[![Latest Version]][crates.io] ![Rustc Version nightly]

[Latest Version]: https://img.shields.io/crates/v/staticvec.svg
[crates.io]: https://crates.io/crates/staticvec
[Rustc Version nightly]: https://img.shields.io/badge/rustc-nightly-lightgray.svg
[![Build Status](https://travis-ci.com/slightlyoutofphase/staticvec.svg?branch=master)](https://travis-ci.com/slightlyoutofphase/staticvec)
[![Build status](https://ci.appveyor.com/api/projects/status/qb40my4v3rr63st2/branch/master?svg=true)](https://ci.appveyor.com/project/slightlyoutofphase/staticvec/branch/master)

Implements a fixed-capacity stack-allocated Vec alternative backed by an array, using const generics.

Note: the word "static" here is meant by the traditional definition of "unchanging" / "not dynamic" etc.

This crate does **not** use literal `static` variables for anything.

Fully `#![no_std]` compatible (with almost no loss of functionality) by setting
`default-features = false` for the `staticvec` dependency in your `Cargo.toml`.

Optional support for serialization and deserialization of the `StaticVec` struct
via `serde` is available by activating the `serde_support` crate feature.

`StaticVec` also implements both `Deref` and `DerefMut` to `[T]`, meaning that all existing slice
methods are accessible through instances of it and that references to it can be used in contexts
where `[T]` is expected.

Contributions/suggestions/etc. very welcome!

**Minimum supported Rust version:** due to the use of const generics, this is a nightly-only crate at the moment.

**General note on the versioning of this crate:** all new releases of `StaticVec`, be they major, minor, or patch, can and
should at all times be assumed to simply be better in some way than the previous version and thus completely safe to upgrade to.
In the not-especially-likely-due-to-the-nature-of-the-crate event of an actual "breaking change", the change in question will
be very explicitly noted and described in this readme.

A basic usage example:

```rust
use staticvec::{staticvec, StaticVec};

fn main() {
  let mut v = StaticVec::<usize, 64>::new();
  for i in 0..v.capacity() {
    v.push(i);
  }
  for i in &v {
    println!("{}", i);
  }
  v.clear();
  v.insert(0, 47);
  v.insert(1, 48);
  v.insert(2, 49);
  v.insert(v.len() - 1, 50);
  v.insert(v.len() - 2, 51);
  v.insert(v.len() - 3, 52);
  for i in &v {
    println!("{}", i);
  }
  for i in &v.reversed().drain(2..4) {
    println!("{}", i);
  }
  while v.is_not_empty() {
    println!("{}", v.remove(0));
  }
  for f in staticvec![12.0, 14.0, 15.0, 16.0].iter().skip(2) {
    println!("{}", f);
  }
  for i in staticvec![
    staticvec![14, 12, 10].sorted(),
    staticvec![20, 18, 16].reversed(),
    staticvec![26, 24, 22].sorted(),
    staticvec![32, 30, 28].reversed(),
  ]
  .iter()
  .flatten()
  .collect::<StaticVec<usize, 12>>()
  .iter() {
    println!("{}", i);
  }
}
```

**License:**

Licensed under either the <a href="LICENSE-MIT">MIT license</a> or version 2.0 of the <a href="LICENSE-APACHE">Apache License</a>. Your choice as to which!
Any source code contributions will be dual-licensed in the same fashion.
