# stack-vec - Ad-hoc stack vectors

This crate defines the macro `stack![]`, which can be used to create ad-hoc `Vec<T>` like structs of a specific compile-time size on the stack.

These structs never allocate on the heap, and expose an API similar to `Vec<T>`.

## Usage
The macro can be used like `vec!`, with optional type inference.

``` rust
let sv = stack![100]; // Implicitly typed. Will cause a type inference error if the compiler cannot find the type of `sv` later.
let sv = stack![usize; 100]; // Explicitly typed, circumvents that error.
```

To see documentation of the types themselves, see one of the pre-defined `StackVec` types in the crate's root.

# Pre-defined types
`StackVec` types of powers of 2 up until 4096 are defined in this crate too.
You can use the macro to create your own named non-opaque `StackVec` types as well.
``` rust
stack!(pub type S10Elements S10IntoIter 10); // A `StackVec` type with a capacity of 10.
```

# License
MIT

