use borsh::{BorshDeserialize, BorshSerialize};
use core::fmt;

#[derive(PartialEq, Eq, PartialOrd, Ord, Clone, Copy, BorshDeserialize, BorshSerialize)]
pub enum StackUsize {
    U2,
    U3,
    U4,
}

impl Default for StackUsize {
    fn default() -> Self {
        StackUsize::U2
    }
}

impl fmt::Debug for StackUsize {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(
            f,
            "{}",
            match self {
                StackUsize::U2 => "StackUsize::U2",
                StackUsize::U3 => "StackUsize::U3",
                StackUsize::U4 => "StackUsize::U4",
            }
        )
    }
}

pub const fn init_storage_stack(bar: &StackUsize) -> usize {
    match bar {
        StackUsize::U2 => 2,
        StackUsize::U3 => 3,
        StackUsize::U4 => 4,
    }
}
