### sqlx 轻量级orm实现

1. 自动转义SQL生成

```rust
    let pool=test_db().await;
    let data=["d‘d","bbb"];
    let sql=sql_format!(
        "select * from yaf_user where id>{id}  {in_grade}",
        id="1'1",
        in_grade=sql_array_str!("and grade in {}",data) //存在data不为空才生成此sql
    );
    println!("{}",sql);
    //会转义‘防止sql注入
```

2. 常用增删改查

使用前准备，结构体增加derive宏
> 使用 sqlx_model::SqlxModel 宏 自动增加辅助方法
> 同时会创建 UserModelRef 的结构，用于辅助增删改查操作

```rust
#[derive(sqlx::FromRow,sqlx_model::SqlxModel,Clone,Debug)]
#[sqlx_model(table_pk="id")]//自定义表主键，不指定默认第一个字段
#[sqlx_model(table_name="users")]//自定义关联表名，不指定为去除Model后的user
pub struct UserModel {
    #[sqlx(default)]
    pub id: u32,
    #[sqlx(default)]
    pub nickname: String,
    #[sqlx(default)]
    pub gender: u8,
    #[sqlx(default)]
    pub headimg: Option<String>,
    #[sqlx(default)]
    pub password_id: u32,
}
```

新增：
> 更多使用方法参考 tests 目录

```rust
    let nike_name="new insert".to_string();
    let gender=1;
    let userinsert=sqlx_model::model_option_set!(UserModelRef,{
        nickname:nike_name,
        gender:gender,
        //不需要全部字段赋值，没赋值生成SQL会少对应字段，等于用表中默认值
    });
    let i1=Insert::<sqlx::MySql,UserModel,_>::new(userinsert).execute(&db).await.unwrap();
    assert!(i1.last_insert_id()>0);
```

删除：
> 更多使用方法参考 tests 目录

```rust
    let select=Select::type_new::<UserModel>();
    let user=select.fetch_one_by_where::<UserModel>(Some(format!("id=1")), &db).await.unwrap();
    let detete=Delete::<sqlx::MySql>::new(UserModel::table_name())
        .execute_by_pk(&user, &db)
        .await.unwrap();
    assert_eq!(detete.rows_affected(),1);
```

修改：
> 更多使用方法参考 tests 目录

```rust
    let nike_name="change to 1".to_string();
    let userchange=sqlx_model::model_option_set!(UserModelRef,{
    nickname:nike_name,
    });
    let update=Update::<sqlx::MySql,UserModel,_>::new(userchange);
    let update=update.execute_by_scalar_pk(1,&db).await.unwrap();
    assert_eq!(update.rows_affected(),1);
```

查询：
> 更多使用方法参考 tests 目录

```rust
    let select=Select::type_new::<UserModel>();
    let user=select.fetch_one_by_scalar_pk::<UserModel,_>(iid, &db).await.unwrap();
    assert_eq!(user.id as u64,iid);
```