mod common;
use crate::common::db_mysql;

#[tokio::test]
async fn test_sql_model_proc_macro(){
    use sqlx_model::SqlQuote;
    use sqlx_model::sql_format;
    use sqlx_model::Select;
    let db=db_mysql().await;
    #[derive(sqlx::FromRow,sqlx_model::SqlxModel,Clone,Debug,Default)]
    struct UserModel {
        id:  u32,
        nickname: String,
        gender: u8,
        headimg: String,
        password_id:u32
    }
    let select=Select::type_new::<UserModel>();
    let sql=sql_format!("id>{id}",id=0);
    let user=select.fetch_one_by_where::<UserModel>(sql, &db).await.unwrap();
    assert!(user.id>0);
    
}

