
mod common;

use crate::common::db_mysql;

#[tokio::test]
async fn curdtest(){
    use sqlx_model::{Delete, Insert, ModelTableName, Select, Update,SqlQuote};
    use sqlx::FromRow;

    let db=db_mysql().await;


    #[derive(FromRow,Clone,Debug)]
    struct UserModel {
        #[sqlx(default)]
        id: u32,
        #[sqlx(default)]
        nickname: String,
        #[sqlx(default)]
        gender: u8,
        #[sqlx(default)]
        headimg: String,
        #[sqlx(default)]
        password_id: u32,
    }

    sqlx_model::model_table_value_bind_define!(UserModel,"user",{id,nickname,gender,headimg,password_id},{id});
    sqlx_model::model_table_ref_define!(UserModel,UserModelRef,{
        id:  u32,
        nickname: String,
        gender: u8,
        headimg: String,
        password_id:u32
    });


    //insert test

    let nike_name="new insert".to_string();
    let gender=1;
    let userinsert=sqlx_model::model_option_var!(UserModelRef,{
        nickname:nike_name,
        gender:gender,
    });
    let i1=Insert::<sqlx::MySql,UserModel,_>::new(userinsert).execute(&db).await.unwrap();
    assert!(i1.last_insert_id()>0);

   


    let nike_name="new vec insert".to_string();
    let gender=1;
    let userinsert=vec![sqlx_model::model_option_var!(UserModelRef,{
        nickname:nike_name,
        gender:gender,
    })];
    let i2=Insert::<sqlx::MySql,UserModel,_>::new_vec(userinsert).execute(&db).await.unwrap();
    assert!(i2.last_insert_id()>0);


    let nickname="model insert".to_string();
    let i3=Insert::<sqlx::MySql,UserModel,_>::model(&UserModel{
        id:i2.last_insert_id() as u32+1,
        nickname:nickname.clone(),
        gender:1,
        headimg:"ddd".to_string(),
        password_id:1,
    }).execute(&db).await.unwrap();
    assert_eq!(i3.rows_affected(),1);

    let vec=vec![
        UserModel{
            id:i3.last_insert_id() as u32+1,
            nickname:"model vec".to_string(),
            gender:1,
            headimg:"ddd".to_string(),
            password_id:1,
        }
    ];
    let i4=Insert::<sqlx::MySql,UserModel,_>::model_vec(&vec).execute(&db).await.unwrap();
    assert_eq!(i4.rows_affected(),1);

    //update

    let nike_name="change 1".to_string();
    let userchange=sqlx_model::model_option_var!(UserModelRef,{
        headimg:nike_name,
    });
    let update=Update::<sqlx::MySql,UserModel,_>::new(userchange);
    let update=update.execute_by_where("id=?",|mut b,_|{
        b=b.bind(i1.last_insert_id());
        b
    },&db).await.unwrap();
    assert_eq!(update.rows_affected(),1);


    let tmp=&UserModel{
        id:1,
        nickname:"model vec".to_string(),
        gender:2,
        headimg:"change 2".to_string(),
        password_id:1,
    };
    let update=Update::model(tmp, None);
    let update=update.execute_by_scalar_pk(i2.last_insert_id(),&db).await.unwrap();
    assert_eq!(update.rows_affected(),1);


    let select=Select::type_new::<UserModel>();
    let user=select.fetch_one_by_where_call::<UserModel,_>("id=?".to_string(),|mut b,_|{
        b=b.bind(i3.last_insert_id());
        b
    }, &db).await.unwrap();

    let nike_name="change 3".to_string();
    let userchange=sqlx_model::model_option_var!(UserModelRef,{
        headimg:nike_name,
    });
    let update=Update::<_,UserModel,_>::new(userchange);
    let update=update.execute_by_pk(&user,&db).await.unwrap();
    assert_eq!(update.rows_affected(),1);

    //select 
    let select=Select::type_new::<UserModel>();
    let user=select.fetch_one_by_scalar_pk::<UserModel,_>(1, &db).await.unwrap();
    assert_eq!(user.nickname,"model vec".to_string());

    let user=select.reload::<UserModel>(&user, &db).await.unwrap();
    assert_eq!(user.nickname,"model vec".to_string());
    

    let (sql,bind_res)=sqlx_model::model_sql_bind!(
        sqlx::MySql,
        r#"nickname=:nickname"#,
        [":nickname"]
    );
    let user=select.fetch_one_by_where_call::<UserModel,_>(sql,|mut b,_|{
        sqlx_model::model_sql_bind_match!(bind_res,{
            ":nickname":{
                b=b.bind(nickname.clone());
            }
        });
        b
    }, &db).await.unwrap();
    assert_eq!(user.nickname,nickname);

    let tuser=select.fetch_one_by_sql_call::<UserModel,_,_>(|select|{
        format!("select {} from {} where id > ?","id",select.table_name)
    },|mut b,_|{
        b=b.bind(0);
        b
    }, &db).await.unwrap();
    assert!(tuser.id>0);
    assert!(tuser.gender==0);

    let tuser=select.fetch_one_scalar_by_sql_call::<String,_,_>(|select|{
        sqlx_model::sql_format!("select nickname from {} where id in (?)",select.table_name)
    },|mut b,_|{
        b=b.bind(1);
        b
    },&db).await.unwrap();
    assert_eq!(tuser,"model vec".to_string());


    //delete
    let detete=Delete::<sqlx::MySql>::new(UserModel::table_name())
        .execute_by_pk(&user, &db)
        .await.unwrap();
    assert_eq!(detete.rows_affected(),1);

    let detete=Delete::<sqlx::MySql>::new(UserModel::table_name())
        .execute_by_scalar_pk::<UserModel,_>(1, &db)
        .await.unwrap();
    assert_eq!(detete.rows_affected(),1);

}