
pub async fn test_db()->sqlx::Pool<sqlx::MySql>{
    use std::str::FromStr;
    let table_prefix = "yaf_".to_string();
    sqlx_model::TableName::set_prefix(table_prefix);
    let database_url = "mysql://root:@127.0.0.1/test";
    let option =sqlx::mysql::MySqlConnectOptions::from_str(&database_url)
        .unwrap();
    sqlx::pool::PoolOptions::<sqlx::MySql>::new()
        .max_connections(5)
        .connect_with(
            option.to_owned()
        )
        .await
        .unwrap()
}
#[tokio::test]
async fn test_build_db(){
    use sqlx_model::SqlQuote;
    let db=test_db().await;
    #[derive(sqlx::FromRow,Clone,Debug,Default)]
    struct UserModel {
        nickname: String,
        gender: u8,
    }
    let nikename="ddd";
    let gender=1;
    let gender_group=vec![1,2];
    let (sql,bind_res)=sqlx_model::model_sql_bind!(
        sqlx::MySql,
        r#"
            select * from (SELECT :nickname as nickname,:gender as gender,1 as gender_group,:nickname as nickname1,:gender as gender1 ) 
            as t where gender in (1) and gender_group in (:gender_group)
        "#,
        [":nickname",":gender",":gender_group"]
    );
    let mut res=sqlx::query_as::<_, UserModel>(sql.as_str());
    sqlx_model::model_sql_bind_match!(bind_res,{
        ":nickname":{
            res=res.bind(&nikename);
        }
        ,
        ":gender":{
            res=res.bind(&gender);
        },
        ":gender_group":{
            res=res.bind(gender_group.sql_quote());
        }
    });
    let res=res.fetch_one(&db).await.unwrap();
    assert_eq!(res.nickname,nikename.to_string());
    assert_eq!(res.gender,gender);
}

