
use sqlx_model::{Select, TableName};
pub async fn test_db()->sqlx::Pool<sqlx::MySql>{
    use std::str::FromStr;
    let table_prefix = "yaf_".to_string();
    TableName::set_prefix(table_prefix);
    let database_url = "mysql://root:@127.0.0.1/test";
    let option =sqlx::mysql::MySqlConnectOptions::from_str(&database_url)
        .unwrap();
    sqlx::pool::PoolOptions::<sqlx::MySql>::new()
        .max_connections(5)
        .connect_with(
            option.to_owned()
        )
        .await
        .unwrap()
}


#[derive(sqlx::FromRow,sqlx_model::SqlxModel,Clone,Debug)]
pub struct UserModel {
    pub id: u32,
    pub nickname: Option<String>,
    pub gender: Option<u8>,
    pub headimg: Option<String>,
    pub password_id: Option<u32>,
}


#[tokio::test]
async fn sqx_model_mysql_test()  {
     let pool=test_db().await;
     let _user=UserModel{
        id:1,
        nickname: Some("11".to_string()),
        gender: None,
        headimg: None,
        password_id: None,
    };
    let select=Select::type_new::<UserModel>();
    let b= select.fetch_one_by_where::<UserModel,_>("id>1", |e,_|{
        e
    }, &pool).await.unwrap();
 }