#![allow(dead_code, mutable_transmutes, non_camel_case_types, non_snake_case,
         non_upper_case_globals, unused_assignments, unused_mut)]
#![register_tool(c2rust)]
#![feature(c_variadic, const_raw_ptr_to_usize_cast, const_transmute,
           core_intrinsics, extern_types, label_break_value,
           ptr_wrapping_offset_from, register_tool)]

#[macro_use]
extern crate c2rust_bitfields;

use num_traits::ToPrimitive;

extern "C" {
    pub type sqlite3_pcache;
    pub type sqlite3_stmt;
    pub type sqlite3_blob;
    pub type CCurHint;
    #[no_mangle]
    fn malloc(_: libc::c_ulong) -> *mut libc::c_void;
    #[no_mangle]
    fn realloc(_: *mut libc::c_void, _: libc::c_ulong) -> *mut libc::c_void;
    #[no_mangle]
    fn free(__ptr: *mut libc::c_void);
    #[no_mangle]
    fn getenv(__name: *const libc::c_char) -> *mut libc::c_char;
    #[no_mangle]
    fn memcpy(_: *mut libc::c_void, _: *const libc::c_void, _: libc::c_ulong)
     -> *mut libc::c_void;
    #[no_mangle]
    fn memmove(_: *mut libc::c_void, _: *const libc::c_void, _: libc::c_ulong)
     -> *mut libc::c_void;
    #[no_mangle]
    fn memset(_: *mut libc::c_void, _: libc::c_int, _: libc::c_ulong)
     -> *mut libc::c_void;
    #[no_mangle]
    fn memcmp(_: *const libc::c_void, _: *const libc::c_void,
              _: libc::c_ulong) -> libc::c_int;
    #[no_mangle]
    fn strcmp(_: *const libc::c_char, _: *const libc::c_char) -> libc::c_int;
    #[no_mangle]
    fn strncmp(_: *const libc::c_char, _: *const libc::c_char,
               _: libc::c_ulong) -> libc::c_int;
    #[no_mangle]
    fn strrchr(_: *const libc::c_char, _: libc::c_int) -> *mut libc::c_char;
    #[no_mangle]
    fn strcspn(_: *const libc::c_char, _: *const libc::c_char)
     -> libc::c_ulong;
    #[no_mangle]
    fn strlen(_: *const libc::c_char) -> libc::c_ulong;
    #[no_mangle]
    fn time(__timer: *mut time_t) -> time_t;
    #[no_mangle]
    fn localtime(__timer: *const time_t) -> *mut tm;
    #[no_mangle]
    fn pthread_create(__newthread: *mut pthread_t,
                      __attr: *const pthread_attr_t,
                      __start_routine:
                          Option<unsafe extern "C" fn(_: *mut libc::c_void)
                                     -> *mut libc::c_void>,
                      __arg: *mut libc::c_void) -> libc::c_int;
    #[no_mangle]
    fn pthread_join(__th: pthread_t, __thread_return: *mut *mut libc::c_void)
     -> libc::c_int;
    #[no_mangle]
    fn pthread_mutex_init(__mutex: *mut pthread_mutex_t,
                          __mutexattr: *const pthread_mutexattr_t)
     -> libc::c_int;
    #[no_mangle]
    fn pthread_mutex_destroy(__mutex: *mut pthread_mutex_t) -> libc::c_int;
    #[no_mangle]
    fn pthread_mutex_trylock(__mutex: *mut pthread_mutex_t) -> libc::c_int;
    #[no_mangle]
    fn pthread_mutex_lock(__mutex: *mut pthread_mutex_t) -> libc::c_int;
    #[no_mangle]
    fn pthread_mutex_unlock(__mutex: *mut pthread_mutex_t) -> libc::c_int;
    #[no_mangle]
    fn pthread_mutexattr_init(__attr: *mut pthread_mutexattr_t)
     -> libc::c_int;
    #[no_mangle]
    fn pthread_mutexattr_destroy(__attr: *mut pthread_mutexattr_t)
     -> libc::c_int;
    #[no_mangle]
    fn pthread_mutexattr_settype(__attr: *mut pthread_mutexattr_t,
                                 __kind: libc::c_int) -> libc::c_int;
    #[no_mangle]
    fn stat(__file: *const libc::c_char, __buf: *mut stat) -> libc::c_int;
    #[no_mangle]
    fn fstat(__fd: libc::c_int, __buf: *mut stat) -> libc::c_int;
    #[no_mangle]
    fn lstat(__file: *const libc::c_char, __buf: *mut stat) -> libc::c_int;
    #[no_mangle]
    fn fchmod(__fd: libc::c_int, __mode: __mode_t) -> libc::c_int;
    #[no_mangle]
    fn mkdir(__path: *const libc::c_char, __mode: __mode_t) -> libc::c_int;
    #[no_mangle]
    fn fcntl(__fd: libc::c_int, __cmd: libc::c_int, _: ...) -> libc::c_int;
    #[no_mangle]
    fn open(__file: *const libc::c_char, __oflag: libc::c_int, _: ...)
     -> libc::c_int;
    #[no_mangle]
    fn access(__name: *const libc::c_char, __type: libc::c_int)
     -> libc::c_int;
    #[no_mangle]
    fn lseek(__fd: libc::c_int, __offset: __off64_t, __whence: libc::c_int)
     -> __off64_t;
    #[no_mangle]
    fn close(__fd: libc::c_int) -> libc::c_int;
    #[no_mangle]
    fn read(__fd: libc::c_int, __buf: *mut libc::c_void, __nbytes: size_t)
     -> ssize_t;
    #[no_mangle]
    fn write(__fd: libc::c_int, __buf: *const libc::c_void, __n: size_t)
     -> ssize_t;
    #[no_mangle]
    fn sleep(__seconds: libc::c_uint) -> libc::c_uint;
    #[no_mangle]
    fn fchown(__fd: libc::c_int, __owner: __uid_t, __group: __gid_t)
     -> libc::c_int;
    #[no_mangle]
    fn getcwd(__buf: *mut libc::c_char, __size: size_t) -> *mut libc::c_char;
    #[no_mangle]
    fn getpid() -> __pid_t;
    #[no_mangle]
    fn geteuid() -> __uid_t;
    #[no_mangle]
    fn readlink(__path: *const libc::c_char, __buf: *mut libc::c_char,
                __len: size_t) -> ssize_t;
    #[no_mangle]
    fn unlink(__name: *const libc::c_char) -> libc::c_int;
    #[no_mangle]
    fn rmdir(__path: *const libc::c_char) -> libc::c_int;
    #[no_mangle]
    fn fsync(__fd: libc::c_int) -> libc::c_int;
    #[no_mangle]
    fn getpagesize() -> libc::c_int;
    #[no_mangle]
    fn ftruncate(__fd: libc::c_int, __length: __off64_t) -> libc::c_int;
    #[no_mangle]
    fn gettimeofday(__tv: *mut timeval, __tz: __timezone_ptr_t)
     -> libc::c_int;
    #[no_mangle]
    fn utimes(__file: *const libc::c_char, __tvp: *const timeval)
     -> libc::c_int;
    #[no_mangle]
    fn __errno_location() -> *mut libc::c_int;
    #[no_mangle]
    fn mmap(__addr: *mut libc::c_void, __len: size_t, __prot: libc::c_int,
            __flags: libc::c_int, __fd: libc::c_int, __offset: __off64_t)
     -> *mut libc::c_void;
    #[no_mangle]
    fn munmap(__addr: *mut libc::c_void, __len: size_t) -> libc::c_int;
    #[no_mangle]
    fn mremap(__addr: *mut libc::c_void, __old_len: size_t, __new_len: size_t,
              __flags: libc::c_int, _: ...) -> *mut libc::c_void;
    #[no_mangle]
    fn dlopen(__file: *const libc::c_char, __mode: libc::c_int)
     -> *mut libc::c_void;
    #[no_mangle]
    fn dlclose(__handle: *mut libc::c_void) -> libc::c_int;
    #[no_mangle]
    fn dlsym(__handle: *mut libc::c_void, __name: *const libc::c_char)
     -> *mut libc::c_void;
    #[no_mangle]
    fn dlerror() -> *mut libc::c_char;
}
pub type __builtin_va_list = [__va_list_tag; 1];
#[derive(Copy, Clone)]
#[repr(C)]
pub struct __va_list_tag {
    pub gp_offset: libc::c_uint,
    pub fp_offset: libc::c_uint,
    pub overflow_arg_area: *mut libc::c_void,
    pub reg_save_area: *mut libc::c_void,
}
pub type __gnuc_va_list = __builtin_va_list;
pub type va_list = __gnuc_va_list;
pub type u8_0 = libc::c_uchar;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3 {
    pub pVfs: *mut sqlite3_vfs,
    pub pVdbe: *mut Vdbe,
    pub pDfltColl: *mut CollSeq,
    pub mutex: *mut sqlite3_mutex,
    pub aDb: *mut Db,
    pub nDb: libc::c_int,
    pub mDbFlags: u32_0,
    pub flags: u64_0,
    pub lastRowid: i64_0,
    pub szMmap: i64_0,
    pub nSchemaLock: u32_0,
    pub openFlags: libc::c_uint,
    pub errCode: libc::c_int,
    pub errMask: libc::c_int,
    pub iSysErrno: libc::c_int,
    pub dbOptFlags: u16_0,
    pub enc: u8_0,
    pub autoCommit: u8_0,
    pub temp_store: u8_0,
    pub mallocFailed: u8_0,
    pub bBenignMalloc: u8_0,
    pub dfltLockMode: u8_0,
    pub nextAutovac: libc::c_schar,
    pub suppressErr: u8_0,
    pub vtabOnConflict: u8_0,
    pub isTransactionSavepoint: u8_0,
    pub mTrace: u8_0,
    pub noSharedCache: u8_0,
    pub nSqlExec: u8_0,
    pub nextPagesize: libc::c_int,
    pub magic: u32_0,
    pub nChange: libc::c_int,
    pub nTotalChange: libc::c_int,
    pub aLimit: [libc::c_int; 12],
    pub nMaxSorterMmap: libc::c_int,
    pub init: sqlite3InitInfo,
    pub nVdbeActive: libc::c_int,
    pub nVdbeRead: libc::c_int,
    pub nVdbeWrite: libc::c_int,
    pub nVdbeExec: libc::c_int,
    pub nVDestroy: libc::c_int,
    pub nExtension: libc::c_int,
    pub aExtension: *mut *mut libc::c_void,
    pub xTrace: Option<unsafe extern "C" fn(_: u32_0, _: *mut libc::c_void,
                                            _: *mut libc::c_void,
                                            _: *mut libc::c_void)
                           -> libc::c_int>,
    pub pTraceArg: *mut libc::c_void,
    pub xProfile: Option<unsafe extern "C" fn(_: *mut libc::c_void,
                                              _: *const libc::c_char,
                                              _: u64_0) -> ()>,
    pub pProfileArg: *mut libc::c_void,
    pub pCommitArg: *mut libc::c_void,
    pub xCommitCallback: Option<unsafe extern "C" fn(_: *mut libc::c_void)
                                    -> libc::c_int>,
    pub pRollbackArg: *mut libc::c_void,
    pub xRollbackCallback: Option<unsafe extern "C" fn(_: *mut libc::c_void)
                                      -> ()>,
    pub pUpdateArg: *mut libc::c_void,
    pub xUpdateCallback: Option<unsafe extern "C" fn(_: *mut libc::c_void,
                                                     _: libc::c_int,
                                                     _: *const libc::c_char,
                                                     _: *const libc::c_char,
                                                     _: sqlite_int64) -> ()>,
    pub pParse: *mut Parse,
    pub xWalCallback: Option<unsafe extern "C" fn(_: *mut libc::c_void,
                                                  _: *mut sqlite3,
                                                  _: *const libc::c_char,
                                                  _: libc::c_int)
                                 -> libc::c_int>,
    pub pWalArg: *mut libc::c_void,
    pub xCollNeeded: Option<unsafe extern "C" fn(_: *mut libc::c_void,
                                                 _: *mut sqlite3,
                                                 _: libc::c_int,
                                                 _: *const libc::c_char)
                                -> ()>,
    pub xCollNeeded16: Option<unsafe extern "C" fn(_: *mut libc::c_void,
                                                   _: *mut sqlite3,
                                                   _: libc::c_int,
                                                   _: *const libc::c_void)
                                  -> ()>,
    pub pCollNeededArg: *mut libc::c_void,
    pub pErr: *mut sqlite3_value,
    pub u1: C2RustUnnamed_11,
    pub lookaside: Lookaside,
    pub xAuth: sqlite3_xauth,
    pub pAuthArg: *mut libc::c_void,
    pub xProgress: Option<unsafe extern "C" fn(_: *mut libc::c_void)
                              -> libc::c_int>,
    pub pProgressArg: *mut libc::c_void,
    pub nProgressOps: libc::c_uint,
    pub nVTrans: libc::c_int,
    pub aModule: Hash,
    pub pVtabCtx: *mut VtabCtx,
    pub aVTrans: *mut *mut VTable,
    pub pDisconnect: *mut VTable,
    pub aFunc: Hash,
    pub aCollSeq: Hash,
    pub busyHandler: BusyHandler,
    pub aDbStatic: [Db; 2],
    pub pSavepoint: *mut Savepoint,
    pub nAnalysisLimit: libc::c_int,
    pub busyTimeout: libc::c_int,
    pub nSavepoint: libc::c_int,
    pub nStatement: libc::c_int,
    pub nDeferredCons: i64_0,
    pub nDeferredImmCons: i64_0,
    pub pnBytesFreed: *mut libc::c_int,
}
pub type i64_0 = sqlite_int64;
pub type sqlite_int64 = libc::c_longlong;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Savepoint {
    pub zName: *mut libc::c_char,
    pub nDeferredCons: i64_0,
    pub nDeferredImmCons: i64_0,
    pub pNext: *mut Savepoint,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Db {
    pub zDbSName: *mut libc::c_char,
    pub pBt: *mut Btree,
    pub safety_level: u8_0,
    pub bSyncSet: u8_0,
    pub pSchema: *mut Schema,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Schema {
    pub schema_cookie: libc::c_int,
    pub iGeneration: libc::c_int,
    pub tblHash: Hash,
    pub idxHash: Hash,
    pub trigHash: Hash,
    pub fkeyHash: Hash,
    pub pSeqTab: *mut Table,
    pub file_format: u8_0,
    pub enc: u8_0,
    pub schemaFlags: u16_0,
    pub cache_size: libc::c_int,
}
pub type u16_0 = libc::c_ushort;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Table {
    pub zName: *mut libc::c_char,
    pub aCol: *mut Column,
    pub pIndex: *mut Index,
    pub pSelect: *mut Select,
    pub pFKey: *mut FKey,
    pub zColAff: *mut libc::c_char,
    pub pCheck: *mut ExprList,
    pub tnum: libc::c_int,
    pub nTabRef: u32_0,
    pub tabFlags: u32_0,
    pub iPKey: i16_0,
    pub nCol: i16_0,
    pub nNVCol: i16_0,
    pub nRowLogEst: LogEst,
    pub szTabRow: LogEst,
    pub keyConf: u8_0,
    pub addColOffset: libc::c_int,
    pub nModuleArg: libc::c_int,
    pub azModuleArg: *mut *mut libc::c_char,
    pub pVTable: *mut VTable,
    pub pTrigger: *mut Trigger,
    pub pSchema: *mut Schema,
    pub pNextZombie: *mut Table,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Trigger {
    pub zName: *mut libc::c_char,
    pub table: *mut libc::c_char,
    pub op: u8_0,
    pub tr_tm: u8_0,
    pub pWhen: *mut Expr,
    pub pColumns: *mut IdList,
    pub pSchema: *mut Schema,
    pub pTabSchema: *mut Schema,
    pub step_list: *mut TriggerStep,
    pub pNext: *mut Trigger,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TriggerStep {
    pub op: u8_0,
    pub orconf: u8_0,
    pub pTrig: *mut Trigger,
    pub pSelect: *mut Select,
    pub zTarget: *mut libc::c_char,
    pub pWhere: *mut Expr,
    pub pExprList: *mut ExprList,
    pub pIdList: *mut IdList,
    pub pUpsert: *mut Upsert,
    pub zSpan: *mut libc::c_char,
    pub pNext: *mut TriggerStep,
    pub pLast: *mut TriggerStep,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Upsert {
    pub pUpsertTarget: *mut ExprList,
    pub pUpsertTargetWhere: *mut Expr,
    pub pUpsertSet: *mut ExprList,
    pub pUpsertWhere: *mut Expr,
    pub pUpsertIdx: *mut Index,
    pub pUpsertSrc: *mut SrcList,
    pub regData: libc::c_int,
    pub iDataCur: libc::c_int,
    pub iIdxCur: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SrcList {
    pub nSrc: libc::c_int,
    pub nAlloc: u32_0,
    pub a: [SrcList_item; 1],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SrcList_item {
    pub pSchema: *mut Schema,
    pub zDatabase: *mut libc::c_char,
    pub zName: *mut libc::c_char,
    pub zAlias: *mut libc::c_char,
    pub pTab: *mut Table,
    pub pSelect: *mut Select,
    pub addrFillSub: libc::c_int,
    pub regReturn: libc::c_int,
    pub regResult: libc::c_int,
    pub fg: C2RustUnnamed_10,
    pub iCursor: libc::c_int,
    pub pOn: *mut Expr,
    pub pUsing: *mut IdList,
    pub colUsed: Bitmask,
    pub u1: C2RustUnnamed_9,
    pub pIBIndex: *mut Index,
}
#[derive(Copy, Clone, BitfieldStruct)]
#[repr(C)]
pub struct Index {
    pub zName: *mut libc::c_char,
    pub aiColumn: *mut i16_0,
    pub aiRowLogEst: *mut LogEst,
    pub pTable: *mut Table,
    pub zColAff: *mut libc::c_char,
    pub pNext: *mut Index,
    pub pSchema: *mut Schema,
    pub aSortOrder: *mut u8_0,
    pub azColl: *mut *const libc::c_char,
    pub pPartIdxWhere: *mut Expr,
    pub aColExpr: *mut ExprList,
    pub tnum: libc::c_int,
    pub szIdxRow: LogEst,
    pub nKeyCol: u16_0,
    pub nColumn: u16_0,
    pub onError: u8_0,
    #[bitfield(name = "idxType", ty = "libc::c_uint", bits = "0..=1")]
    #[bitfield(name = "bUnordered", ty = "libc::c_uint", bits = "2..=2")]
    #[bitfield(name = "uniqNotNull", ty = "libc::c_uint", bits = "3..=3")]
    #[bitfield(name = "isResized", ty = "libc::c_uint", bits = "4..=4")]
    #[bitfield(name = "isCovering", ty = "libc::c_uint", bits = "5..=5")]
    #[bitfield(name = "noSkipScan", ty = "libc::c_uint", bits = "6..=6")]
    #[bitfield(name = "hasStat1", ty = "libc::c_uint", bits = "7..=7")]
    #[bitfield(name = "bNoQuery", ty = "libc::c_uint", bits = "8..=8")]
    #[bitfield(name = "bAscKeyBug", ty = "libc::c_uint", bits = "9..=9")]
    #[bitfield(name = "bHasVCol", ty = "libc::c_uint", bits = "10..=10")]
    pub idxType_bUnordered_uniqNotNull_isResized_isCovering_noSkipScan_hasStat1_bNoQuery_bAscKeyBug_bHasVCol: [u8; 2],
    #[bitfield(padding)]
    pub c2rust_padding: [u8; 3],
    pub colNotIdxed: Bitmask,
}
pub type Bitmask = u64_0;
pub type u64_0 = sqlite_uint64;
pub type sqlite_uint64 = libc::c_ulonglong;
pub type LogEst = libc::c_short;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ExprList {
    pub nExpr: libc::c_int,
    pub a: [ExprList_item; 1],
}
#[derive(Copy, Clone, BitfieldStruct)]
#[repr(C)]
pub struct ExprList_item {
    pub pExpr: *mut Expr,
    pub zEName: *mut libc::c_char,
    pub sortFlags: u8_0,
    #[bitfield(name = "eEName", ty = "libc::c_uint", bits = "0..=1")]
    #[bitfield(name = "done", ty = "libc::c_uint", bits = "2..=2")]
    #[bitfield(name = "reusable", ty = "libc::c_uint", bits = "3..=3")]
    #[bitfield(name = "bSorterRef", ty = "libc::c_uint", bits = "4..=4")]
    #[bitfield(name = "bNulls", ty = "libc::c_uint", bits = "5..=5")]
    pub eEName_done_reusable_bSorterRef_bNulls: [u8; 1],
    #[bitfield(padding)]
    pub c2rust_padding: [u8; 2],
    pub u: C2RustUnnamed,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed {
    pub x: C2RustUnnamed_0,
    pub iConstExprReg: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_0 {
    pub iOrderByCol: u16_0,
    pub iAlias: u16_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Expr {
    pub op: u8_0,
    pub affExpr: libc::c_char,
    pub op2: u8_0,
    pub flags: u32_0,
    pub u: C2RustUnnamed_8,
    pub pLeft: *mut Expr,
    pub pRight: *mut Expr,
    pub x: C2RustUnnamed_7,
    pub nHeight: libc::c_int,
    pub iTable: libc::c_int,
    pub iColumn: ynVar,
    pub iAgg: i16_0,
    pub iRightJoinTable: i16_0,
    pub pAggInfo: *mut AggInfo,
    pub y: C2RustUnnamed_1,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_1 {
    pub pTab: *mut Table,
    pub pWin: *mut Window,
    pub sub: C2RustUnnamed_2,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_2 {
    pub iAddr: libc::c_int,
    pub regReturn: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Window {
    pub zName: *mut libc::c_char,
    pub zBase: *mut libc::c_char,
    pub pPartition: *mut ExprList,
    pub pOrderBy: *mut ExprList,
    pub eFrmType: u8_0,
    pub eStart: u8_0,
    pub eEnd: u8_0,
    pub bImplicitFrame: u8_0,
    pub eExclude: u8_0,
    pub pStart: *mut Expr,
    pub pEnd: *mut Expr,
    pub ppThis: *mut *mut Window,
    pub pNextWin: *mut Window,
    pub pFilter: *mut Expr,
    pub pFunc: *mut FuncDef,
    pub iEphCsr: libc::c_int,
    pub regAccum: libc::c_int,
    pub regResult: libc::c_int,
    pub csrApp: libc::c_int,
    pub regApp: libc::c_int,
    pub regPart: libc::c_int,
    pub pOwner: *mut Expr,
    pub nBufferCol: libc::c_int,
    pub iArgCol: libc::c_int,
    pub regOne: libc::c_int,
    pub regStartRowid: libc::c_int,
    pub regEndRowid: libc::c_int,
    pub bExprArgs: u8_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct FuncDef {
    pub nArg: i8_0,
    pub funcFlags: u32_0,
    pub pUserData: *mut libc::c_void,
    pub pNext: *mut FuncDef,
    pub xSFunc: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                            _: libc::c_int,
                                            _: *mut *mut sqlite3_value)
                           -> ()>,
    pub xFinalize: Option<unsafe extern "C" fn(_: *mut sqlite3_context)
                              -> ()>,
    pub xValue: Option<unsafe extern "C" fn(_: *mut sqlite3_context) -> ()>,
    pub xInverse: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                              _: libc::c_int,
                                              _: *mut *mut sqlite3_value)
                             -> ()>,
    pub zName: *const libc::c_char,
    pub u: C2RustUnnamed_3,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_3 {
    pub pHash: *mut FuncDef,
    pub pDestructor: *mut FuncDestructor,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct FuncDestructor {
    pub nRef: libc::c_int,
    pub xDestroy: Option<unsafe extern "C" fn(_: *mut libc::c_void) -> ()>,
    pub pUserData: *mut libc::c_void,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_value {
    pub u: MemValue,
    pub flags: u16_0,
    pub enc: u8_0,
    pub eSubtype: u8_0,
    pub n: libc::c_int,
    pub z: *mut libc::c_char,
    pub zMalloc: *mut libc::c_char,
    pub szMalloc: libc::c_int,
    pub uTemp: u32_0,
    pub db: *mut sqlite3,
    pub xDel: Option<unsafe extern "C" fn(_: *mut libc::c_void) -> ()>,
}
pub type u32_0 = libc::c_uint;
#[derive(Copy, Clone)]
#[repr(C)]
pub union MemValue {
    pub r: libc::c_double,
    pub i: i64_0,
    pub nZero: libc::c_int,
    pub zPType: *const libc::c_char,
    pub pDef: *mut FuncDef,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_context {
    pub pOut: *mut Mem,
    pub pFunc: *mut FuncDef,
    pub pMem: *mut Mem,
    pub pVdbe: *mut Vdbe,
    pub iOp: libc::c_int,
    pub isError: libc::c_int,
    pub skipFlag: u8_0,
    pub argc: u8_0,
    pub argv: [*mut sqlite3_value; 1],
}
#[derive(Copy, Clone, BitfieldStruct)]
#[repr(C)]
pub struct Vdbe {
    pub db: *mut sqlite3,
    pub pPrev: *mut Vdbe,
    pub pNext: *mut Vdbe,
    pub pParse: *mut Parse,
    pub nVar: ynVar,
    pub magic: u32_0,
    pub nMem: libc::c_int,
    pub nCursor: libc::c_int,
    pub cacheCtr: u32_0,
    pub pc: libc::c_int,
    pub rc: libc::c_int,
    pub nChange: libc::c_int,
    pub iStatement: libc::c_int,
    pub iCurrentTime: i64_0,
    pub nFkConstraint: i64_0,
    pub nStmtDefCons: i64_0,
    pub nStmtDefImmCons: i64_0,
    pub aMem: *mut Mem,
    pub apArg: *mut *mut Mem,
    pub apCsr: *mut *mut VdbeCursor,
    pub aVar: *mut Mem,
    pub aOp: *mut Op,
    pub nOp: libc::c_int,
    pub nOpAlloc: libc::c_int,
    pub aColName: *mut Mem,
    pub pResultSet: *mut Mem,
    pub zErrMsg: *mut libc::c_char,
    pub pVList: *mut VList,
    pub startTime: i64_0,
    pub nResColumn: u16_0,
    pub errorAction: u8_0,
    pub minWriteFileFormat: u8_0,
    pub prepFlags: u8_0,
    pub doingRerun: u8_0,
    #[bitfield(name = "expired", ty = "bft", bits = "0..=1")]
    #[bitfield(name = "explain", ty = "bft", bits = "2..=3")]
    #[bitfield(name = "changeCntOn", ty = "bft", bits = "4..=4")]
    #[bitfield(name = "runOnlyOnce", ty = "bft", bits = "5..=5")]
    #[bitfield(name = "usesStmtJournal", ty = "bft", bits = "6..=6")]
    #[bitfield(name = "readOnly", ty = "bft", bits = "7..=7")]
    #[bitfield(name = "bIsReader", ty = "bft", bits = "8..=8")]
    pub expired_explain_changeCntOn_runOnlyOnce_usesStmtJournal_readOnly_bIsReader: [u8; 2],
    pub btreeMask: yDbMask,
    pub lockMask: yDbMask,
    pub aCounter: [u32_0; 7],
    pub zSql: *mut libc::c_char,
    pub pFree: *mut libc::c_void,
    pub pFrame: *mut VdbeFrame,
    pub pDelFrame: *mut VdbeFrame,
    pub nFrame: libc::c_int,
    pub expmask: u32_0,
    pub pProgram: *mut SubProgram,
    pub pAuxData: *mut AuxData,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AuxData {
    pub iAuxOp: libc::c_int,
    pub iAuxArg: libc::c_int,
    pub pAux: *mut libc::c_void,
    pub xDeleteAux: Option<unsafe extern "C" fn(_: *mut libc::c_void) -> ()>,
    pub pNextAux: *mut AuxData,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SubProgram {
    pub aOp: *mut VdbeOp,
    pub nOp: libc::c_int,
    pub nMem: libc::c_int,
    pub nCsr: libc::c_int,
    pub aOnce: *mut u8_0,
    pub token: *mut libc::c_void,
    pub pNext: *mut SubProgram,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct VdbeOp {
    pub opcode: u8_0,
    pub p4type: libc::c_schar,
    pub p5: u16_0,
    pub p1: libc::c_int,
    pub p2: libc::c_int,
    pub p3: libc::c_int,
    pub p4: p4union,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union p4union {
    pub i: libc::c_int,
    pub p: *mut libc::c_void,
    pub z: *mut libc::c_char,
    pub pI64: *mut i64_0,
    pub pReal: *mut libc::c_double,
    pub pFunc: *mut FuncDef,
    pub pCtx: *mut sqlite3_context,
    pub pColl: *mut CollSeq,
    pub pMem: *mut Mem,
    pub pVtab: *mut VTable,
    pub pKeyInfo: *mut KeyInfo,
    pub ai: *mut libc::c_int,
    pub pProgram: *mut SubProgram,
    pub pTab: *mut Table,
    pub xAdvance: Option<unsafe extern "C" fn(_: *mut BtCursor,
                                              _: libc::c_int) -> libc::c_int>,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct BtCursor {
    pub eState: u8_0,
    pub curFlags: u8_0,
    pub curPagerFlags: u8_0,
    pub hints: u8_0,
    pub skipNext: libc::c_int,
    pub pBtree: *mut Btree,
    pub aOverflow: *mut Pgno,
    pub pKey: *mut libc::c_void,
    pub pBt: *mut BtShared,
    pub pNext: *mut BtCursor,
    pub info: CellInfo,
    pub nKey: i64_0,
    pub pgnoRoot: Pgno,
    pub iPage: i8_0,
    pub curIntKey: u8_0,
    pub ix: u16_0,
    pub aiIdx: [u16_0; 19],
    pub pKeyInfo: *mut KeyInfo,
    pub pPage: *mut MemPage,
    pub apPage: [*mut MemPage; 19],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MemPage {
    pub isInit: u8_0,
    pub bBusy: u8_0,
    pub intKey: u8_0,
    pub intKeyLeaf: u8_0,
    pub pgno: Pgno,
    pub leaf: u8_0,
    pub hdrOffset: u8_0,
    pub childPtrSize: u8_0,
    pub max1bytePayload: u8_0,
    pub nOverflow: u8_0,
    pub maxLocal: u16_0,
    pub minLocal: u16_0,
    pub cellOffset: u16_0,
    pub nFree: libc::c_int,
    pub nCell: u16_0,
    pub maskPage: u16_0,
    pub aiOvfl: [u16_0; 4],
    pub apOvfl: [*mut u8_0; 4],
    pub pBt: *mut BtShared,
    pub aData: *mut u8_0,
    pub aDataEnd: *mut u8_0,
    pub aCellIdx: *mut u8_0,
    pub aDataOfst: *mut u8_0,
    pub pDbPage: *mut DbPage,
    pub xCellSize: Option<unsafe extern "C" fn(_: *mut MemPage, _: *mut u8_0)
                              -> u16_0>,
    pub xParseCell: Option<unsafe extern "C" fn(_: *mut MemPage, _: *mut u8_0,
                                                _: *mut CellInfo) -> ()>,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CellInfo {
    pub nKey: i64_0,
    pub pPayload: *mut u8_0,
    pub nPayload: u32_0,
    pub nLocal: u16_0,
    pub nSize: u16_0,
}
pub type DbPage = PgHdr;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PgHdr {
    pub pPage: *mut sqlite3_pcache_page,
    pub pData: *mut libc::c_void,
    pub pExtra: *mut libc::c_void,
    pub pCache: *mut PCache,
    pub pDirty: *mut PgHdr,
    pub pPager: *mut Pager,
    pub pgno: Pgno,
    pub flags: u16_0,
    pub nRef: i16_0,
    pub pDirtyNext: *mut PgHdr,
    pub pDirtyPrev: *mut PgHdr,
}
pub type i16_0 = libc::c_short;
pub type Pgno = u32_0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Pager {
    pub pVfs: *mut sqlite3_vfs,
    pub exclusiveMode: u8_0,
    pub journalMode: u8_0,
    pub useJournal: u8_0,
    pub noSync: u8_0,
    pub fullSync: u8_0,
    pub extraSync: u8_0,
    pub syncFlags: u8_0,
    pub walSyncFlags: u8_0,
    pub tempFile: u8_0,
    pub noLock: u8_0,
    pub readOnly: u8_0,
    pub memDb: u8_0,
    pub eState: u8_0,
    pub eLock: u8_0,
    pub changeCountDone: u8_0,
    pub setMaster: u8_0,
    pub doNotSpill: u8_0,
    pub subjInMemory: u8_0,
    pub bUseFetch: u8_0,
    pub hasHeldSharedLock: u8_0,
    pub dbSize: Pgno,
    pub dbOrigSize: Pgno,
    pub dbFileSize: Pgno,
    pub dbHintSize: Pgno,
    pub errCode: libc::c_int,
    pub nRec: libc::c_int,
    pub cksumInit: u32_0,
    pub nSubRec: u32_0,
    pub pInJournal: *mut Bitvec,
    pub fd: *mut sqlite3_file,
    pub jfd: *mut sqlite3_file,
    pub sjfd: *mut sqlite3_file,
    pub journalOff: i64_0,
    pub journalHdr: i64_0,
    pub pBackup: *mut sqlite3_backup,
    pub aSavepoint: *mut PagerSavepoint,
    pub nSavepoint: libc::c_int,
    pub iDataVersion: u32_0,
    pub dbFileVers: [libc::c_char; 16],
    pub nMmapOut: libc::c_int,
    pub szMmap: sqlite3_int64,
    pub pMmapFreelist: *mut PgHdr,
    pub nExtra: u16_0,
    pub nReserve: i16_0,
    pub vfsFlags: u32_0,
    pub sectorSize: u32_0,
    pub pageSize: libc::c_int,
    pub mxPgno: Pgno,
    pub journalSizeLimit: i64_0,
    pub zFilename: *mut libc::c_char,
    pub zJournal: *mut libc::c_char,
    pub xBusyHandler: Option<unsafe extern "C" fn(_: *mut libc::c_void)
                                 -> libc::c_int>,
    pub pBusyHandlerArg: *mut libc::c_void,
    pub aStat: [libc::c_int; 4],
    pub xReiniter: Option<unsafe extern "C" fn(_: *mut DbPage) -> ()>,
    pub xGet: Option<unsafe extern "C" fn(_: *mut Pager, _: Pgno,
                                          _: *mut *mut DbPage, _: libc::c_int)
                         -> libc::c_int>,
    pub pTmpSpace: *mut libc::c_char,
    pub pPCache: *mut PCache,
    pub pWal: *mut Wal,
    pub zWal: *mut libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Wal {
    pub pVfs: *mut sqlite3_vfs,
    pub pDbFd: *mut sqlite3_file,
    pub pWalFd: *mut sqlite3_file,
    pub iCallback: u32_0,
    pub mxWalSize: i64_0,
    pub nWiData: libc::c_int,
    pub szFirstBlock: libc::c_int,
    pub apWiData: *mut *mut u32_0,
    pub szPage: u32_0,
    pub readLock: i16_0,
    pub syncFlags: u8_0,
    pub exclusiveMode: u8_0,
    pub writeLock: u8_0,
    pub ckptLock: u8_0,
    pub readOnly: u8_0,
    pub truncateOnCommit: u8_0,
    pub syncHeader: u8_0,
    pub padToSectorBoundary: u8_0,
    pub bShmUnreliable: u8_0,
    pub hdr: WalIndexHdr,
    pub minFrame: u32_0,
    pub iReCksum: u32_0,
    pub zWalName: *const libc::c_char,
    pub nCkpt: u32_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WalIndexHdr {
    pub iVersion: u32_0,
    pub unused: u32_0,
    pub iChange: u32_0,
    pub isInit: u8_0,
    pub bigEndCksum: u8_0,
    pub szPage: u16_0,
    pub mxFrame: u32_0,
    pub nPage: u32_0,
    pub aFrameCksum: [u32_0; 2],
    pub aSalt: [u32_0; 2],
    pub aCksum: [u32_0; 2],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_file {
    pub pMethods: *const sqlite3_io_methods,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_io_methods {
    pub iVersion: libc::c_int,
    pub xClose: Option<unsafe extern "C" fn(_: *mut sqlite3_file)
                           -> libc::c_int>,
    pub xRead: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                           _: *mut libc::c_void,
                                           _: libc::c_int, _: sqlite3_int64)
                          -> libc::c_int>,
    pub xWrite: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                            _: *const libc::c_void,
                                            _: libc::c_int, _: sqlite3_int64)
                           -> libc::c_int>,
    pub xTruncate: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                               _: sqlite3_int64)
                              -> libc::c_int>,
    pub xSync: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                           _: libc::c_int) -> libc::c_int>,
    pub xFileSize: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                               _: *mut sqlite3_int64)
                              -> libc::c_int>,
    pub xLock: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                           _: libc::c_int) -> libc::c_int>,
    pub xUnlock: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                             _: libc::c_int) -> libc::c_int>,
    pub xCheckReservedLock: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                                        _: *mut libc::c_int)
                                       -> libc::c_int>,
    pub xFileControl: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                                  _: libc::c_int,
                                                  _: *mut libc::c_void)
                                 -> libc::c_int>,
    pub xSectorSize: Option<unsafe extern "C" fn(_: *mut sqlite3_file)
                                -> libc::c_int>,
    pub xDeviceCharacteristics: Option<unsafe extern "C" fn(_:
                                                                *mut sqlite3_file)
                                           -> libc::c_int>,
    pub xShmMap: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                             _: libc::c_int, _: libc::c_int,
                                             _: libc::c_int,
                                             _: *mut *mut libc::c_void)
                            -> libc::c_int>,
    pub xShmLock: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                              _: libc::c_int, _: libc::c_int,
                                              _: libc::c_int) -> libc::c_int>,
    pub xShmBarrier: Option<unsafe extern "C" fn(_: *mut sqlite3_file) -> ()>,
    pub xShmUnmap: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                               _: libc::c_int)
                              -> libc::c_int>,
    pub xFetch: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                            _: sqlite3_int64, _: libc::c_int,
                                            _: *mut *mut libc::c_void)
                           -> libc::c_int>,
    pub xUnfetch: Option<unsafe extern "C" fn(_: *mut sqlite3_file,
                                              _: sqlite3_int64,
                                              _: *mut libc::c_void)
                             -> libc::c_int>,
}
pub type sqlite3_int64 = sqlite_int64;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_vfs {
    pub iVersion: libc::c_int,
    pub szOsFile: libc::c_int,
    pub mxPathname: libc::c_int,
    pub pNext: *mut sqlite3_vfs,
    pub zName: *const libc::c_char,
    pub pAppData: *mut libc::c_void,
    pub xOpen: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                           _: *const libc::c_char,
                                           _: *mut sqlite3_file,
                                           _: libc::c_int,
                                           _: *mut libc::c_int)
                          -> libc::c_int>,
    pub xDelete: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                             _: *const libc::c_char,
                                             _: libc::c_int) -> libc::c_int>,
    pub xAccess: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                             _: *const libc::c_char,
                                             _: libc::c_int,
                                             _: *mut libc::c_int)
                            -> libc::c_int>,
    pub xFullPathname: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                                   _: *const libc::c_char,
                                                   _: libc::c_int,
                                                   _: *mut libc::c_char)
                                  -> libc::c_int>,
    pub xDlOpen: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                             _: *const libc::c_char)
                            -> *mut libc::c_void>,
    pub xDlError: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                              _: libc::c_int,
                                              _: *mut libc::c_char) -> ()>,
    pub xDlSym: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                            _: *mut libc::c_void,
                                            _: *const libc::c_char)
                           -> Option<unsafe extern "C" fn() -> ()>>,
    pub xDlClose: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                              _: *mut libc::c_void) -> ()>,
    pub xRandomness: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                                 _: libc::c_int,
                                                 _: *mut libc::c_char)
                                -> libc::c_int>,
    pub xSleep: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                            _: libc::c_int) -> libc::c_int>,
    pub xCurrentTime: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                                  _: *mut libc::c_double)
                                 -> libc::c_int>,
    pub xGetLastError: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                                   _: libc::c_int,
                                                   _: *mut libc::c_char)
                                  -> libc::c_int>,
    pub xCurrentTimeInt64: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                                       _: *mut sqlite3_int64)
                                      -> libc::c_int>,
    pub xSetSystemCall: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                                    _: *const libc::c_char,
                                                    _: sqlite3_syscall_ptr)
                                   -> libc::c_int>,
    pub xGetSystemCall: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                                    _: *const libc::c_char)
                                   -> sqlite3_syscall_ptr>,
    pub xNextSystemCall: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                                     _: *const libc::c_char)
                                    -> *const libc::c_char>,
}
pub type sqlite3_syscall_ptr = Option<unsafe extern "C" fn() -> ()>;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PCache {
    pub pDirty: *mut PgHdr,
    pub pDirtyTail: *mut PgHdr,
    pub pSynced: *mut PgHdr,
    pub nRefSum: libc::c_int,
    pub szCache: libc::c_int,
    pub szSpill: libc::c_int,
    pub szPage: libc::c_int,
    pub szExtra: libc::c_int,
    pub bPurgeable: u8_0,
    pub eCreate: u8_0,
    pub xStress: Option<unsafe extern "C" fn(_: *mut libc::c_void,
                                             _: *mut PgHdr) -> libc::c_int>,
    pub pStress: *mut libc::c_void,
    pub pCache: *mut sqlite3_pcache,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PagerSavepoint {
    pub iOffset: i64_0,
    pub iHdrOffset: i64_0,
    pub pInSavepoint: *mut Bitvec,
    pub nOrig: Pgno,
    pub iSubRec: Pgno,
    pub aWalData: [u32_0; 4],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Bitvec {
    pub iSize: u32_0,
    pub nSet: u32_0,
    pub iDivisor: u32_0,
    pub u: C2RustUnnamed_4,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_4 {
    pub aBitmap: [u8_0; 496],
    pub aHash: [u32_0; 124],
    pub apSub: [*mut Bitvec; 62],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_backup {
    pub pDestDb: *mut sqlite3,
    pub pDest: *mut Btree,
    pub iDestSchema: u32_0,
    pub bDestLocked: libc::c_int,
    pub iNext: Pgno,
    pub pSrcDb: *mut sqlite3,
    pub pSrc: *mut Btree,
    pub rc: libc::c_int,
    pub nRemaining: Pgno,
    pub nPagecount: Pgno,
    pub isAttached: libc::c_int,
    pub pNext: *mut sqlite3_backup,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Btree {
    pub db: *mut sqlite3,
    pub pBt: *mut BtShared,
    pub inTrans: u8_0,
    pub sharable: u8_0,
    pub locked: u8_0,
    pub hasIncrblobCur: u8_0,
    pub wantToLock: libc::c_int,
    pub nBackup: libc::c_int,
    pub iDataVersion: u32_0,
    pub pNext: *mut Btree,
    pub pPrev: *mut Btree,
    pub lock: BtLock,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct BtLock {
    pub pBtree: *mut Btree,
    pub iTable: Pgno,
    pub eLock: u8_0,
    pub pNext: *mut BtLock,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct BtShared {
    pub pPager: *mut Pager,
    pub db: *mut sqlite3,
    pub pCursor: *mut BtCursor,
    pub pPage1: *mut MemPage,
    pub openFlags: u8_0,
    pub autoVacuum: u8_0,
    pub incrVacuum: u8_0,
    pub bDoTruncate: u8_0,
    pub inTransaction: u8_0,
    pub max1bytePayload: u8_0,
    pub nReserveWanted: u8_0,
    pub btsFlags: u16_0,
    pub maxLocal: u16_0,
    pub minLocal: u16_0,
    pub maxLeaf: u16_0,
    pub minLeaf: u16_0,
    pub pageSize: u32_0,
    pub usableSize: u32_0,
    pub nTransaction: libc::c_int,
    pub nPage: u32_0,
    pub pSchema: *mut libc::c_void,
    pub xFreeSchema: Option<unsafe extern "C" fn(_: *mut libc::c_void) -> ()>,
    pub mutex: *mut sqlite3_mutex,
    pub pHasContent: *mut Bitvec,
    pub nRef: libc::c_int,
    pub pNext: *mut BtShared,
    pub pLock: *mut BtLock,
    pub pWriter: *mut Btree,
    pub pTmpSpace: *mut u8_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_mutex {
    pub mutex: pthread_mutex_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [libc::c_char; 40],
    pub __align: libc::c_long,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct __pthread_mutex_s {
    pub __lock: libc::c_int,
    pub __count: libc::c_uint,
    pub __owner: libc::c_int,
    pub __nusers: libc::c_uint,
    pub __kind: libc::c_int,
    pub __spins: libc::c_short,
    pub __elision: libc::c_short,
    pub __list: __pthread_list_t,
}
pub type __pthread_list_t = __pthread_internal_list;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_pcache_page {
    pub pBuf: *mut libc::c_void,
    pub pExtra: *mut libc::c_void,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct KeyInfo {
    pub nRef: u32_0,
    pub enc: u8_0,
    pub nKeyField: u16_0,
    pub nAllField: u16_0,
    pub db: *mut sqlite3,
    pub aSortFlags: *mut u8_0,
    pub aColl: [*mut CollSeq; 1],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CollSeq {
    pub zName: *mut libc::c_char,
    pub enc: u8_0,
    pub pUser: *mut libc::c_void,
    pub xCmp: Option<unsafe extern "C" fn(_: *mut libc::c_void,
                                          _: libc::c_int,
                                          _: *const libc::c_void,
                                          _: libc::c_int,
                                          _: *const libc::c_void)
                         -> libc::c_int>,
    pub xDel: Option<unsafe extern "C" fn(_: *mut libc::c_void) -> ()>,
}
pub type i8_0 = libc::c_schar;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct VTable {
    pub db: *mut sqlite3,
    pub pMod: *mut Module,
    pub pVtab: *mut sqlite3_vtab,
    pub nRef: libc::c_int,
    pub bConstraint: u8_0,
    pub eVtabRisk: u8_0,
    pub iSavepoint: libc::c_int,
    pub pNext: *mut VTable,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_vtab {
    pub pModule: *const sqlite3_module,
    pub nRef: libc::c_int,
    pub zErrMsg: *mut libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_module {
    pub iVersion: libc::c_int,
    pub xCreate: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                             _: *mut libc::c_void,
                                             _: libc::c_int,
                                             _: *const *const libc::c_char,
                                             _: *mut *mut sqlite3_vtab,
                                             _: *mut *mut libc::c_char)
                            -> libc::c_int>,
    pub xConnect: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                              _: *mut libc::c_void,
                                              _: libc::c_int,
                                              _: *const *const libc::c_char,
                                              _: *mut *mut sqlite3_vtab,
                                              _: *mut *mut libc::c_char)
                             -> libc::c_int>,
    pub xBestIndex: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab,
                                                _: *mut sqlite3_index_info)
                               -> libc::c_int>,
    pub xDisconnect: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab)
                                -> libc::c_int>,
    pub xDestroy: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab)
                             -> libc::c_int>,
    pub xOpen: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab,
                                           _: *mut *mut sqlite3_vtab_cursor)
                          -> libc::c_int>,
    pub xClose: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab_cursor)
                           -> libc::c_int>,
    pub xFilter: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab_cursor,
                                             _: libc::c_int,
                                             _: *const libc::c_char,
                                             _: libc::c_int,
                                             _: *mut *mut sqlite3_value)
                            -> libc::c_int>,
    pub xNext: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab_cursor)
                          -> libc::c_int>,
    pub xEof: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab_cursor)
                         -> libc::c_int>,
    pub xColumn: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab_cursor,
                                             _: *mut sqlite3_context,
                                             _: libc::c_int) -> libc::c_int>,
    pub xRowid: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab_cursor,
                                            _: *mut sqlite3_int64)
                           -> libc::c_int>,
    pub xUpdate: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab,
                                             _: libc::c_int,
                                             _: *mut *mut sqlite3_value,
                                             _: *mut sqlite3_int64)
                            -> libc::c_int>,
    pub xBegin: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab)
                           -> libc::c_int>,
    pub xSync: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab)
                          -> libc::c_int>,
    pub xCommit: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab)
                            -> libc::c_int>,
    pub xRollback: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab)
                              -> libc::c_int>,
    pub xFindFunction: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab,
                                                   _: libc::c_int,
                                                   _: *const libc::c_char,
                                                   _:
                                                       *mut Option<unsafe extern "C" fn(_:
                                                                                            *mut sqlite3_context,
                                                                                        _:
                                                                                            libc::c_int,
                                                                                        _:
                                                                                            *mut *mut sqlite3_value)
                                                                       -> ()>,
                                                   _: *mut *mut libc::c_void)
                                  -> libc::c_int>,
    pub xRename: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab,
                                             _: *const libc::c_char)
                            -> libc::c_int>,
    pub xSavepoint: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab,
                                                _: libc::c_int)
                               -> libc::c_int>,
    pub xRelease: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab,
                                              _: libc::c_int) -> libc::c_int>,
    pub xRollbackTo: Option<unsafe extern "C" fn(_: *mut sqlite3_vtab,
                                                 _: libc::c_int)
                                -> libc::c_int>,
    pub xShadowName: Option<unsafe extern "C" fn(_: *const libc::c_char)
                                -> libc::c_int>,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_vtab_cursor {
    pub pVtab: *mut sqlite3_vtab,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_index_info {
    pub nConstraint: libc::c_int,
    pub aConstraint: *mut sqlite3_index_constraint,
    pub nOrderBy: libc::c_int,
    pub aOrderBy: *mut sqlite3_index_orderby,
    pub aConstraintUsage: *mut sqlite3_index_constraint_usage,
    pub idxNum: libc::c_int,
    pub idxStr: *mut libc::c_char,
    pub needToFreeIdxStr: libc::c_int,
    pub orderByConsumed: libc::c_int,
    pub estimatedCost: libc::c_double,
    pub estimatedRows: sqlite3_int64,
    pub idxFlags: libc::c_int,
    pub colUsed: sqlite3_uint64,
}
pub type sqlite3_uint64 = sqlite_uint64;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_index_constraint_usage {
    pub argvIndex: libc::c_int,
    pub omit: libc::c_uchar,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_index_orderby {
    pub iColumn: libc::c_int,
    pub desc: libc::c_uchar,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_index_constraint {
    pub iColumn: libc::c_int,
    pub op: libc::c_uchar,
    pub usable: libc::c_uchar,
    pub iTermOffset: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Module {
    pub pModule: *const sqlite3_module,
    pub zName: *const libc::c_char,
    pub nRefModule: libc::c_int,
    pub pAux: *mut libc::c_void,
    pub xDestroy: Option<unsafe extern "C" fn(_: *mut libc::c_void) -> ()>,
    pub pEpoTab: *mut Table,
}
pub type Mem = sqlite3_value;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct VdbeFrame {
    pub v: *mut Vdbe,
    pub pParent: *mut VdbeFrame,
    pub aOp: *mut Op,
    pub anExec: *mut i64_0,
    pub aMem: *mut Mem,
    pub apCsr: *mut *mut VdbeCursor,
    pub aOnce: *mut u8_0,
    pub token: *mut libc::c_void,
    pub lastRowid: i64_0,
    pub pAuxData: *mut AuxData,
    pub nCursor: libc::c_int,
    pub pc: libc::c_int,
    pub nOp: libc::c_int,
    pub nMem: libc::c_int,
    pub nChildMem: libc::c_int,
    pub nChildCsr: libc::c_int,
    pub nChange: libc::c_int,
    pub nDbChange: libc::c_int,
}
#[derive(Copy, Clone, BitfieldStruct)]
#[repr(C)]
pub struct VdbeCursor {
    pub eCurType: u8_0,
    pub iDb: i8_0,
    pub nullRow: u8_0,
    pub deferredMoveto: u8_0,
    pub isTable: u8_0,
    #[bitfield(name = "isEphemeral", ty = "Bool", bits = "0..=0")]
    #[bitfield(name = "useRandomRowid", ty = "Bool", bits = "1..=1")]
    #[bitfield(name = "isOrdered", ty = "Bool", bits = "2..=2")]
    #[bitfield(name = "seekHit", ty = "Bool", bits = "3..=3")]
    pub isEphemeral_useRandomRowid_isOrdered_seekHit: [u8; 1],
    #[bitfield(padding)]
    pub c2rust_padding: [u8; 2],
    pub pBtx: *mut Btree,
    pub seqCount: i64_0,
    pub aAltMap: *mut libc::c_int,
    pub cacheStatus: u32_0,
    pub seekResult: libc::c_int,
    pub pAltCursor: *mut VdbeCursor,
    pub uc: C2RustUnnamed_5,
    pub pKeyInfo: *mut KeyInfo,
    pub iHdrOffset: u32_0,
    pub pgnoRoot: Pgno,
    pub nField: i16_0,
    pub nHdrParsed: u16_0,
    pub movetoTarget: i64_0,
    pub aOffset: *mut u32_0,
    pub aRow: *const u8_0,
    pub payloadSize: u32_0,
    pub szRow: u32_0,
    pub aType: [u32_0; 1],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_5 {
    pub pCursor: *mut BtCursor,
    pub pVCur: *mut sqlite3_vtab_cursor,
    pub pSorter: *mut VdbeSorter,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct VdbeSorter {
    pub mnPmaSize: libc::c_int,
    pub mxPmaSize: libc::c_int,
    pub mxKeysize: libc::c_int,
    pub pgsz: libc::c_int,
    pub pReader: *mut PmaReader,
    pub pMerger: *mut MergeEngine,
    pub db: *mut sqlite3,
    pub pKeyInfo: *mut KeyInfo,
    pub pUnpacked: *mut UnpackedRecord,
    pub list: SorterList,
    pub iMemory: libc::c_int,
    pub nMemory: libc::c_int,
    pub bUsePMA: u8_0,
    pub bUseThreads: u8_0,
    pub iPrev: u8_0,
    pub nTask: u8_0,
    pub typeMask: u8_0,
    pub aTask: [SortSubtask; 1],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SortSubtask {
    pub pThread: *mut SQLiteThread,
    pub bDone: libc::c_int,
    pub pSorter: *mut VdbeSorter,
    pub pUnpacked: *mut UnpackedRecord,
    pub list: SorterList,
    pub nPMA: libc::c_int,
    pub xCompare: SorterCompare,
    pub file: SorterFile,
    pub file2: SorterFile,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SorterFile {
    pub pFd: *mut sqlite3_file,
    pub iEof: i64_0,
}
pub type SorterCompare
    =
    Option<unsafe extern "C" fn(_: *mut SortSubtask, _: *mut libc::c_int,
                                _: *const libc::c_void, _: libc::c_int,
                                _: *const libc::c_void, _: libc::c_int)
               -> libc::c_int>;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SorterList {
    pub pList: *mut SorterRecord,
    pub aMemory: *mut u8_0,
    pub szPMA: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SorterRecord {
    pub nVal: libc::c_int,
    pub u: C2RustUnnamed_6,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_6 {
    pub pNext: *mut SorterRecord,
    pub iNext: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct UnpackedRecord {
    pub pKeyInfo: *mut KeyInfo,
    pub aMem: *mut Mem,
    pub nField: u16_0,
    pub default_rc: i8_0,
    pub errCode: u8_0,
    pub r1: i8_0,
    pub r2: i8_0,
    pub eqSeen: u8_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SQLiteThread {
    pub tid: pthread_t,
    pub done: libc::c_int,
    pub pOut: *mut libc::c_void,
    pub xTask: Option<unsafe extern "C" fn(_: *mut libc::c_void)
                          -> *mut libc::c_void>,
    pub pIn: *mut libc::c_void,
}
pub type pthread_t = libc::c_ulong;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MergeEngine {
    pub nTree: libc::c_int,
    pub pTask: *mut SortSubtask,
    pub aTree: *mut libc::c_int,
    pub aReadr: *mut PmaReader,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PmaReader {
    pub iReadOff: i64_0,
    pub iEof: i64_0,
    pub nAlloc: libc::c_int,
    pub nKey: libc::c_int,
    pub pFd: *mut sqlite3_file,
    pub aAlloc: *mut u8_0,
    pub aKey: *mut u8_0,
    pub aBuffer: *mut u8_0,
    pub nBuffer: libc::c_int,
    pub aMap: *mut u8_0,
    pub pIncr: *mut IncrMerger,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct IncrMerger {
    pub pTask: *mut SortSubtask,
    pub pMerger: *mut MergeEngine,
    pub iStartOff: i64_0,
    pub mxSz: libc::c_int,
    pub bEof: libc::c_int,
    pub bUseThread: libc::c_int,
    pub aFile: [SorterFile; 2],
}
pub type Bool = libc::c_uint;
pub type Op = VdbeOp;
pub type yDbMask = libc::c_uint;
pub type bft = libc::c_uint;
pub type VList = libc::c_int;
pub type ynVar = i16_0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Parse {
    pub db: *mut sqlite3,
    pub zErrMsg: *mut libc::c_char,
    pub pVdbe: *mut Vdbe,
    pub rc: libc::c_int,
    pub colNamesSet: u8_0,
    pub checkSchema: u8_0,
    pub nested: u8_0,
    pub nTempReg: u8_0,
    pub isMultiWrite: u8_0,
    pub mayAbort: u8_0,
    pub hasCompound: u8_0,
    pub okConstFactor: u8_0,
    pub disableLookaside: u8_0,
    pub disableVtab: u8_0,
    pub nRangeReg: libc::c_int,
    pub iRangeReg: libc::c_int,
    pub nErr: libc::c_int,
    pub nTab: libc::c_int,
    pub nMem: libc::c_int,
    pub szOpAlloc: libc::c_int,
    pub iSelfTab: libc::c_int,
    pub nLabel: libc::c_int,
    pub nLabelAlloc: libc::c_int,
    pub aLabel: *mut libc::c_int,
    pub pConstExpr: *mut ExprList,
    pub constraintName: Token,
    pub writeMask: yDbMask,
    pub cookieMask: yDbMask,
    pub regRowid: libc::c_int,
    pub regRoot: libc::c_int,
    pub nMaxArg: libc::c_int,
    pub nSelect: libc::c_int,
    pub nTableLock: libc::c_int,
    pub aTableLock: *mut TableLock,
    pub pAinc: *mut AutoincInfo,
    pub pToplevel: *mut Parse,
    pub pTriggerTab: *mut Table,
    pub pParentParse: *mut Parse,
    pub pAggList: *mut AggInfo,
    pub addrCrTab: libc::c_int,
    pub nQueryLoop: u32_0,
    pub oldmask: u32_0,
    pub newmask: u32_0,
    pub eTriggerOp: u8_0,
    pub eOrconf: u8_0,
    pub disableTriggers: u8_0,
    pub aTempReg: [libc::c_int; 8],
    pub sNameToken: Token,
    pub sLastToken: Token,
    pub nVar: ynVar,
    pub iPkSortOrder: u8_0,
    pub explain: u8_0,
    pub eParseMode: u8_0,
    pub nVtabLock: libc::c_int,
    pub nHeight: libc::c_int,
    pub addrExplain: libc::c_int,
    pub pVList: *mut VList,
    pub pReprepare: *mut Vdbe,
    pub zTail: *const libc::c_char,
    pub pNewTable: *mut Table,
    pub pNewIndex: *mut Index,
    pub pNewTrigger: *mut Trigger,
    pub zAuthContext: *const libc::c_char,
    pub sArg: Token,
    pub apVtabLock: *mut *mut Table,
    pub pZombieTab: *mut Table,
    pub pTriggerPrg: *mut TriggerPrg,
    pub pWith: *mut With,
    pub pWithToFree: *mut With,
    pub pRename: *mut RenameToken,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct RenameToken {
    pub p: *mut libc::c_void,
    pub t: Token,
    pub pNext: *mut RenameToken,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Token {
    pub z: *const libc::c_char,
    pub n: libc::c_uint,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct With {
    pub nCte: libc::c_int,
    pub pOuter: *mut With,
    pub a: [Cte; 1],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Cte {
    pub zName: *mut libc::c_char,
    pub pCols: *mut ExprList,
    pub pSelect: *mut Select,
    pub zCteErr: *const libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Select {
    pub op: u8_0,
    pub nSelectRow: LogEst,
    pub selFlags: u32_0,
    pub iLimit: libc::c_int,
    pub iOffset: libc::c_int,
    pub selId: u32_0,
    pub addrOpenEphm: [libc::c_int; 2],
    pub pEList: *mut ExprList,
    pub pSrc: *mut SrcList,
    pub pWhere: *mut Expr,
    pub pGroupBy: *mut ExprList,
    pub pHaving: *mut Expr,
    pub pOrderBy: *mut ExprList,
    pub pPrior: *mut Select,
    pub pNext: *mut Select,
    pub pLimit: *mut Expr,
    pub pWith: *mut With,
    pub pWin: *mut Window,
    pub pWinDefn: *mut Window,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TriggerPrg {
    pub pTrigger: *mut Trigger,
    pub pNext: *mut TriggerPrg,
    pub pProgram: *mut SubProgram,
    pub orconf: libc::c_int,
    pub aColmask: [u32_0; 2],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AggInfo {
    pub directMode: u8_0,
    pub useSortingIdx: u8_0,
    pub sortingIdx: libc::c_int,
    pub sortingIdxPTab: libc::c_int,
    pub nSortingColumn: libc::c_int,
    pub mnReg: libc::c_int,
    pub mxReg: libc::c_int,
    pub pGroupBy: *mut ExprList,
    pub aCol: *mut AggInfo_col,
    pub nColumn: libc::c_int,
    pub nAccumulator: libc::c_int,
    pub aFunc: *mut AggInfo_func,
    pub nFunc: libc::c_int,
    pub pNext: *mut AggInfo,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AggInfo_func {
    pub pExpr: *mut Expr,
    pub pFunc: *mut FuncDef,
    pub iMem: libc::c_int,
    pub iDistinct: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AggInfo_col {
    pub pTab: *mut Table,
    pub pExpr: *mut Expr,
    pub iTable: libc::c_int,
    pub iMem: libc::c_int,
    pub iColumn: i16_0,
    pub iSorterColumn: i16_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AutoincInfo {
    pub pNext: *mut AutoincInfo,
    pub pTab: *mut Table,
    pub iDb: libc::c_int,
    pub regCtr: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TableLock {
    pub iDb: libc::c_int,
    pub iTab: libc::c_int,
    pub isWriteLock: u8_0,
    pub zLockName: *const libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_7 {
    pub pList: *mut ExprList,
    pub pSelect: *mut Select,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_8 {
    pub zToken: *mut libc::c_char,
    pub iValue: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_9 {
    pub zIndexedBy: *mut libc::c_char,
    pub pFuncArg: *mut ExprList,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct IdList {
    pub a: *mut IdList_item,
    pub nId: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct IdList_item {
    pub zName: *mut libc::c_char,
    pub idx: libc::c_int,
}
#[derive(Copy, Clone, BitfieldStruct)]
#[repr(C)]
pub struct C2RustUnnamed_10 {
    pub jointype: u8_0,
    #[bitfield(name = "notIndexed", ty = "libc::c_uint", bits = "0..=0")]
    #[bitfield(name = "isIndexedBy", ty = "libc::c_uint", bits = "1..=1")]
    #[bitfield(name = "isTabFunc", ty = "libc::c_uint", bits = "2..=2")]
    #[bitfield(name = "isCorrelated", ty = "libc::c_uint", bits = "3..=3")]
    #[bitfield(name = "viaCoroutine", ty = "libc::c_uint", bits = "4..=4")]
    #[bitfield(name = "isRecursive", ty = "libc::c_uint", bits = "5..=5")]
    #[bitfield(name = "fromDDL", ty = "libc::c_uint", bits = "6..=6")]
    pub notIndexed_isIndexedBy_isTabFunc_isCorrelated_viaCoroutine_isRecursive_fromDDL: [u8; 1],
    #[bitfield(padding)]
    pub c2rust_padding: [u8; 2],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct FKey {
    pub pFrom: *mut Table,
    pub pNextFrom: *mut FKey,
    pub zTo: *mut libc::c_char,
    pub pNextTo: *mut FKey,
    pub pPrevTo: *mut FKey,
    pub nCol: libc::c_int,
    pub isDeferred: u8_0,
    pub aAction: [u8_0; 2],
    pub apTrigger: [*mut Trigger; 2],
    pub aCol: [sColMap; 1],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sColMap {
    pub iFrom: libc::c_int,
    pub zCol: *mut libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Column {
    pub zName: *mut libc::c_char,
    pub pDflt: *mut Expr,
    pub zColl: *mut libc::c_char,
    pub notNull: u8_0,
    pub affinity: libc::c_char,
    pub szEst: u8_0,
    pub hName: u8_0,
    pub colFlags: u16_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Hash {
    pub htsize: libc::c_uint,
    pub count: libc::c_uint,
    pub first: *mut HashElem,
    pub ht: *mut _ht,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _ht {
    pub count: libc::c_uint,
    pub chain: *mut HashElem,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct HashElem {
    pub next: *mut HashElem,
    pub prev: *mut HashElem,
    pub data: *mut libc::c_void,
    pub pKey: *const libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct BusyHandler {
    pub xBusyHandler: Option<unsafe extern "C" fn(_: *mut libc::c_void,
                                                  _: libc::c_int)
                                 -> libc::c_int>,
    pub pBusyArg: *mut libc::c_void,
    pub nBusy: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct VtabCtx {
    pub pVTable: *mut VTable,
    pub pTab: *mut Table,
    pub pPrior: *mut VtabCtx,
    pub bDeclared: libc::c_int,
}
pub type sqlite3_xauth
    =
    Option<unsafe extern "C" fn(_: *mut libc::c_void, _: libc::c_int,
                                _: *const libc::c_char,
                                _: *const libc::c_char,
                                _: *const libc::c_char,
                                _: *const libc::c_char) -> libc::c_int>;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Lookaside {
    pub bDisable: u32_0,
    pub sz: u16_0,
    pub szTrue: u16_0,
    pub bMalloced: u8_0,
    pub nSlot: u32_0,
    pub anStat: [u32_0; 3],
    pub pInit: *mut LookasideSlot,
    pub pFree: *mut LookasideSlot,
    pub pSmallInit: *mut LookasideSlot,
    pub pSmallFree: *mut LookasideSlot,
    pub pMiddle: *mut libc::c_void,
    pub pStart: *mut libc::c_void,
    pub pEnd: *mut libc::c_void,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct LookasideSlot {
    pub pNext: *mut LookasideSlot,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_11 {
    pub isInterrupted: libc::c_int,
    pub notUsed1: libc::c_double,
}
#[derive(Copy, Clone, BitfieldStruct)]
#[repr(C)]
pub struct sqlite3InitInfo {
    pub newTnum: libc::c_int,
    pub iDb: u8_0,
    pub busy: u8_0,
    #[bitfield(name = "orphanTrigger", ty = "libc::c_uint", bits = "0..=0")]
    #[bitfield(name = "imposterTable", ty = "libc::c_uint", bits = "1..=1")]
    #[bitfield(name = "reopenMemdb", ty = "libc::c_uint", bits = "2..=2")]
    pub orphanTrigger_imposterTable_reopenMemdb: [u8; 1],
    #[bitfield(padding)]
    pub c2rust_padding: [u8; 1],
    pub azInit: *mut *mut libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_mem_methods {
    pub xMalloc: Option<unsafe extern "C" fn(_: libc::c_int)
                            -> *mut libc::c_void>,
    pub xFree: Option<unsafe extern "C" fn(_: *mut libc::c_void) -> ()>,
    pub xRealloc: Option<unsafe extern "C" fn(_: *mut libc::c_void,
                                              _: libc::c_int)
                             -> *mut libc::c_void>,
    pub xSize: Option<unsafe extern "C" fn(_: *mut libc::c_void)
                          -> libc::c_int>,
    pub xRoundup: Option<unsafe extern "C" fn(_: libc::c_int) -> libc::c_int>,
    pub xInit: Option<unsafe extern "C" fn(_: *mut libc::c_void)
                          -> libc::c_int>,
    pub xShutdown: Option<unsafe extern "C" fn(_: *mut libc::c_void) -> ()>,
    pub pAppData: *mut libc::c_void,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Sqlite3Config {
    pub bMemstat: libc::c_int,
    pub bCoreMutex: u8_0,
    pub bFullMutex: u8_0,
    pub bOpenUri: u8_0,
    pub bUseCis: u8_0,
    pub bSmallMalloc: u8_0,
    pub bExtraSchemaChecks: u8_0,
    pub mxStrlen: libc::c_int,
    pub neverCorrupt: libc::c_int,
    pub szLookaside: libc::c_int,
    pub nLookaside: libc::c_int,
    pub nStmtSpill: libc::c_int,
    pub m: sqlite3_mem_methods,
    pub mutex: sqlite3_mutex_methods,
    pub pcache2: sqlite3_pcache_methods2,
    pub pHeap: *mut libc::c_void,
    pub nHeap: libc::c_int,
    pub mnReq: libc::c_int,
    pub mxReq: libc::c_int,
    pub szMmap: sqlite3_int64,
    pub mxMmap: sqlite3_int64,
    pub pPage: *mut libc::c_void,
    pub szPage: libc::c_int,
    pub nPage: libc::c_int,
    pub mxParserStack: libc::c_int,
    pub sharedCacheEnabled: libc::c_int,
    pub szPma: u32_0,
    pub isInit: libc::c_int,
    pub inProgress: libc::c_int,
    pub isMutexInit: libc::c_int,
    pub isMallocInit: libc::c_int,
    pub isPCacheInit: libc::c_int,
    pub nRefInitMutex: libc::c_int,
    pub pInitMutex: *mut sqlite3_mutex,
    pub xLog: Option<unsafe extern "C" fn(_: *mut libc::c_void,
                                          _: libc::c_int,
                                          _: *const libc::c_char) -> ()>,
    pub pLogArg: *mut libc::c_void,
    pub xTestCallback: Option<unsafe extern "C" fn(_: libc::c_int)
                                  -> libc::c_int>,
    pub bLocaltimeFault: libc::c_int,
    pub iOnceResetThreshold: libc::c_int,
    pub szSorterRef: u32_0,
    pub iPrngSeed: libc::c_uint,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_pcache_methods2 {
    pub iVersion: libc::c_int,
    pub pArg: *mut libc::c_void,
    pub xInit: Option<unsafe extern "C" fn(_: *mut libc::c_void)
                          -> libc::c_int>,
    pub xShutdown: Option<unsafe extern "C" fn(_: *mut libc::c_void) -> ()>,
    pub xCreate: Option<unsafe extern "C" fn(_: libc::c_int, _: libc::c_int,
                                             _: libc::c_int)
                            -> *mut sqlite3_pcache>,
    pub xCachesize: Option<unsafe extern "C" fn(_: *mut sqlite3_pcache,
                                                _: libc::c_int) -> ()>,
    pub xPagecount: Option<unsafe extern "C" fn(_: *mut sqlite3_pcache)
                               -> libc::c_int>,
    pub xFetch: Option<unsafe extern "C" fn(_: *mut sqlite3_pcache,
                                            _: libc::c_uint, _: libc::c_int)
                           -> *mut sqlite3_pcache_page>,
    pub xUnpin: Option<unsafe extern "C" fn(_: *mut sqlite3_pcache,
                                            _: *mut sqlite3_pcache_page,
                                            _: libc::c_int) -> ()>,
    pub xRekey: Option<unsafe extern "C" fn(_: *mut sqlite3_pcache,
                                            _: *mut sqlite3_pcache_page,
                                            _: libc::c_uint, _: libc::c_uint)
                           -> ()>,
    pub xTruncate: Option<unsafe extern "C" fn(_: *mut sqlite3_pcache,
                                               _: libc::c_uint) -> ()>,
    pub xDestroy: Option<unsafe extern "C" fn(_: *mut sqlite3_pcache) -> ()>,
    pub xShrink: Option<unsafe extern "C" fn(_: *mut sqlite3_pcache) -> ()>,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_mutex_methods {
    pub xMutexInit: Option<unsafe extern "C" fn() -> libc::c_int>,
    pub xMutexEnd: Option<unsafe extern "C" fn() -> libc::c_int>,
    pub xMutexAlloc: Option<unsafe extern "C" fn(_: libc::c_int)
                                -> *mut sqlite3_mutex>,
    pub xMutexFree: Option<unsafe extern "C" fn(_: *mut sqlite3_mutex) -> ()>,
    pub xMutexEnter: Option<unsafe extern "C" fn(_: *mut sqlite3_mutex)
                                -> ()>,
    pub xMutexTry: Option<unsafe extern "C" fn(_: *mut sqlite3_mutex)
                              -> libc::c_int>,
    pub xMutexLeave: Option<unsafe extern "C" fn(_: *mut sqlite3_mutex)
                                -> ()>,
    pub xMutexHeld: Option<unsafe extern "C" fn(_: *mut sqlite3_mutex)
                               -> libc::c_int>,
    pub xMutexNotheld: Option<unsafe extern "C" fn(_: *mut sqlite3_mutex)
                                  -> libc::c_int>,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Mem0Global {
    pub mutex: *mut sqlite3_mutex,
    pub alarmThreshold: sqlite3_int64,
    pub hardLimit: sqlite3_int64,
    pub nearlyFull: libc::c_int,
}
pub type sqlite3StatValueType = sqlite3_int64;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3StatType {
    pub nowValue: [sqlite3StatValueType; 10],
    pub mxValue: [sqlite3StatValueType; 10],
}
pub type uptr = u64_0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct BenignMallocHooks {
    pub xBenignBegin: Option<unsafe extern "C" fn() -> ()>,
    pub xBenignEnd: Option<unsafe extern "C" fn() -> ()>,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PCacheGlobal {
    pub grp: PGroup,
    pub isInit: libc::c_int,
    pub separateCache: libc::c_int,
    pub nInitPage: libc::c_int,
    pub szSlot: libc::c_int,
    pub nSlot: libc::c_int,
    pub nReserve: libc::c_int,
    pub pStart: *mut libc::c_void,
    pub pEnd: *mut libc::c_void,
    pub mutex: *mut sqlite3_mutex,
    pub pFree: *mut PgFreeslot,
    pub nFreeSlot: libc::c_int,
    pub bUnderPressure: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PgFreeslot {
    pub pNext: *mut PgFreeslot,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PGroup {
    pub mutex: *mut sqlite3_mutex,
    pub nMaxPage: libc::c_uint,
    pub nMinPage: libc::c_uint,
    pub mxPinned: libc::c_uint,
    pub nPurgeable: libc::c_uint,
    pub lru: PgHdr1,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PgHdr1 {
    pub page: sqlite3_pcache_page,
    pub iKey: libc::c_uint,
    pub isBulkLocal: u16_0,
    pub isAnchor: u16_0,
    pub pNext: *mut PgHdr1,
    pub pCache: *mut PCache1,
    pub pLruNext: *mut PgHdr1,
    pub pLruPrev: *mut PgHdr1,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PCache1 {
    pub pGroup: *mut PGroup,
    pub pnPurgeable: *mut libc::c_uint,
    pub szPage: libc::c_int,
    pub szExtra: libc::c_int,
    pub szAlloc: libc::c_int,
    pub bPurgeable: libc::c_int,
    pub nMin: libc::c_uint,
    pub nMax: libc::c_uint,
    pub n90pct: libc::c_uint,
    pub iMaxKey: libc::c_uint,
    pub nPurgeableDummy: libc::c_uint,
    pub nRecyclable: libc::c_uint,
    pub nPage: libc::c_uint,
    pub nHash: libc::c_uint,
    pub apHash: *mut *mut PgHdr1,
    pub pFree: *mut PgHdr1,
    pub pBulk: *mut libc::c_void,
}
pub type StrAccum = sqlite3_str;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_str {
    pub db: *mut sqlite3,
    pub zText: *mut libc::c_char,
    pub nAlloc: u32_0,
    pub mxAlloc: u32_0,
    pub nChar: u32_0,
    pub accError: u8_0,
    pub printfFlags: u8_0,
}
pub type etByte = libc::c_uchar;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PrintfArguments {
    pub nArg: libc::c_int,
    pub nUsed: libc::c_int,
    pub apArg: *mut *mut sqlite3_value,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct et_info {
    pub fmttype: libc::c_char,
    pub base: etByte,
    pub flags: etByte,
    pub type_0: etByte,
    pub charset: etByte,
    pub prefix: etByte,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WalHashLoc {
    pub aHash: *mut ht_slot,
    pub aPgno: *mut u32_0,
    pub iZero: u32_0,
}
pub type ht_slot = u16_0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WalCkptInfo {
    pub nBackfill: u32_0,
    pub aReadMark: [u32_0; 5],
    pub aLock: [u8_0; 8],
    pub nBackfillAttempted: u32_0,
    pub notUsed0: u32_0,
}
pub type size_t = libc::c_ulong;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct FilePoint {
    pub iOffset: sqlite3_int64,
    pub pChunk: *mut FileChunk,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct FileChunk {
    pub pNext: *mut FileChunk,
    pub zChunk: [u8_0; 8],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MemJournal {
    pub pMethod: *const sqlite3_io_methods,
    pub nChunkSize: libc::c_int,
    pub nSpill: libc::c_int,
    pub nSize: libc::c_int,
    pub pFirst: *mut FileChunk,
    pub endpoint: FilePoint,
    pub readpoint: FilePoint,
    pub flags: libc::c_int,
    pub pVfs: *mut sqlite3_vfs,
    pub zJournal: *const libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct unix_syscall {
    pub zName: *const libc::c_char,
    pub pCurrent: sqlite3_syscall_ptr,
    pub pDefault: sqlite3_syscall_ptr,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct stat {
    pub st_dev: __dev_t,
    pub st_ino: __ino_t,
    pub st_nlink: __nlink_t,
    pub st_mode: __mode_t,
    pub st_uid: __uid_t,
    pub st_gid: __gid_t,
    pub __pad0: libc::c_int,
    pub st_rdev: __dev_t,
    pub st_size: __off_t,
    pub st_blksize: __blksize_t,
    pub st_blocks: __blkcnt_t,
    pub st_atim: timespec,
    pub st_mtim: timespec,
    pub st_ctim: timespec,
    pub __glibc_reserved: [__syscall_slong_t; 3],
}
pub type __syscall_slong_t = libc::c_long;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
pub type __time_t = libc::c_long;
pub type __blkcnt_t = libc::c_long;
pub type __blksize_t = libc::c_long;
pub type __off_t = libc::c_long;
pub type __dev_t = libc::c_ulong;
pub type __gid_t = libc::c_uint;
pub type __uid_t = libc::c_uint;
pub type __mode_t = libc::c_uint;
pub type __nlink_t = libc::c_ulong;
pub type __ino_t = libc::c_ulong;
pub type ssize_t = __ssize_t;
pub type __ssize_t = libc::c_long;
pub type __off64_t = libc::c_long;
pub type mode_t = __mode_t;
pub type __suseconds_t = libc::c_long;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct timezone {
    pub tz_minuteswest: libc::c_int,
    pub tz_dsttime: libc::c_int,
}
pub type __timezone_ptr_t = *mut timezone;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct unixFile {
    pub pMethod: *const sqlite3_io_methods,
    pub pVfs: *mut sqlite3_vfs,
    pub pInode: *mut unixInodeInfo,
    pub h: libc::c_int,
    pub eFileLock: libc::c_uchar,
    pub ctrlFlags: libc::c_ushort,
    pub lastErrno: libc::c_int,
    pub lockingContext: *mut libc::c_void,
    pub pPreallocatedUnused: *mut UnixUnusedFd,
    pub zPath: *const libc::c_char,
    pub pShm: *mut unixShm,
    pub szChunk: libc::c_int,
    pub nFetchOut: libc::c_int,
    pub mmapSize: sqlite3_int64,
    pub mmapSizeActual: sqlite3_int64,
    pub mmapSizeMax: sqlite3_int64,
    pub pMapRegion: *mut libc::c_void,
    pub sectorSize: libc::c_int,
    pub deviceCharacteristics: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct unixShm {
    pub pShmNode: *mut unixShmNode,
    pub pNext: *mut unixShm,
    pub hasMutex: u8_0,
    pub id: u8_0,
    pub sharedMask: u16_0,
    pub exclMask: u16_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct unixShmNode {
    pub pInode: *mut unixInodeInfo,
    pub pShmMutex: *mut sqlite3_mutex,
    pub zFilename: *mut libc::c_char,
    pub hShm: libc::c_int,
    pub szRegion: libc::c_int,
    pub nRegion: u16_0,
    pub isReadonly: u8_0,
    pub isUnlocked: u8_0,
    pub apRegion: *mut *mut libc::c_char,
    pub nRef: libc::c_int,
    pub pFirst: *mut unixShm,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct unixInodeInfo {
    pub fileId: unixFileId,
    pub pLockMutex: *mut sqlite3_mutex,
    pub nShared: libc::c_int,
    pub nLock: libc::c_int,
    pub eFileLock: libc::c_uchar,
    pub bProcessLock: libc::c_uchar,
    pub pUnused: *mut UnixUnusedFd,
    pub nRef: libc::c_int,
    pub pShmNode: *mut unixShmNode,
    pub pNext: *mut unixInodeInfo,
    pub pPrev: *mut unixInodeInfo,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct UnixUnusedFd {
    pub fd: libc::c_int,
    pub flags: libc::c_int,
    pub pNext: *mut UnixUnusedFd,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct unixFileId {
    pub dev: dev_t,
    pub ino: u64_0,
}
pub type dev_t = __dev_t;
pub type pid_t = __pid_t;
pub type __pid_t = libc::c_int;
pub type time_t = __time_t;
pub type off_t = __off64_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct flock {
    pub l_type: libc::c_short,
    pub l_whence: libc::c_short,
    pub l_start: __off64_t,
    pub l_len: __off64_t,
    pub l_pid: __pid_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3PrngType {
    pub isInit: libc::c_uchar,
    pub i: libc::c_uchar,
    pub j: libc::c_uchar,
    pub s: [libc::c_uchar; 256],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union pthread_mutexattr_t {
    pub __size: [libc::c_char; 4],
    pub __align: libc::c_int,
}
pub const PTHREAD_MUTEX_RECURSIVE: C2RustUnnamed_25 = 1;
pub type gid_t = __gid_t;
pub type uid_t = __uid_t;
pub type finder_type
    =
    Option<unsafe extern "C" fn(_: *const libc::c_char, _: *mut unixFile)
               -> *const sqlite3_io_methods>;
pub type LOGFUNC_t
    =
    Option<unsafe extern "C" fn(_: *mut libc::c_void, _: libc::c_int,
                                _: *const libc::c_char) -> ()>;
pub type sqlite3_destructor_type
    =
    Option<unsafe extern "C" fn(_: *mut libc::c_void) -> ()>;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct compareInfo {
    pub matchAll: u8_0,
    pub matchOne: u8_0,
    pub matchSet: u8_0,
    pub noCase: u8_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CountCtx {
    pub n: i64_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SumCtx {
    pub rSum: libc::c_double,
    pub iSum: i64_0,
    pub cnt: i64_0,
    pub overflow: u8_0,
    pub approx: u8_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3_api_routines {
    pub aggregate_context: Option<unsafe extern "C" fn(_:
                                                           *mut sqlite3_context,
                                                       _: libc::c_int)
                                      -> *mut libc::c_void>,
    pub aggregate_count: Option<unsafe extern "C" fn(_: *mut sqlite3_context)
                                    -> libc::c_int>,
    pub bind_blob: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                               _: libc::c_int,
                                               _: *const libc::c_void,
                                               _: libc::c_int,
                                               _:
                                                   Option<unsafe extern "C" fn(_:
                                                                                   *mut libc::c_void)
                                                              -> ()>)
                              -> libc::c_int>,
    pub bind_double: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                 _: libc::c_int,
                                                 _: libc::c_double)
                                -> libc::c_int>,
    pub bind_int: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                              _: libc::c_int, _: libc::c_int)
                             -> libc::c_int>,
    pub bind_int64: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                _: libc::c_int,
                                                _: sqlite_int64)
                               -> libc::c_int>,
    pub bind_null: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                               _: libc::c_int)
                              -> libc::c_int>,
    pub bind_parameter_count: Option<unsafe extern "C" fn(_:
                                                              *mut sqlite3_stmt)
                                         -> libc::c_int>,
    pub bind_parameter_index: Option<unsafe extern "C" fn(_:
                                                              *mut sqlite3_stmt,
                                                          _:
                                                              *const libc::c_char)
                                         -> libc::c_int>,
    pub bind_parameter_name: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                         _: libc::c_int)
                                        -> *const libc::c_char>,
    pub bind_text: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                               _: libc::c_int,
                                               _: *const libc::c_char,
                                               _: libc::c_int,
                                               _:
                                                   Option<unsafe extern "C" fn(_:
                                                                                   *mut libc::c_void)
                                                              -> ()>)
                              -> libc::c_int>,
    pub bind_text16: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                 _: libc::c_int,
                                                 _: *const libc::c_void,
                                                 _: libc::c_int,
                                                 _:
                                                     Option<unsafe extern "C" fn(_:
                                                                                     *mut libc::c_void)
                                                                -> ()>)
                                -> libc::c_int>,
    pub bind_value: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                _: libc::c_int,
                                                _: *const sqlite3_value)
                               -> libc::c_int>,
    pub busy_handler: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                  _:
                                                      Option<unsafe extern "C" fn(_:
                                                                                      *mut libc::c_void,
                                                                                  _:
                                                                                      libc::c_int)
                                                                 ->
                                                                     libc::c_int>,
                                                  _: *mut libc::c_void)
                                 -> libc::c_int>,
    pub busy_timeout: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                  _: libc::c_int)
                                 -> libc::c_int>,
    pub changes: Option<unsafe extern "C" fn(_: *mut sqlite3) -> libc::c_int>,
    pub close: Option<unsafe extern "C" fn(_: *mut sqlite3) -> libc::c_int>,
    pub collation_needed: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                      _: *mut libc::c_void,
                                                      _:
                                                          Option<unsafe extern "C" fn(_:
                                                                                          *mut libc::c_void,
                                                                                      _:
                                                                                          *mut sqlite3,
                                                                                      _:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          *const libc::c_char)
                                                                     -> ()>)
                                     -> libc::c_int>,
    pub collation_needed16: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                        _: *mut libc::c_void,
                                                        _:
                                                            Option<unsafe extern "C" fn(_:
                                                                                            *mut libc::c_void,
                                                                                        _:
                                                                                            *mut sqlite3,
                                                                                        _:
                                                                                            libc::c_int,
                                                                                        _:
                                                                                            *const libc::c_void)
                                                                       -> ()>)
                                       -> libc::c_int>,
    pub column_blob: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                 _: libc::c_int)
                                -> *const libc::c_void>,
    pub column_bytes: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                  _: libc::c_int)
                                 -> libc::c_int>,
    pub column_bytes16: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                    _: libc::c_int)
                                   -> libc::c_int>,
    pub column_count: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                                 -> libc::c_int>,
    pub column_database_name: Option<unsafe extern "C" fn(_:
                                                              *mut sqlite3_stmt,
                                                          _: libc::c_int)
                                         -> *const libc::c_char>,
    pub column_database_name16: Option<unsafe extern "C" fn(_:
                                                                *mut sqlite3_stmt,
                                                            _: libc::c_int)
                                           -> *const libc::c_void>,
    pub column_decltype: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                     _: libc::c_int)
                                    -> *const libc::c_char>,
    pub column_decltype16: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                       _: libc::c_int)
                                      -> *const libc::c_void>,
    pub column_double: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                   _: libc::c_int)
                                  -> libc::c_double>,
    pub column_int: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                _: libc::c_int)
                               -> libc::c_int>,
    pub column_int64: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                  _: libc::c_int)
                                 -> sqlite_int64>,
    pub column_name: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                 _: libc::c_int)
                                -> *const libc::c_char>,
    pub column_name16: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                   _: libc::c_int)
                                  -> *const libc::c_void>,
    pub column_origin_name: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                        _: libc::c_int)
                                       -> *const libc::c_char>,
    pub column_origin_name16: Option<unsafe extern "C" fn(_:
                                                              *mut sqlite3_stmt,
                                                          _: libc::c_int)
                                         -> *const libc::c_void>,
    pub column_table_name: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                       _: libc::c_int)
                                      -> *const libc::c_char>,
    pub column_table_name16: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                         _: libc::c_int)
                                        -> *const libc::c_void>,
    pub column_text: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                 _: libc::c_int)
                                -> *const libc::c_uchar>,
    pub column_text16: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                   _: libc::c_int)
                                  -> *const libc::c_void>,
    pub column_type: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                 _: libc::c_int)
                                -> libc::c_int>,
    pub column_value: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                  _: libc::c_int)
                                 -> *mut sqlite3_value>,
    pub commit_hook: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                 _:
                                                     Option<unsafe extern "C" fn(_:
                                                                                     *mut libc::c_void)
                                                                ->
                                                                    libc::c_int>,
                                                 _: *mut libc::c_void)
                                -> *mut libc::c_void>,
    pub complete: Option<unsafe extern "C" fn(_: *const libc::c_char)
                             -> libc::c_int>,
    pub complete16: Option<unsafe extern "C" fn(_: *const libc::c_void)
                               -> libc::c_int>,
    pub create_collation: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                      _: *const libc::c_char,
                                                      _: libc::c_int,
                                                      _: *mut libc::c_void,
                                                      _:
                                                          Option<unsafe extern "C" fn(_:
                                                                                          *mut libc::c_void,
                                                                                      _:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          *const libc::c_void,
                                                                                      _:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          *const libc::c_void)
                                                                     ->
                                                                         libc::c_int>)
                                     -> libc::c_int>,
    pub create_collation16: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                        _:
                                                            *const libc::c_void,
                                                        _: libc::c_int,
                                                        _: *mut libc::c_void,
                                                        _:
                                                            Option<unsafe extern "C" fn(_:
                                                                                            *mut libc::c_void,
                                                                                        _:
                                                                                            libc::c_int,
                                                                                        _:
                                                                                            *const libc::c_void,
                                                                                        _:
                                                                                            libc::c_int,
                                                                                        _:
                                                                                            *const libc::c_void)
                                                                       ->
                                                                           libc::c_int>)
                                       -> libc::c_int>,
    pub create_function: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                     _: *const libc::c_char,
                                                     _: libc::c_int,
                                                     _: libc::c_int,
                                                     _: *mut libc::c_void,
                                                     _:
                                                         Option<unsafe extern "C" fn(_:
                                                                                         *mut sqlite3_context,
                                                                                     _:
                                                                                         libc::c_int,
                                                                                     _:
                                                                                         *mut *mut sqlite3_value)
                                                                    -> ()>,
                                                     _:
                                                         Option<unsafe extern "C" fn(_:
                                                                                         *mut sqlite3_context,
                                                                                     _:
                                                                                         libc::c_int,
                                                                                     _:
                                                                                         *mut *mut sqlite3_value)
                                                                    -> ()>,
                                                     _:
                                                         Option<unsafe extern "C" fn(_:
                                                                                         *mut sqlite3_context)
                                                                    -> ()>)
                                    -> libc::c_int>,
    pub create_function16: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                       _: *const libc::c_void,
                                                       _: libc::c_int,
                                                       _: libc::c_int,
                                                       _: *mut libc::c_void,
                                                       _:
                                                           Option<unsafe extern "C" fn(_:
                                                                                           *mut sqlite3_context,
                                                                                       _:
                                                                                           libc::c_int,
                                                                                       _:
                                                                                           *mut *mut sqlite3_value)
                                                                      -> ()>,
                                                       _:
                                                           Option<unsafe extern "C" fn(_:
                                                                                           *mut sqlite3_context,
                                                                                       _:
                                                                                           libc::c_int,
                                                                                       _:
                                                                                           *mut *mut sqlite3_value)
                                                                      -> ()>,
                                                       _:
                                                           Option<unsafe extern "C" fn(_:
                                                                                           *mut sqlite3_context)
                                                                      -> ()>)
                                      -> libc::c_int>,
    pub create_module: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                   _: *const libc::c_char,
                                                   _: *const sqlite3_module,
                                                   _: *mut libc::c_void)
                                  -> libc::c_int>,
    pub data_count: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                               -> libc::c_int>,
    pub db_handle: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                              -> *mut sqlite3>,
    pub declare_vtab: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                  _: *const libc::c_char)
                                 -> libc::c_int>,
    pub enable_shared_cache: Option<unsafe extern "C" fn(_: libc::c_int)
                                        -> libc::c_int>,
    pub errcode: Option<unsafe extern "C" fn(_: *mut sqlite3) -> libc::c_int>,
    pub errmsg: Option<unsafe extern "C" fn(_: *mut sqlite3)
                           -> *const libc::c_char>,
    pub errmsg16: Option<unsafe extern "C" fn(_: *mut sqlite3)
                             -> *const libc::c_void>,
    pub exec: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                          _: *const libc::c_char,
                                          _: sqlite3_callback,
                                          _: *mut libc::c_void,
                                          _: *mut *mut libc::c_char)
                         -> libc::c_int>,
    pub expired: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                            -> libc::c_int>,
    pub finalize: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                             -> libc::c_int>,
    pub free: Option<unsafe extern "C" fn(_: *mut libc::c_void) -> ()>,
    pub free_table: Option<unsafe extern "C" fn(_: *mut *mut libc::c_char)
                               -> ()>,
    pub get_autocommit: Option<unsafe extern "C" fn(_: *mut sqlite3)
                                   -> libc::c_int>,
    pub get_auxdata: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                 _: libc::c_int)
                                -> *mut libc::c_void>,
    pub get_table: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                               _: *const libc::c_char,
                                               _: *mut *mut *mut libc::c_char,
                                               _: *mut libc::c_int,
                                               _: *mut libc::c_int,
                                               _: *mut *mut libc::c_char)
                              -> libc::c_int>,
    pub global_recover: Option<unsafe extern "C" fn() -> libc::c_int>,
    pub interruptx: Option<unsafe extern "C" fn(_: *mut sqlite3) -> ()>,
    pub last_insert_rowid: Option<unsafe extern "C" fn(_: *mut sqlite3)
                                      -> sqlite_int64>,
    pub libversion: Option<unsafe extern "C" fn() -> *const libc::c_char>,
    pub libversion_number: Option<unsafe extern "C" fn() -> libc::c_int>,
    pub malloc: Option<unsafe extern "C" fn(_: libc::c_int)
                           -> *mut libc::c_void>,
    pub mprintf: Option<unsafe extern "C" fn(_: *const libc::c_char, _: ...)
                            -> *mut libc::c_char>,
    pub open: Option<unsafe extern "C" fn(_: *const libc::c_char,
                                          _: *mut *mut sqlite3)
                         -> libc::c_int>,
    pub open16: Option<unsafe extern "C" fn(_: *const libc::c_void,
                                            _: *mut *mut sqlite3)
                           -> libc::c_int>,
    pub prepare: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                             _: *const libc::c_char,
                                             _: libc::c_int,
                                             _: *mut *mut sqlite3_stmt,
                                             _: *mut *const libc::c_char)
                            -> libc::c_int>,
    pub prepare16: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                               _: *const libc::c_void,
                                               _: libc::c_int,
                                               _: *mut *mut sqlite3_stmt,
                                               _: *mut *const libc::c_void)
                              -> libc::c_int>,
    pub profile: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                             _:
                                                 Option<unsafe extern "C" fn(_:
                                                                                 *mut libc::c_void,
                                                                             _:
                                                                                 *const libc::c_char,
                                                                             _:
                                                                                 sqlite_uint64)
                                                            -> ()>,
                                             _: *mut libc::c_void)
                            -> *mut libc::c_void>,
    pub progress_handler: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                      _: libc::c_int,
                                                      _:
                                                          Option<unsafe extern "C" fn(_:
                                                                                          *mut libc::c_void)
                                                                     ->
                                                                         libc::c_int>,
                                                      _: *mut libc::c_void)
                                     -> ()>,
    pub realloc: Option<unsafe extern "C" fn(_: *mut libc::c_void,
                                             _: libc::c_int)
                            -> *mut libc::c_void>,
    pub reset: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                          -> libc::c_int>,
    pub result_blob: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                 _: *const libc::c_void,
                                                 _: libc::c_int,
                                                 _:
                                                     Option<unsafe extern "C" fn(_:
                                                                                     *mut libc::c_void)
                                                                -> ()>)
                                -> ()>,
    pub result_double: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                   _: libc::c_double) -> ()>,
    pub result_error: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                  _: *const libc::c_char,
                                                  _: libc::c_int) -> ()>,
    pub result_error16: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                    _: *const libc::c_void,
                                                    _: libc::c_int) -> ()>,
    pub result_int: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                _: libc::c_int) -> ()>,
    pub result_int64: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                  _: sqlite_int64) -> ()>,
    pub result_null: Option<unsafe extern "C" fn(_: *mut sqlite3_context)
                                -> ()>,
    pub result_text: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                 _: *const libc::c_char,
                                                 _: libc::c_int,
                                                 _:
                                                     Option<unsafe extern "C" fn(_:
                                                                                     *mut libc::c_void)
                                                                -> ()>)
                                -> ()>,
    pub result_text16: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                   _: *const libc::c_void,
                                                   _: libc::c_int,
                                                   _:
                                                       Option<unsafe extern "C" fn(_:
                                                                                       *mut libc::c_void)
                                                                  -> ()>)
                                  -> ()>,
    pub result_text16be: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                     _: *const libc::c_void,
                                                     _: libc::c_int,
                                                     _:
                                                         Option<unsafe extern "C" fn(_:
                                                                                         *mut libc::c_void)
                                                                    -> ()>)
                                    -> ()>,
    pub result_text16le: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                     _: *const libc::c_void,
                                                     _: libc::c_int,
                                                     _:
                                                         Option<unsafe extern "C" fn(_:
                                                                                         *mut libc::c_void)
                                                                    -> ()>)
                                    -> ()>,
    pub result_value: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                  _: *mut sqlite3_value)
                                 -> ()>,
    pub rollback_hook: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                   _:
                                                       Option<unsafe extern "C" fn(_:
                                                                                       *mut libc::c_void)
                                                                  -> ()>,
                                                   _: *mut libc::c_void)
                                  -> *mut libc::c_void>,
    pub set_authorizer: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                    _:
                                                        Option<unsafe extern "C" fn(_:
                                                                                        *mut libc::c_void,
                                                                                    _:
                                                                                        libc::c_int,
                                                                                    _:
                                                                                        *const libc::c_char,
                                                                                    _:
                                                                                        *const libc::c_char,
                                                                                    _:
                                                                                        *const libc::c_char,
                                                                                    _:
                                                                                        *const libc::c_char)
                                                                   ->
                                                                       libc::c_int>,
                                                    _: *mut libc::c_void)
                                   -> libc::c_int>,
    pub set_auxdata: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                 _: libc::c_int,
                                                 _: *mut libc::c_void,
                                                 _:
                                                     Option<unsafe extern "C" fn(_:
                                                                                     *mut libc::c_void)
                                                                -> ()>)
                                -> ()>,
    pub xsnprintf: Option<unsafe extern "C" fn(_: libc::c_int,
                                               _: *mut libc::c_char,
                                               _: *const libc::c_char, _: ...)
                              -> *mut libc::c_char>,
    pub step: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                         -> libc::c_int>,
    pub table_column_metadata: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                           _:
                                                               *const libc::c_char,
                                                           _:
                                                               *const libc::c_char,
                                                           _:
                                                               *const libc::c_char,
                                                           _:
                                                               *mut *const libc::c_char,
                                                           _:
                                                               *mut *const libc::c_char,
                                                           _:
                                                               *mut libc::c_int,
                                                           _:
                                                               *mut libc::c_int,
                                                           _:
                                                               *mut libc::c_int)
                                          -> libc::c_int>,
    pub thread_cleanup: Option<unsafe extern "C" fn() -> ()>,
    pub total_changes: Option<unsafe extern "C" fn(_: *mut sqlite3)
                                  -> libc::c_int>,
    pub trace: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                           _:
                                               Option<unsafe extern "C" fn(_:
                                                                               *mut libc::c_void,
                                                                           _:
                                                                               *const libc::c_char)
                                                          -> ()>,
                                           _: *mut libc::c_void)
                          -> *mut libc::c_void>,
    pub transfer_bindings: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                       _: *mut sqlite3_stmt)
                                      -> libc::c_int>,
    pub update_hook: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                 _:
                                                     Option<unsafe extern "C" fn(_:
                                                                                     *mut libc::c_void,
                                                                                 _:
                                                                                     libc::c_int,
                                                                                 _:
                                                                                     *const libc::c_char,
                                                                                 _:
                                                                                     *const libc::c_char,
                                                                                 _:
                                                                                     sqlite_int64)
                                                                -> ()>,
                                                 _: *mut libc::c_void)
                                -> *mut libc::c_void>,
    pub user_data: Option<unsafe extern "C" fn(_: *mut sqlite3_context)
                              -> *mut libc::c_void>,
    pub value_blob: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                               -> *const libc::c_void>,
    pub value_bytes: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                                -> libc::c_int>,
    pub value_bytes16: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                                  -> libc::c_int>,
    pub value_double: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                                 -> libc::c_double>,
    pub value_int: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                              -> libc::c_int>,
    pub value_int64: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                                -> sqlite_int64>,
    pub value_numeric_type: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                                       -> libc::c_int>,
    pub value_text: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                               -> *const libc::c_uchar>,
    pub value_text16: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                                 -> *const libc::c_void>,
    pub value_text16be: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                                   -> *const libc::c_void>,
    pub value_text16le: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                                   -> *const libc::c_void>,
    pub value_type: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                               -> libc::c_int>,
    pub vmprintf: Option<unsafe extern "C" fn(_: *const libc::c_char,
                                              _: ::std::ffi::VaList)
                             -> *mut libc::c_char>,
    pub overload_function: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                       _: *const libc::c_char,
                                                       _: libc::c_int)
                                      -> libc::c_int>,
    pub prepare_v2: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                _: *const libc::c_char,
                                                _: libc::c_int,
                                                _: *mut *mut sqlite3_stmt,
                                                _: *mut *const libc::c_char)
                               -> libc::c_int>,
    pub prepare16_v2: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                  _: *const libc::c_void,
                                                  _: libc::c_int,
                                                  _: *mut *mut sqlite3_stmt,
                                                  _: *mut *const libc::c_void)
                                 -> libc::c_int>,
    pub clear_bindings: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                                   -> libc::c_int>,
    pub create_module_v2: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                      _: *const libc::c_char,
                                                      _:
                                                          *const sqlite3_module,
                                                      _: *mut libc::c_void,
                                                      _:
                                                          Option<unsafe extern "C" fn(_:
                                                                                          *mut libc::c_void)
                                                                     -> ()>)
                                     -> libc::c_int>,
    pub bind_zeroblob: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                   _: libc::c_int,
                                                   _: libc::c_int)
                                  -> libc::c_int>,
    pub blob_bytes: Option<unsafe extern "C" fn(_: *mut sqlite3_blob)
                               -> libc::c_int>,
    pub blob_close: Option<unsafe extern "C" fn(_: *mut sqlite3_blob)
                               -> libc::c_int>,
    pub blob_open: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                               _: *const libc::c_char,
                                               _: *const libc::c_char,
                                               _: *const libc::c_char,
                                               _: sqlite3_int64,
                                               _: libc::c_int,
                                               _: *mut *mut sqlite3_blob)
                              -> libc::c_int>,
    pub blob_read: Option<unsafe extern "C" fn(_: *mut sqlite3_blob,
                                               _: *mut libc::c_void,
                                               _: libc::c_int, _: libc::c_int)
                              -> libc::c_int>,
    pub blob_write: Option<unsafe extern "C" fn(_: *mut sqlite3_blob,
                                                _: *const libc::c_void,
                                                _: libc::c_int,
                                                _: libc::c_int)
                               -> libc::c_int>,
    pub create_collation_v2: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                         _:
                                                             *const libc::c_char,
                                                         _: libc::c_int,
                                                         _: *mut libc::c_void,
                                                         _:
                                                             Option<unsafe extern "C" fn(_:
                                                                                             *mut libc::c_void,
                                                                                         _:
                                                                                             libc::c_int,
                                                                                         _:
                                                                                             *const libc::c_void,
                                                                                         _:
                                                                                             libc::c_int,
                                                                                         _:
                                                                                             *const libc::c_void)
                                                                        ->
                                                                            libc::c_int>,
                                                         _:
                                                             Option<unsafe extern "C" fn(_:
                                                                                             *mut libc::c_void)
                                                                        ->
                                                                            ()>)
                                        -> libc::c_int>,
    pub file_control: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                  _: *const libc::c_char,
                                                  _: libc::c_int,
                                                  _: *mut libc::c_void)
                                 -> libc::c_int>,
    pub memory_highwater: Option<unsafe extern "C" fn(_: libc::c_int)
                                     -> sqlite3_int64>,
    pub memory_used: Option<unsafe extern "C" fn() -> sqlite3_int64>,
    pub mutex_alloc: Option<unsafe extern "C" fn(_: libc::c_int)
                                -> *mut sqlite3_mutex>,
    pub mutex_enter: Option<unsafe extern "C" fn(_: *mut sqlite3_mutex)
                                -> ()>,
    pub mutex_free: Option<unsafe extern "C" fn(_: *mut sqlite3_mutex) -> ()>,
    pub mutex_leave: Option<unsafe extern "C" fn(_: *mut sqlite3_mutex)
                                -> ()>,
    pub mutex_try: Option<unsafe extern "C" fn(_: *mut sqlite3_mutex)
                              -> libc::c_int>,
    pub open_v2: Option<unsafe extern "C" fn(_: *const libc::c_char,
                                             _: *mut *mut sqlite3,
                                             _: libc::c_int,
                                             _: *const libc::c_char)
                            -> libc::c_int>,
    pub release_memory: Option<unsafe extern "C" fn(_: libc::c_int)
                                   -> libc::c_int>,
    pub result_error_nomem: Option<unsafe extern "C" fn(_:
                                                            *mut sqlite3_context)
                                       -> ()>,
    pub result_error_toobig: Option<unsafe extern "C" fn(_:
                                                             *mut sqlite3_context)
                                        -> ()>,
    pub sleep: Option<unsafe extern "C" fn(_: libc::c_int) -> libc::c_int>,
    pub soft_heap_limit: Option<unsafe extern "C" fn(_: libc::c_int) -> ()>,
    pub vfs_find: Option<unsafe extern "C" fn(_: *const libc::c_char)
                             -> *mut sqlite3_vfs>,
    pub vfs_register: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs,
                                                  _: libc::c_int)
                                 -> libc::c_int>,
    pub vfs_unregister: Option<unsafe extern "C" fn(_: *mut sqlite3_vfs)
                                   -> libc::c_int>,
    pub xthreadsafe: Option<unsafe extern "C" fn() -> libc::c_int>,
    pub result_zeroblob: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                     _: libc::c_int) -> ()>,
    pub result_error_code: Option<unsafe extern "C" fn(_:
                                                           *mut sqlite3_context,
                                                       _: libc::c_int) -> ()>,
    pub test_control: Option<unsafe extern "C" fn(_: libc::c_int, _: ...)
                                 -> libc::c_int>,
    pub randomness: Option<unsafe extern "C" fn(_: libc::c_int,
                                                _: *mut libc::c_void) -> ()>,
    pub context_db_handle: Option<unsafe extern "C" fn(_:
                                                           *mut sqlite3_context)
                                      -> *mut sqlite3>,
    pub extended_result_codes: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                           _: libc::c_int)
                                          -> libc::c_int>,
    pub limit: Option<unsafe extern "C" fn(_: *mut sqlite3, _: libc::c_int,
                                           _: libc::c_int) -> libc::c_int>,
    pub next_stmt: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                               _: *mut sqlite3_stmt)
                              -> *mut sqlite3_stmt>,
    pub sql: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                        -> *const libc::c_char>,
    pub status: Option<unsafe extern "C" fn(_: libc::c_int,
                                            _: *mut libc::c_int,
                                            _: *mut libc::c_int,
                                            _: libc::c_int) -> libc::c_int>,
    pub backup_finish: Option<unsafe extern "C" fn(_: *mut sqlite3_backup)
                                  -> libc::c_int>,
    pub backup_init: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                 _: *const libc::c_char,
                                                 _: *mut sqlite3,
                                                 _: *const libc::c_char)
                                -> *mut sqlite3_backup>,
    pub backup_pagecount: Option<unsafe extern "C" fn(_: *mut sqlite3_backup)
                                     -> libc::c_int>,
    pub backup_remaining: Option<unsafe extern "C" fn(_: *mut sqlite3_backup)
                                     -> libc::c_int>,
    pub backup_step: Option<unsafe extern "C" fn(_: *mut sqlite3_backup,
                                                 _: libc::c_int)
                                -> libc::c_int>,
    pub compileoption_get: Option<unsafe extern "C" fn(_: libc::c_int)
                                      -> *const libc::c_char>,
    pub compileoption_used: Option<unsafe extern "C" fn(_:
                                                            *const libc::c_char)
                                       -> libc::c_int>,
    pub create_function_v2: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                        _:
                                                            *const libc::c_char,
                                                        _: libc::c_int,
                                                        _: libc::c_int,
                                                        _: *mut libc::c_void,
                                                        _:
                                                            Option<unsafe extern "C" fn(_:
                                                                                            *mut sqlite3_context,
                                                                                        _:
                                                                                            libc::c_int,
                                                                                        _:
                                                                                            *mut *mut sqlite3_value)
                                                                       -> ()>,
                                                        _:
                                                            Option<unsafe extern "C" fn(_:
                                                                                            *mut sqlite3_context,
                                                                                        _:
                                                                                            libc::c_int,
                                                                                        _:
                                                                                            *mut *mut sqlite3_value)
                                                                       -> ()>,
                                                        _:
                                                            Option<unsafe extern "C" fn(_:
                                                                                            *mut sqlite3_context)
                                                                       -> ()>,
                                                        _:
                                                            Option<unsafe extern "C" fn(_:
                                                                                            *mut libc::c_void)
                                                                       -> ()>)
                                       -> libc::c_int>,
    pub db_config: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                               _: libc::c_int, _: ...)
                              -> libc::c_int>,
    pub db_mutex: Option<unsafe extern "C" fn(_: *mut sqlite3)
                             -> *mut sqlite3_mutex>,
    pub db_status: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                               _: libc::c_int,
                                               _: *mut libc::c_int,
                                               _: *mut libc::c_int,
                                               _: libc::c_int)
                              -> libc::c_int>,
    pub extended_errcode: Option<unsafe extern "C" fn(_: *mut sqlite3)
                                     -> libc::c_int>,
    pub log: Option<unsafe extern "C" fn(_: libc::c_int,
                                         _: *const libc::c_char, _: ...)
                        -> ()>,
    pub soft_heap_limit64: Option<unsafe extern "C" fn(_: sqlite3_int64)
                                      -> sqlite3_int64>,
    pub sourceid: Option<unsafe extern "C" fn() -> *const libc::c_char>,
    pub stmt_status: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                 _: libc::c_int,
                                                 _: libc::c_int)
                                -> libc::c_int>,
    pub strnicmp: Option<unsafe extern "C" fn(_: *const libc::c_char,
                                              _: *const libc::c_char,
                                              _: libc::c_int) -> libc::c_int>,
    pub unlock_notify: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                   _:
                                                       Option<unsafe extern "C" fn(_:
                                                                                       *mut *mut libc::c_void,
                                                                                   _:
                                                                                       libc::c_int)
                                                                  -> ()>,
                                                   _: *mut libc::c_void)
                                  -> libc::c_int>,
    pub wal_autocheckpoint: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                        _: libc::c_int)
                                       -> libc::c_int>,
    pub wal_checkpoint: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                    _: *const libc::c_char)
                                   -> libc::c_int>,
    pub wal_hook: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                              _:
                                                  Option<unsafe extern "C" fn(_:
                                                                                  *mut libc::c_void,
                                                                              _:
                                                                                  *mut sqlite3,
                                                                              _:
                                                                                  *const libc::c_char,
                                                                              _:
                                                                                  libc::c_int)
                                                             -> libc::c_int>,
                                              _: *mut libc::c_void)
                             -> *mut libc::c_void>,
    pub blob_reopen: Option<unsafe extern "C" fn(_: *mut sqlite3_blob,
                                                 _: sqlite3_int64)
                                -> libc::c_int>,
    pub vtab_config: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                 _: libc::c_int, _: ...)
                                -> libc::c_int>,
    pub vtab_on_conflict: Option<unsafe extern "C" fn(_: *mut sqlite3)
                                     -> libc::c_int>,
    pub close_v2: Option<unsafe extern "C" fn(_: *mut sqlite3)
                             -> libc::c_int>,
    pub db_filename: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                 _: *const libc::c_char)
                                -> *const libc::c_char>,
    pub db_readonly: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                 _: *const libc::c_char)
                                -> libc::c_int>,
    pub db_release_memory: Option<unsafe extern "C" fn(_: *mut sqlite3)
                                      -> libc::c_int>,
    pub errstr: Option<unsafe extern "C" fn(_: libc::c_int)
                           -> *const libc::c_char>,
    pub stmt_busy: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                              -> libc::c_int>,
    pub stmt_readonly: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                                  -> libc::c_int>,
    pub stricmp: Option<unsafe extern "C" fn(_: *const libc::c_char,
                                             _: *const libc::c_char)
                            -> libc::c_int>,
    pub uri_boolean: Option<unsafe extern "C" fn(_: *const libc::c_char,
                                                 _: *const libc::c_char,
                                                 _: libc::c_int)
                                -> libc::c_int>,
    pub uri_int64: Option<unsafe extern "C" fn(_: *const libc::c_char,
                                               _: *const libc::c_char,
                                               _: sqlite3_int64)
                              -> sqlite3_int64>,
    pub uri_parameter: Option<unsafe extern "C" fn(_: *const libc::c_char,
                                                   _: *const libc::c_char)
                                  -> *const libc::c_char>,
    pub xvsnprintf: Option<unsafe extern "C" fn(_: libc::c_int,
                                                _: *mut libc::c_char,
                                                _: *const libc::c_char,
                                                _: ::std::ffi::VaList)
                               -> *mut libc::c_char>,
    pub wal_checkpoint_v2: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                       _: *const libc::c_char,
                                                       _: libc::c_int,
                                                       _: *mut libc::c_int,
                                                       _: *mut libc::c_int)
                                      -> libc::c_int>,
    pub auto_extension: Option<unsafe extern "C" fn(_:
                                                        Option<unsafe extern "C" fn()
                                                                   -> ()>)
                                   -> libc::c_int>,
    pub bind_blob64: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                 _: libc::c_int,
                                                 _: *const libc::c_void,
                                                 _: sqlite3_uint64,
                                                 _:
                                                     Option<unsafe extern "C" fn(_:
                                                                                     *mut libc::c_void)
                                                                -> ()>)
                                -> libc::c_int>,
    pub bind_text64: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                 _: libc::c_int,
                                                 _: *const libc::c_char,
                                                 _: sqlite3_uint64,
                                                 _:
                                                     Option<unsafe extern "C" fn(_:
                                                                                     *mut libc::c_void)
                                                                -> ()>,
                                                 _: libc::c_uchar)
                                -> libc::c_int>,
    pub cancel_auto_extension: Option<unsafe extern "C" fn(_:
                                                               Option<unsafe extern "C" fn()
                                                                          ->
                                                                              ()>)
                                          -> libc::c_int>,
    pub load_extension: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                    _: *const libc::c_char,
                                                    _: *const libc::c_char,
                                                    _: *mut *mut libc::c_char)
                                   -> libc::c_int>,
    pub malloc64: Option<unsafe extern "C" fn(_: sqlite3_uint64)
                             -> *mut libc::c_void>,
    pub msize: Option<unsafe extern "C" fn(_: *mut libc::c_void)
                          -> sqlite3_uint64>,
    pub realloc64: Option<unsafe extern "C" fn(_: *mut libc::c_void,
                                               _: sqlite3_uint64)
                              -> *mut libc::c_void>,
    pub reset_auto_extension: Option<unsafe extern "C" fn() -> ()>,
    pub result_blob64: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                   _: *const libc::c_void,
                                                   _: sqlite3_uint64,
                                                   _:
                                                       Option<unsafe extern "C" fn(_:
                                                                                       *mut libc::c_void)
                                                                  -> ()>)
                                  -> ()>,
    pub result_text64: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                   _: *const libc::c_char,
                                                   _: sqlite3_uint64,
                                                   _:
                                                       Option<unsafe extern "C" fn(_:
                                                                                       *mut libc::c_void)
                                                                  -> ()>,
                                                   _: libc::c_uchar) -> ()>,
    pub strglob: Option<unsafe extern "C" fn(_: *const libc::c_char,
                                             _: *const libc::c_char)
                            -> libc::c_int>,
    pub value_dup: Option<unsafe extern "C" fn(_: *const sqlite3_value)
                              -> *mut sqlite3_value>,
    pub value_free: Option<unsafe extern "C" fn(_: *mut sqlite3_value) -> ()>,
    pub result_zeroblob64: Option<unsafe extern "C" fn(_:
                                                           *mut sqlite3_context,
                                                       _: sqlite3_uint64)
                                      -> libc::c_int>,
    pub bind_zeroblob64: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                     _: libc::c_int,
                                                     _: sqlite3_uint64)
                                    -> libc::c_int>,
    pub value_subtype: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                                  -> libc::c_uint>,
    pub result_subtype: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                    _: libc::c_uint) -> ()>,
    pub status64: Option<unsafe extern "C" fn(_: libc::c_int,
                                              _: *mut sqlite3_int64,
                                              _: *mut sqlite3_int64,
                                              _: libc::c_int) -> libc::c_int>,
    pub strlike: Option<unsafe extern "C" fn(_: *const libc::c_char,
                                             _: *const libc::c_char,
                                             _: libc::c_uint) -> libc::c_int>,
    pub db_cacheflush: Option<unsafe extern "C" fn(_: *mut sqlite3)
                                  -> libc::c_int>,
    pub system_errno: Option<unsafe extern "C" fn(_: *mut sqlite3)
                                 -> libc::c_int>,
    pub trace_v2: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                              _: libc::c_uint,
                                              _:
                                                  Option<unsafe extern "C" fn(_:
                                                                                  libc::c_uint,
                                                                              _:
                                                                                  *mut libc::c_void,
                                                                              _:
                                                                                  *mut libc::c_void,
                                                                              _:
                                                                                  *mut libc::c_void)
                                                             -> libc::c_int>,
                                              _: *mut libc::c_void)
                             -> libc::c_int>,
    pub expanded_sql: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                                 -> *mut libc::c_char>,
    pub set_last_insert_rowid: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                           _: sqlite3_int64)
                                          -> ()>,
    pub prepare_v3: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                _: *const libc::c_char,
                                                _: libc::c_int,
                                                _: libc::c_uint,
                                                _: *mut *mut sqlite3_stmt,
                                                _: *mut *const libc::c_char)
                               -> libc::c_int>,
    pub prepare16_v3: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                  _: *const libc::c_void,
                                                  _: libc::c_int,
                                                  _: libc::c_uint,
                                                  _: *mut *mut sqlite3_stmt,
                                                  _: *mut *const libc::c_void)
                                 -> libc::c_int>,
    pub bind_pointer: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt,
                                                  _: libc::c_int,
                                                  _: *mut libc::c_void,
                                                  _: *const libc::c_char,
                                                  _:
                                                      Option<unsafe extern "C" fn(_:
                                                                                      *mut libc::c_void)
                                                                 -> ()>)
                                 -> libc::c_int>,
    pub result_pointer: Option<unsafe extern "C" fn(_: *mut sqlite3_context,
                                                    _: *mut libc::c_void,
                                                    _: *const libc::c_char,
                                                    _:
                                                        Option<unsafe extern "C" fn(_:
                                                                                        *mut libc::c_void)
                                                                   -> ()>)
                                   -> ()>,
    pub value_pointer: Option<unsafe extern "C" fn(_: *mut sqlite3_value,
                                                   _: *const libc::c_char)
                                  -> *mut libc::c_void>,
    pub vtab_nochange: Option<unsafe extern "C" fn(_: *mut sqlite3_context)
                                  -> libc::c_int>,
    pub value_nochange: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                                   -> libc::c_int>,
    pub vtab_collation: Option<unsafe extern "C" fn(_:
                                                        *mut sqlite3_index_info,
                                                    _: libc::c_int)
                                   -> *const libc::c_char>,
    pub keyword_count: Option<unsafe extern "C" fn() -> libc::c_int>,
    pub keyword_name: Option<unsafe extern "C" fn(_: libc::c_int,
                                                  _: *mut *const libc::c_char,
                                                  _: *mut libc::c_int)
                                 -> libc::c_int>,
    pub keyword_check: Option<unsafe extern "C" fn(_: *const libc::c_char,
                                                   _: libc::c_int)
                                  -> libc::c_int>,
    pub str_new: Option<unsafe extern "C" fn(_: *mut sqlite3)
                            -> *mut sqlite3_str>,
    pub str_finish: Option<unsafe extern "C" fn(_: *mut sqlite3_str)
                               -> *mut libc::c_char>,
    pub str_appendf: Option<unsafe extern "C" fn(_: *mut sqlite3_str,
                                                 _: *const libc::c_char,
                                                 _: ...) -> ()>,
    pub str_vappendf: Option<unsafe extern "C" fn(_: *mut sqlite3_str,
                                                  _: *const libc::c_char,
                                                  _: ::std::ffi::VaList)
                                 -> ()>,
    pub str_append: Option<unsafe extern "C" fn(_: *mut sqlite3_str,
                                                _: *const libc::c_char,
                                                _: libc::c_int) -> ()>,
    pub str_appendall: Option<unsafe extern "C" fn(_: *mut sqlite3_str,
                                                   _: *const libc::c_char)
                                  -> ()>,
    pub str_appendchar: Option<unsafe extern "C" fn(_: *mut sqlite3_str,
                                                    _: libc::c_int,
                                                    _: libc::c_char) -> ()>,
    pub str_reset: Option<unsafe extern "C" fn(_: *mut sqlite3_str) -> ()>,
    pub str_errcode: Option<unsafe extern "C" fn(_: *mut sqlite3_str)
                                -> libc::c_int>,
    pub str_length: Option<unsafe extern "C" fn(_: *mut sqlite3_str)
                               -> libc::c_int>,
    pub str_value: Option<unsafe extern "C" fn(_: *mut sqlite3_str)
                              -> *mut libc::c_char>,
    pub create_window_function: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                            _:
                                                                *const libc::c_char,
                                                            _: libc::c_int,
                                                            _: libc::c_int,
                                                            _:
                                                                *mut libc::c_void,
                                                            _:
                                                                Option<unsafe extern "C" fn(_:
                                                                                                *mut sqlite3_context,
                                                                                            _:
                                                                                                libc::c_int,
                                                                                            _:
                                                                                                *mut *mut sqlite3_value)
                                                                           ->
                                                                               ()>,
                                                            _:
                                                                Option<unsafe extern "C" fn(_:
                                                                                                *mut sqlite3_context)
                                                                           ->
                                                                               ()>,
                                                            _:
                                                                Option<unsafe extern "C" fn(_:
                                                                                                *mut sqlite3_context)
                                                                           ->
                                                                               ()>,
                                                            _:
                                                                Option<unsafe extern "C" fn(_:
                                                                                                *mut sqlite3_context,
                                                                                            _:
                                                                                                libc::c_int,
                                                                                            _:
                                                                                                *mut *mut sqlite3_value)
                                                                           ->
                                                                               ()>,
                                                            _:
                                                                Option<unsafe extern "C" fn(_:
                                                                                                *mut libc::c_void)
                                                                           ->
                                                                               ()>)
                                           -> libc::c_int>,
    pub normalized_sql: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                                   -> *const libc::c_char>,
    pub stmt_isexplain: Option<unsafe extern "C" fn(_: *mut sqlite3_stmt)
                                   -> libc::c_int>,
    pub value_frombind: Option<unsafe extern "C" fn(_: *mut sqlite3_value)
                                   -> libc::c_int>,
    pub drop_modules: Option<unsafe extern "C" fn(_: *mut sqlite3,
                                                  _: *mut *const libc::c_char)
                                 -> libc::c_int>,
    pub hard_heap_limit64: Option<unsafe extern "C" fn(_: sqlite3_int64)
                                      -> sqlite3_int64>,
    pub uri_key: Option<unsafe extern "C" fn(_: *const libc::c_char,
                                             _: libc::c_int)
                            -> *const libc::c_char>,
    pub filename_database: Option<unsafe extern "C" fn(_: *const libc::c_char)
                                      -> *const libc::c_char>,
    pub filename_journal: Option<unsafe extern "C" fn(_: *const libc::c_char)
                                     -> *const libc::c_char>,
    pub filename_wal: Option<unsafe extern "C" fn(_: *const libc::c_char)
                                 -> *const libc::c_char>,
    pub create_filename: Option<unsafe extern "C" fn(_: *const libc::c_char,
                                                     _: *const libc::c_char,
                                                     _: *const libc::c_char,
                                                     _: libc::c_int,
                                                     _:
                                                         *mut *const libc::c_char)
                                    -> *mut libc::c_char>,
    pub free_filename: Option<unsafe extern "C" fn(_: *mut libc::c_char)
                                  -> ()>,
    pub database_file_object: Option<unsafe extern "C" fn(_:
                                                              *const libc::c_char)
                                         -> *mut sqlite3_file>,
}
pub type sqlite3_callback
    =
    Option<unsafe extern "C" fn(_: *mut libc::c_void, _: libc::c_int,
                                _: *mut *mut libc::c_char,
                                _: *mut *mut libc::c_char) -> libc::c_int>;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct FuncDefHash {
    pub a: [*mut FuncDef; 23],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WhereTerm {
    pub pExpr: *mut Expr,
    pub pWC: *mut WhereClause,
    pub truthProb: LogEst,
    pub wtFlags: u16_0,
    pub eOperator: u16_0,
    pub nChild: u8_0,
    pub eMatchOp: u8_0,
    pub iParent: libc::c_int,
    pub leftCursor: libc::c_int,
    pub iField: libc::c_int,
    pub u: C2RustUnnamed_12,
    pub prereqRight: Bitmask,
    pub prereqAll: Bitmask,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_12 {
    pub leftColumn: libc::c_int,
    pub pOrInfo: *mut WhereOrInfo,
    pub pAndInfo: *mut WhereAndInfo,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WhereAndInfo {
    pub wc: WhereClause,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WhereClause {
    pub pWInfo: *mut WhereInfo,
    pub pOuter: *mut WhereClause,
    pub op: u8_0,
    pub hasOr: u8_0,
    pub nTerm: libc::c_int,
    pub nSlot: libc::c_int,
    pub a: *mut WhereTerm,
    pub aStatic: [WhereTerm; 8],
}
#[derive(Copy, Clone, BitfieldStruct)]
#[repr(C)]
pub struct WhereInfo {
    pub pParse: *mut Parse,
    pub pTabList: *mut SrcList,
    pub pOrderBy: *mut ExprList,
    pub pResultSet: *mut ExprList,
    pub pWhere: *mut Expr,
    pub aiCurOnePass: [libc::c_int; 2],
    pub iContinue: libc::c_int,
    pub iBreak: libc::c_int,
    pub savedNQueryLoop: libc::c_int,
    pub wctrlFlags: u16_0,
    pub iLimit: LogEst,
    pub nLevel: u8_0,
    pub nOBSat: i8_0,
    pub eOnePass: u8_0,
    pub eDistinct: u8_0,
    #[bitfield(name = "bDeferredSeek", ty = "libc::c_uint", bits = "0..=0")]
    #[bitfield(name = "untestedTerms", ty = "libc::c_uint", bits = "1..=1")]
    #[bitfield(name = "bOrderedInnerLoop", ty = "libc::c_uint", bits =
               "2..=2")]
    #[bitfield(name = "sorted", ty = "libc::c_uint", bits = "3..=3")]
    pub bDeferredSeek_untestedTerms_bOrderedInnerLoop_sorted: [u8; 1],
    #[bitfield(padding)]
    pub c2rust_padding: [u8; 1],
    pub nRowOut: LogEst,
    pub iTop: libc::c_int,
    pub pLoops: *mut WhereLoop,
    pub pExprMods: *mut WhereExprMod,
    pub revMask: Bitmask,
    pub sWC: WhereClause,
    pub sMaskSet: WhereMaskSet,
    pub a: [WhereLevel; 1],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WhereLevel {
    pub iLeftJoin: libc::c_int,
    pub iTabCur: libc::c_int,
    pub iIdxCur: libc::c_int,
    pub addrBrk: libc::c_int,
    pub addrNxt: libc::c_int,
    pub addrSkip: libc::c_int,
    pub addrCont: libc::c_int,
    pub addrFirst: libc::c_int,
    pub addrBody: libc::c_int,
    pub regBignull: libc::c_int,
    pub addrBignull: libc::c_int,
    pub iLikeRepCntr: u32_0,
    pub addrLikeRep: libc::c_int,
    pub iFrom: u8_0,
    pub op: u8_0,
    pub p3: u8_0,
    pub p5: u8_0,
    pub p1: libc::c_int,
    pub p2: libc::c_int,
    pub u: C2RustUnnamed_16,
    pub pWLoop: *mut WhereLoop,
    pub notReady: Bitmask,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WhereLoop {
    pub prereq: Bitmask,
    pub maskSelf: Bitmask,
    pub iTab: u8_0,
    pub iSortIdx: u8_0,
    pub rSetup: LogEst,
    pub rRun: LogEst,
    pub nOut: LogEst,
    pub u: C2RustUnnamed_13,
    pub wsFlags: u32_0,
    pub nLTerm: u16_0,
    pub nSkip: u16_0,
    pub nLSlot: u16_0,
    pub aLTerm: *mut *mut WhereTerm,
    pub pNextLoop: *mut WhereLoop,
    pub aLTermSpace: [*mut WhereTerm; 3],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_13 {
    pub btree: C2RustUnnamed_15,
    pub vtab: C2RustUnnamed_14,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_14 {
    pub idxNum: libc::c_int,
    pub needFree: u8_0,
    pub isOrdered: i8_0,
    pub omitMask: u16_0,
    pub idxStr: *mut libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_15 {
    pub nEq: u16_0,
    pub nBtm: u16_0,
    pub nTop: u16_0,
    pub nDistinctCol: u16_0,
    pub pIndex: *mut Index,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_16 {
    pub in_0: C2RustUnnamed_17,
    pub pCovidx: *mut Index,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_17 {
    pub nIn: libc::c_int,
    pub aInLoop: *mut InLoop,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct InLoop {
    pub iCur: libc::c_int,
    pub addrInTop: libc::c_int,
    pub iBase: libc::c_int,
    pub nPrefix: libc::c_int,
    pub eEndLoopOp: u8_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WhereMaskSet {
    pub bVarSelect: libc::c_int,
    pub n: libc::c_int,
    pub ix: [libc::c_int; 64],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WhereExprMod {
    pub pNext: *mut WhereExprMod,
    pub pExpr: *mut Expr,
    pub orig: Expr,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WhereOrInfo {
    pub wc: WhereClause,
    pub indexable: Bitmask,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct HiddenIndexInfo {
    pub pWC: *mut WhereClause,
    pub pParse: *mut Parse,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WalWriter {
    pub pWal: *mut Wal,
    pub pFd: *mut sqlite3_file,
    pub iSyncPoint: sqlite3_int64,
    pub syncFlags: libc::c_int,
    pub szPage: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct yyParser {
    pub yytos: *mut yyStackEntry,
    pub pParse: *mut Parse,
    pub yystack: [yyStackEntry; 100],
    pub yystackEnd: *mut yyStackEntry,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct yyStackEntry {
    pub stateno: libc::c_ushort,
    pub major: libc::c_ushort,
    pub minor: YYMINORTYPE,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union YYMINORTYPE {
    pub yyinit: libc::c_int,
    pub yy0: Token,
    pub yy47: *mut SrcList,
    pub yy58: u8_0,
    pub yy77: FrameBound,
    pub yy131: *mut With,
    pub yy192: libc::c_int,
    pub yy202: *mut Expr,
    pub yy207: C2RustUnnamed_18,
    pub yy230: TrigEvent,
    pub yy242: *mut ExprList,
    pub yy303: *mut Window,
    pub yy318: *mut Upsert,
    pub yy436: *const libc::c_char,
    pub yy447: *mut TriggerStep,
    pub yy539: *mut Select,
    pub yy600: *mut IdList,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TrigEvent {
    pub a: libc::c_int,
    pub b: *mut IdList,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_18 {
    pub value: libc::c_int,
    pub mask: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct FrameBound {
    pub eType: libc::c_int,
    pub pExpr: *mut Expr,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Walker {
    pub pParse: *mut Parse,
    pub xExprCallback: Option<unsafe extern "C" fn(_: *mut Walker,
                                                   _: *mut Expr)
                                  -> libc::c_int>,
    pub xSelectCallback: Option<unsafe extern "C" fn(_: *mut Walker,
                                                     _: *mut Select)
                                    -> libc::c_int>,
    pub xSelectCallback2: Option<unsafe extern "C" fn(_: *mut Walker,
                                                      _: *mut Select) -> ()>,
    pub walkerDepth: libc::c_int,
    pub eCode: u16_0,
    pub u: C2RustUnnamed_19,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_19 {
    pub pNC: *mut NameContext,
    pub n: libc::c_int,
    pub iCur: libc::c_int,
    pub pSrcList: *mut SrcList,
    pub pSrcCount: *mut SrcCount,
    pub pCCurHint: *mut CCurHint,
    pub aiCol: *mut libc::c_int,
    pub pIdxCover: *mut IdxCover,
    pub pIdxTrans: *mut IdxExprTrans,
    pub pGroupBy: *mut ExprList,
    pub pSelect: *mut Select,
    pub pRewrite: *mut WindowRewrite,
    pub pConst: *mut WhereConst,
    pub pRename: *mut RenameCtx,
    pub pTab: *mut Table,
    pub pSrcItem: *mut SrcList_item,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct RenameCtx {
    pub pList: *mut RenameToken,
    pub nList: libc::c_int,
    pub iCol: libc::c_int,
    pub pTab: *mut Table,
    pub zOld: *const libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WhereConst {
    pub pParse: *mut Parse,
    pub nConst: libc::c_int,
    pub nChng: libc::c_int,
    pub apExpr: *mut *mut Expr,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WindowRewrite {
    pub pWin: *mut Window,
    pub pSrc: *mut SrcList,
    pub pSub: *mut ExprList,
    pub pTab: *mut Table,
    pub pSubSelect: *mut Select,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct IdxExprTrans {
    pub pIdxExpr: *mut Expr,
    pub iTabCur: libc::c_int,
    pub iIdxCur: libc::c_int,
    pub iIdxCol: libc::c_int,
    pub iTabCol: libc::c_int,
    pub pWInfo: *mut WhereInfo,
    pub db: *mut sqlite3,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct IdxCover {
    pub pIdx: *mut Index,
    pub iCur: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SrcCount {
    pub pSrc: *mut SrcList,
    pub iSrcInner: libc::c_int,
    pub nThis: libc::c_int,
    pub nOther: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct NameContext {
    pub pParse: *mut Parse,
    pub pSrcList: *mut SrcList,
    pub uNC: C2RustUnnamed_20,
    pub pNext: *mut NameContext,
    pub nRef: libc::c_int,
    pub nErr: libc::c_int,
    pub ncFlags: libc::c_int,
    pub pWinSelect: *mut Select,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_20 {
    pub pEList: *mut ExprList,
    pub pAggInfo: *mut AggInfo,
    pub pUpsert: *mut Upsert,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ValueNewStat4Ctx {
    pub pParse: *mut Parse,
    pub pIdx: *mut Index,
    pub ppRec: *mut *mut UnpackedRecord,
    pub iVal: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WindowUpdate {
    pub zFunc: *const libc::c_char,
    pub eFrmType: libc::c_int,
    pub eStart: libc::c_int,
    pub eEnd: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PragmaName {
    pub zName: *const libc::c_char,
    pub ePragTyp: u8_0,
    pub mPragFlg: u8_0,
    pub iPragCName: u8_0,
    pub nPragCName: u8_0,
    pub iArg: u64_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PragmaVtabCursor {
    pub base: sqlite3_vtab_cursor,
    pub pPragma: *mut sqlite3_stmt,
    pub iRowid: sqlite_int64,
    pub azArg: [*mut libc::c_char; 2],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PragmaVtab {
    pub base: sqlite3_vtab,
    pub db: *mut sqlite3,
    pub pName: *const PragmaName,
    pub nHidden: u8_0,
    pub iHidden: u8_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WalIterator {
    pub iPrior: libc::c_int,
    pub nSegment: libc::c_int,
    pub aSegment: [WalSegment; 1],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WalSegment {
    pub iNext: libc::c_int,
    pub aIndex: *mut ht_slot,
    pub aPgno: *mut u32_0,
    pub nEntry: libc::c_int,
    pub iZero: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Sublist {
    pub nList: libc::c_int,
    pub aList: *mut ht_slot,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct RowSet {
    pub pChunk: *mut RowSetChunk,
    pub db: *mut sqlite3,
    pub pEntry: *mut RowSetEntry,
    pub pLast: *mut RowSetEntry,
    pub pFresh: *mut RowSetEntry,
    pub pForest: *mut RowSetEntry,
    pub nFresh: u16_0,
    pub rsFlags: u16_0,
    pub iBatch: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct RowSetEntry {
    pub v: i64_0,
    pub pRight: *mut RowSetEntry,
    pub pLeft: *mut RowSetEntry,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct RowSetChunk {
    pub pNextChunk: *mut RowSetChunk,
    pub aEntry: [RowSetEntry; 42],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct IntegrityCk {
    pub pBt: *mut BtShared,
    pub pPager: *mut Pager,
    pub aPgRef: *mut u8_0,
    pub nPage: Pgno,
    pub mxErr: libc::c_int,
    pub nErr: libc::c_int,
    pub mallocFailed: libc::c_int,
    pub zPfx: *const libc::c_char,
    pub v1: libc::c_int,
    pub v2: libc::c_int,
    pub errMsg: StrAccum,
    pub heap: *mut u32_0,
    pub db: *mut sqlite3,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct analysisInfo {
    pub db: *mut sqlite3,
    pub zDatabase: *const libc::c_char,
}
pub type tRowcnt = u32_0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct InitData {
    pub db: *mut sqlite3,
    pub pzErrMsg: *mut *mut libc::c_char,
    pub iDb: libc::c_int,
    pub rc: libc::c_int,
    pub mInitFlags: u32_0,
    pub nInitRow: u32_0,
}
pub type RecordCompare
    =
    Option<unsafe extern "C" fn(_: libc::c_int, _: *const libc::c_void,
                                _: *mut UnpackedRecord) -> libc::c_int>;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CellArray {
    pub nCell: libc::c_int,
    pub pRef: *mut MemPage,
    pub apCell: *mut *mut u8_0,
    pub szCell: *mut u16_0,
    pub apEnd: [*mut u8_0; 6],
    pub ixNx: [libc::c_int; 6],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PmaWriter {
    pub eFWErr: libc::c_int,
    pub aBuffer: *mut u8_0,
    pub nBuffer: libc::c_int,
    pub iBufStart: libc::c_int,
    pub iBufEnd: libc::c_int,
    pub iWriteOff: i64_0,
    pub pFd: *mut sqlite3_file,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union pthread_attr_t {
    pub __size: [libc::c_char; 56],
    pub __align: libc::c_long,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct BtreePayload {
    pub pKey: *const libc::c_void,
    pub nKey: sqlite3_int64,
    pub pData: *const libc::c_void,
    pub aMem: *mut sqlite3_value,
    pub nMem: u16_0,
    pub nData: libc::c_int,
    pub nZero: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct StatAccum {
    pub db: *mut sqlite3,
    pub nEst: tRowcnt,
    pub nRow: tRowcnt,
    pub nLimit: libc::c_int,
    pub nCol: libc::c_int,
    pub nKeyCol: libc::c_int,
    pub nSkipAhead: u8_0,
    pub current: StatSample,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct StatSample {
    pub anEq: *mut tRowcnt,
    pub anDLt: *mut tRowcnt,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_21 {
    pub zName: *const libc::c_char,
    pub zCols: *const libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SelectDest {
    pub eDest: u8_0,
    pub iSDParm: libc::c_int,
    pub iSdst: libc::c_int,
    pub nSdst: libc::c_int,
    pub zAffSdst: *mut libc::c_char,
    pub pOrderBy: *mut ExprList,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SortCtx {
    pub pOrderBy: *mut ExprList,
    pub nOBSat: libc::c_int,
    pub iECursor: libc::c_int,
    pub regReturn: libc::c_int,
    pub labelBkOut: libc::c_int,
    pub addrSortIndex: libc::c_int,
    pub labelDone: libc::c_int,
    pub labelOBLopt: libc::c_int,
    pub sortFlags: u8_0,
    pub pDeferredRowLoad: *mut RowLoadInfo,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct RowLoadInfo {
    pub regResult: libc::c_int,
    pub ecelFlags: u8_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct DistinctCtx {
    pub isTnct: u8_0,
    pub eTnctType: u8_0,
    pub tabTnct: libc::c_int,
    pub addrTnct: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WhereScan {
    pub pOrigWC: *mut WhereClause,
    pub pWC: *mut WhereClause,
    pub zCollName: *const libc::c_char,
    pub pIdxExpr: *mut Expr,
    pub idxaff: libc::c_char,
    pub nEquiv: libc::c_uchar,
    pub iEquiv: libc::c_uchar,
    pub opMask: u32_0,
    pub k: libc::c_int,
    pub aiCur: [libc::c_int; 11],
    pub aiColumn: [i16_0; 11],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WhereLoopBuilder {
    pub pWInfo: *mut WhereInfo,
    pub pWC: *mut WhereClause,
    pub pOrderBy: *mut ExprList,
    pub pNew: *mut WhereLoop,
    pub pOrSet: *mut WhereOrSet,
    pub bldFlags1: libc::c_uchar,
    pub bldFlags2: libc::c_uchar,
    pub iPlanLimit: libc::c_uint,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WhereOrSet {
    pub n: u16_0,
    pub a: [WhereOrCost; 3],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WhereOrCost {
    pub prereq: Bitmask,
    pub rRun: LogEst,
    pub nOut: LogEst,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WherePath {
    pub maskLoop: Bitmask,
    pub revLoop: Bitmask,
    pub nRow: LogEst,
    pub rCost: LogEst,
    pub rUnsorted: LogEst,
    pub isOrdered: i8_0,
    pub aLoop: *mut *mut WhereLoop,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Op2 {
    pub zOp: *const libc::c_char,
    pub eOp2: libc::c_uchar,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WindowCsrAndReg {
    pub csr: libc::c_int,
    pub reg: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WindowCodeArg {
    pub pParse: *mut Parse,
    pub pMWin: *mut Window,
    pub pVdbe: *mut Vdbe,
    pub addrGosub: libc::c_int,
    pub regGosub: libc::c_int,
    pub regArg: libc::c_int,
    pub eDelete: libc::c_int,
    pub start: WindowCsrAndReg,
    pub current: WindowCsrAndReg,
    pub end: WindowCsrAndReg,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SubstContext {
    pub pParse: *mut Parse,
    pub iTable: libc::c_int,
    pub iNewTable: libc::c_int,
    pub isLeftJoin: libc::c_int,
    pub pEList: *mut ExprList,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct OpenMode {
    pub z: *const libc::c_char,
    pub mode: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct DbFixer {
    pub pParse: *mut Parse,
    pub pSchema: *mut Schema,
    pub bTemp: u8_0,
    pub zDb: *const libc::c_char,
    pub zType: *const libc::c_char,
    pub pName: *const Token,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct VdbeOpList {
    pub opcode: u8_0,
    pub p1: libc::c_schar,
    pub p2: libc::c_schar,
    pub p3: libc::c_schar,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct EncName {
    pub zName: *mut libc::c_char,
    pub enc: u8_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AuthContext {
    pub zAuthContext: *const libc::c_char,
    pub pParse: *mut Parse,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_22 {
    pub i: u8_0,
    pub nChar: u8_0,
    pub code: u8_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ReusableSpace {
    pub pSpace: *mut u8_0,
    pub nFree: sqlite3_int64,
    pub nNeeded: sqlite3_int64,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct sqlite3AutoExtList {
    pub nExt: u32_0,
    pub aExt: *mut Option<unsafe extern "C" fn() -> ()>,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Incrblob {
    pub nByte: libc::c_int,
    pub iOffset: libc::c_int,
    pub iCol: u16_0,
    pub pCsr: *mut BtCursor,
    pub pStmt: *mut sqlite3_stmt,
    pub db: *mut sqlite3,
    pub zDb: *mut libc::c_char,
    pub pTab: *mut Table,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_23 {
    pub op: libc::c_int,
    pub mask: u32_0,
}
pub type void_function = Option<unsafe extern "C" fn() -> ()>;
pub type TESTCALLBACKFUNC_t
    =
    Option<unsafe extern "C" fn(_: libc::c_int) -> libc::c_int>;
pub type sqlite3_loadext_entry
    =
    Option<unsafe extern "C" fn(_: *mut sqlite3, _: *mut *mut libc::c_char,
                                _: *const sqlite3_api_routines)
               -> libc::c_int>;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TabResult {
    pub azResult: *mut *mut libc::c_char,
    pub zErrMsg: *mut libc::c_char,
    pub nAlloc: u32_0,
    pub nRow: u32_0,
    pub nColumn: u32_0,
    pub nData: u32_0,
    pub rc: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct DateTime {
    pub iJD: sqlite3_int64,
    pub Y: libc::c_int,
    pub M: libc::c_int,
    pub D: libc::c_int,
    pub h: libc::c_int,
    pub m: libc::c_int,
    pub tz: libc::c_int,
    pub s: libc::c_double,
    pub validJD: libc::c_char,
    pub rawS: libc::c_char,
    pub validYMD: libc::c_char,
    pub validHMS: libc::c_char,
    pub validTZ: libc::c_char,
    pub tzSet: libc::c_char,
    pub isError: libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_24 {
    pub eType: u8_0,
    pub nName: u8_0,
    pub zName: *mut libc::c_char,
    pub rLimit: libc::c_double,
    pub rXform: libc::c_double,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct tm {
    pub tm_sec: libc::c_int,
    pub tm_min: libc::c_int,
    pub tm_hour: libc::c_int,
    pub tm_mday: libc::c_int,
    pub tm_mon: libc::c_int,
    pub tm_year: libc::c_int,
    pub tm_wday: libc::c_int,
    pub tm_yday: libc::c_int,
    pub tm_isdst: libc::c_int,
    pub tm_gmtoff: libc::c_long,
    pub tm_zone: *const libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct NthValueCtx {
    pub nStep: i64_0,
    pub pValue: *mut sqlite3_value,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct LastValueCtx {
    pub pVal: *mut sqlite3_value,
    pub nVal: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct NtileCtx {
    pub nTotal: i64_0,
    pub nParam: i64_0,
    pub iRow: i64_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CallCount {
    pub nValue: i64_0,
    pub nStep: i64_0,
    pub nTotal: i64_0,
}
pub type C2RustUnnamed_25 = libc::c_uint;
pub const PTHREAD_MUTEX_FAST_NP: C2RustUnnamed_25 = 0;
pub const PTHREAD_MUTEX_DEFAULT: C2RustUnnamed_25 = 0;
pub const PTHREAD_MUTEX_ERRORCHECK: C2RustUnnamed_25 = 2;
pub const PTHREAD_MUTEX_NORMAL: C2RustUnnamed_25 = 0;
pub const PTHREAD_MUTEX_ADAPTIVE_NP: C2RustUnnamed_25 = 3;
pub const PTHREAD_MUTEX_ERRORCHECK_NP: C2RustUnnamed_25 = 2;
pub const PTHREAD_MUTEX_RECURSIVE_NP: C2RustUnnamed_25 = 1;
pub const PTHREAD_MUTEX_TIMED_NP: C2RustUnnamed_25 = 0;
static mut sqlite3azCompileOpt: [*const libc::c_char; 2] =
    [b"COMPILER=gcc-8.3.0\x00" as *const u8 as *const libc::c_char,
     b"THREADSAFE=1\x00" as *const u8 as *const libc::c_char];
unsafe extern "C" fn sqlite3CompileOptions(mut pnOpt: *mut libc::c_int)
 -> *mut *const libc::c_char {
    *pnOpt =
        (::std::mem::size_of::<[*const libc::c_char; 2]>() as
             libc::c_ulong).wrapping_div(::std::mem::size_of::<*const libc::c_char>()
                                             as libc::c_ulong) as libc::c_int;
    return sqlite3azCompileOpt.as_ptr() as *mut *const libc::c_char;
}
#[no_mangle]
pub static mut sqlite3_version: [libc::c_char; 7] =
    [51, 46, 51, 50, 46, 51, 0];
static mut sqlite3UpperToLower: [libc::c_uchar; 256] =
    [0 as libc::c_int as libc::c_uchar, 1 as libc::c_int as libc::c_uchar,
     2 as libc::c_int as libc::c_uchar, 3 as libc::c_int as libc::c_uchar,
     4 as libc::c_int as libc::c_uchar, 5 as libc::c_int as libc::c_uchar,
     6 as libc::c_int as libc::c_uchar, 7 as libc::c_int as libc::c_uchar,
     8 as libc::c_int as libc::c_uchar, 9 as libc::c_int as libc::c_uchar,
     10 as libc::c_int as libc::c_uchar, 11 as libc::c_int as libc::c_uchar,
     12 as libc::c_int as libc::c_uchar, 13 as libc::c_int as libc::c_uchar,
     14 as libc::c_int as libc::c_uchar, 15 as libc::c_int as libc::c_uchar,
     16 as libc::c_int as libc::c_uchar, 17 as libc::c_int as libc::c_uchar,
     18 as libc::c_int as libc::c_uchar, 19 as libc::c_int as libc::c_uchar,
     20 as libc::c_int as libc::c_uchar, 21 as libc::c_int as libc::c_uchar,
     22 as libc::c_int as libc::c_uchar, 23 as libc::c_int as libc::c_uchar,
     24 as libc::c_int as libc::c_uchar, 25 as libc::c_int as libc::c_uchar,
     26 as libc::c_int as libc::c_uchar, 27 as libc::c_int as libc::c_uchar,
     28 as libc::c_int as libc::c_uchar, 29 as libc::c_int as libc::c_uchar,
     30 as libc::c_int as libc::c_uchar, 31 as libc::c_int as libc::c_uchar,
     32 as libc::c_int as libc::c_uchar, 33 as libc::c_int as libc::c_uchar,
     34 as libc::c_int as libc::c_uchar, 35 as libc::c_int as libc::c_uchar,
     36 as libc::c_int as libc::c_uchar, 37 as libc::c_int as libc::c_uchar,
     38 as libc::c_int as libc::c_uchar, 39 as libc::c_int as libc::c_uchar,
     40 as libc::c_int as libc::c_uchar, 41 as libc::c_int as libc::c_uchar,
     42 as libc::c_int as libc::c_uchar, 43 as libc::c_int as libc::c_uchar,
     44 as libc::c_int as libc::c_uchar, 45 as libc::c_int as libc::c_uchar,
     46 as libc::c_int as libc::c_uchar, 47 as libc::c_int as libc::c_uchar,
     48 as libc::c_int as libc::c_uchar, 49 as libc::c_int as libc::c_uchar,
     50 as libc::c_int as libc::c_uchar, 51 as libc::c_int as libc::c_uchar,
     52 as libc::c_int as libc::c_uchar, 53 as libc::c_int as libc::c_uchar,
     54 as libc::c_int as libc::c_uchar, 55 as libc::c_int as libc::c_uchar,
     56 as libc::c_int as libc::c_uchar, 57 as libc::c_int as libc::c_uchar,
     58 as libc::c_int as libc::c_uchar, 59 as libc::c_int as libc::c_uchar,
     60 as libc::c_int as libc::c_uchar, 61 as libc::c_int as libc::c_uchar,
     62 as libc::c_int as libc::c_uchar, 63 as libc::c_int as libc::c_uchar,
     64 as libc::c_int as libc::c_uchar, 97 as libc::c_int as libc::c_uchar,
     98 as libc::c_int as libc::c_uchar, 99 as libc::c_int as libc::c_uchar,
     100 as libc::c_int as libc::c_uchar, 101 as libc::c_int as libc::c_uchar,
     102 as libc::c_int as libc::c_uchar, 103 as libc::c_int as libc::c_uchar,
     104 as libc::c_int as libc::c_uchar, 105 as libc::c_int as libc::c_uchar,
     106 as libc::c_int as libc::c_uchar, 107 as libc::c_int as libc::c_uchar,
     108 as libc::c_int as libc::c_uchar, 109 as libc::c_int as libc::c_uchar,
     110 as libc::c_int as libc::c_uchar, 111 as libc::c_int as libc::c_uchar,
     112 as libc::c_int as libc::c_uchar, 113 as libc::c_int as libc::c_uchar,
     114 as libc::c_int as libc::c_uchar, 115 as libc::c_int as libc::c_uchar,
     116 as libc::c_int as libc::c_uchar, 117 as libc::c_int as libc::c_uchar,
     118 as libc::c_int as libc::c_uchar, 119 as libc::c_int as libc::c_uchar,
     120 as libc::c_int as libc::c_uchar, 121 as libc::c_int as libc::c_uchar,
     122 as libc::c_int as libc::c_uchar, 91 as libc::c_int as libc::c_uchar,
     92 as libc::c_int as libc::c_uchar, 93 as libc::c_int as libc::c_uchar,
     94 as libc::c_int as libc::c_uchar, 95 as libc::c_int as libc::c_uchar,
     96 as libc::c_int as libc::c_uchar, 97 as libc::c_int as libc::c_uchar,
     98 as libc::c_int as libc::c_uchar, 99 as libc::c_int as libc::c_uchar,
     100 as libc::c_int as libc::c_uchar, 101 as libc::c_int as libc::c_uchar,
     102 as libc::c_int as libc::c_uchar, 103 as libc::c_int as libc::c_uchar,
     104 as libc::c_int as libc::c_uchar, 105 as libc::c_int as libc::c_uchar,
     106 as libc::c_int as libc::c_uchar, 107 as libc::c_int as libc::c_uchar,
     108 as libc::c_int as libc::c_uchar, 109 as libc::c_int as libc::c_uchar,
     110 as libc::c_int as libc::c_uchar, 111 as libc::c_int as libc::c_uchar,
     112 as libc::c_int as libc::c_uchar, 113 as libc::c_int as libc::c_uchar,
     114 as libc::c_int as libc::c_uchar, 115 as libc::c_int as libc::c_uchar,
     116 as libc::c_int as libc::c_uchar, 117 as libc::c_int as libc::c_uchar,
     118 as libc::c_int as libc::c_uchar, 119 as libc::c_int as libc::c_uchar,
     120 as libc::c_int as libc::c_uchar, 121 as libc::c_int as libc::c_uchar,
     122 as libc::c_int as libc::c_uchar, 123 as libc::c_int as libc::c_uchar,
     124 as libc::c_int as libc::c_uchar, 125 as libc::c_int as libc::c_uchar,
     126 as libc::c_int as libc::c_uchar, 127 as libc::c_int as libc::c_uchar,
     128 as libc::c_int as libc::c_uchar, 129 as libc::c_int as libc::c_uchar,
     130 as libc::c_int as libc::c_uchar, 131 as libc::c_int as libc::c_uchar,
     132 as libc::c_int as libc::c_uchar, 133 as libc::c_int as libc::c_uchar,
     134 as libc::c_int as libc::c_uchar, 135 as libc::c_int as libc::c_uchar,
     136 as libc::c_int as libc::c_uchar, 137 as libc::c_int as libc::c_uchar,
     138 as libc::c_int as libc::c_uchar, 139 as libc::c_int as libc::c_uchar,
     140 as libc::c_int as libc::c_uchar, 141 as libc::c_int as libc::c_uchar,
     142 as libc::c_int as libc::c_uchar, 143 as libc::c_int as libc::c_uchar,
     144 as libc::c_int as libc::c_uchar, 145 as libc::c_int as libc::c_uchar,
     146 as libc::c_int as libc::c_uchar, 147 as libc::c_int as libc::c_uchar,
     148 as libc::c_int as libc::c_uchar, 149 as libc::c_int as libc::c_uchar,
     150 as libc::c_int as libc::c_uchar, 151 as libc::c_int as libc::c_uchar,
     152 as libc::c_int as libc::c_uchar, 153 as libc::c_int as libc::c_uchar,
     154 as libc::c_int as libc::c_uchar, 155 as libc::c_int as libc::c_uchar,
     156 as libc::c_int as libc::c_uchar, 157 as libc::c_int as libc::c_uchar,
     158 as libc::c_int as libc::c_uchar, 159 as libc::c_int as libc::c_uchar,
     160 as libc::c_int as libc::c_uchar, 161 as libc::c_int as libc::c_uchar,
     162 as libc::c_int as libc::c_uchar, 163 as libc::c_int as libc::c_uchar,
     164 as libc::c_int as libc::c_uchar, 165 as libc::c_int as libc::c_uchar,
     166 as libc::c_int as libc::c_uchar, 167 as libc::c_int as libc::c_uchar,
     168 as libc::c_int as libc::c_uchar, 169 as libc::c_int as libc::c_uchar,
     170 as libc::c_int as libc::c_uchar, 171 as libc::c_int as libc::c_uchar,
     172 as libc::c_int as libc::c_uchar, 173 as libc::c_int as libc::c_uchar,
     174 as libc::c_int as libc::c_uchar, 175 as libc::c_int as libc::c_uchar,
     176 as libc::c_int as libc::c_uchar, 177 as libc::c_int as libc::c_uchar,
     178 as libc::c_int as libc::c_uchar, 179 as libc::c_int as libc::c_uchar,
     180 as libc::c_int as libc::c_uchar, 181 as libc::c_int as libc::c_uchar,
     182 as libc::c_int as libc::c_uchar, 183 as libc::c_int as libc::c_uchar,
     184 as libc::c_int as libc::c_uchar, 185 as libc::c_int as libc::c_uchar,
     186 as libc::c_int as libc::c_uchar, 187 as libc::c_int as libc::c_uchar,
     188 as libc::c_int as libc::c_uchar, 189 as libc::c_int as libc::c_uchar,
     190 as libc::c_int as libc::c_uchar, 191 as libc::c_int as libc::c_uchar,
     192 as libc::c_int as libc::c_uchar, 193 as libc::c_int as libc::c_uchar,
     194 as libc::c_int as libc::c_uchar, 195 as libc::c_int as libc::c_uchar,
     196 as libc::c_int as libc::c_uchar, 197 as libc::c_int as libc::c_uchar,
     198 as libc::c_int as libc::c_uchar, 199 as libc::c_int as libc::c_uchar,
     200 as libc::c_int as libc::c_uchar, 201 as libc::c_int as libc::c_uchar,
     202 as libc::c_int as libc::c_uchar, 203 as libc::c_int as libc::c_uchar,
     204 as libc::c_int as libc::c_uchar, 205 as libc::c_int as libc::c_uchar,
     206 as libc::c_int as libc::c_uchar, 207 as libc::c_int as libc::c_uchar,
     208 as libc::c_int as libc::c_uchar, 209 as libc::c_int as libc::c_uchar,
     210 as libc::c_int as libc::c_uchar, 211 as libc::c_int as libc::c_uchar,
     212 as libc::c_int as libc::c_uchar, 213 as libc::c_int as libc::c_uchar,
     214 as libc::c_int as libc::c_uchar, 215 as libc::c_int as libc::c_uchar,
     216 as libc::c_int as libc::c_uchar, 217 as libc::c_int as libc::c_uchar,
     218 as libc::c_int as libc::c_uchar, 219 as libc::c_int as libc::c_uchar,
     220 as libc::c_int as libc::c_uchar, 221 as libc::c_int as libc::c_uchar,
     222 as libc::c_int as libc::c_uchar, 223 as libc::c_int as libc::c_uchar,
     224 as libc::c_int as libc::c_uchar, 225 as libc::c_int as libc::c_uchar,
     226 as libc::c_int as libc::c_uchar, 227 as libc::c_int as libc::c_uchar,
     228 as libc::c_int as libc::c_uchar, 229 as libc::c_int as libc::c_uchar,
     230 as libc::c_int as libc::c_uchar, 231 as libc::c_int as libc::c_uchar,
     232 as libc::c_int as libc::c_uchar, 233 as libc::c_int as libc::c_uchar,
     234 as libc::c_int as libc::c_uchar, 235 as libc::c_int as libc::c_uchar,
     236 as libc::c_int as libc::c_uchar, 237 as libc::c_int as libc::c_uchar,
     238 as libc::c_int as libc::c_uchar, 239 as libc::c_int as libc::c_uchar,
     240 as libc::c_int as libc::c_uchar, 241 as libc::c_int as libc::c_uchar,
     242 as libc::c_int as libc::c_uchar, 243 as libc::c_int as libc::c_uchar,
     244 as libc::c_int as libc::c_uchar, 245 as libc::c_int as libc::c_uchar,
     246 as libc::c_int as libc::c_uchar, 247 as libc::c_int as libc::c_uchar,
     248 as libc::c_int as libc::c_uchar, 249 as libc::c_int as libc::c_uchar,
     250 as libc::c_int as libc::c_uchar, 251 as libc::c_int as libc::c_uchar,
     252 as libc::c_int as libc::c_uchar, 253 as libc::c_int as libc::c_uchar,
     254 as libc::c_int as libc::c_uchar,
     255 as libc::c_int as libc::c_uchar];
static mut sqlite3CtypeMap: [libc::c_uchar; 256] =
    [0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x80 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0x80 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0xc as libc::c_int as libc::c_uchar, 0xc as libc::c_int as libc::c_uchar,
     0xc as libc::c_int as libc::c_uchar, 0xc as libc::c_int as libc::c_uchar,
     0xc as libc::c_int as libc::c_uchar, 0xc as libc::c_int as libc::c_uchar,
     0xc as libc::c_int as libc::c_uchar, 0xc as libc::c_int as libc::c_uchar,
     0xc as libc::c_int as libc::c_uchar, 0xc as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0xa as libc::c_int as libc::c_uchar,
     0xa as libc::c_int as libc::c_uchar, 0xa as libc::c_int as libc::c_uchar,
     0xa as libc::c_int as libc::c_uchar, 0xa as libc::c_int as libc::c_uchar,
     0xa as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x2 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x2 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x2 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x2 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x2 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x2 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x2 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x2 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x2 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x2 as libc::c_int as libc::c_uchar,
     0x80 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x80 as libc::c_int as libc::c_uchar,
     0x2a as libc::c_int as libc::c_uchar,
     0x2a as libc::c_int as libc::c_uchar,
     0x2a as libc::c_int as libc::c_uchar,
     0x2a as libc::c_int as libc::c_uchar,
     0x2a as libc::c_int as libc::c_uchar,
     0x2a as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar,
     0x22 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar,
     0x40 as libc::c_int as libc::c_uchar];
static mut sqlite3Config: Sqlite3Config =
    {
        let mut init =
            Sqlite3Config{bMemstat: 1 as libc::c_int,
                          bCoreMutex: 1 as libc::c_int as u8_0,
                          bFullMutex:
                              (1 as libc::c_int == 1 as libc::c_int) as
                                  libc::c_int as u8_0,
                          bOpenUri: 0 as libc::c_int as u8_0,
                          bUseCis: 1 as libc::c_int as u8_0,
                          bSmallMalloc: 0 as libc::c_int as u8_0,
                          bExtraSchemaChecks: 1 as libc::c_int as u8_0,
                          mxStrlen: 0x7ffffffe as libc::c_int,
                          neverCorrupt: 0 as libc::c_int,
                          szLookaside: 1200 as libc::c_int,
                          nLookaside: 40 as libc::c_int,
                          nStmtSpill: 64 as libc::c_int * 1024 as libc::c_int,
                          m:
                              {
                                  let mut init =
                                      sqlite3_mem_methods{xMalloc: None,
                                                          xFree: None,
                                                          xRealloc: None,
                                                          xSize: None,
                                                          xRoundup: None,
                                                          xInit: None,
                                                          xShutdown: None,
                                                          pAppData:
                                                              0 as
                                                                  *const libc::c_void
                                                                  as
                                                                  *mut libc::c_void,};
                                  init
                              },
                          mutex:
                              {
                                  let mut init =
                                      sqlite3_mutex_methods{xMutexInit: None,
                                                            xMutexEnd: None,
                                                            xMutexAlloc: None,
                                                            xMutexFree: None,
                                                            xMutexEnter: None,
                                                            xMutexTry: None,
                                                            xMutexLeave: None,
                                                            xMutexHeld: None,
                                                            xMutexNotheld:
                                                                None,};
                                  init
                              },
                          pcache2:
                              {
                                  let mut init =
                                      sqlite3_pcache_methods2{iVersion:
                                                                  0 as
                                                                      libc::c_int,
                                                              pArg:
                                                                  0 as
                                                                      *const libc::c_void
                                                                      as
                                                                      *mut libc::c_void,
                                                              xInit: None,
                                                              xShutdown: None,
                                                              xCreate: None,
                                                              xCachesize:
                                                                  None,
                                                              xPagecount:
                                                                  None,
                                                              xFetch: None,
                                                              xUnpin: None,
                                                              xRekey: None,
                                                              xTruncate: None,
                                                              xDestroy: None,
                                                              xShrink: None,};
                                  init
                              },
                          pHeap:
                              0 as *const libc::c_void as *mut libc::c_void,
                          nHeap: 0 as libc::c_int,
                          mnReq: 0 as libc::c_int,
                          mxReq: 0 as libc::c_int,
                          szMmap: 0 as libc::c_int as sqlite3_int64,
                          mxMmap: 0x7fff0000 as libc::c_int as sqlite3_int64,
                          pPage:
                              0 as *const libc::c_void as *mut libc::c_void,
                          szPage: 0 as libc::c_int,
                          nPage: 20 as libc::c_int,
                          mxParserStack: 0 as libc::c_int,
                          sharedCacheEnabled: 0 as libc::c_int,
                          szPma: 250 as libc::c_int as u32_0,
                          isInit: 0 as libc::c_int,
                          inProgress: 0 as libc::c_int,
                          isMutexInit: 0 as libc::c_int,
                          isMallocInit: 0 as libc::c_int,
                          isPCacheInit: 0 as libc::c_int,
                          nRefInitMutex: 0 as libc::c_int,
                          pInitMutex:
                              0 as *const sqlite3_mutex as *mut sqlite3_mutex,
                          xLog: None,
                          pLogArg:
                              0 as *const libc::c_void as *mut libc::c_void,
                          xTestCallback: None,
                          bLocaltimeFault: 0 as libc::c_int,
                          iOnceResetThreshold: 0x7ffffffe as libc::c_int,
                          szSorterRef: 0x7fffffff as libc::c_int as u32_0,
                          iPrngSeed: 0 as libc::c_int as libc::c_uint,};
        init
    };
static mut sqlite3BuiltinFunctions: FuncDefHash =
    FuncDefHash{a: [0 as *const FuncDef as *mut FuncDef; 23],};
static mut sqlite3PendingByte: libc::c_int = 0x40000000 as libc::c_int;
static mut sqlite3OpcodeProperty: [libc::c_uchar; 176] =
    [0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0x10 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x3 as libc::c_int as libc::c_uchar, 0x3 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x3 as libc::c_int as libc::c_uchar,
     0x12 as libc::c_int as libc::c_uchar,
     0x3 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x9 as libc::c_int as libc::c_uchar, 0x9 as libc::c_int as libc::c_uchar,
     0x9 as libc::c_int as libc::c_uchar, 0x9 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x9 as libc::c_int as libc::c_uchar,
     0x9 as libc::c_int as libc::c_uchar, 0x9 as libc::c_int as libc::c_uchar,
     0x9 as libc::c_int as libc::c_uchar, 0x9 as libc::c_int as libc::c_uchar,
     0x9 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x23 as libc::c_int as libc::c_uchar,
     0x26 as libc::c_int as libc::c_uchar,
     0x26 as libc::c_int as libc::c_uchar,
     0xb as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x3 as libc::c_int as libc::c_uchar,
     0x3 as libc::c_int as libc::c_uchar, 0x3 as libc::c_int as libc::c_uchar,
     0x3 as libc::c_int as libc::c_uchar, 0xb as libc::c_int as libc::c_uchar,
     0xb as libc::c_int as libc::c_uchar, 0xb as libc::c_int as libc::c_uchar,
     0xb as libc::c_int as libc::c_uchar, 0xb as libc::c_int as libc::c_uchar,
     0xb as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x3 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x2 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x8 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0x10 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x2 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x12 as libc::c_int as libc::c_uchar,
     0x20 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x26 as libc::c_int as libc::c_uchar,
     0x26 as libc::c_int as libc::c_uchar,
     0x26 as libc::c_int as libc::c_uchar,
     0x26 as libc::c_int as libc::c_uchar,
     0x26 as libc::c_int as libc::c_uchar,
     0x26 as libc::c_int as libc::c_uchar,
     0x26 as libc::c_int as libc::c_uchar,
     0x26 as libc::c_int as libc::c_uchar,
     0x26 as libc::c_int as libc::c_uchar,
     0x26 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x12 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0x10 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0x10 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0x10 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x4 as libc::c_int as libc::c_uchar, 0x4 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0x10 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0x6 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar,
     0x4 as libc::c_int as libc::c_uchar,
     0x1a as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar];
static mut sqlite3StrBINARY: [libc::c_char; 7] = [66, 73, 78, 65, 82, 89, 0];
static mut sqlite3Stat: sqlite3StatType =
    {
        let mut init =
            sqlite3StatType{nowValue:
                                [0 as libc::c_int as sqlite3StatValueType, 0,
                                 0, 0, 0, 0, 0, 0, 0, 0],
                            mxValue:
                                [0 as libc::c_int as sqlite3StatValueType, 0,
                                 0, 0, 0, 0, 0, 0, 0, 0],};
        init
    };
static mut statMutex: [libc::c_char; 10] =
    [0 as libc::c_int as libc::c_char, 1 as libc::c_int as libc::c_char,
     1 as libc::c_int as libc::c_char, 0 as libc::c_int as libc::c_char,
     0 as libc::c_int as libc::c_char, 0 as libc::c_int as libc::c_char,
     0 as libc::c_int as libc::c_char, 1 as libc::c_int as libc::c_char,
     0 as libc::c_int as libc::c_char, 0 as libc::c_int as libc::c_char];
unsafe extern "C" fn sqlite3StatusValue(mut op: libc::c_int)
 -> sqlite3_int64 {
    return sqlite3Stat.nowValue[op as usize];
}
unsafe extern "C" fn sqlite3StatusUp(mut op: libc::c_int,
                                     mut N: libc::c_int) {
    sqlite3Stat.nowValue[op as usize] += N as libc::c_longlong;
    if sqlite3Stat.nowValue[op as usize] > sqlite3Stat.mxValue[op as usize] {
        sqlite3Stat.mxValue[op as usize] = sqlite3Stat.nowValue[op as usize]
    };
}
unsafe extern "C" fn sqlite3StatusDown(mut op: libc::c_int,
                                       mut N: libc::c_int) {
    sqlite3Stat.nowValue[op as usize] -= N as libc::c_longlong;
}
unsafe extern "C" fn sqlite3StatusHighwater(mut op: libc::c_int,
                                            mut X: libc::c_int) {
    let mut newValue: sqlite3StatValueType = 0;
    newValue = X as sqlite3StatValueType;
    if newValue > sqlite3Stat.mxValue[op as usize] {
        sqlite3Stat.mxValue[op as usize] = newValue
    };
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_status64(mut op: libc::c_int,
                                          mut pCurrent: *mut sqlite3_int64,
                                          mut pHighwater: *mut sqlite3_int64,
                                          mut resetFlag: libc::c_int)
 -> libc::c_int {
    let mut pMutex: *mut sqlite3_mutex = 0 as *mut sqlite3_mutex;
    if op < 0 as libc::c_int ||
           op >=
               (::std::mem::size_of::<[sqlite3StatValueType; 10]>() as
                    libc::c_ulong).wrapping_div(::std::mem::size_of::<sqlite3StatValueType>()
                                                    as libc::c_ulong) as
                   libc::c_int {
        return sqlite3MisuseError(21416 as libc::c_int)
    }
    pMutex =
        if statMutex[op as usize] as libc::c_int != 0 {
            sqlite3Pcache1Mutex()
        } else { sqlite3MallocMutex() };
    sqlite3_mutex_enter(pMutex);
    *pCurrent = sqlite3Stat.nowValue[op as usize];
    *pHighwater = sqlite3Stat.mxValue[op as usize];
    if resetFlag != 0 {
        sqlite3Stat.mxValue[op as usize] = sqlite3Stat.nowValue[op as usize]
    }
    sqlite3_mutex_leave(pMutex);
    return 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_status(mut op: libc::c_int,
                                        mut pCurrent: *mut libc::c_int,
                                        mut pHighwater: *mut libc::c_int,
                                        mut resetFlag: libc::c_int)
 -> libc::c_int {
    let mut iCur: sqlite3_int64 = 0 as libc::c_int as sqlite3_int64;
    let mut iHwtr: sqlite3_int64 = 0 as libc::c_int as sqlite3_int64;
    let mut rc: libc::c_int = 0;
    rc = sqlite3_status64(op, &mut iCur, &mut iHwtr, resetFlag);
    if rc == 0 as libc::c_int {
        *pCurrent = iCur as libc::c_int;
        *pHighwater = iHwtr as libc::c_int
    }
    return rc;
}
unsafe extern "C" fn countLookasideSlots(mut p: *mut LookasideSlot) -> u32_0 {
    let mut cnt: u32_0 = 0 as libc::c_int as u32_0;
    while !p.is_null() { p = (*p).pNext; cnt = cnt.wrapping_add(1) }
    return cnt;
}
unsafe extern "C" fn sqlite3LookasideUsed(mut db: *mut sqlite3,
                                          mut pHighwater: *mut libc::c_int)
 -> libc::c_int {
    let mut nInit: u32_0 = countLookasideSlots((*db).lookaside.pInit);
    let mut nFree: u32_0 = countLookasideSlots((*db).lookaside.pFree);
    nInit =
        (nInit as
             libc::c_uint).wrapping_add(countLookasideSlots((*db).lookaside.pSmallInit))
            as u32_0 as u32_0;
    nFree =
        (nFree as
             libc::c_uint).wrapping_add(countLookasideSlots((*db).lookaside.pSmallFree))
            as u32_0 as u32_0;
    if !pHighwater.is_null() {
        *pHighwater = (*db).lookaside.nSlot.wrapping_sub(nInit) as libc::c_int
    }
    return (*db).lookaside.nSlot.wrapping_sub(nInit.wrapping_add(nFree)) as
               libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_db_status(mut db: *mut sqlite3,
                                           mut op: libc::c_int,
                                           mut pCurrent: *mut libc::c_int,
                                           mut pHighwater: *mut libc::c_int,
                                           mut resetFlag: libc::c_int)
 -> libc::c_int {
    let mut rc: libc::c_int = 0 as libc::c_int;
    sqlite3_mutex_enter((*db).mutex);
    let mut current_block_89: u64;
    match op {
        0 => {
            *pCurrent = sqlite3LookasideUsed(db, pHighwater);
            if resetFlag != 0 {
                let mut p: *mut LookasideSlot = (*db).lookaside.pFree;
                if !p.is_null() {
                    while !(*p).pNext.is_null() { p = (*p).pNext }
                    (*p).pNext = (*db).lookaside.pInit;
                    (*db).lookaside.pInit = (*db).lookaside.pFree;
                    (*db).lookaside.pFree = 0 as *mut LookasideSlot
                }
                p = (*db).lookaside.pSmallFree;
                if !p.is_null() {
                    while !(*p).pNext.is_null() { p = (*p).pNext }
                    (*p).pNext = (*db).lookaside.pSmallInit;
                    (*db).lookaside.pSmallInit = (*db).lookaside.pSmallFree;
                    (*db).lookaside.pSmallFree = 0 as *mut LookasideSlot
                }
            }
            current_block_89 = 4691324637564808323;
        }
        4 | 5 | 6 => {
            *pCurrent = 0 as libc::c_int;
            *pHighwater =
                (*db).lookaside.anStat[(op - 4 as libc::c_int) as usize] as
                    libc::c_int;
            if resetFlag != 0 {
                (*db).lookaside.anStat[(op - 4 as libc::c_int) as usize] =
                    0 as libc::c_int as u32_0
            }
            current_block_89 = 4691324637564808323;
        }
        11 | 1 => {
            let mut totalUsed: libc::c_int = 0 as libc::c_int;
            let mut i: libc::c_int = 0;
            sqlite3BtreeEnterAll(db);
            i = 0 as libc::c_int;
            while i < (*db).nDb {
                let mut pBt: *mut Btree = (*(*db).aDb.offset(i as isize)).pBt;
                if !pBt.is_null() {
                    let mut pPager: *mut Pager = sqlite3BtreePager(pBt);
                    let mut nByte: libc::c_int = sqlite3PagerMemUsed(pPager);
                    if op == 11 as libc::c_int {
                        nByte = nByte / sqlite3BtreeConnectionCount(pBt)
                    }
                    totalUsed += nByte
                }
                i += 1
            }
            sqlite3BtreeLeaveAll(db);
            *pCurrent = totalUsed;
            *pHighwater = 0 as libc::c_int;
            current_block_89 = 4691324637564808323;
        }
        2 => {
            let mut i_0: libc::c_int = 0;
            let mut nByte_0: libc::c_int = 0 as libc::c_int;
            sqlite3BtreeEnterAll(db);
            (*db).pnBytesFreed = &mut nByte_0;
            i_0 = 0 as libc::c_int;
            while i_0 < (*db).nDb {
                let mut pSchema: *mut Schema =
                    (*(*db).aDb.offset(i_0 as isize)).pSchema;
                if !pSchema.is_null() {
                    let mut p_0: *mut HashElem = 0 as *mut HashElem;
                    nByte_0 =
                        (nByte_0 as
                             libc::c_uint).wrapping_add((sqlite3Config.m.xRoundup.expect("non-null function pointer")(::std::mem::size_of::<HashElem>()
                                                                                                                          as
                                                                                                                          libc::c_ulong
                                                                                                                          as
                                                                                                                          libc::c_int)
                                                             as
                                                             libc::c_uint).wrapping_mul((*pSchema).tblHash.count.wrapping_add((*pSchema).trigHash.count).wrapping_add((*pSchema).idxHash.count).wrapping_add((*pSchema).fkeyHash.count)))
                            as libc::c_int as libc::c_int;
                    nByte_0 =
                        (nByte_0 as
                             libc::c_ulonglong).wrapping_add(sqlite3_msize((*pSchema).tblHash.ht
                                                                               as
                                                                               *mut libc::c_void))
                            as libc::c_int as libc::c_int;
                    nByte_0 =
                        (nByte_0 as
                             libc::c_ulonglong).wrapping_add(sqlite3_msize((*pSchema).trigHash.ht
                                                                               as
                                                                               *mut libc::c_void))
                            as libc::c_int as libc::c_int;
                    nByte_0 =
                        (nByte_0 as
                             libc::c_ulonglong).wrapping_add(sqlite3_msize((*pSchema).idxHash.ht
                                                                               as
                                                                               *mut libc::c_void))
                            as libc::c_int as libc::c_int;
                    nByte_0 =
                        (nByte_0 as
                             libc::c_ulonglong).wrapping_add(sqlite3_msize((*pSchema).fkeyHash.ht
                                                                               as
                                                                               *mut libc::c_void))
                            as libc::c_int as libc::c_int;
                    p_0 = (*pSchema).trigHash.first;
                    while !p_0.is_null() {
                        sqlite3DeleteTrigger(db, (*p_0).data as *mut Trigger);
                        p_0 = (*p_0).next
                    }
                    p_0 = (*pSchema).tblHash.first;
                    while !p_0.is_null() {
                        sqlite3DeleteTable(db, (*p_0).data as *mut Table);
                        p_0 = (*p_0).next
                    }
                }
                i_0 += 1
            }
            (*db).pnBytesFreed = 0 as *mut libc::c_int;
            sqlite3BtreeLeaveAll(db);
            *pHighwater = 0 as libc::c_int;
            *pCurrent = nByte_0;
            current_block_89 = 4691324637564808323;
        }
        3 => {
            let mut pVdbe: *mut Vdbe = 0 as *mut Vdbe;
            let mut nByte_1: libc::c_int = 0 as libc::c_int;
            (*db).pnBytesFreed = &mut nByte_1;
            pVdbe = (*db).pVdbe;
            while !pVdbe.is_null() {
                sqlite3VdbeClearObject(db, pVdbe);
                sqlite3DbFree(db, pVdbe as *mut libc::c_void);
                pVdbe = (*pVdbe).pNext
            }
            (*db).pnBytesFreed = 0 as *mut libc::c_int;
            *pHighwater = 0 as libc::c_int;
            *pCurrent = nByte_1;
            current_block_89 = 4691324637564808323;
        }
        12 => {
            op = 9 as libc::c_int + 1 as libc::c_int;
            current_block_89 = 14294131666767243020;
        }
        7 | 8 | 9 => { current_block_89 = 14294131666767243020; }
        10 => {
            *pHighwater = 0 as libc::c_int;
            *pCurrent =
                ((*db).nDeferredImmCons > 0 as libc::c_int as libc::c_longlong
                     ||
                     (*db).nDeferredCons >
                         0 as libc::c_int as libc::c_longlong) as libc::c_int;
            current_block_89 = 4691324637564808323;
        }
        _ => {
            rc = 1 as libc::c_int;
            current_block_89 = 4691324637564808323;
        }
    }
    match current_block_89 {
        14294131666767243020 => {
            let mut i_1: libc::c_int = 0;
            let mut nRet: libc::c_int = 0 as libc::c_int;
            i_1 = 0 as libc::c_int;
            while i_1 < (*db).nDb {
                if !(*(*db).aDb.offset(i_1 as isize)).pBt.is_null() {
                    let mut pPager_0: *mut Pager =
                        sqlite3BtreePager((*(*db).aDb.offset(i_1 as
                                                                 isize)).pBt);
                    sqlite3PagerCacheStat(pPager_0, op, resetFlag, &mut nRet);
                }
                i_1 += 1
            }
            *pHighwater = 0 as libc::c_int;
            *pCurrent = nRet
        }
        _ => { }
    }
    sqlite3_mutex_leave((*db).mutex);
    return rc;
}
unsafe extern "C" fn getDigits(mut zDate: *const libc::c_char,
                               mut zFormat: *const libc::c_char,
                               mut args: ...) -> libc::c_int {
    static mut aMx: [u16_0; 6] =
        [12 as libc::c_int as u16_0, 14 as libc::c_int as u16_0,
         24 as libc::c_int as u16_0, 31 as libc::c_int as u16_0,
         59 as libc::c_int as u16_0, 9999 as libc::c_int as u16_0];
    let mut ap: ::std::ffi::VaListImpl;
    let mut cnt: libc::c_int = 0 as libc::c_int;
    let mut nextC: libc::c_char = 0;
    ap = args.clone();
    's_21:
        loop  {
            let mut N: libc::c_char =
                (*zFormat.offset(0 as libc::c_int as isize) as libc::c_int -
                     '0' as i32) as libc::c_char;
            let mut min: libc::c_char =
                (*zFormat.offset(1 as libc::c_int as isize) as libc::c_int -
                     '0' as i32) as libc::c_char;
            let mut val: libc::c_int = 0 as libc::c_int;
            let mut max: u16_0 = 0;
            max =
                aMx[(*zFormat.offset(2 as libc::c_int as isize) as libc::c_int
                         - 'a' as i32) as usize];
            nextC = *zFormat.offset(3 as libc::c_int as isize);
            val = 0 as libc::c_int;
            loop  {
                let fresh0 = N;
                N = N - 1;
                if !(fresh0 != 0) { break ; }
                if sqlite3CtypeMap[*zDate as libc::c_uchar as usize] as
                       libc::c_int & 0x4 as libc::c_int == 0 {
                    break 's_21 ;
                }
                val =
                    val * 10 as libc::c_int + *zDate as libc::c_int -
                        '0' as i32;
                zDate = zDate.offset(1)
            }
            if val < min as libc::c_int || val > max as libc::c_int ||
                   nextC as libc::c_int != 0 as libc::c_int &&
                       nextC as libc::c_int != *zDate as libc::c_int {
                break ;
            }
            *ap.as_va_list().arg::<*mut libc::c_int>() = val;
            zDate = zDate.offset(1);
            cnt += 1;
            zFormat = zFormat.offset(4 as libc::c_int as isize);
            if !(nextC != 0) { break ; }
        }
    return cnt;
}
unsafe extern "C" fn parseTimezone(mut zDate: *const libc::c_char,
                                   mut p: *mut DateTime) -> libc::c_int {
    let mut current_block: u64;
    let mut sgn: libc::c_int = 0 as libc::c_int;
    let mut nHr: libc::c_int = 0;
    let mut nMn: libc::c_int = 0;
    let mut c: libc::c_int = 0;
    while sqlite3CtypeMap[*zDate as libc::c_uchar as usize] as libc::c_int &
              0x1 as libc::c_int != 0 {
        zDate = zDate.offset(1)
    }
    (*p).tz = 0 as libc::c_int;
    c = *zDate as libc::c_int;
    if c == '-' as i32 {
        sgn = -(1 as libc::c_int);
        current_block = 9606288038608642794;
    } else if c == '+' as i32 {
        sgn = 1 as libc::c_int;
        current_block = 9606288038608642794;
    } else {
        if c == 'Z' as i32 || c == 'z' as i32 {
            zDate = zDate.offset(1)
        } else { return (c != 0 as libc::c_int) as libc::c_int }
        current_block = 4460776247815661198;
    }
    match current_block {
        9606288038608642794 => {
            zDate = zDate.offset(1);
            if getDigits(zDate,
                         b"20b:20e\x00" as *const u8 as *const libc::c_char,
                         &mut nHr as *mut libc::c_int,
                         &mut nMn as *mut libc::c_int) != 2 as libc::c_int {
                return 1 as libc::c_int
            }
            zDate = zDate.offset(5 as libc::c_int as isize);
            (*p).tz = sgn * (nMn + nHr * 60 as libc::c_int)
        }
        _ => { }
    }
    while sqlite3CtypeMap[*zDate as libc::c_uchar as usize] as libc::c_int &
              0x1 as libc::c_int != 0 {
        zDate = zDate.offset(1)
    }
    (*p).tzSet = 1 as libc::c_int as libc::c_char;
    return (*zDate as libc::c_int != 0 as libc::c_int) as libc::c_int;
}
unsafe extern "C" fn parseHhMmSs(mut zDate: *const libc::c_char,
                                 mut p: *mut DateTime) -> libc::c_int {
    let mut h: libc::c_int = 0;
    let mut m: libc::c_int = 0;
    let mut s: libc::c_int = 0;
    let mut ms: libc::c_double = 0.0f64;
    if getDigits(zDate, b"20c:20e\x00" as *const u8 as *const libc::c_char,
                 &mut h as *mut libc::c_int, &mut m as *mut libc::c_int) !=
           2 as libc::c_int {
        return 1 as libc::c_int
    }
    zDate = zDate.offset(5 as libc::c_int as isize);
    if *zDate as libc::c_int == ':' as i32 {
        zDate = zDate.offset(1);
        if getDigits(zDate, b"20e\x00" as *const u8 as *const libc::c_char,
                     &mut s as *mut libc::c_int) != 1 as libc::c_int {
            return 1 as libc::c_int
        }
        zDate = zDate.offset(2 as libc::c_int as isize);
        if *zDate as libc::c_int == '.' as i32 &&
               sqlite3CtypeMap[*zDate.offset(1 as libc::c_int as isize) as
                                   libc::c_uchar as usize] as libc::c_int &
                   0x4 as libc::c_int != 0 {
            let mut rScale: libc::c_double = 1.0f64;
            zDate = zDate.offset(1);
            while sqlite3CtypeMap[*zDate as libc::c_uchar as usize] as
                      libc::c_int & 0x4 as libc::c_int != 0 {
                ms =
                    ms * 10.0f64 + *zDate as libc::c_int as libc::c_double -
                        '0' as i32 as libc::c_double;
                rScale *= 10.0f64;
                zDate = zDate.offset(1)
            }
            ms /= rScale
        }
    } else { s = 0 as libc::c_int }
    (*p).validJD = 0 as libc::c_int as libc::c_char;
    (*p).rawS = 0 as libc::c_int as libc::c_char;
    (*p).validHMS = 1 as libc::c_int as libc::c_char;
    (*p).h = h;
    (*p).m = m;
    (*p).s = s as libc::c_double + ms;
    if parseTimezone(zDate, p) != 0 { return 1 as libc::c_int }
    (*p).validTZ =
        if (*p).tz != 0 as libc::c_int {
            1 as libc::c_int
        } else { 0 as libc::c_int } as libc::c_char;
    return 0 as libc::c_int;
}
unsafe extern "C" fn datetimeError(mut p: *mut DateTime) {
    memset(p as *mut libc::c_void, 0 as libc::c_int,
           ::std::mem::size_of::<DateTime>() as libc::c_ulong);
    (*p).isError = 1 as libc::c_int as libc::c_char;
}
unsafe extern "C" fn computeJD(mut p: *mut DateTime) {
    let mut Y: libc::c_int = 0;
    let mut M: libc::c_int = 0;
    let mut D: libc::c_int = 0;
    let mut A: libc::c_int = 0;
    let mut B: libc::c_int = 0;
    let mut X1: libc::c_int = 0;
    let mut X2: libc::c_int = 0;
    if (*p).validJD != 0 { return }
    if (*p).validYMD != 0 {
        Y = (*p).Y;
        M = (*p).M;
        D = (*p).D
    } else {
        Y = 2000 as libc::c_int;
        M = 1 as libc::c_int;
        D = 1 as libc::c_int
    }
    if Y < -(4713 as libc::c_int) || Y > 9999 as libc::c_int ||
           (*p).rawS as libc::c_int != 0 {
        datetimeError(p);
        return
    }
    if M <= 2 as libc::c_int { Y -= 1; M += 12 as libc::c_int }
    A = Y / 100 as libc::c_int;
    B = 2 as libc::c_int - A + A / 4 as libc::c_int;
    X1 =
        36525 as libc::c_int * (Y + 4716 as libc::c_int) / 100 as libc::c_int;
    X2 =
        306001 as libc::c_int * (M + 1 as libc::c_int) / 10000 as libc::c_int;
    (*p).iJD =
        (((X1 + X2 + D + B) as libc::c_double - 1524.5f64) *
             86400000 as libc::c_int as libc::c_double) as sqlite3_int64;
    (*p).validJD = 1 as libc::c_int as libc::c_char;
    if (*p).validHMS != 0 {
        (*p).iJD +=
            ((*p).h * 3600000 as libc::c_int + (*p).m * 60000 as libc::c_int)
                as libc::c_longlong +
                ((*p).s * 1000 as libc::c_int as libc::c_double) as
                    sqlite3_int64;
        if (*p).validTZ != 0 {
            (*p).iJD -= ((*p).tz * 60000 as libc::c_int) as libc::c_longlong;
            (*p).validYMD = 0 as libc::c_int as libc::c_char;
            (*p).validHMS = 0 as libc::c_int as libc::c_char;
            (*p).validTZ = 0 as libc::c_int as libc::c_char
        }
    };
}
unsafe extern "C" fn parseYyyyMmDd(mut zDate: *const libc::c_char,
                                   mut p: *mut DateTime) -> libc::c_int {
    let mut Y: libc::c_int = 0;
    let mut M: libc::c_int = 0;
    let mut D: libc::c_int = 0;
    let mut neg: libc::c_int = 0;
    if *zDate.offset(0 as libc::c_int as isize) as libc::c_int == '-' as i32 {
        zDate = zDate.offset(1);
        neg = 1 as libc::c_int
    } else { neg = 0 as libc::c_int }
    if getDigits(zDate,
                 b"40f-21a-21d\x00" as *const u8 as *const libc::c_char,
                 &mut Y as *mut libc::c_int, &mut M as *mut libc::c_int,
                 &mut D as *mut libc::c_int) != 3 as libc::c_int {
        return 1 as libc::c_int
    }
    zDate = zDate.offset(10 as libc::c_int as isize);
    while sqlite3CtypeMap[*zDate as libc::c_uchar as usize] as libc::c_int &
              0x1 as libc::c_int != 0 ||
              'T' as i32 == *(zDate as *mut u8_0) as libc::c_int {
        zDate = zDate.offset(1)
    }
    if !(parseHhMmSs(zDate, p) == 0 as libc::c_int) {
        if *zDate as libc::c_int == 0 as libc::c_int {
            (*p).validHMS = 0 as libc::c_int as libc::c_char
        } else { return 1 as libc::c_int }
    }
    (*p).validJD = 0 as libc::c_int as libc::c_char;
    (*p).validYMD = 1 as libc::c_int as libc::c_char;
    (*p).Y = if neg != 0 { -Y } else { Y };
    (*p).M = M;
    (*p).D = D;
    if (*p).validTZ != 0 { computeJD(p); }
    return 0 as libc::c_int;
}
unsafe extern "C" fn setDateTimeToCurrent(mut context: *mut sqlite3_context,
                                          mut p: *mut DateTime)
 -> libc::c_int {
    (*p).iJD = sqlite3StmtCurrentTime(context);
    if (*p).iJD > 0 as libc::c_int as libc::c_longlong {
        (*p).validJD = 1 as libc::c_int as libc::c_char;
        return 0 as libc::c_int
    } else { return 1 as libc::c_int };
}
unsafe extern "C" fn setRawDateNumber(mut p: *mut DateTime,
                                      mut r: libc::c_double) {
    (*p).s = r;
    (*p).rawS = 1 as libc::c_int as libc::c_char;
    if r >= 0.0f64 && r < 5373484.5f64 {
        (*p).iJD = (r * 86400000.0f64 + 0.5f64) as sqlite3_int64;
        (*p).validJD = 1 as libc::c_int as libc::c_char
    };
}
unsafe extern "C" fn parseDateOrTime(mut context: *mut sqlite3_context,
                                     mut zDate: *const libc::c_char,
                                     mut p: *mut DateTime) -> libc::c_int {
    let mut r: libc::c_double = 0.;
    if parseYyyyMmDd(zDate, p) == 0 as libc::c_int {
        return 0 as libc::c_int
    } else {
        if parseHhMmSs(zDate, p) == 0 as libc::c_int {
            return 0 as libc::c_int
        } else {
            if sqlite3StrICmp(zDate,
                              b"now\x00" as *const u8 as *const libc::c_char)
                   == 0 as libc::c_int && sqlite3NotPureFunc(context) != 0 {
                return setDateTimeToCurrent(context, p)
            } else {
                if sqlite3AtoF(zDate, &mut r, sqlite3Strlen30(zDate),
                               1 as libc::c_int as u8_0) > 0 as libc::c_int {
                    setRawDateNumber(p, r);
                    return 0 as libc::c_int
                }
            }
        }
    }
    return 1 as libc::c_int;
}
unsafe extern "C" fn validJulianDay(mut iJD: sqlite3_int64) -> libc::c_int {
    return (iJD >= 0 as libc::c_int as libc::c_longlong &&
                iJD <=
                    (0x1a640 as libc::c_int as i64_0) << 32 as libc::c_int |
                        0x1072fdff as libc::c_int as libc::c_longlong) as
               libc::c_int;
}
unsafe extern "C" fn computeYMD(mut p: *mut DateTime) {
    let mut Z: libc::c_int = 0;
    let mut A: libc::c_int = 0;
    let mut B: libc::c_int = 0;
    let mut C: libc::c_int = 0;
    let mut D: libc::c_int = 0;
    let mut E: libc::c_int = 0;
    let mut X1: libc::c_int = 0;
    if (*p).validYMD != 0 { return }
    if (*p).validJD == 0 {
        (*p).Y = 2000 as libc::c_int;
        (*p).M = 1 as libc::c_int;
        (*p).D = 1 as libc::c_int
    } else if validJulianDay((*p).iJD) == 0 {
        datetimeError(p);
        return
    } else {
        Z =
            (((*p).iJD + 43200000 as libc::c_int as libc::c_longlong) /
                 86400000 as libc::c_int as libc::c_longlong) as libc::c_int;
        A =
            ((Z as libc::c_double - 1867216.25f64) / 36524.25f64) as
                libc::c_int;
        A = Z + 1 as libc::c_int + A - A / 4 as libc::c_int;
        B = A + 1524 as libc::c_int;
        C = ((B as libc::c_double - 122.1f64) / 365.25f64) as libc::c_int;
        D =
            36525 as libc::c_int * (C & 32767 as libc::c_int) /
                100 as libc::c_int;
        E = ((B - D) as libc::c_double / 30.6001f64) as libc::c_int;
        X1 = (30.6001f64 * E as libc::c_double) as libc::c_int;
        (*p).D = B - D - X1;
        (*p).M =
            if E < 14 as libc::c_int {
                (E) - 1 as libc::c_int
            } else { (E) - 13 as libc::c_int };
        (*p).Y =
            if (*p).M > 2 as libc::c_int {
                (C) - 4716 as libc::c_int
            } else { (C) - 4715 as libc::c_int }
    }
    (*p).validYMD = 1 as libc::c_int as libc::c_char;
}
unsafe extern "C" fn computeHMS(mut p: *mut DateTime) {
    let mut s: libc::c_int = 0;
    if (*p).validHMS != 0 { return }
    computeJD(p);
    s =
        (((*p).iJD + 43200000 as libc::c_int as libc::c_longlong) %
             86400000 as libc::c_int as libc::c_longlong) as libc::c_int;
    (*p).s = s as libc::c_double / 1000.0f64;
    s = (*p).s as libc::c_int;
    (*p).s -= s as libc::c_double;
    (*p).h = s / 3600 as libc::c_int;
    s -= (*p).h * 3600 as libc::c_int;
    (*p).m = s / 60 as libc::c_int;
    (*p).s += (s - (*p).m * 60 as libc::c_int) as libc::c_double;
    (*p).rawS = 0 as libc::c_int as libc::c_char;
    (*p).validHMS = 1 as libc::c_int as libc::c_char;
}
unsafe extern "C" fn computeYMD_HMS(mut p: *mut DateTime) {
    computeYMD(p);
    computeHMS(p);
}
unsafe extern "C" fn clearYMD_HMS_TZ(mut p: *mut DateTime) {
    (*p).validYMD = 0 as libc::c_int as libc::c_char;
    (*p).validHMS = 0 as libc::c_int as libc::c_char;
    (*p).validTZ = 0 as libc::c_int as libc::c_char;
}
unsafe extern "C" fn osLocaltime(mut t: *mut time_t, mut pTm: *mut tm)
 -> libc::c_int {
    let mut rc: libc::c_int = 0;
    let mut pX: *mut tm = 0 as *mut tm;
    let mut mutex: *mut sqlite3_mutex = sqlite3MutexAlloc(2 as libc::c_int);
    sqlite3_mutex_enter(mutex);
    pX = localtime(t);
    if sqlite3Config.bLocaltimeFault != 0 { pX = 0 as *mut tm }
    if !pX.is_null() { *pTm = *pX }
    sqlite3_mutex_leave(mutex);
    rc = (pX == 0 as *mut tm) as libc::c_int;
    return rc;
}
unsafe extern "C" fn localtimeOffset(mut p: *mut DateTime,
                                     mut pCtx: *mut sqlite3_context,
                                     mut pRc: *mut libc::c_int)
 -> sqlite3_int64 {
    let mut x: DateTime =
        DateTime{iJD: 0,
                 Y: 0,
                 M: 0,
                 D: 0,
                 h: 0,
                 m: 0,
                 tz: 0,
                 s: 0.,
                 validJD: 0,
                 rawS: 0,
                 validYMD: 0,
                 validHMS: 0,
                 validTZ: 0,
                 tzSet: 0,
                 isError: 0,};
    let mut y: DateTime =
        DateTime{iJD: 0,
                 Y: 0,
                 M: 0,
                 D: 0,
                 h: 0,
                 m: 0,
                 tz: 0,
                 s: 0.,
                 validJD: 0,
                 rawS: 0,
                 validYMD: 0,
                 validHMS: 0,
                 validTZ: 0,
                 tzSet: 0,
                 isError: 0,};
    let mut t: time_t = 0;
    let mut sLocal: tm =
        tm{tm_sec: 0,
           tm_min: 0,
           tm_hour: 0,
           tm_mday: 0,
           tm_mon: 0,
           tm_year: 0,
           tm_wday: 0,
           tm_yday: 0,
           tm_isdst: 0,
           tm_gmtoff: 0,
           tm_zone: 0 as *const libc::c_char,};
    memset(&mut sLocal as *mut tm as *mut libc::c_void, 0 as libc::c_int,
           ::std::mem::size_of::<tm>() as libc::c_ulong);
    x = *p;
    computeYMD_HMS(&mut x);
    if x.Y < 1971 as libc::c_int || x.Y >= 2038 as libc::c_int {
        x.Y = 2000 as libc::c_int;
        x.M = 1 as libc::c_int;
        x.D = 1 as libc::c_int;
        x.h = 0 as libc::c_int;
        x.m = 0 as libc::c_int;
        x.s = 0.0f64
    } else {
        let mut s: libc::c_int = (x.s + 0.5f64) as libc::c_int;
        x.s = s as libc::c_double
    }
    x.tz = 0 as libc::c_int;
    x.validJD = 0 as libc::c_int as libc::c_char;
    computeJD(&mut x);
    t =
        (x.iJD / 1000 as libc::c_int as libc::c_longlong -
             21086676 as libc::c_int as libc::c_longlong *
                 10000 as libc::c_int as i64_0) as time_t;
    if osLocaltime(&mut t, &mut sLocal) != 0 {
        sqlite3_result_error(pCtx,
                             b"local time unavailable\x00" as *const u8 as
                                 *const libc::c_char, -(1 as libc::c_int));
        *pRc = 1 as libc::c_int;
        return 0 as libc::c_int as sqlite3_int64
    }
    y.Y = sLocal.tm_year + 1900 as libc::c_int;
    y.M = sLocal.tm_mon + 1 as libc::c_int;
    y.D = sLocal.tm_mday;
    y.h = sLocal.tm_hour;
    y.m = sLocal.tm_min;
    y.s = sLocal.tm_sec as libc::c_double;
    y.validYMD = 1 as libc::c_int as libc::c_char;
    y.validHMS = 1 as libc::c_int as libc::c_char;
    y.validJD = 0 as libc::c_int as libc::c_char;
    y.rawS = 0 as libc::c_int as libc::c_char;
    y.validTZ = 0 as libc::c_int as libc::c_char;
    y.isError = 0 as libc::c_int as libc::c_char;
    computeJD(&mut y);
    *pRc = 0 as libc::c_int;
    return y.iJD - x.iJD;
}
static mut aXformType: [C2RustUnnamed_24; 6] =
    [{
         let mut init =
             C2RustUnnamed_24{eType: 0 as libc::c_int as u8_0,
                              nName: 6 as libc::c_int as u8_0,
                              zName:
                                  b"second\x00" as *const u8 as
                                      *const libc::c_char as
                                      *mut libc::c_char,
                              rLimit: 464269060800.0f64,
                              rXform: 1000.0f64,};
         init
     },
     {
         let mut init =
             C2RustUnnamed_24{eType: 0 as libc::c_int as u8_0,
                              nName: 6 as libc::c_int as u8_0,
                              zName:
                                  b"minute\x00" as *const u8 as
                                      *const libc::c_char as
                                      *mut libc::c_char,
                              rLimit: 7737817680.0f64,
                              rXform: 60000.0f64,};
         init
     },
     {
         let mut init =
             C2RustUnnamed_24{eType: 0 as libc::c_int as u8_0,
                              nName: 4 as libc::c_int as u8_0,
                              zName:
                                  b"hour\x00" as *const u8 as
                                      *const libc::c_char as
                                      *mut libc::c_char,
                              rLimit: 128963628.0f64,
                              rXform: 3600000.0f64,};
         init
     },
     {
         let mut init =
             C2RustUnnamed_24{eType: 0 as libc::c_int as u8_0,
                              nName: 3 as libc::c_int as u8_0,
                              zName:
                                  b"day\x00" as *const u8 as
                                      *const libc::c_char as
                                      *mut libc::c_char,
                              rLimit: 5373485.0f64,
                              rXform: 86400000.0f64,};
         init
     },
     {
         let mut init =
             C2RustUnnamed_24{eType: 1 as libc::c_int as u8_0,
                              nName: 5 as libc::c_int as u8_0,
                              zName:
                                  b"month\x00" as *const u8 as
                                      *const libc::c_char as
                                      *mut libc::c_char,
                              rLimit: 176546.0f64,
                              rXform: 2592000000.0f64,};
         init
     },
     {
         let mut init =
             C2RustUnnamed_24{eType: 2 as libc::c_int as u8_0,
                              nName: 4 as libc::c_int as u8_0,
                              zName:
                                  b"year\x00" as *const u8 as
                                      *const libc::c_char as
                                      *mut libc::c_char,
                              rLimit: 14713.0f64,
                              rXform: 31536000000.0f64,};
         init
     }];
unsafe extern "C" fn parseModifier(mut pCtx: *mut sqlite3_context,
                                   mut z: *const libc::c_char,
                                   mut n: libc::c_int, mut p: *mut DateTime)
 -> libc::c_int {
    let mut rc: libc::c_int = 1 as libc::c_int;
    let mut r: libc::c_double = 0.;
    match sqlite3UpperToLower[*z.offset(0 as libc::c_int as isize) as u8_0 as
                                  usize] as libc::c_int {
        108 => {
            if sqlite3_stricmp(z,
                               b"localtime\x00" as *const u8 as
                                   *const libc::c_char) == 0 as libc::c_int &&
                   sqlite3NotPureFunc(pCtx) != 0 {
                computeJD(p);
                (*p).iJD += localtimeOffset(p, pCtx, &mut rc);
                clearYMD_HMS_TZ(p);
            }
        }
        117 => {
            if sqlite3_stricmp(z,
                               b"unixepoch\x00" as *const u8 as
                                   *const libc::c_char) == 0 as libc::c_int &&
                   (*p).rawS as libc::c_int != 0 {
                r = (*p).s * 1000.0f64 + 210866760000000.0f64;
                if r >= 0.0f64 && r < 464269060800000.0f64 {
                    clearYMD_HMS_TZ(p);
                    (*p).iJD = (r + 0.5f64) as sqlite3_int64;
                    (*p).validJD = 1 as libc::c_int as libc::c_char;
                    (*p).rawS = 0 as libc::c_int as libc::c_char;
                    rc = 0 as libc::c_int
                }
            } else if sqlite3_stricmp(z,
                                      b"utc\x00" as *const u8 as
                                          *const libc::c_char) ==
                          0 as libc::c_int && sqlite3NotPureFunc(pCtx) != 0 {
                if (*p).tzSet as libc::c_int == 0 as libc::c_int {
                    let mut c1: sqlite3_int64 = 0;
                    computeJD(p);
                    c1 = localtimeOffset(p, pCtx, &mut rc);
                    if rc == 0 as libc::c_int {
                        (*p).iJD -= c1;
                        clearYMD_HMS_TZ(p);
                        (*p).iJD += c1 - localtimeOffset(p, pCtx, &mut rc)
                    }
                    (*p).tzSet = 1 as libc::c_int as libc::c_char
                } else { rc = 0 as libc::c_int }
            }
        }
        119 => {
            if sqlite3_strnicmp(z,
                                b"weekday \x00" as *const u8 as
                                    *const libc::c_char, 8 as libc::c_int) ==
                   0 as libc::c_int &&
                   sqlite3AtoF(&*z.offset(8 as libc::c_int as isize), &mut r,
                               sqlite3Strlen30(&*z.offset(8 as libc::c_int as
                                                              isize)),
                               1 as libc::c_int as u8_0) > 0 as libc::c_int &&
                   { n = r as libc::c_int; (n as libc::c_double) == r } &&
                   n >= 0 as libc::c_int &&
                   r < 7 as libc::c_int as libc::c_double {
                let mut Z: sqlite3_int64 = 0;
                computeYMD_HMS(p);
                (*p).validTZ = 0 as libc::c_int as libc::c_char;
                (*p).validJD = 0 as libc::c_int as libc::c_char;
                computeJD(p);
                Z =
                    ((*p).iJD + 129600000 as libc::c_int as libc::c_longlong)
                        / 86400000 as libc::c_int as libc::c_longlong %
                        7 as libc::c_int as libc::c_longlong;
                if Z > n as libc::c_longlong {
                    Z -= 7 as libc::c_int as libc::c_longlong
                }
                (*p).iJD +=
                    (n as libc::c_longlong - Z) *
                        86400000 as libc::c_int as libc::c_longlong;
                clearYMD_HMS_TZ(p);
                rc = 0 as libc::c_int
            }
        }
        115 => {
            if !(sqlite3_strnicmp(z,
                                  b"start of \x00" as *const u8 as
                                      *const libc::c_char, 9 as libc::c_int)
                     != 0 as libc::c_int) {
                if !((*p).validJD == 0 && (*p).validYMD == 0 &&
                         (*p).validHMS == 0) {
                    z = z.offset(9 as libc::c_int as isize);
                    computeYMD(p);
                    (*p).validHMS = 1 as libc::c_int as libc::c_char;
                    (*p).m = 0 as libc::c_int;
                    (*p).h = (*p).m;
                    (*p).s = 0.0f64;
                    (*p).rawS = 0 as libc::c_int as libc::c_char;
                    (*p).validTZ = 0 as libc::c_int as libc::c_char;
                    (*p).validJD = 0 as libc::c_int as libc::c_char;
                    if sqlite3_stricmp(z,
                                       b"month\x00" as *const u8 as
                                           *const libc::c_char) ==
                           0 as libc::c_int {
                        (*p).D = 1 as libc::c_int;
                        rc = 0 as libc::c_int
                    } else if sqlite3_stricmp(z,
                                              b"year\x00" as *const u8 as
                                                  *const libc::c_char) ==
                                  0 as libc::c_int {
                        (*p).M = 1 as libc::c_int;
                        (*p).D = 1 as libc::c_int;
                        rc = 0 as libc::c_int
                    } else if sqlite3_stricmp(z,
                                              b"day\x00" as *const u8 as
                                                  *const libc::c_char) ==
                                  0 as libc::c_int {
                        rc = 0 as libc::c_int
                    }
                }
            }
        }
        43 | 45 | 48 | 49 | 50 | 51 | 52 | 53 | 54 | 55 | 56 | 57 => {
            let mut rRounder: libc::c_double = 0.;
            let mut i: libc::c_int = 0;
            n = 1 as libc::c_int;
            while *z.offset(n as isize) as libc::c_int != 0 &&
                      *z.offset(n as isize) as libc::c_int != ':' as i32 &&
                      sqlite3CtypeMap[*z.offset(n as isize) as libc::c_uchar
                                          as usize] as libc::c_int &
                          0x1 as libc::c_int == 0 {
                n += 1
            }
            if sqlite3AtoF(z, &mut r, n, 1 as libc::c_int as u8_0) <=
                   0 as libc::c_int {
                rc = 1 as libc::c_int
            } else if *z.offset(n as isize) as libc::c_int == ':' as i32 {
                let mut z2: *const libc::c_char = z;
                let mut tx: DateTime =
                    DateTime{iJD: 0,
                             Y: 0,
                             M: 0,
                             D: 0,
                             h: 0,
                             m: 0,
                             tz: 0,
                             s: 0.,
                             validJD: 0,
                             rawS: 0,
                             validYMD: 0,
                             validHMS: 0,
                             validTZ: 0,
                             tzSet: 0,
                             isError: 0,};
                let mut day: sqlite3_int64 = 0;
                if sqlite3CtypeMap[*z2 as libc::c_uchar as usize] as
                       libc::c_int & 0x4 as libc::c_int == 0 {
                    z2 = z2.offset(1)
                }
                memset(&mut tx as *mut DateTime as *mut libc::c_void,
                       0 as libc::c_int,
                       ::std::mem::size_of::<DateTime>() as libc::c_ulong);
                if !(parseHhMmSs(z2, &mut tx) != 0) {
                    computeJD(&mut tx);
                    tx.iJD -= 43200000 as libc::c_int as libc::c_longlong;
                    day =
                        tx.iJD / 86400000 as libc::c_int as libc::c_longlong;
                    tx.iJD -=
                        day * 86400000 as libc::c_int as libc::c_longlong;
                    if *z.offset(0 as libc::c_int as isize) as libc::c_int ==
                           '-' as i32 {
                        tx.iJD = -tx.iJD
                    }
                    computeJD(p);
                    clearYMD_HMS_TZ(p);
                    (*p).iJD += tx.iJD;
                    rc = 0 as libc::c_int
                }
            } else {
                z = z.offset(n as isize);
                while sqlite3CtypeMap[*z as libc::c_uchar as usize] as
                          libc::c_int & 0x1 as libc::c_int != 0 {
                    z = z.offset(1)
                }
                n = sqlite3Strlen30(z);
                if !(n > 10 as libc::c_int || n < 3 as libc::c_int) {
                    if sqlite3UpperToLower[*z.offset((n - 1 as libc::c_int) as
                                                         isize) as u8_0 as
                                               usize] as libc::c_int ==
                           's' as i32 {
                        n -= 1
                    }
                    computeJD(p);
                    rc = 1 as libc::c_int;
                    rRounder =
                        if r < 0 as libc::c_int as libc::c_double {
                            -0.5f64
                        } else { 0.5f64 };
                    i = 0 as libc::c_int;
                    while i <
                              (::std::mem::size_of::<[C2RustUnnamed_24; 6]>()
                                   as
                                   libc::c_ulong).wrapping_div(::std::mem::size_of::<C2RustUnnamed_24>()
                                                                   as
                                                                   libc::c_ulong)
                                  as libc::c_int {
                        if aXformType[i as usize].nName as libc::c_int == n &&
                               sqlite3_strnicmp(aXformType[i as usize].zName,
                                                z, n) == 0 as libc::c_int &&
                               r > -aXformType[i as usize].rLimit &&
                               r < aXformType[i as usize].rLimit {
                            match aXformType[i as usize].eType as libc::c_int
                                {
                                1 => {
                                    let mut x: libc::c_int = 0;
                                    computeYMD_HMS(p);
                                    (*p).M += r as libc::c_int;
                                    x =
                                        if (*p).M > 0 as libc::c_int {
                                            ((*p).M - 1 as libc::c_int) /
                                                12 as libc::c_int
                                        } else {
                                            ((*p).M - 12 as libc::c_int) /
                                                12 as libc::c_int
                                        };
                                    (*p).Y += x;
                                    (*p).M -= x * 12 as libc::c_int;
                                    (*p).validJD =
                                        0 as libc::c_int as libc::c_char;
                                    r -= r as libc::c_int as libc::c_double
                                }
                                2 => {
                                    let mut y: libc::c_int = r as libc::c_int;
                                    computeYMD_HMS(p);
                                    (*p).Y += y;
                                    (*p).validJD =
                                        0 as libc::c_int as libc::c_char;
                                    r -= r as libc::c_int as libc::c_double
                                }
                                _ => { }
                            }
                            computeJD(p);
                            (*p).iJD +=
                                (r * aXformType[i as usize].rXform + rRounder)
                                    as sqlite3_int64;
                            rc = 0 as libc::c_int;
                            break ;
                        } else { i += 1 }
                    }
                    clearYMD_HMS_TZ(p);
                }
            }
        }
        _ => { }
    }
    return rc;
}
unsafe extern "C" fn isDate(mut context: *mut sqlite3_context,
                            mut argc: libc::c_int,
                            mut argv: *mut *mut sqlite3_value,
                            mut p: *mut DateTime) -> libc::c_int {
    let mut i: libc::c_int = 0;
    let mut n: libc::c_int = 0;
    let mut z: *const libc::c_uchar = 0 as *const libc::c_uchar;
    let mut eType: libc::c_int = 0;
    memset(p as *mut libc::c_void, 0 as libc::c_int,
           ::std::mem::size_of::<DateTime>() as libc::c_ulong);
    if argc == 0 as libc::c_int { return setDateTimeToCurrent(context, p) }
    eType = sqlite3_value_type(*argv.offset(0 as libc::c_int as isize));
    if eType == 2 as libc::c_int || eType == 1 as libc::c_int {
        setRawDateNumber(p,
                         sqlite3_value_double(*argv.offset(0 as libc::c_int as
                                                               isize)));
    } else {
        z = sqlite3_value_text(*argv.offset(0 as libc::c_int as isize));
        if z.is_null() ||
               parseDateOrTime(context, z as *mut libc::c_char, p) != 0 {
            return 1 as libc::c_int
        }
    }
    i = 1 as libc::c_int;
    while i < argc {
        z = sqlite3_value_text(*argv.offset(i as isize));
        n = sqlite3_value_bytes(*argv.offset(i as isize));
        if z.is_null() ||
               parseModifier(context, z as *mut libc::c_char, n, p) != 0 {
            return 1 as libc::c_int
        }
        i += 1
    }
    computeJD(p);
    if (*p).isError as libc::c_int != 0 || validJulianDay((*p).iJD) == 0 {
        return 1 as libc::c_int
    }
    return 0 as libc::c_int;
}
unsafe extern "C" fn juliandayFunc(mut context: *mut sqlite3_context,
                                   mut argc: libc::c_int,
                                   mut argv: *mut *mut sqlite3_value) {
    let mut x: DateTime =
        DateTime{iJD: 0,
                 Y: 0,
                 M: 0,
                 D: 0,
                 h: 0,
                 m: 0,
                 tz: 0,
                 s: 0.,
                 validJD: 0,
                 rawS: 0,
                 validYMD: 0,
                 validHMS: 0,
                 validTZ: 0,
                 tzSet: 0,
                 isError: 0,};
    if isDate(context, argc, argv, &mut x) == 0 as libc::c_int {
        computeJD(&mut x);
        sqlite3_result_double(context,
                              x.iJD as libc::c_double / 86400000.0f64);
    };
}
unsafe extern "C" fn datetimeFunc(mut context: *mut sqlite3_context,
                                  mut argc: libc::c_int,
                                  mut argv: *mut *mut sqlite3_value) {
    let mut x: DateTime =
        DateTime{iJD: 0,
                 Y: 0,
                 M: 0,
                 D: 0,
                 h: 0,
                 m: 0,
                 tz: 0,
                 s: 0.,
                 validJD: 0,
                 rawS: 0,
                 validYMD: 0,
                 validHMS: 0,
                 validTZ: 0,
                 tzSet: 0,
                 isError: 0,};
    if isDate(context, argc, argv, &mut x) == 0 as libc::c_int {
        let mut zBuf: [libc::c_char; 100] = [0; 100];
        computeYMD_HMS(&mut x);
        sqlite3_snprintf(::std::mem::size_of::<[libc::c_char; 100]>() as
                             libc::c_ulong as libc::c_int, zBuf.as_mut_ptr(),
                         b"%04d-%02d-%02d %02d:%02d:%02d\x00" as *const u8 as
                             *const libc::c_char, x.Y, x.M, x.D, x.h, x.m,
                         x.s as libc::c_int);
        sqlite3_result_text(context, zBuf.as_mut_ptr(), -(1 as libc::c_int),
                            ::std::mem::transmute::<libc::intptr_t,
                                                    sqlite3_destructor_type>(-(1
                                                                                   as
                                                                                   libc::c_int)
                                                                                 as
                                                                                 libc::intptr_t));
    };
}
unsafe extern "C" fn timeFunc(mut context: *mut sqlite3_context,
                              mut argc: libc::c_int,
                              mut argv: *mut *mut sqlite3_value) {
    let mut x: DateTime =
        DateTime{iJD: 0,
                 Y: 0,
                 M: 0,
                 D: 0,
                 h: 0,
                 m: 0,
                 tz: 0,
                 s: 0.,
                 validJD: 0,
                 rawS: 0,
                 validYMD: 0,
                 validHMS: 0,
                 validTZ: 0,
                 tzSet: 0,
                 isError: 0,};
    if isDate(context, argc, argv, &mut x) == 0 as libc::c_int {
        let mut zBuf: [libc::c_char; 100] = [0; 100];
        computeHMS(&mut x);
        sqlite3_snprintf(::std::mem::size_of::<[libc::c_char; 100]>() as
                             libc::c_ulong as libc::c_int, zBuf.as_mut_ptr(),
                         b"%02d:%02d:%02d\x00" as *const u8 as
                             *const libc::c_char, x.h, x.m,
                         x.s as libc::c_int);
        sqlite3_result_text(context, zBuf.as_mut_ptr(), -(1 as libc::c_int),
                            ::std::mem::transmute::<libc::intptr_t,
                                                    sqlite3_destructor_type>(-(1
                                                                                   as
                                                                                   libc::c_int)
                                                                                 as
                                                                                 libc::intptr_t));
    };
}
unsafe extern "C" fn dateFunc(mut context: *mut sqlite3_context,
                              mut argc: libc::c_int,
                              mut argv: *mut *mut sqlite3_value) {
    let mut x: DateTime =
        DateTime{iJD: 0,
                 Y: 0,
                 M: 0,
                 D: 0,
                 h: 0,
                 m: 0,
                 tz: 0,
                 s: 0.,
                 validJD: 0,
                 rawS: 0,
                 validYMD: 0,
                 validHMS: 0,
                 validTZ: 0,
                 tzSet: 0,
                 isError: 0,};
    if isDate(context, argc, argv, &mut x) == 0 as libc::c_int {
        let mut zBuf: [libc::c_char; 100] = [0; 100];
        computeYMD(&mut x);
        sqlite3_snprintf(::std::mem::size_of::<[libc::c_char; 100]>() as
                             libc::c_ulong as libc::c_int, zBuf.as_mut_ptr(),
                         b"%04d-%02d-%02d\x00" as *const u8 as
                             *const libc::c_char, x.Y, x.M, x.D);
        sqlite3_result_text(context, zBuf.as_mut_ptr(), -(1 as libc::c_int),
                            ::std::mem::transmute::<libc::intptr_t,
                                                    sqlite3_destructor_type>(-(1
                                                                                   as
                                                                                   libc::c_int)
                                                                                 as
                                                                                 libc::intptr_t));
    };
}
unsafe extern "C" fn strftimeFunc(mut context: *mut sqlite3_context,
                                  mut argc: libc::c_int,
                                  mut argv: *mut *mut sqlite3_value) {
    let mut x: DateTime =
        DateTime{iJD: 0,
                 Y: 0,
                 M: 0,
                 D: 0,
                 h: 0,
                 m: 0,
                 tz: 0,
                 s: 0.,
                 validJD: 0,
                 rawS: 0,
                 validYMD: 0,
                 validHMS: 0,
                 validTZ: 0,
                 tzSet: 0,
                 isError: 0,};
    let mut n: u64_0 = 0;
    let mut i: size_t = 0;
    let mut j: size_t = 0;
    let mut z: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut db: *mut sqlite3 = 0 as *mut sqlite3;
    let mut zFmt: *const libc::c_char = 0 as *const libc::c_char;
    let mut zBuf: [libc::c_char; 100] = [0; 100];
    if argc == 0 as libc::c_int { return }
    zFmt =
        sqlite3_value_text(*argv.offset(0 as libc::c_int as isize)) as
            *const libc::c_char;
    if zFmt.is_null() ||
           isDate(context, argc - 1 as libc::c_int,
                  argv.offset(1 as libc::c_int as isize), &mut x) != 0 {
        return
    }
    db = sqlite3_context_db_handle(context);
    i = 0 as libc::c_int as size_t;
    n = 1 as libc::c_int as u64_0;
    while *zFmt.offset(i as isize) != 0 {
        if *zFmt.offset(i as isize) as libc::c_int == '%' as i32 {
            match *zFmt.offset(i.wrapping_add(1 as libc::c_int as
                                                  libc::c_ulong) as isize) as
                      libc::c_int {
                100 | 72 | 109 | 77 | 83 | 87 => { n = n.wrapping_add(1) }
                119 | 37 => { }
                102 => {
                    n =
                        (n as
                             libc::c_ulonglong).wrapping_add(8 as libc::c_int
                                                                 as
                                                                 libc::c_ulonglong)
                            as u64_0 as u64_0
                }
                106 => {
                    n =
                        (n as
                             libc::c_ulonglong).wrapping_add(3 as libc::c_int
                                                                 as
                                                                 libc::c_ulonglong)
                            as u64_0 as u64_0
                }
                89 => {
                    n =
                        (n as
                             libc::c_ulonglong).wrapping_add(8 as libc::c_int
                                                                 as
                                                                 libc::c_ulonglong)
                            as u64_0 as u64_0
                }
                115 | 74 => {
                    n =
                        (n as
                             libc::c_ulonglong).wrapping_add(50 as libc::c_int
                                                                 as
                                                                 libc::c_ulonglong)
                            as u64_0 as u64_0
                }
                _ => { return }
            }
            i = i.wrapping_add(1)
        }
        i = i.wrapping_add(1);
        n = n.wrapping_add(1)
    }
    if n <
           ::std::mem::size_of::<[libc::c_char; 100]>() as libc::c_ulong as
               libc::c_ulonglong {
        z = zBuf.as_mut_ptr()
    } else if n > (*db).aLimit[0 as libc::c_int as usize] as u64_0 {
        sqlite3_result_error_toobig(context);
        return
    } else {
        z =
            sqlite3DbMallocRawNN(db, n as libc::c_int as u64_0) as
                *mut libc::c_char;
        if z.is_null() { sqlite3_result_error_nomem(context); return }
    }
    computeJD(&mut x);
    computeYMD_HMS(&mut x);
    j = 0 as libc::c_int as size_t;
    i = j;
    while *zFmt.offset(i as isize) != 0 {
        if *zFmt.offset(i as isize) as libc::c_int != '%' as i32 {
            let fresh1 = j;
            j = j.wrapping_add(1);
            *z.offset(fresh1 as isize) = *zFmt.offset(i as isize)
        } else {
            i = i.wrapping_add(1);
            match *zFmt.offset(i as isize) as libc::c_int {
                100 => {
                    sqlite3_snprintf(3 as libc::c_int,
                                     &mut *z.offset(j as isize) as
                                         *mut libc::c_char,
                                     b"%02d\x00" as *const u8 as
                                         *const libc::c_char, x.D);
                    j =
                        (j as
                             libc::c_ulong).wrapping_add(2 as libc::c_int as
                                                             libc::c_ulong) as
                            size_t as size_t
                }
                102 => {
                    let mut s: libc::c_double = x.s;
                    if s > 59.999f64 { s = 59.999f64 }
                    sqlite3_snprintf(7 as libc::c_int,
                                     &mut *z.offset(j as isize) as
                                         *mut libc::c_char,
                                     b"%06.3f\x00" as *const u8 as
                                         *const libc::c_char, s);
                    j =
                        (j as
                             libc::c_ulong).wrapping_add(sqlite3Strlen30(&mut *z.offset(j
                                                                                            as
                                                                                            isize))
                                                             as libc::c_ulong)
                            as size_t as size_t
                }
                72 => {
                    sqlite3_snprintf(3 as libc::c_int,
                                     &mut *z.offset(j as isize) as
                                         *mut libc::c_char,
                                     b"%02d\x00" as *const u8 as
                                         *const libc::c_char, x.h);
                    j =
                        (j as
                             libc::c_ulong).wrapping_add(2 as libc::c_int as
                                                             libc::c_ulong) as
                            size_t as size_t
                }
                87 | 106 => {
                    let mut nDay: libc::c_int = 0;
                    let mut y: DateTime = x;
                    y.validJD = 0 as libc::c_int as libc::c_char;
                    y.M = 1 as libc::c_int;
                    y.D = 1 as libc::c_int;
                    computeJD(&mut y);
                    nDay =
                        ((x.iJD - y.iJD +
                              43200000 as libc::c_int as libc::c_longlong) /
                             86400000 as libc::c_int as libc::c_longlong) as
                            libc::c_int;
                    if *zFmt.offset(i as isize) as libc::c_int == 'W' as i32 {
                        let mut wd: libc::c_int = 0;
                        wd =
                            ((x.iJD +
                                  43200000 as libc::c_int as libc::c_longlong)
                                 / 86400000 as libc::c_int as libc::c_longlong
                                 % 7 as libc::c_int as libc::c_longlong) as
                                libc::c_int;
                        sqlite3_snprintf(3 as libc::c_int,
                                         &mut *z.offset(j as isize) as
                                             *mut libc::c_char,
                                         b"%02d\x00" as *const u8 as
                                             *const libc::c_char,
                                         (nDay + 7 as libc::c_int - wd) /
                                             7 as libc::c_int);
                        j =
                            (j as
                                 libc::c_ulong).wrapping_add(2 as libc::c_int
                                                                 as
                                                                 libc::c_ulong)
                                as size_t as size_t
                    } else {
                        sqlite3_snprintf(4 as libc::c_int,
                                         &mut *z.offset(j as isize) as
                                             *mut libc::c_char,
                                         b"%03d\x00" as *const u8 as
                                             *const libc::c_char,
                                         nDay + 1 as libc::c_int);
                        j =
                            (j as
                                 libc::c_ulong).wrapping_add(3 as libc::c_int
                                                                 as
                                                                 libc::c_ulong)
                                as size_t as size_t
                    }
                }
                74 => {
                    sqlite3_snprintf(20 as libc::c_int,
                                     &mut *z.offset(j as isize) as
                                         *mut libc::c_char,
                                     b"%.16g\x00" as *const u8 as
                                         *const libc::c_char,
                                     x.iJD as libc::c_double / 86400000.0f64);
                    j =
                        (j as
                             libc::c_ulong).wrapping_add(sqlite3Strlen30(&mut *z.offset(j
                                                                                            as
                                                                                            isize))
                                                             as libc::c_ulong)
                            as size_t as size_t
                }
                109 => {
                    sqlite3_snprintf(3 as libc::c_int,
                                     &mut *z.offset(j as isize) as
                                         *mut libc::c_char,
                                     b"%02d\x00" as *const u8 as
                                         *const libc::c_char, x.M);
                    j =
                        (j as
                             libc::c_ulong).wrapping_add(2 as libc::c_int as
                                                             libc::c_ulong) as
                            size_t as size_t
                }
                77 => {
                    sqlite3_snprintf(3 as libc::c_int,
                                     &mut *z.offset(j as isize) as
                                         *mut libc::c_char,
                                     b"%02d\x00" as *const u8 as
                                         *const libc::c_char, x.m);
                    j =
                        (j as
                             libc::c_ulong).wrapping_add(2 as libc::c_int as
                                                             libc::c_ulong) as
                            size_t as size_t
                }
                115 => {
                    sqlite3_snprintf(30 as libc::c_int,
                                     &mut *z.offset(j as isize) as
                                         *mut libc::c_char,
                                     b"%lld\x00" as *const u8 as
                                         *const libc::c_char,
                                     x.iJD /
                                         1000 as libc::c_int as
                                             libc::c_longlong -
                                         21086676 as libc::c_int as
                                             libc::c_longlong *
                                             10000 as libc::c_int as i64_0);
                    j =
                        (j as
                             libc::c_ulong).wrapping_add(sqlite3Strlen30(&mut *z.offset(j
                                                                                            as
                                                                                            isize))
                                                             as libc::c_ulong)
                            as size_t as size_t
                }
                83 => {
                    sqlite3_snprintf(3 as libc::c_int,
                                     &mut *z.offset(j as isize) as
                                         *mut libc::c_char,
                                     b"%02d\x00" as *const u8 as
                                         *const libc::c_char,
                                     x.s as libc::c_int);
                    j =
                        (j as
                             libc::c_ulong).wrapping_add(2 as libc::c_int as
                                                             libc::c_ulong) as
                            size_t as size_t
                }
                119 => {
                    let fresh2 = j;
                    j = j.wrapping_add(1);
                    *z.offset(fresh2 as isize) =
                        (((x.iJD +
                               129600000 as libc::c_int as libc::c_longlong) /
                              86400000 as libc::c_int as libc::c_longlong %
                              7 as libc::c_int as libc::c_longlong) as
                             libc::c_char as libc::c_int + '0' as i32) as
                            libc::c_char
                }
                89 => {
                    sqlite3_snprintf(5 as libc::c_int,
                                     &mut *z.offset(j as isize) as
                                         *mut libc::c_char,
                                     b"%04d\x00" as *const u8 as
                                         *const libc::c_char, x.Y);
                    j =
                        (j as
                             libc::c_ulong).wrapping_add(sqlite3Strlen30(&mut *z.offset(j
                                                                                            as
                                                                                            isize))
                                                             as libc::c_ulong)
                            as size_t as size_t
                }
                _ => {
                    let fresh3 = j;
                    j = j.wrapping_add(1);
                    *z.offset(fresh3 as isize) = '%' as i32 as libc::c_char
                }
            }
        }
        i = i.wrapping_add(1)
    }
    *z.offset(j as isize) = 0 as libc::c_int as libc::c_char;
    sqlite3_result_text(context, z, -(1 as libc::c_int),
                        if z == zBuf.as_mut_ptr() {
                            ::std::mem::transmute::<libc::intptr_t,
                                                    sqlite3_destructor_type>(-(1
                                                                                   as
                                                                                   libc::c_int)
                                                                                 as
                                                                                 libc::intptr_t)
                        } else {
                            ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                    *mut libc::c_void)
                                                               ->
                                                                   libc::c_int>,
                                                    sqlite3_destructor_type>(Some(sqlite3MallocSize
                                                                                      as
                                                                                      unsafe extern "C" fn(_:
                                                                                                               *mut libc::c_void)
                                                                                          ->
                                                                                              libc::c_int))
                        });
}
unsafe extern "C" fn ctimeFunc(mut context: *mut sqlite3_context,
                               mut NotUsed: libc::c_int,
                               mut NotUsed2: *mut *mut sqlite3_value) {
    timeFunc(context, 0 as libc::c_int, 0 as *mut *mut sqlite3_value);
}
unsafe extern "C" fn cdateFunc(mut context: *mut sqlite3_context,
                               mut NotUsed: libc::c_int,
                               mut NotUsed2: *mut *mut sqlite3_value) {
    dateFunc(context, 0 as libc::c_int, 0 as *mut *mut sqlite3_value);
}
unsafe extern "C" fn ctimestampFunc(mut context: *mut sqlite3_context,
                                    mut NotUsed: libc::c_int,
                                    mut NotUsed2: *mut *mut sqlite3_value) {
    datetimeFunc(context, 0 as libc::c_int, 0 as *mut *mut sqlite3_value);
}
unsafe extern "C" fn sqlite3RegisterDateTimeFunctions() {
    static mut aDateTimeFuncs: [FuncDef; 8] =
        unsafe {
            [{
                 let mut init =
                     FuncDef{nArg: -(1 as libc::c_int) as i8_0,
                             funcFlags:
                                 (0x2000 as libc::c_int | 1 as libc::c_int |
                                      0x800 as libc::c_int) as u32_0,
                             pUserData:
                                 &sqlite3Config as *const Sqlite3Config as
                                     *mut Sqlite3Config as *mut libc::c_void,
                             pNext: 0 as *const FuncDef as *mut FuncDef,
                             xSFunc:
                                 Some(juliandayFunc as
                                          unsafe extern "C" fn(_:
                                                                   *mut sqlite3_context,
                                                               _: libc::c_int,
                                                               _:
                                                                   *mut *mut sqlite3_value)
                                              -> ()),
                             xFinalize: None,
                             xValue: None,
                             xInverse: None,
                             zName:
                                 b"julianday\x00" as *const u8 as
                                     *const libc::c_char,
                             u:
                                 C2RustUnnamed_3{pHash:
                                                     0 as *const FuncDef as
                                                         *mut FuncDef,},};
                 init
             },
             {
                 let mut init =
                     FuncDef{nArg: -(1 as libc::c_int) as i8_0,
                             funcFlags:
                                 (0x2000 as libc::c_int | 1 as libc::c_int |
                                      0x800 as libc::c_int) as u32_0,
                             pUserData:
                                 &sqlite3Config as *const Sqlite3Config as
                                     *mut Sqlite3Config as *mut libc::c_void,
                             pNext: 0 as *const FuncDef as *mut FuncDef,
                             xSFunc:
                                 Some(dateFunc as
                                          unsafe extern "C" fn(_:
                                                                   *mut sqlite3_context,
                                                               _: libc::c_int,
                                                               _:
                                                                   *mut *mut sqlite3_value)
                                              -> ()),
                             xFinalize: None,
                             xValue: None,
                             xInverse: None,
                             zName:
                                 b"date\x00" as *const u8 as
                                     *const libc::c_char,
                             u:
                                 C2RustUnnamed_3{pHash:
                                                     0 as *const FuncDef as
                                                         *mut FuncDef,},};
                 init
             },
             {
                 let mut init =
                     FuncDef{nArg: -(1 as libc::c_int) as i8_0,
                             funcFlags:
                                 (0x2000 as libc::c_int | 1 as libc::c_int |
                                      0x800 as libc::c_int) as u32_0,
                             pUserData:
                                 &sqlite3Config as *const Sqlite3Config as
                                     *mut Sqlite3Config as *mut libc::c_void,
                             pNext: 0 as *const FuncDef as *mut FuncDef,
                             xSFunc:
                                 Some(timeFunc as
                                          unsafe extern "C" fn(_:
                                                                   *mut sqlite3_context,
                                                               _: libc::c_int,
                                                               _:
                                                                   *mut *mut sqlite3_value)
                                              -> ()),
                             xFinalize: None,
                             xValue: None,
                             xInverse: None,
                             zName:
                                 b"time\x00" as *const u8 as
                                     *const libc::c_char,
                             u:
                                 C2RustUnnamed_3{pHash:
                                                     0 as *const FuncDef as
                                                         *mut FuncDef,},};
                 init
             },
             {
                 let mut init =
                     FuncDef{nArg: -(1 as libc::c_int) as i8_0,
                             funcFlags:
                                 (0x2000 as libc::c_int | 1 as libc::c_int |
                                      0x800 as libc::c_int) as u32_0,
                             pUserData:
                                 &sqlite3Config as *const Sqlite3Config as
                                     *mut Sqlite3Config as *mut libc::c_void,
                             pNext: 0 as *const FuncDef as *mut FuncDef,
                             xSFunc:
                                 Some(datetimeFunc as
                                          unsafe extern "C" fn(_:
                                                                   *mut sqlite3_context,
                                                               _: libc::c_int,
                                                               _:
                                                                   *mut *mut sqlite3_value)
                                              -> ()),
                             xFinalize: None,
                             xValue: None,
                             xInverse: None,
                             zName:
                                 b"datetime\x00" as *const u8 as
                                     *const libc::c_char,
                             u:
                                 C2RustUnnamed_3{pHash:
                                                     0 as *const FuncDef as
                                                         *mut FuncDef,},};
                 init
             },
             {
                 let mut init =
                     FuncDef{nArg: -(1 as libc::c_int) as i8_0,
                             funcFlags:
                                 (0x2000 as libc::c_int | 1 as libc::c_int |
                                      0x800 as libc::c_int) as u32_0,
                             pUserData:
                                 &sqlite3Config as *const Sqlite3Config as
                                     *mut Sqlite3Config as *mut libc::c_void,
                             pNext: 0 as *const FuncDef as *mut FuncDef,
                             xSFunc:
                                 Some(strftimeFunc as
                                          unsafe extern "C" fn(_:
                                                                   *mut sqlite3_context,
                                                               _: libc::c_int,
                                                               _:
                                                                   *mut *mut sqlite3_value)
                                              -> ()),
                             xFinalize: None,
                             xValue: None,
                             xInverse: None,
                             zName:
                                 b"strftime\x00" as *const u8 as
                                     *const libc::c_char,
                             u:
                                 C2RustUnnamed_3{pHash:
                                                     0 as *const FuncDef as
                                                         *mut FuncDef,},};
                 init
             },
             {
                 let mut init =
                     FuncDef{nArg: 0 as libc::c_int as i8_0,
                             funcFlags:
                                 (0x2000 as libc::c_int | 1 as libc::c_int) as
                                     u32_0,
                             pUserData:
                                 0 as *const libc::c_void as
                                     *mut libc::c_void,
                             pNext: 0 as *const FuncDef as *mut FuncDef,
                             xSFunc:
                                 Some(ctimeFunc as
                                          unsafe extern "C" fn(_:
                                                                   *mut sqlite3_context,
                                                               _: libc::c_int,
                                                               _:
                                                                   *mut *mut sqlite3_value)
                                              -> ()),
                             xFinalize: None,
                             xValue: None,
                             xInverse: None,
                             zName:
                                 b"current_time\x00" as *const u8 as
                                     *const libc::c_char,
                             u:
                                 C2RustUnnamed_3{pHash:
                                                     0 as *const FuncDef as
                                                         *mut FuncDef,},};
                 init
             },
             {
                 let mut init =
                     FuncDef{nArg: 0 as libc::c_int as i8_0,
                             funcFlags:
                                 (0x2000 as libc::c_int | 1 as libc::c_int) as
                                     u32_0,
                             pUserData:
                                 0 as *const libc::c_void as
                                     *mut libc::c_void,
                             pNext: 0 as *const FuncDef as *mut FuncDef,
                             xSFunc:
                                 Some(ctimestampFunc as
                                          unsafe extern "C" fn(_:
                                                                   *mut sqlite3_context,
                                                               _: libc::c_int,
                                                               _:
                                                                   *mut *mut sqlite3_value)
                                              -> ()),
                             xFinalize: None,
                             xValue: None,
                             xInverse: None,
                             zName:
                                 b"current_timestamp\x00" as *const u8 as
                                     *const libc::c_char,
                             u:
                                 C2RustUnnamed_3{pHash:
                                                     0 as *const FuncDef as
                                                         *mut FuncDef,},};
                 init
             },
             {
                 let mut init =
                     FuncDef{nArg: 0 as libc::c_int as i8_0,
                             funcFlags:
                                 (0x2000 as libc::c_int | 1 as libc::c_int) as
                                     u32_0,
                             pUserData:
                                 0 as *const libc::c_void as
                                     *mut libc::c_void,
                             pNext: 0 as *const FuncDef as *mut FuncDef,
                             xSFunc:
                                 Some(cdateFunc as
                                          unsafe extern "C" fn(_:
                                                                   *mut sqlite3_context,
                                                               _: libc::c_int,
                                                               _:
                                                                   *mut *mut sqlite3_value)
                                              -> ()),
                             xFinalize: None,
                             xValue: None,
                             xInverse: None,
                             zName:
                                 b"current_date\x00" as *const u8 as
                                     *const libc::c_char,
                             u:
                                 C2RustUnnamed_3{pHash:
                                                     0 as *const FuncDef as
                                                         *mut FuncDef,},};
                 init
             }]
        };
    sqlite3InsertBuiltinFuncs(aDateTimeFuncs.as_mut_ptr(),
                              (::std::mem::size_of::<[FuncDef; 8]>() as
                                   libc::c_ulong).wrapping_div(::std::mem::size_of::<FuncDef>()
                                                                   as
                                                                   libc::c_ulong)
                                  as libc::c_int);
}
unsafe extern "C" fn sqlite3OsClose(mut pId: *mut sqlite3_file) {
    if !(*pId).pMethods.is_null() {
        (*(*pId).pMethods).xClose.expect("non-null function pointer")(pId);
        (*pId).pMethods = 0 as *const sqlite3_io_methods
    };
}
unsafe extern "C" fn sqlite3OsRead(mut id: *mut sqlite3_file,
                                   mut pBuf: *mut libc::c_void,
                                   mut amt: libc::c_int, mut offset: i64_0)
 -> libc::c_int {
    return (*(*id).pMethods).xRead.expect("non-null function pointer")(id,
                                                                       pBuf,
                                                                       amt,
                                                                       offset);
}
unsafe extern "C" fn sqlite3OsWrite(mut id: *mut sqlite3_file,
                                    mut pBuf: *const libc::c_void,
                                    mut amt: libc::c_int, mut offset: i64_0)
 -> libc::c_int {
    return (*(*id).pMethods).xWrite.expect("non-null function pointer")(id,
                                                                        pBuf,
                                                                        amt,
                                                                        offset);
}
unsafe extern "C" fn sqlite3OsTruncate(mut id: *mut sqlite3_file,
                                       mut size: i64_0) -> libc::c_int {
    return (*(*id).pMethods).xTruncate.expect("non-null function pointer")(id,
                                                                           size);
}
unsafe extern "C" fn sqlite3OsSync(mut id: *mut sqlite3_file,
                                   mut flags: libc::c_int) -> libc::c_int {
    return if flags != 0 {
               (*(*id).pMethods).xSync.expect("non-null function pointer")(id,
                                                                           flags)
           } else { 0 as libc::c_int };
}
unsafe extern "C" fn sqlite3OsFileSize(mut id: *mut sqlite3_file,
                                       mut pSize: *mut i64_0) -> libc::c_int {
    return (*(*id).pMethods).xFileSize.expect("non-null function pointer")(id,
                                                                           pSize);
}
unsafe extern "C" fn sqlite3OsLock(mut id: *mut sqlite3_file,
                                   mut lockType: libc::c_int) -> libc::c_int {
    return (*(*id).pMethods).xLock.expect("non-null function pointer")(id,
                                                                       lockType);
}
unsafe extern "C" fn sqlite3OsUnlock(mut id: *mut sqlite3_file,
                                     mut lockType: libc::c_int)
 -> libc::c_int {
    return (*(*id).pMethods).xUnlock.expect("non-null function pointer")(id,
                                                                         lockType);
}
unsafe extern "C" fn sqlite3OsCheckReservedLock(mut id: *mut sqlite3_file,
                                                mut pResOut: *mut libc::c_int)
 -> libc::c_int {
    return (*(*id).pMethods).xCheckReservedLock.expect("non-null function pointer")(id,
                                                                                    pResOut);
}
unsafe extern "C" fn sqlite3OsFileControl(mut id: *mut sqlite3_file,
                                          mut op: libc::c_int,
                                          mut pArg: *mut libc::c_void)
 -> libc::c_int {
    if (*id).pMethods.is_null() { return 12 as libc::c_int }
    return (*(*id).pMethods).xFileControl.expect("non-null function pointer")(id,
                                                                              op,
                                                                              pArg);
}
unsafe extern "C" fn sqlite3OsFileControlHint(mut id: *mut sqlite3_file,
                                              mut op: libc::c_int,
                                              mut pArg: *mut libc::c_void) {
    if !(*id).pMethods.is_null() {
        (*(*id).pMethods).xFileControl.expect("non-null function pointer")(id,
                                                                           op,
                                                                           pArg);
    };
}
unsafe extern "C" fn sqlite3OsSectorSize(mut id: *mut sqlite3_file)
 -> libc::c_int {
    let mut xSectorSize:
            Option<unsafe extern "C" fn(_: *mut sqlite3_file)
                       -> libc::c_int> = (*(*id).pMethods).xSectorSize;
    return if xSectorSize.is_some() {
               xSectorSize.expect("non-null function pointer")(id)
           } else { 4096 as libc::c_int };
}
unsafe extern "C" fn sqlite3OsDeviceCharacteristics(mut id: *mut sqlite3_file)
 -> libc::c_int {
    return (*(*id).pMethods).xDeviceCharacteristics.expect("non-null function pointer")(id);
}
unsafe extern "C" fn sqlite3OsShmLock(mut id: *mut sqlite3_file,
                                      mut offset: libc::c_int,
                                      mut n: libc::c_int,
                                      mut flags: libc::c_int) -> libc::c_int {
    return (*(*id).pMethods).xShmLock.expect("non-null function pointer")(id,
                                                                          offset,
                                                                          n,
                                                                          flags);
}
unsafe extern "C" fn sqlite3OsShmBarrier(mut id: *mut sqlite3_file) {
    (*(*id).pMethods).xShmBarrier.expect("non-null function pointer")(id);
}
unsafe extern "C" fn sqlite3OsShmUnmap(mut id: *mut sqlite3_file,
                                       mut deleteFlag: libc::c_int)
 -> libc::c_int {
    return (*(*id).pMethods).xShmUnmap.expect("non-null function pointer")(id,
                                                                           deleteFlag);
}
unsafe extern "C" fn sqlite3OsShmMap(mut id: *mut sqlite3_file,
                                     mut iPage: libc::c_int,
                                     mut pgsz: libc::c_int,
                                     mut bExtend: libc::c_int,
                                     mut pp: *mut *mut libc::c_void)
 -> libc::c_int {
    return (*(*id).pMethods).xShmMap.expect("non-null function pointer")(id,
                                                                         iPage,
                                                                         pgsz,
                                                                         bExtend,
                                                                         pp);
}
unsafe extern "C" fn sqlite3OsFetch(mut id: *mut sqlite3_file,
                                    mut iOff: i64_0, mut iAmt: libc::c_int,
                                    mut pp: *mut *mut libc::c_void)
 -> libc::c_int {
    return (*(*id).pMethods).xFetch.expect("non-null function pointer")(id,
                                                                        iOff,
                                                                        iAmt,
                                                                        pp);
}
unsafe extern "C" fn sqlite3OsUnfetch(mut id: *mut sqlite3_file,
                                      mut iOff: i64_0,
                                      mut p: *mut libc::c_void)
 -> libc::c_int {
    return (*(*id).pMethods).xUnfetch.expect("non-null function pointer")(id,
                                                                          iOff,
                                                                          p);
}
unsafe extern "C" fn sqlite3OsOpen(mut pVfs: *mut sqlite3_vfs,
                                   mut zPath: *const libc::c_char,
                                   mut pFile: *mut sqlite3_file,
                                   mut flags: libc::c_int,
                                   mut pFlagsOut: *mut libc::c_int)
 -> libc::c_int {
    let mut rc: libc::c_int = 0;
    rc =
        (*pVfs).xOpen.expect("non-null function pointer")(pVfs, zPath, pFile,
                                                          flags &
                                                              0x1087f7f as
                                                                  libc::c_int,
                                                          pFlagsOut);
    return rc;
}
unsafe extern "C" fn sqlite3OsDelete(mut pVfs: *mut sqlite3_vfs,
                                     mut zPath: *const libc::c_char,
                                     mut dirSync: libc::c_int)
 -> libc::c_int {
    return (*pVfs).xDelete.expect("non-null function pointer")(pVfs, zPath,
                                                               dirSync);
}
unsafe extern "C" fn sqlite3OsAccess(mut pVfs: *mut sqlite3_vfs,
                                     mut zPath: *const libc::c_char,
                                     mut flags: libc::c_int,
                                     mut pResOut: *mut libc::c_int)
 -> libc::c_int {
    return (*pVfs).xAccess.expect("non-null function pointer")(pVfs, zPath,
                                                               flags,
                                                               pResOut);
}
unsafe extern "C" fn sqlite3OsFullPathname(mut pVfs: *mut sqlite3_vfs,
                                           mut zPath: *const libc::c_char,
                                           mut nPathOut: libc::c_int,
                                           mut zPathOut: *mut libc::c_char)
 -> libc::c_int {
    *zPathOut.offset(0 as libc::c_int as isize) =
        0 as libc::c_int as libc::c_char;
    return (*pVfs).xFullPathname.expect("non-null function pointer")(pVfs,
                                                                     zPath,
                                                                     nPathOut,
                                                                     zPathOut);
}
unsafe extern "C" fn sqlite3OsDlOpen(mut pVfs: *mut sqlite3_vfs,
                                     mut zPath: *const libc::c_char)
 -> *mut libc::c_void {
    return (*pVfs).xDlOpen.expect("non-null function pointer")(pVfs, zPath);
}
unsafe extern "C" fn sqlite3OsDlError(mut pVfs: *mut sqlite3_vfs,
                                      mut nByte: libc::c_int,
                                      mut zBufOut: *mut libc::c_char) {
    (*pVfs).xDlError.expect("non-null function pointer")(pVfs, nByte,
                                                         zBufOut);
}
unsafe extern "C" fn sqlite3OsDlSym(mut pVfs: *mut sqlite3_vfs,
                                    mut pHdle: *mut libc::c_void,
                                    mut zSym: *const libc::c_char)
 -> Option<unsafe extern "C" fn() -> ()> {
    return (*pVfs).xDlSym.expect("non-null function pointer")(pVfs, pHdle,
                                                              zSym);
}
unsafe extern "C" fn sqlite3OsDlClose(mut pVfs: *mut sqlite3_vfs,
                                      mut pHandle: *mut libc::c_void) {
    (*pVfs).xDlClose.expect("non-null function pointer")(pVfs, pHandle);
}
unsafe extern "C" fn sqlite3OsRandomness(mut pVfs: *mut sqlite3_vfs,
                                         mut nByte: libc::c_int,
                                         mut zBufOut: *mut libc::c_char)
 -> libc::c_int {
    if sqlite3Config.iPrngSeed != 0 {
        memset(zBufOut as *mut libc::c_void, 0 as libc::c_int,
               nByte as libc::c_ulong);
        if nByte >
               ::std::mem::size_of::<libc::c_uint>() as libc::c_ulong as
                   libc::c_int {
            nByte =
                ::std::mem::size_of::<libc::c_uint>() as libc::c_ulong as
                    libc::c_int
        }
        memcpy(zBufOut as *mut libc::c_void,
               &mut sqlite3Config.iPrngSeed as *mut libc::c_uint as
                   *const libc::c_void, nByte as libc::c_ulong);
        return 0 as libc::c_int
    } else {
        return (*pVfs).xRandomness.expect("non-null function pointer")(pVfs,
                                                                       nByte,
                                                                       zBufOut)
    };
}
unsafe extern "C" fn sqlite3OsSleep(mut pVfs: *mut sqlite3_vfs,
                                    mut nMicro: libc::c_int) -> libc::c_int {
    return (*pVfs).xSleep.expect("non-null function pointer")(pVfs, nMicro);
}
unsafe extern "C" fn sqlite3OsGetLastError(mut pVfs: *mut sqlite3_vfs)
 -> libc::c_int {
    return if (*pVfs).xGetLastError.is_some() {
               (*pVfs).xGetLastError.expect("non-null function pointer")(pVfs,
                                                                         0 as
                                                                             libc::c_int,
                                                                         0 as
                                                                             *mut libc::c_char)
           } else { 0 as libc::c_int };
}
unsafe extern "C" fn sqlite3OsCurrentTimeInt64(mut pVfs: *mut sqlite3_vfs,
                                               mut pTimeOut:
                                                   *mut sqlite3_int64)
 -> libc::c_int {
    let mut rc: libc::c_int = 0;
    if (*pVfs).iVersion >= 2 as libc::c_int &&
           (*pVfs).xCurrentTimeInt64.is_some() {
        rc =
            (*pVfs).xCurrentTimeInt64.expect("non-null function pointer")(pVfs,
                                                                          pTimeOut)
    } else {
        let mut r: libc::c_double = 0.;
        rc =
            (*pVfs).xCurrentTime.expect("non-null function pointer")(pVfs,
                                                                     &mut r);
        *pTimeOut = (r * 86400000.0f64) as sqlite3_int64
    }
    return rc;
}
unsafe extern "C" fn sqlite3OsOpenMalloc(mut pVfs: *mut sqlite3_vfs,
                                         mut zFile: *const libc::c_char,
                                         mut ppFile: *mut *mut sqlite3_file,
                                         mut flags: libc::c_int,
                                         mut pOutFlags: *mut libc::c_int)
 -> libc::c_int {
    let mut rc: libc::c_int = 0;
    let mut pFile: *mut sqlite3_file = 0 as *mut sqlite3_file;
    pFile = sqlite3MallocZero((*pVfs).szOsFile as u64_0) as *mut sqlite3_file;
    if !pFile.is_null() {
        rc = sqlite3OsOpen(pVfs, zFile, pFile, flags, pOutFlags);
        if rc != 0 as libc::c_int {
            sqlite3_free(pFile as *mut libc::c_void);
        } else { *ppFile = pFile }
    } else { rc = 7 as libc::c_int }
    return rc;
}
unsafe extern "C" fn sqlite3OsCloseFree(mut pFile: *mut sqlite3_file) {
    sqlite3OsClose(pFile);
    sqlite3_free(pFile as *mut libc::c_void);
}
unsafe extern "C" fn sqlite3OsInit() -> libc::c_int {
    let mut p: *mut libc::c_void = sqlite3_malloc(10 as libc::c_int);
    if p.is_null() { return 7 as libc::c_int }
    sqlite3_free(p);
    return sqlite3_os_init();
}
static mut vfsList: *mut sqlite3_vfs =
    0 as *const sqlite3_vfs as *mut sqlite3_vfs;
#[no_mangle]
pub unsafe extern "C" fn sqlite3_vfs_find(mut zVfs: *const libc::c_char)
 -> *mut sqlite3_vfs {
    let mut pVfs: *mut sqlite3_vfs = 0 as *mut sqlite3_vfs;
    let mut mutex: *mut sqlite3_mutex = 0 as *mut sqlite3_mutex;
    let mut rc: libc::c_int = sqlite3_initialize();
    if rc != 0 { return 0 as *mut sqlite3_vfs }
    mutex = sqlite3MutexAlloc(2 as libc::c_int);
    sqlite3_mutex_enter(mutex);
    pVfs = vfsList;
    while !pVfs.is_null() {
        if zVfs.is_null() { break ; }
        if strcmp(zVfs, (*pVfs).zName) == 0 as libc::c_int { break ; }
        pVfs = (*pVfs).pNext
    }
    sqlite3_mutex_leave(mutex);
    return pVfs;
}
unsafe extern "C" fn vfsUnlink(mut pVfs: *mut sqlite3_vfs) {
    if !pVfs.is_null() {
        if vfsList == pVfs {
            vfsList = (*pVfs).pNext
        } else if !vfsList.is_null() {
            let mut p: *mut sqlite3_vfs = vfsList;
            while !(*p).pNext.is_null() && (*p).pNext != pVfs {
                p = (*p).pNext
            }
            if (*p).pNext == pVfs { (*p).pNext = (*pVfs).pNext }
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_vfs_register(mut pVfs: *mut sqlite3_vfs,
                                              mut makeDflt: libc::c_int)
 -> libc::c_int {
    let mut mutex: *mut sqlite3_mutex = 0 as *mut sqlite3_mutex;
    let mut rc: libc::c_int = sqlite3_initialize();
    if rc != 0 { return rc }
    mutex = sqlite3MutexAlloc(2 as libc::c_int);
    sqlite3_mutex_enter(mutex);
    vfsUnlink(pVfs);
    if makeDflt != 0 || vfsList.is_null() {
        (*pVfs).pNext = vfsList;
        vfsList = pVfs
    } else { (*pVfs).pNext = (*vfsList).pNext; (*vfsList).pNext = pVfs }
    sqlite3_mutex_leave(mutex);
    return 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_vfs_unregister(mut pVfs: *mut sqlite3_vfs)
 -> libc::c_int {
    let mut mutex: *mut sqlite3_mutex = 0 as *mut sqlite3_mutex;
    let mut rc: libc::c_int = sqlite3_initialize();
    if rc != 0 { return rc }
    mutex = sqlite3MutexAlloc(2 as libc::c_int);
    sqlite3_mutex_enter(mutex);
    vfsUnlink(pVfs);
    sqlite3_mutex_leave(mutex);
    return 0 as libc::c_int;
}
static mut sqlite3Hooks: BenignMallocHooks =
    {
        let mut init =
            BenignMallocHooks{xBenignBegin: None, xBenignEnd: None,};
        init
    };
unsafe extern "C" fn sqlite3BenignMallocHooks(mut xBenignBegin:
                                                  Option<unsafe extern "C" fn()
                                                             -> ()>,
                                              mut xBenignEnd:
                                                  Option<unsafe extern "C" fn()
                                                             -> ()>) {
    sqlite3Hooks.xBenignBegin = xBenignBegin;
    sqlite3Hooks.xBenignEnd = xBenignEnd;
}
unsafe extern "C" fn sqlite3BeginBenignMalloc() {
    if sqlite3Hooks.xBenignBegin.is_some() {
        sqlite3Hooks.xBenignBegin.expect("non-null function pointer")();
    };
}
unsafe extern "C" fn sqlite3EndBenignMalloc() {
    if sqlite3Hooks.xBenignEnd.is_some() {
        sqlite3Hooks.xBenignEnd.expect("non-null function pointer")();
    };
}
unsafe extern "C" fn sqlite3MemMalloc(mut nByte: libc::c_int)
 -> *mut libc::c_void {
    let mut p: *mut sqlite3_int64 = 0 as *mut sqlite3_int64;
    p =
        malloc((nByte + 8 as libc::c_int) as libc::c_ulong) as
            *mut sqlite3_int64;
    if !p.is_null() {
        *p.offset(0 as libc::c_int as isize) = nByte as sqlite3_int64;
        p = p.offset(1)
    } else {
        sqlite3_log(7 as libc::c_int,
                    b"failed to allocate %u bytes of memory\x00" as *const u8
                        as *const libc::c_char, nByte);
    }
    return p as *mut libc::c_void;
}
unsafe extern "C" fn sqlite3MemFree(mut pPrior: *mut libc::c_void) {
    let mut p: *mut sqlite3_int64 = pPrior as *mut sqlite3_int64;
    p = p.offset(-1);
    free(p as *mut libc::c_void);
}
unsafe extern "C" fn sqlite3MemSize(mut pPrior: *mut libc::c_void)
 -> libc::c_int {
    let mut p: *mut sqlite3_int64 = 0 as *mut sqlite3_int64;
    p = pPrior as *mut sqlite3_int64;
    p = p.offset(-1);
    return *p.offset(0 as libc::c_int as isize) as libc::c_int;
}
unsafe extern "C" fn sqlite3MemRealloc(mut pPrior: *mut libc::c_void,
                                       mut nByte: libc::c_int)
 -> *mut libc::c_void {
    let mut p: *mut sqlite3_int64 = pPrior as *mut sqlite3_int64;
    p = p.offset(-1);
    p =
        realloc(p as *mut libc::c_void,
                (nByte + 8 as libc::c_int) as libc::c_ulong) as
            *mut sqlite3_int64;
    if !p.is_null() {
        *p.offset(0 as libc::c_int as isize) = nByte as sqlite3_int64;
        p = p.offset(1)
    } else {
        sqlite3_log(7 as libc::c_int,
                    b"failed memory resize %u to %u bytes\x00" as *const u8 as
                        *const libc::c_char, sqlite3MemSize(pPrior), nByte);
    }
    return p as *mut libc::c_void;
}
unsafe extern "C" fn sqlite3MemRoundup(mut n: libc::c_int) -> libc::c_int {
    return n + 7 as libc::c_int & !(7 as libc::c_int);
}
unsafe extern "C" fn sqlite3MemInit(mut NotUsed: *mut libc::c_void)
 -> libc::c_int {
    return 0 as libc::c_int;
}
unsafe extern "C" fn sqlite3MemShutdown(mut NotUsed: *mut libc::c_void) { }
unsafe extern "C" fn sqlite3MemSetDefault() {
    static mut defaultMethods: sqlite3_mem_methods =
        unsafe {
            {
                let mut init =
                    sqlite3_mem_methods{xMalloc:
                                            Some(sqlite3MemMalloc as
                                                     unsafe extern "C" fn(_:
                                                                              libc::c_int)
                                                         ->
                                                             *mut libc::c_void),
                                        xFree:
                                            Some(sqlite3MemFree as
                                                     unsafe extern "C" fn(_:
                                                                              *mut libc::c_void)
                                                         -> ()),
                                        xRealloc:
                                            Some(sqlite3MemRealloc as
                                                     unsafe extern "C" fn(_:
                                                                              *mut libc::c_void,
                                                                          _:
                                                                              libc::c_int)
                                                         ->
                                                             *mut libc::c_void),
                                        xSize:
                                            Some(sqlite3MemSize as
                                                     unsafe extern "C" fn(_:
                                                                              *mut libc::c_void)
                                                         -> libc::c_int),
                                        xRoundup:
                                            Some(sqlite3MemRoundup as
                                                     unsafe extern "C" fn(_:
                                                                              libc::c_int)
                                                         -> libc::c_int),
                                        xInit:
                                            Some(sqlite3MemInit as
                                                     unsafe extern "C" fn(_:
                                                                              *mut libc::c_void)
                                                         -> libc::c_int),
                                        xShutdown:
                                            Some(sqlite3MemShutdown as
                                                     unsafe extern "C" fn(_:
                                                                              *mut libc::c_void)
                                                         -> ()),
                                        pAppData:
                                            0 as *const libc::c_void as
                                                *mut libc::c_void,};
                init
            }
        };
    sqlite3_config(4 as libc::c_int,
                   &defaultMethods as *const sqlite3_mem_methods);
}
unsafe extern "C" fn sqlite3MutexInit() -> libc::c_int {
    let mut rc: libc::c_int = 0 as libc::c_int;
    if sqlite3Config.mutex.xMutexAlloc.is_none() {
        let mut pFrom: *const sqlite3_mutex_methods =
            0 as *const sqlite3_mutex_methods;
        let mut pTo: *mut sqlite3_mutex_methods = &mut sqlite3Config.mutex;
        if sqlite3Config.bCoreMutex != 0 {
            pFrom = sqlite3DefaultMutex()
        } else { pFrom = sqlite3NoopMutex() }
        (*pTo).xMutexInit = (*pFrom).xMutexInit;
        (*pTo).xMutexEnd = (*pFrom).xMutexEnd;
        (*pTo).xMutexFree = (*pFrom).xMutexFree;
        (*pTo).xMutexEnter = (*pFrom).xMutexEnter;
        (*pTo).xMutexTry = (*pFrom).xMutexTry;
        (*pTo).xMutexLeave = (*pFrom).xMutexLeave;
        (*pTo).xMutexHeld = (*pFrom).xMutexHeld;
        (*pTo).xMutexNotheld = (*pFrom).xMutexNotheld;
        sqlite3MemoryBarrier();
        (*pTo).xMutexAlloc = (*pFrom).xMutexAlloc
    }
    rc = sqlite3Config.mutex.xMutexInit.expect("non-null function pointer")();
    sqlite3MemoryBarrier();
    return rc;
}
unsafe extern "C" fn sqlite3MutexEnd() -> libc::c_int {
    let mut rc: libc::c_int = 0 as libc::c_int;
    if sqlite3Config.mutex.xMutexEnd.is_some() {
        rc =
            sqlite3Config.mutex.xMutexEnd.expect("non-null function pointer")()
    }
    return rc;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_mutex_alloc(mut id: libc::c_int)
 -> *mut sqlite3_mutex {
    if id <= 1 as libc::c_int && sqlite3_initialize() != 0 {
        return 0 as *mut sqlite3_mutex
    }
    if id > 1 as libc::c_int && sqlite3MutexInit() != 0 {
        return 0 as *mut sqlite3_mutex
    }
    return sqlite3Config.mutex.xMutexAlloc.expect("non-null function pointer")(id);
}
unsafe extern "C" fn sqlite3MutexAlloc(mut id: libc::c_int)
 -> *mut sqlite3_mutex {
    if sqlite3Config.bCoreMutex == 0 { return 0 as *mut sqlite3_mutex }
    return sqlite3Config.mutex.xMutexAlloc.expect("non-null function pointer")(id);
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_mutex_free(mut p: *mut sqlite3_mutex) {
    if !p.is_null() {
        sqlite3Config.mutex.xMutexFree.expect("non-null function pointer")(p);
    };
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_mutex_enter(mut p: *mut sqlite3_mutex) {
    if !p.is_null() {
        sqlite3Config.mutex.xMutexEnter.expect("non-null function pointer")(p);
    };
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_mutex_try(mut p: *mut sqlite3_mutex)
 -> libc::c_int {
    let mut rc: libc::c_int = 0 as libc::c_int;
    if !p.is_null() {
        return sqlite3Config.mutex.xMutexTry.expect("non-null function pointer")(p)
    }
    return rc;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_mutex_leave(mut p: *mut sqlite3_mutex) {
    if !p.is_null() {
        sqlite3Config.mutex.xMutexLeave.expect("non-null function pointer")(p);
    };
}
unsafe extern "C" fn noopMutexInit() -> libc::c_int {
    return 0 as libc::c_int;
}
unsafe extern "C" fn noopMutexEnd() -> libc::c_int {
    return 0 as libc::c_int;
}
unsafe extern "C" fn noopMutexAlloc(mut id: libc::c_int)
 -> *mut sqlite3_mutex {
    return 8 as libc::c_int as *mut sqlite3_mutex;
}
unsafe extern "C" fn noopMutexFree(mut p: *mut sqlite3_mutex) { }
unsafe extern "C" fn noopMutexEnter(mut p: *mut sqlite3_mutex) { }
unsafe extern "C" fn noopMutexTry(mut p: *mut sqlite3_mutex) -> libc::c_int {
    return 0 as libc::c_int;
}
unsafe extern "C" fn noopMutexLeave(mut p: *mut sqlite3_mutex) { }
unsafe extern "C" fn sqlite3NoopMutex() -> *const sqlite3_mutex_methods {
    static mut sMutex: sqlite3_mutex_methods =
        unsafe {
            {
                let mut init =
                    sqlite3_mutex_methods{xMutexInit:
                                              Some(noopMutexInit as
                                                       unsafe extern "C" fn()
                                                           -> libc::c_int),
                                          xMutexEnd:
                                              Some(noopMutexEnd as
                                                       unsafe extern "C" fn()
                                                           -> libc::c_int),
                                          xMutexAlloc:
                                              Some(noopMutexAlloc as
                                                       unsafe extern "C" fn(_:
                                                                                libc::c_int)
                                                           ->
                                                               *mut sqlite3_mutex),
                                          xMutexFree:
                                              Some(noopMutexFree as
                                                       unsafe extern "C" fn(_:
                                                                                *mut sqlite3_mutex)
                                                           -> ()),
                                          xMutexEnter:
                                              Some(noopMutexEnter as
                                                       unsafe extern "C" fn(_:
                                                                                *mut sqlite3_mutex)
                                                           -> ()),
                                          xMutexTry:
                                              Some(noopMutexTry as
                                                       unsafe extern "C" fn(_:
                                                                                *mut sqlite3_mutex)
                                                           -> libc::c_int),
                                          xMutexLeave:
                                              Some(noopMutexLeave as
                                                       unsafe extern "C" fn(_:
                                                                                *mut sqlite3_mutex)
                                                           -> ()),
                                          xMutexHeld: None,
                                          xMutexNotheld: None,};
                init
            }
        };
    return &sMutex;
}
unsafe extern "C" fn sqlite3MemoryBarrier() {
    ::std::intrinsics::atomic_fence();
}
unsafe extern "C" fn pthreadMutexInit() -> libc::c_int {
    return 0 as libc::c_int;
}
unsafe extern "C" fn pthreadMutexEnd() -> libc::c_int {
    return 0 as libc::c_int;
}
unsafe extern "C" fn pthreadMutexAlloc(mut iType: libc::c_int)
 -> *mut sqlite3_mutex {
    static mut staticMutexes: [sqlite3_mutex; 12] =
        [{
             let mut init =
                 sqlite3_mutex{mutex:
                                   pthread_mutex_t{__data:
                                                       {
                                                           let mut init =
                                                               __pthread_mutex_s{__lock:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __count:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __owner:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __nusers:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __kind:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __spins:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __elision:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __list:
                                                                                     {
                                                                                         let mut init =
                                                                                             __pthread_internal_list{__prev:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,
                                                                                                                     __next:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,};
                                                                                         init
                                                                                     },};
                                                           init
                                                       },},};
             init
         },
         {
             let mut init =
                 sqlite3_mutex{mutex:
                                   pthread_mutex_t{__data:
                                                       {
                                                           let mut init =
                                                               __pthread_mutex_s{__lock:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __count:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __owner:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __nusers:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __kind:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __spins:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __elision:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __list:
                                                                                     {
                                                                                         let mut init =
                                                                                             __pthread_internal_list{__prev:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,
                                                                                                                     __next:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,};
                                                                                         init
                                                                                     },};
                                                           init
                                                       },},};
             init
         },
         {
             let mut init =
                 sqlite3_mutex{mutex:
                                   pthread_mutex_t{__data:
                                                       {
                                                           let mut init =
                                                               __pthread_mutex_s{__lock:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __count:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __owner:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __nusers:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __kind:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __spins:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __elision:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __list:
                                                                                     {
                                                                                         let mut init =
                                                                                             __pthread_internal_list{__prev:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,
                                                                                                                     __next:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,};
                                                                                         init
                                                                                     },};
                                                           init
                                                       },},};
             init
         },
         {
             let mut init =
                 sqlite3_mutex{mutex:
                                   pthread_mutex_t{__data:
                                                       {
                                                           let mut init =
                                                               __pthread_mutex_s{__lock:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __count:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __owner:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __nusers:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __kind:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __spins:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __elision:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __list:
                                                                                     {
                                                                                         let mut init =
                                                                                             __pthread_internal_list{__prev:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,
                                                                                                                     __next:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,};
                                                                                         init
                                                                                     },};
                                                           init
                                                       },},};
             init
         },
         {
             let mut init =
                 sqlite3_mutex{mutex:
                                   pthread_mutex_t{__data:
                                                       {
                                                           let mut init =
                                                               __pthread_mutex_s{__lock:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __count:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __owner:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __nusers:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __kind:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __spins:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __elision:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __list:
                                                                                     {
                                                                                         let mut init =
                                                                                             __pthread_internal_list{__prev:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,
                                                                                                                     __next:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,};
                                                                                         init
                                                                                     },};
                                                           init
                                                       },},};
             init
         },
         {
             let mut init =
                 sqlite3_mutex{mutex:
                                   pthread_mutex_t{__data:
                                                       {
                                                           let mut init =
                                                               __pthread_mutex_s{__lock:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __count:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __owner:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __nusers:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __kind:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __spins:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __elision:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __list:
                                                                                     {
                                                                                         let mut init =
                                                                                             __pthread_internal_list{__prev:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,
                                                                                                                     __next:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,};
                                                                                         init
                                                                                     },};
                                                           init
                                                       },},};
             init
         },
         {
             let mut init =
                 sqlite3_mutex{mutex:
                                   pthread_mutex_t{__data:
                                                       {
                                                           let mut init =
                                                               __pthread_mutex_s{__lock:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __count:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __owner:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __nusers:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __kind:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __spins:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __elision:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __list:
                                                                                     {
                                                                                         let mut init =
                                                                                             __pthread_internal_list{__prev:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,
                                                                                                                     __next:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,};
                                                                                         init
                                                                                     },};
                                                           init
                                                       },},};
             init
         },
         {
             let mut init =
                 sqlite3_mutex{mutex:
                                   pthread_mutex_t{__data:
                                                       {
                                                           let mut init =
                                                               __pthread_mutex_s{__lock:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __count:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __owner:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __nusers:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __kind:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __spins:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __elision:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __list:
                                                                                     {
                                                                                         let mut init =
                                                                                             __pthread_internal_list{__prev:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,
                                                                                                                     __next:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,};
                                                                                         init
                                                                                     },};
                                                           init
                                                       },},};
             init
         },
         {
             let mut init =
                 sqlite3_mutex{mutex:
                                   pthread_mutex_t{__data:
                                                       {
                                                           let mut init =
                                                               __pthread_mutex_s{__lock:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __count:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __owner:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __nusers:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __kind:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __spins:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __elision:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __list:
                                                                                     {
                                                                                         let mut init =
                                                                                             __pthread_internal_list{__prev:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,
                                                                                                                     __next:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,};
                                                                                         init
                                                                                     },};
                                                           init
                                                       },},};
             init
         },
         {
             let mut init =
                 sqlite3_mutex{mutex:
                                   pthread_mutex_t{__data:
                                                       {
                                                           let mut init =
                                                               __pthread_mutex_s{__lock:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __count:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __owner:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __nusers:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __kind:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __spins:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __elision:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __list:
                                                                                     {
                                                                                         let mut init =
                                                                                             __pthread_internal_list{__prev:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,
                                                                                                                     __next:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,};
                                                                                         init
                                                                                     },};
                                                           init
                                                       },},};
             init
         },
         {
             let mut init =
                 sqlite3_mutex{mutex:
                                   pthread_mutex_t{__data:
                                                       {
                                                           let mut init =
                                                               __pthread_mutex_s{__lock:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __count:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __owner:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __nusers:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __kind:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __spins:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __elision:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __list:
                                                                                     {
                                                                                         let mut init =
                                                                                             __pthread_internal_list{__prev:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,
                                                                                                                     __next:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,};
                                                                                         init
                                                                                     },};
                                                           init
                                                       },},};
             init
         },
         {
             let mut init =
                 sqlite3_mutex{mutex:
                                   pthread_mutex_t{__data:
                                                       {
                                                           let mut init =
                                                               __pthread_mutex_s{__lock:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __count:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __owner:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __nusers:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_uint,
                                                                                 __kind:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int,
                                                                                 __spins:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __elision:
                                                                                     0
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         libc::c_short,
                                                                                 __list:
                                                                                     {
                                                                                         let mut init =
                                                                                             __pthread_internal_list{__prev:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,
                                                                                                                     __next:
                                                                                                                         0
                                                                                                                             as
                                                                                                                             *const __pthread_internal_list
                                                                                                                             as
                                                                                                                             *mut __pthread_internal_list,};
                                                                                         init
                                                                                     },};
                                                           init
                                                       },},};
             init
         }];
    let mut p: *mut sqlite3_mutex = 0 as *mut sqlite3_mutex;
    match iType {
        1 => {
            p =
                sqlite3MallocZero(::std::mem::size_of::<sqlite3_mutex>() as
                                      libc::c_ulong as u64_0) as
                    *mut sqlite3_mutex;
            if !p.is_null() {
                let mut recursiveAttr: pthread_mutexattr_t =
                    pthread_mutexattr_t{__size: [0; 4],};
                pthread_mutexattr_init(&mut recursiveAttr);
                pthread_mutexattr_settype(&mut recursiveAttr,
                                          PTHREAD_MUTEX_RECURSIVE as
                                              libc::c_int);
                pthread_mutex_init(&mut (*p).mutex, &mut recursiveAttr);
                pthread_mutexattr_destroy(&mut recursiveAttr);
            }
        }
        0 => {
            p =
                sqlite3MallocZero(::std::mem::size_of::<sqlite3_mutex>() as
                                      libc::c_ulong as u64_0) as
                    *mut sqlite3_mutex;
            if !p.is_null() {
                pthread_mutex_init(&mut (*p).mutex,
                                   0 as *const pthread_mutexattr_t);
            }
        }
        _ => {
            p =
                &mut *staticMutexes.as_mut_ptr().offset((iType -
                                                             2 as libc::c_int)
                                                            as isize) as
                    *mut sqlite3_mutex
        }
    }
    return p;
}
unsafe extern "C" fn pthreadMutexFree(mut p: *mut sqlite3_mutex) {
    pthread_mutex_destroy(&mut (*p).mutex);
    sqlite3_free(p as *mut libc::c_void);
}
unsafe extern "C" fn pthreadMutexEnter(mut p: *mut sqlite3_mutex) {
    pthread_mutex_lock(&mut (*p).mutex);
}
unsafe extern "C" fn pthreadMutexTry(mut p: *mut sqlite3_mutex)
 -> libc::c_int {
    let mut rc: libc::c_int = 0;
    if pthread_mutex_trylock(&mut (*p).mutex) == 0 as libc::c_int {
        rc = 0 as libc::c_int
    } else { rc = 5 as libc::c_int }
    return rc;
}
unsafe extern "C" fn pthreadMutexLeave(mut p: *mut sqlite3_mutex) {
    pthread_mutex_unlock(&mut (*p).mutex);
}
unsafe extern "C" fn sqlite3DefaultMutex() -> *const sqlite3_mutex_methods {
    static mut sMutex: sqlite3_mutex_methods =
        unsafe {
            {
                let mut init =
                    sqlite3_mutex_methods{xMutexInit:
                                              Some(pthreadMutexInit as
                                                       unsafe extern "C" fn()
                                                           -> libc::c_int),
                                          xMutexEnd:
                                              Some(pthreadMutexEnd as
                                                       unsafe extern "C" fn()
                                                           -> libc::c_int),
                                          xMutexAlloc:
                                              Some(pthreadMutexAlloc as
                                                       unsafe extern "C" fn(_:
                                                                                libc::c_int)
                                                           ->
                                                               *mut sqlite3_mutex),
                                          xMutexFree:
                                              Some(pthreadMutexFree as
                                                       unsafe extern "C" fn(_:
                                                                                *mut sqlite3_mutex)
                                                           -> ()),
                                          xMutexEnter:
                                              Some(pthreadMutexEnter as
                                                       unsafe extern "C" fn(_:
                                                                                *mut sqlite3_mutex)
                                                           -> ()),
                                          xMutexTry:
                                              Some(pthreadMutexTry as
                                                       unsafe extern "C" fn(_:
                                                                                *mut sqlite3_mutex)
                                                           -> libc::c_int),
                                          xMutexLeave:
                                              Some(pthreadMutexLeave as
                                                       unsafe extern "C" fn(_:
                                                                                *mut sqlite3_mutex)
                                                           -> ()),
                                          xMutexHeld: None,
                                          xMutexNotheld: None,};
                init
            }
        };
    return &sMutex;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_release_memory(mut n: libc::c_int)
 -> libc::c_int {
    return 0 as libc::c_int;
}
static mut mem0: Mem0Global =
    {
        let mut init =
            Mem0Global{mutex: 0 as *const sqlite3_mutex as *mut sqlite3_mutex,
                       alarmThreshold: 0 as libc::c_int as sqlite3_int64,
                       hardLimit: 0 as libc::c_int as sqlite3_int64,
                       nearlyFull: 0 as libc::c_int,};
        init
    };
unsafe extern "C" fn sqlite3MallocMutex() -> *mut sqlite3_mutex {
    return mem0.mutex;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_memory_alarm(mut xCallback:
                                                  Option<unsafe extern "C" fn(_:
                                                                                  *mut libc::c_void,
                                                                              _:
                                                                                  sqlite3_int64,
                                                                              _:
                                                                                  libc::c_int)
                                                             -> ()>,
                                              mut pArg: *mut libc::c_void,
                                              mut iThreshold: sqlite3_int64)
 -> libc::c_int {
    return 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_soft_heap_limit64(mut n: sqlite3_int64)
 -> sqlite3_int64 {
    let mut priorLimit: sqlite3_int64 = 0;
    let mut excess: sqlite3_int64 = 0;
    let mut nUsed: sqlite3_int64 = 0;
    let mut rc: libc::c_int = sqlite3_initialize();
    if rc != 0 { return -(1 as libc::c_int) as sqlite3_int64 }
    sqlite3_mutex_enter(mem0.mutex);
    priorLimit = mem0.alarmThreshold;
    if n < 0 as libc::c_int as libc::c_longlong {
        sqlite3_mutex_leave(mem0.mutex);
        return priorLimit
    }
    if mem0.hardLimit > 0 as libc::c_int as libc::c_longlong &&
           (n > mem0.hardLimit || n == 0 as libc::c_int as libc::c_longlong) {
        n = mem0.hardLimit
    }
    mem0.alarmThreshold = n;
    nUsed = sqlite3StatusValue(0 as libc::c_int);
    ::std::intrinsics::atomic_store_relaxed(&mut mem0.nearlyFull,
                                            (n >
                                                 0 as libc::c_int as
                                                     libc::c_longlong &&
                                                 n <= nUsed) as libc::c_int);
    sqlite3_mutex_leave(mem0.mutex);
    excess = sqlite3_memory_used() - n;
    if excess > 0 as libc::c_int as libc::c_longlong {
        sqlite3_release_memory((excess &
                                    0x7fffffff as libc::c_int as
                                        libc::c_longlong) as libc::c_int);
    }
    return priorLimit;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_soft_heap_limit(mut n: libc::c_int) {
    if n < 0 as libc::c_int { n = 0 as libc::c_int }
    sqlite3_soft_heap_limit64(n as sqlite3_int64);
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_hard_heap_limit64(mut n: sqlite3_int64)
 -> sqlite3_int64 {
    let mut priorLimit: sqlite3_int64 = 0;
    let mut rc: libc::c_int = sqlite3_initialize();
    if rc != 0 { return -(1 as libc::c_int) as sqlite3_int64 }
    sqlite3_mutex_enter(mem0.mutex);
    priorLimit = mem0.hardLimit;
    if n >= 0 as libc::c_int as libc::c_longlong {
        mem0.hardLimit = n;
        if n < mem0.alarmThreshold ||
               mem0.alarmThreshold == 0 as libc::c_int as libc::c_longlong {
            mem0.alarmThreshold = n
        }
    }
    sqlite3_mutex_leave(mem0.mutex);
    return priorLimit;
}
unsafe extern "C" fn sqlite3MallocInit() -> libc::c_int {
    let mut rc: libc::c_int = 0;
    if sqlite3Config.m.xMalloc.is_none() { sqlite3MemSetDefault(); }
    memset(&mut mem0 as *mut Mem0Global as *mut libc::c_void,
           0 as libc::c_int,
           ::std::mem::size_of::<Mem0Global>() as libc::c_ulong);
    mem0.mutex = sqlite3MutexAlloc(3 as libc::c_int);
    if sqlite3Config.pPage.is_null() ||
           sqlite3Config.szPage < 512 as libc::c_int ||
           sqlite3Config.nPage <= 0 as libc::c_int {
        sqlite3Config.pPage = 0 as *mut libc::c_void;
        sqlite3Config.szPage = 0 as libc::c_int
    }
    rc =
        sqlite3Config.m.xInit.expect("non-null function pointer")(sqlite3Config.m.pAppData);
    if rc != 0 as libc::c_int {
        memset(&mut mem0 as *mut Mem0Global as *mut libc::c_void,
               0 as libc::c_int,
               ::std::mem::size_of::<Mem0Global>() as libc::c_ulong);
    }
    return rc;
}
unsafe extern "C" fn sqlite3HeapNearlyFull() -> libc::c_int {
    return ::std::intrinsics::atomic_load_relaxed(&mut mem0.nearlyFull);
}
unsafe extern "C" fn sqlite3MallocEnd() {
    if sqlite3Config.m.xShutdown.is_some() {
        sqlite3Config.m.xShutdown.expect("non-null function pointer")(sqlite3Config.m.pAppData);
    }
    memset(&mut mem0 as *mut Mem0Global as *mut libc::c_void,
           0 as libc::c_int,
           ::std::mem::size_of::<Mem0Global>() as libc::c_ulong);
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_memory_used() -> sqlite3_int64 {
    let mut res: sqlite3_int64 = 0;
    let mut mx: sqlite3_int64 = 0;
    sqlite3_status64(0 as libc::c_int, &mut res, &mut mx, 0 as libc::c_int);
    return res;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_memory_highwater(mut resetFlag: libc::c_int)
 -> sqlite3_int64 {
    let mut res: sqlite3_int64 = 0;
    let mut mx: sqlite3_int64 = 0;
    sqlite3_status64(0 as libc::c_int, &mut res, &mut mx, resetFlag);
    return mx;
}
unsafe extern "C" fn sqlite3MallocAlarm(mut nByte: libc::c_int) {
    if mem0.alarmThreshold <= 0 as libc::c_int as libc::c_longlong { return }
    sqlite3_mutex_leave(mem0.mutex);
    sqlite3_release_memory(nByte);
    sqlite3_mutex_enter(mem0.mutex);
}
unsafe extern "C" fn mallocWithAlarm(mut n: libc::c_int,
                                     mut pp: *mut *mut libc::c_void) {
    let mut p: *mut libc::c_void = 0 as *mut libc::c_void;
    let mut nFull: libc::c_int = 0;
    nFull = sqlite3Config.m.xRoundup.expect("non-null function pointer")(n);
    sqlite3StatusHighwater(5 as libc::c_int, n);
    if mem0.alarmThreshold > 0 as libc::c_int as libc::c_longlong {
        let mut nUsed: sqlite3_int64 = sqlite3StatusValue(0 as libc::c_int);
        if nUsed >= mem0.alarmThreshold - nFull as libc::c_longlong {
            ::std::intrinsics::atomic_store_relaxed(&mut mem0.nearlyFull,
                                                    1 as libc::c_int);
            sqlite3MallocAlarm(nFull);
            if mem0.hardLimit != 0 {
                nUsed = sqlite3StatusValue(0 as libc::c_int);
                if nUsed >= mem0.hardLimit - nFull as libc::c_longlong {
                    *pp = 0 as *mut libc::c_void;
                    return
                }
            }
        } else {
            ::std::intrinsics::atomic_store_relaxed(&mut mem0.nearlyFull,
                                                    0 as libc::c_int);
        }
    }
    p = sqlite3Config.m.xMalloc.expect("non-null function pointer")(nFull);
    if !p.is_null() {
        nFull = sqlite3MallocSize(p);
        sqlite3StatusUp(0 as libc::c_int, nFull);
        sqlite3StatusUp(9 as libc::c_int, 1 as libc::c_int);
    }
    *pp = p;
}
unsafe extern "C" fn sqlite3Malloc(mut n: u64_0) -> *mut libc::c_void {
    let mut p: *mut libc::c_void = 0 as *mut libc::c_void;
    if n == 0 as libc::c_int as libc::c_ulonglong ||
           n >= 0x7fffff00 as libc::c_int as libc::c_ulonglong {
        p = 0 as *mut libc::c_void
    } else if sqlite3Config.bMemstat != 0 {
        sqlite3_mutex_enter(mem0.mutex);
        mallocWithAlarm(n as libc::c_int, &mut p);
        sqlite3_mutex_leave(mem0.mutex);
    } else {
        p =
            sqlite3Config.m.xMalloc.expect("non-null function pointer")(n as
                                                                            libc::c_int)
    }
    return p;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_malloc(mut n: libc::c_int)
 -> *mut libc::c_void {
    if sqlite3_initialize() != 0 { return 0 as *mut libc::c_void }
    return if n <= 0 as libc::c_int {
               0 as *mut libc::c_void
           } else { sqlite3Malloc(n as u64_0) };
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_malloc64(mut n: sqlite3_uint64)
 -> *mut libc::c_void {
    if sqlite3_initialize() != 0 { return 0 as *mut libc::c_void }
    return sqlite3Malloc(n);
}
unsafe extern "C" fn isLookaside(mut db: *mut sqlite3,
                                 mut p: *mut libc::c_void) -> libc::c_int {
    return (p as uptr >= (*db).lookaside.pStart as uptr &&
                (p as uptr) < (*db).lookaside.pEnd as uptr) as libc::c_int;
}
unsafe extern "C" fn sqlite3MallocSize(mut p: *mut libc::c_void)
 -> libc::c_int {
    return sqlite3Config.m.xSize.expect("non-null function pointer")(p);
}
unsafe extern "C" fn lookasideMallocSize(mut db: *mut sqlite3,
                                         mut p: *mut libc::c_void)
 -> libc::c_int {
    return if p < (*db).lookaside.pMiddle {
               (*db).lookaside.szTrue as libc::c_int
           } else { 128 as libc::c_int };
}
unsafe extern "C" fn sqlite3DbMallocSize(mut db: *mut sqlite3,
                                         mut p: *mut libc::c_void)
 -> libc::c_int {
    if !db.is_null() {
        if (p as uptr) < (*db).lookaside.pEnd as uptr {
            if p as uptr >= (*db).lookaside.pMiddle as uptr {
                return 128 as libc::c_int
            }
            if p as uptr >= (*db).lookaside.pStart as uptr {
                return (*db).lookaside.szTrue as libc::c_int
            }
        }
    }
    return sqlite3Config.m.xSize.expect("non-null function pointer")(p);
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_msize(mut p: *mut libc::c_void)
 -> sqlite3_uint64 {
    return if !p.is_null() {
               sqlite3Config.m.xSize.expect("non-null function pointer")(p)
           } else { 0 as libc::c_int } as sqlite3_uint64;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_free(mut p: *mut libc::c_void) {
    if p.is_null() { return }
    if sqlite3Config.bMemstat != 0 {
        sqlite3_mutex_enter(mem0.mutex);
        sqlite3StatusDown(0 as libc::c_int, sqlite3MallocSize(p));
        sqlite3StatusDown(9 as libc::c_int, 1 as libc::c_int);
        sqlite3Config.m.xFree.expect("non-null function pointer")(p);
        sqlite3_mutex_leave(mem0.mutex);
    } else { sqlite3Config.m.xFree.expect("non-null function pointer")(p); };
}
#[inline(never)]
unsafe extern "C" fn measureAllocationSize(mut db: *mut sqlite3,
                                           mut p: *mut libc::c_void) {
    *(*db).pnBytesFreed += sqlite3DbMallocSize(db, p);
}
unsafe extern "C" fn sqlite3DbFreeNN(mut db: *mut sqlite3,
                                     mut p: *mut libc::c_void) {
    if !db.is_null() {
        if !(*db).pnBytesFreed.is_null() {
            measureAllocationSize(db, p);
            return
        }
        if (p as uptr) < (*db).lookaside.pEnd as uptr {
            if p as uptr >= (*db).lookaside.pMiddle as uptr {
                let mut pBuf: *mut LookasideSlot = p as *mut LookasideSlot;
                (*pBuf).pNext = (*db).lookaside.pSmallFree;
                (*db).lookaside.pSmallFree = pBuf;
                return
            }
            if p as uptr >= (*db).lookaside.pStart as uptr {
                let mut pBuf_0: *mut LookasideSlot = p as *mut LookasideSlot;
                (*pBuf_0).pNext = (*db).lookaside.pFree;
                (*db).lookaside.pFree = pBuf_0;
                return
            }
        }
    }
    sqlite3_free(p);
}
unsafe extern "C" fn sqlite3DbFree(mut db: *mut sqlite3,
                                   mut p: *mut libc::c_void) {
    if !p.is_null() { sqlite3DbFreeNN(db, p); };
}
unsafe extern "C" fn sqlite3Realloc(mut pOld: *mut libc::c_void,
                                    mut nBytes: u64_0) -> *mut libc::c_void {
    let mut nOld: libc::c_int = 0;
    let mut nNew: libc::c_int = 0;
    let mut nDiff: libc::c_int = 0;
    let mut pNew: *mut libc::c_void = 0 as *mut libc::c_void;
    if pOld.is_null() { return sqlite3Malloc(nBytes) }
    if nBytes == 0 as libc::c_int as libc::c_ulonglong {
        sqlite3_free(pOld);
        return 0 as *mut libc::c_void
    }
    if nBytes >= 0x7fffff00 as libc::c_int as libc::c_ulonglong {
        return 0 as *mut libc::c_void
    }
    nOld = sqlite3MallocSize(pOld);
    nNew =
        sqlite3Config.m.xRoundup.expect("non-null function pointer")(nBytes as
                                                                         libc::c_int);
    if nOld == nNew {
        pNew = pOld
    } else if sqlite3Config.bMemstat != 0 {
        sqlite3_mutex_enter(mem0.mutex);
        sqlite3StatusHighwater(5 as libc::c_int, nBytes as libc::c_int);
        nDiff = nNew - nOld;
        if nDiff > 0 as libc::c_int &&
               sqlite3StatusValue(0 as libc::c_int) >=
                   mem0.alarmThreshold - nDiff as libc::c_longlong {
            sqlite3MallocAlarm(nDiff);
        }
        pNew =
            sqlite3Config.m.xRealloc.expect("non-null function pointer")(pOld,
                                                                         nNew);
        if !pNew.is_null() {
            nNew = sqlite3MallocSize(pNew);
            sqlite3StatusUp(0 as libc::c_int, nNew - nOld);
        }
        sqlite3_mutex_leave(mem0.mutex);
    } else {
        pNew =
            sqlite3Config.m.xRealloc.expect("non-null function pointer")(pOld,
                                                                         nNew)
    }
    return pNew;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_realloc(mut pOld: *mut libc::c_void,
                                         mut n: libc::c_int)
 -> *mut libc::c_void {
    if sqlite3_initialize() != 0 { return 0 as *mut libc::c_void }
    if n < 0 as libc::c_int { n = 0 as libc::c_int }
    return sqlite3Realloc(pOld, n as u64_0);
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_realloc64(mut pOld: *mut libc::c_void,
                                           mut n: sqlite3_uint64)
 -> *mut libc::c_void {
    if sqlite3_initialize() != 0 { return 0 as *mut libc::c_void }
    return sqlite3Realloc(pOld, n);
}
unsafe extern "C" fn sqlite3MallocZero(mut n: u64_0) -> *mut libc::c_void {
    let mut p: *mut libc::c_void = sqlite3Malloc(n);
    if !p.is_null() { memset(p, 0 as libc::c_int, n as size_t); }
    return p;
}
unsafe extern "C" fn sqlite3DbMallocZero(mut db: *mut sqlite3, mut n: u64_0)
 -> *mut libc::c_void {
    let mut p: *mut libc::c_void = 0 as *mut libc::c_void;
    p = sqlite3DbMallocRaw(db, n);
    if !p.is_null() { memset(p, 0 as libc::c_int, n as size_t); }
    return p;
}
#[inline(never)]
unsafe extern "C" fn dbMallocRawFinish(mut db: *mut sqlite3, mut n: u64_0)
 -> *mut libc::c_void {
    let mut p: *mut libc::c_void = 0 as *mut libc::c_void;
    p = sqlite3Malloc(n);
    if p.is_null() { sqlite3OomFault(db); }
    return p;
}
unsafe extern "C" fn sqlite3DbMallocRaw(mut db: *mut sqlite3, mut n: u64_0)
 -> *mut libc::c_void {
    let mut p: *mut libc::c_void = 0 as *mut libc::c_void;
    if !db.is_null() { return sqlite3DbMallocRawNN(db, n) }
    p = sqlite3Malloc(n);
    return p;
}
unsafe extern "C" fn sqlite3DbMallocRawNN(mut db: *mut sqlite3, mut n: u64_0)
 -> *mut libc::c_void {
    let mut pBuf: *mut LookasideSlot = 0 as *mut LookasideSlot;
    if n > (*db).lookaside.sz as libc::c_ulonglong {
        if (*db).lookaside.bDisable == 0 {
            (*db).lookaside.anStat[1 as libc::c_int as usize] =
                (*db).lookaside.anStat[1 as libc::c_int as
                                           usize].wrapping_add(1)
        } else if (*db).mallocFailed != 0 { return 0 as *mut libc::c_void }
        return dbMallocRawFinish(db, n)
    }
    if n <= 128 as libc::c_int as libc::c_ulonglong {
        pBuf = (*db).lookaside.pSmallFree;
        if !pBuf.is_null() {
            (*db).lookaside.pSmallFree = (*pBuf).pNext;
            (*db).lookaside.anStat[0 as libc::c_int as usize] =
                (*db).lookaside.anStat[0 as libc::c_int as
                                           usize].wrapping_add(1);
            return pBuf as *mut libc::c_void
        } else {
            pBuf = (*db).lookaside.pSmallInit;
            if !pBuf.is_null() {
                (*db).lookaside.pSmallInit = (*pBuf).pNext;
                (*db).lookaside.anStat[0 as libc::c_int as usize] =
                    (*db).lookaside.anStat[0 as libc::c_int as
                                               usize].wrapping_add(1);
                return pBuf as *mut libc::c_void
            }
        }
    }
    pBuf = (*db).lookaside.pFree;
    if !pBuf.is_null() {
        (*db).lookaside.pFree = (*pBuf).pNext;
        (*db).lookaside.anStat[0 as libc::c_int as usize] =
            (*db).lookaside.anStat[0 as libc::c_int as usize].wrapping_add(1);
        return pBuf as *mut libc::c_void
    } else {
        pBuf = (*db).lookaside.pInit;
        if !pBuf.is_null() {
            (*db).lookaside.pInit = (*pBuf).pNext;
            (*db).lookaside.anStat[0 as libc::c_int as usize] =
                (*db).lookaside.anStat[0 as libc::c_int as
                                           usize].wrapping_add(1);
            return pBuf as *mut libc::c_void
        } else {
            (*db).lookaside.anStat[2 as libc::c_int as usize] =
                (*db).lookaside.anStat[2 as libc::c_int as
                                           usize].wrapping_add(1)
        }
    }
    return dbMallocRawFinish(db, n);
}
unsafe extern "C" fn sqlite3DbRealloc(mut db: *mut sqlite3,
                                      mut p: *mut libc::c_void, mut n: u64_0)
 -> *mut libc::c_void {
    if p.is_null() { return sqlite3DbMallocRawNN(db, n) }
    if (p as uptr) < (*db).lookaside.pEnd as uptr {
        if p as uptr >= (*db).lookaside.pMiddle as uptr {
            if n <= 128 as libc::c_int as libc::c_ulonglong { return p }
        } else if p as uptr >= (*db).lookaside.pStart as uptr {
            if n <= (*db).lookaside.szTrue as libc::c_ulonglong { return p }
        }
    }
    return dbReallocFinish(db, p, n);
}
#[inline(never)]
unsafe extern "C" fn dbReallocFinish(mut db: *mut sqlite3,
                                     mut p: *mut libc::c_void, mut n: u64_0)
 -> *mut libc::c_void {
    let mut pNew: *mut libc::c_void = 0 as *mut libc::c_void;
    if (*db).mallocFailed as libc::c_int == 0 as libc::c_int {
        if isLookaside(db, p) != 0 {
            pNew = sqlite3DbMallocRawNN(db, n);
            if !pNew.is_null() {
                memcpy(pNew, p, lookasideMallocSize(db, p) as libc::c_ulong);
                sqlite3DbFree(db, p);
            }
        } else {
            pNew = sqlite3Realloc(p, n);
            if pNew.is_null() { sqlite3OomFault(db); }
        }
    }
    return pNew;
}
unsafe extern "C" fn sqlite3DbReallocOrFree(mut db: *mut sqlite3,
                                            mut p: *mut libc::c_void,
                                            mut n: u64_0)
 -> *mut libc::c_void {
    let mut pNew: *mut libc::c_void = 0 as *mut libc::c_void;
    pNew = sqlite3DbRealloc(db, p, n);
    if pNew.is_null() { sqlite3DbFree(db, p); }
    return pNew;
}
unsafe extern "C" fn sqlite3DbStrDup(mut db: *mut sqlite3,
                                     mut z: *const libc::c_char)
 -> *mut libc::c_char {
    let mut zNew: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut n: size_t = 0;
    if z.is_null() { return 0 as *mut libc::c_char }
    n = strlen(z).wrapping_add(1 as libc::c_int as libc::c_ulong);
    zNew = sqlite3DbMallocRaw(db, n as u64_0) as *mut libc::c_char;
    if !zNew.is_null() {
        memcpy(zNew as *mut libc::c_void, z as *const libc::c_void, n);
    }
    return zNew;
}
unsafe extern "C" fn sqlite3DbStrNDup(mut db: *mut sqlite3,
                                      mut z: *const libc::c_char,
                                      mut n: u64_0) -> *mut libc::c_char {
    let mut zNew: *mut libc::c_char = 0 as *mut libc::c_char;
    if z.is_null() { return 0 as *mut libc::c_char }
    zNew =
        sqlite3DbMallocRawNN(db,
                             n.wrapping_add(1 as libc::c_int as
                                                libc::c_ulonglong)) as
            *mut libc::c_char;
    if !zNew.is_null() {
        memcpy(zNew as *mut libc::c_void, z as *const libc::c_void,
               n as size_t);
        *zNew.offset(n as isize) = 0 as libc::c_int as libc::c_char
    }
    return zNew;
}
unsafe extern "C" fn sqlite3DbSpanDup(mut db: *mut sqlite3,
                                      mut zStart: *const libc::c_char,
                                      mut zEnd: *const libc::c_char)
 -> *mut libc::c_char {
    let mut n: libc::c_int = 0;
    while sqlite3CtypeMap[*zStart.offset(0 as libc::c_int as isize) as
                              libc::c_uchar as usize] as libc::c_int &
              0x1 as libc::c_int != 0 {
        zStart = zStart.offset(1)
    }
    n = zEnd.wrapping_offset_from(zStart) as libc::c_long as libc::c_int;
    while n > 0 as libc::c_int &&
              sqlite3CtypeMap[*zStart.offset((n - 1 as libc::c_int) as isize)
                                  as libc::c_uchar as usize] as libc::c_int &
                  0x1 as libc::c_int != 0 {
        n -= 1
    }
    return sqlite3DbStrNDup(db, zStart, n as u64_0);
}
unsafe extern "C" fn sqlite3SetString(mut pz: *mut *mut libc::c_char,
                                      mut db: *mut sqlite3,
                                      mut zNew: *const libc::c_char) {
    sqlite3DbFree(db, *pz as *mut libc::c_void);
    *pz = sqlite3DbStrDup(db, zNew);
}
unsafe extern "C" fn sqlite3OomFault(mut db: *mut sqlite3) {
    if (*db).mallocFailed as libc::c_int == 0 as libc::c_int &&
           (*db).bBenignMalloc as libc::c_int == 0 as libc::c_int {
        (*db).mallocFailed = 1 as libc::c_int as u8_0;
        if (*db).nVdbeExec > 0 as libc::c_int {
            ::std::intrinsics::atomic_store_relaxed(&mut (*db).u1.isInterrupted,
                                                    1 as libc::c_int);
        }
        (*db).lookaside.bDisable = (*db).lookaside.bDisable.wrapping_add(1);
        (*db).lookaside.sz = 0 as libc::c_int as u16_0;
        if !(*db).pParse.is_null() { (*(*db).pParse).rc = 7 as libc::c_int }
    };
}
unsafe extern "C" fn sqlite3OomClear(mut db: *mut sqlite3) {
    if (*db).mallocFailed as libc::c_int != 0 &&
           (*db).nVdbeExec == 0 as libc::c_int {
        (*db).mallocFailed = 0 as libc::c_int as u8_0;
        ::std::intrinsics::atomic_store_relaxed(&mut (*db).u1.isInterrupted,
                                                0 as libc::c_int);
        (*db).lookaside.bDisable = (*db).lookaside.bDisable.wrapping_sub(1);
        (*db).lookaside.sz =
            if (*db).lookaside.bDisable != 0 {
                0 as libc::c_int
            } else { (*db).lookaside.szTrue as libc::c_int } as u16_0
    };
}
#[inline(never)]
unsafe extern "C" fn apiOomError(mut db: *mut sqlite3) -> libc::c_int {
    sqlite3OomClear(db);
    sqlite3Error(db, 7 as libc::c_int);
    return 7 as libc::c_int;
}
unsafe extern "C" fn sqlite3ApiExit(mut db: *mut sqlite3, mut rc: libc::c_int)
 -> libc::c_int {
    if (*db).mallocFailed as libc::c_int != 0 ||
           rc == 10 as libc::c_int | (12 as libc::c_int) << 8 as libc::c_int {
        return apiOomError(db)
    }
    return rc & (*db).errMask;
}
static mut aDigits: [libc::c_char; 33] =
    [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 48, 49,
     50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 0];
static mut aPrefix: [libc::c_char; 7] = [45, 120, 48, 0, 88, 48, 0];
static mut fmtinfo: [et_info; 23] =
    [{
         let mut init =
             et_info{fmttype: 'd' as i32 as libc::c_char,
                     base: 10 as libc::c_int as etByte,
                     flags: 1 as libc::c_int as etByte,
                     type_0: 16 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 's' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 4 as libc::c_int as etByte,
                     type_0: 5 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'g' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 1 as libc::c_int as etByte,
                     type_0: 3 as libc::c_int as etByte,
                     charset: 30 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'z' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 4 as libc::c_int as etByte,
                     type_0: 6 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'q' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 4 as libc::c_int as etByte,
                     type_0: 9 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'Q' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 4 as libc::c_int as etByte,
                     type_0: 10 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'w' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 4 as libc::c_int as etByte,
                     type_0: 14 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'c' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 0 as libc::c_int as etByte,
                     type_0: 8 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'o' as i32 as libc::c_char,
                     base: 8 as libc::c_int as etByte,
                     flags: 0 as libc::c_int as etByte,
                     type_0: 0 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 2 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'u' as i32 as libc::c_char,
                     base: 10 as libc::c_int as etByte,
                     flags: 0 as libc::c_int as etByte,
                     type_0: 16 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'x' as i32 as libc::c_char,
                     base: 16 as libc::c_int as etByte,
                     flags: 0 as libc::c_int as etByte,
                     type_0: 0 as libc::c_int as etByte,
                     charset: 16 as libc::c_int as etByte,
                     prefix: 1 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'X' as i32 as libc::c_char,
                     base: 16 as libc::c_int as etByte,
                     flags: 0 as libc::c_int as etByte,
                     type_0: 0 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 4 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'f' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 1 as libc::c_int as etByte,
                     type_0: 1 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'e' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 1 as libc::c_int as etByte,
                     type_0: 2 as libc::c_int as etByte,
                     charset: 30 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'E' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 1 as libc::c_int as etByte,
                     type_0: 2 as libc::c_int as etByte,
                     charset: 14 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'G' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 1 as libc::c_int as etByte,
                     type_0: 3 as libc::c_int as etByte,
                     charset: 14 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'i' as i32 as libc::c_char,
                     base: 10 as libc::c_int as etByte,
                     flags: 1 as libc::c_int as etByte,
                     type_0: 16 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'n' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 0 as libc::c_int as etByte,
                     type_0: 4 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: '%' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 0 as libc::c_int as etByte,
                     type_0: 7 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'p' as i32 as libc::c_char,
                     base: 16 as libc::c_int as etByte,
                     flags: 0 as libc::c_int as etByte,
                     type_0: 13 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 1 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'T' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 0 as libc::c_int as etByte,
                     type_0: 11 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'S' as i32 as libc::c_char,
                     base: 0 as libc::c_int as etByte,
                     flags: 0 as libc::c_int as etByte,
                     type_0: 12 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     },
     {
         let mut init =
             et_info{fmttype: 'r' as i32 as libc::c_char,
                     base: 10 as libc::c_int as etByte,
                     flags: 1 as libc::c_int as etByte,
                     type_0: 15 as libc::c_int as etByte,
                     charset: 0 as libc::c_int as etByte,
                     prefix: 0 as libc::c_int as etByte,};
         init
     }];
static mut arRound: [libc::c_double; 10] =
    [5.0e-01f64, 5.0e-02f64, 5.0e-03f64, 5.0e-04f64, 5.0e-05f64, 5.0e-06f64,
     5.0e-07f64, 5.0e-08f64, 5.0e-09f64, 5.0e-10f64];
unsafe extern "C" fn et_getdigit(mut val: *mut f128::f128,
                                 mut cnt: *mut libc::c_int) -> libc::c_char {
    let mut digit: libc::c_int = 0;
    let mut d: f128::f128 = f128::f128::ZERO;
    if *cnt <= 0 as libc::c_int { return '0' as i32 as libc::c_char }
    *cnt -= 1;
    digit = (*val).to_i32().unwrap();
    d = f128::f128::new(digit);
    digit += '0' as i32;
    *val = (*val - d) * f128::f128::new(10.0f64);
    return digit as libc::c_char;
}
unsafe extern "C" fn setStrAccumError(mut p: *mut StrAccum,
                                      mut eError: u8_0) {
    (*p).accError = eError;
    if (*p).mxAlloc != 0 { sqlite3_str_reset(p); }
    if eError as libc::c_int == 18 as libc::c_int {
        sqlite3ErrorToParser((*p).db, eError as libc::c_int);
    };
}
unsafe extern "C" fn getIntArg(mut p: *mut PrintfArguments) -> sqlite3_int64 {
    if (*p).nArg <= (*p).nUsed { return 0 as libc::c_int as sqlite3_int64 }
    let fresh4 = (*p).nUsed;
    (*p).nUsed = (*p).nUsed + 1;
    return sqlite3_value_int64(*(*p).apArg.offset(fresh4 as isize));
}
unsafe extern "C" fn getDoubleArg(mut p: *mut PrintfArguments)
 -> libc::c_double {
    if (*p).nArg <= (*p).nUsed { return 0.0f64 }
    let fresh5 = (*p).nUsed;
    (*p).nUsed = (*p).nUsed + 1;
    return sqlite3_value_double(*(*p).apArg.offset(fresh5 as isize));
}
unsafe extern "C" fn getTextArg(mut p: *mut PrintfArguments)
 -> *mut libc::c_char {
    if (*p).nArg <= (*p).nUsed { return 0 as *mut libc::c_char }
    let fresh6 = (*p).nUsed;
    (*p).nUsed = (*p).nUsed + 1;
    return sqlite3_value_text(*(*p).apArg.offset(fresh6 as isize)) as
               *mut libc::c_char;
}
unsafe extern "C" fn printfTempBuf(mut pAccum: *mut sqlite3_str,
                                   mut n: sqlite3_int64)
 -> *mut libc::c_char {
    let mut z: *mut libc::c_char = 0 as *mut libc::c_char;
    if (*pAccum).accError != 0 { return 0 as *mut libc::c_char }
    if n > (*pAccum).nAlloc as libc::c_longlong &&
           n > (*pAccum).mxAlloc as libc::c_longlong {
        setStrAccumError(pAccum, 18 as libc::c_int as u8_0);
        return 0 as *mut libc::c_char
    }
    z = sqlite3DbMallocRaw((*pAccum).db, n as u64_0) as *mut libc::c_char;
    if z.is_null() { setStrAccumError(pAccum, 7 as libc::c_int as u8_0); }
    return z;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_str_vappendf(mut pAccum: *mut sqlite3_str,
                                              mut fmt: *const libc::c_char,
                                              mut ap: ::std::ffi::VaList) {
    let mut current_block: u64;
    let mut c: libc::c_int = 0;
    let mut bufpt: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut precision: libc::c_int = 0;
    let mut length: libc::c_int = 0;
    let mut idx: libc::c_int = 0;
    let mut width: libc::c_int = 0;
    let mut flag_leftjustify: etByte = 0;
    let mut flag_prefix: etByte = 0;
    let mut flag_alternateform: etByte = 0;
    let mut flag_altform2: etByte = 0;
    let mut flag_zeropad: etByte = 0;
    let mut flag_long: etByte = 0;
    let mut done: etByte = 0;
    let mut cThousand: etByte = 0;
    let mut xtype: etByte = 17 as libc::c_int as etByte;
    let mut bArgList: u8_0 = 0;
    let mut prefix: libc::c_char = 0;
    let mut longvalue: sqlite_uint64 = 0;
    let mut realvalue: f128::f128 = f128::f128::ZERO;
    let mut infop: *const et_info = 0 as *const et_info;
    let mut zOut: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut nOut: libc::c_int = 0;
    let mut zExtra: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut exp: libc::c_int = 0;
    let mut e2: libc::c_int = 0;
    let mut nsd: libc::c_int = 0;
    let mut rounder: libc::c_double = 0.;
    let mut flag_dp: etByte = 0;
    let mut flag_rtz: etByte = 0;
    let mut pArgList: *mut PrintfArguments = 0 as *mut PrintfArguments;
    let mut buf: [libc::c_char; 70] = [0; 70];
    bufpt = 0 as *mut libc::c_char;
    if (*pAccum).printfFlags as libc::c_int & 0x2 as libc::c_int !=
           0 as libc::c_int {
        pArgList = ap.as_va_list().arg::<*mut PrintfArguments>();
        bArgList = 1 as libc::c_int as u8_0
    } else { bArgList = 0 as libc::c_int as u8_0 }
    loop  {
        c = *fmt as libc::c_int;
        if !(c != 0 as libc::c_int) { break ; }
        if c != '%' as i32 {
            bufpt = fmt as *mut libc::c_char;
            loop  {
                fmt = fmt.offset(1);
                if !(*fmt as libc::c_int != 0 &&
                         *fmt as libc::c_int != '%' as i32) {
                    break ;
                }
            }
            sqlite3_str_append(pAccum, bufpt,
                               fmt.wrapping_offset_from(bufpt) as libc::c_long
                                   as libc::c_int);
            if *fmt as libc::c_int == 0 as libc::c_int { break ; }
        }
        fmt = fmt.offset(1);
        c = *fmt as libc::c_int;
        if c == 0 as libc::c_int {
            sqlite3_str_append(pAccum,
                               b"%\x00" as *const u8 as *const libc::c_char,
                               1 as libc::c_int);
            break ;
        } else {
            flag_zeropad = 0 as libc::c_int as etByte;
            flag_altform2 = flag_zeropad;
            flag_alternateform = flag_altform2;
            cThousand = flag_alternateform;
            flag_prefix = cThousand;
            flag_leftjustify = flag_prefix;
            done = 0 as libc::c_int as etByte;
            width = 0 as libc::c_int;
            flag_long = 0 as libc::c_int as etByte;
            precision = -(1 as libc::c_int);
            loop  {
                match c {
                    45 => { flag_leftjustify = 1 as libc::c_int as etByte }
                    43 => { flag_prefix = '+' as i32 as etByte }
                    32 => { flag_prefix = ' ' as i32 as etByte }
                    35 => { flag_alternateform = 1 as libc::c_int as etByte }
                    33 => { flag_altform2 = 1 as libc::c_int as etByte }
                    48 => { flag_zeropad = 1 as libc::c_int as etByte }
                    44 => { cThousand = ',' as i32 as etByte }
                    108 => {
                        flag_long = 1 as libc::c_int as etByte;
                        fmt = fmt.offset(1);
                        c = *fmt as libc::c_int;
                        if c == 'l' as i32 {
                            fmt = fmt.offset(1);
                            c = *fmt as libc::c_int;
                            flag_long = 2 as libc::c_int as etByte
                        }
                        done = 1 as libc::c_int as etByte
                    }
                    49 | 50 | 51 | 52 | 53 | 54 | 55 | 56 | 57 => {
                        let mut wx: libc::c_uint =
                            (c - '0' as i32) as libc::c_uint;
                        loop  {
                            fmt = fmt.offset(1);
                            c = *fmt as libc::c_int;
                            if !(c >= '0' as i32 && c <= '9' as i32) {
                                break ;
                            }
                            wx =
                                wx.wrapping_mul(10 as libc::c_int as
                                                    libc::c_uint).wrapping_add(c
                                                                                   as
                                                                                   libc::c_uint).wrapping_sub('0'
                                                                                                                  as
                                                                                                                  i32
                                                                                                                  as
                                                                                                                  libc::c_uint)
                        }
                        width =
                            (wx & 0x7fffffff as libc::c_int as libc::c_uint)
                                as libc::c_int;
                        if c != '.' as i32 && c != 'l' as i32 {
                            done = 1 as libc::c_int as etByte
                        } else { fmt = fmt.offset(-1) }
                    }
                    42 => {
                        if bArgList != 0 {
                            width = getIntArg(pArgList) as libc::c_int
                        } else {
                            width = ap.as_va_list().arg::<libc::c_int>()
                        }
                        if width < 0 as libc::c_int {
                            flag_leftjustify = 1 as libc::c_int as etByte;
                            width =
                                if width >= -(2147483647 as libc::c_int) {
                                    -width
                                } else { 0 as libc::c_int }
                        }
                        c =
                            *fmt.offset(1 as libc::c_int as isize) as
                                libc::c_int;
                        if c != '.' as i32 && c != 'l' as i32 {
                            fmt = fmt.offset(1);
                            c = *fmt as libc::c_int;
                            done = 1 as libc::c_int as etByte
                        }
                    }
                    46 => {
                        fmt = fmt.offset(1);
                        c = *fmt as libc::c_int;
                        if c == '*' as i32 {
                            if bArgList != 0 {
                                precision = getIntArg(pArgList) as libc::c_int
                            } else {
                                precision =
                                    ap.as_va_list().arg::<libc::c_int>()
                            }
                            if precision < 0 as libc::c_int {
                                precision =
                                    if precision >=
                                           -(2147483647 as libc::c_int) {
                                        -precision
                                    } else { -(1 as libc::c_int) }
                            }
                            fmt = fmt.offset(1);
                            c = *fmt as libc::c_int
                        } else {
                            let mut px: libc::c_uint =
                                0 as libc::c_int as libc::c_uint;
                            while c >= '0' as i32 && c <= '9' as i32 {
                                px =
                                    px.wrapping_mul(10 as libc::c_int as
                                                        libc::c_uint).wrapping_add(c
                                                                                       as
                                                                                       libc::c_uint).wrapping_sub('0'
                                                                                                                      as
                                                                                                                      i32
                                                                                                                      as
                                                                                                                      libc::c_uint);
                                fmt = fmt.offset(1);
                                c = *fmt as libc::c_int
                            }
                            precision =
                                (px &
                                     0x7fffffff as libc::c_int as
                                         libc::c_uint) as libc::c_int
                        }
                        if c == 'l' as i32 {
                            fmt = fmt.offset(-1)
                        } else { done = 1 as libc::c_int as etByte }
                    }
                    _ => { done = 1 as libc::c_int as etByte }
                }
                if !(done == 0 &&
                         {
                             fmt = fmt.offset(1);
                             c = *fmt as libc::c_int;
                             (c) != 0 as libc::c_int
                         }) {
                    break ;
                }
            }
            infop =
                &*fmtinfo.as_ptr().offset(0 as libc::c_int as isize) as
                    *const et_info;
            xtype = 17 as libc::c_int as etByte;
            idx = 0 as libc::c_int;
            while idx <
                      (::std::mem::size_of::<[et_info; 23]>() as
                           libc::c_ulong).wrapping_div(::std::mem::size_of::<et_info>()
                                                           as libc::c_ulong)
                          as libc::c_int {
                if c == fmtinfo[idx as usize].fmttype as libc::c_int {
                    infop =
                        &*fmtinfo.as_ptr().offset(idx as isize) as
                            *const et_info;
                    xtype = (*infop).type_0;
                    break ;
                } else { idx += 1 }
            }
            match xtype as libc::c_int {
                13 => {
                    flag_long =
                        if ::std::mem::size_of::<*mut libc::c_char>() as
                               libc::c_ulong ==
                               ::std::mem::size_of::<i64_0>() as libc::c_ulong
                           {
                            2 as libc::c_int
                        } else if ::std::mem::size_of::<*mut libc::c_char>()
                                      as libc::c_ulong ==
                                      ::std::mem::size_of::<libc::c_long>() as
                                          libc::c_ulong {
                            1 as libc::c_int
                        } else { 0 as libc::c_int } as etByte;
                    current_block = 13525776932060567462;
                }
                15 | 0 => { current_block = 13525776932060567462; }
                16 => { current_block = 4648980483242066537; }
                1 | 2 | 3 => {
                    if bArgList != 0 {
                        realvalue = f128::f128::new(getDoubleArg(pArgList))
                    } else {
                        realvalue =
                            f128::f128::new(ap.as_va_list().arg::<libc::c_double>())
                    }
                    if precision < 0 as libc::c_int {
                        precision = 6 as libc::c_int
                    }
                    if precision > 100000000 as libc::c_int {
                        precision = 100000000 as libc::c_int
                    }
                    if realvalue < f128::f128::new(0.0f64) {
                        realvalue = -realvalue;
                        prefix = '-' as i32 as libc::c_char
                    } else { prefix = flag_prefix as libc::c_char }
                    if xtype as libc::c_int == 3 as libc::c_int &&
                           precision > 0 as libc::c_int {
                        precision -= 1
                    }
                    idx = precision & 0xfff as libc::c_int;
                    rounder = arRound[(idx % 10 as libc::c_int) as usize];
                    while idx >= 10 as libc::c_int {
                        rounder *= 1.0e-10f64;
                        idx -= 10 as libc::c_int
                    }
                    if xtype as libc::c_int == 1 as libc::c_int {
                        let mut rx: libc::c_double =
                            realvalue.to_f64().unwrap();
                        let mut u: sqlite3_uint64 = 0;
                        let mut ex: libc::c_int = 0;
                        memcpy(&mut u as *mut sqlite3_uint64 as
                                   *mut libc::c_void,
                               &mut rx as *mut libc::c_double as
                                   *const libc::c_void,
                               ::std::mem::size_of::<sqlite3_uint64>() as
                                   libc::c_ulong);
                        ex =
                            -(1023 as libc::c_int) +
                                (u >> 52 as libc::c_int &
                                     0x7ff as libc::c_int as
                                         libc::c_ulonglong) as libc::c_int;
                        if (precision + ex / 3 as libc::c_int) <
                               15 as libc::c_int {
                            rounder =
                                (f128::f128::from(rounder) +
                                     realvalue *
                                         f128::f128::new(3e-16f64)).to_f64().unwrap()
                        }
                        realvalue += f128::f128::new(rounder)
                    }
                    exp = 0 as libc::c_int;
                    if sqlite3IsNaN(realvalue.to_f64().unwrap()) != 0 {
                        bufpt =
                            b"NaN\x00" as *const u8 as *const libc::c_char as
                                *mut libc::c_char;
                        length = 3 as libc::c_int
                    } else {
                        if realvalue > f128::f128::new(0.0f64) {
                            let mut scale: f128::f128 =
                                f128::f128::new(1.0f64);
                            while realvalue >=
                                      f128::f128::new(1e100f64) * scale &&
                                      exp <= 350 as libc::c_int {
                                scale *= f128::f128::new(1e100f64);
                                exp += 100 as libc::c_int
                            }
                            while realvalue >=
                                      f128::f128::new(1e10f64) * scale &&
                                      exp <= 350 as libc::c_int {
                                scale *= f128::f128::new(1e10f64);
                                exp += 10 as libc::c_int
                            }
                            while realvalue >=
                                      f128::f128::new(10.0f64) * scale &&
                                      exp <= 350 as libc::c_int {
                                scale *= f128::f128::new(10.0f64);
                                exp += 1
                            }
                            realvalue /= scale;
                            while realvalue < f128::f128::new(1e-8f64) {
                                realvalue *= f128::f128::new(1e8f64);
                                exp -= 8 as libc::c_int
                            }
                            while realvalue < f128::f128::new(1.0f64) {
                                realvalue *= f128::f128::new(10.0f64);
                                exp -= 1
                            }
                            if exp > 350 as libc::c_int {
                                bufpt = buf.as_mut_ptr();
                                buf[0 as libc::c_int as usize] = prefix;
                                memcpy(buf.as_mut_ptr().offset((prefix as
                                                                    libc::c_int
                                                                    !=
                                                                    0 as
                                                                        libc::c_int)
                                                                   as
                                                                   libc::c_int
                                                                   as isize)
                                           as *mut libc::c_void,
                                       b"Inf\x00" as *const u8 as
                                           *const libc::c_char as
                                           *const libc::c_void,
                                       4 as libc::c_int as libc::c_ulong);
                                length =
                                    3 as libc::c_int +
                                        (prefix as libc::c_int !=
                                             0 as libc::c_int) as libc::c_int;
                                current_block = 11211850645214766980;
                            } else { current_block = 3066043723669372660; }
                        } else { current_block = 3066043723669372660; }
                        match current_block {
                            11211850645214766980 => { }
                            _ => {
                                bufpt = buf.as_mut_ptr();
                                if xtype as libc::c_int != 1 as libc::c_int {
                                    realvalue += f128::f128::new(rounder);
                                    if realvalue >= f128::f128::new(10.0f64) {
                                        realvalue *= f128::f128::new(0.1f64);
                                        exp += 1
                                    }
                                }
                                if xtype as libc::c_int == 3 as libc::c_int {
                                    flag_rtz =
                                        (flag_alternateform == 0) as
                                            libc::c_int as etByte;
                                    if exp < -(4 as libc::c_int) ||
                                           exp > precision {
                                        xtype = 2 as libc::c_int as etByte
                                    } else {
                                        precision = precision - exp;
                                        xtype = 1 as libc::c_int as etByte
                                    }
                                } else { flag_rtz = flag_altform2 }
                                if xtype as libc::c_int == 2 as libc::c_int {
                                    e2 = 0 as libc::c_int
                                } else { e2 = exp }
                                let mut szBufNeeded: i64_0 = 0;
                                szBufNeeded =
                                    (if e2 > 0 as libc::c_int {
                                         e2
                                     } else { 0 as libc::c_int }) as
                                        libc::c_longlong + precision as i64_0
                                        + width as i64_0 +
                                        15 as libc::c_int as libc::c_longlong;
                                if szBufNeeded >
                                       70 as libc::c_int as libc::c_longlong {
                                    zExtra =
                                        printfTempBuf(pAccum, szBufNeeded);
                                    bufpt = zExtra;
                                    if bufpt.is_null() { return }
                                }
                                zOut = bufpt;
                                nsd =
                                    16 as libc::c_int +
                                        flag_altform2 as libc::c_int *
                                            10 as libc::c_int;
                                flag_dp =
                                    ((if precision > 0 as libc::c_int {
                                          1 as libc::c_int
                                      } else { 0 as libc::c_int }) |
                                         flag_alternateform as libc::c_int |
                                         flag_altform2 as libc::c_int) as
                                        etByte;
                                if prefix != 0 {
                                    let fresh7 = bufpt;
                                    bufpt = bufpt.offset(1);
                                    *fresh7 = prefix
                                }
                                if e2 < 0 as libc::c_int {
                                    let fresh8 = bufpt;
                                    bufpt = bufpt.offset(1);
                                    *fresh8 = '0' as i32 as libc::c_char
                                } else {
                                    while e2 >= 0 as libc::c_int {
                                        let fresh9 = bufpt;
                                        bufpt = bufpt.offset(1);
                                        *fresh9 =
                                            et_getdigit(&mut realvalue,
                                                        &mut nsd);
                                        e2 -= 1
                                    }
                                }
                                if flag_dp != 0 {
                                    let fresh10 = bufpt;
                                    bufpt = bufpt.offset(1);
                                    *fresh10 = '.' as i32 as libc::c_char
                                }
                                e2 += 1;
                                while e2 < 0 as libc::c_int {
                                    let fresh11 = bufpt;
                                    bufpt = bufpt.offset(1);
                                    *fresh11 = '0' as i32 as libc::c_char;
                                    precision -= 1;
                                    e2 += 1
                                }
                                loop  {
                                    let fresh12 = precision;
                                    precision = precision - 1;
                                    if !(fresh12 > 0 as libc::c_int) {
                                        break ;
                                    }
                                    let fresh13 = bufpt;
                                    bufpt = bufpt.offset(1);
                                    *fresh13 =
                                        et_getdigit(&mut realvalue, &mut nsd)
                                }
                                if flag_rtz as libc::c_int != 0 &&
                                       flag_dp as libc::c_int != 0 {
                                    while *bufpt.offset(-(1 as libc::c_int) as
                                                            isize) as
                                              libc::c_int == '0' as i32 {
                                        bufpt = bufpt.offset(-1);
                                        *bufpt =
                                            0 as libc::c_int as libc::c_char
                                    }
                                    if *bufpt.offset(-(1 as libc::c_int) as
                                                         isize) as libc::c_int
                                           == '.' as i32 {
                                        if flag_altform2 != 0 {
                                            let fresh14 = bufpt;
                                            bufpt = bufpt.offset(1);
                                            *fresh14 =
                                                '0' as i32 as libc::c_char
                                        } else {
                                            bufpt = bufpt.offset(-1);
                                            *bufpt =
                                                0 as libc::c_int as
                                                    libc::c_char
                                        }
                                    }
                                }
                                if xtype as libc::c_int == 2 as libc::c_int {
                                    let fresh15 = bufpt;
                                    bufpt = bufpt.offset(1);
                                    *fresh15 =
                                        aDigits[(*infop).charset as usize];
                                    if exp < 0 as libc::c_int {
                                        let fresh16 = bufpt;
                                        bufpt = bufpt.offset(1);
                                        *fresh16 = '-' as i32 as libc::c_char;
                                        exp = -exp
                                    } else {
                                        let fresh17 = bufpt;
                                        bufpt = bufpt.offset(1);
                                        *fresh17 = '+' as i32 as libc::c_char
                                    }
                                    if exp >= 100 as libc::c_int {
                                        let fresh18 = bufpt;
                                        bufpt = bufpt.offset(1);
                                        *fresh18 =
                                            (exp / 100 as libc::c_int +
                                                 '0' as i32) as libc::c_char;
                                        exp %= 100 as libc::c_int
                                    }
                                    let fresh19 = bufpt;
                                    bufpt = bufpt.offset(1);
                                    *fresh19 =
                                        (exp / 10 as libc::c_int + '0' as i32)
                                            as libc::c_char;
                                    let fresh20 = bufpt;
                                    bufpt = bufpt.offset(1);
                                    *fresh20 =
                                        (exp % 10 as libc::c_int + '0' as i32)
                                            as libc::c_char
                                }
                                *bufpt = 0 as libc::c_int as libc::c_char;
                                length =
                                    bufpt.wrapping_offset_from(zOut) as
                                        libc::c_long as libc::c_int;
                                bufpt = zOut;
                                if flag_zeropad as libc::c_int != 0 &&
                                       flag_leftjustify == 0 && length < width
                                   {
                                    let mut i: libc::c_int = 0;
                                    let mut nPad: libc::c_int =
                                        width - length;
                                    i = width;
                                    while i >= nPad {
                                        *bufpt.offset(i as isize) =
                                            *bufpt.offset((i - nPad) as
                                                              isize);
                                        i -= 1
                                    }
                                    i =
                                        (prefix as libc::c_int !=
                                             0 as libc::c_int) as libc::c_int;
                                    loop  {
                                        let fresh21 = nPad;
                                        nPad = nPad - 1;
                                        if !(fresh21 != 0) { break ; }
                                        let fresh22 = i;
                                        i = i + 1;
                                        *bufpt.offset(fresh22 as isize) =
                                            '0' as i32 as libc::c_char
                                    }
                                    length = width
                                }
                            }
                        }
                    }
                    current_block = 11211850645214766980;
                }
                4 => {
                    if bArgList == 0 {
                        *ap.as_va_list().arg::<*mut libc::c_int>() =
                            (*pAccum).nChar as libc::c_int
                    }
                    width = 0 as libc::c_int;
                    length = width;
                    current_block = 11211850645214766980;
                }
                7 => {
                    buf[0 as libc::c_int as usize] =
                        '%' as i32 as libc::c_char;
                    bufpt = buf.as_mut_ptr();
                    length = 1 as libc::c_int;
                    current_block = 11211850645214766980;
                }
                8 => {
                    if bArgList != 0 {
                        bufpt = getTextArg(pArgList);
                        length = 1 as libc::c_int;
                        if !bufpt.is_null() {
                            let fresh23 = bufpt;
                            bufpt = bufpt.offset(1);
                            c = *fresh23 as libc::c_int;
                            buf[0 as libc::c_int as usize] =
                                c as libc::c_char;
                            if c & 0xc0 as libc::c_int == 0xc0 as libc::c_int
                               {
                                while length < 4 as libc::c_int &&
                                          *bufpt.offset(0 as libc::c_int as
                                                            isize) as
                                              libc::c_int &
                                              0xc0 as libc::c_int ==
                                              0x80 as libc::c_int {
                                    let fresh24 = bufpt;
                                    bufpt = bufpt.offset(1);
                                    let fresh25 = length;
                                    length = length + 1;
                                    buf[fresh25 as usize] = *fresh24
                                }
                            }
                        } else {
                            buf[0 as libc::c_int as usize] =
                                0 as libc::c_int as libc::c_char
                        }
                    } else {
                        let mut ch: libc::c_uint =
                            ap.as_va_list().arg::<libc::c_uint>();
                        if ch < 0x80 as libc::c_int as libc::c_uint {
                            buf[0 as libc::c_int as usize] =
                                (ch & 0xff as libc::c_int as libc::c_uint) as
                                    libc::c_char;
                            length = 1 as libc::c_int
                        } else if ch < 0x800 as libc::c_int as libc::c_uint {
                            buf[0 as libc::c_int as usize] =
                                (0xc0 as libc::c_int +
                                     (ch >> 6 as libc::c_int &
                                          0x1f as libc::c_int as libc::c_uint)
                                         as u8_0 as libc::c_int) as
                                    libc::c_char;
                            buf[1 as libc::c_int as usize] =
                                (0x80 as libc::c_int +
                                     (ch &
                                          0x3f as libc::c_int as libc::c_uint)
                                         as u8_0 as libc::c_int) as
                                    libc::c_char;
                            length = 2 as libc::c_int
                        } else if ch < 0x10000 as libc::c_int as libc::c_uint
                         {
                            buf[0 as libc::c_int as usize] =
                                (0xe0 as libc::c_int +
                                     (ch >> 12 as libc::c_int &
                                          0xf as libc::c_int as libc::c_uint)
                                         as u8_0 as libc::c_int) as
                                    libc::c_char;
                            buf[1 as libc::c_int as usize] =
                                (0x80 as libc::c_int +
                                     (ch >> 6 as libc::c_int &
                                          0x3f as libc::c_int as libc::c_uint)
                                         as u8_0 as libc::c_int) as
                                    libc::c_char;
                            buf[2 as libc::c_int as usize] =
                                (0x80 as libc::c_int +
                                     (ch &
                                          0x3f as libc::c_int as libc::c_uint)
                                         as u8_0 as libc::c_int) as
                                    libc::c_char;
                            length = 3 as libc::c_int
                        } else {
                            buf[0 as libc::c_int as usize] =
                                (0xf0 as libc::c_int +
                                     (ch >> 18 as libc::c_int &
                                          0x7 as libc::c_int as libc::c_uint)
                                         as u8_0 as libc::c_int) as
                                    libc::c_char;
                            buf[1 as libc::c_int as usize] =
                                (0x80 as libc::c_int +
                                     (ch >> 12 as libc::c_int &
                                          0x3f as libc::c_int as libc::c_uint)
                                         as u8_0 as libc::c_int) as
                                    libc::c_char;
                            buf[2 as libc::c_int as usize] =
                                (0x80 as libc::c_int +
                                     (ch >> 6 as libc::c_int &
                                          0x3f as libc::c_int as libc::c_uint)
                                         as u8_0 as libc::c_int) as
                                    libc::c_char;
                            buf[3 as libc::c_int as usize] =
                                (0x80 as libc::c_int +
                                     (ch &
                                          0x3f as libc::c_int as libc::c_uint)
                                         as u8_0 as libc::c_int) as
                                    libc::c_char;
                            length = 4 as libc::c_int
                        }
                    }
                    if precision > 1 as libc::c_int {
                        width -= precision - 1 as libc::c_int;
                        if width > 1 as libc::c_int && flag_leftjustify == 0 {
                            sqlite3_str_appendchar(pAccum,
                                                   width - 1 as libc::c_int,
                                                   ' ' as i32 as
                                                       libc::c_char);
                            width = 0 as libc::c_int
                        }
                        loop  {
                            let fresh26 = precision;
                            precision = precision - 1;
                            if !(fresh26 > 1 as libc::c_int) { break ; }
                            sqlite3_str_append(pAccum, buf.as_mut_ptr(),
                                               length);
                        }
                    }
                    bufpt = buf.as_mut_ptr();
                    flag_altform2 = 1 as libc::c_int as etByte;
                    current_block = 11870105945373198560;
                }
                5 | 6 => {
                    if bArgList != 0 {
                        bufpt = getTextArg(pArgList);
                        xtype = 5 as libc::c_int as etByte
                    } else {
                        bufpt = ap.as_va_list().arg::<*mut libc::c_char>()
                    }
                    if bufpt.is_null() {
                        bufpt =
                            b"\x00" as *const u8 as *const libc::c_char as
                                *mut libc::c_char;
                        current_block = 17806356812449559122;
                    } else if xtype as libc::c_int == 6 as libc::c_int {
                        if (*pAccum).nChar == 0 as libc::c_int as libc::c_uint
                               && (*pAccum).mxAlloc != 0 &&
                               width == 0 as libc::c_int &&
                               precision < 0 as libc::c_int &&
                               (*pAccum).accError as libc::c_int ==
                                   0 as libc::c_int {
                            (*pAccum).zText = bufpt;
                            (*pAccum).nAlloc =
                                sqlite3DbMallocSize((*pAccum).db,
                                                    bufpt as
                                                        *mut libc::c_void) as
                                    u32_0;
                            (*pAccum).nChar =
                                (0x7fffffff as libc::c_int &
                                     strlen(bufpt) as libc::c_int) as u32_0;
                            (*pAccum).printfFlags =
                                ((*pAccum).printfFlags as libc::c_int |
                                     0x4 as libc::c_int) as u8_0;
                            length = 0 as libc::c_int;
                            current_block = 11211850645214766980;
                        } else {
                            zExtra = bufpt;
                            current_block = 17806356812449559122;
                        }
                    } else { current_block = 17806356812449559122; }
                    match current_block {
                        11211850645214766980 => { }
                        _ => {
                            if precision >= 0 as libc::c_int {
                                if flag_altform2 != 0 {
                                    let mut z: *mut libc::c_uchar =
                                        bufpt as *mut libc::c_uchar;
                                    loop  {
                                        let fresh27 = precision;
                                        precision = precision - 1;
                                        if !(fresh27 > 0 as libc::c_int &&
                                                 *z.offset(0 as libc::c_int as
                                                               isize) as
                                                     libc::c_int != 0) {
                                            break ;
                                        }
                                        let fresh28 = z;
                                        z = z.offset(1);
                                        if *fresh28 as libc::c_int >=
                                               0xc0 as libc::c_int {
                                            while *z as libc::c_int &
                                                      0xc0 as libc::c_int ==
                                                      0x80 as libc::c_int {
                                                z = z.offset(1)
                                            }
                                        }
                                    }
                                    length =
                                        z.wrapping_offset_from(bufpt as
                                                                   *mut libc::c_uchar)
                                            as libc::c_long as libc::c_int
                                } else {
                                    length = 0 as libc::c_int;
                                    while length < precision &&
                                              *bufpt.offset(length as isize)
                                                  as libc::c_int != 0 {
                                        length += 1
                                    }
                                }
                            } else {
                                length =
                                    0x7fffffff as libc::c_int &
                                        strlen(bufpt) as libc::c_int
                            }
                            current_block = 11870105945373198560;
                        }
                    }
                }
                9 | 10 | 14 => {
                    let mut i_0: libc::c_int = 0;
                    let mut j: libc::c_int = 0;
                    let mut k: libc::c_int = 0;
                    let mut n_0: libc::c_int = 0;
                    let mut isnull: libc::c_int = 0;
                    let mut needQuote: libc::c_int = 0;
                    let mut ch_0: libc::c_char = 0;
                    let mut q: libc::c_char =
                        if xtype as libc::c_int == 14 as libc::c_int {
                            '\"' as i32
                        } else { '\'' as i32 } as libc::c_char;
                    let mut escarg: *mut libc::c_char =
                        0 as *mut libc::c_char;
                    if bArgList != 0 {
                        escarg = getTextArg(pArgList)
                    } else {
                        escarg = ap.as_va_list().arg::<*mut libc::c_char>()
                    }
                    isnull =
                        (escarg == 0 as *mut libc::c_char) as libc::c_int;
                    if isnull != 0 {
                        escarg =
                            if xtype as libc::c_int == 10 as libc::c_int {
                                b"NULL\x00" as *const u8 as
                                    *const libc::c_char
                            } else {
                                b"(NULL)\x00" as *const u8 as
                                    *const libc::c_char
                            } as *mut libc::c_char
                    }
                    k = precision;
                    n_0 = 0 as libc::c_int;
                    i_0 = n_0;
                    while k != 0 as libc::c_int &&
                              {
                                  ch_0 = *escarg.offset(i_0 as isize);
                                  (ch_0 as libc::c_int) != 0 as libc::c_int
                              } {
                        if ch_0 as libc::c_int == q as libc::c_int {
                            n_0 += 1
                        }
                        if flag_altform2 as libc::c_int != 0 &&
                               ch_0 as libc::c_int & 0xc0 as libc::c_int ==
                                   0xc0 as libc::c_int {
                            while *escarg.offset((i_0 + 1 as libc::c_int) as
                                                     isize) as libc::c_int &
                                      0xc0 as libc::c_int ==
                                      0x80 as libc::c_int {
                                i_0 += 1
                            }
                        }
                        i_0 += 1;
                        k -= 1
                    }
                    needQuote =
                        (isnull == 0 &&
                             xtype as libc::c_int == 10 as libc::c_int) as
                            libc::c_int;
                    n_0 += i_0 + 3 as libc::c_int;
                    if n_0 > 70 as libc::c_int {
                        zExtra = printfTempBuf(pAccum, n_0 as sqlite3_int64);
                        bufpt = zExtra;
                        if bufpt.is_null() { return }
                    } else { bufpt = buf.as_mut_ptr() }
                    j = 0 as libc::c_int;
                    if needQuote != 0 {
                        let fresh30 = j;
                        j = j + 1;
                        *bufpt.offset(fresh30 as isize) = q
                    }
                    k = i_0;
                    i_0 = 0 as libc::c_int;
                    while i_0 < k {
                        ch_0 = *escarg.offset(i_0 as isize);
                        let fresh31 = j;
                        j = j + 1;
                        *bufpt.offset(fresh31 as isize) = ch_0;
                        if ch_0 as libc::c_int == q as libc::c_int {
                            let fresh32 = j;
                            j = j + 1;
                            *bufpt.offset(fresh32 as isize) = ch_0
                        }
                        i_0 += 1
                    }
                    if needQuote != 0 {
                        let fresh33 = j;
                        j = j + 1;
                        *bufpt.offset(fresh33 as isize) = q
                    }
                    *bufpt.offset(j as isize) =
                        0 as libc::c_int as libc::c_char;
                    length = j;
                    current_block = 11870105945373198560;
                }
                11 => {
                    let mut pToken: *mut Token = 0 as *mut Token;
                    if (*pAccum).printfFlags as libc::c_int &
                           0x1 as libc::c_int == 0 as libc::c_int {
                        return
                    }
                    pToken = ap.as_va_list().arg::<*mut Token>();
                    if !pToken.is_null() && (*pToken).n != 0 {
                        sqlite3_str_append(pAccum, (*pToken).z,
                                           (*pToken).n as libc::c_int);
                    }
                    width = 0 as libc::c_int;
                    length = width;
                    current_block = 11211850645214766980;
                }
                12 => {
                    let mut pSrc: *mut SrcList = 0 as *mut SrcList;
                    let mut k_0: libc::c_int = 0;
                    let mut pItem: *mut SrcList_item = 0 as *mut SrcList_item;
                    if (*pAccum).printfFlags as libc::c_int &
                           0x1 as libc::c_int == 0 as libc::c_int {
                        return
                    }
                    pSrc = ap.as_va_list().arg::<*mut SrcList>();
                    k_0 = ap.as_va_list().arg::<libc::c_int>();
                    pItem =
                        &mut *(*pSrc).a.as_mut_ptr().offset(k_0 as isize) as
                            *mut SrcList_item;
                    if !(*pItem).zDatabase.is_null() {
                        sqlite3_str_appendall(pAccum, (*pItem).zDatabase);
                        sqlite3_str_append(pAccum,
                                           b".\x00" as *const u8 as
                                               *const libc::c_char,
                                           1 as libc::c_int);
                    }
                    sqlite3_str_appendall(pAccum, (*pItem).zName);
                    width = 0 as libc::c_int;
                    length = width;
                    current_block = 11211850645214766980;
                }
                _ => { return }
            }
            match current_block {
                13525776932060567462 => {
                    cThousand = 0 as libc::c_int as etByte;
                    current_block = 4648980483242066537;
                }
                11870105945373198560 => {
                    if flag_altform2 as libc::c_int != 0 &&
                           width > 0 as libc::c_int {
                        let mut ii: libc::c_int = length - 1 as libc::c_int;
                        while ii >= 0 as libc::c_int {
                            let fresh29 = ii;
                            ii = ii - 1;
                            if *bufpt.offset(fresh29 as isize) as libc::c_int
                                   & 0xc0 as libc::c_int ==
                                   0x80 as libc::c_int {
                                width += 1
                            }
                        }
                    }
                    current_block = 11211850645214766980;
                }
                _ => { }
            }
            match current_block {
                4648980483242066537 => {
                    if (*infop).flags as libc::c_int & 1 as libc::c_int != 0 {
                        let mut v: i64_0 = 0;
                        if bArgList != 0 {
                            v = getIntArg(pArgList)
                        } else if flag_long != 0 {
                            if flag_long as libc::c_int == 2 as libc::c_int {
                                v = ap.as_va_list().arg::<i64_0>()
                            } else {
                                v =
                                    ap.as_va_list().arg::<libc::c_long>() as
                                        i64_0
                            }
                        } else {
                            v = ap.as_va_list().arg::<libc::c_int>() as i64_0
                        }
                        if v < 0 as libc::c_int as libc::c_longlong {
                            if v ==
                                   -(1 as libc::c_int) as i64_0 -
                                       (0xffffffff as libc::c_uint as
                                            libc::c_longlong |
                                            (0x7fffffff as libc::c_int as
                                                 i64_0) << 32 as libc::c_int)
                               {
                                longvalue =
                                    (1 as libc::c_int as u64_0) <<
                                        63 as libc::c_int
                            } else { longvalue = -v as sqlite_uint64 }
                            prefix = '-' as i32 as libc::c_char
                        } else {
                            longvalue = v as sqlite_uint64;
                            prefix = flag_prefix as libc::c_char
                        }
                    } else {
                        if bArgList != 0 {
                            longvalue = getIntArg(pArgList) as u64_0
                        } else if flag_long != 0 {
                            if flag_long as libc::c_int == 2 as libc::c_int {
                                longvalue = ap.as_va_list().arg::<u64_0>()
                            } else {
                                longvalue =
                                    ap.as_va_list().arg::<libc::c_ulong>() as
                                        sqlite_uint64
                            }
                        } else {
                            longvalue =
                                ap.as_va_list().arg::<libc::c_uint>() as
                                    sqlite_uint64
                        }
                        prefix = 0 as libc::c_int as libc::c_char
                    }
                    if longvalue == 0 as libc::c_int as libc::c_ulonglong {
                        flag_alternateform = 0 as libc::c_int as etByte
                    }
                    if flag_zeropad as libc::c_int != 0 &&
                           precision <
                               width -
                                   (prefix as libc::c_int != 0 as libc::c_int)
                                       as libc::c_int {
                        precision =
                            width -
                                (prefix as libc::c_int != 0 as libc::c_int) as
                                    libc::c_int
                    }
                    if precision <
                           70 as libc::c_int - 10 as libc::c_int -
                               70 as libc::c_int / 3 as libc::c_int {
                        nOut = 70 as libc::c_int;
                        zOut = buf.as_mut_ptr()
                    } else {
                        let mut n: u64_0 = 0;
                        n =
                            (precision as
                                 u64_0).wrapping_add(10 as libc::c_int as
                                                         libc::c_ulonglong);
                        if cThousand != 0 {
                            n =
                                (n as
                                     libc::c_ulonglong).wrapping_add((precision
                                                                          /
                                                                          3 as
                                                                              libc::c_int)
                                                                         as
                                                                         libc::c_ulonglong)
                                    as u64_0 as u64_0
                        }
                        zExtra = printfTempBuf(pAccum, n as sqlite3_int64);
                        zOut = zExtra;
                        if zOut.is_null() { return }
                        nOut = n as libc::c_int
                    }
                    bufpt =
                        &mut *zOut.offset((nOut - 1 as libc::c_int) as isize)
                            as *mut libc::c_char;
                    if xtype as libc::c_int == 15 as libc::c_int {
                        static mut zOrd: [libc::c_char; 9] =
                            [116, 104, 115, 116, 110, 100, 114, 100, 0];
                        let mut x: libc::c_int =
                            longvalue.wrapping_rem(10 as libc::c_int as
                                                       libc::c_ulonglong) as
                                libc::c_int;
                        if x >= 4 as libc::c_int ||
                               longvalue.wrapping_div(10 as libc::c_int as
                                                          libc::c_ulonglong).wrapping_rem(10
                                                                                              as
                                                                                              libc::c_int
                                                                                              as
                                                                                              libc::c_ulonglong)
                                   == 1 as libc::c_int as libc::c_ulonglong {
                            x = 0 as libc::c_int
                        }
                        bufpt = bufpt.offset(-1);
                        *bufpt =
                            zOrd[(x * 2 as libc::c_int + 1 as libc::c_int) as
                                     usize];
                        bufpt = bufpt.offset(-1);
                        *bufpt = zOrd[(x * 2 as libc::c_int) as usize]
                    }
                    let mut cset: *const libc::c_char =
                        &*aDigits.as_ptr().offset((*infop).charset as isize)
                            as *const libc::c_char;
                    let mut base: u8_0 = (*infop).base;
                    loop  {
                        bufpt = bufpt.offset(-1);
                        *bufpt =
                            *cset.offset(longvalue.wrapping_rem(base as
                                                                    libc::c_ulonglong)
                                             as isize);
                        longvalue =
                            longvalue.wrapping_div(base as libc::c_ulonglong);
                        if !(longvalue >
                                 0 as libc::c_int as libc::c_ulonglong) {
                            break ;
                        }
                    }
                    length =
                        (&mut *zOut.offset((nOut - 1 as libc::c_int) as isize)
                             as *mut libc::c_char).wrapping_offset_from(bufpt)
                            as libc::c_long as libc::c_int;
                    while precision > length {
                        bufpt = bufpt.offset(-1);
                        *bufpt = '0' as i32 as libc::c_char;
                        length += 1
                    }
                    if cThousand != 0 {
                        let mut nn: libc::c_int =
                            (length - 1 as libc::c_int) / 3 as libc::c_int;
                        let mut ix: libc::c_int =
                            (length - 1 as libc::c_int) % 3 as libc::c_int +
                                1 as libc::c_int;
                        bufpt = bufpt.offset(-(nn as isize));
                        idx = 0 as libc::c_int;
                        while nn > 0 as libc::c_int {
                            *bufpt.offset(idx as isize) =
                                *bufpt.offset((idx + nn) as isize);
                            ix -= 1;
                            if ix == 0 as libc::c_int {
                                idx += 1;
                                *bufpt.offset(idx as isize) =
                                    cThousand as libc::c_char;
                                nn -= 1;
                                ix = 3 as libc::c_int
                            }
                            idx += 1
                        }
                    }
                    if prefix != 0 {
                        bufpt = bufpt.offset(-1);
                        *bufpt = prefix
                    }
                    if flag_alternateform as libc::c_int != 0 &&
                           (*infop).prefix as libc::c_int != 0 {
                        let mut pre: *const libc::c_char =
                            0 as *const libc::c_char;
                        let mut x_0: libc::c_char = 0;
                        pre =
                            &*aPrefix.as_ptr().offset((*infop).prefix as
                                                          isize) as
                                *const libc::c_char;
                        loop  {
                            x_0 = *pre;
                            if !(x_0 as libc::c_int != 0 as libc::c_int) {
                                break ;
                            }
                            bufpt = bufpt.offset(-1);
                            *bufpt = x_0;
                            pre = pre.offset(1)
                        }
                    }
                    length =
                        (&mut *zOut.offset((nOut - 1 as libc::c_int) as isize)
                             as *mut libc::c_char).wrapping_offset_from(bufpt)
                            as libc::c_long as libc::c_int
                }
                _ => { }
            }
            width -= length;
            if width > 0 as libc::c_int {
                if flag_leftjustify == 0 {
                    sqlite3_str_appendchar(pAccum, width,
                                           ' ' as i32 as libc::c_char);
                }
                sqlite3_str_append(pAccum, bufpt, length);
                if flag_leftjustify != 0 {
                    sqlite3_str_appendchar(pAccum, width,
                                           ' ' as i32 as libc::c_char);
                }
            } else { sqlite3_str_append(pAccum, bufpt, length); }
            if !zExtra.is_null() {
                sqlite3DbFree((*pAccum).db, zExtra as *mut libc::c_void);
                zExtra = 0 as *mut libc::c_char
            }
            fmt = fmt.offset(1)
        }
    };
}
unsafe extern "C" fn sqlite3StrAccumEnlarge(mut p: *mut StrAccum,
                                            mut N: libc::c_int)
 -> libc::c_int {
    let mut zNew: *mut libc::c_char = 0 as *mut libc::c_char;
    if (*p).accError != 0 { return 0 as libc::c_int }
    if (*p).mxAlloc == 0 as libc::c_int as libc::c_uint {
        setStrAccumError(p, 18 as libc::c_int as u8_0);
        return (*p).nAlloc.wrapping_sub((*p).nChar).wrapping_sub(1 as
                                                                     libc::c_int
                                                                     as
                                                                     libc::c_uint)
                   as libc::c_int
    } else {
        let mut zOld: *mut libc::c_char =
            if (*p).printfFlags as libc::c_int & 0x4 as libc::c_int !=
                   0 as libc::c_int {
                (*p).zText
            } else { 0 as *mut libc::c_char };
        let mut szNew: i64_0 = (*p).nChar as i64_0;
        szNew += (N + 1 as libc::c_int) as libc::c_longlong;
        if szNew + (*p).nChar as libc::c_longlong <=
               (*p).mxAlloc as libc::c_longlong {
            szNew += (*p).nChar as libc::c_longlong
        }
        if szNew > (*p).mxAlloc as libc::c_longlong {
            sqlite3_str_reset(p);
            setStrAccumError(p, 18 as libc::c_int as u8_0);
            return 0 as libc::c_int
        } else { (*p).nAlloc = szNew as libc::c_int as u32_0 }
        if !(*p).db.is_null() {
            zNew =
                sqlite3DbRealloc((*p).db, zOld as *mut libc::c_void,
                                 (*p).nAlloc as u64_0) as *mut libc::c_char
        } else {
            zNew =
                sqlite3Realloc(zOld as *mut libc::c_void,
                               (*p).nAlloc as u64_0) as *mut libc::c_char
        }
        if !zNew.is_null() {
            if !((*p).printfFlags as libc::c_int & 0x4 as libc::c_int !=
                     0 as libc::c_int) &&
                   (*p).nChar > 0 as libc::c_int as libc::c_uint {
                memcpy(zNew as *mut libc::c_void,
                       (*p).zText as *const libc::c_void,
                       (*p).nChar as libc::c_ulong);
            }
            (*p).zText = zNew;
            (*p).nAlloc =
                sqlite3DbMallocSize((*p).db, zNew as *mut libc::c_void) as
                    u32_0;
            (*p).printfFlags =
                ((*p).printfFlags as libc::c_int | 0x4 as libc::c_int) as u8_0
        } else {
            sqlite3_str_reset(p);
            setStrAccumError(p, 7 as libc::c_int as u8_0);
            return 0 as libc::c_int
        }
    }
    return N;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_str_appendchar(mut p: *mut sqlite3_str,
                                                mut N: libc::c_int,
                                                mut c: libc::c_char) {
    if (*p).nChar as libc::c_longlong + N as i64_0 >=
           (*p).nAlloc as libc::c_longlong &&
           { N = sqlite3StrAccumEnlarge(p, N); (N) <= 0 as libc::c_int } {
        return
    }
    loop  {
        let fresh34 = N;
        N = N - 1;
        if !(fresh34 > 0 as libc::c_int) { break ; }
        let fresh35 = (*p).nChar;
        (*p).nChar = (*p).nChar.wrapping_add(1);
        *(*p).zText.offset(fresh35 as isize) = c
    };
}
#[inline(never)]
unsafe extern "C" fn enlargeAndAppend(mut p: *mut StrAccum,
                                      mut z: *const libc::c_char,
                                      mut N: libc::c_int) {
    N = sqlite3StrAccumEnlarge(p, N);
    if N > 0 as libc::c_int {
        memcpy(&mut *(*p).zText.offset((*p).nChar as isize) as
                   *mut libc::c_char as *mut libc::c_void,
               z as *const libc::c_void, N as libc::c_ulong);
        (*p).nChar =
            ((*p).nChar as libc::c_uint).wrapping_add(N as libc::c_uint) as
                u32_0 as u32_0
    };
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_str_append(mut p: *mut sqlite3_str,
                                            mut z: *const libc::c_char,
                                            mut N: libc::c_int) {
    if (*p).nChar.wrapping_add(N as libc::c_uint) >= (*p).nAlloc {
        enlargeAndAppend(p, z, N);
    } else if N != 0 {
        (*p).nChar =
            ((*p).nChar as libc::c_uint).wrapping_add(N as libc::c_uint) as
                u32_0 as u32_0;
        memcpy(&mut *(*p).zText.offset((*p).nChar.wrapping_sub(N as
                                                                   libc::c_uint)
                                           as isize) as *mut libc::c_char as
                   *mut libc::c_void, z as *const libc::c_void,
               N as libc::c_ulong);
    };
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_str_appendall(mut p: *mut sqlite3_str,
                                               mut z: *const libc::c_char) {
    sqlite3_str_append(p, z, sqlite3Strlen30(z));
}
#[inline(never)]
unsafe extern "C" fn strAccumFinishRealloc(mut p: *mut StrAccum)
 -> *mut libc::c_char {
    let mut zText: *mut libc::c_char = 0 as *mut libc::c_char;
    zText =
        sqlite3DbMallocRaw((*p).db,
                           (*p).nChar.wrapping_add(1 as libc::c_int as
                                                       libc::c_uint) as u64_0)
            as *mut libc::c_char;
    if !zText.is_null() {
        memcpy(zText as *mut libc::c_void, (*p).zText as *const libc::c_void,
               (*p).nChar.wrapping_add(1 as libc::c_int as libc::c_uint) as
                   libc::c_ulong);
        (*p).printfFlags =
            ((*p).printfFlags as libc::c_int | 0x4 as libc::c_int) as u8_0
    } else { setStrAccumError(p, 7 as libc::c_int as u8_0); }
    (*p).zText = zText;
    return zText;
}
unsafe extern "C" fn sqlite3StrAccumFinish(mut p: *mut StrAccum)
 -> *mut libc::c_char {
    if !(*p).zText.is_null() {
        *(*p).zText.offset((*p).nChar as isize) =
            0 as libc::c_int as libc::c_char;
        if (*p).mxAlloc > 0 as libc::c_int as libc::c_uint &&
               !((*p).printfFlags as libc::c_int & 0x4 as libc::c_int !=
                     0 as libc::c_int) {
            return strAccumFinishRealloc(p)
        }
    }
    return (*p).zText;
}
static mut sqlite3OomStr: sqlite3_str =
    {
        let mut init =
            sqlite3_str{db: 0 as *const sqlite3 as *mut sqlite3,
                        zText: 0 as *const libc::c_char as *mut libc::c_char,
                        nAlloc: 0 as libc::c_int as u32_0,
                        mxAlloc: 0 as libc::c_int as u32_0,
                        nChar: 0 as libc::c_int as u32_0,
                        accError: 7 as libc::c_int as u8_0,
                        printfFlags: 0 as libc::c_int as u8_0,};
        init
    };
#[no_mangle]
pub unsafe extern "C" fn sqlite3_str_finish(mut p: *mut sqlite3_str)
 -> *mut libc::c_char {
    let mut z: *mut libc::c_char = 0 as *mut libc::c_char;
    if !p.is_null() && p != &mut sqlite3OomStr as *mut sqlite3_str {
        z = sqlite3StrAccumFinish(p);
        sqlite3_free(p as *mut libc::c_void);
    } else { z = 0 as *mut libc::c_char }
    return z;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_str_errcode(mut p: *mut sqlite3_str)
 -> libc::c_int {
    return if !p.is_null() {
               (*p).accError as libc::c_int
           } else { 7 as libc::c_int };
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_str_length(mut p: *mut sqlite3_str)
 -> libc::c_int {
    return if !p.is_null() {
               (*p).nChar
           } else { 0 as libc::c_int as libc::c_uint } as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_str_value(mut p: *mut sqlite3_str)
 -> *mut libc::c_char {
    if p.is_null() || (*p).nChar == 0 as libc::c_int as libc::c_uint {
        return 0 as *mut libc::c_char
    }
    *(*p).zText.offset((*p).nChar as isize) =
        0 as libc::c_int as libc::c_char;
    return (*p).zText;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_str_reset(mut p: *mut StrAccum) {
    if (*p).printfFlags as libc::c_int & 0x4 as libc::c_int !=
           0 as libc::c_int {
        sqlite3DbFree((*p).db, (*p).zText as *mut libc::c_void);
        (*p).printfFlags =
            ((*p).printfFlags as libc::c_int & !(0x4 as libc::c_int)) as u8_0
    }
    (*p).nAlloc = 0 as libc::c_int as u32_0;
    (*p).nChar = 0 as libc::c_int as u32_0;
    (*p).zText = 0 as *mut libc::c_char;
}
unsafe extern "C" fn sqlite3StrAccumInit(mut p: *mut StrAccum,
                                         mut db: *mut sqlite3,
                                         mut zBase: *mut libc::c_char,
                                         mut n: libc::c_int,
                                         mut mx: libc::c_int) {
    (*p).zText = zBase;
    (*p).db = db;
    (*p).nAlloc = n as u32_0;
    (*p).mxAlloc = mx as u32_0;
    (*p).nChar = 0 as libc::c_int as u32_0;
    (*p).accError = 0 as libc::c_int as u8_0;
    (*p).printfFlags = 0 as libc::c_int as u8_0;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_str_new(mut db: *mut sqlite3)
 -> *mut sqlite3_str {
    let mut p: *mut sqlite3_str =
        sqlite3_malloc64(::std::mem::size_of::<sqlite3_str>() as libc::c_ulong
                             as sqlite3_uint64) as *mut sqlite3_str;
    if !p.is_null() {
        sqlite3StrAccumInit(p, 0 as *mut sqlite3, 0 as *mut libc::c_char,
                            0 as libc::c_int,
                            if !db.is_null() {
                                (*db).aLimit[0 as libc::c_int as usize]
                            } else { 1000000000 as libc::c_int });
    } else { p = &mut sqlite3OomStr }
    return p;
}
unsafe extern "C" fn sqlite3VMPrintf(mut db: *mut sqlite3,
                                     mut zFormat: *const libc::c_char,
                                     mut ap: ::std::ffi::VaList)
 -> *mut libc::c_char {
    let mut z: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut zBase: [libc::c_char; 70] = [0; 70];
    let mut acc: StrAccum =
        StrAccum{db: 0 as *mut sqlite3,
                 zText: 0 as *mut libc::c_char,
                 nAlloc: 0,
                 mxAlloc: 0,
                 nChar: 0,
                 accError: 0,
                 printfFlags: 0,};
    sqlite3StrAccumInit(&mut acc, db, zBase.as_mut_ptr(),
                        ::std::mem::size_of::<[libc::c_char; 70]>() as
                            libc::c_ulong as libc::c_int,
                        (*db).aLimit[0 as libc::c_int as usize]);
    acc.printfFlags = 0x1 as libc::c_int as u8_0;
    sqlite3_str_vappendf(&mut acc, zFormat, ap.as_va_list());
    z = sqlite3StrAccumFinish(&mut acc);
    if acc.accError as libc::c_int == 7 as libc::c_int {
        sqlite3OomFault(db);
    }
    return z;
}
unsafe extern "C" fn sqlite3MPrintf(mut db: *mut sqlite3,
                                    mut zFormat: *const libc::c_char,
                                    mut args: ...) -> *mut libc::c_char {
    let mut ap: ::std::ffi::VaListImpl;
    let mut z: *mut libc::c_char = 0 as *mut libc::c_char;
    ap = args.clone();
    z = sqlite3VMPrintf(db, zFormat, ap.as_va_list());
    return z;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_vmprintf(mut zFormat: *const libc::c_char,
                                          mut ap: ::std::ffi::VaList)
 -> *mut libc::c_char {
    let mut z: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut zBase: [libc::c_char; 70] = [0; 70];
    let mut acc: StrAccum =
        StrAccum{db: 0 as *mut sqlite3,
                 zText: 0 as *mut libc::c_char,
                 nAlloc: 0,
                 mxAlloc: 0,
                 nChar: 0,
                 accError: 0,
                 printfFlags: 0,};
    if sqlite3_initialize() != 0 { return 0 as *mut libc::c_char }
    sqlite3StrAccumInit(&mut acc, 0 as *mut sqlite3, zBase.as_mut_ptr(),
                        ::std::mem::size_of::<[libc::c_char; 70]>() as
                            libc::c_ulong as libc::c_int,
                        1000000000 as libc::c_int);
    sqlite3_str_vappendf(&mut acc, zFormat, ap.as_va_list());
    z = sqlite3StrAccumFinish(&mut acc);
    return z;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_mprintf(mut zFormat: *const libc::c_char,
                                         mut args: ...) -> *mut libc::c_char {
    let mut ap: ::std::ffi::VaListImpl;
    let mut z: *mut libc::c_char = 0 as *mut libc::c_char;
    if sqlite3_initialize() != 0 { return 0 as *mut libc::c_char }
    ap = args.clone();
    z = sqlite3_vmprintf(zFormat, ap.as_va_list());
    return z;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_vsnprintf(mut n: libc::c_int,
                                           mut zBuf: *mut libc::c_char,
                                           mut zFormat: *const libc::c_char,
                                           mut ap: ::std::ffi::VaList)
 -> *mut libc::c_char {
    let mut acc: StrAccum =
        StrAccum{db: 0 as *mut sqlite3,
                 zText: 0 as *mut libc::c_char,
                 nAlloc: 0,
                 mxAlloc: 0,
                 nChar: 0,
                 accError: 0,
                 printfFlags: 0,};
    if n <= 0 as libc::c_int { return zBuf }
    sqlite3StrAccumInit(&mut acc, 0 as *mut sqlite3, zBuf, n,
                        0 as libc::c_int);
    sqlite3_str_vappendf(&mut acc, zFormat, ap.as_va_list());
    *zBuf.offset(acc.nChar as isize) = 0 as libc::c_int as libc::c_char;
    return zBuf;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_snprintf(mut n: libc::c_int,
                                          mut zBuf: *mut libc::c_char,
                                          mut zFormat: *const libc::c_char,
                                          mut args: ...)
 -> *mut libc::c_char {
    let mut z: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut ap: ::std::ffi::VaListImpl;
    ap = args.clone();
    z = sqlite3_vsnprintf(n, zBuf, zFormat, ap.as_va_list());
    return z;
}
unsafe extern "C" fn renderLogMsg(mut iErrCode: libc::c_int,
                                  mut zFormat: *const libc::c_char,
                                  mut ap: ::std::ffi::VaList) {
    let mut acc: StrAccum =
        StrAccum{db: 0 as *mut sqlite3,
                 zText: 0 as *mut libc::c_char,
                 nAlloc: 0,
                 mxAlloc: 0,
                 nChar: 0,
                 accError: 0,
                 printfFlags: 0,};
    let mut zMsg: [libc::c_char; 210] = [0; 210];
    sqlite3StrAccumInit(&mut acc, 0 as *mut sqlite3, zMsg.as_mut_ptr(),
                        ::std::mem::size_of::<[libc::c_char; 210]>() as
                            libc::c_ulong as libc::c_int, 0 as libc::c_int);
    sqlite3_str_vappendf(&mut acc, zFormat, ap.as_va_list());
    sqlite3Config.xLog.expect("non-null function pointer")(sqlite3Config.pLogArg,
                                                           iErrCode,
                                                           sqlite3StrAccumFinish(&mut acc));
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_log(mut iErrCode: libc::c_int,
                                     mut zFormat: *const libc::c_char,
                                     mut args: ...) {
    let mut ap: ::std::ffi::VaListImpl;
    if sqlite3Config.xLog.is_some() {
        ap = args.clone();
        renderLogMsg(iErrCode, zFormat, ap.as_va_list());
    };
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_str_appendf(mut p: *mut StrAccum,
                                             mut zFormat: *const libc::c_char,
                                             mut args: ...) {
    let mut ap: ::std::ffi::VaListImpl;
    ap = args.clone();
    sqlite3_str_vappendf(p, zFormat, ap.as_va_list());
}
static mut sqlite3Prng: sqlite3PrngType =
    sqlite3PrngType{isInit: 0, i: 0, j: 0, s: [0; 256],};
#[no_mangle]
pub unsafe extern "C" fn sqlite3_randomness(mut N: libc::c_int,
                                            mut pBuf: *mut libc::c_void) {
    let mut t: libc::c_uchar = 0;
    let mut zBuf: *mut libc::c_uchar = pBuf as *mut libc::c_uchar;
    let mut mutex: *mut sqlite3_mutex = 0 as *mut sqlite3_mutex;
    if sqlite3_initialize() != 0 { return }
    mutex = sqlite3MutexAlloc(5 as libc::c_int);
    sqlite3_mutex_enter(mutex);
    if N <= 0 as libc::c_int || pBuf.is_null() {
        sqlite3Prng.isInit = 0 as libc::c_int as libc::c_uchar;
        sqlite3_mutex_leave(mutex);
        return
    }
    if sqlite3Prng.isInit == 0 {
        let mut i: libc::c_int = 0;
        let mut k: [libc::c_char; 256] = [0; 256];
        sqlite3Prng.j = 0 as libc::c_int as libc::c_uchar;
        sqlite3Prng.i = 0 as libc::c_int as libc::c_uchar;
        sqlite3OsRandomness(sqlite3_vfs_find(0 as *const libc::c_char),
                            256 as libc::c_int, k.as_mut_ptr());
        i = 0 as libc::c_int;
        while i < 256 as libc::c_int {
            sqlite3Prng.s[i as usize] = i as u8_0;
            i += 1
        }
        i = 0 as libc::c_int;
        while i < 256 as libc::c_int {
            sqlite3Prng.j =
                (sqlite3Prng.j as libc::c_int +
                     (sqlite3Prng.s[i as usize] as libc::c_int +
                          k[i as usize] as libc::c_int)) as libc::c_uchar;
            t = sqlite3Prng.s[sqlite3Prng.j as usize];
            sqlite3Prng.s[sqlite3Prng.j as usize] = sqlite3Prng.s[i as usize];
            sqlite3Prng.s[i as usize] = t;
            i += 1
        }
        sqlite3Prng.isInit = 1 as libc::c_int as libc::c_uchar
    }
    loop  {
        sqlite3Prng.i = sqlite3Prng.i.wrapping_add(1);
        t = sqlite3Prng.s[sqlite3Prng.i as usize];
        sqlite3Prng.j =
            (sqlite3Prng.j as libc::c_int + t as libc::c_int) as
                libc::c_uchar;
        sqlite3Prng.s[sqlite3Prng.i as usize] =
            sqlite3Prng.s[sqlite3Prng.j as usize];
        sqlite3Prng.s[sqlite3Prng.j as usize] = t;
        t =
            (t as libc::c_int +
                 sqlite3Prng.s[sqlite3Prng.i as usize] as libc::c_int) as
                libc::c_uchar;
        let fresh36 = zBuf;
        zBuf = zBuf.offset(1);
        *fresh36 = sqlite3Prng.s[t as usize];
        N -= 1;
        if !(N != 0) { break ; }
    }
    sqlite3_mutex_leave(mutex);
}
static mut sqlite3SavedPrng: sqlite3PrngType =
    sqlite3PrngType{isInit: 0, i: 0, j: 0, s: [0; 256],};
unsafe extern "C" fn sqlite3PrngSaveState() {
    memcpy(&mut sqlite3SavedPrng as *mut sqlite3PrngType as *mut libc::c_void,
           &mut sqlite3Prng as *mut sqlite3PrngType as *const libc::c_void,
           ::std::mem::size_of::<sqlite3PrngType>() as libc::c_ulong);
}
unsafe extern "C" fn sqlite3PrngRestoreState() {
    memcpy(&mut sqlite3Prng as *mut sqlite3PrngType as *mut libc::c_void,
           &mut sqlite3SavedPrng as *mut sqlite3PrngType as
               *const libc::c_void,
           ::std::mem::size_of::<sqlite3PrngType>() as libc::c_ulong);
}
unsafe extern "C" fn sqlite3ThreadCreate(mut ppThread: *mut *mut SQLiteThread,
                                         mut xTask:
                                             Option<unsafe extern "C" fn(_:
                                                                             *mut libc::c_void)
                                                        -> *mut libc::c_void>,
                                         mut pIn: *mut libc::c_void)
 -> libc::c_int {
    let mut p: *mut SQLiteThread = 0 as *mut SQLiteThread;
    let mut rc: libc::c_int = 0;
    *ppThread = 0 as *mut SQLiteThread;
    p =
        sqlite3Malloc(::std::mem::size_of::<SQLiteThread>() as libc::c_ulong
                          as u64_0) as *mut SQLiteThread;
    if p.is_null() { return 7 as libc::c_int }
    memset(p as *mut libc::c_void, 0 as libc::c_int,
           ::std::mem::size_of::<SQLiteThread>() as libc::c_ulong);
    (*p).xTask = xTask;
    (*p).pIn = pIn;
    if sqlite3FaultSim(200 as libc::c_int) != 0 {
        rc = 1 as libc::c_int
    } else {
        rc =
            pthread_create(&mut (*p).tid, 0 as *const pthread_attr_t, xTask,
                           pIn)
    }
    if rc != 0 {
        (*p).done = 1 as libc::c_int;
        (*p).pOut = xTask.expect("non-null function pointer")(pIn)
    }
    *ppThread = p;
    return 0 as libc::c_int;
}
unsafe extern "C" fn sqlite3ThreadJoin(mut p: *mut SQLiteThread,
                                       mut ppOut: *mut *mut libc::c_void)
 -> libc::c_int {
    let mut rc: libc::c_int = 0;
    if p.is_null() { return 7 as libc::c_int }
    if (*p).done != 0 {
        *ppOut = (*p).pOut;
        rc = 0 as libc::c_int
    } else {
        rc =
            if pthread_join((*p).tid, ppOut) != 0 {
                1 as libc::c_int
            } else { 0 as libc::c_int }
    }
    sqlite3_free(p as *mut libc::c_void);
    return rc;
}
static mut sqlite3Utf8Trans1: [libc::c_uchar; 64] =
    [0 as libc::c_int as libc::c_uchar, 0x1 as libc::c_int as libc::c_uchar,
     0x2 as libc::c_int as libc::c_uchar, 0x3 as libc::c_int as libc::c_uchar,
     0x4 as libc::c_int as libc::c_uchar, 0x5 as libc::c_int as libc::c_uchar,
     0x6 as libc::c_int as libc::c_uchar, 0x7 as libc::c_int as libc::c_uchar,
     0x8 as libc::c_int as libc::c_uchar, 0x9 as libc::c_int as libc::c_uchar,
     0xa as libc::c_int as libc::c_uchar, 0xb as libc::c_int as libc::c_uchar,
     0xc as libc::c_int as libc::c_uchar, 0xd as libc::c_int as libc::c_uchar,
     0xe as libc::c_int as libc::c_uchar, 0xf as libc::c_int as libc::c_uchar,
     0x10 as libc::c_int as libc::c_uchar,
     0x11 as libc::c_int as libc::c_uchar,
     0x12 as libc::c_int as libc::c_uchar,
     0x13 as libc::c_int as libc::c_uchar,
     0x14 as libc::c_int as libc::c_uchar,
     0x15 as libc::c_int as libc::c_uchar,
     0x16 as libc::c_int as libc::c_uchar,
     0x17 as libc::c_int as libc::c_uchar,
     0x18 as libc::c_int as libc::c_uchar,
     0x19 as libc::c_int as libc::c_uchar,
     0x1a as libc::c_int as libc::c_uchar,
     0x1b as libc::c_int as libc::c_uchar,
     0x1c as libc::c_int as libc::c_uchar,
     0x1d as libc::c_int as libc::c_uchar,
     0x1e as libc::c_int as libc::c_uchar,
     0x1f as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x3 as libc::c_int as libc::c_uchar, 0x4 as libc::c_int as libc::c_uchar,
     0x5 as libc::c_int as libc::c_uchar, 0x6 as libc::c_int as libc::c_uchar,
     0x7 as libc::c_int as libc::c_uchar, 0x8 as libc::c_int as libc::c_uchar,
     0x9 as libc::c_int as libc::c_uchar, 0xa as libc::c_int as libc::c_uchar,
     0xb as libc::c_int as libc::c_uchar, 0xc as libc::c_int as libc::c_uchar,
     0xd as libc::c_int as libc::c_uchar, 0xe as libc::c_int as libc::c_uchar,
     0xf as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x3 as libc::c_int as libc::c_uchar, 0x4 as libc::c_int as libc::c_uchar,
     0x5 as libc::c_int as libc::c_uchar, 0x6 as libc::c_int as libc::c_uchar,
     0x7 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0x2 as libc::c_int as libc::c_uchar,
     0x3 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0x1 as libc::c_int as libc::c_uchar, 0 as libc::c_int as libc::c_uchar,
     0 as libc::c_int as libc::c_uchar];
unsafe extern "C" fn sqlite3Utf8Read(mut pz: *mut *const libc::c_uchar)
 -> u32_0 {
    let mut c: libc::c_uint = 0;
    let fresh37 = *pz;
    *pz = (*pz).offset(1);
    c = *fresh37 as libc::c_uint;
    if c >= 0xc0 as libc::c_int as libc::c_uint {
        c =
            sqlite3Utf8Trans1[c.wrapping_sub(0xc0 as libc::c_int as
                                                 libc::c_uint) as usize] as
                libc::c_uint;
        while **pz as libc::c_int & 0xc0 as libc::c_int == 0x80 as libc::c_int
              {
            let fresh38 = *pz;
            *pz = (*pz).offset(1);
            c =
                (c <<
                     6 as
                         libc::c_int).wrapping_add((0x3f as libc::c_int &
                                                        *fresh38 as
                                                            libc::c_int) as
                                                       libc::c_uint)
        }
        if c < 0x80 as libc::c_int as libc::c_uint ||
               c & 0xfffff800 as libc::c_uint ==
                   0xd800 as libc::c_int as libc::c_uint ||
               c & 0xfffffffe as libc::c_uint ==
                   0xfffe as libc::c_int as libc::c_uint {
            c = 0xfffd as libc::c_int as libc::c_uint
        }
    }
    return c;
}
#[inline(never)]
unsafe extern "C" fn sqlite3VdbeMemTranslate(mut pMem: *mut Mem,
                                             mut desiredEnc: u8_0)
 -> libc::c_int {
    let mut len: sqlite3_int64 = 0;
    let mut zOut: *mut libc::c_uchar = 0 as *mut libc::c_uchar;
    let mut zIn: *mut libc::c_uchar = 0 as *mut libc::c_uchar;
    let mut zTerm: *mut libc::c_uchar = 0 as *mut libc::c_uchar;
    let mut z: *mut libc::c_uchar = 0 as *mut libc::c_uchar;
    let mut c: libc::c_uint = 0;
    if (*pMem).enc as libc::c_int != 1 as libc::c_int &&
           desiredEnc as libc::c_int != 1 as libc::c_int {
        let mut temp: u8_0 = 0;
        let mut rc: libc::c_int = 0;
        rc = sqlite3VdbeMemMakeWriteable(pMem);
        if rc != 0 as libc::c_int { return 7 as libc::c_int }
        zIn = (*pMem).z as *mut u8_0;
        zTerm =
            &mut *zIn.offset(((*pMem).n & !(1 as libc::c_int)) as isize) as
                *mut libc::c_uchar;
        while zIn < zTerm {
            temp = *zIn;
            *zIn = *zIn.offset(1 as libc::c_int as isize);
            zIn = zIn.offset(1);
            let fresh39 = zIn;
            zIn = zIn.offset(1);
            *fresh39 = temp
        }
        (*pMem).enc = desiredEnc
    } else {
        if desiredEnc as libc::c_int == 1 as libc::c_int {
            (*pMem).n &= !(1 as libc::c_int);
            len =
                2 as libc::c_int as libc::c_longlong *
                    (*pMem).n as sqlite3_int64 +
                    1 as libc::c_int as libc::c_longlong
        } else {
            len =
                2 as libc::c_int as libc::c_longlong *
                    (*pMem).n as sqlite3_int64 +
                    2 as libc::c_int as libc::c_longlong
        }
        zIn = (*pMem).z as *mut u8_0;
        zTerm = &mut *zIn.offset((*pMem).n as isize) as *mut libc::c_uchar;
        zOut =
            sqlite3DbMallocRaw((*pMem).db, len as u64_0) as
                *mut libc::c_uchar;
        if zOut.is_null() { return 7 as libc::c_int }
        z = zOut;
        if (*pMem).enc as libc::c_int == 1 as libc::c_int {
            if desiredEnc as libc::c_int == 2 as libc::c_int {
                while zIn < zTerm {
                    let fresh40 = zIn;
                    zIn = zIn.offset(1);
                    c = *fresh40 as libc::c_uint;
                    if c >= 0xc0 as libc::c_int as libc::c_uint {
                        c =
                            sqlite3Utf8Trans1[c.wrapping_sub(0xc0 as
                                                                 libc::c_int
                                                                 as
                                                                 libc::c_uint)
                                                  as usize] as libc::c_uint;
                        while zIn != zTerm &&
                                  *zIn as libc::c_int & 0xc0 as libc::c_int ==
                                      0x80 as libc::c_int {
                            let fresh41 = zIn;
                            zIn = zIn.offset(1);
                            c =
                                (c <<
                                     6 as
                                         libc::c_int).wrapping_add((0x3f as
                                                                        libc::c_int
                                                                        &
                                                                        *fresh41
                                                                            as
                                                                            libc::c_int)
                                                                       as
                                                                       libc::c_uint)
                        }
                        if c < 0x80 as libc::c_int as libc::c_uint ||
                               c & 0xfffff800 as libc::c_uint ==
                                   0xd800 as libc::c_int as libc::c_uint ||
                               c & 0xfffffffe as libc::c_uint ==
                                   0xfffe as libc::c_int as libc::c_uint {
                            c = 0xfffd as libc::c_int as libc::c_uint
                        }
                    }
                    if c <= 0xffff as libc::c_int as libc::c_uint {
                        let fresh42 = z;
                        z = z.offset(1);
                        *fresh42 =
                            (c & 0xff as libc::c_int as libc::c_uint) as u8_0;
                        let fresh43 = z;
                        z = z.offset(1);
                        *fresh43 =
                            (c >> 8 as libc::c_int &
                                 0xff as libc::c_int as libc::c_uint) as u8_0
                    } else {
                        let fresh44 = z;
                        z = z.offset(1);
                        *fresh44 =
                            (c >> 10 as libc::c_int &
                                 0x3f as libc::c_int as
                                     libc::c_uint).wrapping_add(c.wrapping_sub(0x10000
                                                                                   as
                                                                                   libc::c_int
                                                                                   as
                                                                                   libc::c_uint)
                                                                    >>
                                                                    10 as
                                                                        libc::c_int
                                                                    &
                                                                    0xc0 as
                                                                        libc::c_int
                                                                        as
                                                                        libc::c_uint)
                                as u8_0;
                        let fresh45 = z;
                        z = z.offset(1);
                        *fresh45 =
                            (0xd8 as libc::c_int as
                                 libc::c_uint).wrapping_add(c.wrapping_sub(0x10000
                                                                               as
                                                                               libc::c_int
                                                                               as
                                                                               libc::c_uint)
                                                                >>
                                                                18 as
                                                                    libc::c_int
                                                                &
                                                                0x3 as
                                                                    libc::c_int
                                                                    as
                                                                    libc::c_uint)
                                as u8_0;
                        let fresh46 = z;
                        z = z.offset(1);
                        *fresh46 =
                            (c & 0xff as libc::c_int as libc::c_uint) as u8_0;
                        let fresh47 = z;
                        z = z.offset(1);
                        *fresh47 =
                            (0xdc as libc::c_int as
                                 libc::c_uint).wrapping_add(c >>
                                                                8 as
                                                                    libc::c_int
                                                                &
                                                                0x3 as
                                                                    libc::c_int
                                                                    as
                                                                    libc::c_uint)
                                as u8_0
                    }
                }
            } else {
                while zIn < zTerm {
                    let fresh48 = zIn;
                    zIn = zIn.offset(1);
                    c = *fresh48 as libc::c_uint;
                    if c >= 0xc0 as libc::c_int as libc::c_uint {
                        c =
                            sqlite3Utf8Trans1[c.wrapping_sub(0xc0 as
                                                                 libc::c_int
                                                                 as
                                                                 libc::c_uint)
                                                  as usize] as libc::c_uint;
                        while zIn != zTerm &&
                                  *zIn as libc::c_int & 0xc0 as libc::c_int ==
                                      0x80 as libc::c_int {
                            let fresh49 = zIn;
                            zIn = zIn.offset(1);
                            c =
                                (c <<
                                     6 as
                                         libc::c_int).wrapping_add((0x3f as
                                                                        libc::c_int
                                                                        &
                                                                        *fresh49
                                                                            as
                                                                            libc::c_int)
                                                                       as
                                                                       libc::c_uint)
                        }
                        if c < 0x80 as libc::c_int as libc::c_uint ||
                               c & 0xfffff800 as libc::c_uint ==
                                   0xd800 as libc::c_int as libc::c_uint ||
                               c & 0xfffffffe as libc::c_uint ==
                                   0xfffe as libc::c_int as libc::c_uint {
                            c = 0xfffd as libc::c_int as libc::c_uint
                        }
                    }
                    if c <= 0xffff as libc::c_int as libc::c_uint {
                        let fresh50 = z;
                        z = z.offset(1);
                        *fresh50 =
                            (c >> 8 as libc::c_int &
                                 0xff as libc::c_int as libc::c_uint) as u8_0;
                        let fresh51 = z;
                        z = z.offset(1);
                        *fresh51 =
                            (c & 0xff as libc::c_int as libc::c_uint) as u8_0
                    } else {
                        let fresh52 = z;
                        z = z.offset(1);
                        *fresh52 =
                            (0xd8 as libc::c_int as
                                 libc::c_uint).wrapping_add(c.wrapping_sub(0x10000
                                                                               as
                                                                               libc::c_int
                                                                               as
                                                                               libc::c_uint)
                                                                >>
                                                                18 as
                                                                    libc::c_int
                                                                &
                                                                0x3 as
                                                                    libc::c_int
                                                                    as
                                                                    libc::c_uint)
                                as u8_0;
                        let fresh53 = z;
                        z = z.offset(1);
                        *fresh53 =
                            (c >> 10 as libc::c_int &
                                 0x3f as libc::c_int as
                                     libc::c_uint).wrapping_add(c.wrapping_sub(0x10000
                                                                                   as
                                                                                   libc::c_int
                                                                                   as
                                                                                   libc::c_uint)
                                                                    >>
                                                                    10 as
                                                                        libc::c_int
                                                                    &
                                                                    0xc0 as
                                                                        libc::c_int
                                                                        as
                                                                        libc::c_uint)
                                as u8_0;
                        let fresh54 = z;
                        z = z.offset(1);
                        *fresh54 =
                            (0xdc as libc::c_int as
                                 libc::c_uint).wrapping_add(c >>
                                                                8 as
                                                                    libc::c_int
                                                                &
                                                                0x3 as
                                                                    libc::c_int
                                                                    as
                                                                    libc::c_uint)
                                as u8_0;
                        let fresh55 = z;
                        z = z.offset(1);
                        *fresh55 =
                            (c & 0xff as libc::c_int as libc::c_uint) as u8_0
                    }
                }
            }
            (*pMem).n =
                z.wrapping_offset_from(zOut) as libc::c_long as libc::c_int;
            let fresh56 = z;
            z = z.offset(1);
            *fresh56 = 0 as libc::c_int as libc::c_uchar
        } else {
            if (*pMem).enc as libc::c_int == 2 as libc::c_int {
                while zIn < zTerm {
                    let fresh57 = zIn;
                    zIn = zIn.offset(1);
                    c = *fresh57 as libc::c_uint;
                    let fresh58 = zIn;
                    zIn = zIn.offset(1);
                    c =
                        c.wrapping_add(((*fresh58 as libc::c_int) <<
                                            8 as libc::c_int) as
                                           libc::c_uint);
                    if c >= 0xd800 as libc::c_int as libc::c_uint &&
                           c < 0xe000 as libc::c_int as libc::c_uint {
                        if zIn < zTerm {
                            let fresh59 = zIn;
                            zIn = zIn.offset(1);
                            let mut c2: libc::c_int = *fresh59 as libc::c_int;
                            let fresh60 = zIn;
                            zIn = zIn.offset(1);
                            c2 +=
                                (*fresh60 as libc::c_int) << 8 as libc::c_int;
                            c =
                                ((c2 & 0x3ff as libc::c_int) as
                                     libc::c_uint).wrapping_add((c &
                                                                     0x3f as
                                                                         libc::c_int
                                                                         as
                                                                         libc::c_uint)
                                                                    <<
                                                                    10 as
                                                                        libc::c_int).wrapping_add((c
                                                                                                       &
                                                                                                       0x3c0
                                                                                                           as
                                                                                                           libc::c_int
                                                                                                           as
                                                                                                           libc::c_uint).wrapping_add(0x40
                                                                                                                                          as
                                                                                                                                          libc::c_int
                                                                                                                                          as
                                                                                                                                          libc::c_uint)
                                                                                                      <<
                                                                                                      10
                                                                                                          as
                                                                                                          libc::c_int)
                        }
                    }
                    if c < 0x80 as libc::c_int as libc::c_uint {
                        let fresh61 = z;
                        z = z.offset(1);
                        *fresh61 =
                            (c & 0xff as libc::c_int as libc::c_uint) as u8_0
                    } else if c < 0x800 as libc::c_int as libc::c_uint {
                        let fresh62 = z;
                        z = z.offset(1);
                        *fresh62 =
                            (0xc0 as libc::c_int +
                                 (c >> 6 as libc::c_int &
                                      0x1f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar;
                        let fresh63 = z;
                        z = z.offset(1);
                        *fresh63 =
                            (0x80 as libc::c_int +
                                 (c & 0x3f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar
                    } else if c < 0x10000 as libc::c_int as libc::c_uint {
                        let fresh64 = z;
                        z = z.offset(1);
                        *fresh64 =
                            (0xe0 as libc::c_int +
                                 (c >> 12 as libc::c_int &
                                      0xf as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar;
                        let fresh65 = z;
                        z = z.offset(1);
                        *fresh65 =
                            (0x80 as libc::c_int +
                                 (c >> 6 as libc::c_int &
                                      0x3f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar;
                        let fresh66 = z;
                        z = z.offset(1);
                        *fresh66 =
                            (0x80 as libc::c_int +
                                 (c & 0x3f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar
                    } else {
                        let fresh67 = z;
                        z = z.offset(1);
                        *fresh67 =
                            (0xf0 as libc::c_int +
                                 (c >> 18 as libc::c_int &
                                      0x7 as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar;
                        let fresh68 = z;
                        z = z.offset(1);
                        *fresh68 =
                            (0x80 as libc::c_int +
                                 (c >> 12 as libc::c_int &
                                      0x3f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar;
                        let fresh69 = z;
                        z = z.offset(1);
                        *fresh69 =
                            (0x80 as libc::c_int +
                                 (c >> 6 as libc::c_int &
                                      0x3f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar;
                        let fresh70 = z;
                        z = z.offset(1);
                        *fresh70 =
                            (0x80 as libc::c_int +
                                 (c & 0x3f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar
                    }
                }
            } else {
                while zIn < zTerm {
                    let fresh71 = zIn;
                    zIn = zIn.offset(1);
                    c =
                        ((*fresh71 as libc::c_int) << 8 as libc::c_int) as
                            libc::c_uint;
                    let fresh72 = zIn;
                    zIn = zIn.offset(1);
                    c = c.wrapping_add(*fresh72 as libc::c_uint);
                    if c >= 0xd800 as libc::c_int as libc::c_uint &&
                           c < 0xe000 as libc::c_int as libc::c_uint {
                        if zIn < zTerm {
                            let fresh73 = zIn;
                            zIn = zIn.offset(1);
                            let mut c2_0: libc::c_int =
                                (*fresh73 as libc::c_int) << 8 as libc::c_int;
                            let fresh74 = zIn;
                            zIn = zIn.offset(1);
                            c2_0 += *fresh74 as libc::c_int;
                            c =
                                ((c2_0 & 0x3ff as libc::c_int) as
                                     libc::c_uint).wrapping_add((c &
                                                                     0x3f as
                                                                         libc::c_int
                                                                         as
                                                                         libc::c_uint)
                                                                    <<
                                                                    10 as
                                                                        libc::c_int).wrapping_add((c
                                                                                                       &
                                                                                                       0x3c0
                                                                                                           as
                                                                                                           libc::c_int
                                                                                                           as
                                                                                                           libc::c_uint).wrapping_add(0x40
                                                                                                                                          as
                                                                                                                                          libc::c_int
                                                                                                                                          as
                                                                                                                                          libc::c_uint)
                                                                                                      <<
                                                                                                      10
                                                                                                          as
                                                                                                          libc::c_int)
                        }
                    }
                    if c < 0x80 as libc::c_int as libc::c_uint {
                        let fresh75 = z;
                        z = z.offset(1);
                        *fresh75 =
                            (c & 0xff as libc::c_int as libc::c_uint) as u8_0
                    } else if c < 0x800 as libc::c_int as libc::c_uint {
                        let fresh76 = z;
                        z = z.offset(1);
                        *fresh76 =
                            (0xc0 as libc::c_int +
                                 (c >> 6 as libc::c_int &
                                      0x1f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar;
                        let fresh77 = z;
                        z = z.offset(1);
                        *fresh77 =
                            (0x80 as libc::c_int +
                                 (c & 0x3f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar
                    } else if c < 0x10000 as libc::c_int as libc::c_uint {
                        let fresh78 = z;
                        z = z.offset(1);
                        *fresh78 =
                            (0xe0 as libc::c_int +
                                 (c >> 12 as libc::c_int &
                                      0xf as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar;
                        let fresh79 = z;
                        z = z.offset(1);
                        *fresh79 =
                            (0x80 as libc::c_int +
                                 (c >> 6 as libc::c_int &
                                      0x3f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar;
                        let fresh80 = z;
                        z = z.offset(1);
                        *fresh80 =
                            (0x80 as libc::c_int +
                                 (c & 0x3f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar
                    } else {
                        let fresh81 = z;
                        z = z.offset(1);
                        *fresh81 =
                            (0xf0 as libc::c_int +
                                 (c >> 18 as libc::c_int &
                                      0x7 as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar;
                        let fresh82 = z;
                        z = z.offset(1);
                        *fresh82 =
                            (0x80 as libc::c_int +
                                 (c >> 12 as libc::c_int &
                                      0x3f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar;
                        let fresh83 = z;
                        z = z.offset(1);
                        *fresh83 =
                            (0x80 as libc::c_int +
                                 (c >> 6 as libc::c_int &
                                      0x3f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar;
                        let fresh84 = z;
                        z = z.offset(1);
                        *fresh84 =
                            (0x80 as libc::c_int +
                                 (c & 0x3f as libc::c_int as libc::c_uint) as
                                     u8_0 as libc::c_int) as libc::c_uchar
                    }
                }
            }
            (*pMem).n =
                z.wrapping_offset_from(zOut) as libc::c_long as libc::c_int
        }
        *z = 0 as libc::c_int as libc::c_uchar;
        c = (*pMem).flags as libc::c_uint;
        sqlite3VdbeMemRelease(pMem);
        (*pMem).flags =
            ((0x2 as libc::c_int | 0x200 as libc::c_int) as libc::c_uint |
                 c &
                     (0x3f as libc::c_int | 0x8000 as libc::c_int) as
                         libc::c_uint) as u16_0;
        (*pMem).enc = desiredEnc;
        (*pMem).z = zOut as *mut libc::c_char;
        (*pMem).zMalloc = (*pMem).z;
        (*pMem).szMalloc =
            sqlite3DbMallocSize((*pMem).db, (*pMem).z as *mut libc::c_void)
    }
    return 0 as libc::c_int;
}
unsafe extern "C" fn sqlite3VdbeMemHandleBom(mut pMem: *mut Mem)
 -> libc::c_int {
    let mut rc: libc::c_int = 0 as libc::c_int;
    let mut bom: u8_0 = 0 as libc::c_int as u8_0;
    if (*pMem).n > 1 as libc::c_int {
        let mut b1: u8_0 = *((*pMem).z as *mut u8_0);
        let mut b2: u8_0 =
            *((*pMem).z as *mut u8_0).offset(1 as libc::c_int as isize);
        if b1 as libc::c_int == 0xfe as libc::c_int &&
               b2 as libc::c_int == 0xff as libc::c_int {
            bom = 3 as libc::c_int as u8_0
        }
        if b1 as libc::c_int == 0xff as libc::c_int &&
               b2 as libc::c_int == 0xfe as libc::c_int {
            bom = 2 as libc::c_int as u8_0
        }
    }
    if bom != 0 {
        rc = sqlite3VdbeMemMakeWriteable(pMem);
        if rc == 0 as libc::c_int {
            (*pMem).n -= 2 as libc::c_int;
            memmove((*pMem).z as *mut libc::c_void,
                    &mut *(*pMem).z.offset(2 as libc::c_int as isize) as
                        *mut libc::c_char as *const libc::c_void,
                    (*pMem).n as libc::c_ulong);
            *(*pMem).z.offset((*pMem).n as isize) =
                '\u{0}' as i32 as libc::c_char;
            *(*pMem).z.offset(((*pMem).n + 1 as libc::c_int) as isize) =
                '\u{0}' as i32 as libc::c_char;
            (*pMem).flags =
                ((*pMem).flags as libc::c_int | 0x200 as libc::c_int) as
                    u16_0;
            (*pMem).enc = bom
        }
    }
    return rc;
}
unsafe extern "C" fn sqlite3Utf8CharLen(mut zIn: *const libc::c_char,
                                        mut nByte: libc::c_int)
 -> libc::c_int {
    let mut r: libc::c_int = 0 as libc::c_int;
    let mut z: *const u8_0 = zIn as *const u8_0;
    let mut zTerm: *const u8_0 = 0 as *const u8_0;
    if nByte >= 0 as libc::c_int {
        zTerm = &*z.offset(nByte as isize) as *const u8_0
    } else { zTerm = -(1 as libc::c_int) as *const u8_0 }
    while *z as libc::c_int != 0 as libc::c_int && z < zTerm {
        let fresh85 = z;
        z = z.offset(1);
        if *fresh85 as libc::c_int >= 0xc0 as libc::c_int {
            while *z as libc::c_int & 0xc0 as libc::c_int ==
                      0x80 as libc::c_int {
                z = z.offset(1)
            }
        }
        r += 1
    }
    return r;
}
unsafe extern "C" fn sqlite3Utf16to8(mut db: *mut sqlite3,
                                     mut z: *const libc::c_void,
                                     mut nByte: libc::c_int, mut enc: u8_0)
 -> *mut libc::c_char {
    let mut m: Mem =
        Mem{u: MemValue{r: 0.,},
            flags: 0,
            enc: 0,
            eSubtype: 0,
            n: 0,
            z: 0 as *mut libc::c_char,
            zMalloc: 0 as *mut libc::c_char,
            szMalloc: 0,
            uTemp: 0,
            db: 0 as *mut sqlite3,
            xDel: None,};
    memset(&mut m as *mut Mem as *mut libc::c_void, 0 as libc::c_int,
           ::std::mem::size_of::<Mem>() as libc::c_ulong);
    m.db = db;
    sqlite3VdbeMemSetStr(&mut m, z as *const libc::c_char, nByte, enc, None);
    sqlite3VdbeChangeEncoding(&mut m, 1 as libc::c_int);
    if (*db).mallocFailed != 0 {
        sqlite3VdbeMemRelease(&mut m);
        m.z = 0 as *mut libc::c_char
    }
    return m.z;
}
unsafe extern "C" fn sqlite3Utf16ByteLen(mut zIn: *const libc::c_void,
                                         mut nChar: libc::c_int)
 -> libc::c_int {
    let mut c: libc::c_int = 0;
    let mut z: *const libc::c_uchar = zIn as *const libc::c_uchar;
    let mut n: libc::c_int = 0 as libc::c_int;
    if 2 as libc::c_int == 2 as libc::c_int { z = z.offset(1) }
    while n < nChar {
        c = *z.offset(0 as libc::c_int as isize) as libc::c_int;
        z = z.offset(2 as libc::c_int as isize);
        if c >= 0xd8 as libc::c_int && c < 0xdc as libc::c_int &&
               *z.offset(0 as libc::c_int as isize) as libc::c_int >=
                   0xdc as libc::c_int &&
               (*z.offset(0 as libc::c_int as isize) as libc::c_int) <
                   0xe0 as libc::c_int {
            z = z.offset(2 as libc::c_int as isize)
        }
        n += 1
    }
    return z.wrapping_offset_from(zIn as *const libc::c_uchar) as libc::c_long
               as libc::c_int -
               (2 as libc::c_int == 2 as libc::c_int) as libc::c_int;
}
unsafe extern "C" fn sqlite3FaultSim(mut iTest: libc::c_int) -> libc::c_int {
    let mut xCallback:
            Option<unsafe extern "C" fn(_: libc::c_int) -> libc::c_int> =
        sqlite3Config.xTestCallback;
    return if xCallback.is_some() {
               xCallback.expect("non-null function pointer")(iTest)
           } else { 0 as libc::c_int };
}
unsafe extern "C" fn sqlite3IsNaN(mut x: libc::c_double) -> libc::c_int {
    let mut y: u64_0 = 0;
    memcpy(&mut y as *mut u64_0 as *mut libc::c_void,
           &mut x as *mut libc::c_double as *const libc::c_void,
           ::std::mem::size_of::<u64_0>() as libc::c_ulong);
    return (y & (0x7ff as libc::c_int as u64_0) << 52 as libc::c_int ==
                (0x7ff as libc::c_int as u64_0) << 52 as libc::c_int &&
                y &
                    ((1 as libc::c_int as u64_0) <<
                         52 as
                             libc::c_int).wrapping_sub(1 as libc::c_int as
                                                           libc::c_ulonglong)
                    != 0 as libc::c_int as libc::c_ulonglong) as libc::c_int;
}
unsafe extern "C" fn sqlite3Strlen30(mut z: *const libc::c_char)
 -> libc::c_int {
    if z.is_null() { return 0 as libc::c_int }
    return 0x3fffffff as libc::c_int & strlen(z) as libc::c_int;
}
unsafe extern "C" fn sqlite3ColumnType(mut pCol: *mut Column,
                                       mut zDflt: *mut libc::c_char)
 -> *mut libc::c_char {
    if (*pCol).colFlags as libc::c_int & 0x4 as libc::c_int ==
           0 as libc::c_int {
        return zDflt
    }
    return (*pCol).zName.offset(strlen((*pCol).zName) as
                                    isize).offset(1 as libc::c_int as isize);
}
#[inline(never)]
unsafe extern "C" fn sqlite3ErrorFinish(mut db: *mut sqlite3,
                                        mut err_code: libc::c_int) {
    if !(*db).pErr.is_null() { sqlite3ValueSetNull((*db).pErr); }
    sqlite3SystemError(db, err_code);
}
unsafe extern "C" fn sqlite3Error(mut db: *mut sqlite3,
                                  mut err_code: libc::c_int) {
    (*db).errCode = err_code;
    if err_code != 0 || !(*db).pErr.is_null() {
        sqlite3ErrorFinish(db, err_code);
    };
}
unsafe extern "C" fn sqlite3SystemError(mut db: *mut sqlite3,
                                        mut rc: libc::c_int) {
    if rc == 10 as libc::c_int | (12 as libc::c_int) << 8 as libc::c_int {
        return
    }
    rc &= 0xff as libc::c_int;
    if rc == 14 as libc::c_int || rc == 10 as libc::c_int {
        (*db).iSysErrno = sqlite3OsGetLastError((*db).pVfs)
    };
}
unsafe extern "C" fn sqlite3ErrorWithMsg(mut db: *mut sqlite3,
                                         mut err_code: libc::c_int,
                                         mut zFormat: *const libc::c_char,
                                         mut args: ...) {
    (*db).errCode = err_code;
    sqlite3SystemError(db, err_code);
    if zFormat.is_null() {
        sqlite3Error(db, err_code);
    } else if !(*db).pErr.is_null() ||
                  { (*db).pErr = sqlite3ValueNew(db); !(*db).pErr.is_null() }
     {
        let mut z: *mut libc::c_char = 0 as *mut libc::c_char;
        let mut ap: ::std::ffi::VaListImpl;
        ap = args.clone();
        z = sqlite3VMPrintf(db, zFormat, ap.as_va_list());
        sqlite3ValueSetStr((*db).pErr, -(1 as libc::c_int),
                           z as *const libc::c_void, 1 as libc::c_int as u8_0,
                           ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                   *mut libc::c_void)
                                                              -> libc::c_int>,
                                                   sqlite3_destructor_type>(Some(sqlite3MallocSize
                                                                                     as
                                                                                     unsafe extern "C" fn(_:
                                                                                                              *mut libc::c_void)
                                                                                         ->
                                                                                             libc::c_int)));
    };
}
unsafe extern "C" fn sqlite3ErrorMsg(mut pParse: *mut Parse,
                                     mut zFormat: *const libc::c_char,
                                     mut args: ...) {
    let mut zMsg: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut ap: ::std::ffi::VaListImpl;
    let mut db: *mut sqlite3 = (*pParse).db;
    ap = args.clone();
    zMsg = sqlite3VMPrintf(db, zFormat, ap.as_va_list());
    if (*db).suppressErr != 0 {
        sqlite3DbFree(db, zMsg as *mut libc::c_void);
    } else {
        (*pParse).nErr += 1;
        sqlite3DbFree(db, (*pParse).zErrMsg as *mut libc::c_void);
        (*pParse).zErrMsg = zMsg;
        (*pParse).rc = 1 as libc::c_int;
        (*pParse).pWith = 0 as *mut With
    };
}
unsafe extern "C" fn sqlite3ErrorToParser(mut db: *mut sqlite3,
                                          mut errCode: libc::c_int)
 -> libc::c_int {
    let mut pParse: *mut Parse = 0 as *mut Parse;
    if db.is_null() || { pParse = (*db).pParse; pParse.is_null() } {
        return errCode
    }
    (*pParse).rc = errCode;
    (*pParse).nErr += 1;
    return errCode;
}
unsafe extern "C" fn sqlite3Dequote(mut z: *mut libc::c_char) {
    let mut quote: libc::c_char = 0;
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    if z.is_null() { return }
    quote = *z.offset(0 as libc::c_int as isize);
    if sqlite3CtypeMap[quote as libc::c_uchar as usize] as libc::c_int &
           0x80 as libc::c_int == 0 {
        return
    }
    if quote as libc::c_int == '[' as i32 {
        quote = ']' as i32 as libc::c_char
    }
    i = 1 as libc::c_int;
    j = 0 as libc::c_int;
    loop  {
        if *z.offset(i as isize) as libc::c_int == quote as libc::c_int {
            if !(*z.offset((i + 1 as libc::c_int) as isize) as libc::c_int ==
                     quote as libc::c_int) {
                break ;
            }
            let fresh86 = j;
            j = j + 1;
            *z.offset(fresh86 as isize) = quote;
            i += 1
        } else {
            let fresh87 = j;
            j = j + 1;
            *z.offset(fresh87 as isize) = *z.offset(i as isize)
        }
        i += 1
    }
    *z.offset(j as isize) = 0 as libc::c_int as libc::c_char;
}
unsafe extern "C" fn sqlite3DequoteExpr(mut p: *mut Expr) {
    (*p).flags |=
        if *(*p).u.zToken.offset(0 as libc::c_int as isize) as libc::c_int ==
               '\"' as i32 {
            (0x4000000 as libc::c_int) | 0x40 as libc::c_int
        } else { 0x4000000 as libc::c_int } as libc::c_uint;
    sqlite3Dequote((*p).u.zToken);
}
unsafe extern "C" fn sqlite3TokenInit(mut p: *mut Token,
                                      mut z: *mut libc::c_char) {
    (*p).z = z;
    (*p).n = sqlite3Strlen30(z) as libc::c_uint;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_stricmp(mut zLeft: *const libc::c_char,
                                         mut zRight: *const libc::c_char)
 -> libc::c_int {
    if zLeft.is_null() {
        return if !zRight.is_null() {
                   -(1 as libc::c_int)
               } else { 0 as libc::c_int }
    } else { if zRight.is_null() { return 1 as libc::c_int } }
    return sqlite3StrICmp(zLeft, zRight);
}
unsafe extern "C" fn sqlite3StrICmp(mut zLeft: *const libc::c_char,
                                    mut zRight: *const libc::c_char)
 -> libc::c_int {
    let mut a: *mut libc::c_uchar = 0 as *mut libc::c_uchar;
    let mut b: *mut libc::c_uchar = 0 as *mut libc::c_uchar;
    let mut c: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    a = zLeft as *mut libc::c_uchar;
    b = zRight as *mut libc::c_uchar;
    loop  {
        c = *a as libc::c_int;
        x = *b as libc::c_int;
        if c == x {
            if c == 0 as libc::c_int { break ; }
        } else {
            c =
                sqlite3UpperToLower[c as usize] as libc::c_int -
                    sqlite3UpperToLower[x as usize] as libc::c_int;
            if c != 0 { break ; }
        }
        a = a.offset(1);
        b = b.offset(1)
    }
    return c;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_strnicmp(mut zLeft: *const libc::c_char,
                                          mut zRight: *const libc::c_char,
                                          mut N: libc::c_int) -> libc::c_int {
    let mut a: *mut libc::c_uchar = 0 as *mut libc::c_uchar;
    let mut b: *mut libc::c_uchar = 0 as *mut libc::c_uchar;
    if zLeft.is_null() {
        return if !zRight.is_null() {
                   -(1 as libc::c_int)
               } else { 0 as libc::c_int }
    } else { if zRight.is_null() { return 1 as libc::c_int } }
    a = zLeft as *mut libc::c_uchar;
    b = zRight as *mut libc::c_uchar;
    loop  {
        let fresh88 = N;
        N = N - 1;
        if !(fresh88 > 0 as libc::c_int &&
                 *a as libc::c_int != 0 as libc::c_int &&
                 sqlite3UpperToLower[*a as usize] as libc::c_int ==
                     sqlite3UpperToLower[*b as usize] as libc::c_int) {
            break ;
        }
        a = a.offset(1);
        b = b.offset(1)
    }
    return if N < 0 as libc::c_int {
               0 as libc::c_int
           } else {
               (sqlite3UpperToLower[*a as usize] as libc::c_int) -
                   sqlite3UpperToLower[*b as usize] as libc::c_int
           };
}
unsafe extern "C" fn sqlite3StrIHash(mut z: *const libc::c_char) -> u8_0 {
    let mut h: u8_0 = 0 as libc::c_int as u8_0;
    if z.is_null() { return 0 as libc::c_int as u8_0 }
    while *z.offset(0 as libc::c_int as isize) != 0 {
        h =
            (h as libc::c_int +
                 sqlite3UpperToLower[*z.offset(0 as libc::c_int as isize) as
                                         libc::c_uchar as usize] as
                     libc::c_int) as u8_0;
        z = z.offset(1)
    }
    return h;
}
unsafe extern "C" fn sqlite3Pow10(mut E: libc::c_int) -> f128::f128 {
    let mut x: f128::f128 = f128::f128::new(10.0f64);
    let mut r: f128::f128 = f128::f128::new(1.0f64);
    loop  {
        if E & 1 as libc::c_int != 0 { r *= x }
        E >>= 1 as libc::c_int;
        if E == 0 as libc::c_int { break ; }
        x *= x
    }
    return r;
}
unsafe extern "C" fn sqlite3AtoF(mut z: *const libc::c_char,
                                 mut pResult: *mut libc::c_double,
                                 mut length: libc::c_int, mut enc: u8_0)
 -> libc::c_int {
    let mut current_block: u64;
    let mut incr: libc::c_int = 0;
    let mut zEnd: *const libc::c_char = 0 as *const libc::c_char;
    let mut sign: libc::c_int = 1 as libc::c_int;
    let mut s: i64_0 = 0 as libc::c_int as i64_0;
    let mut d: libc::c_int = 0 as libc::c_int;
    let mut esign: libc::c_int = 1 as libc::c_int;
    let mut e: libc::c_int = 0 as libc::c_int;
    let mut eValid: libc::c_int = 1 as libc::c_int;
    let mut result: libc::c_double = 0.;
    let mut nDigit: libc::c_int = 0 as libc::c_int;
    let mut eType: libc::c_int = 1 as libc::c_int;
    *pResult = 0.0f64;
    if length == 0 as libc::c_int { return 0 as libc::c_int }
    if enc as libc::c_int == 1 as libc::c_int {
        incr = 1 as libc::c_int;
        zEnd = z.offset(length as isize)
    } else {
        let mut i: libc::c_int = 0;
        incr = 2 as libc::c_int;
        length &= !(1 as libc::c_int);
        i = 3 as libc::c_int - enc as libc::c_int;
        while i < length &&
                  *z.offset(i as isize) as libc::c_int == 0 as libc::c_int {
            i += 2 as libc::c_int
        }
        if i < length { eType = -(100 as libc::c_int) }
        zEnd =
            &*z.offset((i ^ 1 as libc::c_int) as isize) as
                *const libc::c_char;
        z = z.offset((enc as libc::c_int & 1 as libc::c_int) as isize)
    }
    while z < zEnd &&
              sqlite3CtypeMap[*z as libc::c_uchar as usize] as libc::c_int &
                  0x1 as libc::c_int != 0 {
        z = z.offset(incr as isize)
    }
    if z >= zEnd { return 0 as libc::c_int }
    if *z as libc::c_int == '-' as i32 {
        sign = -(1 as libc::c_int);
        z = z.offset(incr as isize)
    } else if *z as libc::c_int == '+' as i32 { z = z.offset(incr as isize) }
    while z < zEnd &&
              sqlite3CtypeMap[*z as libc::c_uchar as usize] as libc::c_int &
                  0x4 as libc::c_int != 0 {
        s =
            s * 10 as libc::c_int as libc::c_longlong +
                (*z as libc::c_int - '0' as i32) as libc::c_longlong;
        z = z.offset(incr as isize);
        nDigit += 1;
        if s >=
               ((0xffffffff as libc::c_uint as libc::c_longlong |
                     (0x7fffffff as libc::c_int as i64_0) <<
                         32 as libc::c_int) -
                    9 as libc::c_int as libc::c_longlong) /
                   10 as libc::c_int as libc::c_longlong {
            while z < zEnd &&
                      sqlite3CtypeMap[*z as libc::c_uchar as usize] as
                          libc::c_int & 0x4 as libc::c_int != 0 {
                z = z.offset(incr as isize);
                d += 1
            }
        }
    }
    if !(z >= zEnd) {
        if *z as libc::c_int == '.' as i32 {
            z = z.offset(incr as isize);
            eType += 1;
            while z < zEnd &&
                      sqlite3CtypeMap[*z as libc::c_uchar as usize] as
                          libc::c_int & 0x4 as libc::c_int != 0 {
                if s <
                       ((0xffffffff as libc::c_uint as libc::c_longlong |
                             (0x7fffffff as libc::c_int as i64_0) <<
                                 32 as libc::c_int) -
                            9 as libc::c_int as libc::c_longlong) /
                           10 as libc::c_int as libc::c_longlong {
                    s =
                        s * 10 as libc::c_int as libc::c_longlong +
                            (*z as libc::c_int - '0' as i32) as
                                libc::c_longlong;
                    d -= 1;
                    nDigit += 1
                }
                z = z.offset(incr as isize)
            }
        }
        if !(z >= zEnd) {
            if *z as libc::c_int == 'e' as i32 ||
                   *z as libc::c_int == 'E' as i32 {
                z = z.offset(incr as isize);
                eValid = 0 as libc::c_int;
                eType += 1;
                if z >= zEnd {
                    current_block = 15316457195432865246;
                } else {
                    if *z as libc::c_int == '-' as i32 {
                        esign = -(1 as libc::c_int);
                        z = z.offset(incr as isize)
                    } else if *z as libc::c_int == '+' as i32 {
                        z = z.offset(incr as isize)
                    }
                    while z < zEnd &&
                              sqlite3CtypeMap[*z as libc::c_uchar as usize] as
                                  libc::c_int & 0x4 as libc::c_int != 0 {
                        e =
                            if e < 10000 as libc::c_int {
                                (e * 10 as libc::c_int) +
                                    (*z as libc::c_int - '0' as i32)
                            } else { 10000 as libc::c_int };
                        z = z.offset(incr as isize);
                        eValid = 1 as libc::c_int
                    }
                    current_block = 3736434875406665187;
                }
            } else { current_block = 3736434875406665187; }
            match current_block {
                15316457195432865246 => { }
                _ => {
                    while z < zEnd &&
                              sqlite3CtypeMap[*z as libc::c_uchar as usize] as
                                  libc::c_int & 0x1 as libc::c_int != 0 {
                        z = z.offset(incr as isize)
                    }
                }
            }
        }
    }
    e = e * esign + d;
    if e < 0 as libc::c_int {
        esign = -(1 as libc::c_int);
        e *= -(1 as libc::c_int)
    } else { esign = 1 as libc::c_int }
    if s == 0 as libc::c_int as libc::c_longlong {
        result =
            if sign < 0 as libc::c_int {
                -(0 as libc::c_int as libc::c_double)
            } else { 0 as libc::c_int as libc::c_double }
    } else {
        while e > 0 as libc::c_int {
            if esign > 0 as libc::c_int {
                if s >=
                       (0xffffffff as libc::c_uint as libc::c_longlong |
                            (0x7fffffff as libc::c_int as i64_0) <<
                                32 as libc::c_int) /
                           10 as libc::c_int as libc::c_longlong {
                    break ;
                }
                s *= 10 as libc::c_int as libc::c_longlong
            } else {
                if s % 10 as libc::c_int as libc::c_longlong !=
                       0 as libc::c_int as libc::c_longlong {
                    break ;
                }
                s /= 10 as libc::c_int as libc::c_longlong
            }
            e -= 1
        }
        s = if sign < 0 as libc::c_int { -s } else { s };
        if e == 0 as libc::c_int {
            result = s as libc::c_double
        } else if e > 307 as libc::c_int {
            if e < 342 as libc::c_int {
                let mut scale: f128::f128 =
                    sqlite3Pow10(e - 308 as libc::c_int);
                if esign < 0 as libc::c_int {
                    result = (f128::f128::new(s) / scale).to_f64().unwrap();
                    result /= 1.0e+308f64
                } else {
                    result = (f128::f128::new(s) * scale).to_f64().unwrap();
                    result *= 1.0e+308f64
                }
            } else if esign < 0 as libc::c_int {
                result = 0.0f64 * s as libc::c_double
            } else {
                result =
                    (::std::f32::INFINITY * s as libc::c_float) as
                        libc::c_double
            }
        } else {
            let mut scale_0: f128::f128 = sqlite3Pow10(e);
            if esign < 0 as libc::c_int {
                result = (f128::f128::new(s) / scale_0).to_f64().unwrap()
            } else {
                result = (f128::f128::new(s) * scale_0).to_f64().unwrap()
            }
        }
    }
    *pResult = result;
    if z == zEnd && nDigit > 0 as libc::c_int && eValid != 0 &&
           eType > 0 as libc::c_int {
        return eType
    } else if eType >= 2 as libc::c_int &&
                  (eType == 3 as libc::c_int || eValid != 0) &&
                  nDigit > 0 as libc::c_int {
        return -(1 as libc::c_int)
    } else { return 0 as libc::c_int };
}
unsafe extern "C" fn compare2pow63(mut zNum: *const libc::c_char,
                                   mut incr: libc::c_int) -> libc::c_int {
    let mut c: libc::c_int = 0 as libc::c_int;
    let mut i: libc::c_int = 0;
    let mut pow63: *const libc::c_char =
        b"922337203685477580\x00" as *const u8 as *const libc::c_char;
    i = 0 as libc::c_int;
    while c == 0 as libc::c_int && i < 18 as libc::c_int {
        c =
            (*zNum.offset((i * incr) as isize) as libc::c_int -
                 *pow63.offset(i as isize) as libc::c_int) *
                10 as libc::c_int;
        i += 1
    }
    if c == 0 as libc::c_int {
        c =
            *zNum.offset((18 as libc::c_int * incr) as isize) as libc::c_int -
                '8' as i32
    }
    return c;
}
unsafe extern "C" fn sqlite3Atoi64(mut zNum: *const libc::c_char,
                                   mut pNum: *mut i64_0,
                                   mut length: libc::c_int, mut enc: u8_0)
 -> libc::c_int {
    let mut incr: libc::c_int = 0;
    let mut u: u64_0 = 0 as libc::c_int as u64_0;
    let mut neg: libc::c_int = 0 as libc::c_int;
    let mut i: libc::c_int = 0;
    let mut c: libc::c_int = 0 as libc::c_int;
    let mut nonNum: libc::c_int = 0 as libc::c_int;
    let mut rc: libc::c_int = 0;
    let mut zStart: *const libc::c_char = 0 as *const libc::c_char;
    let mut zEnd: *const libc::c_char = zNum.offset(length as isize);
    if enc as libc::c_int == 1 as libc::c_int {
        incr = 1 as libc::c_int
    } else {
        incr = 2 as libc::c_int;
        i = 3 as libc::c_int - enc as libc::c_int;
        while i < length &&
                  *zNum.offset(i as isize) as libc::c_int == 0 as libc::c_int
              {
            i += 2 as libc::c_int
        }
        nonNum = (i < length) as libc::c_int;
        zEnd =
            &*zNum.offset((i ^ 1 as libc::c_int) as isize) as
                *const libc::c_char;
        zNum = zNum.offset((enc as libc::c_int & 1 as libc::c_int) as isize)
    }
    while zNum < zEnd &&
              sqlite3CtypeMap[*zNum as libc::c_uchar as usize] as libc::c_int
                  & 0x1 as libc::c_int != 0 {
        zNum = zNum.offset(incr as isize)
    }
    if zNum < zEnd {
        if *zNum as libc::c_int == '-' as i32 {
            neg = 1 as libc::c_int;
            zNum = zNum.offset(incr as isize)
        } else if *zNum as libc::c_int == '+' as i32 {
            zNum = zNum.offset(incr as isize)
        }
    }
    zStart = zNum;
    while zNum < zEnd &&
              *zNum.offset(0 as libc::c_int as isize) as libc::c_int ==
                  '0' as i32 {
        zNum = zNum.offset(incr as isize)
    }
    i = 0 as libc::c_int;
    while (&*zNum.offset(i as isize) as *const libc::c_char) < zEnd &&
              {
                  c = *zNum.offset(i as isize) as libc::c_int;
                  (c) >= '0' as i32
              } && c <= '9' as i32 {
        u =
            u.wrapping_mul(10 as libc::c_int as
                               libc::c_ulonglong).wrapping_add(c as
                                                                   libc::c_ulonglong).wrapping_sub('0'
                                                                                                       as
                                                                                                       i32
                                                                                                       as
                                                                                                       libc::c_ulonglong);
        i += incr
    }
    if u >
           (0xffffffff as libc::c_uint as libc::c_longlong |
                (0x7fffffff as libc::c_int as i64_0) << 32 as libc::c_int) as
               libc::c_ulonglong {
        *pNum =
            if neg != 0 {
                (-(1 as libc::c_int) as i64_0) -
                    (0xffffffff as libc::c_uint as libc::c_longlong |
                         (0x7fffffff as libc::c_int as i64_0) <<
                             32 as libc::c_int)
            } else {
                (0xffffffff as libc::c_uint as libc::c_longlong) |
                    (0x7fffffff as libc::c_int as i64_0) << 32 as libc::c_int
            }
    } else if neg != 0 { *pNum = -(u as i64_0) } else { *pNum = u as i64_0 }
    rc = 0 as libc::c_int;
    if i == 0 as libc::c_int && zStart == zNum {
        rc = -(1 as libc::c_int)
    } else if nonNum != 0 {
        rc = 1 as libc::c_int
    } else if (&*zNum.offset(i as isize) as *const libc::c_char) < zEnd {
        let mut jj: libc::c_int = i;
        loop  {
            if sqlite3CtypeMap[*zNum.offset(jj as isize) as libc::c_uchar as
                                   usize] as libc::c_int & 0x1 as libc::c_int
                   == 0 {
                rc = 1 as libc::c_int;
                break ;
            } else {
                jj += incr;
                if !((&*zNum.offset(jj as isize) as *const libc::c_char) <
                         zEnd) {
                    break ;
                }
            }
        }
    }
    if i < 19 as libc::c_int * incr {
        return rc
    } else {
        c =
            if i > 19 as libc::c_int * incr {
                1 as libc::c_int
            } else { compare2pow63(zNum, incr) };
        if c < 0 as libc::c_int {
            return rc
        } else {
            *pNum =
                if neg != 0 {
                    (-(1 as libc::c_int) as i64_0) -
                        (0xffffffff as libc::c_uint as libc::c_longlong |
                             (0x7fffffff as libc::c_int as i64_0) <<
                                 32 as libc::c_int)
                } else {
                    (0xffffffff as libc::c_uint as libc::c_longlong) |
                        (0x7fffffff as libc::c_int as i64_0) <<
                            32 as libc::c_int
                };
            if c > 0 as libc::c_int {
                return 2 as libc::c_int
            } else { return if neg != 0 { rc } else { 3 as libc::c_int } }
        }
    };
}
unsafe extern "C" fn sqlite3DecOrHexToI64(mut z: *const libc::c_char,
                                          mut pOut: *mut i64_0)
 -> libc::c_int {
    if *z.offset(0 as libc::c_int as isize) as libc::c_int == '0' as i32 &&
           (*z.offset(1 as libc::c_int as isize) as libc::c_int == 'x' as i32
                ||
                *z.offset(1 as libc::c_int as isize) as libc::c_int ==
                    'X' as i32) {
        let mut u: u64_0 = 0 as libc::c_int as u64_0;
        let mut i: libc::c_int = 0;
        let mut k: libc::c_int = 0;
        i = 2 as libc::c_int;
        while *z.offset(i as isize) as libc::c_int == '0' as i32 { i += 1 }
        k = i;
        while sqlite3CtypeMap[*z.offset(k as isize) as libc::c_uchar as usize]
                  as libc::c_int & 0x8 as libc::c_int != 0 {
            u =
                u.wrapping_mul(16 as libc::c_int as
                                   libc::c_ulonglong).wrapping_add(sqlite3HexToInt(*z.offset(k
                                                                                                 as
                                                                                                 isize)
                                                                                       as
                                                                                       libc::c_int)
                                                                       as
                                                                       libc::c_ulonglong);
            k += 1
        }
        memcpy(pOut as *mut libc::c_void,
               &mut u as *mut u64_0 as *const libc::c_void,
               8 as libc::c_int as libc::c_ulong);
        return if *z.offset(k as isize) as libc::c_int == 0 as libc::c_int &&
                      k - i <= 16 as libc::c_int {
                   0 as libc::c_int
               } else { 2 as libc::c_int }
    } else {
        return sqlite3Atoi64(z, pOut, sqlite3Strlen30(z),
                             1 as libc::c_int as u8_0)
    };
}
unsafe extern "C" fn sqlite3GetInt32(mut zNum: *const libc::c_char,
                                     mut pValue: *mut libc::c_int)
 -> libc::c_int {
    let mut v: sqlite_int64 = 0 as libc::c_int as sqlite_int64;
    let mut i: libc::c_int = 0;
    let mut c: libc::c_int = 0;
    let mut neg: libc::c_int = 0 as libc::c_int;
    if *zNum.offset(0 as libc::c_int as isize) as libc::c_int == '-' as i32 {
        neg = 1 as libc::c_int;
        zNum = zNum.offset(1)
    } else if *zNum.offset(0 as libc::c_int as isize) as libc::c_int ==
                  '+' as i32 {
        zNum = zNum.offset(1)
    } else if *zNum.offset(0 as libc::c_int as isize) as libc::c_int ==
                  '0' as i32 &&
                  (*zNum.offset(1 as libc::c_int as isize) as libc::c_int ==
                       'x' as i32 ||
                       *zNum.offset(1 as libc::c_int as isize) as libc::c_int
                           == 'X' as i32) &&
                  sqlite3CtypeMap[*zNum.offset(2 as libc::c_int as isize) as
                                      libc::c_uchar as usize] as libc::c_int &
                      0x8 as libc::c_int != 0 {
        let mut u: u32_0 = 0 as libc::c_int as u32_0;
        zNum = zNum.offset(2 as libc::c_int as isize);
        while *zNum.offset(0 as libc::c_int as isize) as libc::c_int ==
                  '0' as i32 {
            zNum = zNum.offset(1)
        }
        i = 0 as libc::c_int;
        while sqlite3CtypeMap[*zNum.offset(i as isize) as libc::c_uchar as
                                  usize] as libc::c_int & 0x8 as libc::c_int
                  != 0 && i < 8 as libc::c_int {
            u =
                u.wrapping_mul(16 as libc::c_int as
                                   libc::c_uint).wrapping_add(sqlite3HexToInt(*zNum.offset(i
                                                                                               as
                                                                                               isize)
                                                                                  as
                                                                                  libc::c_int)
                                                                  as
                                                                  libc::c_uint);
            i += 1
        }
        if u & 0x80000000 as libc::c_uint == 0 as libc::c_int as libc::c_uint
               &&
               sqlite3CtypeMap[*zNum.offset(i as isize) as libc::c_uchar as
                                   usize] as libc::c_int & 0x8 as libc::c_int
                   == 0 as libc::c_int {
            memcpy(pValue as *mut libc::c_void,
                   &mut u as *mut u32_0 as *const libc::c_void,
                   4 as libc::c_int as libc::c_ulong);
            return 1 as libc::c_int
        } else { return 0 as libc::c_int }
    }
    if sqlite3CtypeMap[*zNum.offset(0 as libc::c_int as isize) as
                           libc::c_uchar as usize] as libc::c_int &
           0x4 as libc::c_int == 0 {
        return 0 as libc::c_int
    }
    while *zNum.offset(0 as libc::c_int as isize) as libc::c_int == '0' as i32
          {
        zNum = zNum.offset(1)
    }
    i = 0 as libc::c_int;
    while i < 11 as libc::c_int &&
              {
                  c = *zNum.offset(i as isize) as libc::c_int - '0' as i32;
                  (c) >= 0 as libc::c_int
              } && c <= 9 as libc::c_int {
        v = v * 10 as libc::c_int as libc::c_longlong + c as libc::c_longlong;
        i += 1
    }
    if i > 10 as libc::c_int { return 0 as libc::c_int }
    if v - neg as libc::c_longlong >
           2147483647 as libc::c_int as libc::c_longlong {
        return 0 as libc::c_int
    }
    if neg != 0 { v = -v }
    *pValue = v as libc::c_int;
    return 1 as libc::c_int;
}
unsafe extern "C" fn sqlite3Atoi(mut z: *const libc::c_char) -> libc::c_int {
    let mut x: libc::c_int = 0 as libc::c_int;
    if !z.is_null() { sqlite3GetInt32(z, &mut x); }
    return x;
}
#[inline(never)]
unsafe extern "C" fn putVarint64(mut p: *mut libc::c_uchar, mut v: u64_0)
 -> libc::c_int {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut n: libc::c_int = 0;
    let mut buf: [u8_0; 10] = [0; 10];
    if v & (0xff000000 as libc::c_uint as u64_0) << 32 as libc::c_int != 0 {
        *p.offset(8 as libc::c_int as isize) = v as u8_0;
        v >>= 8 as libc::c_int;
        i = 7 as libc::c_int;
        while i >= 0 as libc::c_int {
            *p.offset(i as isize) =
                (v & 0x7f as libc::c_int as libc::c_ulonglong |
                     0x80 as libc::c_int as libc::c_ulonglong) as u8_0;
            v >>= 7 as libc::c_int;
            i -= 1
        }
        return 9 as libc::c_int
    }
    n = 0 as libc::c_int;
    loop  {
        let fresh89 = n;
        n = n + 1;
        buf[fresh89 as usize] =
            (v & 0x7f as libc::c_int as libc::c_ulonglong |
                 0x80 as libc::c_int as libc::c_ulonglong) as u8_0;
        v >>= 7 as libc::c_int;
        if !(v != 0 as libc::c_int as libc::c_ulonglong) { break ; }
    }
    buf[0 as libc::c_int as usize] =
        (buf[0 as libc::c_int as usize] as libc::c_int & 0x7f as libc::c_int)
            as u8_0;
    i = 0 as libc::c_int;
    j = n - 1 as libc::c_int;
    while j >= 0 as libc::c_int {
        *p.offset(i as isize) = buf[j as usize];
        j -= 1;
        i += 1
    }
    return n;
}
unsafe extern "C" fn sqlite3PutVarint(mut p: *mut libc::c_uchar, mut v: u64_0)
 -> libc::c_int {
    if v <= 0x7f as libc::c_int as libc::c_ulonglong {
        *p.offset(0 as libc::c_int as isize) =
            (v & 0x7f as libc::c_int as libc::c_ulonglong) as libc::c_uchar;
        return 1 as libc::c_int
    }
    if v <= 0x3fff as libc::c_int as libc::c_ulonglong {
        *p.offset(0 as libc::c_int as isize) =
            (v >> 7 as libc::c_int & 0x7f as libc::c_int as libc::c_ulonglong
                 | 0x80 as libc::c_int as libc::c_ulonglong) as libc::c_uchar;
        *p.offset(1 as libc::c_int as isize) =
            (v & 0x7f as libc::c_int as libc::c_ulonglong) as libc::c_uchar;
        return 2 as libc::c_int
    }
    return putVarint64(p, v);
}
unsafe extern "C" fn sqlite3GetVarint(mut p: *const libc::c_uchar,
                                      mut v: *mut u64_0) -> u8_0 {
    let mut a: u32_0 = 0;
    let mut b: u32_0 = 0;
    let mut s: u32_0 = 0;
    if *(p as *mut libc::c_schar).offset(0 as libc::c_int as isize) as
           libc::c_int >= 0 as libc::c_int {
        *v = *p as u64_0;
        return 1 as libc::c_int as u8_0
    }
    if *(p as *mut libc::c_schar).offset(1 as libc::c_int as isize) as
           libc::c_int >= 0 as libc::c_int {
        *v =
            (((*p.offset(0 as libc::c_int as isize) as libc::c_int &
                   0x7f as libc::c_int) as u32_0) << 7 as libc::c_int |
                 *p.offset(1 as libc::c_int as isize) as libc::c_uint) as
                u64_0;
        return 2 as libc::c_int as u8_0
    }
    a = (*p.offset(0 as libc::c_int as isize) as u32_0) << 14 as libc::c_int;
    b = *p.offset(1 as libc::c_int as isize) as u32_0;
    p = p.offset(2 as libc::c_int as isize);
    a |= *p as libc::c_uint;
    if a & 0x80 as libc::c_int as libc::c_uint == 0 {
        a &= 0x1fc07f as libc::c_int as libc::c_uint;
        b &= 0x7f as libc::c_int as libc::c_uint;
        b = b << 7 as libc::c_int;
        a |= b;
        *v = a as u64_0;
        return 3 as libc::c_int as u8_0
    }
    a &= 0x1fc07f as libc::c_int as libc::c_uint;
    p = p.offset(1);
    b = b << 14 as libc::c_int;
    b |= *p as libc::c_uint;
    if b & 0x80 as libc::c_int as libc::c_uint == 0 {
        b &= 0x1fc07f as libc::c_int as libc::c_uint;
        a = a << 7 as libc::c_int;
        a |= b;
        *v = a as u64_0;
        return 4 as libc::c_int as u8_0
    }
    b &= 0x1fc07f as libc::c_int as libc::c_uint;
    s = a;
    p = p.offset(1);
    a = a << 14 as libc::c_int;
    a |= *p as libc::c_uint;
    if a & 0x80 as libc::c_int as libc::c_uint == 0 {
        b = b << 7 as libc::c_int;
        a |= b;
        s = s >> 18 as libc::c_int;
        *v = (s as u64_0) << 32 as libc::c_int | a as libc::c_ulonglong;
        return 5 as libc::c_int as u8_0
    }
    s = s << 7 as libc::c_int;
    s |= b;
    p = p.offset(1);
    b = b << 14 as libc::c_int;
    b |= *p as libc::c_uint;
    if b & 0x80 as libc::c_int as libc::c_uint == 0 {
        a &= 0x1fc07f as libc::c_int as libc::c_uint;
        a = a << 7 as libc::c_int;
        a |= b;
        s = s >> 18 as libc::c_int;
        *v = (s as u64_0) << 32 as libc::c_int | a as libc::c_ulonglong;
        return 6 as libc::c_int as u8_0
    }
    p = p.offset(1);
    a = a << 14 as libc::c_int;
    a |= *p as libc::c_uint;
    if a & 0x80 as libc::c_int as libc::c_uint == 0 {
        a &= 0xf01fc07f as libc::c_uint;
        b &= 0x1fc07f as libc::c_int as libc::c_uint;
        b = b << 7 as libc::c_int;
        a |= b;
        s = s >> 11 as libc::c_int;
        *v = (s as u64_0) << 32 as libc::c_int | a as libc::c_ulonglong;
        return 7 as libc::c_int as u8_0
    }
    a &= 0x1fc07f as libc::c_int as libc::c_uint;
    p = p.offset(1);
    b = b << 14 as libc::c_int;
    b |= *p as libc::c_uint;
    if b & 0x80 as libc::c_int as libc::c_uint == 0 {
        b &= 0xf01fc07f as libc::c_uint;
        a = a << 7 as libc::c_int;
        a |= b;
        s = s >> 4 as libc::c_int;
        *v = (s as u64_0) << 32 as libc::c_int | a as libc::c_ulonglong;
        return 8 as libc::c_int as u8_0
    }
    p = p.offset(1);
    a = a << 15 as libc::c_int;
    a |= *p as libc::c_uint;
    b &= 0x1fc07f as libc::c_int as libc::c_uint;
    b = b << 8 as libc::c_int;
    a |= b;
    s = s << 4 as libc::c_int;
    b = *p.offset(-(4 as libc::c_int) as isize) as u32_0;
    b &= 0x7f as libc::c_int as libc::c_uint;
    b = b >> 3 as libc::c_int;
    s |= b;
    *v = (s as u64_0) << 32 as libc::c_int | a as libc::c_ulonglong;
    return 9 as libc::c_int as u8_0;
}
unsafe extern "C" fn sqlite3GetVarint32(mut p: *const libc::c_uchar,
                                        mut v: *mut u32_0) -> u8_0 {
    let mut a: u32_0 = 0;
    let mut b: u32_0 = 0;
    a = *p as u32_0;
    p = p.offset(1);
    b = *p as u32_0;
    if b & 0x80 as libc::c_int as libc::c_uint == 0 {
        a &= 0x7f as libc::c_int as libc::c_uint;
        a = a << 7 as libc::c_int;
        *v = a | b;
        return 2 as libc::c_int as u8_0
    }
    p = p.offset(1);
    a = a << 14 as libc::c_int;
    a |= *p as libc::c_uint;
    if a & 0x80 as libc::c_int as libc::c_uint == 0 {
        a &=
            ((0x7f as libc::c_int) << 14 as libc::c_int | 0x7f as libc::c_int)
                as libc::c_uint;
        b &= 0x7f as libc::c_int as libc::c_uint;
        b = b << 7 as libc::c_int;
        *v = a | b;
        return 3 as libc::c_int as u8_0
    }
    let mut v64: u64_0 = 0;
    let mut n: u8_0 = 0;
    p = p.offset(-(2 as libc::c_int as isize));
    n = sqlite3GetVarint(p, &mut v64);
    if v64 &
           ((1 as libc::c_int as u64_0) <<
                32 as
                    libc::c_int).wrapping_sub(1 as libc::c_int as
                                                  libc::c_ulonglong) != v64 {
        *v = 0xffffffff as libc::c_uint
    } else { *v = v64 as u32_0 }
    return n;
}
unsafe extern "C" fn sqlite3VarintLen(mut v: u64_0) -> libc::c_int {
    let mut i: libc::c_int = 0;
    i = 1 as libc::c_int;
    loop  {
        v >>= 7 as libc::c_int;
        if !(v != 0 as libc::c_int as libc::c_ulonglong) { break ; }
        i += 1
    }
    return i;
}
unsafe extern "C" fn sqlite3Get4byte(mut p: *const u8_0) -> u32_0 {
    let mut x: u32_0 = 0;
    memcpy(&mut x as *mut u32_0 as *mut libc::c_void,
           p as *const libc::c_void, 4 as libc::c_int as libc::c_ulong);
    return x.swap_bytes();
}
unsafe extern "C" fn sqlite3Put4byte(mut p: *mut libc::c_uchar,
                                     mut v: u32_0) {
    let mut x: u32_0 = v.swap_bytes();
    memcpy(p as *mut libc::c_void,
           &mut x as *mut u32_0 as *const libc::c_void,
           4 as libc::c_int as libc::c_ulong);
}
unsafe extern "C" fn sqlite3HexToInt(mut h: libc::c_int) -> u8_0 {
    h += 9 as libc::c_int * (1 as libc::c_int & h >> 6 as libc::c_int);
    return (h & 0xf as libc::c_int) as u8_0;
}
unsafe extern "C" fn sqlite3HexToBlob(mut db: *mut sqlite3,
                                      mut z: *const libc::c_char,
                                      mut n: libc::c_int)
 -> *mut libc::c_void {
    let mut zBlob: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut i: libc::c_int = 0;
    zBlob =
        sqlite3DbMallocRawNN(db,
                             (n / 2 as libc::c_int + 1 as libc::c_int) as
                                 u64_0) as *mut libc::c_char;
    n -= 1;
    if !zBlob.is_null() {
        i = 0 as libc::c_int;
        while i < n {
            *zBlob.offset((i / 2 as libc::c_int) as isize) =
                ((sqlite3HexToInt(*z.offset(i as isize) as libc::c_int) as
                      libc::c_int) << 4 as libc::c_int |
                     sqlite3HexToInt(*z.offset((i + 1 as libc::c_int) as
                                                   isize) as libc::c_int) as
                         libc::c_int) as libc::c_char;
            i += 2 as libc::c_int
        }
        *zBlob.offset((i / 2 as libc::c_int) as isize) =
            0 as libc::c_int as libc::c_char
    }
    return zBlob as *mut libc::c_void;
}
unsafe extern "C" fn logBadConnection(mut zType: *const libc::c_char) {
    sqlite3_log(21 as libc::c_int,
                b"API call with %s database connection pointer\x00" as
                    *const u8 as *const libc::c_char, zType);
}
unsafe extern "C" fn sqlite3SafetyCheckOk(mut db: *mut sqlite3)
 -> libc::c_int {
    let mut magic: u32_0 = 0;
    if db.is_null() {
        logBadConnection(b"NULL\x00" as *const u8 as *const libc::c_char);
        return 0 as libc::c_int
    }
    magic = (*db).magic;
    if magic != 0xa029a697 as libc::c_uint {
        if sqlite3SafetyCheckSickOrOk(db) != 0 {
            logBadConnection(b"unopened\x00" as *const u8 as
                                 *const libc::c_char);
        }
        return 0 as libc::c_int
    } else { return 1 as libc::c_int };
}
unsafe extern "C" fn sqlite3SafetyCheckSickOrOk(mut db: *mut sqlite3)
 -> libc::c_int {
    let mut magic: u32_0 = 0;
    magic = (*db).magic;
    if magic != 0x4b771290 as libc::c_int as libc::c_uint &&
           magic != 0xa029a697 as libc::c_uint &&
           magic != 0xf03b7906 as libc::c_uint {
        logBadConnection(b"invalid\x00" as *const u8 as *const libc::c_char);
        return 0 as libc::c_int
    } else { return 1 as libc::c_int };
}
unsafe extern "C" fn sqlite3AddInt64(mut pA: *mut i64_0, mut iB: i64_0)
 -> libc::c_int {
    let (fresh90, fresh91) = (*pA).overflowing_add(iB);
    *pA = fresh90;
    return fresh91 as libc::c_int;
}
unsafe extern "C" fn sqlite3SubInt64(mut pA: *mut i64_0, mut iB: i64_0)
 -> libc::c_int {
    let (fresh92, fresh93) = (*pA).overflowing_sub(iB);
    *pA = fresh92;
    return fresh93 as libc::c_int;
}
unsafe extern "C" fn sqlite3MulInt64(mut pA: *mut i64_0, mut iB: i64_0)
 -> libc::c_int {
    let (fresh94, fresh95) = (*pA).overflowing_mul(iB);
    *pA = fresh94;
    return fresh95 as libc::c_int;
}
unsafe extern "C" fn sqlite3AbsInt32(mut x: libc::c_int) -> libc::c_int {
    if x >= 0 as libc::c_int { return x }
    if x == 0x80000000 as libc::c_uint as libc::c_int {
        return 0x7fffffff as libc::c_int
    }
    return -x;
}
unsafe extern "C" fn sqlite3LogEstAdd(mut a: LogEst, mut b: LogEst)
 -> LogEst {
    static mut x: [libc::c_uchar; 32] =
        [10 as libc::c_int as libc::c_uchar,
         10 as libc::c_int as libc::c_uchar,
         9 as libc::c_int as libc::c_uchar, 9 as libc::c_int as libc::c_uchar,
         8 as libc::c_int as libc::c_uchar, 8 as libc::c_int as libc::c_uchar,
         7 as libc::c_int as libc::c_uchar, 7 as libc::c_int as libc::c_uchar,
         7 as libc::c_int as libc::c_uchar, 6 as libc::c_int as libc::c_uchar,
         6 as libc::c_int as libc::c_uchar, 6 as libc::c_int as libc::c_uchar,
         5 as libc::c_int as libc::c_uchar, 5 as libc::c_int as libc::c_uchar,
         5 as libc::c_int as libc::c_uchar, 4 as libc::c_int as libc::c_uchar,
         4 as libc::c_int as libc::c_uchar, 4 as libc::c_int as libc::c_uchar,
         4 as libc::c_int as libc::c_uchar, 3 as libc::c_int as libc::c_uchar,
         3 as libc::c_int as libc::c_uchar, 3 as libc::c_int as libc::c_uchar,
         3 as libc::c_int as libc::c_uchar, 3 as libc::c_int as libc::c_uchar,
         3 as libc::c_int as libc::c_uchar, 2 as libc::c_int as libc::c_uchar,
         2 as libc::c_int as libc::c_uchar, 2 as libc::c_int as libc::c_uchar,
         2 as libc::c_int as libc::c_uchar, 2 as libc::c_int as libc::c_uchar,
         2 as libc::c_int as libc::c_uchar,
         2 as libc::c_int as libc::c_uchar];
    if a as libc::c_int >= b as libc::c_int {
        if a as libc::c_int > b as libc::c_int + 49 as libc::c_int {
            return a
        }
        if a as libc::c_int > b as libc::c_int + 31 as libc::c_int {
            return (a as libc::c_int + 1 as libc::c_int) as LogEst
        }
        return (a as libc::c_int +
                    x[(a as libc::c_int - b as libc::c_int) as usize] as
                        libc::c_int) as LogEst
    } else {
        if b as libc::c_int > a as libc::c_int + 49 as libc::c_int {
            return b
        }
        if b as libc::c_int > a as libc::c_int + 31 as libc::c_int {
            return (b as libc::c_int + 1 as libc::c_int) as LogEst
        }
        return (b as libc::c_int +
                    x[(b as libc::c_int - a as libc::c_int) as usize] as
                        libc::c_int) as LogEst
    };
}
unsafe extern "C" fn sqlite3LogEst(mut x: u64_0) -> LogEst {
    static mut a: [LogEst; 8] =
        [0 as libc::c_int as LogEst, 2 as libc::c_int as LogEst,
         3 as libc::c_int as LogEst, 5 as libc::c_int as LogEst,
         6 as libc::c_int as LogEst, 7 as libc::c_int as LogEst,
         8 as libc::c_int as LogEst, 9 as libc::c_int as LogEst];
    let mut y: LogEst = 40 as libc::c_int as LogEst;
    if x < 8 as libc::c_int as libc::c_ulonglong {
        if x < 2 as libc::c_int as libc::c_ulonglong {
            return 0 as libc::c_int as LogEst
        }
        while x < 8 as libc::c_int as libc::c_ulonglong {
            y = (y as libc::c_int - 10 as libc::c_int) as LogEst;
            x <<= 1 as libc::c_int
        }
    } else {
        let mut i: libc::c_int = 60 as libc::c_int - x.leading_zeros() as i32;
        y = (y as libc::c_int + i * 10 as libc::c_int) as LogEst;
        x >>= i
    }
    return (a[(x & 7 as libc::c_int as libc::c_ulonglong) as usize] as
                libc::c_int + y as libc::c_int - 10 as libc::c_int) as LogEst;
}
unsafe extern "C" fn sqlite3LogEstFromDouble(mut x: libc::c_double)
 -> LogEst {
    let mut a: u64_0 = 0;
    let mut e: LogEst = 0;
    if x <= 1 as libc::c_int as libc::c_double {
        return 0 as libc::c_int as LogEst
    }
    if x <= 2000000000 as libc::c_int as libc::c_double {
        return sqlite3LogEst(x as u64_0)
    }
    memcpy(&mut a as *mut u64_0 as *mut libc::c_void,
           &mut x as *mut libc::c_double as *const libc::c_void,
           8 as libc::c_int as libc::c_ulong);
    e =
        (a >>
             52 as
                 libc::c_int).wrapping_sub(1022 as libc::c_int as
                                               libc::c_ulonglong) as LogEst;
    return (e as libc::c_int * 10 as libc::c_int) as LogEst;
}
unsafe extern "C" fn sqlite3VListAdd(mut db: *mut sqlite3,
                                     mut pIn: *mut VList,
                                     mut zName: *const libc::c_char,
                                     mut nName: libc::c_int,
                                     mut iVal: libc::c_int) -> *mut VList {
    let mut nInt: libc::c_int = 0;
    let mut z: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut i: libc::c_int = 0;
    nInt = nName / 4 as libc::c_int + 3 as libc::c_int;
    if pIn.is_null() ||
           *pIn.offset(1 as libc::c_int as isize) + nInt >
               *pIn.offset(0 as libc::c_int as isize) {
        let mut nAlloc: sqlite3_int64 =
            (if !pIn.is_null() {
                 (2 as libc::c_int as libc::c_longlong) *
                     *pIn.offset(0 as libc::c_int as isize) as sqlite3_int64
             } else { 10 as libc::c_int as libc::c_longlong }) +
                nInt as libc::c_longlong;
        let mut pOut: *mut VList =
            sqlite3DbRealloc(db, pIn as *mut libc::c_void,
                             (nAlloc as
                                  libc::c_ulonglong).wrapping_mul(::std::mem::size_of::<libc::c_int>()
                                                                      as
                                                                      libc::c_ulong
                                                                      as
                                                                      libc::c_ulonglong))
                as *mut VList;
        if pOut.is_null() { return pIn }
        if pIn.is_null() {
            *pOut.offset(1 as libc::c_int as isize) = 2 as libc::c_int
        }
        pIn = pOut;
        *pIn.offset(0 as libc::c_int as isize) = nAlloc as VList
    }
    i = *pIn.offset(1 as libc::c_int as isize);
    *pIn.offset(i as isize) = iVal;
    *pIn.offset((i + 1 as libc::c_int) as isize) = nInt;
    z =
        &mut *pIn.offset((i + 2 as libc::c_int) as isize) as *mut VList as
            *mut libc::c_char;
    *pIn.offset(1 as libc::c_int as isize) = i + nInt;
    memcpy(z as *mut libc::c_void, zName as *const libc::c_void,
           nName as libc::c_ulong);
    *z.offset(nName as isize) = 0 as libc::c_int as libc::c_char;
    return pIn;
}
unsafe extern "C" fn sqlite3VListNumToName(mut pIn: *mut VList,
                                           mut iVal: libc::c_int)
 -> *const libc::c_char {
    let mut i: libc::c_int = 0;
    let mut mx: libc::c_int = 0;
    if pIn.is_null() { return 0 as *const libc::c_char }
    mx = *pIn.offset(1 as libc::c_int as isize);
    i = 2 as libc::c_int;
    loop  {
        if *pIn.offset(i as isize) == iVal {
            return &mut *pIn.offset((i + 2 as libc::c_int) as isize) as
                       *mut VList as *mut libc::c_char
        }
        i += *pIn.offset((i + 1 as libc::c_int) as isize);
        if !(i < mx) { break ; }
    }
    return 0 as *const libc::c_char;
}
unsafe extern "C" fn sqlite3VListNameToNum(mut pIn: *mut VList,
                                           mut zName: *const libc::c_char,
                                           mut nName: libc::c_int)
 -> libc::c_int {
    let mut i: libc::c_int = 0;
    let mut mx: libc::c_int = 0;
    if pIn.is_null() { return 0 as libc::c_int }
    mx = *pIn.offset(1 as libc::c_int as isize);
    i = 2 as libc::c_int;
    loop  {
        let mut z: *const libc::c_char =
            &mut *pIn.offset((i + 2 as libc::c_int) as isize) as *mut VList as
                *const libc::c_char;
        if strncmp(z, zName, nName as libc::c_ulong) == 0 as libc::c_int &&
               *z.offset(nName as isize) as libc::c_int == 0 as libc::c_int {
            return *pIn.offset(i as isize)
        }
        i += *pIn.offset((i + 1 as libc::c_int) as isize);
        if !(i < mx) { break ; }
    }
    return 0 as libc::c_int;
}
unsafe extern "C" fn sqlite3HashInit(mut pNew: *mut Hash) {
    (*pNew).first = 0 as *mut HashElem;
    (*pNew).count = 0 as libc::c_int as libc::c_uint;
    (*pNew).htsize = 0 as libc::c_int as libc::c_uint;
    (*pNew).ht = 0 as *mut _ht;
}
unsafe extern "C" fn sqlite3HashClear(mut pH: *mut Hash) {
    let mut elem: *mut HashElem = 0 as *mut HashElem;
    elem = (*pH).first;
    (*pH).first = 0 as *mut HashElem;
    sqlite3_free((*pH).ht as *mut libc::c_void);
    (*pH).ht = 0 as *mut _ht;
    (*pH).htsize = 0 as libc::c_int as libc::c_uint;
    while !elem.is_null() {
        let mut next_elem: *mut HashElem = (*elem).next;
        sqlite3_free(elem as *mut libc::c_void);
        elem = next_elem
    }
    (*pH).count = 0 as libc::c_int as libc::c_uint;
}
unsafe extern "C" fn strHash(mut z: *const libc::c_char) -> libc::c_uint {
    let mut h: libc::c_uint = 0 as libc::c_int as libc::c_uint;
    let mut c: libc::c_uchar = 0;
    loop  {
        let fresh96 = z;
        z = z.offset(1);
        c = *fresh96 as libc::c_uchar;
        if !(c as libc::c_int != 0 as libc::c_int) { break ; }
        h = h.wrapping_add(sqlite3UpperToLower[c as usize] as libc::c_uint);
        h = h.wrapping_mul(0x9e3779b1 as libc::c_uint)
    }
    return h;
}
unsafe extern "C" fn insertElement(mut pH: *mut Hash, mut pEntry: *mut _ht,
                                   mut pNew: *mut HashElem) {
    let mut pHead: *mut HashElem = 0 as *mut HashElem;
    if !pEntry.is_null() {
        pHead =
            if (*pEntry).count != 0 {
                (*pEntry).chain
            } else { 0 as *mut HashElem };
        (*pEntry).count = (*pEntry).count.wrapping_add(1);
        (*pEntry).chain = pNew
    } else { pHead = 0 as *mut HashElem }
    if !pHead.is_null() {
        (*pNew).next = pHead;
        (*pNew).prev = (*pHead).prev;
        if !(*pHead).prev.is_null() {
            (*(*pHead).prev).next = pNew
        } else { (*pH).first = pNew }
        (*pHead).prev = pNew
    } else {
        (*pNew).next = (*pH).first;
        if !(*pH).first.is_null() { (*(*pH).first).prev = pNew }
        (*pNew).prev = 0 as *mut HashElem;
        (*pH).first = pNew
    };
}
unsafe extern "C" fn rehash(mut pH: *mut Hash, mut new_size: libc::c_uint)
 -> libc::c_int {
    let mut new_ht: *mut _ht = 0 as *mut _ht;
    let mut elem: *mut HashElem = 0 as *mut HashElem;
    let mut next_elem: *mut HashElem = 0 as *mut HashElem;
    if (new_size as
            libc::c_ulong).wrapping_mul(::std::mem::size_of::<_ht>() as
                                            libc::c_ulong) >
           1024 as libc::c_int as libc::c_ulong {
        new_size =
            (1024 as libc::c_int as
                 libc::c_ulong).wrapping_div(::std::mem::size_of::<_ht>() as
                                                 libc::c_ulong) as
                libc::c_uint
    }
    if new_size == (*pH).htsize { return 0 as libc::c_int }
    sqlite3BeginBenignMalloc();
    new_ht =
        sqlite3Malloc((new_size as
                           libc::c_ulong).wrapping_mul(::std::mem::size_of::<_ht>()
                                                           as libc::c_ulong)
                          as u64_0) as *mut _ht;
    sqlite3EndBenignMalloc();
    if new_ht.is_null() { return 0 as libc::c_int }
    sqlite3_free((*pH).ht as *mut libc::c_void);
    (*pH).ht = new_ht;
    new_size =
        (sqlite3MallocSize(new_ht as *mut libc::c_void) as
             libc::c_ulong).wrapping_div(::std::mem::size_of::<_ht>() as
                                             libc::c_ulong) as libc::c_uint;
    (*pH).htsize = new_size;
    memset(new_ht as *mut libc::c_void, 0 as libc::c_int,
           (new_size as
                libc::c_ulong).wrapping_mul(::std::mem::size_of::<_ht>() as
                                                libc::c_ulong));
    elem = (*pH).first;
    (*pH).first = 0 as *mut HashElem;
    while !elem.is_null() {
        let mut h: libc::c_uint =
            strHash((*elem).pKey).wrapping_rem(new_size);
        next_elem = (*elem).next;
        insertElement(pH, &mut *new_ht.offset(h as isize), elem);
        elem = next_elem
    }
    return 1 as libc::c_int;
}
unsafe extern "C" fn findElementWithHash(mut pH: *const Hash,
                                         mut pKey: *const libc::c_char,
                                         mut pHash: *mut libc::c_uint)
 -> *mut HashElem {
    let mut elem: *mut HashElem = 0 as *mut HashElem;
    let mut count: libc::c_uint = 0;
    let mut h: libc::c_uint = 0;
    static mut nullElement: HashElem =
        {
            let mut init =
                HashElem{next: 0 as *const HashElem as *mut HashElem,
                         prev: 0 as *const HashElem as *mut HashElem,
                         data: 0 as *const libc::c_void as *mut libc::c_void,
                         pKey: 0 as *const libc::c_char,};
            init
        };
    if !(*pH).ht.is_null() {
        let mut pEntry: *mut _ht = 0 as *mut _ht;
        h = strHash(pKey).wrapping_rem((*pH).htsize);
        pEntry = &mut *(*pH).ht.offset(h as isize) as *mut _ht;
        elem = (*pEntry).chain;
        count = (*pEntry).count
    } else {
        h = 0 as libc::c_int as libc::c_uint;
        elem = (*pH).first;
        count = (*pH).count
    }
    if !pHash.is_null() { *pHash = h }
    loop  {
        let fresh97 = count;
        count = count.wrapping_sub(1);
        if !(fresh97 != 0) { break ; }
        if sqlite3StrICmp((*elem).pKey, pKey) == 0 as libc::c_int {
            return elem
        }
        elem = (*elem).next
    }
    return &mut nullElement;
}
unsafe extern "C" fn removeElementGivenHash(mut pH: *mut Hash,
                                            mut elem: *mut HashElem,
                                            mut h: libc::c_uint) {
    let mut pEntry: *mut _ht = 0 as *mut _ht;
    if !(*elem).prev.is_null() {
        (*(*elem).prev).next = (*elem).next
    } else { (*pH).first = (*elem).next }
    if !(*elem).next.is_null() { (*(*elem).next).prev = (*elem).prev }
    if !(*pH).ht.is_null() {
        pEntry = &mut *(*pH).ht.offset(h as isize) as *mut _ht;
        if (*pEntry).chain == elem { (*pEntry).chain = (*elem).next }
        (*pEntry).count = (*pEntry).count.wrapping_sub(1)
    }
    sqlite3_free(elem as *mut libc::c_void);
    (*pH).count = (*pH).count.wrapping_sub(1);
    if (*pH).count == 0 as libc::c_int as libc::c_uint {
        sqlite3HashClear(pH);
    };
}
unsafe extern "C" fn sqlite3HashFind(mut pH: *const Hash,
                                     mut pKey: *const libc::c_char)
 -> *mut libc::c_void {
    return (*findElementWithHash(pH, pKey, 0 as *mut libc::c_uint)).data;
}
unsafe extern "C" fn sqlite3HashInsert(mut pH: *mut Hash,
                                       mut pKey: *const libc::c_char,
                                       mut data: *mut libc::c_void)
 -> *mut libc::c_void {
    let mut h: libc::c_uint = 0;
    let mut elem: *mut HashElem = 0 as *mut HashElem;
    let mut new_elem: *mut HashElem = 0 as *mut HashElem;
    elem = findElementWithHash(pH, pKey, &mut h);
    if !(*elem).data.is_null() {
        let mut old_data: *mut libc::c_void = (*elem).data;
        if data.is_null() {
            removeElementGivenHash(pH, elem, h);
        } else { (*elem).data = data; (*elem).pKey = pKey }
        return old_data
    }
    if data.is_null() { return 0 as *mut libc::c_void }
    new_elem =
        sqlite3Malloc(::std::mem::size_of::<HashElem>() as libc::c_ulong as
                          u64_0) as *mut HashElem;
    if new_elem.is_null() { return data }
    (*new_elem).pKey = pKey;
    (*new_elem).data = data;
    (*pH).count = (*pH).count.wrapping_add(1);
    if (*pH).count >= 10 as libc::c_int as libc::c_uint &&
           (*pH).count >
               (2 as libc::c_int as libc::c_uint).wrapping_mul((*pH).htsize) {
        if rehash(pH,
                  (*pH).count.wrapping_mul(2 as libc::c_int as libc::c_uint))
               != 0 {
            h = strHash(pKey).wrapping_rem((*pH).htsize)
        }
    }
    insertElement(pH,
                  if !(*pH).ht.is_null() {
                      &mut *(*pH).ht.offset(h as isize)
                  } else { 0 as *mut _ht }, new_elem);
    return 0 as *mut libc::c_void;
}
unsafe extern "C" fn sqlite3OpcodeName(mut i: libc::c_int)
 -> *const libc::c_char {
    static mut azName: [*const libc::c_char; 176] =
        [b"Savepoint\x00" as *const u8 as *const libc::c_char,
         b"AutoCommit\x00" as *const u8 as *const libc::c_char,
         b"Transaction\x00" as *const u8 as *const libc::c_char,
         b"SorterNext\x00" as *const u8 as *const libc::c_char,
         b"Prev\x00" as *const u8 as *const libc::c_char,
         b"Next\x00" as *const u8 as *const libc::c_char,
         b"Checkpoint\x00" as *const u8 as *const libc::c_char,
         b"JournalMode\x00" as *const u8 as *const libc::c_char,
         b"Vacuum\x00" as *const u8 as *const libc::c_char,
         b"VFilter\x00" as *const u8 as *const libc::c_char,
         b"VUpdate\x00" as *const u8 as *const libc::c_char,
         b"Goto\x00" as *const u8 as *const libc::c_char,
         b"Gosub\x00" as *const u8 as *const libc::c_char,
         b"InitCoroutine\x00" as *const u8 as *const libc::c_char,
         b"Yield\x00" as *const u8 as *const libc::c_char,
         b"MustBeInt\x00" as *const u8 as *const libc::c_char,
         b"Jump\x00" as *const u8 as *const libc::c_char,
         b"Once\x00" as *const u8 as *const libc::c_char,
         b"If\x00" as *const u8 as *const libc::c_char,
         b"Not\x00" as *const u8 as *const libc::c_char,
         b"IfNot\x00" as *const u8 as *const libc::c_char,
         b"IfNullRow\x00" as *const u8 as *const libc::c_char,
         b"SeekLT\x00" as *const u8 as *const libc::c_char,
         b"SeekLE\x00" as *const u8 as *const libc::c_char,
         b"SeekGE\x00" as *const u8 as *const libc::c_char,
         b"SeekGT\x00" as *const u8 as *const libc::c_char,
         b"IfNotOpen\x00" as *const u8 as *const libc::c_char,
         b"IfNoHope\x00" as *const u8 as *const libc::c_char,
         b"NoConflict\x00" as *const u8 as *const libc::c_char,
         b"NotFound\x00" as *const u8 as *const libc::c_char,
         b"Found\x00" as *const u8 as *const libc::c_char,
         b"SeekRowid\x00" as *const u8 as *const libc::c_char,
         b"NotExists\x00" as *const u8 as *const libc::c_char,
         b"Last\x00" as *const u8 as *const libc::c_char,
         b"IfSmaller\x00" as *const u8 as *const libc::c_char,
         b"SorterSort\x00" as *const u8 as *const libc::c_char,
         b"Sort\x00" as *const u8 as *const libc::c_char,
         b"Rewind\x00" as *const u8 as *const libc::c_char,
         b"IdxLE\x00" as *const u8 as *const libc::c_char,
         b"IdxGT\x00" as *const u8 as *const libc::c_char,
         b"IdxLT\x00" as *const u8 as *const libc::c_char,
         b"IdxGE\x00" as *const u8 as *const libc::c_char,
         b"RowSetRead\x00" as *const u8 as *const libc::c_char,
         b"Or\x00" as *const u8 as *const libc::c_char,
         b"And\x00" as *const u8 as *const libc::c_char,
         b"RowSetTest\x00" as *const u8 as *const libc::c_char,
         b"Program\x00" as *const u8 as *const libc::c_char,
         b"FkIfZero\x00" as *const u8 as *const libc::c_char,
         b"IfPos\x00" as *const u8 as *const libc::c_char,
         b"IfNotZero\x00" as *const u8 as *const libc::c_char,
         b"IsNull\x00" as *const u8 as *const libc::c_char,
         b"NotNull\x00" as *const u8 as *const libc::c_char,
         b"Ne\x00" as *const u8 as *const libc::c_char,
         b"Eq\x00" as *const u8 as *const libc::c_char,
         b"Gt\x00" as *const u8 as *const libc::c_char,
         b"Le\x00" as *const u8 as *const libc::c_char,
         b"Lt\x00" as *const u8 as *const libc::c_char,
         b"Ge\x00" as *const u8 as *const libc::c_char,
         b"ElseNotEq\x00" as *const u8 as *const libc::c_char,
         b"DecrJumpZero\x00" as *const u8 as *const libc::c_char,
         b"IncrVacuum\x00" as *const u8 as *const libc::c_char,
         b"VNext\x00" as *const u8 as *const libc::c_char,
         b"Init\x00" as *const u8 as *const libc::c_char,
         b"PureFunc\x00" as *const u8 as *const libc::c_char,
         b"Function\x00" as *const u8 as *const libc::c_char,
         b"Return\x00" as *const u8 as *const libc::c_char,
         b"EndCoroutine\x00" as *const u8 as *const libc::c_char,
         b"HaltIfNull\x00" as *const u8 as *const libc::c_char,
         b"Halt\x00" as *const u8 as *const libc::c_char,
         b"Integer\x00" as *const u8 as *const libc::c_char,
         b"Int64\x00" as *const u8 as *const libc::c_char,
         b"String\x00" as *const u8 as *const libc::c_char,
         b"Null\x00" as *const u8 as *const libc::c_char,
         b"SoftNull\x00" as *const u8 as *const libc::c_char,
         b"Blob\x00" as *const u8 as *const libc::c_char,
         b"Variable\x00" as *const u8 as *const libc::c_char,
         b"Move\x00" as *const u8 as *const libc::c_char,
         b"Copy\x00" as *const u8 as *const libc::c_char,
         b"SCopy\x00" as *const u8 as *const libc::c_char,
         b"IntCopy\x00" as *const u8 as *const libc::c_char,
         b"ResultRow\x00" as *const u8 as *const libc::c_char,
         b"CollSeq\x00" as *const u8 as *const libc::c_char,
         b"AddImm\x00" as *const u8 as *const libc::c_char,
         b"RealAffinity\x00" as *const u8 as *const libc::c_char,
         b"Cast\x00" as *const u8 as *const libc::c_char,
         b"Permutation\x00" as *const u8 as *const libc::c_char,
         b"Compare\x00" as *const u8 as *const libc::c_char,
         b"IsTrue\x00" as *const u8 as *const libc::c_char,
         b"Offset\x00" as *const u8 as *const libc::c_char,
         b"Column\x00" as *const u8 as *const libc::c_char,
         b"Affinity\x00" as *const u8 as *const libc::c_char,
         b"MakeRecord\x00" as *const u8 as *const libc::c_char,
         b"Count\x00" as *const u8 as *const libc::c_char,
         b"ReadCookie\x00" as *const u8 as *const libc::c_char,
         b"SetCookie\x00" as *const u8 as *const libc::c_char,
         b"ReopenIdx\x00" as *const u8 as *const libc::c_char,
         b"OpenRead\x00" as *const u8 as *const libc::c_char,
         b"OpenWrite\x00" as *const u8 as *const libc::c_char,
         b"OpenDup\x00" as *const u8 as *const libc::c_char,
         b"OpenAutoindex\x00" as *const u8 as *const libc::c_char,
         b"OpenEphemeral\x00" as *const u8 as *const libc::c_char,
         b"BitAnd\x00" as *const u8 as *const libc::c_char,
         b"BitOr\x00" as *const u8 as *const libc::c_char,
         b"ShiftLeft\x00" as *const u8 as *const libc::c_char,
         b"ShiftRight\x00" as *const u8 as *const libc::c_char,
         b"Add\x00" as *const u8 as *const libc::c_char,
         b"Subtract\x00" as *const u8 as *const libc::c_char,
         b"Multiply\x00" as *const u8 as *const libc::c_char,
         b"Divide\x00" as *const u8 as *const libc::c_char,
         b"Remainder\x00" as *const u8 as *const libc::c_char,
         b"Concat\x00" as *const u8 as *const libc::c_char,
         b"SorterOpen\x00" as *const u8 as *const libc::c_char,
         b"BitNot\x00" as *const u8 as *const libc::c_char,
         b"SequenceTest\x00" as *const u8 as *const libc::c_char,
         b"OpenPseudo\x00" as *const u8 as *const libc::c_char,
         b"String8\x00" as *const u8 as *const libc::c_char,
         b"Close\x00" as *const u8 as *const libc::c_char,
         b"ColumnsUsed\x00" as *const u8 as *const libc::c_char,
         b"SeekHit\x00" as *const u8 as *const libc::c_char,
         b"Sequence\x00" as *const u8 as *const libc::c_char,
         b"NewRowid\x00" as *const u8 as *const libc::c_char,
         b"Insert\x00" as *const u8 as *const libc::c_char,
         b"Delete\x00" as *const u8 as *const libc::c_char,
         b"ResetCount\x00" as *const u8 as *const libc::c_char,
         b"SorterCompare\x00" as *const u8 as *const libc::c_char,
         b"SorterData\x00" as *const u8 as *const libc::c_char,
         b"RowData\x00" as *const u8 as *const libc::c_char,
         b"Rowid\x00" as *const u8 as *const libc::c_char,
         b"NullRow\x00" as *const u8 as *const libc::c_char,
         b"SeekEnd\x00" as *const u8 as *const libc::c_char,
         b"IdxInsert\x00" as *const u8 as *const libc::c_char,
         b"SorterInsert\x00" as *const u8 as *const libc::c_char,
         b"IdxDelete\x00" as *const u8 as *const libc::c_char,
         b"DeferredSeek\x00" as *const u8 as *const libc::c_char,
         b"IdxRowid\x00" as *const u8 as *const libc::c_char,
         b"FinishSeek\x00" as *const u8 as *const libc::c_char,
         b"Destroy\x00" as *const u8 as *const libc::c_char,
         b"Clear\x00" as *const u8 as *const libc::c_char,
         b"ResetSorter\x00" as *const u8 as *const libc::c_char,
         b"CreateBtree\x00" as *const u8 as *const libc::c_char,
         b"SqlExec\x00" as *const u8 as *const libc::c_char,
         b"ParseSchema\x00" as *const u8 as *const libc::c_char,
         b"LoadAnalysis\x00" as *const u8 as *const libc::c_char,
         b"DropTable\x00" as *const u8 as *const libc::c_char,
         b"DropIndex\x00" as *const u8 as *const libc::c_char,
         b"DropTrigger\x00" as *const u8 as *const libc::c_char,
         b"IntegrityCk\x00" as *const u8 as *const libc::c_char,
         b"RowSetAdd\x00" as *const u8 as *const libc::c_char,
         b"Param\x00" as *const u8 as *const libc::c_char,
         b"FkCounter\x00" as *const u8 as *const libc::c_char,
         b"Real\x00" as *const u8 as *const libc::c_char,
         b"MemMax\x00" as *const u8 as *const libc::c_char,
         b"OffsetLimit\x00" as *const u8 as *const libc::c_char,
         b"AggInverse\x00" as *const u8 as *const libc::c_char,
         b"AggStep\x00" as *const u8 as *const libc::c_char,
         b"AggStep1\x00" as *const u8 as *const libc::c_char,
         b"AggValue\x00" as *const u8 as *const libc::c_char,
         b"AggFinal\x00" as *const u8 as *const libc::c_char,
         b"Expire\x00" as *const u8 as *const libc::c_char,
         b"CursorLock\x00" as *const u8 as *const libc::c_char,
         b"CursorUnlock\x00" as *const u8 as *const libc::c_char,
         b"TableLock\x00" as *const u8 as *const libc::c_char,
         b"VBegin\x00" as *const u8 as *const libc::c_char,
         b"VCreate\x00" as *const u8 as *const libc::c_char,
         b"VDestroy\x00" as *const u8 as *const libc::c_char,
         b"VOpen\x00" as *const u8 as *const libc::c_char,
         b"VColumn\x00" as *const u8 as *const libc::c_char,
         b"VRename\x00" as *const u8 as *const libc::c_char,
         b"Pagecount\x00" as *const u8 as *const libc::c_char,
         b"MaxPgcnt\x00" as *const u8 as *const libc::c_char,
         b"Trace\x00" as *const u8 as *const libc::c_char,
         b"CursorHint\x00" as *const u8 as *const libc::c_char,
         b"ReleaseReg\x00" as *const u8 as *const libc::c_char,
         b"Noop\x00" as *const u8 as *const libc::c_char,
         b"Explain\x00" as *const u8 as *const libc::c_char,
         b"Abortable\x00" as *const u8 as *const libc::c_char];
    return azName[i as usize];
}
static mut randomnessPid: pid_t = 0 as libc::c_int;
unsafe extern "C" fn posixOpen(mut zFile: *const libc::c_char,
                               mut flags: libc::c_int, mut mode: libc::c_int)
 -> libc::c_int {
    return open(zFile, flags, mode);
}
static mut aSyscall: [unix_syscall; 29] =
    unsafe {
        [{
             let mut init =
                 unix_syscall{zName:
                                  b"open\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          *const libc::c_char,
                                                                                      _:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          libc::c_int)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(posixOpen
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 *const libc::c_char,
                                                                                                             _:
                                                                                                                 libc::c_int,
                                                                                                             _:
                                                                                                                 libc::c_int)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"close\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          libc::c_int)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(close
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 libc::c_int)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"access\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          *const libc::c_char,
                                                                                      _:
                                                                                          libc::c_int)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(access
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 *const libc::c_char,
                                                                                                             _:
                                                                                                                 libc::c_int)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"getcwd\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          *mut libc::c_char,
                                                                                      _:
                                                                                          size_t)
                                                                     ->
                                                                         *mut libc::c_char>,
                                                          sqlite3_syscall_ptr>(Some(getcwd
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 *mut libc::c_char,
                                                                                                             _:
                                                                                                                 size_t)
                                                                                            ->
                                                                                                *mut libc::c_char)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"stat\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          *const libc::c_char,
                                                                                      _:
                                                                                          *mut stat)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(stat
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 *const libc::c_char,
                                                                                                             _:
                                                                                                                 *mut stat)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"fstat\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          *mut stat)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(fstat
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 libc::c_int,
                                                                                                             _:
                                                                                                                 *mut stat)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"ftruncate\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          __off64_t)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(ftruncate
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 libc::c_int,
                                                                                                             _:
                                                                                                                 __off64_t)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"fcntl\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          ...)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(fcntl
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 libc::c_int,
                                                                                                             _:
                                                                                                                 libc::c_int,
                                                                                                             _:
                                                                                                                 ...)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"read\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          *mut libc::c_void,
                                                                                      _:
                                                                                          size_t)
                                                                     ->
                                                                         ssize_t>,
                                                          sqlite3_syscall_ptr>(Some(read
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 libc::c_int,
                                                                                                             _:
                                                                                                                 *mut libc::c_void,
                                                                                                             _:
                                                                                                                 size_t)
                                                                                            ->
                                                                                                ssize_t)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"pread\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent: None,
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"pread64\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent: None,
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"write\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          *const libc::c_void,
                                                                                      _:
                                                                                          size_t)
                                                                     ->
                                                                         ssize_t>,
                                                          sqlite3_syscall_ptr>(Some(write
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 libc::c_int,
                                                                                                             _:
                                                                                                                 *const libc::c_void,
                                                                                                             _:
                                                                                                                 size_t)
                                                                                            ->
                                                                                                ssize_t)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"pwrite\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent: None,
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"pwrite64\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent: None,
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"fchmod\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          __mode_t)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(fchmod
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 libc::c_int,
                                                                                                             _:
                                                                                                                 __mode_t)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"fallocate\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent: None,
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"unlink\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          *const libc::c_char)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(unlink
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 *const libc::c_char)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"openDirectory\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          *const libc::c_char,
                                                                                      _:
                                                                                          *mut libc::c_int)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(openDirectory
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 *const libc::c_char,
                                                                                                             _:
                                                                                                                 *mut libc::c_int)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"mkdir\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          *const libc::c_char,
                                                                                      _:
                                                                                          __mode_t)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(mkdir
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 *const libc::c_char,
                                                                                                             _:
                                                                                                                 __mode_t)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"rmdir\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          *const libc::c_char)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(rmdir
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 *const libc::c_char)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"fchown\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          __uid_t,
                                                                                      _:
                                                                                          __gid_t)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(fchown
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 libc::c_int,
                                                                                                             _:
                                                                                                                 __uid_t,
                                                                                                             _:
                                                                                                                 __gid_t)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"geteuid\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn()
                                                                     ->
                                                                         __uid_t>,
                                                          sqlite3_syscall_ptr>(Some(geteuid
                                                                                        as
                                                                                        unsafe extern "C" fn()
                                                                                            ->
                                                                                                __uid_t)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"mmap\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          *mut libc::c_void,
                                                                                      _:
                                                                                          size_t,
                                                                                      _:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          __off64_t)
                                                                     ->
                                                                         *mut libc::c_void>,
                                                          sqlite3_syscall_ptr>(Some(mmap
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 *mut libc::c_void,
                                                                                                             _:
                                                                                                                 size_t,
                                                                                                             _:
                                                                                                                 libc::c_int,
                                                                                                             _:
                                                                                                                 libc::c_int,
                                                                                                             _:
                                                                                                                 libc::c_int,
                                                                                                             _:
                                                                                                                 __off64_t)
                                                                                            ->
                                                                                                *mut libc::c_void)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"munmap\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          *mut libc::c_void,
                                                                                      _:
                                                                                          size_t)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(munmap
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 *mut libc::c_void,
                                                                                                             _:
                                                                                                                 size_t)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"mremap\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          *mut libc::c_void,
                                                                                      _:
                                                                                          size_t,
                                                                                      _:
                                                                                          size_t,
                                                                                      _:
                                                                                          libc::c_int,
                                                                                      _:
                                                                                          ...)
                                                                     ->
                                                                         *mut libc::c_void>,
                                                          sqlite3_syscall_ptr>(Some(mremap
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 *mut libc::c_void,
                                                                                                             _:
                                                                                                                 size_t,
                                                                                                             _:
                                                                                                                 size_t,
                                                                                                             _:
                                                                                                                 libc::c_int,
                                                                                                             _:
                                                                                                                 ...)
                                                                                            ->
                                                                                                *mut libc::c_void)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"getpagesize\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn()
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(unixGetpagesize
                                                                                        as
                                                                                        unsafe extern "C" fn()
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"readlink\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          *const libc::c_char,
                                                                                      _:
                                                                                          *mut libc::c_char,
                                                                                      _:
                                                                                          size_t)
                                                                     ->
                                                                         ssize_t>,
                                                          sqlite3_syscall_ptr>(Some(readlink
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 *const libc::c_char,
                                                                                                             _:
                                                                                                                 *mut libc::c_char,
                                                                                                             _:
                                                                                                                 size_t)
                                                                                            ->
                                                                                                ssize_t)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"lstat\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent:
                                  ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                                          *const libc::c_char,
                                                                                      _:
                                                                                          *mut stat)
                                                                     ->
                                                                         libc::c_int>,
                                                          sqlite3_syscall_ptr>(Some(lstat
                                                                                        as
                                                                                        unsafe extern "C" fn(_:
                                                                                                                 *const libc::c_char,
                                                                                                             _:
                                                                                                                 *mut stat)
                                                                                            ->
                                                                                                libc::c_int)),
                              pDefault: None,};
             init
         },
         {
             let mut init =
                 unix_syscall{zName:
                                  b"ioctl\x00" as *const u8 as
                                      *const libc::c_char,
                              pCurrent: None,
                              pDefault: None,};
             init
         }]
    };
unsafe extern "C" fn robustFchown(mut fd: libc::c_int, mut uid: uid_t,
                                  mut gid: gid_t) -> libc::c_int {
    return if ::std::mem::transmute::<sqlite3_syscall_ptr,
                                      Option<unsafe extern "C" fn()
                                                 ->
                                                     uid_t>>(aSyscall[21 as
                                                                          libc::c_int
                                                                          as
                                                                          usize].pCurrent).expect("non-null function pointer")()
                  != 0 {
               0 as libc::c_int
           } else {
               ::std::mem::transmute::<sqlite3_syscall_ptr,
                                       Option<unsafe extern "C" fn(_:
                                                                       libc::c_int,
                                                                   _: uid_t,
                                                                   _: gid_t)
                                                  ->
                                                      libc::c_int>>(aSyscall[20
                                                                                 as
                                                                                 libc::c_int
                                                                                 as
                                                                                 usize].pCurrent).expect("non-null function pointer")(fd,
                                                                                                                                      uid,
                                                                                                                                      gid)
           };
}
unsafe extern "C" fn unixSetSystemCall(mut pNotUsed: *mut sqlite3_vfs,
                                       mut zName: *const libc::c_char,
                                       mut pNewFunc: sqlite3_syscall_ptr)
 -> libc::c_int {
    let mut i: libc::c_uint = 0;
    let mut rc: libc::c_int = 12 as libc::c_int;
    if zName.is_null() {
        rc = 0 as libc::c_int;
        i = 0 as libc::c_int as libc::c_uint;
        while (i as libc::c_ulong) <
                  (::std::mem::size_of::<[unix_syscall; 29]>() as
                       libc::c_ulong).wrapping_div(::std::mem::size_of::<unix_syscall>()
                                                       as libc::c_ulong) {
            if aSyscall[i as usize].pDefault.is_some() {
                aSyscall[i as usize].pCurrent = aSyscall[i as usize].pDefault
            }
            i = i.wrapping_add(1)
        }
    } else {
        i = 0 as libc::c_int as libc::c_uint;
        while (i as libc::c_ulong) <
                  (::std::mem::size_of::<[unix_syscall; 29]>() as
                       libc::c_ulong).wrapping_div(::std::mem::size_of::<unix_syscall>()
                                                       as libc::c_ulong) {
            if strcmp(zName, aSyscall[i as usize].zName) == 0 as libc::c_int {
                if aSyscall[i as usize].pDefault.is_none() {
                    aSyscall[i as usize].pDefault =
                        aSyscall[i as usize].pCurrent
                }
                rc = 0 as libc::c_int;
                if pNewFunc.is_none() {
                    pNewFunc = aSyscall[i as usize].pDefault
                }
                aSyscall[i as usize].pCurrent = pNewFunc;
                break ;
            } else { i = i.wrapping_add(1) }
        }
    }
    return rc;
}
unsafe extern "C" fn unixGetSystemCall(mut pNotUsed: *mut sqlite3_vfs,
                                       mut zName: *const libc::c_char)
 -> sqlite3_syscall_ptr {
    let mut i: libc::c_uint = 0;
    i = 0 as libc::c_int as libc::c_uint;
    while (i as libc::c_ulong) <
              (::std::mem::size_of::<[unix_syscall; 29]>() as
                   libc::c_ulong).wrapping_div(::std::mem::size_of::<unix_syscall>()
                                                   as libc::c_ulong) {
        if strcmp(zName, aSyscall[i as usize].zName) == 0 as libc::c_int {
            return aSyscall[i as usize].pCurrent
        }
        i = i.wrapping_add(1)
    }
    return None;
}
unsafe extern "C" fn unixNextSystemCall(mut p: *mut sqlite3_vfs,
                                        mut zName: *const libc::c_char)
 -> *const libc::c_char {
    let mut i: libc::c_int = -(1 as libc::c_int);
    if !zName.is_null() {
        i = 0 as libc::c_int;
        while i <
                  (::std::mem::size_of::<[unix_syscall; 29]>() as
                       libc::c_ulong).wrapping_div(::std::mem::size_of::<unix_syscall>()
                                                       as libc::c_ulong) as
                      libc::c_int - 1 as libc::c_int {
            if strcmp(zName, aSyscall[i as usize].zName) == 0 as libc::c_int {
                break ;
            }
            i += 1
        }
    }
    i += 1;
    while i <
              (::std::mem::size_of::<[unix_syscall; 29]>() as
                   libc::c_ulong).wrapping_div(::std::mem::size_of::<unix_syscall>()
                                                   as libc::c_ulong) as
                  libc::c_int {
        if aSyscall[i as usize].pCurrent.is_some() {
            return aSyscall[i as usize].zName
        }
        i += 1
    }
    return 0 as *const libc::c_char;
}
unsafe extern "C" fn robust_open(mut z: *const libc::c_char,
                                 mut f: libc::c_int, mut m: mode_t)
 -> libc::c_int {
    let mut fd: libc::c_int = 0;
    let mut m2: mode_t =
        if m != 0 { m } else { 0o644 as libc::c_int as libc::c_uint };
    loop  {
        fd =
            ::std::mem::transmute::<sqlite3_syscall_ptr,
                                    Option<unsafe extern "C" fn(_:
                                                                    *const libc::c_char,
                                                                _:
                                                                    libc::c_int,
                                                                _:
                                                                    libc::c_int)
                                               ->
                                                   libc::c_int>>(aSyscall[0 as
                                                                              libc::c_int
                                                                              as
                                                                              usize].pCurrent).expect("non-null function pointer")(z,
                                                                                                                                   f
                                                                                                                                       |
                                                                                                                                       0o2000000
                                                                                                                                           as
                                                                                                                                           libc::c_int,
                                                                                                                                   m2
                                                                                                                                       as
                                                                                                                                       libc::c_int);
        if fd < 0 as libc::c_int {
            if !(*__errno_location() == 4 as libc::c_int) { break ; }
        } else {
            if fd >= 3 as libc::c_int { break ; }
            ::std::mem::transmute::<sqlite3_syscall_ptr,
                                    Option<unsafe extern "C" fn(_:
                                                                    libc::c_int)
                                               ->
                                                   libc::c_int>>(aSyscall[1 as
                                                                              libc::c_int
                                                                              as
                                                                              usize].pCurrent).expect("non-null function pointer")(fd);
            sqlite3_log(28 as libc::c_int,
                        b"attempt to open \"%s\" as file descriptor %d\x00" as
                            *const u8 as *const libc::c_char, z, fd);
            fd = -(1 as libc::c_int);
            if ::std::mem::transmute::<sqlite3_syscall_ptr,
                                       Option<unsafe extern "C" fn(_:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       libc::c_int)
                                                  ->
                                                      libc::c_int>>(aSyscall[0
                                                                                 as
                                                                                 libc::c_int
                                                                                 as
                                                                                 usize].pCurrent).expect("non-null function pointer")(b"/dev/null\x00"
                                                                                                                                          as
                                                                                                                                          *const u8
                                                                                                                                          as
                                                                                                                                          *const libc::c_char,
                                                                                                                                      0
                                                                                                                                          as
                                                                                                                                          libc::c_int,
                                                                                                                                      m
                                                                                                                                          as
                                                                                                                                          libc::c_int)
                   < 0 as libc::c_int {
                break ;
            }
        }
    }
    if fd >= 0 as libc::c_int {
        if m != 0 as libc::c_int as libc::c_uint {
            let mut statbuf: stat =
                stat{st_dev: 0,
                     st_ino: 0,
                     st_nlink: 0,
                     st_mode: 0,
                     st_uid: 0,
                     st_gid: 0,
                     __pad0: 0,
                     st_rdev: 0,
                     st_size: 0,
                     st_blksize: 0,
                     st_blocks: 0,
                     st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
                     st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
                     st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
                     __glibc_reserved: [0; 3],};
            if ::std::mem::transmute::<sqlite3_syscall_ptr,
                                       Option<unsafe extern "C" fn(_:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut stat)
                                                  ->
                                                      libc::c_int>>(aSyscall[5
                                                                                 as
                                                                                 libc::c_int
                                                                                 as
                                                                                 usize].pCurrent).expect("non-null function pointer")(fd,
                                                                                                                                      &mut statbuf)
                   == 0 as libc::c_int &&
                   statbuf.st_size == 0 as libc::c_int as libc::c_long &&
                   statbuf.st_mode & 0o777 as libc::c_int as libc::c_uint != m
               {
                ::std::mem::transmute::<sqlite3_syscall_ptr,
                                        Option<unsafe extern "C" fn(_:
                                                                        libc::c_int,
                                                                    _: mode_t)
                                                   ->
                                                       libc::c_int>>(aSyscall[14
                                                                                  as
                                                                                  libc::c_int
                                                                                  as
                                                                                  usize].pCurrent).expect("non-null function pointer")(fd,
                                                                                                                                       m);
            }
        }
    }
    return fd;
}
static mut unixBigLock: *mut sqlite3_mutex =
    0 as *const sqlite3_mutex as *mut sqlite3_mutex;
unsafe extern "C" fn unixEnterMutex() { sqlite3_mutex_enter(unixBigLock); }
unsafe extern "C" fn unixLeaveMutex() { sqlite3_mutex_leave(unixBigLock); }
unsafe extern "C" fn robust_ftruncate(mut h: libc::c_int,
                                      mut sz: sqlite3_int64) -> libc::c_int {
    let mut rc: libc::c_int = 0;
    loop  {
        rc =
            ::std::mem::transmute::<sqlite3_syscall_ptr,
                                    Option<unsafe extern "C" fn(_:
                                                                    libc::c_int,
                                                                _: off_t)
                                               ->
                                                   libc::c_int>>(aSyscall[6 as
                                                                              libc::c_int
                                                                              as
                                                                              usize].pCurrent).expect("non-null function pointer")(h,
                                                                                                                                   sz
                                                                                                                                       as
                                                                                                                                       off_t);
        if !(rc < 0 as libc::c_int && *__errno_location() == 4 as libc::c_int)
           {
            break ;
        }
    }
    return rc;
}
unsafe extern "C" fn sqliteErrorFromPosixError(mut posixError: libc::c_int,
                                               mut sqliteIOErr: libc::c_int)
 -> libc::c_int {
    match posixError {
        13 | 11 | 110 | 16 | 4 | 37 => { return 5 as libc::c_int }
        1 => { return 3 as libc::c_int }
        _ => { return sqliteIOErr }
    };
}
static mut inodeList: *mut unixInodeInfo =
    0 as *const unixInodeInfo as *mut unixInodeInfo;
unsafe extern "C" fn unixLogErrorAtLine(mut errcode: libc::c_int,
                                        mut zFunc: *const libc::c_char,
                                        mut zPath: *const libc::c_char,
                                        mut iLine: libc::c_int)
 -> libc::c_int {
    let mut zErr: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut iErrno: libc::c_int = *__errno_location();
    zErr = b"\x00" as *const u8 as *const libc::c_char as *mut libc::c_char;
    if zPath.is_null() { zPath = b"\x00" as *const u8 as *const libc::c_char }
    sqlite3_log(errcode,
                b"os_unix.c:%d: (%d) %s(%s) - %s\x00" as *const u8 as
                    *const libc::c_char, iLine, iErrno, zFunc, zPath, zErr);
    return errcode;
}
unsafe extern "C" fn robust_close(mut pFile: *mut unixFile,
                                  mut h: libc::c_int,
                                  mut lineno: libc::c_int) {
    if ::std::mem::transmute::<sqlite3_syscall_ptr,
                               Option<unsafe extern "C" fn(_: libc::c_int)
                                          ->
                                              libc::c_int>>(aSyscall[1 as
                                                                         libc::c_int
                                                                         as
                                                                         usize].pCurrent).expect("non-null function pointer")(h)
           != 0 {
        unixLogErrorAtLine(10 as libc::c_int |
                               (16 as libc::c_int) << 8 as libc::c_int,
                           b"close\x00" as *const u8 as *const libc::c_char,
                           if !pFile.is_null() {
                               (*pFile).zPath
                           } else { 0 as *const libc::c_char }, lineno);
    };
}
unsafe extern "C" fn storeLastErrno(mut pFile: *mut unixFile,
                                    mut error: libc::c_int) {
    (*pFile).lastErrno = error;
}
unsafe extern "C" fn closePendingFds(mut pFile: *mut unixFile) {
    let mut pInode: *mut unixInodeInfo = (*pFile).pInode;
    let mut p: *mut UnixUnusedFd = 0 as *mut UnixUnusedFd;
    let mut pNext: *mut UnixUnusedFd = 0 as *mut UnixUnusedFd;
    p = (*pInode).pUnused;
    while !p.is_null() {
        pNext = (*p).pNext;
        robust_close(pFile, (*p).fd, 34774 as libc::c_int);
        sqlite3_free(p as *mut libc::c_void);
        p = pNext
    }
    (*pInode).pUnused = 0 as *mut UnixUnusedFd;
}
unsafe extern "C" fn releaseInodeInfo(mut pFile: *mut unixFile) {
    let mut pInode: *mut unixInodeInfo = (*pFile).pInode;
    if !pInode.is_null() {
        (*pInode).nRef -= 1;
        if (*pInode).nRef == 0 as libc::c_int {
            sqlite3_mutex_enter((*pInode).pLockMutex);
            closePendingFds(pFile);
            sqlite3_mutex_leave((*pInode).pLockMutex);
            if !(*pInode).pPrev.is_null() {
                (*(*pInode).pPrev).pNext = (*pInode).pNext
            } else { inodeList = (*pInode).pNext }
            if !(*pInode).pNext.is_null() {
                (*(*pInode).pNext).pPrev = (*pInode).pPrev
            }
            sqlite3_mutex_free((*pInode).pLockMutex);
            sqlite3_free(pInode as *mut libc::c_void);
        }
    };
}
unsafe extern "C" fn findInodeInfo(mut pFile: *mut unixFile,
                                   mut ppInode: *mut *mut unixInodeInfo)
 -> libc::c_int {
    let mut rc: libc::c_int = 0;
    let mut fd: libc::c_int = 0;
    let mut fileId: unixFileId = unixFileId{dev: 0, ino: 0,};
    let mut statbuf: stat =
        stat{st_dev: 0,
             st_ino: 0,
             st_nlink: 0,
             st_mode: 0,
             st_uid: 0,
             st_gid: 0,
             __pad0: 0,
             st_rdev: 0,
             st_size: 0,
             st_blksize: 0,
             st_blocks: 0,
             st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
             __glibc_reserved: [0; 3],};
    let mut pInode: *mut unixInodeInfo = 0 as *mut unixInodeInfo;
    fd = (*pFile).h;
    rc =
        ::std::mem::transmute::<sqlite3_syscall_ptr,
                                Option<unsafe extern "C" fn(_: libc::c_int,
                                                            _: *mut stat)
                                           ->
                                               libc::c_int>>(aSyscall[5 as
                                                                          libc::c_int
                                                                          as
                                                                          usize].pCurrent).expect("non-null function pointer")(fd,
                                                                                                                               &mut statbuf);
    if rc != 0 as libc::c_int {
        storeLastErrno(pFile, *__errno_location());
        return 10 as libc::c_int
    }
    memset(&mut fileId as *mut unixFileId as *mut libc::c_void,
           0 as libc::c_int,
           ::std::mem::size_of::<unixFileId>() as libc::c_ulong);
    fileId.dev = statbuf.st_dev;
    fileId.ino = statbuf.st_ino as u64_0;
    pInode = inodeList;
    while !pInode.is_null() &&
              memcmp(&mut fileId as *mut unixFileId as *const libc::c_void,
                     &mut (*pInode).fileId as *mut unixFileId as
                         *const libc::c_void,
                     ::std::mem::size_of::<unixFileId>() as libc::c_ulong) !=
                  0 {
        pInode = (*pInode).pNext
    }
    if pInode.is_null() {
        pInode =
            sqlite3_malloc64(::std::mem::size_of::<unixInodeInfo>() as
                                 libc::c_ulong as sqlite3_uint64) as
                *mut unixInodeInfo;
        if pInode.is_null() { return 7 as libc::c_int }
        memset(pInode as *mut libc::c_void, 0 as libc::c_int,
               ::std::mem::size_of::<unixInodeInfo>() as libc::c_ulong);
        memcpy(&mut (*pInode).fileId as *mut unixFileId as *mut libc::c_void,
               &mut fileId as *mut unixFileId as *const libc::c_void,
               ::std::mem::size_of::<unixFileId>() as libc::c_ulong);
        if sqlite3Config.bCoreMutex != 0 {
            (*pInode).pLockMutex = sqlite3_mutex_alloc(0 as libc::c_int);
            if (*pInode).pLockMutex.is_null() {
                sqlite3_free(pInode as *mut libc::c_void);
                return 7 as libc::c_int
            }
        }
        (*pInode).nRef = 1 as libc::c_int;
        (*pInode).pNext = inodeList;
        (*pInode).pPrev = 0 as *mut unixInodeInfo;
        if !inodeList.is_null() { (*inodeList).pPrev = pInode }
        inodeList = pInode
    } else { (*pInode).nRef += 1 }
    *ppInode = pInode;
    return 0 as libc::c_int;
}
unsafe extern "C" fn fileHasMoved(mut pFile: *mut unixFile) -> libc::c_int {
    let mut buf: stat =
        stat{st_dev: 0,
             st_ino: 0,
             st_nlink: 0,
             st_mode: 0,
             st_uid: 0,
             st_gid: 0,
             __pad0: 0,
             st_rdev: 0,
             st_size: 0,
             st_blksize: 0,
             st_blocks: 0,
             st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
             __glibc_reserved: [0; 3],};
    return (!(*pFile).pInode.is_null() &&
                (::std::mem::transmute::<sqlite3_syscall_ptr,
                                         Option<unsafe extern "C" fn(_:
                                                                         *const libc::c_char,
                                                                     _:
                                                                         *mut stat)
                                                    ->
                                                        libc::c_int>>(aSyscall[4
                                                                                   as
                                                                                   libc::c_int
                                                                                   as
                                                                                   usize].pCurrent).expect("non-null function pointer")((*pFile).zPath,
                                                                                                                                        &mut buf)
                     != 0 as libc::c_int ||
                     buf.st_ino as u64_0 != (*(*pFile).pInode).fileId.ino)) as
               libc::c_int;
}
unsafe extern "C" fn verifyDbFile(mut pFile: *mut unixFile) {
    let mut buf: stat =
        stat{st_dev: 0,
             st_ino: 0,
             st_nlink: 0,
             st_mode: 0,
             st_uid: 0,
             st_gid: 0,
             __pad0: 0,
             st_rdev: 0,
             st_size: 0,
             st_blksize: 0,
             st_blocks: 0,
             st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
             __glibc_reserved: [0; 3],};
    let mut rc: libc::c_int = 0;
    if (*pFile).ctrlFlags as libc::c_int & 0x80 as libc::c_int != 0 { return }
    rc =
        ::std::mem::transmute::<sqlite3_syscall_ptr,
                                Option<unsafe extern "C" fn(_: libc::c_int,
                                                            _: *mut stat)
                                           ->
                                               libc::c_int>>(aSyscall[5 as
                                                                          libc::c_int
                                                                          as
                                                                          usize].pCurrent).expect("non-null function pointer")((*pFile).h,
                                                                                                                               &mut buf);
    if rc != 0 as libc::c_int {
        sqlite3_log(28 as libc::c_int,
                    b"cannot fstat db file %s\x00" as *const u8 as
                        *const libc::c_char, (*pFile).zPath);
        return
    }
    if buf.st_nlink == 0 as libc::c_int as libc::c_ulong {
        sqlite3_log(28 as libc::c_int,
                    b"file unlinked while open: %s\x00" as *const u8 as
                        *const libc::c_char, (*pFile).zPath);
        return
    }
    if buf.st_nlink > 1 as libc::c_int as libc::c_ulong {
        sqlite3_log(28 as libc::c_int,
                    b"multiple links to file: %s\x00" as *const u8 as
                        *const libc::c_char, (*pFile).zPath);
        return
    }
    if fileHasMoved(pFile) != 0 {
        sqlite3_log(28 as libc::c_int,
                    b"file renamed while open: %s\x00" as *const u8 as
                        *const libc::c_char, (*pFile).zPath);
        return
    };
}
unsafe extern "C" fn unixCheckReservedLock(mut id: *mut sqlite3_file,
                                           mut pResOut: *mut libc::c_int)
 -> libc::c_int {
    let mut rc: libc::c_int = 0 as libc::c_int;
    let mut reserved: libc::c_int = 0 as libc::c_int;
    let mut pFile: *mut unixFile = id as *mut unixFile;
    sqlite3_mutex_enter((*(*pFile).pInode).pLockMutex);
    if (*(*pFile).pInode).eFileLock as libc::c_int > 1 as libc::c_int {
        reserved = 1 as libc::c_int
    }
    if reserved == 0 && (*(*pFile).pInode).bProcessLock == 0 {
        let mut lock: flock =
            flock{l_type: 0, l_whence: 0, l_start: 0, l_len: 0, l_pid: 0,};
        lock.l_whence = 0 as libc::c_int as libc::c_short;
        lock.l_start = (sqlite3PendingByte + 1 as libc::c_int) as __off64_t;
        lock.l_len = 1 as libc::c_int as __off64_t;
        lock.l_type = 1 as libc::c_int as libc::c_short;
        if ::std::mem::transmute::<sqlite3_syscall_ptr,
                                   Option<unsafe extern "C" fn(_: libc::c_int,
                                                               _: libc::c_int,
                                                               _: ...)
                                              ->
                                                  libc::c_int>>(aSyscall[7 as
                                                                             libc::c_int
                                                                             as
                                                                             usize].pCurrent).expect("non-null function pointer")((*pFile).h,
                                                                                                                                  5
                                                                                                                                      as
                                                                                                                                      libc::c_int,
                                                                                                                                  &mut lock
                                                                                                                                      as
                                                                                                                                      *mut flock)
               != 0 {
            rc = 10 as libc::c_int | (14 as libc::c_int) << 8 as libc::c_int;
            storeLastErrno(pFile, *__errno_location());
        } else if lock.l_type as libc::c_int != 2 as libc::c_int {
            reserved = 1 as libc::c_int
        }
    }
    sqlite3_mutex_leave((*(*pFile).pInode).pLockMutex);
    *pResOut = reserved;
    return rc;
}
unsafe extern "C" fn unixFileLock(mut pFile: *mut unixFile,
                                  mut pLock: *mut flock) -> libc::c_int {
    let mut rc: libc::c_int = 0;
    let mut pInode: *mut unixInodeInfo = (*pFile).pInode;
    if (*pFile).ctrlFlags as libc::c_int &
           (0x1 as libc::c_int | 0x2 as libc::c_int) == 0x1 as libc::c_int {
        if (*pInode).bProcessLock as libc::c_int == 0 as libc::c_int {
            let mut lock: flock =
                flock{l_type: 0,
                      l_whence: 0,
                      l_start: 0,
                      l_len: 0,
                      l_pid: 0,};
            lock.l_whence = 0 as libc::c_int as libc::c_short;
            lock.l_start =
                (sqlite3PendingByte + 2 as libc::c_int) as __off64_t;
            lock.l_len = 510 as libc::c_int as __off64_t;
            lock.l_type = 1 as libc::c_int as libc::c_short;
            rc =
                ::std::mem::transmute::<sqlite3_syscall_ptr,
                                        Option<unsafe extern "C" fn(_:
                                                                        libc::c_int,
                                                                    _:
                                                                        libc::c_int,
                                                                    _: ...)
                                                   ->
                                                       libc::c_int>>(aSyscall[7
                                                                                  as
                                                                                  libc::c_int
                                                                                  as
                                                                                  usize].pCurrent).expect("non-null function pointer")((*pFile).h,
                                                                                                                                       6
                                                                                                                                           as
                                                                                                                                           libc::c_int,
                                                                                                                                       &mut lock
                                                                                                                                           as
                                                                                                                                           *mut flock);
            if rc < 0 as libc::c_int { return rc }
            (*pInode).bProcessLock = 1 as libc::c_int as libc::c_uchar;
            (*pInode).nLock += 1
        } else { rc = 0 as libc::c_int }
    } else {
        rc =
            ::std::mem::transmute::<sqlite3_syscall_ptr,
                                    Option<unsafe extern "C" fn(_:
                                                                    libc::c_int,
                                                                _:
                                                                    libc::c_int,
                                                                _: ...)
                                               ->
                                                   libc::c_int>>(aSyscall[7 as
                                                                              libc::c_int
                                                                              as
                                                                              usize].pCurrent).expect("non-null function pointer")((*pFile).h,
                                                                                                                                   6
                                                                                                                                       as
                                                                                                                                       libc::c_int,
                                                                                                                                   pLock)
    }
    return rc;
}
unsafe extern "C" fn unixLock(mut id: *mut sqlite3_file,
                              mut eFileLock: libc::c_int) -> libc::c_int {
    let mut current_block: u64;
    let mut rc: libc::c_int = 0 as libc::c_int;
    let mut pFile: *mut unixFile = id as *mut unixFile;
    let mut pInode: *mut unixInodeInfo = 0 as *mut unixInodeInfo;
    let mut lock: flock =
        flock{l_type: 0, l_whence: 0, l_start: 0, l_len: 0, l_pid: 0,};
    let mut tErrno: libc::c_int = 0 as libc::c_int;
    if (*pFile).eFileLock as libc::c_int >= eFileLock {
        return 0 as libc::c_int
    }
    pInode = (*pFile).pInode;
    sqlite3_mutex_enter((*pInode).pLockMutex);
    if (*pFile).eFileLock as libc::c_int != (*pInode).eFileLock as libc::c_int
           &&
           ((*pInode).eFileLock as libc::c_int >= 3 as libc::c_int ||
                eFileLock > 1 as libc::c_int) {
        rc = 5 as libc::c_int
    } else if eFileLock == 1 as libc::c_int &&
                  ((*pInode).eFileLock as libc::c_int == 1 as libc::c_int ||
                       (*pInode).eFileLock as libc::c_int == 2 as libc::c_int)
     {
        (*pFile).eFileLock = 1 as libc::c_int as libc::c_uchar;
        (*pInode).nShared += 1;
        (*pInode).nLock += 1
    } else {
        lock.l_len = 1 as libc::c_long;
        lock.l_whence = 0 as libc::c_int as libc::c_short;
        if eFileLock == 1 as libc::c_int ||
               eFileLock == 4 as libc::c_int &&
                   ((*pFile).eFileLock as libc::c_int) < 3 as libc::c_int {
            lock.l_type =
                if eFileLock == 1 as libc::c_int {
                    0 as libc::c_int
                } else { 1 as libc::c_int } as libc::c_short;
            lock.l_start = sqlite3PendingByte as __off64_t;
            if unixFileLock(pFile, &mut lock) != 0 {
                tErrno = *__errno_location();
                rc =
                    sqliteErrorFromPosixError(tErrno,
                                              10 as libc::c_int |
                                                  (15 as libc::c_int) <<
                                                      8 as libc::c_int);
                if rc != 5 as libc::c_int { storeLastErrno(pFile, tErrno); }
                current_block = 11641369862243750010;
            } else { current_block = 5494826135382683477; }
        } else { current_block = 5494826135382683477; }
        match current_block {
            11641369862243750010 => { }
            _ => {
                if eFileLock == 1 as libc::c_int {
                    lock.l_start =
                        (sqlite3PendingByte + 2 as libc::c_int) as __off64_t;
                    lock.l_len = 510 as libc::c_int as __off64_t;
                    if unixFileLock(pFile, &mut lock) != 0 {
                        tErrno = *__errno_location();
                        rc =
                            sqliteErrorFromPosixError(tErrno,
                                                      10 as libc::c_int |
                                                          (15 as libc::c_int)
                                                              <<
                                                              8 as
                                                                  libc::c_int)
                    }
                    lock.l_start = sqlite3PendingByte as __off64_t;
                    lock.l_len = 1 as libc::c_long;
                    lock.l_type = 2 as libc::c_int as libc::c_short;
                    if unixFileLock(pFile, &mut lock) != 0 &&
                           rc == 0 as libc::c_int {
                        tErrno = *__errno_location();
                        rc =
                            10 as libc::c_int |
                                (8 as libc::c_int) << 8 as libc::c_int
                    }
                    if rc != 0 {
                        if rc != 5 as libc::c_int {
                            storeLastErrno(pFile, tErrno);
                        }
                        current_block = 11641369862243750010;
                    } else {
                        (*pFile).eFileLock =
                            1 as libc::c_int as libc::c_uchar;
                        (*pInode).nLock += 1;
                        (*pInode).nShared = 1 as libc::c_int;
                        current_block = 9437375157805982253;
                    }
                } else {
                    if eFileLock == 4 as libc::c_int &&
                           (*pInode).nShared > 1 as libc::c_int {
                        rc = 5 as libc::c_int
                    } else {
                        lock.l_type = 1 as libc::c_int as libc::c_short;
                        if eFileLock == 2 as libc::c_int {
                            lock.l_start =
                                (sqlite3PendingByte + 1 as libc::c_int) as
                                    __off64_t;
                            lock.l_len = 1 as libc::c_long
                        } else {
                            lock.l_start =
                                (sqlite3PendingByte + 2 as libc::c_int) as
                                    __off64_t;
                            lock.l_len = 510 as libc::c_int as __off64_t
                        }
                        if unixFileLock(pFile, &mut lock) != 0 {
                            tErrno = *__errno_location();
                            rc =
                                sqliteErrorFromPosixError(tErrno,
                                                          10 as libc::c_int |
                                                              (15 as
                                                                   libc::c_int)
                                                                  <<
                                                                  8 as
                                                                      libc::c_int);
                            if rc != 5 as libc::c_int {
                                storeLastErrno(pFile, tErrno);
                            }
                        }
                    }
                    current_block = 9437375157805982253;
                }
                match current_block {
                    11641369862243750010 => { }
                    _ => {
                        if rc == 0 as libc::c_int {
                            (*pFile).eFileLock = eFileLock as libc::c_uchar;
                            (*pInode).eFileLock = eFileLock as libc::c_uchar
                        } else if eFileLock == 4 as libc::c_int {
                            (*pFile).eFileLock =
                                3 as libc::c_int as libc::c_uchar;
                            (*pInode).eFileLock =
                                3 as libc::c_int as libc::c_uchar
                        }
                    }
                }
            }
        }
    }
    sqlite3_mutex_leave((*pInode).pLockMutex);
    return rc;
}
unsafe extern "C" fn setPendingFd(mut pFile: *mut unixFile) {
    let mut pInode: *mut unixInodeInfo = (*pFile).pInode;
    let mut p: *mut UnixUnusedFd = (*pFile).pPreallocatedUnused;
    (*p).pNext = (*pInode).pUnused;
    (*pInode).pUnused = p;
    (*pFile).h = -(1 as libc::c_int);
    (*pFile).pPreallocatedUnused = 0 as *mut UnixUnusedFd;
}
unsafe extern "C" fn posixUnlock(mut id: *mut sqlite3_file,
                                 mut eFileLock: libc::c_int,
                                 mut handleNFSUnlock: libc::c_int)
 -> libc::c_int {
    let mut current_block: u64;
    let mut pFile: *mut unixFile = id as *mut unixFile;
    let mut pInode: *mut unixInodeInfo = 0 as *mut unixInodeInfo;
    let mut lock: flock =
        flock{l_type: 0, l_whence: 0, l_start: 0, l_len: 0, l_pid: 0,};
    let mut rc: libc::c_int = 0 as libc::c_int;
    if (*pFile).eFileLock as libc::c_int <= eFileLock {
        return 0 as libc::c_int
    }
    pInode = (*pFile).pInode;
    sqlite3_mutex_enter((*pInode).pLockMutex);
    if (*pFile).eFileLock as libc::c_int > 1 as libc::c_int {
        if eFileLock == 1 as libc::c_int {
            lock.l_type = 0 as libc::c_int as libc::c_short;
            lock.l_whence = 0 as libc::c_int as libc::c_short;
            lock.l_start =
                (sqlite3PendingByte + 2 as libc::c_int) as __off64_t;
            lock.l_len = 510 as libc::c_int as __off64_t;
            if unixFileLock(pFile, &mut lock) != 0 {
                rc =
                    10 as libc::c_int |
                        (9 as libc::c_int) << 8 as libc::c_int;
                storeLastErrno(pFile, *__errno_location());
                current_block = 10432635067672664899;
            } else { current_block = 15089075282327824602; }
        } else { current_block = 15089075282327824602; }
        match current_block {
            10432635067672664899 => { }
            _ => {
                lock.l_type = 2 as libc::c_int as libc::c_short;
                lock.l_whence = 0 as libc::c_int as libc::c_short;
                lock.l_start = sqlite3PendingByte as __off64_t;
                lock.l_len = 2 as libc::c_long;
                if unixFileLock(pFile, &mut lock) == 0 as libc::c_int {
                    (*pInode).eFileLock = 1 as libc::c_int as libc::c_uchar;
                    current_block = 15897653523371991391;
                } else {
                    rc =
                        10 as libc::c_int |
                            (8 as libc::c_int) << 8 as libc::c_int;
                    storeLastErrno(pFile, *__errno_location());
                    current_block = 10432635067672664899;
                }
            }
        }
    } else { current_block = 15897653523371991391; }
    match current_block {
        15897653523371991391 => {
            if eFileLock == 0 as libc::c_int {
                (*pInode).nShared -= 1;
                if (*pInode).nShared == 0 as libc::c_int {
                    lock.l_type = 2 as libc::c_int as libc::c_short;
                    lock.l_whence = 0 as libc::c_int as libc::c_short;
                    lock.l_len = 0 as libc::c_long;
                    lock.l_start = lock.l_len;
                    if unixFileLock(pFile, &mut lock) == 0 as libc::c_int {
                        (*pInode).eFileLock =
                            0 as libc::c_int as libc::c_uchar
                    } else {
                        rc =
                            10 as libc::c_int |
                                (8 as libc::c_int) << 8 as libc::c_int;
                        storeLastErrno(pFile, *__errno_location());
                        (*pInode).eFileLock =
                            0 as libc::c_int as libc::c_uchar;
                        (*pFile).eFileLock = 0 as libc::c_int as libc::c_uchar
                    }
                }
                (*pInode).nLock -= 1;
                if (*pInode).nLock == 0 as libc::c_int {
                    closePendingFds(pFile);
                }
            }
        }
        _ => { }
    }
    sqlite3_mutex_leave((*pInode).pLockMutex);
    if rc == 0 as libc::c_int {
        (*pFile).eFileLock = eFileLock as libc::c_uchar
    }
    return rc;
}
unsafe extern "C" fn unixUnlock(mut id: *mut sqlite3_file,
                                mut eFileLock: libc::c_int) -> libc::c_int {
    return posixUnlock(id, eFileLock, 0 as libc::c_int);
}
unsafe extern "C" fn closeUnixFile(mut id: *mut sqlite3_file) -> libc::c_int {
    let mut pFile: *mut unixFile = id as *mut unixFile;
    unixUnmapfile(pFile);
    if (*pFile).h >= 0 as libc::c_int {
        robust_close(pFile, (*pFile).h, 35555 as libc::c_int);
        (*pFile).h = -(1 as libc::c_int)
    }
    sqlite3_free((*pFile).pPreallocatedUnused as *mut libc::c_void);
    memset(pFile as *mut libc::c_void, 0 as libc::c_int,
           ::std::mem::size_of::<unixFile>() as libc::c_ulong);
    return 0 as libc::c_int;
}
unsafe extern "C" fn unixClose(mut id: *mut sqlite3_file) -> libc::c_int {
    let mut rc: libc::c_int = 0 as libc::c_int;
    let mut pFile: *mut unixFile = id as *mut unixFile;
    let mut pInode: *mut unixInodeInfo = (*pFile).pInode;
    verifyDbFile(pFile);
    unixUnlock(id, 0 as libc::c_int);
    unixEnterMutex();
    sqlite3_mutex_enter((*pInode).pLockMutex);
    if (*pInode).nLock != 0 { setPendingFd(pFile); }
    sqlite3_mutex_leave((*pInode).pLockMutex);
    releaseInodeInfo(pFile);
    rc = closeUnixFile(id);
    unixLeaveMutex();
    return rc;
}
unsafe extern "C" fn nolockCheckReservedLock(mut NotUsed: *mut sqlite3_file,
                                             mut pResOut: *mut libc::c_int)
 -> libc::c_int {
    *pResOut = 0 as libc::c_int;
    return 0 as libc::c_int;
}
unsafe extern "C" fn nolockLock(mut NotUsed: *mut sqlite3_file,
                                mut NotUsed2: libc::c_int) -> libc::c_int {
    return 0 as libc::c_int;
}
unsafe extern "C" fn nolockUnlock(mut NotUsed: *mut sqlite3_file,
                                  mut NotUsed2: libc::c_int) -> libc::c_int {
    return 0 as libc::c_int;
}
unsafe extern "C" fn nolockClose(mut id: *mut sqlite3_file) -> libc::c_int {
    return closeUnixFile(id);
}
unsafe extern "C" fn dotlockCheckReservedLock(mut id: *mut sqlite3_file,
                                              mut pResOut: *mut libc::c_int)
 -> libc::c_int {
    let mut rc: libc::c_int = 0 as libc::c_int;
    let mut reserved: libc::c_int = 0 as libc::c_int;
    let mut pFile: *mut unixFile = id as *mut unixFile;
    reserved =
        (::std::mem::transmute::<sqlite3_syscall_ptr,
                                 Option<unsafe extern "C" fn(_:
                                                                 *const libc::c_char,
                                                             _: libc::c_int)
                                            ->
                                                libc::c_int>>(aSyscall[2 as
                                                                           libc::c_int
                                                                           as
                                                                           usize].pCurrent).expect("non-null function pointer")((*pFile).lockingContext
                                                                                                                                    as
                                                                                                                                    *const libc::c_char,
                                                                                                                                0
                                                                                                                                    as
                                                                                                                                    libc::c_int)
             == 0 as libc::c_int) as libc::c_int;
    *pResOut = reserved;
    return rc;
}
unsafe extern "C" fn dotlockLock(mut id: *mut sqlite3_file,
                                 mut eFileLock: libc::c_int) -> libc::c_int {
    let mut pFile: *mut unixFile = id as *mut unixFile;
    let mut zLockFile: *mut libc::c_char =
        (*pFile).lockingContext as *mut libc::c_char;
    let mut rc: libc::c_int = 0 as libc::c_int;
    if (*pFile).eFileLock as libc::c_int > 0 as libc::c_int {
        (*pFile).eFileLock = eFileLock as libc::c_uchar;
        utimes(zLockFile, 0 as *const timeval);
        return 0 as libc::c_int
    }
    rc =
        ::std::mem::transmute::<sqlite3_syscall_ptr,
                                Option<unsafe extern "C" fn(_:
                                                                *const libc::c_char,
                                                            _: mode_t)
                                           ->
                                               libc::c_int>>(aSyscall[18 as
                                                                          libc::c_int
                                                                          as
                                                                          usize].pCurrent).expect("non-null function pointer")(zLockFile,
                                                                                                                               0o777
                                                                                                                                   as
                                                                                                                                   libc::c_int
                                                                                                                                   as
                                                                                                                                   mode_t);
    if rc < 0 as libc::c_int {
        let mut tErrno: libc::c_int = *__errno_location();
        if 17 as libc::c_int == tErrno {
            rc = 5 as libc::c_int
        } else {
            rc =
                sqliteErrorFromPosixError(tErrno,
                                          10 as libc::c_int |
                                              (15 as libc::c_int) <<
                                                  8 as libc::c_int);
            if rc != 5 as libc::c_int { storeLastErrno(pFile, tErrno); }
        }
        return rc
    }
    (*pFile).eFileLock = eFileLock as libc::c_uchar;
    return rc;
}
unsafe extern "C" fn dotlockUnlock(mut id: *mut sqlite3_file,
                                   mut eFileLock: libc::c_int)
 -> libc::c_int {
    let mut pFile: *mut unixFile = id as *mut unixFile;
    let mut zLockFile: *mut libc::c_char =
        (*pFile).lockingContext as *mut libc::c_char;
    let mut rc: libc::c_int = 0;
    if (*pFile).eFileLock as libc::c_int == eFileLock {
        return 0 as libc::c_int
    }
    if eFileLock == 1 as libc::c_int {
        (*pFile).eFileLock = 1 as libc::c_int as libc::c_uchar;
        return 0 as libc::c_int
    }
    rc =
        ::std::mem::transmute::<sqlite3_syscall_ptr,
                                Option<unsafe extern "C" fn(_:
                                                                *const libc::c_char)
                                           ->
                                               libc::c_int>>(aSyscall[19 as
                                                                          libc::c_int
                                                                          as
                                                                          usize].pCurrent).expect("non-null function pointer")(zLockFile);
    if rc < 0 as libc::c_int {
        let mut tErrno: libc::c_int = *__errno_location();
        if tErrno == 2 as libc::c_int {
            rc = 0 as libc::c_int
        } else {
            rc = 10 as libc::c_int | (8 as libc::c_int) << 8 as libc::c_int;
            storeLastErrno(pFile, tErrno);
        }
        return rc
    }
    (*pFile).eFileLock = 0 as libc::c_int as libc::c_uchar;
    return 0 as libc::c_int;
}
unsafe extern "C" fn dotlockClose(mut id: *mut sqlite3_file) -> libc::c_int {
    let mut pFile: *mut unixFile = id as *mut unixFile;
    dotlockUnlock(id, 0 as libc::c_int);
    sqlite3_free((*pFile).lockingContext);
    return closeUnixFile(id);
}
unsafe extern "C" fn seekAndRead(mut id: *mut unixFile,
                                 mut offset: sqlite3_int64,
                                 mut pBuf: *mut libc::c_void,
                                 mut cnt: libc::c_int) -> libc::c_int {
    let mut got: libc::c_int = 0;
    let mut prior: libc::c_int = 0 as libc::c_int;
    let mut newOffset: i64_0 = 0;
    loop  {
        newOffset =
            lseek((*id).h, offset as __off64_t, 0 as libc::c_int) as i64_0;
        if newOffset < 0 as libc::c_int as libc::c_longlong {
            storeLastErrno(id, *__errno_location());
            return -(1 as libc::c_int)
        }
        got =
            ::std::mem::transmute::<sqlite3_syscall_ptr,
                                    Option<unsafe extern "C" fn(_:
                                                                    libc::c_int,
                                                                _:
                                                                    *mut libc::c_void,
                                                                _: size_t)
                                               ->
                                                   ssize_t>>(aSyscall[8 as
                                                                          libc::c_int
                                                                          as
                                                                          usize].pCurrent).expect("non-null function pointer")((*id).h,
                                                                                                                               pBuf,
                                                                                                                               cnt
                                                                                                                                   as
                                                                                                                                   size_t)
                as libc::c_int;
        if got == cnt { break ; }
        if got < 0 as libc::c_int {
            if *__errno_location() == 4 as libc::c_int {
                got = 1 as libc::c_int
            } else {
                prior = 0 as libc::c_int;
                storeLastErrno(id, *__errno_location());
                break ;
            }
        } else if got > 0 as libc::c_int {
            cnt -= got;
            offset += got as libc::c_longlong;
            prior += got;
            pBuf =
                (pBuf as *mut libc::c_char).offset(got as isize) as
                    *mut libc::c_void
        }
        if !(got > 0 as libc::c_int) { break ; }
    }
    return got + prior;
}
unsafe extern "C" fn unixRead(mut id: *mut sqlite3_file,
                              mut pBuf: *mut libc::c_void,
                              mut amt: libc::c_int, mut offset: sqlite3_int64)
 -> libc::c_int {
    let mut pFile: *mut unixFile = id as *mut unixFile;
    let mut got: libc::c_int = 0;
    if offset < (*pFile).mmapSize {
        if offset + amt as libc::c_longlong <= (*pFile).mmapSize {
            memcpy(pBuf,
                   &mut *((*pFile).pMapRegion as
                              *mut u8_0).offset(offset as isize) as *mut u8_0
                       as *const libc::c_void, amt as libc::c_ulong);
            return 0 as libc::c_int
        } else {
            let mut nCopy: libc::c_int =
                ((*pFile).mmapSize - offset) as libc::c_int;
            memcpy(pBuf,
                   &mut *((*pFile).pMapRegion as
                              *mut u8_0).offset(offset as isize) as *mut u8_0
                       as *const libc::c_void, nCopy as libc::c_ulong);
            pBuf =
                &mut *(pBuf as *mut u8_0).offset(nCopy as isize) as *mut u8_0
                    as *mut libc::c_void;
            amt -= nCopy;
            offset += nCopy as libc::c_longlong
        }
    }
    got = seekAndRead(pFile, offset, pBuf, amt);
    if got == amt {
        return 0 as libc::c_int
    } else if got < 0 as libc::c_int {
        return 10 as libc::c_int | (1 as libc::c_int) << 8 as libc::c_int
    } else {
        storeLastErrno(pFile, 0 as libc::c_int);
        memset(&mut *(pBuf as *mut libc::c_char).offset(got as isize) as
                   *mut libc::c_char as *mut libc::c_void, 0 as libc::c_int,
               (amt - got) as libc::c_ulong);
        return 10 as libc::c_int | (2 as libc::c_int) << 8 as libc::c_int
    };
}
unsafe extern "C" fn seekAndWriteFd(mut fd: libc::c_int, mut iOff: i64_0,
                                    mut pBuf: *const libc::c_void,
                                    mut nBuf: libc::c_int,
                                    mut piErrno: *mut libc::c_int)
 -> libc::c_int {
    let mut rc: libc::c_int = 0 as libc::c_int;
    nBuf &= 0x1ffff as libc::c_int;
    loop  {
        let mut iSeek: i64_0 =
            lseek(fd, iOff as __off64_t, 0 as libc::c_int) as i64_0;
        if iSeek < 0 as libc::c_int as libc::c_longlong {
            rc = -(1 as libc::c_int);
            break ;
        } else {
            rc =
                ::std::mem::transmute::<sqlite3_syscall_ptr,
                                        Option<unsafe extern "C" fn(_:
                                                                        libc::c_int,
                                                                    _:
                                                                        *const libc::c_void,
                                                                    _: size_t)
                                                   ->
                                                       ssize_t>>(aSyscall[11
                                                                              as
                                                                              libc::c_int
                                                                              as
                                                                              usize].pCurrent).expect("non-null function pointer")(fd,
                                                                                                                                   pBuf,
                                                                                                                                   nBuf
                                                                                                                                       as
                                                                                                                                       size_t)
                    as libc::c_int;
            if !(rc < 0 as libc::c_int &&
                     *__errno_location() == 4 as libc::c_int) {
                break ;
            }
        }
    }
    if rc < 0 as libc::c_int { *piErrno = *__errno_location() }
    return rc;
}
unsafe extern "C" fn seekAndWrite(mut id: *mut unixFile, mut offset: i64_0,
                                  mut pBuf: *const libc::c_void,
                                  mut cnt: libc::c_int) -> libc::c_int {
    return seekAndWriteFd((*id).h, offset, pBuf, cnt, &mut (*id).lastErrno);
}
unsafe extern "C" fn unixWrite(mut id: *mut sqlite3_file,
                               mut pBuf: *const libc::c_void,
                               mut amt: libc::c_int,
                               mut offset: sqlite3_int64) -> libc::c_int {
    let mut pFile: *mut unixFile = id as *mut unixFile;
    let mut wrote: libc::c_int = 0 as libc::c_int;
    loop  {
        wrote = seekAndWrite(pFile, offset, pBuf, amt);
        if !(wrote < amt && wrote > 0 as libc::c_int) { break ; }
        amt -= wrote;
        offset += wrote as libc::c_longlong;
        pBuf =
            &mut *(pBuf as *mut libc::c_char).offset(wrote as isize) as
                *mut libc::c_char as *const libc::c_void
    }
    if amt > wrote {
        if wrote < 0 as libc::c_int && (*pFile).lastErrno != 28 as libc::c_int
           {
            return 10 as libc::c_int | (3 as libc::c_int) << 8 as libc::c_int
        } else {
            storeLastErrno(pFile, 0 as libc::c_int);
            return 13 as libc::c_int
        }
    }
    return 0 as libc::c_int;
}
unsafe extern "C" fn full_fsync(mut fd: libc::c_int,
                                mut fullSync: libc::c_int,
                                mut dataOnly: libc::c_int) -> libc::c_int {
    let mut rc: libc::c_int = 0;
    rc = fsync(fd);
    if 0 as libc::c_int != 0 && rc != -(1 as libc::c_int) {
        rc = 0 as libc::c_int
    }
    return rc;
}
unsafe extern "C" fn openDirectory(mut zFilename: *const libc::c_char,
                                   mut pFd: *mut libc::c_int) -> libc::c_int {
    let mut ii: libc::c_int = 0;
    let mut fd: libc::c_int = -(1 as libc::c_int);
    let mut zDirname: [libc::c_char; 513] = [0; 513];
    sqlite3_snprintf(512 as libc::c_int, zDirname.as_mut_ptr(),
                     b"%s\x00" as *const u8 as *const libc::c_char,
                     zFilename);
    ii = strlen(zDirname.as_mut_ptr()) as libc::c_int;
    while ii > 0 as libc::c_int &&
              zDirname[ii as usize] as libc::c_int != '/' as i32 {
        ii -= 1
    }
    if ii > 0 as libc::c_int {
        zDirname[ii as usize] = '\u{0}' as i32 as libc::c_char
    } else {
        if zDirname[0 as libc::c_int as usize] as libc::c_int != '/' as i32 {
            zDirname[0 as libc::c_int as usize] = '.' as i32 as libc::c_char
        }
        zDirname[1 as libc::c_int as usize] = 0 as libc::c_int as libc::c_char
    }
    fd =
        robust_open(zDirname.as_mut_ptr(),
                    0 as libc::c_int | 0 as libc::c_int,
                    0 as libc::c_int as mode_t);
    (fd) >= 0 as libc::c_int;
    *pFd = fd;
    if fd >= 0 as libc::c_int { return 0 as libc::c_int }
    return unixLogErrorAtLine(sqlite3CantopenError(37158 as libc::c_int),
                              b"openDirectory\x00" as *const u8 as
                                  *const libc::c_char, zDirname.as_mut_ptr(),
                              37158 as libc::c_int);
}
unsafe extern "C" fn unixSync(mut id: *mut sqlite3_file,
                              mut flags: libc::c_int) -> libc::c_int {
    let mut rc: libc::c_int = 0;
    let mut pFile: *mut unixFile = id as *mut unixFile;
    let mut isDataOnly: libc::c_int = flags & 0x10 as libc::c_int;
    let mut isFullsync: libc::c_int =
        (flags & 0xf as libc::c_int == 0x3 as libc::c_int) as libc::c_int;
    rc = full_fsync((*pFile).h, isFullsync, isDataOnly);
    if rc != 0 {
        storeLastErrno(pFile, *__errno_location());
        return unixLogErrorAtLine(10 as libc::c_int |
                                      (4 as libc::c_int) << 8 as libc::c_int,
                                  b"full_fsync\x00" as *const u8 as
                                      *const libc::c_char, (*pFile).zPath,
                                  37199 as libc::c_int)
    }
    if (*pFile).ctrlFlags as libc::c_int & 0x8 as libc::c_int != 0 {
        let mut dirfd: libc::c_int = 0;
        rc =
            ::std::mem::transmute::<sqlite3_syscall_ptr,
                                    Option<unsafe extern "C" fn(_:
                                                                    *const libc::c_char,
                                                                _:
                                                                    *mut libc::c_int)
                                               ->
                                                   libc::c_int>>(aSyscall[17
                                                                              as
                                                                              libc::c_int
                                                                              as
                                                                              usize].pCurrent).expect("non-null function pointer")((*pFile).zPath,
                                                                                                                                   &mut dirfd);
        if rc == 0 as libc::c_int {
            full_fsync(dirfd, 0 as libc::c_int, 0 as libc::c_int);
            robust_close(pFile, dirfd, 37213 as libc::c_int);
        } else { rc = 0 as libc::c_int }
        (*pFile).ctrlFlags =
            ((*pFile).ctrlFlags as libc::c_int & !(0x8 as libc::c_int)) as
                libc::c_ushort
    }
    return rc;
}
unsafe extern "C" fn unixTruncate(mut id: *mut sqlite3_file, mut nByte: i64_0)
 -> libc::c_int {
    let mut pFile: *mut unixFile = id as *mut unixFile;
    let mut rc: libc::c_int = 0;
    if (*pFile).szChunk > 0 as libc::c_int {
        nByte =
            (nByte + (*pFile).szChunk as libc::c_longlong -
                 1 as libc::c_int as libc::c_longlong) /
                (*pFile).szChunk as libc::c_longlong *
                (*pFile).szChunk as libc::c_longlong
    }
    rc = robust_ftruncate((*pFile).h, nByte);
    if rc != 0 {
        storeLastErrno(pFile, *__errno_location());
        return unixLogErrorAtLine(10 as libc::c_int |
                                      (6 as libc::c_int) << 8 as libc::c_int,
                                  b"ftruncate\x00" as *const u8 as
                                      *const libc::c_char, (*pFile).zPath,
                                  37244 as libc::c_int)
    } else {
        if nByte < (*pFile).mmapSize { (*pFile).mmapSize = nByte }
        return 0 as libc::c_int
    };
}
unsafe extern "C" fn unixFileSize(mut id: *mut sqlite3_file,
                                  mut pSize: *mut i64_0) -> libc::c_int {
    let mut rc: libc::c_int = 0;
    let mut buf: stat =
        stat{st_dev: 0,
             st_ino: 0,
             st_nlink: 0,
             st_mode: 0,
             st_uid: 0,
             st_gid: 0,
             __pad0: 0,
             st_rdev: 0,
             st_size: 0,
             st_blksize: 0,
             st_blocks: 0,
             st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
             __glibc_reserved: [0; 3],};
    rc =
        ::std::mem::transmute::<sqlite3_syscall_ptr,
                                Option<unsafe extern "C" fn(_: libc::c_int,
                                                            _: *mut stat)
                                           ->
                                               libc::c_int>>(aSyscall[5 as
                                                                          libc::c_int
                                                                          as
                                                                          usize].pCurrent).expect("non-null function pointer")((*(id
                                                                                                                                      as
                                                                                                                                      *mut unixFile)).h,
                                                                                                                               &mut buf);
    if rc != 0 as libc::c_int {
        storeLastErrno(id as *mut unixFile, *__errno_location());
        return 10 as libc::c_int | (7 as libc::c_int) << 8 as libc::c_int
    }
    *pSize = buf.st_size as i64_0;
    if *pSize == 1 as libc::c_int as libc::c_longlong {
        *pSize = 0 as libc::c_int as i64_0
    }
    return 0 as libc::c_int;
}
unsafe extern "C" fn fcntlSizeHint(mut pFile: *mut unixFile, mut nByte: i64_0)
 -> libc::c_int {
    if (*pFile).szChunk > 0 as libc::c_int {
        let mut nSize: i64_0 = 0;
        let mut buf: stat =
            stat{st_dev: 0,
                 st_ino: 0,
                 st_nlink: 0,
                 st_mode: 0,
                 st_uid: 0,
                 st_gid: 0,
                 __pad0: 0,
                 st_rdev: 0,
                 st_size: 0,
                 st_blksize: 0,
                 st_blocks: 0,
                 st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
                 st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
                 st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
                 __glibc_reserved: [0; 3],};
        if ::std::mem::transmute::<sqlite3_syscall_ptr,
                                   Option<unsafe extern "C" fn(_: libc::c_int,
                                                               _: *mut stat)
                                              ->
                                                  libc::c_int>>(aSyscall[5 as
                                                                             libc::c_int
                                                                             as
                                                                             usize].pCurrent).expect("non-null function pointer")((*pFile).h,
                                                                                                                                  &mut buf)
               != 0 {
            return 10 as libc::c_int | (7 as libc::c_int) << 8 as libc::c_int
        }
        nSize =
            (nByte + (*pFile).szChunk as libc::c_longlong -
                 1 as libc::c_int as libc::c_longlong) /
                (*pFile).szChunk as libc::c_longlong *
                (*pFile).szChunk as libc::c_longlong;
        if nSize > buf.st_size as i64_0 {
            let mut nBlk: libc::c_int = buf.st_blksize as libc::c_int;
            let mut nWrite: libc::c_int = 0 as libc::c_int;
            let mut iWrite: i64_0 = 0;
            iWrite =
                (buf.st_size / nBlk as libc::c_long * nBlk as libc::c_long +
                     nBlk as libc::c_long - 1 as libc::c_int as libc::c_long)
                    as i64_0;
            while iWrite <
                      nSize + nBlk as libc::c_longlong -
                          1 as libc::c_int as libc::c_longlong {
                if iWrite >= nSize {
                    iWrite = nSize - 1 as libc::c_int as libc::c_longlong
                }
                nWrite =
                    seekAndWrite(pFile, iWrite,
                                 b"\x00" as *const u8 as *const libc::c_char
                                     as *const libc::c_void,
                                 1 as libc::c_int);
                if nWrite != 1 as libc::c_int {
                    return 10 as libc::c_int |
                               (3 as libc::c_int) << 8 as libc::c_int
                }
                iWrite += nBlk as libc::c_longlong
            }
        }
    }
    if (*pFile).mmapSizeMax > 0 as libc::c_int as libc::c_longlong &&
           nByte > (*pFile).mmapSize {
        let mut rc: libc::c_int = 0;
        if (*pFile).szChunk <= 0 as libc::c_int {
            if robust_ftruncate((*pFile).h, nByte) != 0 {
                storeLastErrno(pFile, *__errno_location());
                return unixLogErrorAtLine(10 as libc::c_int |
                                              (6 as libc::c_int) <<
                                                  8 as libc::c_int,
                                          b"ftruncate\x00" as *const u8 as
                                              *const libc::c_char,
                                          (*pFile).zPath,
                                          37365 as libc::c_int)
            }
        }
        rc = unixMapfile(pFile, nByte);
        return rc
    }
    return 0 as libc::c_int;
}
unsafe extern "C" fn unixModeBit(mut pFile: *mut unixFile,
                                 mut mask: libc::c_uchar,
                                 mut pArg: *mut libc::c_int) {
    if *pArg < 0 as libc::c_int {
        *pArg =
            ((*pFile).ctrlFlags as libc::c_int & mask as libc::c_int !=
                 0 as libc::c_int) as libc::c_int
    } else if *pArg == 0 as libc::c_int {
        (*pFile).ctrlFlags =
            ((*pFile).ctrlFlags as libc::c_int & !(mask as libc::c_int)) as
                libc::c_ushort
    } else {
        (*pFile).ctrlFlags =
            ((*pFile).ctrlFlags as libc::c_int | mask as libc::c_int) as
                libc::c_ushort
    };
}
unsafe extern "C" fn unixFileControl(mut id: *mut sqlite3_file,
                                     mut op: libc::c_int,
                                     mut pArg: *mut libc::c_void)
 -> libc::c_int {
    let mut pFile: *mut unixFile = id as *mut unixFile;
    match op {
        1 => {
            *(pArg as *mut libc::c_int) = (*pFile).eFileLock as libc::c_int;
            return 0 as libc::c_int
        }
        4 => {
            *(pArg as *mut libc::c_int) = (*pFile).lastErrno;
            return 0 as libc::c_int
        }
        6 => {
            (*pFile).szChunk = *(pArg as *mut libc::c_int);
            return 0 as libc::c_int
        }
        5 => {
            let mut rc: libc::c_int = 0;
            rc = fcntlSizeHint(pFile, *(pArg as *mut i64_0));
            return rc
        }
        10 => {
            unixModeBit(pFile, 0x4 as libc::c_int as libc::c_uchar,
                        pArg as *mut libc::c_int);
            return 0 as libc::c_int
        }
        13 => {
            unixModeBit(pFile, 0x10 as libc::c_int as libc::c_uchar,
                        pArg as *mut libc::c_int);
            return 0 as libc::c_int
        }
        12 => {
            let ref mut fresh98 = *(pArg as *mut *mut libc::c_char);
            *fresh98 =
                sqlite3_mprintf(b"%s\x00" as *const u8 as *const libc::c_char,
                                (*(*pFile).pVfs).zName);
            return 0 as libc::c_int
        }
        16 => {
            let mut zTFile: *mut libc::c_char =
                sqlite3_malloc64((*(*pFile).pVfs).mxPathname as
                                     sqlite3_uint64) as *mut libc::c_char;
            if !zTFile.is_null() {
                unixGetTempname((*(*pFile).pVfs).mxPathname, zTFile);
                let ref mut fresh99 = *(pArg as *mut *mut libc::c_char);
                *fresh99 = zTFile
            }
            return 0 as libc::c_int
        }
        20 => {
            *(pArg as *mut libc::c_int) = fileHasMoved(pFile);
            return 0 as libc::c_int
        }
        18 => {
            let mut newLimit: i64_0 = *(pArg as *mut i64_0);
            let mut rc_0: libc::c_int = 0 as libc::c_int;
            if newLimit > sqlite3Config.mxMmap {
                newLimit = sqlite3Config.mxMmap
            }
            if newLimit > 0 as libc::c_int as libc::c_longlong &&
                   (::std::mem::size_of::<size_t>() as libc::c_ulong) <
                       8 as libc::c_int as libc::c_ulong {
                newLimit =
                    newLimit & 0x7fffffff as libc::c_int as libc::c_longlong
            }
            *(pArg as *mut i64_0) = (*pFile).mmapSizeMax;
            if newLimit >= 0 as libc::c_int as libc::c_longlong &&
                   newLimit != (*pFile).mmapSizeMax &&
                   (*pFile).nFetchOut == 0 as libc::c_int {
                (*pFile).mmapSizeMax = newLimit;
                if (*pFile).mmapSize > 0 as libc::c_int as libc::c_longlong {
                    unixUnmapfile(pFile);
                    rc_0 = unixMapfile(pFile, -(1 as libc::c_int) as i64_0)
                }
            }
            return rc_0
        }
        _ => { }
    }
    return 12 as libc::c_int;
}
unsafe extern "C" fn setDeviceCharacteristics(mut pFd: *mut unixFile) {
    if (*pFd).sectorSize == 0 as libc::c_int {
        if (*pFd).ctrlFlags as libc::c_int & 0x10 as libc::c_int != 0 {
            (*pFd).deviceCharacteristics |= 0x1000 as libc::c_int
        }
        (*pFd).sectorSize = 4096 as libc::c_int
    };
}
unsafe extern "C" fn unixSectorSize(mut id: *mut sqlite3_file)
 -> libc::c_int {
    let mut pFd: *mut unixFile = id as *mut unixFile;
    setDeviceCharacteristics(pFd);
    return (*pFd).sectorSize;
}
unsafe extern "C" fn unixDeviceCharacteristics(mut id: *mut sqlite3_file)
 -> libc::c_int {
    let mut pFd: *mut unixFile = id as *mut unixFile;
    setDeviceCharacteristics(pFd);
    return (*pFd).deviceCharacteristics;
}
unsafe extern "C" fn unixGetpagesize() -> libc::c_int {
    return getpagesize();
}
unsafe extern "C" fn unixShmSystemLock(mut pFile: *mut unixFile,
                                       mut lockType: libc::c_int,
                                       mut ofst: libc::c_int,
                                       mut n: libc::c_int) -> libc::c_int {
    let mut pShmNode: *mut unixShmNode = 0 as *mut unixShmNode;
    let mut f: flock =
        flock{l_type: 0, l_whence: 0, l_start: 0, l_len: 0, l_pid: 0,};
    let mut rc: libc::c_int = 0 as libc::c_int;
    pShmNode = (*(*pFile).pInode).pShmNode;
    if (*pShmNode).hShm >= 0 as libc::c_int {
        let mut res: libc::c_int = 0;
        f.l_type = lockType as libc::c_short;
        f.l_whence = 0 as libc::c_int as libc::c_short;
        f.l_start = ofst as __off64_t;
        f.l_len = n as __off64_t;
        res =
            ::std::mem::transmute::<sqlite3_syscall_ptr,
                                    Option<unsafe extern "C" fn(_:
                                                                    libc::c_int,
                                                                _:
                                                                    libc::c_int,
                                                                _: ...)
                                               ->
                                                   libc::c_int>>(aSyscall[7 as
                                                                              libc::c_int
                                                                              as
                                                                              usize].pCurrent).expect("non-null function pointer")((*pShmNode).hShm,
                                                                                                                                   6
                                                                                                                                       as
                                                                                                                                       libc::c_int,
                                                                                                                                   &mut f
                                                                                                                                       as
                                                                                                                                       *mut flock);
        if res == -(1 as libc::c_int) { rc = 5 as libc::c_int }
    }
    return rc;
}
unsafe extern "C" fn unixShmRegionPerMap() -> libc::c_int {
    let mut shmsz: libc::c_int = 32 as libc::c_int * 1024 as libc::c_int;
    let mut pgsz: libc::c_int =
        ::std::mem::transmute::<sqlite3_syscall_ptr,
                                Option<unsafe extern "C" fn()
                                           ->
                                               libc::c_int>>(aSyscall[25 as
                                                                          libc::c_int
                                                                          as
                                                                          usize].pCurrent).expect("non-null function pointer")();
    if pgsz < shmsz { return 1 as libc::c_int }
    return pgsz / shmsz;
}
unsafe extern "C" fn unixShmPurge(mut pFd: *mut unixFile) {
    let mut p: *mut unixShmNode = (*(*pFd).pInode).pShmNode;
    if !p.is_null() && (*p).nRef == 0 as libc::c_int {
        let mut nShmPerMap: libc::c_int = unixShmRegionPerMap();
        let mut i: libc::c_int = 0;
        sqlite3_mutex_free((*p).pShmMutex);
        i = 0 as libc::c_int;
        while i < (*p).nRegion as libc::c_int {
            if (*p).hShm >= 0 as libc::c_int {
                ::std::mem::transmute::<sqlite3_syscall_ptr,
                                        Option<unsafe extern "C" fn(_:
                                                                        *mut libc::c_void,
                                                                    _: size_t)
                                                   ->
                                                       libc::c_int>>(aSyscall[23
                                                                                  as
                                                                                  libc::c_int
                                                                                  as
                                                                                  usize].pCurrent).expect("non-null function pointer")(*(*p).apRegion.offset(i
                                                                                                                                                                 as
                                                                                                                                                                 isize)
                                                                                                                                           as
                                                                                                                                           *mut libc::c_void,
                                                                                                                                       (*p).szRegion
                                                                                                                                           as
                                                                                                                                           size_t);
            } else {
                sqlite3_free(*(*p).apRegion.offset(i as isize) as
                                 *mut libc::c_void);
            }
            i += nShmPerMap
        }
        sqlite3_free((*p).apRegion as *mut libc::c_void);
        if (*p).hShm >= 0 as libc::c_int {
            robust_close(pFd, (*p).hShm, 37877 as libc::c_int);
            (*p).hShm = -(1 as libc::c_int)
        }
        (*(*p).pInode).pShmNode = 0 as *mut unixShmNode;
        sqlite3_free(p as *mut libc::c_void);
    };
}
unsafe extern "C" fn unixLockSharedMemory(mut pDbFd: *mut unixFile,
                                          mut pShmNode: *mut unixShmNode)
 -> libc::c_int {
    let mut lock: flock =
        flock{l_type: 0, l_whence: 0, l_start: 0, l_len: 0, l_pid: 0,};
    let mut rc: libc::c_int = 0 as libc::c_int;
    lock.l_whence = 0 as libc::c_int as libc::c_short;
    lock.l_start =
        ((22 as libc::c_int + 8 as libc::c_int) * 4 as libc::c_int +
             8 as libc::c_int) as __off64_t;
    lock.l_len = 1 as libc::c_int as __off64_t;
    lock.l_type = 1 as libc::c_int as libc::c_short;
    if ::std::mem::transmute::<sqlite3_syscall_ptr,
                               Option<unsafe extern "C" fn(_: libc::c_int,
                                                           _: libc::c_int,
                                                           _: ...)
                                          ->
                                              libc::c_int>>(aSyscall[7 as
                                                                         libc::c_int
                                                                         as
                                                                         usize].pCurrent).expect("non-null function pointer")((*pShmNode).hShm,
                                                                                                                              5
                                                                                                                                  as
                                                                                                                                  libc::c_int,
                                                                                                                              &mut lock
                                                                                                                                  as
                                                                                                                                  *mut flock)
           != 0 as libc::c_int {
        rc = 10 as libc::c_int | (15 as libc::c_int) << 8 as libc::c_int
    } else if lock.l_type as libc::c_int == 2 as libc::c_int {
        if (*pShmNode).isReadonly != 0 {
            (*pShmNode).isUnlocked = 1 as libc::c_int as u8_0;
            rc = 8 as libc::c_int | (5 as libc::c_int) << 8 as libc::c_int
        } else {
            rc =
                unixShmSystemLock(pDbFd, 1 as libc::c_int,
                                  (22 as libc::c_int + 8 as libc::c_int) *
                                      4 as libc::c_int + 8 as libc::c_int,
                                  1 as libc::c_int);
            if rc == 0 as libc::c_int &&
                   robust_ftruncate((*pShmNode).hShm,
                                    3 as libc::c_int as sqlite3_int64) != 0 {
                rc =
                    unixLogErrorAtLine(10 as libc::c_int |
                                           (18 as libc::c_int) <<
                                               8 as libc::c_int,
                                       b"ftruncate\x00" as *const u8 as
                                           *const libc::c_char,
                                       (*pShmNode).zFilename,
                                       37934 as libc::c_int)
            }
        }
    } else if lock.l_type as libc::c_int == 1 as libc::c_int {
        rc = 5 as libc::c_int
    }
    if rc == 0 as libc::c_int {
        rc =
            unixShmSystemLock(pDbFd, 0 as libc::c_int,
                              (22 as libc::c_int + 8 as libc::c_int) *
                                  4 as libc::c_int + 8 as libc::c_int,
                              1 as libc::c_int)
    }
    return rc;
}
unsafe extern "C" fn unixOpenSharedMemory(mut pDbFd: *mut unixFile)
 -> libc::c_int {
    let mut current_block: u64;
    let mut p: *mut unixShm = 0 as *mut unixShm;
    let mut pShmNode: *mut unixShmNode = 0 as *mut unixShmNode;
    let mut rc: libc::c_int = 0 as libc::c_int;
    let mut pInode: *mut unixInodeInfo = 0 as *mut unixInodeInfo;
    let mut zShm: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut nShmFilename: libc::c_int = 0;
    p =
        sqlite3_malloc64(::std::mem::size_of::<unixShm>() as libc::c_ulong as
                             sqlite3_uint64) as *mut unixShm;
    if p.is_null() { return 7 as libc::c_int }
    memset(p as *mut libc::c_void, 0 as libc::c_int,
           ::std::mem::size_of::<unixShm>() as libc::c_ulong);
    unixEnterMutex();
    pInode = (*pDbFd).pInode;
    pShmNode = (*pInode).pShmNode;
    if pShmNode.is_null() {
        let mut sStat: stat =
            stat{st_dev: 0,
                 st_ino: 0,
                 st_nlink: 0,
                 st_mode: 0,
                 st_uid: 0,
                 st_gid: 0,
                 __pad0: 0,
                 st_rdev: 0,
                 st_size: 0,
                 st_blksize: 0,
                 st_blocks: 0,
                 st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
                 st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
                 st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
                 __glibc_reserved: [0; 3],};
        let mut zBasePath: *const libc::c_char = (*pDbFd).zPath;
        if ::std::mem::transmute::<sqlite3_syscall_ptr,
                                   Option<unsafe extern "C" fn(_: libc::c_int,
                                                               _: *mut stat)
                                              ->
                                                  libc::c_int>>(aSyscall[5 as
                                                                             libc::c_int
                                                                             as
                                                                             usize].pCurrent).expect("non-null function pointer")((*pDbFd).h,
                                                                                                                                  &mut sStat)
               != 0 {
            rc = 10 as libc::c_int | (7 as libc::c_int) << 8 as libc::c_int;
            current_block = 15457774371261439102;
        } else {
            nShmFilename =
                6 as libc::c_int + strlen(zBasePath) as libc::c_int;
            pShmNode =
                sqlite3_malloc64((::std::mem::size_of::<unixShmNode>() as
                                      libc::c_ulong).wrapping_add(nShmFilename
                                                                      as
                                                                      libc::c_ulong)
                                     as sqlite3_uint64) as *mut unixShmNode;
            if pShmNode.is_null() {
                rc = 7 as libc::c_int;
                current_block = 15457774371261439102;
            } else {
                memset(pShmNode as *mut libc::c_void, 0 as libc::c_int,
                       (::std::mem::size_of::<unixShmNode>() as
                            libc::c_ulong).wrapping_add(nShmFilename as
                                                            libc::c_ulong));
                (*pShmNode).zFilename =
                    &mut *pShmNode.offset(1 as libc::c_int as isize) as
                        *mut unixShmNode as *mut libc::c_char;
                zShm = (*pShmNode).zFilename;
                sqlite3_snprintf(nShmFilename, zShm,
                                 b"%s-shm\x00" as *const u8 as
                                     *const libc::c_char, zBasePath);
                (*pShmNode).hShm = -(1 as libc::c_int);
                (*(*pDbFd).pInode).pShmNode = pShmNode;
                (*pShmNode).pInode = (*pDbFd).pInode;
                if sqlite3Config.bCoreMutex != 0 {
                    (*pShmNode).pShmMutex =
                        sqlite3_mutex_alloc(0 as libc::c_int);
                    if (*pShmNode).pShmMutex.is_null() {
                        rc = 7 as libc::c_int;
                        current_block = 15457774371261439102;
                    } else { current_block = 7205609094909031804; }
                } else { current_block = 7205609094909031804; }
                match current_block {
                    15457774371261439102 => { }
                    _ => {
                        if (*pInode).bProcessLock as libc::c_int ==
                               0 as libc::c_int {
                            if 0 as libc::c_int ==
                                   sqlite3_uri_boolean((*pDbFd).zPath,
                                                       b"readonly_shm\x00" as
                                                           *const u8 as
                                                           *const libc::c_char,
                                                       0 as libc::c_int) {
                                (*pShmNode).hShm =
                                    robust_open(zShm,
                                                0o2 as libc::c_int |
                                                    0o100 as libc::c_int |
                                                    0o400000 as libc::c_int,
                                                sStat.st_mode &
                                                    0o777 as libc::c_int as
                                                        libc::c_uint)
                            }
                            if (*pShmNode).hShm < 0 as libc::c_int {
                                (*pShmNode).hShm =
                                    robust_open(zShm,
                                                0 as libc::c_int |
                                                    0o400000 as libc::c_int,
                                                sStat.st_mode &
                                                    0o777 as libc::c_int as
                                                        libc::c_uint);
                                if (*pShmNode).hShm < 0 as libc::c_int {
                                    rc =
                                        unixLogErrorAtLine(sqlite3CantopenError(38059
                                                                                    as
                                                                                    libc::c_int),
                                                           b"open\x00" as
                                                               *const u8 as
                                                               *const libc::c_char,
                                                           zShm,
                                                           38059 as
                                                               libc::c_int);
                                    current_block = 15457774371261439102;
                                } else {
                                    (*pShmNode).isReadonly =
                                        1 as libc::c_int as u8_0;
                                    current_block = 980989089337379490;
                                }
                            } else { current_block = 980989089337379490; }
                            match current_block {
                                15457774371261439102 => { }
                                _ => {
                                    robustFchown((*pShmNode).hShm,
                                                 sStat.st_uid, sStat.st_gid);
                                    rc =
                                        unixLockSharedMemory(pDbFd, pShmNode);
                                    if rc != 0 as libc::c_int &&
                                           rc !=
                                               8 as libc::c_int |
                                                   (5 as libc::c_int) <<
                                                       8 as libc::c_int {
                                        current_block = 15457774371261439102;
                                    } else {
                                        current_block = 721385680381463314;
                                    }
                                }
                            }
                        } else { current_block = 721385680381463314; }
                    }
                }
            }
        }
        match current_block {
            721385680381463314 => { }
            _ => {
                unixShmPurge(pDbFd);
                sqlite3_free(p as *mut libc::c_void);
                unixLeaveMutex();
                return rc
            }
        }
    }
    (*p).pShmNode = pShmNode;
    (*pShmNode).nRef += 1;
    (*pDbFd).pShm = p;
    unixLeaveMutex();
    sqlite3_mutex_enter((*pShmNode).pShmMutex);
    (*p).pNext = (*pShmNode).pFirst;
    (*pShmNode).pFirst = p;
    sqlite3_mutex_leave((*pShmNode).pShmMutex);
    return rc;
}
unsafe extern "C" fn unixShmMap(mut fd: *mut sqlite3_file,
                                mut iRegion: libc::c_int,
                                mut szRegion: libc::c_int,
                                mut bExtend: libc::c_int,
                                mut pp: *mut *mut libc::c_void)
 -> libc::c_int {
    let mut current_block: u64;
    let mut pDbFd: *mut unixFile = fd as *mut unixFile;
    let mut p: *mut unixShm = 0 as *mut unixShm;
    let mut pShmNode: *mut unixShmNode = 0 as *mut unixShmNode;
    let mut rc: libc::c_int = 0 as libc::c_int;
    let mut nShmPerMap: libc::c_int = unixShmRegionPerMap();
    let mut nReqRegion: libc::c_int = 0;
    if (*pDbFd).pShm.is_null() {
        rc = unixOpenSharedMemory(pDbFd);
        if rc != 0 as libc::c_int { return rc }
    }
    p = (*pDbFd).pShm;
    pShmNode = (*p).pShmNode;
    sqlite3_mutex_enter((*pShmNode).pShmMutex);
    if (*pShmNode).isUnlocked != 0 {
        rc = unixLockSharedMemory(pDbFd, pShmNode);
        if rc != 0 as libc::c_int {
            current_block = 7467405950898972943;
        } else {
            (*pShmNode).isUnlocked = 0 as libc::c_int as u8_0;
            current_block = 8457315219000651999;
        }
    } else { current_block = 8457315219000651999; }
    match current_block {
        8457315219000651999 => {
            nReqRegion = (iRegion + nShmPerMap) / nShmPerMap * nShmPerMap;
            if ((*pShmNode).nRegion as libc::c_int) < nReqRegion {
                let mut apNew: *mut *mut libc::c_char =
                    0 as *mut *mut libc::c_char;
                let mut nByte: libc::c_int = nReqRegion * szRegion;
                let mut sStat: stat =
                    stat{st_dev: 0,
                         st_ino: 0,
                         st_nlink: 0,
                         st_mode: 0,
                         st_uid: 0,
                         st_gid: 0,
                         __pad0: 0,
                         st_rdev: 0,
                         st_size: 0,
                         st_blksize: 0,
                         st_blocks: 0,
                         st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
                         st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
                         st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
                         __glibc_reserved: [0; 3],};
                (*pShmNode).szRegion = szRegion;
                if (*pShmNode).hShm >= 0 as libc::c_int {
                    if ::std::mem::transmute::<sqlite3_syscall_ptr,
                                               Option<unsafe extern "C" fn(_:
                                                                               libc::c_int,
                                                                           _:
                                                                               *mut stat)
                                                          ->
                                                              libc::c_int>>(aSyscall[5
                                                                                         as
                                                                                         libc::c_int
                                                                                         as
                                                                                         usize].pCurrent).expect("non-null function pointer")((*pShmNode).hShm,
                                                                                                                                              &mut sStat)
                           != 0 {
                        rc =
                            10 as libc::c_int |
                                (19 as libc::c_int) << 8 as libc::c_int;
                        current_block = 7467405950898972943;
                    } else if sStat.st_size < nByte as libc::c_long {
                        if bExtend == 0 {
                            current_block = 7467405950898972943;
                        } else {
                            static mut pgsz: libc::c_int =
                                4096 as libc::c_int;
                            let mut iPg: libc::c_int = 0;
                            iPg =
                                (sStat.st_size / pgsz as libc::c_long) as
                                    libc::c_int;
                            loop  {
                                if !(iPg < nByte / pgsz) {
                                    current_block = 14072441030219150333;
                                    break ;
                                }
                                let mut x: libc::c_int = 0 as libc::c_int;
                                if seekAndWriteFd((*pShmNode).hShm,
                                                  (iPg * pgsz + pgsz -
                                                       1 as libc::c_int) as
                                                      i64_0,
                                                  b"\x00" as *const u8 as
                                                      *const libc::c_char as
                                                      *const libc::c_void,
                                                  1 as libc::c_int, &mut x) !=
                                       1 as libc::c_int {
                                    let mut zFile: *const libc::c_char =
                                        (*pShmNode).zFilename;
                                    rc =
                                        unixLogErrorAtLine(10 as libc::c_int |
                                                               (19 as
                                                                    libc::c_int)
                                                                   <<
                                                                   8 as
                                                                       libc::c_int,
                                                           b"write\x00" as
                                                               *const u8 as
                                                               *const libc::c_char,
                                                           zFile,
                                                           38203 as
                                                               libc::c_int);
                                    current_block = 7467405950898972943;
                                    break ;
                                } else { iPg += 1 }
                            }
                        }
                    } else { current_block = 14072441030219150333; }
                } else { current_block = 14072441030219150333; }
                match current_block {
                    7467405950898972943 => { }
                    _ => {
                        apNew =
                            sqlite3_realloc((*pShmNode).apRegion as
                                                *mut libc::c_void,
                                            (nReqRegion as
                                                 libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut libc::c_char>()
                                                                                 as
                                                                                 libc::c_ulong)
                                                as libc::c_int) as
                                *mut *mut libc::c_char;
                        if apNew.is_null() {
                            rc =
                                10 as libc::c_int |
                                    (12 as libc::c_int) << 8 as libc::c_int
                        } else {
                            (*pShmNode).apRegion = apNew;
                            while ((*pShmNode).nRegion as libc::c_int) <
                                      nReqRegion {
                                let mut nMap: libc::c_int =
                                    szRegion * nShmPerMap;
                                let mut i: libc::c_int = 0;
                                let mut pMem: *mut libc::c_void =
                                    0 as *mut libc::c_void;
                                if (*pShmNode).hShm >= 0 as libc::c_int {
                                    pMem =
                                        ::std::mem::transmute::<sqlite3_syscall_ptr,
                                                                Option<unsafe extern "C" fn(_:
                                                                                                *mut libc::c_void,
                                                                                            _:
                                                                                                size_t,
                                                                                            _:
                                                                                                libc::c_int,
                                                                                            _:
                                                                                                libc::c_int,
                                                                                            _:
                                                                                                libc::c_int,
                                                                                            _:
                                                                                                off_t)
                                                                           ->
                                                                               *mut libc::c_void>>(aSyscall[22
                                                                                                                as
                                                                                                                libc::c_int
                                                                                                                as
                                                                                                                usize].pCurrent).expect("non-null function pointer")(0
                                                                                                                                                                         as
                                                                                                                                                                         *mut libc::c_void,
                                                                                                                                                                     nMap
                                                                                                                                                                         as
                                                                                                                                                                         size_t,
                                                                                                                                                                     if (*pShmNode).isReadonly
                                                                                                                                                                            as
                                                                                                                                                                            libc::c_int
                                                                                                                                                                            !=
                                                                                                                                                                            0
                                                                                                                                                                        {
                                                                                                                                                                         0x1
                                                                                                                                                                             as
                                                                                                                                                                             libc::c_int
                                                                                                                                                                     } else {
                                                                                                                                                                         (0x1
                                                                                                                                                                              as
                                                                                                                                                                              libc::c_int)
                                                                                                                                                                             |
                                                                                                                                                                             0x2
                                                                                                                                                                                 as
                                                                                                                                                                                 libc::c_int
                                                                                                                                                                     },
                                                                                                                                                                     0x1
                                                                                                                                                                         as
                                                                                                                                                                         libc::c_int,
                                                                                                                                                                     (*pShmNode).hShm,
                                                                                                                                                                     (szRegion
                                                                                                                                                                          as
                                                                                                                                                                          libc::c_longlong
                                                                                                                                                                          *
                                                                                                                                                                          (*pShmNode).nRegion
                                                                                                                                                                              as
                                                                                                                                                                              i64_0)
                                                                                                                                                                         as
                                                                                                                                                                         off_t);
                                    if pMem ==
                                           -(1 as libc::c_int) as
                                               *mut libc::c_void {
                                        rc =
                                            unixLogErrorAtLine(10 as
                                                                   libc::c_int
                                                                   |
                                                                   (21 as
                                                                        libc::c_int)
                                                                       <<
                                                                       8 as
                                                                           libc::c_int,
                                                               b"mmap\x00" as
                                                                   *const u8
                                                                   as
                                                                   *const libc::c_char,
                                                               (*pShmNode).zFilename,
                                                               38230 as
                                                                   libc::c_int);
                                        break ;
                                    }
                                } else {
                                    pMem =
                                        sqlite3_malloc64(nMap as
                                                             sqlite3_uint64);
                                    if pMem.is_null() {
                                        rc = 7 as libc::c_int;
                                        break ;
                                    } else {
                                        memset(pMem, 0 as libc::c_int,
                                               nMap as libc::c_ulong);
                                    }
                                }
                                i = 0 as libc::c_int;
                                while i < nShmPerMap {
                                    let ref mut fresh100 =
                                        *(*pShmNode).apRegion.offset(((*pShmNode).nRegion
                                                                          as
                                                                          libc::c_int
                                                                          + i)
                                                                         as
                                                                         isize);
                                    *fresh100 =
                                        &mut *(pMem as
                                                   *mut libc::c_char).offset((szRegion
                                                                                  *
                                                                                  i)
                                                                                 as
                                                                                 isize)
                                            as *mut libc::c_char;
                                    i += 1
                                }
                                (*pShmNode).nRegion =
                                    ((*pShmNode).nRegion as libc::c_int +
                                         nShmPerMap) as u16_0
                            }
                        }
                    }
                }
            }
        }
        _ => { }
    }
    if (*pShmNode).nRegion as libc::c_int > iRegion {
        *pp =
            *(*pShmNode).apRegion.offset(iRegion as isize) as
                *mut libc::c_void
    } else { *pp = 0 as *mut libc::c_void }
    if (*pShmNode).isReadonly as libc::c_int != 0 && rc == 0 as libc::c_int {
        rc = 8 as libc::c_int
    }
    sqlite3_mutex_leave((*pShmNode).pShmMutex);
    return rc;
}
unsafe extern "C" fn unixShmLock(mut fd: *mut sqlite3_file,
                                 mut ofst: libc::c_int, mut n: libc::c_int,
                                 mut flags: libc::c_int) -> libc::c_int {
    let mut pDbFd: *mut unixFile = fd as *mut unixFile;
    let mut p: *mut unixShm = (*pDbFd).pShm;
    let mut pX: *mut unixShm = 0 as *mut unixShm;
    let mut pShmNode: *mut unixShmNode = (*p).pShmNode;
    let mut rc: libc::c_int = 0 as libc::c_int;
    let mut mask: u16_0 = 0;
    mask =
        (((1 as libc::c_int) << ofst + n) - ((1 as libc::c_int) << ofst)) as
            u16_0;
    sqlite3_mutex_enter((*pShmNode).pShmMutex);
    if flags & 1 as libc::c_int != 0 {
        let mut allMask: u16_0 = 0 as libc::c_int as u16_0;
        pX = (*pShmNode).pFirst;
        while !pX.is_null() {
            if !(pX == p) {
                allMask =
                    (allMask as libc::c_int | (*pX).sharedMask as libc::c_int)
                        as u16_0
            }
            pX = (*pX).pNext
        }
        if mask as libc::c_int & allMask as libc::c_int == 0 as libc::c_int {
            rc =
                unixShmSystemLock(pDbFd, 2 as libc::c_int,
                                  ofst +
                                      (22 as libc::c_int + 8 as libc::c_int) *
                                          4 as libc::c_int, n)
        } else { rc = 0 as libc::c_int }
        if rc == 0 as libc::c_int {
            (*p).exclMask =
                ((*p).exclMask as libc::c_int & !(mask as libc::c_int)) as
                    u16_0;
            (*p).sharedMask =
                ((*p).sharedMask as libc::c_int & !(mask as libc::c_int)) as
                    u16_0
        }
    } else if flags & 4 as libc::c_int != 0 {
        let mut allShared: u16_0 = 0 as libc::c_int as u16_0;
        pX = (*pShmNode).pFirst;
        while !pX.is_null() {
            if (*pX).exclMask as libc::c_int & mask as libc::c_int !=
                   0 as libc::c_int {
                rc = 5 as libc::c_int;
                break ;
            } else {
                allShared =
                    (allShared as libc::c_int |
                         (*pX).sharedMask as libc::c_int) as u16_0;
                pX = (*pX).pNext
            }
        }
        if rc == 0 as libc::c_int {
            if allShared as libc::c_int & mask as libc::c_int ==
                   0 as libc::c_int {
                rc =
                    unixShmSystemLock(pDbFd, 0 as libc::c_int,
                                      ofst +
                                          (22 as libc::c_int +
                                               8 as libc::c_int) *
                                              4 as libc::c_int, n)
            } else { rc = 0 as libc::c_int }
        }
        if rc == 0 as libc::c_int {
            (*p).sharedMask =
                ((*p).sharedMask as libc::c_int | mask as libc::c_int) as
                    u16_0
        }
    } else {
        pX = (*pShmNode).pFirst;
        while !pX.is_null() {
            if (*pX).exclMask as libc::c_int & mask as libc::c_int !=
                   0 as libc::c_int ||
                   (*pX).sharedMask as libc::c_int & mask as libc::c_int !=
                       0 as libc::c_int {
                rc = 5 as libc::c_int;
                break ;
            } else { pX = (*pX).pNext }
        }
        if rc == 0 as libc::c_int {
            rc =
                unixShmSystemLock(pDbFd, 1 as libc::c_int,
                                  ofst +
                                      (22 as libc::c_int + 8 as libc::c_int) *
                                          4 as libc::c_int, n);
            if rc == 0 as libc::c_int {
                (*p).exclMask =
                    ((*p).exclMask as libc::c_int | mask as libc::c_int) as
                        u16_0
            }
        }
    }
    sqlite3_mutex_leave((*pShmNode).pShmMutex);
    return rc;
}
unsafe extern "C" fn unixShmBarrier(mut fd: *mut sqlite3_file) {
    sqlite3MemoryBarrier();
    unixEnterMutex();
    unixLeaveMutex();
}
unsafe extern "C" fn unixShmUnmap(mut fd: *mut sqlite3_file,
                                  mut deleteFlag: libc::c_int)
 -> libc::c_int {
    let mut p: *mut unixShm = 0 as *mut unixShm;
    let mut pShmNode: *mut unixShmNode = 0 as *mut unixShmNode;
    let mut pp: *mut *mut unixShm = 0 as *mut *mut unixShm;
    let mut pDbFd: *mut unixFile = 0 as *mut unixFile;
    pDbFd = fd as *mut unixFile;
    p = (*pDbFd).pShm;
    if p.is_null() { return 0 as libc::c_int }
    pShmNode = (*p).pShmNode;
    sqlite3_mutex_enter((*pShmNode).pShmMutex);
    pp = &mut (*pShmNode).pFirst;
    while *pp != p { pp = &mut (**pp).pNext }
    *pp = (*p).pNext;
    sqlite3_free(p as *mut libc::c_void);
    (*pDbFd).pShm = 0 as *mut unixShm;
    sqlite3_mutex_leave((*pShmNode).pShmMutex);
    unixEnterMutex();
    (*pShmNode).nRef -= 1;
    if (*pShmNode).nRef == 0 as libc::c_int {
        if deleteFlag != 0 && (*pShmNode).hShm >= 0 as libc::c_int {
            ::std::mem::transmute::<sqlite3_syscall_ptr,
                                    Option<unsafe extern "C" fn(_:
                                                                    *const libc::c_char)
                                               ->
                                                   libc::c_int>>(aSyscall[16
                                                                              as
                                                                              libc::c_int
                                                                              as
                                                                              usize].pCurrent).expect("non-null function pointer")((*pShmNode).zFilename);
        }
        unixShmPurge(pDbFd);
    }
    unixLeaveMutex();
    return 0 as libc::c_int;
}
unsafe extern "C" fn unixUnmapfile(mut pFd: *mut unixFile) {
    if !(*pFd).pMapRegion.is_null() {
        ::std::mem::transmute::<sqlite3_syscall_ptr,
                                Option<unsafe extern "C" fn(_:
                                                                *mut libc::c_void,
                                                            _: size_t)
                                           ->
                                               libc::c_int>>(aSyscall[23 as
                                                                          libc::c_int
                                                                          as
                                                                          usize].pCurrent).expect("non-null function pointer")((*pFd).pMapRegion,
                                                                                                                               (*pFd).mmapSizeActual
                                                                                                                                   as
                                                                                                                                   size_t);
        (*pFd).pMapRegion = 0 as *mut libc::c_void;
        (*pFd).mmapSize = 0 as libc::c_int as sqlite3_int64;
        (*pFd).mmapSizeActual = 0 as libc::c_int as sqlite3_int64
    };
}
unsafe extern "C" fn unixRemapfile(mut pFd: *mut unixFile, mut nNew: i64_0) {
    let mut zErr: *const libc::c_char =
        b"mmap\x00" as *const u8 as *const libc::c_char;
    let mut h: libc::c_int = (*pFd).h;
    let mut pOrig: *mut u8_0 = (*pFd).pMapRegion as *mut u8_0;
    let mut nOrig: i64_0 = (*pFd).mmapSizeActual;
    let mut pNew: *mut u8_0 = 0 as *mut u8_0;
    let mut flags: libc::c_int = 0x1 as libc::c_int;
    if !pOrig.is_null() {
        let mut nReuse: i64_0 = (*pFd).mmapSize;
        let mut pReq: *mut u8_0 =
            &mut *pOrig.offset(nReuse as isize) as *mut u8_0;
        if nReuse != nOrig {
            ::std::mem::transmute::<sqlite3_syscall_ptr,
                                    Option<unsafe extern "C" fn(_:
                                                                    *mut libc::c_void,
                                                                _: size_t)
                                               ->
                                                   libc::c_int>>(aSyscall[23
                                                                              as
                                                                              libc::c_int
                                                                              as
                                                                              usize].pCurrent).expect("non-null function pointer")(pReq
                                                                                                                                       as
                                                                                                                                       *mut libc::c_void,
                                                                                                                                   (nOrig
                                                                                                                                        -
                                                                                                                                        nReuse)
                                                                                                                                       as
                                                                                                                                       size_t);
        }
        pNew =
            ::std::mem::transmute::<sqlite3_syscall_ptr,
                                    Option<unsafe extern "C" fn(_:
                                                                    *mut libc::c_void,
                                                                _: size_t,
                                                                _: size_t,
                                                                _:
                                                                    libc::c_int,
                                                                _: ...)
                                               ->
                                                   *mut libc::c_void>>(aSyscall[24
                                                                                    as
                                                                                    libc::c_int
                                                                                    as
                                                                                    usize].pCurrent).expect("non-null function pointer")(pOrig
                                                                                                                                             as
                                                                                                                                             *mut libc::c_void,
                                                                                                                                         nReuse
                                                                                                                                             as
                                                                                                                                             size_t,
                                                                                                                                         nNew
                                                                                                                                             as
                                                                                                                                             size_t,
                                                                                                                                         1
                                                                                                                                             as
                                                                                                                                             libc::c_int)
                as *mut u8_0;
        zErr = b"mremap\x00" as *const u8 as *const libc::c_char;
        if pNew == -(1 as libc::c_int) as *mut libc::c_void as *mut u8_0 ||
               pNew.is_null() {
            ::std::mem::transmute::<sqlite3_syscall_ptr,
                                    Option<unsafe extern "C" fn(_:
                                                                    *mut libc::c_void,
                                                                _: size_t)
                                               ->
                                                   libc::c_int>>(aSyscall[23
                                                                              as
                                                                              libc::c_int
                                                                              as
                                                                              usize].pCurrent).expect("non-null function pointer")(pOrig
                                                                                                                                       as
                                                                                                                                       *mut libc::c_void,
                                                                                                                                   nReuse
                                                                                                                                       as
                                                                                                                                       size_t);
        }
    }
    if pNew.is_null() {
        pNew =
            ::std::mem::transmute::<sqlite3_syscall_ptr,
                                    Option<unsafe extern "C" fn(_:
                                                                    *mut libc::c_void,
                                                                _: size_t,
                                                                _:
                                                                    libc::c_int,
                                                                _:
                                                                    libc::c_int,
                                                                _:
                                                                    libc::c_int,
                                                                _: off_t)
                                               ->
                                                   *mut libc::c_void>>(aSyscall[22
                                                                                    as
                                                                                    libc::c_int
                                                                                    as
                                                                                    usize].pCurrent).expect("non-null function pointer")(0
                                                                                                                                             as
                                                                                                                                             *mut libc::c_void,
                                                                                                                                         nNew
                                                                                                                                             as
                                                                                                                                             size_t,
                                                                                                                                         flags,
                                                                                                                                         0x1
                                                                                                                                             as
                                                                                                                                             libc::c_int,
                                                                                                                                         h,
                                                                                                                                         0
                                                                                                                                             as
                                                                                                                                             libc::c_int
                                                                                                                                             as
                                                                                                                                             off_t)
                as *mut u8_0
    }
    if pNew == -(1 as libc::c_int) as *mut libc::c_void as *mut u8_0 {
        pNew = 0 as *mut u8_0;
        nNew = 0 as libc::c_int as i64_0;
        unixLogErrorAtLine(0 as libc::c_int, zErr, (*pFd).zPath,
                           38565 as libc::c_int);
        (*pFd).mmapSizeMax = 0 as libc::c_int as sqlite3_int64
    }
    (*pFd).pMapRegion = pNew as *mut libc::c_void;
    (*pFd).mmapSizeActual = nNew;
    (*pFd).mmapSize = (*pFd).mmapSizeActual;
}
unsafe extern "C" fn unixMapfile(mut pFd: *mut unixFile, mut nMap: i64_0)
 -> libc::c_int {
    if (*pFd).nFetchOut > 0 as libc::c_int { return 0 as libc::c_int }
    if nMap < 0 as libc::c_int as libc::c_longlong {
        let mut statbuf: stat =
            stat{st_dev: 0,
                 st_ino: 0,
                 st_nlink: 0,
                 st_mode: 0,
                 st_uid: 0,
                 st_gid: 0,
                 __pad0: 0,
                 st_rdev: 0,
                 st_size: 0,
                 st_blksize: 0,
                 st_blocks: 0,
                 st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
                 st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
                 st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
                 __glibc_reserved: [0; 3],};
        if ::std::mem::transmute::<sqlite3_syscall_ptr,
                                   Option<unsafe extern "C" fn(_: libc::c_int,
                                                               _: *mut stat)
                                              ->
                                                  libc::c_int>>(aSyscall[5 as
                                                                             libc::c_int
                                                                             as
                                                                             usize].pCurrent).expect("non-null function pointer")((*pFd).h,
                                                                                                                                  &mut statbuf)
               != 0 {
            return 10 as libc::c_int | (7 as libc::c_int) << 8 as libc::c_int
        }
        nMap = statbuf.st_size as i64_0
    }
    if nMap > (*pFd).mmapSizeMax { nMap = (*pFd).mmapSizeMax }
    if nMap != (*pFd).mmapSize { unixRemapfile(pFd, nMap); }
    return 0 as libc::c_int;
}
unsafe extern "C" fn unixFetch(mut fd: *mut sqlite3_file, mut iOff: i64_0,
                               mut nAmt: libc::c_int,
                               mut pp: *mut *mut libc::c_void)
 -> libc::c_int {
    let mut pFd: *mut unixFile = fd as *mut unixFile;
    *pp = 0 as *mut libc::c_void;
    if (*pFd).mmapSizeMax > 0 as libc::c_int as libc::c_longlong {
        if (*pFd).pMapRegion.is_null() {
            let mut rc: libc::c_int =
                unixMapfile(pFd, -(1 as libc::c_int) as i64_0);
            if rc != 0 as libc::c_int { return rc }
        }
        if (*pFd).mmapSize >= iOff + nAmt as libc::c_longlong {
            *pp =
                &mut *((*pFd).pMapRegion as *mut u8_0).offset(iOff as isize)
                    as *mut u8_0 as *mut libc::c_void;
            (*pFd).nFetchOut += 1
        }
    }
    return 0 as libc::c_int;
}
unsafe extern "C" fn unixUnfetch(mut fd: *mut sqlite3_file, mut iOff: i64_0,
                                 mut p: *mut libc::c_void) -> libc::c_int {
    let mut pFd: *mut unixFile = fd as *mut unixFile;
    if !p.is_null() { (*pFd).nFetchOut -= 1 } else { unixUnmapfile(pFd); }
    return 0 as libc::c_int;
}
static mut posixIoMethods: sqlite3_io_methods =
    unsafe {
        {
            let mut init =
                sqlite3_io_methods{iVersion: 3 as libc::c_int,
                                   xClose:
                                       Some(unixClose as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file)
                                                    -> libc::c_int),
                                   xRead:
                                       Some(unixRead as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         *mut libc::c_void,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         sqlite3_int64)
                                                    -> libc::c_int),
                                   xWrite:
                                       Some(unixWrite as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         *const libc::c_void,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         sqlite3_int64)
                                                    -> libc::c_int),
                                   xTruncate:
                                       Some(unixTruncate as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _: i64_0)
                                                    -> libc::c_int),
                                   xSync:
                                       Some(unixSync as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xFileSize:
                                       Some(unixFileSize as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         *mut i64_0)
                                                    -> libc::c_int),
                                   xLock:
                                       Some(unixLock as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xUnlock:
                                       Some(unixUnlock as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xCheckReservedLock:
                                       Some(unixCheckReservedLock as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         *mut libc::c_int)
                                                    -> libc::c_int),
                                   xFileControl:
                                       Some(unixFileControl as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         *mut libc::c_void)
                                                    -> libc::c_int),
                                   xSectorSize:
                                       Some(unixSectorSize as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file)
                                                    -> libc::c_int),
                                   xDeviceCharacteristics:
                                       Some(unixDeviceCharacteristics as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file)
                                                    -> libc::c_int),
                                   xShmMap:
                                       Some(unixShmMap as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         *mut *mut libc::c_void)
                                                    -> libc::c_int),
                                   xShmLock:
                                       Some(unixShmLock as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xShmBarrier:
                                       Some(unixShmBarrier as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file)
                                                    -> ()),
                                   xShmUnmap:
                                       Some(unixShmUnmap as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xFetch:
                                       Some(unixFetch as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _: i64_0,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         *mut *mut libc::c_void)
                                                    -> libc::c_int),
                                   xUnfetch:
                                       Some(unixUnfetch as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _: i64_0,
                                                                     _:
                                                                         *mut libc::c_void)
                                                    -> libc::c_int),};
            init
        }
    };
unsafe extern "C" fn posixIoFinderImpl(mut z: *const libc::c_char,
                                       mut p: *mut unixFile)
 -> *const sqlite3_io_methods {
    return &posixIoMethods;
}
static mut posixIoFinder:
       Option<unsafe extern "C" fn(_: *const libc::c_char, _: *mut unixFile)
                  -> *const sqlite3_io_methods> =
    unsafe {
        Some(posixIoFinderImpl as
                 unsafe extern "C" fn(_: *const libc::c_char,
                                      _: *mut unixFile)
                     -> *const sqlite3_io_methods)
    };
static mut nolockIoMethods: sqlite3_io_methods =
    unsafe {
        {
            let mut init =
                sqlite3_io_methods{iVersion: 3 as libc::c_int,
                                   xClose:
                                       Some(nolockClose as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file)
                                                    -> libc::c_int),
                                   xRead:
                                       Some(unixRead as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         *mut libc::c_void,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         sqlite3_int64)
                                                    -> libc::c_int),
                                   xWrite:
                                       Some(unixWrite as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         *const libc::c_void,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         sqlite3_int64)
                                                    -> libc::c_int),
                                   xTruncate:
                                       Some(unixTruncate as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _: i64_0)
                                                    -> libc::c_int),
                                   xSync:
                                       Some(unixSync as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xFileSize:
                                       Some(unixFileSize as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         *mut i64_0)
                                                    -> libc::c_int),
                                   xLock:
                                       Some(nolockLock as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xUnlock:
                                       Some(nolockUnlock as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xCheckReservedLock:
                                       Some(nolockCheckReservedLock as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         *mut libc::c_int)
                                                    -> libc::c_int),
                                   xFileControl:
                                       Some(unixFileControl as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         *mut libc::c_void)
                                                    -> libc::c_int),
                                   xSectorSize:
                                       Some(unixSectorSize as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file)
                                                    -> libc::c_int),
                                   xDeviceCharacteristics:
                                       Some(unixDeviceCharacteristics as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file)
                                                    -> libc::c_int),
                                   xShmMap: None,
                                   xShmLock:
                                       Some(unixShmLock as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xShmBarrier:
                                       Some(unixShmBarrier as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file)
                                                    -> ()),
                                   xShmUnmap:
                                       Some(unixShmUnmap as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xFetch:
                                       Some(unixFetch as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _: i64_0,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         *mut *mut libc::c_void)
                                                    -> libc::c_int),
                                   xUnfetch:
                                       Some(unixUnfetch as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _: i64_0,
                                                                     _:
                                                                         *mut libc::c_void)
                                                    -> libc::c_int),};
            init
        }
    };
unsafe extern "C" fn nolockIoFinderImpl(mut z: *const libc::c_char,
                                        mut p: *mut unixFile)
 -> *const sqlite3_io_methods {
    return &nolockIoMethods;
}
static mut nolockIoFinder:
       Option<unsafe extern "C" fn(_: *const libc::c_char, _: *mut unixFile)
                  -> *const sqlite3_io_methods> =
    unsafe {
        Some(nolockIoFinderImpl as
                 unsafe extern "C" fn(_: *const libc::c_char,
                                      _: *mut unixFile)
                     -> *const sqlite3_io_methods)
    };
static mut dotlockIoMethods: sqlite3_io_methods =
    unsafe {
        {
            let mut init =
                sqlite3_io_methods{iVersion: 1 as libc::c_int,
                                   xClose:
                                       Some(dotlockClose as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file)
                                                    -> libc::c_int),
                                   xRead:
                                       Some(unixRead as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         *mut libc::c_void,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         sqlite3_int64)
                                                    -> libc::c_int),
                                   xWrite:
                                       Some(unixWrite as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         *const libc::c_void,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         sqlite3_int64)
                                                    -> libc::c_int),
                                   xTruncate:
                                       Some(unixTruncate as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _: i64_0)
                                                    -> libc::c_int),
                                   xSync:
                                       Some(unixSync as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xFileSize:
                                       Some(unixFileSize as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         *mut i64_0)
                                                    -> libc::c_int),
                                   xLock:
                                       Some(dotlockLock as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xUnlock:
                                       Some(dotlockUnlock as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xCheckReservedLock:
                                       Some(dotlockCheckReservedLock as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         *mut libc::c_int)
                                                    -> libc::c_int),
                                   xFileControl:
                                       Some(unixFileControl as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         *mut libc::c_void)
                                                    -> libc::c_int),
                                   xSectorSize:
                                       Some(unixSectorSize as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file)
                                                    -> libc::c_int),
                                   xDeviceCharacteristics:
                                       Some(unixDeviceCharacteristics as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file)
                                                    -> libc::c_int),
                                   xShmMap: None,
                                   xShmLock:
                                       Some(unixShmLock as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xShmBarrier:
                                       Some(unixShmBarrier as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file)
                                                    -> ()),
                                   xShmUnmap:
                                       Some(unixShmUnmap as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _:
                                                                         libc::c_int)
                                                    -> libc::c_int),
                                   xFetch:
                                       Some(unixFetch as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _: i64_0,
                                                                     _:
                                                                         libc::c_int,
                                                                     _:
                                                                         *mut *mut libc::c_void)
                                                    -> libc::c_int),
                                   xUnfetch:
                                       Some(unixUnfetch as
                                                unsafe extern "C" fn(_:
                                                                         *mut sqlite3_file,
                                                                     _: i64_0,
                                                                     _:
                                                                         *mut libc::c_void)
                                                    -> libc::c_int),};
            init
        }
    };
unsafe extern "C" fn dotlockIoFinderImpl(mut z: *const libc::c_char,
                                         mut p: *mut unixFile)
 -> *const sqlite3_io_methods {
    return &dotlockIoMethods;
}
static mut dotlockIoFinder:
       Option<unsafe extern "C" fn(_: *const libc::c_char, _: *mut unixFile)
                  -> *const sqlite3_io_methods> =
    unsafe {
        Some(dotlockIoFinderImpl as
                 unsafe extern "C" fn(_: *const libc::c_char,
                                      _: *mut unixFile)
                     -> *const sqlite3_io_methods)
    };
unsafe extern "C" fn fillInUnixFile(mut pVfs: *mut sqlite3_vfs,
                                    mut h: libc::c_int,
                                    mut pId: *mut sqlite3_file,
                                    mut zFilename: *const libc::c_char,
                                    mut ctrlFlags: libc::c_int)
 -> libc::c_int {
    let mut pLockingStyle: *const sqlite3_io_methods =
        0 as *const sqlite3_io_methods;
    let mut pNew: *mut unixFile = pId as *mut unixFile;
    let mut rc: libc::c_int = 0 as libc::c_int;
    (*pNew).h = h;
    (*pNew).pVfs = pVfs;
    (*pNew).zPath = zFilename;
    (*pNew).ctrlFlags = ctrlFlags as u8_0 as libc::c_ushort;
    (*pNew).mmapSizeMax = sqlite3Config.szMmap;
    if sqlite3_uri_boolean(if ctrlFlags & 0x40 as libc::c_int != 0 {
                               zFilename
                           } else { 0 as *const libc::c_char },
                           b"psow\x00" as *const u8 as *const libc::c_char,
                           1 as libc::c_int) != 0 {
        (*pNew).ctrlFlags =
            ((*pNew).ctrlFlags as libc::c_int | 0x10 as libc::c_int) as
                libc::c_ushort
    }
    if strcmp((*pVfs).zName,
              b"unix-excl\x00" as *const u8 as *const libc::c_char) ==
           0 as libc::c_int {
        (*pNew).ctrlFlags =
            ((*pNew).ctrlFlags as libc::c_int | 0x1 as libc::c_int) as
                libc::c_ushort
    }
    if ctrlFlags & 0x80 as libc::c_int != 0 {
        pLockingStyle = &nolockIoMethods
    } else {
        pLockingStyle =
            Some((*((*pVfs).pAppData as
                        *mut finder_type)).expect("non-null function pointer")).expect("non-null function pointer")(zFilename,
                                                                                                                    pNew)
    }
    if pLockingStyle == &posixIoMethods as *const sqlite3_io_methods {
        unixEnterMutex();
        rc = findInodeInfo(pNew, &mut (*pNew).pInode);
        if rc != 0 as libc::c_int {
            robust_close(pNew, h, 39068 as libc::c_int);
            h = -(1 as libc::c_int)
        }
        unixLeaveMutex();
    } else if pLockingStyle == &dotlockIoMethods as *const sqlite3_io_methods
     {
        let mut zLockFile: *mut libc::c_char = 0 as *mut libc::c_char;
        let mut nFilename: libc::c_int = 0;
        nFilename = strlen(zFilename) as libc::c_int + 6 as libc::c_int;
        zLockFile =
            sqlite3_malloc64(nFilename as sqlite3_uint64) as
                *mut libc::c_char;
        if zLockFile.is_null() {
            rc = 7 as libc::c_int
        } else {
            sqlite3_snprintf(nFilename, zLockFile,
                             b"%s.lock\x00" as *const u8 as
                                 *const libc::c_char, zFilename);
        }
        (*pNew).lockingContext = zLockFile as *mut libc::c_void
    }
    storeLastErrno(pNew, 0 as libc::c_int);
    if rc != 0 as libc::c_int {
        if h >= 0 as libc::c_int {
            robust_close(pNew, h, 39153 as libc::c_int);
        }
    } else { (*pNew).pMethod = pLockingStyle; verifyDbFile(pNew); }
    return rc;
}
unsafe extern "C" fn unixTempFileDir() -> *const libc::c_char {
    static mut azDirs: [*const libc::c_char; 6] =
        [0 as *const libc::c_char, 0 as *const libc::c_char,
         b"/var/tmp\x00" as *const u8 as *const libc::c_char,
         b"/usr/tmp\x00" as *const u8 as *const libc::c_char,
         b"/tmp\x00" as *const u8 as *const libc::c_char,
         b".\x00" as *const u8 as *const libc::c_char];
    let mut i: libc::c_uint = 0 as libc::c_int as libc::c_uint;
    let mut buf: stat =
        stat{st_dev: 0,
             st_ino: 0,
             st_nlink: 0,
             st_mode: 0,
             st_uid: 0,
             st_gid: 0,
             __pad0: 0,
             st_rdev: 0,
             st_size: 0,
             st_blksize: 0,
             st_blocks: 0,
             st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
             __glibc_reserved: [0; 3],};
    let mut zDir: *const libc::c_char = sqlite3_temp_directory;
    if azDirs[0 as libc::c_int as usize].is_null() {
        azDirs[0 as libc::c_int as usize] =
            getenv(b"SQLITE_TMPDIR\x00" as *const u8 as *const libc::c_char)
    }
    if azDirs[1 as libc::c_int as usize].is_null() {
        azDirs[1 as libc::c_int as usize] =
            getenv(b"TMPDIR\x00" as *const u8 as *const libc::c_char)
    }
    loop  {
        if !zDir.is_null() &&
               ::std::mem::transmute::<sqlite3_syscall_ptr,
                                       Option<unsafe extern "C" fn(_:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       *mut stat)
                                                  ->
                                                      libc::c_int>>(aSyscall[4
                                                                                 as
                                                                                 libc::c_int
                                                                                 as
                                                                                 usize].pCurrent).expect("non-null function pointer")(zDir,
                                                                                                                                      &mut buf)
                   == 0 as libc::c_int &&
               buf.st_mode & 0o170000 as libc::c_int as libc::c_uint ==
                   0o40000 as libc::c_int as libc::c_uint &&
               ::std::mem::transmute::<sqlite3_syscall_ptr,
                                       Option<unsafe extern "C" fn(_:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int)
                                                  ->
                                                      libc::c_int>>(aSyscall[2
                                                                                 as
                                                                                 libc::c_int
                                                                                 as
                                                                                 usize].pCurrent).expect("non-null function pointer")(zDir,
                                                                                                                                      0o3
                                                                                                                                          as
                                                                                                                                          libc::c_int)
                   == 0 as libc::c_int {
            return zDir
        }
        if i as libc::c_ulong >=
               (::std::mem::size_of::<[*const libc::c_char; 6]>() as
                    libc::c_ulong).wrapping_div(::std::mem::size_of::<*const libc::c_char>()
                                                    as libc::c_ulong) {
            break ;
        }
        let fresh101 = i;
        i = i.wrapping_add(1);
        zDir = azDirs[fresh101 as usize]
    }
    return 0 as *const libc::c_char;
}
unsafe extern "C" fn unixGetTempname(mut nBuf: libc::c_int,
                                     mut zBuf: *mut libc::c_char)
 -> libc::c_int {
    let mut zDir: *const libc::c_char = 0 as *const libc::c_char;
    let mut iLimit: libc::c_int = 0 as libc::c_int;
    *zBuf.offset(0 as libc::c_int as isize) =
        0 as libc::c_int as libc::c_char;
    zDir = unixTempFileDir();
    if zDir.is_null() {
        return 10 as libc::c_int | (25 as libc::c_int) << 8 as libc::c_int
    }
    loop  {
        let mut r: u64_0 = 0;
        sqlite3_randomness(::std::mem::size_of::<u64_0>() as libc::c_ulong as
                               libc::c_int,
                           &mut r as *mut u64_0 as *mut libc::c_void);
        *zBuf.offset((nBuf - 2 as libc::c_int) as isize) =
            0 as libc::c_int as libc::c_char;
        sqlite3_snprintf(nBuf, zBuf,
                         b"%s/etilqs_%llx%c\x00" as *const u8 as
                             *const libc::c_char, zDir, r, 0 as libc::c_int);
        if *zBuf.offset((nBuf - 2 as libc::c_int) as isize) as libc::c_int !=
               0 as libc::c_int ||
               {
                   let fresh102 = iLimit;
                   iLimit = iLimit + 1;
                   (fresh102) > 10 as libc::c_int
               } {
            return 1 as libc::c_int
        }
        if !(::std::mem::transmute::<sqlite3_syscall_ptr,
                                     Option<unsafe extern "C" fn(_:
                                                                     *const libc::c_char,
                                                                 _:
                                                                     libc::c_int)
                                                ->
                                                    libc::c_int>>(aSyscall[2
                                                                               as
                                                                               libc::c_int
                                                                               as
                                                                               usize].pCurrent).expect("non-null function pointer")(zBuf,
                                                                                                                                    0
                                                                                                                                        as
                                                                                                                                        libc::c_int)
                 == 0 as libc::c_int) {
            break ;
        }
    }
    return 0 as libc::c_int;
}
unsafe extern "C" fn findReusableFd(mut zPath: *const libc::c_char,
                                    mut flags: libc::c_int)
 -> *mut UnixUnusedFd {
    let mut pUnused: *mut UnixUnusedFd = 0 as *mut UnixUnusedFd;
    let mut sStat: stat =
        stat{st_dev: 0,
             st_ino: 0,
             st_nlink: 0,
             st_mode: 0,
             st_uid: 0,
             st_gid: 0,
             __pad0: 0,
             st_rdev: 0,
             st_size: 0,
             st_blksize: 0,
             st_blocks: 0,
             st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
             __glibc_reserved: [0; 3],};
    unixEnterMutex();
    if !inodeList.is_null() &&
           0 as libc::c_int ==
               ::std::mem::transmute::<sqlite3_syscall_ptr,
                                       Option<unsafe extern "C" fn(_:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       *mut stat)
                                                  ->
                                                      libc::c_int>>(aSyscall[4
                                                                                 as
                                                                                 libc::c_int
                                                                                 as
                                                                                 usize].pCurrent).expect("non-null function pointer")(zPath,
                                                                                                                                      &mut sStat)
       {
        let mut pInode: *mut unixInodeInfo = 0 as *mut unixInodeInfo;
        pInode = inodeList;
        while !pInode.is_null() &&
                  ((*pInode).fileId.dev != sStat.st_dev ||
                       (*pInode).fileId.ino != sStat.st_ino as u64_0) {
            pInode = (*pInode).pNext
        }
        if !pInode.is_null() {
            let mut pp: *mut *mut UnixUnusedFd = 0 as *mut *mut UnixUnusedFd;
            sqlite3_mutex_enter((*pInode).pLockMutex);
            flags &= 0x1 as libc::c_int | 0x2 as libc::c_int;
            pp = &mut (*pInode).pUnused;
            while !(*pp).is_null() && (**pp).flags != flags {
                pp = &mut (**pp).pNext
            }
            pUnused = *pp;
            if !pUnused.is_null() { *pp = (*pUnused).pNext }
            sqlite3_mutex_leave((*pInode).pLockMutex);
        }
    }
    unixLeaveMutex();
    return pUnused;
}
unsafe extern "C" fn getFileMode(mut zFile: *const libc::c_char,
                                 mut pMode: *mut mode_t, mut pUid: *mut uid_t,
                                 mut pGid: *mut gid_t) -> libc::c_int {
    let mut sStat: stat =
        stat{st_dev: 0,
             st_ino: 0,
             st_nlink: 0,
             st_mode: 0,
             st_uid: 0,
             st_gid: 0,
             __pad0: 0,
             st_rdev: 0,
             st_size: 0,
             st_blksize: 0,
             st_blocks: 0,
             st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
             st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
             __glibc_reserved: [0; 3],};
    let mut rc: libc::c_int = 0 as libc::c_int;
    if 0 as libc::c_int ==
           ::std::mem::transmute::<sqlite3_syscall_ptr,
                                   Option<unsafe extern "C" fn(_:
                                                                   *const libc::c_char,
                                                               _: *mut stat)
                                              ->
                                                  libc::c_int>>(aSyscall[4 as
                                                                             libc::c_int
                                                                             as
                                                                             usize].pCurrent).expect("non-null function pointer")(zFile,
                                                                                                                                  &mut sStat)
       {
        *pMode = sStat.st_mode & 0o777 as libc::c_int as libc::c_uint;
        *pUid = sStat.st_uid;
        *pGid = sStat.st_gid
    } else { rc = 10 as libc::c_int | (7 as libc::c_int) << 8 as libc::c_int }
    return rc;
}
unsafe extern "C" fn findCreateFileMode(mut zPath: *const libc::c_char,
                                        mut flags: libc::c_int,
                                        mut pMode: *mut mode_t,
                                        mut pUid: *mut uid_t,
                                        mut pGid: *mut gid_t) -> libc::c_int {
    let mut rc: libc::c_int = 0 as libc::c_int;
    *pMode = 0 as libc::c_int as mode_t;
    *pUid = 0 as libc::c_int as uid_t;
    *pGid = 0 as libc::c_int as gid_t;
    if flags & (0x80000 as libc::c_int | 0x800 as libc::c_int) != 0 {
        let mut zDb: [libc::c_char; 513] = [0; 513];
        let mut nDb: libc::c_int = 0;
        nDb = sqlite3Strlen30(zPath) - 1 as libc::c_int;
        while *zPath.offset(nDb as isize) as libc::c_int != '-' as i32 {
            if nDb == 0 as libc::c_int ||
                   *zPath.offset(nDb as isize) as libc::c_int == '.' as i32 {
                return 0 as libc::c_int
            }
            nDb -= 1
        }
        memcpy(zDb.as_mut_ptr() as *mut libc::c_void,
               zPath as *const libc::c_void, nDb as libc::c_ulong);
        zDb[nDb as usize] = '\u{0}' as i32 as libc::c_char;
        rc = getFileMode(zDb.as_mut_ptr(), pMode, pUid, pGid)
    } else if flags & 0x8 as libc::c_int != 0 {
        *pMode = 0o600 as libc::c_int as mode_t
    } else if flags & 0x40 as libc::c_int != 0 {
        let mut z: *const libc::c_char =
            sqlite3_uri_parameter(zPath,
                                  b"modeof\x00" as *const u8 as
                                      *const libc::c_char);
        if !z.is_null() { rc = getFileMode(z, pMode, pUid, pGid) }
    }
    return rc;
}
unsafe extern "C" fn unixOpen(mut pVfs: *mut sqlite3_vfs,
                              mut zPath: *const libc::c_char,
                              mut pFile: *mut sqlite3_file,
                              mut flags: libc::c_int,
                              mut pOutFlags: *mut libc::c_int)
 -> libc::c_int {
    let mut current_block: u64;
    let mut p: *mut unixFile = pFile as *mut unixFile;
    let mut fd: libc::c_int = -(1 as libc::c_int);
    let mut openFlags: libc::c_int = 0 as libc::c_int;
    let mut eType: libc::c_int = flags & 0xfff00 as libc::c_int;
    let mut noLock: libc::c_int = 0;
    let mut rc: libc::c_int = 0 as libc::c_int;
    let mut ctrlFlags: libc::c_int = 0 as libc::c_int;
    let mut isExclusive: libc::c_int = flags & 0x10 as libc::c_int;
    let mut isDelete: libc::c_int = flags & 0x8 as libc::c_int;
    let mut isCreate: libc::c_int = flags & 0x4 as libc::c_int;
    let mut isReadonly: libc::c_int = flags & 0x1 as libc::c_int;
    let mut isReadWrite: libc::c_int = flags & 0x2 as libc::c_int;
    let mut isNewJrnl: libc::c_int =
        (isCreate != 0 &&
             (eType == 0x4000 as libc::c_int || eType == 0x800 as libc::c_int
                  || eType == 0x80000 as libc::c_int)) as libc::c_int;
    let mut zTmpname: [libc::c_char; 514] = [0; 514];
    let mut zName: *const libc::c_char = zPath;
    if randomnessPid != getpid() {
        randomnessPid = getpid();
        sqlite3_randomness(0 as libc::c_int, 0 as *mut libc::c_void);
    }
    memset(p as *mut libc::c_void, 0 as libc::c_int,
           ::std::mem::size_of::<unixFile>() as libc::c_ulong);
    if eType == 0x100 as libc::c_int {
        let mut pUnused: *mut UnixUnusedFd = 0 as *mut UnixUnusedFd;
        pUnused = findReusableFd(zName, flags);
        if !pUnused.is_null() {
            fd = (*pUnused).fd
        } else {
            pUnused =
                sqlite3_malloc64(::std::mem::size_of::<UnixUnusedFd>() as
                                     libc::c_ulong as sqlite3_uint64) as
                    *mut UnixUnusedFd;
            if pUnused.is_null() { return 7 as libc::c_int }
        }
        (*p).pPreallocatedUnused = pUnused
    } else if zName.is_null() {
        rc = unixGetTempname((*pVfs).mxPathname, zTmpname.as_mut_ptr());
        if rc != 0 as libc::c_int { return rc }
        zName = zTmpname.as_mut_ptr()
    }
    if isReadonly != 0 { openFlags |= 0 as libc::c_int }
    if isReadWrite != 0 { openFlags |= 0o2 as libc::c_int }
    if isCreate != 0 { openFlags |= 0o100 as libc::c_int }
    if isExclusive != 0 {
        openFlags |= 0o200 as libc::c_int | 0o400000 as libc::c_int
    }
    openFlags |=
        0 as libc::c_int | 0 as libc::c_int | 0o400000 as libc::c_int;
    if fd < 0 as libc::c_int {
        let mut openMode: mode_t = 0;
        let mut uid: uid_t = 0;
        let mut gid: gid_t = 0;
        rc =
            findCreateFileMode(zName, flags, &mut openMode, &mut uid,
                               &mut gid);
        if rc != 0 as libc::c_int { return rc }
        fd = robust_open(zName, openFlags, openMode);
        if fd < 0 as libc::c_int {
            if isNewJrnl != 0 && *__errno_location() == 13 as libc::c_int &&
                   ::std::mem::transmute::<sqlite3_syscall_ptr,
                                           Option<unsafe extern "C" fn(_:
                                                                           *const libc::c_char,
                                                                       _:
                                                                           libc::c_int)
                                                      ->
                                                          libc::c_int>>(aSyscall[2
                                                                                     as
                                                                                     libc::c_int
                                                                                     as
                                                                                     usize].pCurrent).expect("non-null function pointer")(zName,
                                                                                                                                          0
                                                                                                                                              as
                                                                                                                                              libc::c_int)
                       != 0 {
                rc = 8 as libc::c_int | (6 as libc::c_int) << 8 as libc::c_int
            } else if *__errno_location() != 21 as libc::c_int &&
                          isReadWrite != 0 {
                flags &= !(0x2 as libc::c_int | 0x4 as libc::c_int);
                openFlags &= !(0o2 as libc::c_int | 0o100 as libc::c_int);
                flags |= 0x1 as libc::c_int;
                openFlags |= 0 as libc::c_int;
                isReadonly = 1 as libc::c_int;
                fd = robust_open(zName, openFlags, openMode)
            }
        }
        if fd < 0 as libc::c_int {
            let mut rc2: libc::c_int =
                unixLogErrorAtLine(sqlite3CantopenError(39567 as libc::c_int),
                                   b"open\x00" as *const u8 as
                                       *const libc::c_char, zName,
                                   39567 as libc::c_int);
            if rc == 0 as libc::c_int { rc = rc2 }
            current_block = 17825399868307214571;
        } else {
            if openMode != 0 &&
                   flags & (0x80000 as libc::c_int | 0x800 as libc::c_int) !=
                       0 as libc::c_int {
                robustFchown(fd, uid, gid);
            }
            current_block = 15514718523126015390;
        }
    } else { current_block = 15514718523126015390; }
    match current_block {
        15514718523126015390 => {
            if !pOutFlags.is_null() { *pOutFlags = flags }
            if !(*p).pPreallocatedUnused.is_null() {
                (*(*p).pPreallocatedUnused).fd = fd;
                (*(*p).pPreallocatedUnused).flags =
                    flags & (0x1 as libc::c_int | 0x2 as libc::c_int)
            }
            if isDelete != 0 {
                ::std::mem::transmute::<sqlite3_syscall_ptr,
                                        Option<unsafe extern "C" fn(_:
                                                                        *const libc::c_char)
                                                   ->
                                                       libc::c_int>>(aSyscall[16
                                                                                  as
                                                                                  libc::c_int
                                                                                  as
                                                                                  usize].pCurrent).expect("non-null function pointer")(zName);
            }
            if isDelete != 0 { ctrlFlags |= 0x20 as libc::c_int }
            if isReadonly != 0 { ctrlFlags |= 0x2 as libc::c_int }
            noLock = (eType != 0x100 as libc::c_int) as libc::c_int;
            if noLock != 0 { ctrlFlags |= 0x80 as libc::c_int }
            if isNewJrnl != 0 { ctrlFlags |= 0x8 as libc::c_int }
            if flags & 0x40 as libc::c_int != 0 {
                ctrlFlags |= 0x40 as libc::c_int
            }
            rc = fillInUnixFile(pVfs, fd, pFile, zPath, ctrlFlags)
        }
        _ => { }
    }
    if rc != 0 as libc::c_int {
        sqlite3_free((*p).pPreallocatedUnused as *mut libc::c_void);
    }
    return rc;
}
unsafe extern "C" fn unixDelete(mut NotUsed: *mut sqlite3_vfs,
                                mut zPath: *const libc::c_char,
                                mut dirSync: libc::c_int) -> libc::c_int {
    let mut rc: libc::c_int = 0 as libc::c_int;
    if ::std::mem::transmute::<sqlite3_syscall_ptr,
                               Option<unsafe extern "C" fn(_:
                                                               *const libc::c_char)
                                          ->
                                              libc::c_int>>(aSyscall[16 as
                                                                         libc::c_int
                                                                         as
                                                                         usize].pCurrent).expect("non-null function pointer")(zPath)
           == -(1 as libc::c_int) {
        if *__errno_location() == 2 as libc::c_int {
            rc = 10 as libc::c_int | (23 as libc::c_int) << 8 as libc::c_int
        } else {
            rc =
                unixLogErrorAtLine(10 as libc::c_int |
                                       (10 as libc::c_int) <<
                                           8 as libc::c_int,
                                   b"unlink\x00" as *const u8 as
                                       *const libc::c_char, zPath,
                                   39706 as libc::c_int)
        }
        return rc
    }
    if dirSync & 1 as libc::c_int != 0 as libc::c_int {
        let mut fd: libc::c_int = 0;
        rc =
            ::std::mem::transmute::<sqlite3_syscall_ptr,
                                    Option<unsafe extern "C" fn(_:
                                                                    *const libc::c_char,
                                                                _:
                                                                    *mut libc::c_int)
                                               ->
                                                   libc::c_int>>(aSyscall[17
                                                                              as
                                                                              libc::c_int
                                                                              as
                                                                              usize].pCurrent).expect("non-null function pointer")(zPath,
                                                                                                                                   &mut fd);
        if rc == 0 as libc::c_int {
            if full_fsync(fd, 0 as libc::c_int, 0 as libc::c_int) != 0 {
                rc =
                    unixLogErrorAtLine(10 as libc::c_int |
                                           (5 as libc::c_int) <<
                                               8 as libc::c_int,
                                       b"fsync\x00" as *const u8 as
                                           *const libc::c_char, zPath,
                                       39716 as libc::c_int)
            }
            robust_close(0 as *mut unixFile, fd, 39718 as libc::c_int);
        } else { rc = 0 as libc::c_int }
    }
    return rc;
}
unsafe extern "C" fn unixAccess(mut NotUsed: *mut sqlite3_vfs,
                                mut zPath: *const libc::c_char,
                                mut flags: libc::c_int,
                                mut pResOut: *mut libc::c_int)
 -> libc::c_int {
    if flags == 0 as libc::c_int {
        let mut buf: stat =
            stat{st_dev: 0,
                 st_ino: 0,
                 st_nlink: 0,
                 st_mode: 0,
                 st_uid: 0,
                 st_gid: 0,
                 __pad0: 0,
                 st_rdev: 0,
                 st_size: 0,
                 st_blksize: 0,
                 st_blocks: 0,
                 st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
                 st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
                 st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
                 __glibc_reserved: [0; 3],};
        *pResOut =
            (0 as libc::c_int ==
                 ::std::mem::transmute::<sqlite3_syscall_ptr,
                                         Option<unsafe extern "C" fn(_:
                                                                         *const libc::c_char,
                                                                     _:
                                                                         *mut stat)
                                                    ->
                                                        libc::c_int>>(aSyscall[4
                                                                                   as
                                                                                   libc::c_int
                                                                                   as
                                                                                   usize].pCurrent).expect("non-null function pointer")(zPath,
                                                                                                                                        &mut buf)
                 &&
                 (!(buf.st_mode & 0o170000 as libc::c_int as libc::c_uint ==
                        0o100000 as libc::c_int as libc::c_uint) ||
                      buf.st_size > 0 as libc::c_int as libc::c_long)) as
                libc::c_int
    } else {
        *pResOut =
            (::std::mem::transmute::<sqlite3_syscall_ptr,
                                     Option<unsafe extern "C" fn(_:
                                                                     *const libc::c_char,
                                                                 _:
                                                                     libc::c_int)
                                                ->
                                                    libc::c_int>>(aSyscall[2
                                                                               as
                                                                               libc::c_int
                                                                               as
                                                                               usize].pCurrent).expect("non-null function pointer")(zPath,
                                                                                                                                    2
                                                                                                                                        as
                                                                                                                                        libc::c_int
                                                                                                                                        |
                                                                                                                                        4
                                                                                                                                            as
                                                                                                                                            libc::c_int)
                 == 0 as libc::c_int) as libc::c_int
    }
    return 0 as libc::c_int;
}
unsafe extern "C" fn mkFullPathname(mut zPath: *const libc::c_char,
                                    mut zOut: *mut libc::c_char,
                                    mut nOut: libc::c_int) -> libc::c_int {
    let mut nPath: libc::c_int = sqlite3Strlen30(zPath);
    let mut iOff: libc::c_int = 0 as libc::c_int;
    if *zPath.offset(0 as libc::c_int as isize) as libc::c_int != '/' as i32 {
        if ::std::mem::transmute::<sqlite3_syscall_ptr,
                                   Option<unsafe extern "C" fn(_:
                                                                   *mut libc::c_char,
                                                               _: size_t)
                                              ->
                                                  *mut libc::c_char>>(aSyscall[3
                                                                                   as
                                                                                   libc::c_int
                                                                                   as
                                                                                   usize].pCurrent).expect("non-null function pointer")(zOut,
                                                                                                                                        (nOut
                                                                                                                                             -
                                                                                                                                             2
                                                                                                                                                 as
                                                                                                                                                 libc::c_int)
                                                                                                                                            as
                                                                                                                                            size_t).is_null()
           {
            return unixLogErrorAtLine(sqlite3CantopenError(39774 as
                                                               libc::c_int),
                                      b"getcwd\x00" as *const u8 as
                                          *const libc::c_char, zPath,
                                      39774 as libc::c_int)
        }
        iOff = sqlite3Strlen30(zOut);
        let fresh103 = iOff;
        iOff = iOff + 1;
        *zOut.offset(fresh103 as isize) = '/' as i32 as libc::c_char
    }
    if iOff + nPath + 1 as libc::c_int > nOut {
        *zOut.offset(iOff as isize) = '\u{0}' as i32 as libc::c_char;
        return sqlite3CantopenError(39783 as libc::c_int)
    }
    sqlite3_snprintf(nOut - iOff,
                     &mut *zOut.offset(iOff as isize) as *mut libc::c_char,
                     b"%s\x00" as *const u8 as *const libc::c_char, zPath);
    return 0 as libc::c_int;
}
unsafe extern "C" fn unixFullPathname(mut pVfs: *mut sqlite3_vfs,
                                      mut zPath: *const libc::c_char,
                                      mut nOut: libc::c_int,
                                      mut zOut: *mut libc::c_char)
 -> libc::c_int {
    let mut rc: libc::c_int = 0 as libc::c_int;
    let mut nByte: libc::c_int = 0;
    let mut nLink: libc::c_int = 0 as libc::c_int;
    let mut zIn: *const libc::c_char = zPath;
    let mut zDel: *mut libc::c_char = 0 as *mut libc::c_char;
    loop  {
        let mut bLink: libc::c_int = 0 as libc::c_int;
        let mut buf: stat =
            stat{st_dev: 0,
                 st_ino: 0,
                 st_nlink: 0,
                 st_mode: 0,
                 st_uid: 0,
                 st_gid: 0,
                 __pad0: 0,
                 st_rdev: 0,
                 st_size: 0,
                 st_blksize: 0,
                 st_blocks: 0,
                 st_atim: timespec{tv_sec: 0, tv_nsec: 0,},
                 st_mtim: timespec{tv_sec: 0, tv_nsec: 0,},
                 st_ctim: timespec{tv_sec: 0, tv_nsec: 0,},
                 __glibc_reserved: [0; 3],};
        if ::std::mem::transmute::<sqlite3_syscall_ptr,
                                   Option<unsafe extern "C" fn(_:
                                                                   *const libc::c_char,
                                                               _: *mut stat)
                                              ->
                                                  libc::c_int>>(aSyscall[27 as
                                                                             libc::c_int
                                                                             as
                                                                             usize].pCurrent).expect("non-null function pointer")(zIn,
                                                                                                                                  &mut buf)
               != 0 as libc::c_int {
            if *__errno_location() != 2 as libc::c_int {
                rc =
                    unixLogErrorAtLine(sqlite3CantopenError(39831 as
                                                                libc::c_int),
                                       b"lstat\x00" as *const u8 as
                                           *const libc::c_char, zIn,
                                       39831 as libc::c_int)
            }
        } else {
            bLink =
                (buf.st_mode & 0o170000 as libc::c_int as libc::c_uint ==
                     0o120000 as libc::c_int as libc::c_uint) as libc::c_int
        }
        if bLink != 0 {
            nLink += 1;
            if zDel.is_null() {
                zDel = sqlite3_malloc(nOut) as *mut libc::c_char;
                if zDel.is_null() { rc = 7 as libc::c_int }
            } else if nLink >= 100 as libc::c_int {
                rc = sqlite3CantopenError(39843 as libc::c_int)
            }
            if rc == 0 as libc::c_int {
                nByte =
                    ::std::mem::transmute::<sqlite3_syscall_ptr,
                                            Option<unsafe extern "C" fn(_:
                                                                            *const libc::c_char,
                                                                        _:
                                                                            *mut libc::c_char,
                                                                        _:
                                                                            size_t)
                                                       ->
                                                           ssize_t>>(aSyscall[26
                                                                                  as
                                                                                  libc::c_int
                                                                                  as
                                                                                  usize].pCurrent).expect("non-null function pointer")(zIn,
                                                                                                                                       zDel,
                                                                                                                                       (nOut
                                                                                                                                            -
                                                                                                                                            1
                                                                                                                                                as
                                                                                                                                                libc::c_int)
                                                                                                                                           as
                                                                                                                                           size_t)
                        as libc::c_int;
                if nByte < 0 as libc::c_int {
                    rc =
                        unixLogErrorAtLine(sqlite3CantopenError(39849 as
                                                                    libc::c_int),
                                           b"readlink\x00" as *const u8 as
                                               *const libc::c_char, zIn,
                                           39849 as libc::c_int)
                } else {
                    if *zDel.offset(0 as libc::c_int as isize) as libc::c_int
                           != '/' as i32 {
                        let mut n: libc::c_int = 0;
                        n = sqlite3Strlen30(zIn);
                        while n > 0 as libc::c_int &&
                                  *zIn.offset((n - 1 as libc::c_int) as isize)
                                      as libc::c_int != '/' as i32 {
                            n -= 1
                        }
                        if nByte + n + 1 as libc::c_int > nOut {
                            rc = sqlite3CantopenError(39855 as libc::c_int)
                        } else {
                            memmove(&mut *zDel.offset(n as isize) as
                                        *mut libc::c_char as
                                        *mut libc::c_void,
                                    zDel as *const libc::c_void,
                                    (nByte + 1 as libc::c_int) as
                                        libc::c_ulong);
                            memcpy(zDel as *mut libc::c_void,
                                   zIn as *const libc::c_void,
                                   n as libc::c_ulong);
                            nByte += n
                        }
                    }
                    *zDel.offset(nByte as isize) =
                        '\u{0}' as i32 as libc::c_char
                }
            }
            zIn = zDel
        }
        if rc == 0 as libc::c_int && zIn != zOut {
            rc = mkFullPathname(zIn, zOut, nOut)
        }
        if bLink == 0 as libc::c_int { break ; }
        zIn = zOut;
        if !(rc == 0 as libc::c_int) { break ; }
    }
    sqlite3_free(zDel as *mut libc::c_void);
    if rc == 0 as libc::c_int && nLink != 0 {
        rc = 0 as libc::c_int | (2 as libc::c_int) << 8 as libc::c_int
    }
    return rc;
}
unsafe extern "C" fn unixDlOpen(mut NotUsed: *mut sqlite3_vfs,
                                mut zFilename: *const libc::c_char)
 -> *mut libc::c_void {
    return dlopen(zFilename, 0x2 as libc::c_int | 0x100 as libc::c_int);
}
unsafe extern "C" fn unixDlError(mut NotUsed: *mut sqlite3_vfs,
                                 mut nBuf: libc::c_int,
                                 mut zBufOut: *mut libc::c_char) {
    let mut zErr: *const libc::c_char = 0 as *const libc::c_char;
    unixEnterMutex();
    zErr = dlerror();
    if !zErr.is_null() {
        sqlite3_snprintf(nBuf, zBufOut,
                         b"%s\x00" as *const u8 as *const libc::c_char, zErr);
    }
    unixLeaveMutex();
}
unsafe extern "C" fn unixDlSym(mut NotUsed: *mut sqlite3_vfs,
                               mut p: *mut libc::c_void,
                               mut zSym: *const libc::c_char)
 -> Option<unsafe extern "C" fn() -> ()> {
    let mut x:
            Option<unsafe extern "C" fn(_: *mut libc::c_void,
                                        _: *const libc::c_char)
                       -> Option<unsafe extern "C" fn() -> ()>> = None;
    x =
        ::std::mem::transmute::<Option<unsafe extern "C" fn(_:
                                                                *mut libc::c_void,
                                                            _:
                                                                *const libc::c_char)
                                           -> *mut libc::c_void>,
                                Option<unsafe extern "C" fn(_:
                                                                *mut libc::c_void,
                                                            _:
                                                                *const libc::c_char)
                                           ->
                                               Option<unsafe extern "C" fn()
                                                          ->
                                                              ()>>>(Some(dlsym
                                                                             as
                                                                             unsafe extern "C" fn(_:
                                                                                                      *mut libc::c_void,
                                                                                                  _:
                                                                                                      *const libc::c_char)
                                                                                 ->
                                                                                     *mut libc::c_void));
    return Some(x.expect("non-null function pointer")).expect("non-null function pointer")(p,
                                                                                           zSym);
}
unsafe extern "C" fn unixDlClose(mut NotUsed: *mut sqlite3_vfs,
                                 mut pHandle: *mut libc::c_void) {
    dlclose(pHandle);
}
unsafe extern "C" fn unixRandomness(mut NotUsed: *mut sqlite3_vfs,
                                    mut nBuf: libc::c_int,
                                    mut zBuf: *mut libc::c_char)
 -> libc::c_int {
    memset(zBuf as *mut libc::c_void, 0 as libc::c_int,
           nBuf as libc::c_ulong);
    randomnessPid = getpid();
    let mut fd: libc::c_int = 0;
    let mut got: libc::c_int = 0;
    fd =
        robust_open(b"/dev/urandom\x00" as *const u8 as *const libc::c_char,
                    0 as libc::c_int, 0 as libc::c_int as mode_t);
    if fd < 0 as libc::c_int {
        let mut t: time_t = 0;
        time(&mut t);
        memcpy(zBuf as *mut libc::c_void,
               &mut t as *mut time_t as *const libc::c_void,
               ::std::mem::size_of::<time_t>() as libc::c_ulong);
        memcpy(&mut *zBuf.offset(::std::mem::size_of::<time_t>() as
                                     libc::c_ulong as isize) as
                   *mut libc::c_char as *mut libc::c_void,
               &mut randomnessPid as *mut pid_t as *const libc::c_void,
               ::std::mem::size_of::<pid_t>() as libc::c_ulong);
        nBuf =
            (::std::mem::size_of::<time_t>() as
                 libc::c_ulong).wrapping_add(::std::mem::size_of::<pid_t>() as
                                                 libc::c_ulong) as libc::c_int
    } else {
        loop  {
            got =
                ::std::mem::transmute::<sqlite3_syscall_ptr,
                                        Option<unsafe extern "C" fn(_:
                                                                        libc::c_int,
                                                                    _:
                                                                        *mut libc::c_void,
                                                                    _: size_t)
                                                   ->
                                                       ssize_t>>(aSyscall[8 as
                                                                              libc::c_int
                                                                              as
                                                                              usize].pCurrent).expect("non-null function pointer")(fd,
                                                                                                                                   zBuf
                                                                                                                                       as
                                                                                                                                       *mut libc::c_void,
                                                                                                                                   nBuf
                                                                                                                                       as
                                                                                                                                       size_t)
                    as libc::c_int;
            if !(got < 0 as libc::c_int &&
                     *__errno_location() == 4 as libc::c_int) {
                break ;
            }
        }
        robust_close(0 as *mut unixFile, fd, 39980 as libc::c_int);
    }
    return nBuf;
}
unsafe extern "C" fn unixSleep(mut NotUsed: *mut sqlite3_vfs,
                               mut microseconds: libc::c_int) -> libc::c_int {
    let mut seconds: libc::c_int =
        (microseconds + 999999 as libc::c_int) / 1000000 as libc::c_int;
    sleep(seconds as libc::c_uint);
    return seconds * 1000000 as libc::c_int;
}
unsafe extern "C" fn unixCurrentTimeInt64(mut NotUsed: *mut sqlite3_vfs,
                                          mut piNow: *mut sqlite3_int64)
 -> libc::c_int {
    static mut unixEpoch: sqlite3_int64 =
        24405875 as libc::c_int as libc::c_longlong *
            8640000 as libc::c_int as sqlite3_int64;
    let mut rc: libc::c_int = 0 as libc::c_int;
    let mut sNow: timeval = timeval{tv_sec: 0, tv_usec: 0,};
    gettimeofday(&mut sNow, 0 as *mut timezone);
    *piNow =
        unixEpoch +
            1000 as libc::c_int as libc::c_longlong *
                sNow.tv_sec as sqlite3_int64 +
            (sNow.tv_usec / 1000 as libc::c_int as libc::c_long) as
                libc::c_longlong;
    return rc;
}
unsafe extern "C" fn unixCurrentTime(mut NotUsed: *mut sqlite3_vfs,
                                     mut prNow: *mut libc::c_double)
 -> libc::c_int {
    let mut i: sqlite3_int64 = 0 as libc::c_int as sqlite3_int64;
    let mut rc: libc::c_int = 0;
    rc = unixCurrentTimeInt64(0 as *mut sqlite3_vfs, &mut i);
    *prNow = i as libc::c_double / 86400000.0f64;
    return rc;
}
unsafe extern "C" fn unixGetLastError(mut NotUsed: *mut sqlite3_vfs,
                                      mut NotUsed2: libc::c_int,
                                      mut NotUsed3: *mut libc::c_char)
 -> libc::c_int {
    return *__errno_location();
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_os_init() -> libc::c_int {
    static mut aVfs: [sqlite3_vfs; 4] =
        unsafe {
            [{
                 let mut init =
                     sqlite3_vfs{iVersion: 3 as libc::c_int,
                                 szOsFile:
                                     ::std::mem::size_of::<unixFile>() as
                                         libc::c_ulong as libc::c_int,
                                 mxPathname: 512 as libc::c_int,
                                 pNext:
                                     0 as *const sqlite3_vfs as
                                         *mut sqlite3_vfs,
                                 zName:
                                     b"unix\x00" as *const u8 as
                                         *const libc::c_char,
                                 pAppData:
                                     &posixIoFinder as
                                         *const Option<unsafe extern "C" fn(_:
                                                                                *const libc::c_char,
                                                                            _:
                                                                                *mut unixFile)
                                                           ->
                                                               *const sqlite3_io_methods>
                                         as *mut libc::c_void,
                                 xOpen:
                                     Some(unixOpen as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       *mut sqlite3_file,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_int)
                                                  -> libc::c_int),
                                 xDelete:
                                     Some(unixDelete as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int)
                                                  -> libc::c_int),
                                 xAccess:
                                     Some(unixAccess as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_int)
                                                  -> libc::c_int),
                                 xFullPathname:
                                     Some(unixFullPathname as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> libc::c_int),
                                 xDlOpen:
                                     Some(unixDlOpen as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char)
                                                  -> *mut libc::c_void),
                                 xDlError:
                                     Some(unixDlError as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> ()),
                                 xDlSym:
                                     Some(unixDlSym as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut libc::c_void,
                                                                   _:
                                                                       *const libc::c_char)
                                                  ->
                                                      Option<unsafe extern "C" fn()
                                                                 -> ()>),
                                 xDlClose:
                                     Some(unixDlClose as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut libc::c_void)
                                                  -> ()),
                                 xRandomness:
                                     Some(unixRandomness as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> libc::c_int),
                                 xSleep:
                                     Some(unixSleep as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int)
                                                  -> libc::c_int),
                                 xCurrentTime:
                                     Some(unixCurrentTime as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut libc::c_double)
                                                  -> libc::c_int),
                                 xGetLastError:
                                     Some(unixGetLastError as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> libc::c_int),
                                 xCurrentTimeInt64:
                                     Some(unixCurrentTimeInt64 as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut sqlite3_int64)
                                                  -> libc::c_int),
                                 xSetSystemCall:
                                     Some(unixSetSystemCall as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       sqlite3_syscall_ptr)
                                                  -> libc::c_int),
                                 xGetSystemCall:
                                     Some(unixGetSystemCall as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char)
                                                  -> sqlite3_syscall_ptr),
                                 xNextSystemCall:
                                     Some(unixNextSystemCall as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char)
                                                  -> *const libc::c_char),};
                 init
             },
             {
                 let mut init =
                     sqlite3_vfs{iVersion: 3 as libc::c_int,
                                 szOsFile:
                                     ::std::mem::size_of::<unixFile>() as
                                         libc::c_ulong as libc::c_int,
                                 mxPathname: 512 as libc::c_int,
                                 pNext:
                                     0 as *const sqlite3_vfs as
                                         *mut sqlite3_vfs,
                                 zName:
                                     b"unix-none\x00" as *const u8 as
                                         *const libc::c_char,
                                 pAppData:
                                     &nolockIoFinder as
                                         *const Option<unsafe extern "C" fn(_:
                                                                                *const libc::c_char,
                                                                            _:
                                                                                *mut unixFile)
                                                           ->
                                                               *const sqlite3_io_methods>
                                         as *mut libc::c_void,
                                 xOpen:
                                     Some(unixOpen as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       *mut sqlite3_file,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_int)
                                                  -> libc::c_int),
                                 xDelete:
                                     Some(unixDelete as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int)
                                                  -> libc::c_int),
                                 xAccess:
                                     Some(unixAccess as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_int)
                                                  -> libc::c_int),
                                 xFullPathname:
                                     Some(unixFullPathname as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> libc::c_int),
                                 xDlOpen:
                                     Some(unixDlOpen as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char)
                                                  -> *mut libc::c_void),
                                 xDlError:
                                     Some(unixDlError as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> ()),
                                 xDlSym:
                                     Some(unixDlSym as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut libc::c_void,
                                                                   _:
                                                                       *const libc::c_char)
                                                  ->
                                                      Option<unsafe extern "C" fn()
                                                                 -> ()>),
                                 xDlClose:
                                     Some(unixDlClose as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut libc::c_void)
                                                  -> ()),
                                 xRandomness:
                                     Some(unixRandomness as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> libc::c_int),
                                 xSleep:
                                     Some(unixSleep as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int)
                                                  -> libc::c_int),
                                 xCurrentTime:
                                     Some(unixCurrentTime as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut libc::c_double)
                                                  -> libc::c_int),
                                 xGetLastError:
                                     Some(unixGetLastError as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> libc::c_int),
                                 xCurrentTimeInt64:
                                     Some(unixCurrentTimeInt64 as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut sqlite3_int64)
                                                  -> libc::c_int),
                                 xSetSystemCall:
                                     Some(unixSetSystemCall as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       sqlite3_syscall_ptr)
                                                  -> libc::c_int),
                                 xGetSystemCall:
                                     Some(unixGetSystemCall as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char)
                                                  -> sqlite3_syscall_ptr),
                                 xNextSystemCall:
                                     Some(unixNextSystemCall as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char)
                                                  -> *const libc::c_char),};
                 init
             },
             {
                 let mut init =
                     sqlite3_vfs{iVersion: 3 as libc::c_int,
                                 szOsFile:
                                     ::std::mem::size_of::<unixFile>() as
                                         libc::c_ulong as libc::c_int,
                                 mxPathname: 512 as libc::c_int,
                                 pNext:
                                     0 as *const sqlite3_vfs as
                                         *mut sqlite3_vfs,
                                 zName:
                                     b"unix-dotfile\x00" as *const u8 as
                                         *const libc::c_char,
                                 pAppData:
                                     &dotlockIoFinder as
                                         *const Option<unsafe extern "C" fn(_:
                                                                                *const libc::c_char,
                                                                            _:
                                                                                *mut unixFile)
                                                           ->
                                                               *const sqlite3_io_methods>
                                         as *mut libc::c_void,
                                 xOpen:
                                     Some(unixOpen as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       *mut sqlite3_file,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_int)
                                                  -> libc::c_int),
                                 xDelete:
                                     Some(unixDelete as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int)
                                                  -> libc::c_int),
                                 xAccess:
                                     Some(unixAccess as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_int)
                                                  -> libc::c_int),
                                 xFullPathname:
                                     Some(unixFullPathname as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> libc::c_int),
                                 xDlOpen:
                                     Some(unixDlOpen as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char)
                                                  -> *mut libc::c_void),
                                 xDlError:
                                     Some(unixDlError as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> ()),
                                 xDlSym:
                                     Some(unixDlSym as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut libc::c_void,
                                                                   _:
                                                                       *const libc::c_char)
                                                  ->
                                                      Option<unsafe extern "C" fn()
                                                                 -> ()>),
                                 xDlClose:
                                     Some(unixDlClose as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut libc::c_void)
                                                  -> ()),
                                 xRandomness:
                                     Some(unixRandomness as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> libc::c_int),
                                 xSleep:
                                     Some(unixSleep as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int)
                                                  -> libc::c_int),
                                 xCurrentTime:
                                     Some(unixCurrentTime as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut libc::c_double)
                                                  -> libc::c_int),
                                 xGetLastError:
                                     Some(unixGetLastError as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> libc::c_int),
                                 xCurrentTimeInt64:
                                     Some(unixCurrentTimeInt64 as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut sqlite3_int64)
                                                  -> libc::c_int),
                                 xSetSystemCall:
                                     Some(unixSetSystemCall as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       sqlite3_syscall_ptr)
                                                  -> libc::c_int),
                                 xGetSystemCall:
                                     Some(unixGetSystemCall as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char)
                                                  -> sqlite3_syscall_ptr),
                                 xNextSystemCall:
                                     Some(unixNextSystemCall as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char)
                                                  -> *const libc::c_char),};
                 init
             },
             {
                 let mut init =
                     sqlite3_vfs{iVersion: 3 as libc::c_int,
                                 szOsFile:
                                     ::std::mem::size_of::<unixFile>() as
                                         libc::c_ulong as libc::c_int,
                                 mxPathname: 512 as libc::c_int,
                                 pNext:
                                     0 as *const sqlite3_vfs as
                                         *mut sqlite3_vfs,
                                 zName:
                                     b"unix-excl\x00" as *const u8 as
                                         *const libc::c_char,
                                 pAppData:
                                     &posixIoFinder as
                                         *const Option<unsafe extern "C" fn(_:
                                                                                *const libc::c_char,
                                                                            _:
                                                                                *mut unixFile)
                                                           ->
                                                               *const sqlite3_io_methods>
                                         as *mut libc::c_void,
                                 xOpen:
                                     Some(unixOpen as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       *mut sqlite3_file,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_int)
                                                  -> libc::c_int),
                                 xDelete:
                                     Some(unixDelete as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int)
                                                  -> libc::c_int),
                                 xAccess:
                                     Some(unixAccess as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_int)
                                                  -> libc::c_int),
                                 xFullPathname:
                                     Some(unixFullPathname as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> libc::c_int),
                                 xDlOpen:
                                     Some(unixDlOpen as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char)
                                                  -> *mut libc::c_void),
                                 xDlError:
                                     Some(unixDlError as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> ()),
                                 xDlSym:
                                     Some(unixDlSym as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut libc::c_void,
                                                                   _:
                                                                       *const libc::c_char)
                                                  ->
                                                      Option<unsafe extern "C" fn()
                                                                 -> ()>),
                                 xDlClose:
                                     Some(unixDlClose as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut libc::c_void)
                                                  -> ()),
                                 xRandomness:
                                     Some(unixRandomness as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> libc::c_int),
                                 xSleep:
                                     Some(unixSleep as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int)
                                                  -> libc::c_int),
                                 xCurrentTime:
                                     Some(unixCurrentTime as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut libc::c_double)
                                                  -> libc::c_int),
                                 xGetLastError:
                                     Some(unixGetLastError as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       libc::c_int,
                                                                   _:
                                                                       *mut libc::c_char)
                                                  -> libc::c_int),
                                 xCurrentTimeInt64:
                                     Some(unixCurrentTimeInt64 as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *mut sqlite3_int64)
                                                  -> libc::c_int),
                                 xSetSystemCall:
                                     Some(unixSetSystemCall as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char,
                                                                   _:
                                                                       sqlite3_syscall_ptr)
                                                  -> libc::c_int),
                                 xGetSystemCall:
                                     Some(unixGetSystemCall as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char)
                                                  -> sqlite3_syscall_ptr),
                                 xNextSystemCall:
                                     Some(unixNextSystemCall as
                                              unsafe extern "C" fn(_:
                                                                       *mut sqlite3_vfs,
                                                                   _:
                                                                       *const libc::c_char)
                                                  -> *const libc::c_char),};
                 init
             }]
        };
    let mut i: libc::c_uint = 0;
    i = 0 as libc::c_int as libc::c_uint;
    while (i as libc::c_ulong) <
              (::std::mem::size_of::<[sqlite3_vfs; 4]>() as
                   libc::c_ulong).wrapping_div(::std::mem::size_of::<sqlite3_vfs>()
                                                   as libc::c_ulong) {
        sqlite3_vfs_register(&mut *aVfs.as_mut_ptr().offset(i as isize),
                             (i == 0 as libc::c_int as libc::c_uint) as
                                 libc::c_int);
        i = i.wrapping_add(1)
    }
    unixBigLock = sqlite3MutexAlloc(11 as libc::c_int);
    return 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn sqlite3_os_end() -> libc::c_int {
    unixBigLock = 0 as *mut sqlite3_mutex;
    return 0 as libc::c_int;
}
unsafe extern "C" fn sqlite3BitvecCreate(mut iSize: u32_0) -> *mut Bitvec {
    let mut p: *mut Bitvec = 0 as *mut Bitvec;
    p =
        sqlite3MallocZero(::std::mem::size_of::<Bitvec>() as libc::c_ulong as
                              u64_0) as *mut Bitvec;
    if !p.is_null() { (*p).iSize = iSize }
    return p;
}
unsafe extern "C" fn sqlite3BitvecTestNotNull(mut p: *mut Bitvec,
                                              mut i: u32_0) -> libc::c_int {
    i = i.wrapping_sub(1);
    if i >= (*p).iSize { return 0 as libc::c_int }
    while (*p).iDivisor != 0 {
        let mut bin: u32_0 = i.wrapping_div((*p).iDivisor);
        i = i.wrapping_rem((*p).iDivisor);
        p = (*p).u.apSub[bin as usize];
        if p.is_null() { return 0 as libc::c_int }
    }
    if (*p).iSize as libc::c_ulong <=
           (512 as libc::c_int as
                libc::c_ulong).wrapping_sub((3 as libc::c_int as
                                                 libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                 as
                                                                                 libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                  as
                                                                                                                  libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                  as
                                                                                                                                                  libc::c_ulong).wrapping_div(::std::mem::size_of::<u8_0>()
                                                                                                                                                                                  as
                                                                                                                                                                                  libc::c_ulong).wrapping_mul(8
                                                                                                                                                                                                                  as
                                                                                                                                                                                                                  libc::c_int
                                                                                                                                                                                                                  as
                                                                                                                                                                                                                  libc::c_ulong)
       {
        return ((*p).u.aBitmap[i.wrapping_div(8 as libc::c_int as
                                                  libc::c_uint) as usize] as
                    libc::c_int &
                    (1 as libc::c_int) <<
                        (i &
                             (8 as libc::c_int - 1 as libc::c_int) as
                                 libc::c_uint) != 0 as libc::c_int) as
                   libc::c_int
    } else {
        let fresh104 = i;
        i = i.wrapping_add(1);
        let mut h: u32_0 =
            (fresh104.wrapping_mul(1 as libc::c_int as libc::c_uint) as
                 libc::c_ulong).wrapping_rem((512 as libc::c_int as
                                                  libc::c_ulong).wrapping_sub((3
                                                                                   as
                                                                                   libc::c_int
                                                                                   as
                                                                                   libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                                                   as
                                                                                                                   libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                    as
                                                                                                                                                    libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                                                    as
                                                                                                                                                                                    libc::c_ulong).wrapping_div(::std::mem::size_of::<u32_0>()
                                                                                                                                                                                                                    as
                                                                                                                                                                                                                    libc::c_ulong))
                as u32_0;
        while (*p).u.aHash[h as usize] != 0 {
            if (*p).u.aHash[h as usize] == i { return 1 as libc::c_int }
            h =
                (h.wrapping_add(1 as libc::c_int as libc::c_uint) as
                     libc::c_ulong).wrapping_rem((512 as libc::c_int as
                                                      libc::c_ulong).wrapping_sub((3
                                                                                       as
                                                                                       libc::c_int
                                                                                       as
                                                                                       libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                                                       as
                                                                                                                       libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                        as
                                                                                                                                                        libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                                                        as
                                                                                                                                                                                        libc::c_ulong).wrapping_div(::std::mem::size_of::<u32_0>()
                                                                                                                                                                                                                        as
                                                                                                                                                                                                                        libc::c_ulong))
                    as u32_0
        }
        return 0 as libc::c_int
    };
}
unsafe extern "C" fn sqlite3BitvecTest(mut p: *mut Bitvec, mut i: u32_0)
 -> libc::c_int {
    return (!p.is_null() && sqlite3BitvecTestNotNull(p, i) != 0) as
               libc::c_int;
}
unsafe extern "C" fn sqlite3BitvecSet(mut p: *mut Bitvec, mut i: u32_0)
 -> libc::c_int {
    let mut current_block: u64;
    let mut h: u32_0 = 0;
    if p.is_null() { return 0 as libc::c_int }
    i = i.wrapping_sub(1);
    while (*p).iSize as libc::c_ulong >
              (512 as libc::c_int as
                   libc::c_ulong).wrapping_sub((3 as libc::c_int as
                                                    libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                    as
                                                                                    libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                     as
                                                                                                                     libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                     as
                                                                                                                                                     libc::c_ulong).wrapping_div(::std::mem::size_of::<u8_0>()
                                                                                                                                                                                     as
                                                                                                                                                                                     libc::c_ulong).wrapping_mul(8
                                                                                                                                                                                                                     as
                                                                                                                                                                                                                     libc::c_int
                                                                                                                                                                                                                     as
                                                                                                                                                                                                                     libc::c_ulong)
              && (*p).iDivisor != 0 {
        let mut bin: u32_0 = i.wrapping_div((*p).iDivisor);
        i = i.wrapping_rem((*p).iDivisor);
        if (*p).u.apSub[bin as usize].is_null() {
            (*p).u.apSub[bin as usize] = sqlite3BitvecCreate((*p).iDivisor);
            if (*p).u.apSub[bin as usize].is_null() {
                return 7 as libc::c_int
            }
        }
        p = (*p).u.apSub[bin as usize]
    }
    if (*p).iSize as libc::c_ulong <=
           (512 as libc::c_int as
                libc::c_ulong).wrapping_sub((3 as libc::c_int as
                                                 libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                 as
                                                                                 libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                  as
                                                                                                                  libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                  as
                                                                                                                                                  libc::c_ulong).wrapping_div(::std::mem::size_of::<u8_0>()
                                                                                                                                                                                  as
                                                                                                                                                                                  libc::c_ulong).wrapping_mul(8
                                                                                                                                                                                                                  as
                                                                                                                                                                                                                  libc::c_int
                                                                                                                                                                                                                  as
                                                                                                                                                                                                                  libc::c_ulong)
       {
        (*p).u.aBitmap[i.wrapping_div(8 as libc::c_int as libc::c_uint) as
                           usize] =
            ((*p).u.aBitmap[i.wrapping_div(8 as libc::c_int as libc::c_uint)
                                as usize] as libc::c_int |
                 (1 as libc::c_int) <<
                     (i &
                          (8 as libc::c_int - 1 as libc::c_int) as
                              libc::c_uint)) as u8_0;
        return 0 as libc::c_int
    }
    let fresh105 = i;
    i = i.wrapping_add(1);
    h =
        (fresh105.wrapping_mul(1 as libc::c_int as libc::c_uint) as
             libc::c_ulong).wrapping_rem((512 as libc::c_int as
                                              libc::c_ulong).wrapping_sub((3
                                                                               as
                                                                               libc::c_int
                                                                               as
                                                                               libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                                               as
                                                                                                               libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                as
                                                                                                                                                libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                                                as
                                                                                                                                                                                libc::c_ulong).wrapping_div(::std::mem::size_of::<u32_0>()
                                                                                                                                                                                                                as
                                                                                                                                                                                                                libc::c_ulong))
            as u32_0;
    if (*p).u.aHash[h as usize] == 0 {
        if ((*p).nSet as libc::c_ulong) <
               (512 as libc::c_int as
                    libc::c_ulong).wrapping_sub((3 as libc::c_int as
                                                     libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                     as
                                                                                     libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                      as
                                                                                                                      libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                      as
                                                                                                                                                      libc::c_ulong).wrapping_div(::std::mem::size_of::<u32_0>()
                                                                                                                                                                                      as
                                                                                                                                                                                      libc::c_ulong).wrapping_sub(1
                                                                                                                                                                                                                      as
                                                                                                                                                                                                                      libc::c_int
                                                                                                                                                                                                                      as
                                                                                                                                                                                                                      libc::c_ulong)
           {
            current_block = 15325006274910139791;
        } else { current_block = 13908709514835533010; }
    } else {
        loop  {
            if (*p).u.aHash[h as usize] == i { return 0 as libc::c_int }
            h = h.wrapping_add(1);
            if h as libc::c_ulong >=
                   (512 as libc::c_int as
                        libc::c_ulong).wrapping_sub((3 as libc::c_int as
                                                         libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                         as
                                                                                         libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                          as
                                                                                                                          libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                          as
                                                                                                                                                          libc::c_ulong).wrapping_div(::std::mem::size_of::<u32_0>()
                                                                                                                                                                                          as
                                                                                                                                                                                          libc::c_ulong)
               {
                h = 0 as libc::c_int as u32_0
            }
            if !((*p).u.aHash[h as usize] != 0) { break ; }
        }
        current_block = 13908709514835533010;
    }
    match current_block {
        13908709514835533010 => {
            if (*p).nSet as libc::c_ulong >=
                   (512 as libc::c_int as
                        libc::c_ulong).wrapping_sub((3 as libc::c_int as
                                                         libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                         as
                                                                                         libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                          as
                                                                                                                          libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                          as
                                                                                                                                                          libc::c_ulong).wrapping_div(::std::mem::size_of::<u32_0>()
                                                                                                                                                                                          as
                                                                                                                                                                                          libc::c_ulong).wrapping_div(2
                                                                                                                                                                                                                          as
                                                                                                                                                                                                                          libc::c_int
                                                                                                                                                                                                                          as
                                                                                                                                                                                                                          libc::c_ulong)
               {
                let mut j: libc::c_uint = 0;
                let mut rc: libc::c_int = 0;
                let mut aiValues: *mut u32_0 =
                    sqlite3DbMallocRaw(0 as *mut sqlite3,
                                       ::std::mem::size_of::<[u32_0; 124]>()
                                           as libc::c_ulong as u64_0) as
                        *mut u32_0;
                if aiValues.is_null() {
                    return 7 as libc::c_int
                } else {
                    memcpy(aiValues as *mut libc::c_void,
                           (*p).u.aHash.as_mut_ptr() as *const libc::c_void,
                           ::std::mem::size_of::<[u32_0; 124]>() as
                               libc::c_ulong);
                    memset((*p).u.apSub.as_mut_ptr() as *mut libc::c_void,
                           0 as libc::c_int,
                           ::std::mem::size_of::<[*mut Bitvec; 62]>() as
                               libc::c_ulong);
                    (*p).iDivisor =
                        ((*p).iSize as
                             libc::c_ulong).wrapping_add((512 as libc::c_int
                                                              as
                                                              libc::c_ulong).wrapping_sub((3
                                                                                               as
                                                                                               libc::c_int
                                                                                               as
                                                                                               libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                                                               as
                                                                                                                               libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                                as
                                                                                                                                                                libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                                                                as
                                                                                                                                                                                                libc::c_ulong).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                                                                                                as
                                                                                                                                                                                                                                libc::c_ulong)).wrapping_sub(1
                                                                                                                                                                                                                                                                 as
                                                                                                                                                                                                                                                                 libc::c_int
                                                                                                                                                                                                                                                                 as
                                                                                                                                                                                                                                                                 libc::c_ulong).wrapping_div((512
                                                                                                                                                                                                                                                                                                  as
                                                                                                                                                                                                                                                                                                  libc::c_int
                                                                                                                                                                                                                                                                                                  as
                                                                                                                                                                                                                                                                                                  libc::c_ulong).wrapping_sub((3
                                                                                                                                                                                                                                                                                                                                   as
                                                                                                                                                                                                                                                                                                                                   libc::c_int
                                                                                                                                                                                                                                                                                                                                   as
                                                                                                                                                                                                                                                                                                                                   libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                                                                                                                                                                                                                                                                                                   as
                                                                                                                                                                                                                                                                                                                                                                   libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                                                                                                                                                                                                                                                                    as
                                                                                                                                                                                                                                                                                                                                                                                                    libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                                                                                                                                                                                                                                                                                                    as
                                                                                                                                                                                                                                                                                                                                                                                                                                    libc::c_ulong).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    as
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    libc::c_ulong))
                            as u32_0;
                    rc = sqlite3BitvecSet(p, i);
                    j = 0 as libc::c_int as libc::c_uint;
                    while (j as libc::c_ulong) <
                              (512 as libc::c_int as
                                   libc::c_ulong).wrapping_sub((3 as
                                                                    libc::c_int
                                                                    as
                                                                    libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                                    as
                                                                                                    libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                     as
                                                                                                                                     libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                                     as
                                                                                                                                                                     libc::c_ulong).wrapping_div(::std::mem::size_of::<u32_0>()
                                                                                                                                                                                                     as
                                                                                                                                                                                                     libc::c_ulong)
                          {
                        if *aiValues.offset(j as isize) != 0 {
                            rc |=
                                sqlite3BitvecSet(p,
                                                 *aiValues.offset(j as isize))
                        }
                        j = j.wrapping_add(1)
                    }
                    sqlite3DbFree(0 as *mut sqlite3,
                                  aiValues as *mut libc::c_void);
                    return rc
                }
            }
        }
        _ => { }
    }
    (*p).nSet = (*p).nSet.wrapping_add(1);
    (*p).u.aHash[h as usize] = i;
    return 0 as libc::c_int;
}
unsafe extern "C" fn sqlite3BitvecClear(mut p: *mut Bitvec, mut i: u32_0,
                                        mut pBuf: *mut libc::c_void) {
    if p.is_null() { return }
    i = i.wrapping_sub(1);
    while (*p).iDivisor != 0 {
        let mut bin: u32_0 = i.wrapping_div((*p).iDivisor);
        i = i.wrapping_rem((*p).iDivisor);
        p = (*p).u.apSub[bin as usize];
        if p.is_null() { return }
    }
    if (*p).iSize as libc::c_ulong <=
           (512 as libc::c_int as
                libc::c_ulong).wrapping_sub((3 as libc::c_int as
                                                 libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                 as
                                                                                 libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                  as
                                                                                                                  libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                  as
                                                                                                                                                  libc::c_ulong).wrapping_div(::std::mem::size_of::<u8_0>()
                                                                                                                                                                                  as
                                                                                                                                                                                  libc::c_ulong).wrapping_mul(8
                                                                                                                                                                                                                  as
                                                                                                                                                                                                                  libc::c_int
                                                                                                                                                                                                                  as
                                                                                                                                                                                                                  libc::c_ulong)
       {
        (*p).u.aBitmap[i.wrapping_div(8 as libc::c_int as libc::c_uint) as
                           usize] =
            ((*p).u.aBitmap[i.wrapping_div(8 as libc::c_int as libc::c_uint)
                                as usize] as libc::c_int &
                 !((1 as libc::c_int) <<
                       (i &
                            (8 as libc::c_int - 1 as libc::c_int) as
                                libc::c_uint))) as u8_0
    } else {
        let mut j: libc::c_uint = 0;
        let mut aiValues: *mut u32_0 = pBuf as *mut u32_0;
        memcpy(aiValues as *mut libc::c_void,
               (*p).u.aHash.as_mut_ptr() as *const libc::c_void,
               ::std::mem::size_of::<[u32_0; 124]>() as libc::c_ulong);
        memset((*p).u.aHash.as_mut_ptr() as *mut libc::c_void,
               0 as libc::c_int,
               ::std::mem::size_of::<[u32_0; 124]>() as libc::c_ulong);
        (*p).nSet = 0 as libc::c_int as u32_0;
        j = 0 as libc::c_int as libc::c_uint;
        while (j as libc::c_ulong) <
                  (512 as libc::c_int as
                       libc::c_ulong).wrapping_sub((3 as libc::c_int as
                                                        libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                        as
                                                                                        libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                         as
                                                                                                                         libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                         as
                                                                                                                                                         libc::c_ulong).wrapping_div(::std::mem::size_of::<u32_0>()
                                                                                                                                                                                         as
                                                                                                                                                                                         libc::c_ulong)
              {
            if *aiValues.offset(j as isize) != 0 &&
                   *aiValues.offset(j as isize) !=
                       i.wrapping_add(1 as libc::c_int as libc::c_uint) {
                let mut h: u32_0 =
                    ((*aiValues.offset(j as
                                           isize)).wrapping_sub(1 as
                                                                    libc::c_int
                                                                    as
                                                                    libc::c_uint).wrapping_mul(1
                                                                                                   as
                                                                                                   libc::c_int
                                                                                                   as
                                                                                                   libc::c_uint)
                         as
                         libc::c_ulong).wrapping_rem((512 as libc::c_int as
                                                          libc::c_ulong).wrapping_sub((3
                                                                                           as
                                                                                           libc::c_int
                                                                                           as
                                                                                           libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                                                           as
                                                                                                                           libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                            as
                                                                                                                                                            libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                                                            as
                                                                                                                                                                                            libc::c_ulong).wrapping_div(::std::mem::size_of::<u32_0>()
                                                                                                                                                                                                                            as
                                                                                                                                                                                                                            libc::c_ulong))
                        as u32_0;
                (*p).nSet = (*p).nSet.wrapping_add(1);
                while (*p).u.aHash[h as usize] != 0 {
                    h = h.wrapping_add(1);
                    if h as libc::c_ulong >=
                           (512 as libc::c_int as
                                libc::c_ulong).wrapping_sub((3 as libc::c_int
                                                                 as
                                                                 libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                                 as
                                                                                                 libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                  as
                                                                                                                                  libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                                  as
                                                                                                                                                                  libc::c_ulong).wrapping_div(::std::mem::size_of::<u32_0>()
                                                                                                                                                                                                  as
                                                                                                                                                                                                  libc::c_ulong)
                       {
                        h = 0 as libc::c_int as u32_0
                    }
                }
                (*p).u.aHash[h as usize] = *aiValues.offset(j as isize)
            }
            j = j.wrapping_add(1)
        }
    };
}
unsafe extern "C" fn sqlite3BitvecDestroy(mut p: *mut Bitvec) {
    if p.is_null() { return }
    if (*p).iDivisor != 0 {
        let mut i: libc::c_uint = 0;
        i = 0 as libc::c_int as libc::c_uint;
        while (i as libc::c_ulong) <
                  (512 as libc::c_int as
                       libc::c_ulong).wrapping_sub((3 as libc::c_int as
                                                        libc::c_ulong).wrapping_mul(::std::mem::size_of::<u32_0>()
                                                                                        as
                                                                                        libc::c_ulong)).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                         as
                                                                                                                         libc::c_ulong).wrapping_mul(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                         as
                                                                                                                                                         libc::c_ulong).wrapping_div(::std::mem::size_of::<*mut Bitvec>()
                                                                                                                                                                                         as
                                                                                                                                                                                         libc::c_ulong)
              {
            sqlite3BitvecDestroy((*p).u.apSub[i as usize]);
            i = i.wrapping_add(1)
        }
    }
    sqlite3_free(p as *mut libc::c_void);
}
unsafe extern "C" fn sqlite3BitvecSize(mut p: *mut Bitvec) -> u32_0 {
    return (*p).iSize;
}
unsafe extern "C" fn sqlite3BitvecBuiltinTest(mut sz: libc::c_int,
                                              mut aOp: *mut libc::c_int)
 -> libc::c_int {
    let mut current_block: u64;
    let mut pBitvec: *mut Bitvec = 0 as *mut Bitvec;
    let mut pV: *mut libc::c_uchar = 0 as *mut libc::c_uchar;
    let mut rc: libc::c_int = -(1 as libc::c_int);
    let mut i: libc::c_int = 0;
    let mut nx: libc::c_int = 0;
    let mut pc: libc::c_int = 0;
    let mut op: libc::c_int = 0;
    let mut pTmpSpace: *mut libc::c_void = 0 as *mut libc::c_void;
    pBitvec = sqlite3BitvecCreate(sz as u32_0);
    pV =
        sqlite3MallocZero(((sz + 7 as libc::c_int) / 8 as libc::c_int +
                               1 as libc::c_int) as u64_0) as
            *mut libc::c_uchar;
    pTmpSpace = sqlite3_malloc64(512 as libc::c_int as sqlite3_uint64);
    if !(pBitvec.is_null() || pV.is_null() || pTmpSpace.is_null()) {
        sqlite3BitvecSet(0 as *mut Bitvec, 1 as libc::c_int as u32_0);
        sqlite3BitvecClear(0 as *mut Bitvec, 1 as libc::c_int as u32_0,
                           pTmpSpace);
        pc = 0 as libc::c_int;
        loop  {
            op = *aOp.offset(pc as isize);
            if !(op != 0 as libc::c_int) {
                current_block = 8693738493027456495;
                break ;
            }
            match op {
                1 | 2 | 5 => {
                    nx = 4 as libc::c_int;
                    i =
                        *aOp.offset((pc + 2 as libc::c_int) as isize) -
                            1 as libc::c_int;
                    *aOp.offset((pc + 2 as libc::c_int) as isize) +=
                        *aOp.offset((pc + 3 as libc::c_int) as isize)
                }
                3 | 4 | _ => {
                    nx = 2 as libc::c_int;
                    sqlite3_randomness(::std::mem::size_of::<libc::c_int>() as
                                           libc::c_ulong as libc::c_int,
                                       &mut i as *mut libc::c_int as
                                           *mut libc::c_void);
                }
            }
            let ref mut fresh106 =
                *aOp.offset((pc + 1 as libc::c_int) as isize);
            *fresh106 -= 1;
            if *fresh106 > 0 as libc::c_int { nx = 0 as libc::c_int }
            pc += nx;
            i = (i & 0x7fffffff as libc::c_int) % sz;
            if op & 1 as libc::c_int != 0 as libc::c_int {
                let ref mut fresh107 =
                    *pV.offset((i + 1 as libc::c_int >> 3 as libc::c_int) as
                                   isize);
                *fresh107 =
                    (*fresh107 as libc::c_int |
                         (1 as libc::c_int) <<
                             (i + 1 as libc::c_int & 7 as libc::c_int)) as
                        libc::c_uchar;
                if !(op != 5 as libc::c_int) { continue ; }
                if sqlite3BitvecSet(pBitvec, (i + 1 as libc::c_int) as u32_0)
                       != 0 {
                    current_block = 8682447778599044194;
                    break ;
                }
            } else {
                let ref mut fresh108 =
                    *pV.offset((i + 1 as libc::c_int >> 3 as libc::c_int) as
                                   isize);
                *fresh108 =
                    (*fresh108 as libc::c_int &
                         !((1 as libc::c_int) <<
                               (i + 1 as libc::c_int & 7 as libc::c_int))) as
                        libc::c_uchar;
                sqlite3BitvecClear(pBitvec, (i + 1 as libc::c_int) as u32_0,
                                   pTmpSpace);
            }
        }
        match current_block {
            8682447778599044194 => { }
            _ => {
                rc =
                    ((sqlite3BitvecTest(0 as *mut Bitvec,
                                        0 as libc::c_int as u32_0) +
                          sqlite3BitvecTest(pBitvec,
                                            (sz + 1 as libc::c_int) as u32_0)
                          +
                          sqlite3BitvecTest(pBitvec,
                                            0 as libc::c_int as u32_