#pragma once

#ifdef __NetBSD__
#  include "pal_bsd_aligned.h"

#  include <fcntl.h>

namespace snmalloc
{
  /**
   * NetBSD-specific platform abstraction layer.
   *
   * This adds NetBSD-specific aligned allocation to the generic BSD
   * implementation.
   */
  class PALNetBSD : public PALBSD_Aligned<PALNetBSD>
  {
  public:
    /**
     * Bitmap of PalFeatures flags indicating the optional features that this
     * PAL supports.
     *
     * The NetBSD PAL does not currently add any features beyond those of a
     * generic BSD with support for arbitrary alignment from `mmap`.  This
     * field is declared explicitly to remind anyone modifying this class to
     * add new features that they should add any required feature flags.
     *
     * As NetBSD does not have the getentropy call, get_entropy64 will
     * currently fallback to C++ libraries std::random_device.
     */
    static constexpr uint64_t pal_features =
      PALBSD_Aligned::pal_features | Entropy;

    /**
     * Temporary solution while waiting getrandom support for the next release
     * random_device seems unimplemented in clang for this platform
     */
    static uint64_t get_entropy64()
    {
      return PALPOSIX::dev_urandom();
    }
  };
} // namespace snmalloc
#endif
