set(CMAKE_SYSTEM_NAME Linux)
set(CMAKE_SYSTEM_PROCESSOR $ENV{ARCH})

set(triple $ENV{TRIPLE})

set(CMAKE_C_COMPILER clang-13)
set(CMAKE_C_COMPILER_TARGET ${triple})
set(CMAKE_CXX_COMPILER clang++-13)
set(CMAKE_CXX_COMPILER_TARGET ${triple})

set(CROSS_LINKER_FLAGS "-fuse-ld=${SNMALLOC_LINKER_FLAVOUR} -Wl,--dynamic-linker=/usr/${triple}/lib/$ENV{RTLD_NAME},-rpath,/usr/${triple}/lib")
if((DEFINED SNMALLOC_LINKER) AND NOT ("${SNMALLOC_LINKER}" MATCHES "^$"))
  string(APPEND CROSS_LINKER_FLAGS " --ld-path=${SNMALLOC_LINKER}")
endif()
set(CMAKE_EXE_LINKER_FLAGS ${CROSS_LINKER_FLAGS})
set(CMAKE_SHARED_LINKER_FLAGS ${CROSS_LINKER_FLAGS})
set(CMAKE_MODULE_LINKER_FLAGS ${CROSS_LINKER_FLAGS})
