#pragma once

#ifdef __NetBSD__
#  include <cassert>

namespace snmalloc
{
  template<typename... Args>
  int getentropy(Args...)
  {
    assert(0 && "Unreachable path");
    return -1;
  }
}

#  include "pal_bsd_aligned.h"

namespace snmalloc
{
  /**
   * NetBSD-specific platform abstraction layer.
   *
   * This adds NetBSD-specific aligned allocation to the generic BSD
   * implementation.
   */
  class PALNetBSD : public PALBSD_Aligned<PALNetBSD>
  {
  public:
    /**
     * Bitmap of PalFeatures flags indicating the optional features that this
     * PAL supports.
     *
     * The NetBSD PAL does not currently add any features beyond those of a
     * generic BSD with support for arbitrary alignment from `mmap`.  This
     * field is declared explicitly to remind anyone modifying this class to
     * add new features that they should add any required feature flags.
     *
     * We disable the default implementation of randomness on NetBSD as it
     * does not have the getentropy call. This will currently fallback to
     * C++ libraries std::random_device.
     */
    static constexpr uint64_t pal_features =
      PALBSD_Aligned::pal_features & ~Entropy;
  };
} // namespace snmalloc
#endif
