[![License](https://img.shields.io/badge/License-BSD--2--Clause-blue.svg)](https://opensource.org/licenses/BSD-2-Clause)
[![License](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)

slice_queue
===========
Welcome to my `slice_queue`-library 🎊


What this library is:
---------------------
This library provides a optimized queue for efficient working with (byte-)slices. It allows you to
 - efficiently push an arbitrary amount of elements by either consuming them or by cloning them from a slice (if the
   type supports the `Clone` trait)
 - efficiently popping an arbitrary amount of elements from the front
 - direct access to the underlying buffer by either using `peek*` methods or by using (range-)indices
 - dereferencing the `SliceQueue<T>` like it's a `Vec<T>` (which usually results in a slice)

_Important: If you use the feature `fast_unsafe_code`, we use some raw-memory-access and -management to speed things up.
Especially if you work a lot of `Copy`-types, this may improve the performance drastically. This feature is disabled by
default._


Build Documentation and Library:
--------------------------------
To build and open the documentation, go into the project's root-directory and run `cargo doc --release --open`

To build this library, change into the projects root-directory and run `cargo build --release`; you can find the build
in `target/release`.