use rusteval::{Function, Interactive, InteractiveRoot, Methods};

#[derive(Interactive, Debug, Default)]
struct ChildStruct {
    last_sum: f32,
}

#[Methods]
impl ChildStruct {
    fn add(&mut self, a: f32, b: f32) -> f32 {
        self.last_sum = a + b;
        self.last_sum
    }

    fn add2(&self, a: &f32, b: &f32) -> f32 {
        a + b
    }
}

#[derive(Interactive, Debug, Default)]
struct ParentStruct {
    child1: ChildStruct,
    child2: ChildStruct,
}

#[derive(InteractiveRoot, Debug, Default)]
struct Root {
    parent: ParentStruct,
}

#[Function]
fn add_one(a: u32) -> u32 {
    a + 1
}

fn main() -> std::io::Result<()> {
    use std::io;
    use std::io::Write;

    let mut root = Root::default();
    let mut input = String::new();

    loop {
        print!(">>> ");
        io::stdout().flush()?;

        input.clear();
        io::stdin().read_line(&mut input)?;
        println!("{}", root.eval_to_string(&input));
    }
}

#[derive(Interactive, Debug, Default)]
struct ChildStruct2 {
    last_sum: f32,
}
