//! Rush shell

mod io;

use std::path::PathBuf;
use structopt::StructOpt;

#[derive(StructOpt)]
#[structopt(name="rush")]
struct Opt {
    script_file: Option<PathBuf>,
    script_args: Vec<String>,
}

fn main() {
    let mut opt = Opt::from_args();
    let mut input = if let Some(script_file) = opt.script_file {
        io::Input::from_script_file(&script_file).expect("Error opening script file")
    } else {
        opt.script_args.push("rush".to_string());
        io::Input::from_stdin()
    };
    let mut input_line = String::new();
    loop {
        if input.read_line(&mut input_line).expect("Can NOT read the input properly") == 0 {
            // EOF
            break;
        }
        match input_line.trim() {
            // The exit as bye is for compatibility with zsh.
            "exit" | "quit" | "bye" => break, // This is temporary.
            command => println!("Your command is '{}' but this can not execute it yet", command),
        }
        input_line.clear();
    }
}
