#[derive(Debug, PartialEq, Clone, Copy)]
pub enum TID {
    NONE,
    ROOT,
    LNUM,
    REM,
    ID,
    MDID,
    FN,
    INT,
    REAL,
    STR,
    CLOSE,
    CLR,
    CMD,
    CONT,
    DATA,
    DEF,
    DIM,
    END,
    FOR,
    TO,
    GET,
    GOSUB,
    GOTO,
    IF,
    THEN,
    INPUT,
    LET,
    LIST,
    LOAD,
    NEW,
    NEXT,
    ON,
    OPEN,
    POKE,
    PRINT,
    READ,
    RETURN,
    RESTORE,
    RUN,
    STEP,
    STOP,
    SYS,
    WAIT,
    VERIFY,
    ABS,
    ASC,
    ATN,
    CHR,
    COS,
    EXP,
    FRE,
    FINT,
    LEFT,
    LEN,
    MID,
    PEEK,
    POS,
    RIGHT,
    RND,
    SGN,
    SIN,
    SPC,
    SQR,
    FSTR,
    TAB,
    TAN,
    VAL,
    AND,
    NOT,
    OR,
    EQ,
    NEQ,
    GT,
    GTEQ,
    LT,
    LTEQ,
    PLUS,
    MINUS,
    MULT,
    DIV,
    POW,
    LBRK,
    RBRK,
    SEP,
    SEMICOLON,
    COMMA,
    NL,
}

impl<'a> From<&'a str> for TID {
    fn from(s: &'a str) -> Self {
        match s {
            "CLOSE" => TID::CLOSE,
            "CLR" => TID::CLR,
            "CMD" => TID::CMD,
            "CONT" => TID::CONT,
            "DATA" => TID::DATA,
            "DEF" => TID::DEF,
            "DIM" => TID::DIM,
            "END" => TID::END,
            "FOR" => TID::FOR,
            "TO" => TID::TO,
            "GET" => TID::GET,
            "GOSUB" => TID::GOSUB,
            "GOTO" => TID::GOTO,
            "IF" => TID::IF,
            "THEN" => TID::THEN,
            "INPUT" => TID::INPUT,
            "LET" => TID::LET,
            "LIST" => TID::LIST,
            "LOAD" => TID::LOAD,
            "NEW" => TID::NEW,
            "NEXT" => TID::NEXT,
            "ON" => TID::ON,
            "OPEN" => TID::OPEN,
            "POKE" => TID::POKE,
            "PRINT" => TID::PRINT,
            "READ" => TID::READ,
            "RETURN" => TID::RETURN,
            "RESTORE" => TID::RESTORE,
            "RUN" => TID::RUN,
            "STEP" => TID::STEP,
            "STOP" => TID::STOP,
            "SYS" => TID::SYS,
            "WAIT" => TID::WAIT,
            "VERIFY" => TID::VERIFY,
            "FN" => TID::FN,
            "REM" => TID::REM,
            "ABS" => TID::ABS,
            "ASC" => TID::ASC,
            "ATN" => TID::ATN,
            "CHR$" => TID::CHR,
            "COS" => TID::COS,
            "EXP" => TID::EXP,
            "FRE" => TID::FRE,
            "INT" => TID::FINT,
            "LEFT$" => TID::LEFT,
            "LEN" => TID::LEN,
            "MID$" => TID::MID,
            "PEEK" => TID::PEEK,
            "POS" => TID::POS,
            "RIGHT$" => TID::RIGHT,
            "RND" => TID::RND,
            "SGN" => TID::SGN,
            "SIN" => TID::SIN,
            "SPC" => TID::SPC,
            "SQR" => TID::SQR,
            "STR$" => TID::FSTR,
            "TAB" => TID::TAB,
            "TAN" => TID::TAN,
            "VAL" => TID::VAL,
            "AND" => TID::AND,
            "NOT" => TID::NOT,
            "OR" => TID::OR,
            "=" => TID::EQ,
            "<>" => TID::NEQ,
            ">" => TID::GT,
            ">=" => TID::GTEQ,
            "<" => TID::LT,
            "<=" => TID::LTEQ,
            "+" => TID::PLUS,
            "-" => TID::MINUS,
            "*" => TID::MULT,
            "/" => TID::DIV,
            "^" => TID::POW,
            "(" => TID::LBRK,
            ")" => TID::RBRK,
            ":" => TID::SEP,
            ";" => TID::SEMICOLON,
            "," => TID::COMMA,
            _ => TID::NONE,
        }
    }
}

#[cfg(test)]
mod tests {
    use tokenid::*;

    #[test]
    fn can_convert_from_string() {
        assert_eq!(TID::from("END"), TID::END);
        assert_eq!(TID::from("LET"), TID::LET);
        assert_eq!(TID::from("PRINT"), TID::PRINT);
    }
}
