#include <correct.h>
#include <stdio.h>
#include <stdlib.h>

int main() {
    uint8_t data[] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    correct_convolutional *conv = correct_convolutional_create(2, 7, correct_conv_r12_7_polynomial);
    size_t enc_len = correct_convolutional_encode_len(conv, sizeof(data));
    printf("enc len %zu\n", enc_len);
    size_t enc_len_bytes = enc_len / 8;
    enc_len_bytes++;
    uint8_t *encoded = malloc(enc_len_bytes);

    correct_convolutional_encode(conv, data, sizeof(data), encoded);

    for (int i = 0; i < enc_len_bytes; i++) {
        printf("%02x ", encoded[i]);
    }
    printf("\n");

    uint8_t *decoded = malloc(enc_len_bytes/2 + 1);

    ssize_t decoded_len = correct_convolutional_decode(conv, encoded, enc_len, decoded);

    printf("%zd\n", decoded_len);

    for (int i = 0; i < decoded_len; ++i) {
        printf("%02x ", decoded[i]);
    }
    printf("\n");

    free(encoded);
    free(decoded);
    correct_convolutional_destroy(conv);
    return 0;
}
