#![cfg(feature = "benchmark")]
#![feature(test)]

extern crate quick_sort;
extern crate test;
extern crate rand;
extern crate quicksort;

use test::Bencher;

#[bench]
fn quick_sort_benchmark(b: &mut Bencher) {
    let mut numbers = Vec::new();
    for _ in 1..10000 {
        numbers.push(rand::random::<u32>());
    }
    b.iter(|| quick_sort::sort(numbers.as_mut_slice()));
}

#[bench]
fn quick_sort_custom_order_benchmark(b: &mut Bencher) {
    let mut numbers = Vec::new();
    for _ in 1..10000 {
        numbers.push(rand::random::<u32>());
    }
    b.iter(|| quick_sort::sort_by(numbers.as_mut_slice(), &|a, b| a > b));
}

#[bench]
fn quick_sort_benchmark_crate(b: &mut Bencher) {
    let mut numbers = Vec::new();
    for _ in 1..10000 {
        numbers.push(rand::random::<u32>());
    }
    b.iter(|| quicksort::quicksort(numbers.as_mut_slice()));
}

#[bench]
fn empty_bench(b: &mut Bencher) {
    b.iter(|| 1);
}

#[bench]
fn bench_std_sort(b: &mut Bencher) {
    let mut numbers = Vec::new();
    for _ in 1..10000 {
        numbers.push(rand::random::<u32>());
    }
    b.iter(|| numbers.sort());
}
