macro_rules! sort {
    ({ $( $(#[$meta:meta])* => $item:ident )* }
     { $(#[$bufmeta:meta])* }
     { #[$nextmeta:meta] $($tail:tt)* }) => {
     sort!({ $( $(#[$meta])* => $item )* } { $(#[$bufmeta])* #[$nextmeta] } { $($tail)* });
    };
    ({ $( $(#[$meta:meta])* => $item:ident )* }
     { $(#[$bufmeta:meta])* }
     { $name:ident $($tail:tt)* }) => {
     sort!({ $( $(#[$meta])* => $item )* $(#[$bufmeta])* => $name } {} { $($tail)* });
    };
    ({ $( $(#[$meta:meta])* => $item:ident )* } {} {}) => {
        #[derive(Debug)]
        pub enum Test {
            $(
                $(#[$meta])*
                $item,
            )*
        }
    };
}
macro_rules! test {
    ( $($items:tt)* ) => {
        sort!({} {} { $($items)*});
    }
}

test! {
    /// Document1
    /// line2
    One
    /// Second
    Second
    Third
}

fn main() {
    println!("One {:?}", Test::One);
    println!("Two {:?}", Test::Two);
    println!("Three {:?}", Test::Three);
}
