use libc::{c_char, c_int};

use crate::object::{PyObject, PyTypeObject};
use crate::pyport::Py_ssize_t;

#[repr(C)]
#[derive(Copy)]
pub struct PyStructSequence_Field {
    #[cfg(not(Py_3_7))]
    pub name: *mut c_char,
    #[cfg(Py_3_7)]
    pub name: *const c_char,
    #[cfg(not(Py_3_7))]
    pub doc: *mut c_char,
    #[cfg(Py_3_7)]
    pub doc: *const c_char,
}
impl Clone for PyStructSequence_Field {
    #[inline]
    fn clone(&self) -> PyStructSequence_Field {
        *self
    }
}

#[repr(C)]
#[derive(Copy)]
pub struct PyStructSequence_Desc {
    #[cfg(not(Py_3_7))]
    pub name: *mut c_char,
    #[cfg(Py_3_7)]
    pub name: *const c_char,
    #[cfg(not(Py_3_7))]
    pub doc: *mut c_char,
    #[cfg(Py_3_7)]
    pub doc: *const c_char,
    pub fields: *mut PyStructSequence_Field,
    pub n_in_sequence: c_int,
}
impl Clone for PyStructSequence_Desc {
    #[inline]
    fn clone(&self) -> PyStructSequence_Desc {
        *self
    }
}

#[cfg_attr(windows, link(name = "pythonXY"))]
extern "C" {
    pub fn PyStructSequence_NewType(desc: *mut PyStructSequence_Desc) -> *mut PyTypeObject;
    pub fn PyStructSequence_New(_type: *mut PyTypeObject) -> *mut PyObject;
    pub fn PyStructSequence_SetItem(
        arg1: *mut PyObject,
        arg2: Py_ssize_t,
        arg3: *mut PyObject,
    ) -> ();
    pub fn PyStructSequence_GetItem(arg1: *mut PyObject, arg2: Py_ssize_t) -> *mut PyObject;
}
