// This file is auto-generated by the build script
// Please, do not modify it manually

extern crate pulldown_cmark;

include!("normalize_html.rs.inc");


    #[test]
    fn gfm_tasklist_test_1() {
        let original = r##"- [ ] foo
- [x] bar
"##;
        let expected = r##"<ul>
<li><input disabled="" type="checkbox"> foo</li>
<li><input checked="" disabled="" type="checkbox"> bar</li>
</ul>
"##;

        use pulldown_cmark::{Parser, html, Options};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(Options::ENABLE_TABLES);
        opts.insert(Options::ENABLE_FOOTNOTES);
        opts.insert(Options::ENABLE_STRIKETHROUGH);
        opts.insert(Options::ENABLE_TASKLISTS);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(normalize_html(&expected), normalize_html(&s));
    }

    #[test]
    fn gfm_tasklist_test_2() {
        let original = r##"- [x] foo
  - [ ] bar
  - [x] baz
- [ ] bim
"##;
        let expected = r##"<ul>
<li><input checked="" disabled="" type="checkbox"> foo
<ul>
<li><input disabled="" type="checkbox"> bar</li>
<li><input checked="" disabled="" type="checkbox"> baz</li>
</ul>
</li>
<li><input disabled="" type="checkbox"> bim</li>
</ul>
"##;

        use pulldown_cmark::{Parser, html, Options};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(Options::ENABLE_TABLES);
        opts.insert(Options::ENABLE_FOOTNOTES);
        opts.insert(Options::ENABLE_STRIKETHROUGH);
        opts.insert(Options::ENABLE_TASKLISTS);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(normalize_html(&expected), normalize_html(&s));
    }