// Copyright 2015 Google Inc. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//! Expansions of HTML5 entities

// Autogenerated by mk_entities.py

const ENTITIES: [&'static str; 2125] = [
        "AElig",
        "AMP",
        "Aacute",
        "Abreve",
        "Acirc",
        "Acy",
        "Afr",
        "Agrave",
        "Alpha",
        "Amacr",
        "And",
        "Aogon",
        "Aopf",
        "ApplyFunction",
        "Aring",
        "Ascr",
        "Assign",
        "Atilde",
        "Auml",
        "Backslash",
        "Barv",
        "Barwed",
        "Bcy",
        "Because",
        "Bernoullis",
        "Beta",
        "Bfr",
        "Bopf",
        "Breve",
        "Bscr",
        "Bumpeq",
        "CHcy",
        "COPY",
        "Cacute",
        "Cap",
        "CapitalDifferentialD",
        "Cayleys",
        "Ccaron",
        "Ccedil",
        "Ccirc",
        "Cconint",
        "Cdot",
        "Cedilla",
        "CenterDot",
        "Cfr",
        "Chi",
        "CircleDot",
        "CircleMinus",
        "CirclePlus",
        "CircleTimes",
        "ClockwiseContourIntegral",
        "CloseCurlyDoubleQuote",
        "CloseCurlyQuote",
        "Colon",
        "Colone",
        "Congruent",
        "Conint",
        "ContourIntegral",
        "Copf",
        "Coproduct",
        "CounterClockwiseContourIntegral",
        "Cross",
        "Cscr",
        "Cup",
        "CupCap",
        "DD",
        "DDotrahd",
        "DJcy",
        "DScy",
        "DZcy",
        "Dagger",
        "Darr",
        "Dashv",
        "Dcaron",
        "Dcy",
        "Del",
        "Delta",
        "Dfr",
        "DiacriticalAcute",
        "DiacriticalDot",
        "DiacriticalDoubleAcute",
        "DiacriticalGrave",
        "DiacriticalTilde",
        "Diamond",
        "DifferentialD",
        "Dopf",
        "Dot",
        "DotDot",
        "DotEqual",
        "DoubleContourIntegral",
        "DoubleDot",
        "DoubleDownArrow",
        "DoubleLeftArrow",
        "DoubleLeftRightArrow",
        "DoubleLeftTee",
        "DoubleLongLeftArrow",
        "DoubleLongLeftRightArrow",
        "DoubleLongRightArrow",
        "DoubleRightArrow",
        "DoubleRightTee",
        "DoubleUpArrow",
        "DoubleUpDownArrow",
        "DoubleVerticalBar",
        "DownArrow",
        "DownArrowBar",
        "DownArrowUpArrow",
        "DownBreve",
        "DownLeftRightVector",
        "DownLeftTeeVector",
        "DownLeftVector",
        "DownLeftVectorBar",
        "DownRightTeeVector",
        "DownRightVector",
        "DownRightVectorBar",
        "DownTee",
        "DownTeeArrow",
        "Downarrow",
        "Dscr",
        "Dstrok",
        "ENG",
        "ETH",
        "Eacute",
        "Ecaron",
        "Ecirc",
        "Ecy",
        "Edot",
        "Efr",
        "Egrave",
        "Element",
        "Emacr",
        "EmptySmallSquare",
        "EmptyVerySmallSquare",
        "Eogon",
        "Eopf",
        "Epsilon",
        "Equal",
        "EqualTilde",
        "Equilibrium",
        "Escr",
        "Esim",
        "Eta",
        "Euml",
        "Exists",
        "ExponentialE",
        "Fcy",
        "Ffr",
        "FilledSmallSquare",
        "FilledVerySmallSquare",
        "Fopf",
        "ForAll",
        "Fouriertrf",
        "Fscr",
        "GJcy",
        "GT",
        "Gamma",
        "Gammad",
        "Gbreve",
        "Gcedil",
        "Gcirc",
        "Gcy",
        "Gdot",
        "Gfr",
        "Gg",
        "Gopf",
        "GreaterEqual",
        "GreaterEqualLess",
        "GreaterFullEqual",
        "GreaterGreater",
        "GreaterLess",
        "GreaterSlantEqual",
        "GreaterTilde",
        "Gscr",
        "Gt",
        "HARDcy",
        "Hacek",
        "Hat",
        "Hcirc",
        "Hfr",
        "HilbertSpace",
        "Hopf",
        "HorizontalLine",
        "Hscr",
        "Hstrok",
        "HumpDownHump",
        "HumpEqual",
        "IEcy",
        "IJlig",
        "IOcy",
        "Iacute",
        "Icirc",
        "Icy",
        "Idot",
        "Ifr",
        "Igrave",
        "Im",
        "Imacr",
        "ImaginaryI",
        "Implies",
        "Int",
        "Integral",
        "Intersection",
        "InvisibleComma",
        "InvisibleTimes",
        "Iogon",
        "Iopf",
        "Iota",
        "Iscr",
        "Itilde",
        "Iukcy",
        "Iuml",
        "Jcirc",
        "Jcy",
        "Jfr",
        "Jopf",
        "Jscr",
        "Jsercy",
        "Jukcy",
        "KHcy",
        "KJcy",
        "Kappa",
        "Kcedil",
        "Kcy",
        "Kfr",
        "Kopf",
        "Kscr",
        "LJcy",
        "LT",
        "Lacute",
        "Lambda",
        "Lang",
        "Laplacetrf",
        "Larr",
        "Lcaron",
        "Lcedil",
        "Lcy",
        "LeftAngleBracket",
        "LeftArrow",
        "LeftArrowBar",
        "LeftArrowRightArrow",
        "LeftCeiling",
        "LeftDoubleBracket",
        "LeftDownTeeVector",
        "LeftDownVector",
        "LeftDownVectorBar",
        "LeftFloor",
        "LeftRightArrow",
        "LeftRightVector",
        "LeftTee",
        "LeftTeeArrow",
        "LeftTeeVector",
        "LeftTriangle",
        "LeftTriangleBar",
        "LeftTriangleEqual",
        "LeftUpDownVector",
        "LeftUpTeeVector",
        "LeftUpVector",
        "LeftUpVectorBar",
        "LeftVector",
        "LeftVectorBar",
        "Leftarrow",
        "Leftrightarrow",
        "LessEqualGreater",
        "LessFullEqual",
        "LessGreater",
        "LessLess",
        "LessSlantEqual",
        "LessTilde",
        "Lfr",
        "Ll",
        "Lleftarrow",
        "Lmidot",
        "LongLeftArrow",
        "LongLeftRightArrow",
        "LongRightArrow",
        "Longleftarrow",
        "Longleftrightarrow",
        "Longrightarrow",
        "Lopf",
        "LowerLeftArrow",
        "LowerRightArrow",
        "Lscr",
        "Lsh",
        "Lstrok",
        "Lt",
        "Map",
        "Mcy",
        "MediumSpace",
        "Mellintrf",
        "Mfr",
        "MinusPlus",
        "Mopf",
        "Mscr",
        "Mu",
        "NJcy",
        "Nacute",
        "Ncaron",
        "Ncedil",
        "Ncy",
        "NegativeMediumSpace",
        "NegativeThickSpace",
        "NegativeThinSpace",
        "NegativeVeryThinSpace",
        "NestedGreaterGreater",
        "NestedLessLess",
        "NewLine",
        "Nfr",
        "NoBreak",
        "NonBreakingSpace",
        "Nopf",
        "Not",
        "NotCongruent",
        "NotCupCap",
        "NotDoubleVerticalBar",
        "NotElement",
        "NotEqual",
        "NotEqualTilde",
        "NotExists",
        "NotGreater",
        "NotGreaterEqual",
        "NotGreaterFullEqual",
        "NotGreaterGreater",
        "NotGreaterLess",
        "NotGreaterSlantEqual",
        "NotGreaterTilde",
        "NotHumpDownHump",
        "NotHumpEqual",
        "NotLeftTriangle",
        "NotLeftTriangleBar",
        "NotLeftTriangleEqual",
        "NotLess",
        "NotLessEqual",
        "NotLessGreater",
        "NotLessLess",
        "NotLessSlantEqual",
        "NotLessTilde",
        "NotNestedGreaterGreater",
        "NotNestedLessLess",
        "NotPrecedes",
        "NotPrecedesEqual",
        "NotPrecedesSlantEqual",
        "NotReverseElement",
        "NotRightTriangle",
        "NotRightTriangleBar",
        "NotRightTriangleEqual",
        "NotSquareSubset",
        "NotSquareSubsetEqual",
        "NotSquareSuperset",
        "NotSquareSupersetEqual",
        "NotSubset",
        "NotSubsetEqual",
        "NotSucceeds",
        "NotSucceedsEqual",
        "NotSucceedsSlantEqual",
        "NotSucceedsTilde",
        "NotSuperset",
        "NotSupersetEqual",
        "NotTilde",
        "NotTildeEqual",
        "NotTildeFullEqual",
        "NotTildeTilde",
        "NotVerticalBar",
        "Nscr",
        "Ntilde",
        "Nu",
        "OElig",
        "Oacute",
        "Ocirc",
        "Ocy",
        "Odblac",
        "Ofr",
        "Ograve",
        "Omacr",
        "Omega",
        "Omicron",
        "Oopf",
        "OpenCurlyDoubleQuote",
        "OpenCurlyQuote",
        "Or",
        "Oscr",
        "Oslash",
        "Otilde",
        "Otimes",
        "Ouml",
        "OverBar",
        "OverBrace",
        "OverBracket",
        "OverParenthesis",
        "PartialD",
        "Pcy",
        "Pfr",
        "Phi",
        "Pi",
        "PlusMinus",
        "Poincareplane",
        "Popf",
        "Pr",
        "Precedes",
        "PrecedesEqual",
        "PrecedesSlantEqual",
        "PrecedesTilde",
        "Prime",
        "Product",
        "Proportion",
        "Proportional",
        "Pscr",
        "Psi",
        "QUOT",
        "Qfr",
        "Qopf",
        "Qscr",
        "RBarr",
        "REG",
        "Racute",
        "Rang",
        "Rarr",
        "Rarrtl",
        "Rcaron",
        "Rcedil",
        "Rcy",
        "Re",
        "ReverseElement",
        "ReverseEquilibrium",
        "ReverseUpEquilibrium",
        "Rfr",
        "Rho",
        "RightAngleBracket",
        "RightArrow",
        "RightArrowBar",
        "RightArrowLeftArrow",
        "RightCeiling",
        "RightDoubleBracket",
        "RightDownTeeVector",
        "RightDownVector",
        "RightDownVectorBar",
        "RightFloor",
        "RightTee",
        "RightTeeArrow",
        "RightTeeVector",
        "RightTriangle",
        "RightTriangleBar",
        "RightTriangleEqual",
        "RightUpDownVector",
        "RightUpTeeVector",
        "RightUpVector",
        "RightUpVectorBar",
        "RightVector",
        "RightVectorBar",
        "Rightarrow",
        "Ropf",
        "RoundImplies",
        "Rrightarrow",
        "Rscr",
        "Rsh",
        "RuleDelayed",
        "SHCHcy",
        "SHcy",
        "SOFTcy",
        "Sacute",
        "Sc",
        "Scaron",
        "Scedil",
        "Scirc",
        "Scy",
        "Sfr",
        "ShortDownArrow",
        "ShortLeftArrow",
        "ShortRightArrow",
        "ShortUpArrow",
        "Sigma",
        "SmallCircle",
        "Sopf",
        "Sqrt",
        "Square",
        "SquareIntersection",
        "SquareSubset",
        "SquareSubsetEqual",
        "SquareSuperset",
        "SquareSupersetEqual",
        "SquareUnion",
        "Sscr",
        "Star",
        "Sub",
        "Subset",
        "SubsetEqual",
        "Succeeds",
        "SucceedsEqual",
        "SucceedsSlantEqual",
        "SucceedsTilde",
        "SuchThat",
        "Sum",
        "Sup",
        "Superset",
        "SupersetEqual",
        "Supset",
        "THORN",
        "TRADE",
        "TSHcy",
        "TScy",
        "Tab",
        "Tau",
        "Tcaron",
        "Tcedil",
        "Tcy",
        "Tfr",
        "Therefore",
        "Theta",
        "ThickSpace",
        "ThinSpace",
        "Tilde",
        "TildeEqual",
        "TildeFullEqual",
        "TildeTilde",
        "Topf",
        "TripleDot",
        "Tscr",
        "Tstrok",
        "Uacute",
        "Uarr",
        "Uarrocir",
        "Ubrcy",
        "Ubreve",
        "Ucirc",
        "Ucy",
        "Udblac",
        "Ufr",
        "Ugrave",
        "Umacr",
        "UnderBar",
        "UnderBrace",
        "UnderBracket",
        "UnderParenthesis",
        "Union",
        "UnionPlus",
        "Uogon",
        "Uopf",
        "UpArrow",
        "UpArrowBar",
        "UpArrowDownArrow",
        "UpDownArrow",
        "UpEquilibrium",
        "UpTee",
        "UpTeeArrow",
        "Uparrow",
        "Updownarrow",
        "UpperLeftArrow",
        "UpperRightArrow",
        "Upsi",
        "Upsilon",
        "Uring",
        "Uscr",
        "Utilde",
        "Uuml",
        "VDash",
        "Vbar",
        "Vcy",
        "Vdash",
        "Vdashl",
        "Vee",
        "Verbar",
        "Vert",
        "VerticalBar",
        "VerticalLine",
        "VerticalSeparator",
        "VerticalTilde",
        "VeryThinSpace",
        "Vfr",
        "Vopf",
        "Vscr",
        "Vvdash",
        "Wcirc",
        "Wedge",
        "Wfr",
        "Wopf",
        "Wscr",
        "Xfr",
        "Xi",
        "Xopf",
        "Xscr",
        "YAcy",
        "YIcy",
        "YUcy",
        "Yacute",
        "Ycirc",
        "Ycy",
        "Yfr",
        "Yopf",
        "Yscr",
        "Yuml",
        "ZHcy",
        "Zacute",
        "Zcaron",
        "Zcy",
        "Zdot",
        "ZeroWidthSpace",
        "Zeta",
        "Zfr",
        "Zopf",
        "Zscr",
        "aacute",
        "abreve",
        "ac",
        "acE",
        "acd",
        "acirc",
        "acute",
        "acy",
        "aelig",
        "af",
        "afr",
        "agrave",
        "alefsym",
        "aleph",
        "alpha",
        "amacr",
        "amalg",
        "amp",
        "and",
        "andand",
        "andd",
        "andslope",
        "andv",
        "ang",
        "ange",
        "angle",
        "angmsd",
        "angmsdaa",
        "angmsdab",
        "angmsdac",
        "angmsdad",
        "angmsdae",
        "angmsdaf",
        "angmsdag",
        "angmsdah",
        "angrt",
        "angrtvb",
        "angrtvbd",
        "angsph",
        "angst",
        "angzarr",
        "aogon",
        "aopf",
        "ap",
        "apE",
        "apacir",
        "ape",
        "apid",
        "apos",
        "approx",
        "approxeq",
        "aring",
        "ascr",
        "ast",
        "asymp",
        "asympeq",
        "atilde",
        "auml",
        "awconint",
        "awint",
        "bNot",
        "backcong",
        "backepsilon",
        "backprime",
        "backsim",
        "backsimeq",
        "barvee",
        "barwed",
        "barwedge",
        "bbrk",
        "bbrktbrk",
        "bcong",
        "bcy",
        "bdquo",
        "becaus",
        "because",
        "bemptyv",
        "bepsi",
        "bernou",
        "beta",
        "beth",
        "between",
        "bfr",
        "bigcap",
        "bigcirc",
        "bigcup",
        "bigodot",
        "bigoplus",
        "bigotimes",
        "bigsqcup",
        "bigstar",
        "bigtriangledown",
        "bigtriangleup",
        "biguplus",
        "bigvee",
        "bigwedge",
        "bkarow",
        "blacklozenge",
        "blacksquare",
        "blacktriangle",
        "blacktriangledown",
        "blacktriangleleft",
        "blacktriangleright",
        "blank",
        "blk12",
        "blk14",
        "blk34",
        "block",
        "bne",
        "bnequiv",
        "bnot",
        "bopf",
        "bot",
        "bottom",
        "bowtie",
        "boxDL",
        "boxDR",
        "boxDl",
        "boxDr",
        "boxH",
        "boxHD",
        "boxHU",
        "boxHd",
        "boxHu",
        "boxUL",
        "boxUR",
        "boxUl",
        "boxUr",
        "boxV",
        "boxVH",
        "boxVL",
        "boxVR",
        "boxVh",
        "boxVl",
        "boxVr",
        "boxbox",
        "boxdL",
        "boxdR",
        "boxdl",
        "boxdr",
        "boxh",
        "boxhD",
        "boxhU",
        "boxhd",
        "boxhu",
        "boxminus",
        "boxplus",
        "boxtimes",
        "boxuL",
        "boxuR",
        "boxul",
        "boxur",
        "boxv",
        "boxvH",
        "boxvL",
        "boxvR",
        "boxvh",
        "boxvl",
        "boxvr",
        "bprime",
        "breve",
        "brvbar",
        "bscr",
        "bsemi",
        "bsim",
        "bsime",
        "bsol",
        "bsolb",
        "bsolhsub",
        "bull",
        "bullet",
        "bump",
        "bumpE",
        "bumpe",
        "bumpeq",
        "cacute",
        "cap",
        "capand",
        "capbrcup",
        "capcap",
        "capcup",
        "capdot",
        "caps",
        "caret",
        "caron",
        "ccaps",
        "ccaron",
        "ccedil",
        "ccirc",
        "ccups",
        "ccupssm",
        "cdot",
        "cedil",
        "cemptyv",
        "cent",
        "centerdot",
        "cfr",
        "chcy",
        "check",
        "checkmark",
        "chi",
        "cir",
        "cirE",
        "circ",
        "circeq",
        "circlearrowleft",
        "circlearrowright",
        "circledR",
        "circledS",
        "circledast",
        "circledcirc",
        "circleddash",
        "cire",
        "cirfnint",
        "cirmid",
        "cirscir",
        "clubs",
        "clubsuit",
        "colon",
        "colone",
        "coloneq",
        "comma",
        "commat",
        "comp",
        "compfn",
        "complement",
        "complexes",
        "cong",
        "congdot",
        "conint",
        "copf",
        "coprod",
        "copy",
        "copysr",
        "crarr",
        "cross",
        "cscr",
        "csub",
        "csube",
        "csup",
        "csupe",
        "ctdot",
        "cudarrl",
        "cudarrr",
        "cuepr",
        "cuesc",
        "cularr",
        "cularrp",
        "cup",
        "cupbrcap",
        "cupcap",
        "cupcup",
        "cupdot",
        "cupor",
        "cups",
        "curarr",
        "curarrm",
        "curlyeqprec",
        "curlyeqsucc",
        "curlyvee",
        "curlywedge",
        "curren",
        "curvearrowleft",
        "curvearrowright",
        "cuvee",
        "cuwed",
        "cwconint",
        "cwint",
        "cylcty",
        "dArr",
        "dHar",
        "dagger",
        "daleth",
        "darr",
        "dash",
        "dashv",
        "dbkarow",
        "dblac",
        "dcaron",
        "dcy",
        "dd",
        "ddagger",
        "ddarr",
        "ddotseq",
        "deg",
        "delta",
        "demptyv",
        "dfisht",
        "dfr",
        "dharl",
        "dharr",
        "diam",
        "diamond",
        "diamondsuit",
        "diams",
        "die",
        "digamma",
        "disin",
        "div",
        "divide",
        "divideontimes",
        "divonx",
        "djcy",
        "dlcorn",
        "dlcrop",
        "dollar",
        "dopf",
        "dot",
        "doteq",
        "doteqdot",
        "dotminus",
        "dotplus",
        "dotsquare",
        "doublebarwedge",
        "downarrow",
        "downdownarrows",
        "downharpoonleft",
        "downharpoonright",
        "drbkarow",
        "drcorn",
        "drcrop",
        "dscr",
        "dscy",
        "dsol",
        "dstrok",
        "dtdot",
        "dtri",
        "dtrif",
        "duarr",
        "duhar",
        "dwangle",
        "dzcy",
        "dzigrarr",
        "eDDot",
        "eDot",
        "eacute",
        "easter",
        "ecaron",
        "ecir",
        "ecirc",
        "ecolon",
        "ecy",
        "edot",
        "ee",
        "efDot",
        "efr",
        "eg",
        "egrave",
        "egs",
        "egsdot",
        "el",
        "elinters",
        "ell",
        "els",
        "elsdot",
        "emacr",
        "empty",
        "emptyset",
        "emptyv",
        "emsp",
        "emsp13",
        "emsp14",
        "eng",
        "ensp",
        "eogon",
        "eopf",
        "epar",
        "eparsl",
        "eplus",
        "epsi",
        "epsilon",
        "epsiv",
        "eqcirc",
        "eqcolon",
        "eqsim",
        "eqslantgtr",
        "eqslantless",
        "equals",
        "equest",
        "equiv",
        "equivDD",
        "eqvparsl",
        "erDot",
        "erarr",
        "escr",
        "esdot",
        "esim",
        "eta",
        "eth",
        "euml",
        "euro",
        "excl",
        "exist",
        "expectation",
        "exponentiale",
        "fallingdotseq",
        "fcy",
        "female",
        "ffilig",
        "fflig",
        "ffllig",
        "ffr",
        "filig",
        "fjlig",
        "flat",
        "fllig",
        "fltns",
        "fnof",
        "fopf",
        "forall",
        "fork",
        "forkv",
        "fpartint",
        "frac12",
        "frac13",
        "frac14",
        "frac15",
        "frac16",
        "frac18",
        "frac23",
        "frac25",
        "frac34",
        "frac35",
        "frac38",
        "frac45",
        "frac56",
        "frac58",
        "frac78",
        "frasl",
        "frown",
        "fscr",
        "gE",
        "gEl",
        "gacute",
        "gamma",
        "gammad",
        "gap",
        "gbreve",
        "gcirc",
        "gcy",
        "gdot",
        "ge",
        "gel",
        "geq",
        "geqq",
        "geqslant",
        "ges",
        "gescc",
        "gesdot",
        "gesdoto",
        "gesdotol",
        "gesl",
        "gesles",
        "gfr",
        "gg",
        "ggg",
        "gimel",
        "gjcy",
        "gl",
        "glE",
        "gla",
        "glj",
        "gnE",
        "gnap",
        "gnapprox",
        "gne",
        "gneq",
        "gneqq",
        "gnsim",
        "gopf",
        "grave",
        "gscr",
        "gsim",
        "gsime",
        "gsiml",
        "gt",
        "gtcc",
        "gtcir",
        "gtdot",
        "gtlPar",
        "gtquest",
        "gtrapprox",
        "gtrarr",
        "gtrdot",
        "gtreqless",
        "gtreqqless",
        "gtrless",
        "gtrsim",
        "gvertneqq",
        "gvnE",
        "hArr",
        "hairsp",
        "half",
        "hamilt",
        "hardcy",
        "harr",
        "harrcir",
        "harrw",
        "hbar",
        "hcirc",
        "hearts",
        "heartsuit",
        "hellip",
        "hercon",
        "hfr",
        "hksearow",
        "hkswarow",
        "hoarr",
        "homtht",
        "hookleftarrow",
        "hookrightarrow",
        "hopf",
        "horbar",
        "hscr",
        "hslash",
        "hstrok",
        "hybull",
        "hyphen",
        "iacute",
        "ic",
        "icirc",
        "icy",
        "iecy",
        "iexcl",
        "iff",
        "ifr",
        "igrave",
        "ii",
        "iiiint",
        "iiint",
        "iinfin",
        "iiota",
        "ijlig",
        "imacr",
        "image",
        "imagline",
        "imagpart",
        "imath",
        "imof",
        "imped",
        "in",
        "incare",
        "infin",
        "infintie",
        "inodot",
        "int",
        "intcal",
        "integers",
        "intercal",
        "intlarhk",
        "intprod",
        "iocy",
        "iogon",
        "iopf",
        "iota",
        "iprod",
        "iquest",
        "iscr",
        "isin",
        "isinE",
        "isindot",
        "isins",
        "isinsv",
        "isinv",
        "it",
        "itilde",
        "iukcy",
        "iuml",
        "jcirc",
        "jcy",
        "jfr",
        "jmath",
        "jopf",
        "jscr",
        "jsercy",
        "jukcy",
        "kappa",
        "kappav",
        "kcedil",
        "kcy",
        "kfr",
        "kgreen",
        "khcy",
        "kjcy",
        "kopf",
        "kscr",
        "lAarr",
        "lArr",
        "lAtail",
        "lBarr",
        "lE",
        "lEg",
        "lHar",
        "lacute",
        "laemptyv",
        "lagran",
        "lambda",
        "lang",
        "langd",
        "langle",
        "lap",
        "laquo",
        "larr",
        "larrb",
        "larrbfs",
        "larrfs",
        "larrhk",
        "larrlp",
        "larrpl",
        "larrsim",
        "larrtl",
        "lat",
        "latail",
        "late",
        "lates",
        "lbarr",
        "lbbrk",
        "lbrace",
        "lbrack",
        "lbrke",
        "lbrksld",
        "lbrkslu",
        "lcaron",
        "lcedil",
        "lceil",
        "lcub",
        "lcy",
        "ldca",
        "ldquo",
        "ldquor",
        "ldrdhar",
        "ldrushar",
        "ldsh",
        "le",
        "leftarrow",
        "leftarrowtail",
        "leftharpoondown",
        "leftharpoonup",
        "leftleftarrows",
        "leftrightarrow",
        "leftrightarrows",
        "leftrightharpoons",
        "leftrightsquigarrow",
        "leftthreetimes",
        "leg",
        "leq",
        "leqq",
        "leqslant",
        "les",
        "lescc",
        "lesdot",
        "lesdoto",
        "lesdotor",
        "lesg",
        "lesges",
        "lessapprox",
        "lessdot",
        "lesseqgtr",
        "lesseqqgtr",
        "lessgtr",
        "lesssim",
        "lfisht",
        "lfloor",
        "lfr",
        "lg",
        "lgE",
        "lhard",
        "lharu",
        "lharul",
        "lhblk",
        "ljcy",
        "ll",
        "llarr",
        "llcorner",
        "llhard",
        "lltri",
        "lmidot",
        "lmoust",
        "lmoustache",
        "lnE",
        "lnap",
        "lnapprox",
        "lne",
        "lneq",
        "lneqq",
        "lnsim",
        "loang",
        "loarr",
        "lobrk",
        "longleftarrow",
        "longleftrightarrow",
        "longmapsto",
        "longrightarrow",
        "looparrowleft",
        "looparrowright",
        "lopar",
        "lopf",
        "loplus",
        "lotimes",
        "lowast",
        "lowbar",
        "loz",
        "lozenge",
        "lozf",
        "lpar",
        "lparlt",
        "lrarr",
        "lrcorner",
        "lrhar",
        "lrhard",
        "lrm",
        "lrtri",
        "lsaquo",
        "lscr",
        "lsh",
        "lsim",
        "lsime",
        "lsimg",
        "lsqb",
        "lsquo",
        "lsquor",
        "lstrok",
        "lt",
        "ltcc",
        "ltcir",
        "ltdot",
        "lthree",
        "ltimes",
        "ltlarr",
        "ltquest",
        "ltrPar",
        "ltri",
        "ltrie",
        "ltrif",
        "lurdshar",
        "luruhar",
        "lvertneqq",
        "lvnE",
        "mDDot",
        "macr",
        "male",
        "malt",
        "maltese",
        "map",
        "mapsto",
        "mapstodown",
        "mapstoleft",
        "mapstoup",
        "marker",
        "mcomma",
        "mcy",
        "mdash",
        "measuredangle",
        "mfr",
        "mho",
        "micro",
        "mid",
        "midast",
        "midcir",
        "middot",
        "minus",
        "minusb",
        "minusd",
        "minusdu",
        "mlcp",
        "mldr",
        "mnplus",
        "models",
        "mopf",
        "mp",
        "mscr",
        "mstpos",
        "mu",
        "multimap",
        "mumap",
        "nGg",
        "nGt",
        "nGtv",
        "nLeftarrow",
        "nLeftrightarrow",
        "nLl",
        "nLt",
        "nLtv",
        "nRightarrow",
        "nVDash",
        "nVdash",
        "nabla",
        "nacute",
        "nang",
        "nap",
        "napE",
        "napid",
        "napos",
        "napprox",
        "natur",
        "natural",
        "naturals",
        "nbsp",
        "nbump",
        "nbumpe",
        "ncap",
        "ncaron",
        "ncedil",
        "ncong",
        "ncongdot",
        "ncup",
        "ncy",
        "ndash",
        "ne",
        "neArr",
        "nearhk",
        "nearr",
        "nearrow",
        "nedot",
        "nequiv",
        "nesear",
        "nesim",
        "nexist",
        "nexists",
        "nfr",
        "ngE",
        "nge",
        "ngeq",
        "ngeqq",
        "ngeqslant",
        "nges",
        "ngsim",
        "ngt",
        "ngtr",
        "nhArr",
        "nharr",
        "nhpar",
        "ni",
        "nis",
        "nisd",
        "niv",
        "njcy",
        "nlArr",
        "nlE",
        "nlarr",
        "nldr",
        "nle",
        "nleftarrow",
        "nleftrightarrow",
        "nleq",
        "nleqq",
        "nleqslant",
        "nles",
        "nless",
        "nlsim",
        "nlt",
        "nltri",
        "nltrie",
        "nmid",
        "nopf",
        "not",
        "notin",
        "notinE",
        "notindot",
        "notinva",
        "notinvb",
        "notinvc",
        "notni",
        "notniva",
        "notnivb",
        "notnivc",
        "npar",
        "nparallel",
        "nparsl",
        "npart",
        "npolint",
        "npr",
        "nprcue",
        "npre",
        "nprec",
        "npreceq",
        "nrArr",
        "nrarr",
        "nrarrc",
        "nrarrw",
        "nrightarrow",
        "nrtri",
        "nrtrie",
        "nsc",
        "nsccue",
        "nsce",
        "nscr",
        "nshortmid",
        "nshortparallel",
        "nsim",
        "nsime",
        "nsimeq",
        "nsmid",
        "nspar",
        "nsqsube",
        "nsqsupe",
        "nsub",
        "nsubE",
        "nsube",
        "nsubset",
        "nsubseteq",
        "nsubseteqq",
        "nsucc",
        "nsucceq",
        "nsup",
        "nsupE",
        "nsupe",
        "nsupset",
        "nsupseteq",
        "nsupseteqq",
        "ntgl",
        "ntilde",
        "ntlg",
        "ntriangleleft",
        "ntrianglelefteq",
        "ntriangleright",
        "ntrianglerighteq",
        "nu",
        "num",
        "numero",
        "numsp",
        "nvDash",
        "nvHarr",
        "nvap",
        "nvdash",
        "nvge",
        "nvgt",
        "nvinfin",
        "nvlArr",
        "nvle",
        "nvlt",
        "nvltrie",
        "nvrArr",
        "nvrtrie",
        "nvsim",
        "nwArr",
        "nwarhk",
        "nwarr",
        "nwarrow",
        "nwnear",
        "oS",
        "oacute",
        "oast",
        "ocir",
        "ocirc",
        "ocy",
        "odash",
        "odblac",
        "odiv",
        "odot",
        "odsold",
        "oelig",
        "ofcir",
        "ofr",
        "ogon",
        "ograve",
        "ogt",
        "ohbar",
        "ohm",
        "oint",
        "olarr",
        "olcir",
        "olcross",
        "oline",
        "olt",
        "omacr",
        "omega",
        "omicron",
        "omid",
        "ominus",
        "oopf",
        "opar",
        "operp",
        "oplus",
        "or",
        "orarr",
        "ord",
        "order",
        "orderof",
        "ordf",
        "ordm",
        "origof",
        "oror",
        "orslope",
        "orv",
        "oscr",
        "oslash",
        "osol",
        "otilde",
        "otimes",
        "otimesas",
        "ouml",
        "ovbar",
        "par",
        "para",
        "parallel",
        "parsim",
        "parsl",
        "part",
        "pcy",
        "percnt",
        "period",
        "permil",
        "perp",
        "pertenk",
        "pfr",
        "phi",
        "phiv",
        "phmmat",
        "phone",
        "pi",
        "pitchfork",
        "piv",
        "planck",
        "planckh",
        "plankv",
        "plus",
        "plusacir",
        "plusb",
        "pluscir",
        "plusdo",
        "plusdu",
        "pluse",
        "plusmn",
        "plussim",
        "plustwo",
        "pm",
        "pointint",
        "popf",
        "pound",
        "pr",
        "prE",
        "prap",
        "prcue",
        "pre",
        "prec",
        "precapprox",
        "preccurlyeq",
        "preceq",
        "precnapprox",
        "precneqq",
        "precnsim",
        "precsim",
        "prime",
        "primes",
        "prnE",
        "prnap",
        "prnsim",
        "prod",
        "profalar",
        "profline",
        "profsurf",
        "prop",
        "propto",
        "prsim",
        "prurel",
        "pscr",
        "psi",
        "puncsp",
        "qfr",
        "qint",
        "qopf",
        "qprime",
        "qscr",
        "quaternions",
        "quatint",
        "quest",
        "questeq",
        "quot",
        "rAarr",
        "rArr",
        "rAtail",
        "rBarr",
        "rHar",
        "race",
        "racute",
        "radic",
        "raemptyv",
        "rang",
        "rangd",
        "range",
        "rangle",
        "raquo",
        "rarr",
        "rarrap",
        "rarrb",
        "rarrbfs",
        "rarrc",
        "rarrfs",
        "rarrhk",
        "rarrlp",
        "rarrpl",
        "rarrsim",
        "rarrtl",
        "rarrw",
        "ratail",
        "ratio",
        "rationals",
        "rbarr",
        "rbbrk",
        "rbrace",
        "rbrack",
        "rbrke",
        "rbrksld",
        "rbrkslu",
        "rcaron",
        "rcedil",
        "rceil",
        "rcub",
        "rcy",
        "rdca",
        "rdldhar",
        "rdquo",
        "rdquor",
        "rdsh",
        "real",
        "realine",
        "realpart",
        "reals",
        "rect",
        "reg",
        "rfisht",
        "rfloor",
        "rfr",
        "rhard",
        "rharu",
        "rharul",
        "rho",
        "rhov",
        "rightarrow",
        "rightarrowtail",
        "rightharpoondown",
        "rightharpoonup",
        "rightleftarrows",
        "rightleftharpoons",
        "rightrightarrows",
        "rightsquigarrow",
        "rightthreetimes",
        "ring",
        "risingdotseq",
        "rlarr",
        "rlhar",
        "rlm",
        "rmoust",
        "rmoustache",
        "rnmid",
        "roang",
        "roarr",
        "robrk",
        "ropar",
        "ropf",
        "roplus",
        "rotimes",
        "rpar",
        "rpargt",
        "rppolint",
        "rrarr",
        "rsaquo",
        "rscr",
        "rsh",
        "rsqb",
        "rsquo",
        "rsquor",
        "rthree",
        "rtimes",
        "rtri",
        "rtrie",
        "rtrif",
        "rtriltri",
        "ruluhar",
        "rx",
        "sacute",
        "sbquo",
        "sc",
        "scE",
        "scap",
        "scaron",
        "sccue",
        "sce",
        "scedil",
        "scirc",
        "scnE",
        "scnap",
        "scnsim",
        "scpolint",
        "scsim",
        "scy",
        "sdot",
        "sdotb",
        "sdote",
        "seArr",
        "searhk",
        "searr",
        "searrow",
        "sect",
        "semi",
        "seswar",
        "setminus",
        "setmn",
        "sext",
        "sfr",
        "sfrown",
        "sharp",
        "shchcy",
        "shcy",
        "shortmid",
        "shortparallel",
        "shy",
        "sigma",
        "sigmaf",
        "sigmav",
        "sim",
        "simdot",
        "sime",
        "simeq",
        "simg",
        "simgE",
        "siml",
        "simlE",
        "simne",
        "simplus",
        "simrarr",
        "slarr",
        "smallsetminus",
        "smashp",
        "smeparsl",
        "smid",
        "smile",
        "smt",
        "smte",
        "smtes",
        "softcy",
        "sol",
        "solb",
        "solbar",
        "sopf",
        "spades",
        "spadesuit",
        "spar",
        "sqcap",
        "sqcaps",
        "sqcup",
        "sqcups",
        "sqsub",
        "sqsube",
        "sqsubset",
        "sqsubseteq",
        "sqsup",
        "sqsupe",
        "sqsupset",
        "sqsupseteq",
        "squ",
        "square",
        "squarf",
        "squf",
        "srarr",
        "sscr",
        "ssetmn",
        "ssmile",
        "sstarf",
        "star",
        "starf",
        "straightepsilon",
        "straightphi",
        "strns",
        "sub",
        "subE",
        "subdot",
        "sube",
        "subedot",
        "submult",
        "subnE",
        "subne",
        "subplus",
        "subrarr",
        "subset",
        "subseteq",
        "subseteqq",
        "subsetneq",
        "subsetneqq",
        "subsim",
        "subsub",
        "subsup",
        "succ",
        "succapprox",
        "succcurlyeq",
        "succeq",
        "succnapprox",
        "succneqq",
        "succnsim",
        "succsim",
        "sum",
        "sung",
        "sup",
        "sup1",
        "sup2",
        "sup3",
        "supE",
        "supdot",
        "supdsub",
        "supe",
        "supedot",
        "suphsol",
        "suphsub",
        "suplarr",
        "supmult",
        "supnE",
        "supne",
        "supplus",
        "supset",
        "supseteq",
        "supseteqq",
        "supsetneq",
        "supsetneqq",
        "supsim",
        "supsub",
        "supsup",
        "swArr",
        "swarhk",
        "swarr",
        "swarrow",
        "swnwar",
        "szlig",
        "target",
        "tau",
        "tbrk",
        "tcaron",
        "tcedil",
        "tcy",
        "tdot",
        "telrec",
        "tfr",
        "there4",
        "therefore",
        "theta",
        "thetasym",
        "thetav",
        "thickapprox",
        "thicksim",
        "thinsp",
        "thkap",
        "thksim",
        "thorn",
        "tilde",
        "times",
        "timesb",
        "timesbar",
        "timesd",
        "tint",
        "toea",
        "top",
        "topbot",
        "topcir",
        "topf",
        "topfork",
        "tosa",
        "tprime",
        "trade",
        "triangle",
        "triangledown",
        "triangleleft",
        "trianglelefteq",
        "triangleq",
        "triangleright",
        "trianglerighteq",
        "tridot",
        "trie",
        "triminus",
        "triplus",
        "trisb",
        "tritime",
        "trpezium",
        "tscr",
        "tscy",
        "tshcy",
        "tstrok",
        "twixt",
        "twoheadleftarrow",
        "twoheadrightarrow",
        "uArr",
        "uHar",
        "uacute",
        "uarr",
        "ubrcy",
        "ubreve",
        "ucirc",
        "ucy",
        "udarr",
        "udblac",
        "udhar",
        "ufisht",
        "ufr",
        "ugrave",
        "uharl",
        "uharr",
        "uhblk",
        "ulcorn",
        "ulcorner",
        "ulcrop",
        "ultri",
        "umacr",
        "uml",
        "uogon",
        "uopf",
        "uparrow",
        "updownarrow",
        "upharpoonleft",
        "upharpoonright",
        "uplus",
        "upsi",
        "upsih",
        "upsilon",
        "upuparrows",
        "urcorn",
        "urcorner",
        "urcrop",
        "uring",
        "urtri",
        "uscr",
        "utdot",
        "utilde",
        "utri",
        "utrif",
        "uuarr",
        "uuml",
        "uwangle",
        "vArr",
        "vBar",
        "vBarv",
        "vDash",
        "vangrt",
        "varepsilon",
        "varkappa",
        "varnothing",
        "varphi",
        "varpi",
        "varpropto",
        "varr",
        "varrho",
        "varsigma",
        "varsubsetneq",
        "varsubsetneqq",
        "varsupsetneq",
        "varsupsetneqq",
        "vartheta",
        "vartriangleleft",
        "vartriangleright",
        "vcy",
        "vdash",
        "vee",
        "veebar",
        "veeeq",
        "vellip",
        "verbar",
        "vert",
        "vfr",
        "vltri",
        "vnsub",
        "vnsup",
        "vopf",
        "vprop",
        "vrtri",
        "vscr",
        "vsubnE",
        "vsubne",
        "vsupnE",
        "vsupne",
        "vzigzag",
        "wcirc",
        "wedbar",
        "wedge",
        "wedgeq",
        "weierp",
        "wfr",
        "wopf",
        "wp",
        "wr",
        "wreath",
        "wscr",
        "xcap",
        "xcirc",
        "xcup",
        "xdtri",
        "xfr",
        "xhArr",
        "xharr",
        "xi",
        "xlArr",
        "xlarr",
        "xmap",
        "xnis",
        "xodot",
        "xopf",
        "xoplus",
        "xotime",
        "xrArr",
        "xrarr",
        "xscr",
        "xsqcup",
        "xuplus",
        "xutri",
        "xvee",
        "xwedge",
        "yacute",
        "yacy",
        "ycirc",
        "ycy",
        "yen",
        "yfr",
        "yicy",
        "yopf",
        "yscr",
        "yucy",
        "yuml",
        "zacute",
        "zcaron",
        "zcy",
        "zdot",
        "zeetrf",
        "zeta",
        "zfr",
        "zhcy",
        "zigrarr",
        "zopf",
        "zscr",
        "zwj",
        "zwnj",
    ];

const ENTITY_VALUES: [&'static str; 2125] = [
        "\u{00C6}",
        "\u{0026}",
        "\u{00C1}",
        "\u{0102}",
        "\u{00C2}",
        "\u{0410}",
        "\u{1D504}",
        "\u{00C0}",
        "\u{0391}",
        "\u{0100}",
        "\u{2A53}",
        "\u{0104}",
        "\u{1D538}",
        "\u{2061}",
        "\u{00C5}",
        "\u{1D49C}",
        "\u{2254}",
        "\u{00C3}",
        "\u{00C4}",
        "\u{2216}",
        "\u{2AE7}",
        "\u{2306}",
        "\u{0411}",
        "\u{2235}",
        "\u{212C}",
        "\u{0392}",
        "\u{1D505}",
        "\u{1D539}",
        "\u{02D8}",
        "\u{212C}",
        "\u{224E}",
        "\u{0427}",
        "\u{00A9}",
        "\u{0106}",
        "\u{22D2}",
        "\u{2145}",
        "\u{212D}",
        "\u{010C}",
        "\u{00C7}",
        "\u{0108}",
        "\u{2230}",
        "\u{010A}",
        "\u{00B8}",
        "\u{00B7}",
        "\u{212D}",
        "\u{03A7}",
        "\u{2299}",
        "\u{2296}",
        "\u{2295}",
        "\u{2297}",
        "\u{2232}",
        "\u{201D}",
        "\u{2019}",
        "\u{2237}",
        "\u{2A74}",
        "\u{2261}",
        "\u{222F}",
        "\u{222E}",
        "\u{2102}",
        "\u{2210}",
        "\u{2233}",
        "\u{2A2F}",
        "\u{1D49E}",
        "\u{22D3}",
        "\u{224D}",
        "\u{2145}",
        "\u{2911}",
        "\u{0402}",
        "\u{0405}",
        "\u{040F}",
        "\u{2021}",
        "\u{21A1}",
        "\u{2AE4}",
        "\u{010E}",
        "\u{0414}",
        "\u{2207}",
        "\u{0394}",
        "\u{1D507}",
        "\u{00B4}",
        "\u{02D9}",
        "\u{02DD}",
        "\u{0060}",
        "\u{02DC}",
        "\u{22C4}",
        "\u{2146}",
        "\u{1D53B}",
        "\u{00A8}",
        "\u{20DC}",
        "\u{2250}",
        "\u{222F}",
        "\u{00A8}",
        "\u{21D3}",
        "\u{21D0}",
        "\u{21D4}",
        "\u{2AE4}",
        "\u{27F8}",
        "\u{27FA}",
        "\u{27F9}",
        "\u{21D2}",
        "\u{22A8}",
        "\u{21D1}",
        "\u{21D5}",
        "\u{2225}",
        "\u{2193}",
        "\u{2913}",
        "\u{21F5}",
        "\u{0311}",
        "\u{2950}",
        "\u{295E}",
        "\u{21BD}",
        "\u{2956}",
        "\u{295F}",
        "\u{21C1}",
        "\u{2957}",
        "\u{22A4}",
        "\u{21A7}",
        "\u{21D3}",
        "\u{1D49F}",
        "\u{0110}",
        "\u{014A}",
        "\u{00D0}",
        "\u{00C9}",
        "\u{011A}",
        "\u{00CA}",
        "\u{042D}",
        "\u{0116}",
        "\u{1D508}",
        "\u{00C8}",
        "\u{2208}",
        "\u{0112}",
        "\u{25FB}",
        "\u{25AB}",
        "\u{0118}",
        "\u{1D53C}",
        "\u{0395}",
        "\u{2A75}",
        "\u{2242}",
        "\u{21CC}",
        "\u{2130}",
        "\u{2A73}",
        "\u{0397}",
        "\u{00CB}",
        "\u{2203}",
        "\u{2147}",
        "\u{0424}",
        "\u{1D509}",
        "\u{25FC}",
        "\u{25AA}",
        "\u{1D53D}",
        "\u{2200}",
        "\u{2131}",
        "\u{2131}",
        "\u{0403}",
        "\u{003E}",
        "\u{0393}",
        "\u{03DC}",
        "\u{011E}",
        "\u{0122}",
        "\u{011C}",
        "\u{0413}",
        "\u{0120}",
        "\u{1D50A}",
        "\u{22D9}",
        "\u{1D53E}",
        "\u{2265}",
        "\u{22DB}",
        "\u{2267}",
        "\u{2AA2}",
        "\u{2277}",
        "\u{2A7E}",
        "\u{2273}",
        "\u{1D4A2}",
        "\u{226B}",
        "\u{042A}",
        "\u{02C7}",
        "\u{005E}",
        "\u{0124}",
        "\u{210C}",
        "\u{210B}",
        "\u{210D}",
        "\u{2500}",
        "\u{210B}",
        "\u{0126}",
        "\u{224E}",
        "\u{224F}",
        "\u{0415}",
        "\u{0132}",
        "\u{0401}",
        "\u{00CD}",
        "\u{00CE}",
        "\u{0418}",
        "\u{0130}",
        "\u{2111}",
        "\u{00CC}",
        "\u{2111}",
        "\u{012A}",
        "\u{2148}",
        "\u{21D2}",
        "\u{222C}",
        "\u{222B}",
        "\u{22C2}",
        "\u{2063}",
        "\u{2062}",
        "\u{012E}",
        "\u{1D540}",
        "\u{0399}",
        "\u{2110}",
        "\u{0128}",
        "\u{0406}",
        "\u{00CF}",
        "\u{0134}",
        "\u{0419}",
        "\u{1D50D}",
        "\u{1D541}",
        "\u{1D4A5}",
        "\u{0408}",
        "\u{0404}",
        "\u{0425}",
        "\u{040C}",
        "\u{039A}",
        "\u{0136}",
        "\u{041A}",
        "\u{1D50E}",
        "\u{1D542}",
        "\u{1D4A6}",
        "\u{0409}",
        "\u{003C}",
        "\u{0139}",
        "\u{039B}",
        "\u{27EA}",
        "\u{2112}",
        "\u{219E}",
        "\u{013D}",
        "\u{013B}",
        "\u{041B}",
        "\u{27E8}",
        "\u{2190}",
        "\u{21E4}",
        "\u{21C6}",
        "\u{2308}",
        "\u{27E6}",
        "\u{2961}",
        "\u{21C3}",
        "\u{2959}",
        "\u{230A}",
        "\u{2194}",
        "\u{294E}",
        "\u{22A3}",
        "\u{21A4}",
        "\u{295A}",
        "\u{22B2}",
        "\u{29CF}",
        "\u{22B4}",
        "\u{2951}",
        "\u{2960}",
        "\u{21BF}",
        "\u{2958}",
        "\u{21BC}",
        "\u{2952}",
        "\u{21D0}",
        "\u{21D4}",
        "\u{22DA}",
        "\u{2266}",
        "\u{2276}",
        "\u{2AA1}",
        "\u{2A7D}",
        "\u{2272}",
        "\u{1D50F}",
        "\u{22D8}",
        "\u{21DA}",
        "\u{013F}",
        "\u{27F5}",
        "\u{27F7}",
        "\u{27F6}",
        "\u{27F8}",
        "\u{27FA}",
        "\u{27F9}",
        "\u{1D543}",
        "\u{2199}",
        "\u{2198}",
        "\u{2112}",
        "\u{21B0}",
        "\u{0141}",
        "\u{226A}",
        "\u{2905}",
        "\u{041C}",
        "\u{205F}",
        "\u{2133}",
        "\u{1D510}",
        "\u{2213}",
        "\u{1D544}",
        "\u{2133}",
        "\u{039C}",
        "\u{040A}",
        "\u{0143}",
        "\u{0147}",
        "\u{0145}",
        "\u{041D}",
        "\u{200B}",
        "\u{200B}",
        "\u{200B}",
        "\u{200B}",
        "\u{226B}",
        "\u{226A}",
        "\u{000A}",
        "\u{1D511}",
        "\u{2060}",
        "\u{00A0}",
        "\u{2115}",
        "\u{2AEC}",
        "\u{2262}",
        "\u{226D}",
        "\u{2226}",
        "\u{2209}",
        "\u{2260}",
        "\u{2242}\u{0338}",
        "\u{2204}",
        "\u{226F}",
        "\u{2271}",
        "\u{2267}\u{0338}",
        "\u{226B}\u{0338}",
        "\u{2279}",
        "\u{2A7E}\u{0338}",
        "\u{2275}",
        "\u{224E}\u{0338}",
        "\u{224F}\u{0338}",
        "\u{22EA}",
        "\u{29CF}\u{0338}",
        "\u{22EC}",
        "\u{226E}",
        "\u{2270}",
        "\u{2278}",
        "\u{226A}\u{0338}",
        "\u{2A7D}\u{0338}",
        "\u{2274}",
        "\u{2AA2}\u{0338}",
        "\u{2AA1}\u{0338}",
        "\u{2280}",
        "\u{2AAF}\u{0338}",
        "\u{22E0}",
        "\u{220C}",
        "\u{22EB}",
        "\u{29D0}\u{0338}",
        "\u{22ED}",
        "\u{228F}\u{0338}",
        "\u{22E2}",
        "\u{2290}\u{0338}",
        "\u{22E3}",
        "\u{2282}\u{20D2}",
        "\u{2288}",
        "\u{2281}",
        "\u{2AB0}\u{0338}",
        "\u{22E1}",
        "\u{227F}\u{0338}",
        "\u{2283}\u{20D2}",
        "\u{2289}",
        "\u{2241}",
        "\u{2244}",
        "\u{2247}",
        "\u{2249}",
        "\u{2224}",
        "\u{1D4A9}",
        "\u{00D1}",
        "\u{039D}",
        "\u{0152}",
        "\u{00D3}",
        "\u{00D4}",
        "\u{041E}",
        "\u{0150}",
        "\u{1D512}",
        "\u{00D2}",
        "\u{014C}",
        "\u{03A9}",
        "\u{039F}",
        "\u{1D546}",
        "\u{201C}",
        "\u{2018}",
        "\u{2A54}",
        "\u{1D4AA}",
        "\u{00D8}",
        "\u{00D5}",
        "\u{2A37}",
        "\u{00D6}",
        "\u{203E}",
        "\u{23DE}",
        "\u{23B4}",
        "\u{23DC}",
        "\u{2202}",
        "\u{041F}",
        "\u{1D513}",
        "\u{03A6}",
        "\u{03A0}",
        "\u{00B1}",
        "\u{210C}",
        "\u{2119}",
        "\u{2ABB}",
        "\u{227A}",
        "\u{2AAF}",
        "\u{227C}",
        "\u{227E}",
        "\u{2033}",
        "\u{220F}",
        "\u{2237}",
        "\u{221D}",
        "\u{1D4AB}",
        "\u{03A8}",
        "\u{0022}",
        "\u{1D514}",
        "\u{211A}",
        "\u{1D4AC}",
        "\u{2910}",
        "\u{00AE}",
        "\u{0154}",
        "\u{27EB}",
        "\u{21A0}",
        "\u{2916}",
        "\u{0158}",
        "\u{0156}",
        "\u{0420}",
        "\u{211C}",
        "\u{220B}",
        "\u{21CB}",
        "\u{296F}",
        "\u{211C}",
        "\u{03A1}",
        "\u{27E9}",
        "\u{2192}",
        "\u{21E5}",
        "\u{21C4}",
        "\u{2309}",
        "\u{27E7}",
        "\u{295D}",
        "\u{21C2}",
        "\u{2955}",
        "\u{230B}",
        "\u{22A2}",
        "\u{21A6}",
        "\u{295B}",
        "\u{22B3}",
        "\u{29D0}",
        "\u{22B5}",
        "\u{294F}",
        "\u{295C}",
        "\u{21BE}",
        "\u{2954}",
        "\u{21C0}",
        "\u{2953}",
        "\u{21D2}",
        "\u{211D}",
        "\u{2970}",
        "\u{21DB}",
        "\u{211B}",
        "\u{21B1}",
        "\u{29F4}",
        "\u{0429}",
        "\u{0428}",
        "\u{042C}",
        "\u{015A}",
        "\u{2ABC}",
        "\u{0160}",
        "\u{015E}",
        "\u{015C}",
        "\u{0421}",
        "\u{1D516}",
        "\u{2193}",
        "\u{2190}",
        "\u{2192}",
        "\u{2191}",
        "\u{03A3}",
        "\u{2218}",
        "\u{1D54A}",
        "\u{221A}",
        "\u{25A1}",
        "\u{2293}",
        "\u{228F}",
        "\u{2291}",
        "\u{2290}",
        "\u{2292}",
        "\u{2294}",
        "\u{1D4AE}",
        "\u{22C6}",
        "\u{22D0}",
        "\u{22D0}",
        "\u{2286}",
        "\u{227B}",
        "\u{2AB0}",
        "\u{227D}",
        "\u{227F}",
        "\u{220B}",
        "\u{2211}",
        "\u{22D1}",
        "\u{2283}",
        "\u{2287}",
        "\u{22D1}",
        "\u{00DE}",
        "\u{2122}",
        "\u{040B}",
        "\u{0426}",
        "\u{0009}",
        "\u{03A4}",
        "\u{0164}",
        "\u{0162}",
        "\u{0422}",
        "\u{1D517}",
        "\u{2234}",
        "\u{0398}",
        "\u{205F}\u{200A}",
        "\u{2009}",
        "\u{223C}",
        "\u{2243}",
        "\u{2245}",
        "\u{2248}",
        "\u{1D54B}",
        "\u{20DB}",
        "\u{1D4AF}",
        "\u{0166}",
        "\u{00DA}",
        "\u{219F}",
        "\u{2949}",
        "\u{040E}",
        "\u{016C}",
        "\u{00DB}",
        "\u{0423}",
        "\u{0170}",
        "\u{1D518}",
        "\u{00D9}",
        "\u{016A}",
        "\u{005F}",
        "\u{23DF}",
        "\u{23B5}",
        "\u{23DD}",
        "\u{22C3}",
        "\u{228E}",
        "\u{0172}",
        "\u{1D54C}",
        "\u{2191}",
        "\u{2912}",
        "\u{21C5}",
        "\u{2195}",
        "\u{296E}",
        "\u{22A5}",
        "\u{21A5}",
        "\u{21D1}",
        "\u{21D5}",
        "\u{2196}",
        "\u{2197}",
        "\u{03D2}",
        "\u{03A5}",
        "\u{016E}",
        "\u{1D4B0}",
        "\u{0168}",
        "\u{00DC}",
        "\u{22AB}",
        "\u{2AEB}",
        "\u{0412}",
        "\u{22A9}",
        "\u{2AE6}",
        "\u{22C1}",
        "\u{2016}",
        "\u{2016}",
        "\u{2223}",
        "\u{007C}",
        "\u{2758}",
        "\u{2240}",
        "\u{200A}",
        "\u{1D519}",
        "\u{1D54D}",
        "\u{1D4B1}",
        "\u{22AA}",
        "\u{0174}",
        "\u{22C0}",
        "\u{1D51A}",
        "\u{1D54E}",
        "\u{1D4B2}",
        "\u{1D51B}",
        "\u{039E}",
        "\u{1D54F}",
        "\u{1D4B3}",
        "\u{042F}",
        "\u{0407}",
        "\u{042E}",
        "\u{00DD}",
        "\u{0176}",
        "\u{042B}",
        "\u{1D51C}",
        "\u{1D550}",
        "\u{1D4B4}",
        "\u{0178}",
        "\u{0416}",
        "\u{0179}",
        "\u{017D}",
        "\u{0417}",
        "\u{017B}",
        "\u{200B}",
        "\u{0396}",
        "\u{2128}",
        "\u{2124}",
        "\u{1D4B5}",
        "\u{00E1}",
        "\u{0103}",
        "\u{223E}",
        "\u{223E}\u{0333}",
        "\u{223F}",
        "\u{00E2}",
        "\u{00B4}",
        "\u{0430}",
        "\u{00E6}",
        "\u{2061}",
        "\u{1D51E}",
        "\u{00E0}",
        "\u{2135}",
        "\u{2135}",
        "\u{03B1}",
        "\u{0101}",
        "\u{2A3F}",
        "\u{0026}",
        "\u{2227}",
        "\u{2A55}",
        "\u{2A5C}",
        "\u{2A58}",
        "\u{2A5A}",
        "\u{2220}",
        "\u{29A4}",
        "\u{2220}",
        "\u{2221}",
        "\u{29A8}",
        "\u{29A9}",
        "\u{29AA}",
        "\u{29AB}",
        "\u{29AC}",
        "\u{29AD}",
        "\u{29AE}",
        "\u{29AF}",
        "\u{221F}",
        "\u{22BE}",
        "\u{299D}",
        "\u{2222}",
        "\u{00C5}",
        "\u{237C}",
        "\u{0105}",
        "\u{1D552}",
        "\u{2248}",
        "\u{2A70}",
        "\u{2A6F}",
        "\u{224A}",
        "\u{224B}",
        "\u{0027}",
        "\u{2248}",
        "\u{224A}",
        "\u{00E5}",
        "\u{1D4B6}",
        "\u{002A}",
        "\u{2248}",
        "\u{224D}",
        "\u{00E3}",
        "\u{00E4}",
        "\u{2233}",
        "\u{2A11}",
        "\u{2AED}",
        "\u{224C}",
        "\u{03F6}",
        "\u{2035}",
        "\u{223D}",
        "\u{22CD}",
        "\u{22BD}",
        "\u{2305}",
        "\u{2305}",
        "\u{23B5}",
        "\u{23B6}",
        "\u{224C}",
        "\u{0431}",
        "\u{201E}",
        "\u{2235}",
        "\u{2235}",
        "\u{29B0}",
        "\u{03F6}",
        "\u{212C}",
        "\u{03B2}",
        "\u{2136}",
        "\u{226C}",
        "\u{1D51F}",
        "\u{22C2}",
        "\u{25EF}",
        "\u{22C3}",
        "\u{2A00}",
        "\u{2A01}",
        "\u{2A02}",
        "\u{2A06}",
        "\u{2605}",
        "\u{25BD}",
        "\u{25B3}",
        "\u{2A04}",
        "\u{22C1}",
        "\u{22C0}",
        "\u{290D}",
        "\u{29EB}",
        "\u{25AA}",
        "\u{25B4}",
        "\u{25BE}",
        "\u{25C2}",
        "\u{25B8}",
        "\u{2423}",
        "\u{2592}",
        "\u{2591}",
        "\u{2593}",
        "\u{2588}",
        "\u{003D}\u{20E5}",
        "\u{2261}\u{20E5}",
        "\u{2310}",
        "\u{1D553}",
        "\u{22A5}",
        "\u{22A5}",
        "\u{22C8}",
        "\u{2557}",
        "\u{2554}",
        "\u{2556}",
        "\u{2553}",
        "\u{2550}",
        "\u{2566}",
        "\u{2569}",
        "\u{2564}",
        "\u{2567}",
        "\u{255D}",
        "\u{255A}",
        "\u{255C}",
        "\u{2559}",
        "\u{2551}",
        "\u{256C}",
        "\u{2563}",
        "\u{2560}",
        "\u{256B}",
        "\u{2562}",
        "\u{255F}",
        "\u{29C9}",
        "\u{2555}",
        "\u{2552}",
        "\u{2510}",
        "\u{250C}",
        "\u{2500}",
        "\u{2565}",
        "\u{2568}",
        "\u{252C}",
        "\u{2534}",
        "\u{229F}",
        "\u{229E}",
        "\u{22A0}",
        "\u{255B}",
        "\u{2558}",
        "\u{2518}",
        "\u{2514}",
        "\u{2502}",
        "\u{256A}",
        "\u{2561}",
        "\u{255E}",
        "\u{253C}",
        "\u{2524}",
        "\u{251C}",
        "\u{2035}",
        "\u{02D8}",
        "\u{00A6}",
        "\u{1D4B7}",
        "\u{204F}",
        "\u{223D}",
        "\u{22CD}",
        "\u{005C}",
        "\u{29C5}",
        "\u{27C8}",
        "\u{2022}",
        "\u{2022}",
        "\u{224E}",
        "\u{2AAE}",
        "\u{224F}",
        "\u{224F}",
        "\u{0107}",
        "\u{2229}",
        "\u{2A44}",
        "\u{2A49}",
        "\u{2A4B}",
        "\u{2A47}",
        "\u{2A40}",
        "\u{2229}\u{FE00}",
        "\u{2041}",
        "\u{02C7}",
        "\u{2A4D}",
        "\u{010D}",
        "\u{00E7}",
        "\u{0109}",
        "\u{2A4C}",
        "\u{2A50}",
        "\u{010B}",
        "\u{00B8}",
        "\u{29B2}",
        "\u{00A2}",
        "\u{00B7}",
        "\u{1D520}",
        "\u{0447}",
        "\u{2713}",
        "\u{2713}",
        "\u{03C7}",
        "\u{25CB}",
        "\u{29C3}",
        "\u{02C6}",
        "\u{2257}",
        "\u{21BA}",
        "\u{21BB}",
        "\u{00AE}",
        "\u{24C8}",
        "\u{229B}",
        "\u{229A}",
        "\u{229D}",
        "\u{2257}",
        "\u{2A10}",
        "\u{2AEF}",
        "\u{29C2}",
        "\u{2663}",
        "\u{2663}",
        "\u{003A}",
        "\u{2254}",
        "\u{2254}",
        "\u{002C}",
        "\u{0040}",
        "\u{2201}",
        "\u{2218}",
        "\u{2201}",
        "\u{2102}",
        "\u{2245}",
        "\u{2A6D}",
        "\u{222E}",
        "\u{1D554}",
        "\u{2210}",
        "\u{00A9}",
        "\u{2117}",
        "\u{21B5}",
        "\u{2717}",
        "\u{1D4B8}",
        "\u{2ACF}",
        "\u{2AD1}",
        "\u{2AD0}",
        "\u{2AD2}",
        "\u{22EF}",
        "\u{2938}",
        "\u{2935}",
        "\u{22DE}",
        "\u{22DF}",
        "\u{21B6}",
        "\u{293D}",
        "\u{222A}",
        "\u{2A48}",
        "\u{2A46}",
        "\u{2A4A}",
        "\u{228D}",
        "\u{2A45}",
        "\u{222A}\u{FE00}",
        "\u{21B7}",
        "\u{293C}",
        "\u{22DE}",
        "\u{22DF}",
        "\u{22CE}",
        "\u{22CF}",
        "\u{00A4}",
        "\u{21B6}",
        "\u{21B7}",
        "\u{22CE}",
        "\u{22CF}",
        "\u{2232}",
        "\u{2231}",
        "\u{232D}",
        "\u{21D3}",
        "\u{2965}",
        "\u{2020}",
        "\u{2138}",
        "\u{2193}",
        "\u{2010}",
        "\u{22A3}",
        "\u{290F}",
        "\u{02DD}",
        "\u{010F}",
        "\u{0434}",
        "\u{2146}",
        "\u{2021}",
        "\u{21CA}",
        "\u{2A77}",
        "\u{00B0}",
        "\u{03B4}",
        "\u{29B1}",
        "\u{297F}",
        "\u{1D521}",
        "\u{21C3}",
        "\u{21C2}",
        "\u{22C4}",
        "\u{22C4}",
        "\u{2666}",
        "\u{2666}",
        "\u{00A8}",
        "\u{03DD}",
        "\u{22F2}",
        "\u{00F7}",
        "\u{00F7}",
        "\u{22C7}",
        "\u{22C7}",
        "\u{0452}",
        "\u{231E}",
        "\u{230D}",
        "\u{0024}",
        "\u{1D555}",
        "\u{02D9}",
        "\u{2250}",
        "\u{2251}",
        "\u{2238}",
        "\u{2214}",
        "\u{22A1}",
        "\u{2306}",
        "\u{2193}",
        "\u{21CA}",
        "\u{21C3}",
        "\u{21C2}",
        "\u{2910}",
        "\u{231F}",
        "\u{230C}",
        "\u{1D4B9}",
        "\u{0455}",
        "\u{29F6}",
        "\u{0111}",
        "\u{22F1}",
        "\u{25BF}",
        "\u{25BE}",
        "\u{21F5}",
        "\u{296F}",
        "\u{29A6}",
        "\u{045F}",
        "\u{27FF}",
        "\u{2A77}",
        "\u{2251}",
        "\u{00E9}",
        "\u{2A6E}",
        "\u{011B}",
        "\u{2256}",
        "\u{00EA}",
        "\u{2255}",
        "\u{044D}",
        "\u{0117}",
        "\u{2147}",
        "\u{2252}",
        "\u{1D522}",
        "\u{2A9A}",
        "\u{00E8}",
        "\u{2A96}",
        "\u{2A98}",
        "\u{2A99}",
        "\u{23E7}",
        "\u{2113}",
        "\u{2A95}",
        "\u{2A97}",
        "\u{0113}",
        "\u{2205}",
        "\u{2205}",
        "\u{2205}",
        "\u{2003}",
        "\u{2004}",
        "\u{2005}",
        "\u{014B}",
        "\u{2002}",
        "\u{0119}",
        "\u{1D556}",
        "\u{22D5}",
        "\u{29E3}",
        "\u{2A71}",
        "\u{03B5}",
        "\u{03B5}",
        "\u{03F5}",
        "\u{2256}",
        "\u{2255}",
        "\u{2242}",
        "\u{2A96}",
        "\u{2A95}",
        "\u{003D}",
        "\u{225F}",
        "\u{2261}",
        "\u{2A78}",
        "\u{29E5}",
        "\u{2253}",
        "\u{2971}",
        "\u{212F}",
        "\u{2250}",
        "\u{2242}",
        "\u{03B7}",
        "\u{00F0}",
        "\u{00EB}",
        "\u{20AC}",
        "\u{0021}",
        "\u{2203}",
        "\u{2130}",
        "\u{2147}",
        "\u{2252}",
        "\u{0444}",
        "\u{2640}",
        "\u{FB03}",
        "\u{FB00}",
        "\u{FB04}",
        "\u{1D523}",
        "\u{FB01}",
        "\u{0066}\u{006A}",
        "\u{266D}",
        "\u{FB02}",
        "\u{25B1}",
        "\u{0192}",
        "\u{1D557}",
        "\u{2200}",
        "\u{22D4}",
        "\u{2AD9}",
        "\u{2A0D}",
        "\u{00BD}",
        "\u{2153}",
        "\u{00BC}",
        "\u{2155}",
        "\u{2159}",
        "\u{215B}",
        "\u{2154}",
        "\u{2156}",
        "\u{00BE}",
        "\u{2157}",
        "\u{215C}",
        "\u{2158}",
        "\u{215A}",
        "\u{215D}",
        "\u{215E}",
        "\u{2044}",
        "\u{2322}",
        "\u{1D4BB}",
        "\u{2267}",
        "\u{2A8C}",
        "\u{01F5}",
        "\u{03B3}",
        "\u{03DD}",
        "\u{2A86}",
        "\u{011F}",
        "\u{011D}",
        "\u{0433}",
        "\u{0121}",
        "\u{2265}",
        "\u{22DB}",
        "\u{2265}",
        "\u{2267}",
        "\u{2A7E}",
        "\u{2A7E}",
        "\u{2AA9}",
        "\u{2A80}",
        "\u{2A82}",
        "\u{2A84}",
        "\u{22DB}\u{FE00}",
        "\u{2A94}",
        "\u{1D524}",
        "\u{226B}",
        "\u{22D9}",
        "\u{2137}",
        "\u{0453}",
        "\u{2277}",
        "\u{2A92}",
        "\u{2AA5}",
        "\u{2AA4}",
        "\u{2269}",
        "\u{2A8A}",
        "\u{2A8A}",
        "\u{2A88}",
        "\u{2A88}",
        "\u{2269}",
        "\u{22E7}",
        "\u{1D558}",
        "\u{0060}",
        "\u{210A}",
        "\u{2273}",
        "\u{2A8E}",
        "\u{2A90}",
        "\u{003E}",
        "\u{2AA7}",
        "\u{2A7A}",
        "\u{22D7}",
        "\u{2995}",
        "\u{2A7C}",
        "\u{2A86}",
        "\u{2978}",
        "\u{22D7}",
        "\u{22DB}",
        "\u{2A8C}",
        "\u{2277}",
        "\u{2273}",
        "\u{2269}\u{FE00}",
        "\u{2269}\u{FE00}",
        "\u{21D4}",
        "\u{200A}",
        "\u{00BD}",
        "\u{210B}",
        "\u{044A}",
        "\u{2194}",
        "\u{2948}",
        "\u{21AD}",
        "\u{210F}",
        "\u{0125}",
        "\u{2665}",
        "\u{2665}",
        "\u{2026}",
        "\u{22B9}",
        "\u{1D525}",
        "\u{2925}",
        "\u{2926}",
        "\u{21FF}",
        "\u{223B}",
        "\u{21A9}",
        "\u{21AA}",
        "\u{1D559}",
        "\u{2015}",
        "\u{1D4BD}",
        "\u{210F}",
        "\u{0127}",
        "\u{2043}",
        "\u{2010}",
        "\u{00ED}",
        "\u{2063}",
        "\u{00EE}",
        "\u{0438}",
        "\u{0435}",
        "\u{00A1}",
        "\u{21D4}",
        "\u{1D526}",
        "\u{00EC}",
        "\u{2148}",
        "\u{2A0C}",
        "\u{222D}",
        "\u{29DC}",
        "\u{2129}",
        "\u{0133}",
        "\u{012B}",
        "\u{2111}",
        "\u{2110}",
        "\u{2111}",
        "\u{0131}",
        "\u{22B7}",
        "\u{01B5}",
        "\u{2208}",
        "\u{2105}",
        "\u{221E}",
        "\u{29DD}",
        "\u{0131}",
        "\u{222B}",
        "\u{22BA}",
        "\u{2124}",
        "\u{22BA}",
        "\u{2A17}",
        "\u{2A3C}",
        "\u{0451}",
        "\u{012F}",
        "\u{1D55A}",
        "\u{03B9}",
        "\u{2A3C}",
        "\u{00BF}",
        "\u{1D4BE}",
        "\u{2208}",
        "\u{22F9}",
        "\u{22F5}",
        "\u{22F4}",
        "\u{22F3}",
        "\u{2208}",
        "\u{2062}",
        "\u{0129}",
        "\u{0456}",
        "\u{00EF}",
        "\u{0135}",
        "\u{0439}",
        "\u{1D527}",
        "\u{0237}",
        "\u{1D55B}",
        "\u{1D4BF}",
        "\u{0458}",
        "\u{0454}",
        "\u{03BA}",
        "\u{03F0}",
        "\u{0137}",
        "\u{043A}",
        "\u{1D528}",
        "\u{0138}",
        "\u{0445}",
        "\u{045C}",
        "\u{1D55C}",
        "\u{1D4C0}",
        "\u{21DA}",
        "\u{21D0}",
        "\u{291B}",
        "\u{290E}",
        "\u{2266}",
        "\u{2A8B}",
        "\u{2962}",
        "\u{013A}",
        "\u{29B4}",
        "\u{2112}",
        "\u{03BB}",
        "\u{27E8}",
        "\u{2991}",
        "\u{27E8}",
        "\u{2A85}",
        "\u{00AB}",
        "\u{2190}",
        "\u{21E4}",
        "\u{291F}",
        "\u{291D}",
        "\u{21A9}",
        "\u{21AB}",
        "\u{2939}",
        "\u{2973}",
        "\u{21A2}",
        "\u{2AAB}",
        "\u{2919}",
        "\u{2AAD}",
        "\u{2AAD}\u{FE00}",
        "\u{290C}",
        "\u{2772}",
        "\u{007B}",
        "\u{005B}",
        "\u{298B}",
        "\u{298F}",
        "\u{298D}",
        "\u{013E}",
        "\u{013C}",
        "\u{2308}",
        "\u{007B}",
        "\u{043B}",
        "\u{2936}",
        "\u{201C}",
        "\u{201E}",
        "\u{2967}",
        "\u{294B}",
        "\u{21B2}",
        "\u{2264}",
        "\u{2190}",
        "\u{21A2}",
        "\u{21BD}",
        "\u{21BC}",
        "\u{21C7}",
        "\u{2194}",
        "\u{21C6}",
        "\u{21CB}",
        "\u{21AD}",
        "\u{22CB}",
        "\u{22DA}",
        "\u{2264}",
        "\u{2266}",
        "\u{2A7D}",
        "\u{2A7D}",
        "\u{2AA8}",
        "\u{2A7F}",
        "\u{2A81}",
        "\u{2A83}",
        "\u{22DA}\u{FE00}",
        "\u{2A93}",
        "\u{2A85}",
        "\u{22D6}",
        "\u{22DA}",
        "\u{2A8B}",
        "\u{2276}",
        "\u{2272}",
        "\u{297C}",
        "\u{230A}",
        "\u{1D529}",
        "\u{2276}",
        "\u{2A91}",
        "\u{21BD}",
        "\u{21BC}",
        "\u{296A}",
        "\u{2584}",
        "\u{0459}",
        "\u{226A}",
        "\u{21C7}",
        "\u{231E}",
        "\u{296B}",
        "\u{25FA}",
        "\u{0140}",
        "\u{23B0}",
        "\u{23B0}",
        "\u{2268}",
        "\u{2A89}",
        "\u{2A89}",
        "\u{2A87}",
        "\u{2A87}",
        "\u{2268}",
        "\u{22E6}",
        "\u{27EC}",
        "\u{21FD}",
        "\u{27E6}",
        "\u{27F5}",
        "\u{27F7}",
        "\u{27FC}",
        "\u{27F6}",
        "\u{21AB}",
        "\u{21AC}",
        "\u{2985}",
        "\u{1D55D}",
        "\u{2A2D}",
        "\u{2A34}",
        "\u{2217}",
        "\u{005F}",
        "\u{25CA}",
        "\u{25CA}",
        "\u{29EB}",
        "\u{0028}",
        "\u{2993}",
        "\u{21C6}",
        "\u{231F}",
        "\u{21CB}",
        "\u{296D}",
        "\u{200E}",
        "\u{22BF}",
        "\u{2039}",
        "\u{1D4C1}",
        "\u{21B0}",
        "\u{2272}",
        "\u{2A8D}",
        "\u{2A8F}",
        "\u{005B}",
        "\u{2018}",
        "\u{201A}",
        "\u{0142}",
        "\u{003C}",
        "\u{2AA6}",
        "\u{2A79}",
        "\u{22D6}",
        "\u{22CB}",
        "\u{22C9}",
        "\u{2976}",
        "\u{2A7B}",
        "\u{2996}",
        "\u{25C3}",
        "\u{22B4}",
        "\u{25C2}",
        "\u{294A}",
        "\u{2966}",
        "\u{2268}\u{FE00}",
        "\u{2268}\u{FE00}",
        "\u{223A}",
        "\u{00AF}",
        "\u{2642}",
        "\u{2720}",
        "\u{2720}",
        "\u{21A6}",
        "\u{21A6}",
        "\u{21A7}",
        "\u{21A4}",
        "\u{21A5}",
        "\u{25AE}",
        "\u{2A29}",
        "\u{043C}",
        "\u{2014}",
        "\u{2221}",
        "\u{1D52A}",
        "\u{2127}",
        "\u{00B5}",
        "\u{2223}",
        "\u{002A}",
        "\u{2AF0}",
        "\u{00B7}",
        "\u{2212}",
        "\u{229F}",
        "\u{2238}",
        "\u{2A2A}",
        "\u{2ADB}",
        "\u{2026}",
        "\u{2213}",
        "\u{22A7}",
        "\u{1D55E}",
        "\u{2213}",
        "\u{1D4C2}",
        "\u{223E}",
        "\u{03BC}",
        "\u{22B8}",
        "\u{22B8}",
        "\u{22D9}\u{0338}",
        "\u{226B}\u{20D2}",
        "\u{226B}\u{0338}",
        "\u{21CD}",
        "\u{21CE}",
        "\u{22D8}\u{0338}",
        "\u{226A}\u{20D2}",
        "\u{226A}\u{0338}",
        "\u{21CF}",
        "\u{22AF}",
        "\u{22AE}",
        "\u{2207}",
        "\u{0144}",
        "\u{2220}\u{20D2}",
        "\u{2249}",
        "\u{2A70}\u{0338}",
        "\u{224B}\u{0338}",
        "\u{0149}",
        "\u{2249}",
        "\u{266E}",
        "\u{266E}",
        "\u{2115}",
        "\u{00A0}",
        "\u{224E}\u{0338}",
        "\u{224F}\u{0338}",
        "\u{2A43}",
        "\u{0148}",
        "\u{0146}",
        "\u{2247}",
        "\u{2A6D}\u{0338}",
        "\u{2A42}",
        "\u{043D}",
        "\u{2013}",
        "\u{2260}",
        "\u{21D7}",
        "\u{2924}",
        "\u{2197}",
        "\u{2197}",
        "\u{2250}\u{0338}",
        "\u{2262}",
        "\u{2928}",
        "\u{2242}\u{0338}",
        "\u{2204}",
        "\u{2204}",
        "\u{1D52B}",
        "\u{2267}\u{0338}",
        "\u{2271}",
        "\u{2271}",
        "\u{2267}\u{0338}",
        "\u{2A7E}\u{0338}",
        "\u{2A7E}\u{0338}",
        "\u{2275}",
        "\u{226F}",
        "\u{226F}",
        "\u{21CE}",
        "\u{21AE}",
        "\u{2AF2}",
        "\u{220B}",
        "\u{22FC}",
        "\u{22FA}",
        "\u{220B}",
        "\u{045A}",
        "\u{21CD}",
        "\u{2266}\u{0338}",
        "\u{219A}",
        "\u{2025}",
        "\u{2270}",
        "\u{219A}",
        "\u{21AE}",
        "\u{2270}",
        "\u{2266}\u{0338}",
        "\u{2A7D}\u{0338}",
        "\u{2A7D}\u{0338}",
        "\u{226E}",
        "\u{2274}",
        "\u{226E}",
        "\u{22EA}",
        "\u{22EC}",
        "\u{2224}",
        "\u{1D55F}",
        "\u{00AC}",
        "\u{2209}",
        "\u{22F9}\u{0338}",
        "\u{22F5}\u{0338}",
        "\u{2209}",
        "\u{22F7}",
        "\u{22F6}",
        "\u{220C}",
        "\u{220C}",
        "\u{22FE}",
        "\u{22FD}",
        "\u{2226}",
        "\u{2226}",
        "\u{2AFD}\u{20E5}",
        "\u{2202}\u{0338}",
        "\u{2A14}",
        "\u{2280}",
        "\u{22E0}",
        "\u{2AAF}\u{0338}",
        "\u{2280}",
        "\u{2AAF}\u{0338}",
        "\u{21CF}",
        "\u{219B}",
        "\u{2933}\u{0338}",
        "\u{219D}\u{0338}",
        "\u{219B}",
        "\u{22EB}",
        "\u{22ED}",
        "\u{2281}",
        "\u{22E1}",
        "\u{2AB0}\u{0338}",
        "\u{1D4C3}",
        "\u{2224}",
        "\u{2226}",
        "\u{2241}",
        "\u{2244}",
        "\u{2244}",
        "\u{2224}",
        "\u{2226}",
        "\u{22E2}",
        "\u{22E3}",
        "\u{2284}",
        "\u{2AC5}\u{0338}",
        "\u{2288}",
        "\u{2282}\u{20D2}",
        "\u{2288}",
        "\u{2AC5}\u{0338}",
        "\u{2281}",
        "\u{2AB0}\u{0338}",
        "\u{2285}",
        "\u{2AC6}\u{0338}",
        "\u{2289}",
        "\u{2283}\u{20D2}",
        "\u{2289}",
        "\u{2AC6}\u{0338}",
        "\u{2279}",
        "\u{00F1}",
        "\u{2278}",
        "\u{22EA}",
        "\u{22EC}",
        "\u{22EB}",
        "\u{22ED}",
        "\u{03BD}",
        "\u{0023}",
        "\u{2116}",
        "\u{2007}",
        "\u{22AD}",
        "\u{2904}",
        "\u{224D}\u{20D2}",
        "\u{22AC}",
        "\u{2265}\u{20D2}",
        "\u{003E}\u{20D2}",
        "\u{29DE}",
        "\u{2902}",
        "\u{2264}\u{20D2}",
        "\u{003C}\u{20D2}",
        "\u{22B4}\u{20D2}",
        "\u{2903}",
        "\u{22B5}\u{20D2}",
        "\u{223C}\u{20D2}",
        "\u{21D6}",
        "\u{2923}",
        "\u{2196}",
        "\u{2196}",
        "\u{2927}",
        "\u{24C8}",
        "\u{00F3}",
        "\u{229B}",
        "\u{229A}",
        "\u{00F4}",
        "\u{043E}",
        "\u{229D}",
        "\u{0151}",
        "\u{2A38}",
        "\u{2299}",
        "\u{29BC}",
        "\u{0153}",
        "\u{29BF}",
        "\u{1D52C}",
        "\u{02DB}",
        "\u{00F2}",
        "\u{29C1}",
        "\u{29B5}",
        "\u{03A9}",
        "\u{222E}",
        "\u{21BA}",
        "\u{29BE}",
        "\u{29BB}",
        "\u{203E}",
        "\u{29C0}",
        "\u{014D}",
        "\u{03C9}",
        "\u{03BF}",
        "\u{29B6}",
        "\u{2296}",
        "\u{1D560}",
        "\u{29B7}",
        "\u{29B9}",
        "\u{2295}",
        "\u{2228}",
        "\u{21BB}",
        "\u{2A5D}",
        "\u{2134}",
        "\u{2134}",
        "\u{00AA}",
        "\u{00BA}",
        "\u{22B6}",
        "\u{2A56}",
        "\u{2A57}",
        "\u{2A5B}",
        "\u{2134}",
        "\u{00F8}",
        "\u{2298}",
        "\u{00F5}",
        "\u{2297}",
        "\u{2A36}",
        "\u{00F6}",
        "\u{233D}",
        "\u{2225}",
        "\u{00B6}",
        "\u{2225}",
        "\u{2AF3}",
        "\u{2AFD}",
        "\u{2202}",
        "\u{043F}",
        "\u{0025}",
        "\u{002E}",
        "\u{2030}",
        "\u{22A5}",
        "\u{2031}",
        "\u{1D52D}",
        "\u{03C6}",
        "\u{03D5}",
        "\u{2133}",
        "\u{260E}",
        "\u{03C0}",
        "\u{22D4}",
        "\u{03D6}",
        "\u{210F}",
        "\u{210E}",
        "\u{210F}",
        "\u{002B}",
        "\u{2A23}",
        "\u{229E}",
        "\u{2A22}",
        "\u{2214}",
        "\u{2A25}",
        "\u{2A72}",
        "\u{00B1}",
        "\u{2A26}",
        "\u{2A27}",
        "\u{00B1}",
        "\u{2A15}",
        "\u{1D561}",
        "\u{00A3}",
        "\u{227A}",
        "\u{2AB3}",
        "\u{2AB7}",
        "\u{227C}",
        "\u{2AAF}",
        "\u{227A}",
        "\u{2AB7}",
        "\u{227C}",
        "\u{2AAF}",
        "\u{2AB9}",
        "\u{2AB5}",
        "\u{22E8}",
        "\u{227E}",
        "\u{2032}",
        "\u{2119}",
        "\u{2AB5}",
        "\u{2AB9}",
        "\u{22E8}",
        "\u{220F}",
        "\u{232E}",
        "\u{2312}",
        "\u{2313}",
        "\u{221D}",
        "\u{221D}",
        "\u{227E}",
        "\u{22B0}",
        "\u{1D4C5}",
        "\u{03C8}",
        "\u{2008}",
        "\u{1D52E}",
        "\u{2A0C}",
        "\u{1D562}",
        "\u{2057}",
        "\u{1D4C6}",
        "\u{210D}",
        "\u{2A16}",
        "\u{003F}",
        "\u{225F}",
        "\u{0022}",
        "\u{21DB}",
        "\u{21D2}",
        "\u{291C}",
        "\u{290F}",
        "\u{2964}",
        "\u{223D}\u{0331}",
        "\u{0155}",
        "\u{221A}",
        "\u{29B3}",
        "\u{27E9}",
        "\u{2992}",
        "\u{29A5}",
        "\u{27E9}",
        "\u{00BB}",
        "\u{2192}",
        "\u{2975}",
        "\u{21E5}",
        "\u{2920}",
        "\u{2933}",
        "\u{291E}",
        "\u{21AA}",
        "\u{21AC}",
        "\u{2945}",
        "\u{2974}",
        "\u{21A3}",
        "\u{219D}",
        "\u{291A}",
        "\u{2236}",
        "\u{211A}",
        "\u{290D}",
        "\u{2773}",
        "\u{007D}",
        "\u{005D}",
        "\u{298C}",
        "\u{298E}",
        "\u{2990}",
        "\u{0159}",
        "\u{0157}",
        "\u{2309}",
        "\u{007D}",
        "\u{0440}",
        "\u{2937}",
        "\u{2969}",
        "\u{201D}",
        "\u{201D}",
        "\u{21B3}",
        "\u{211C}",
        "\u{211B}",
        "\u{211C}",
        "\u{211D}",
        "\u{25AD}",
        "\u{00AE}",
        "\u{297D}",
        "\u{230B}",
        "\u{1D52F}",
        "\u{21C1}",
        "\u{21C0}",
        "\u{296C}",
        "\u{03C1}",
        "\u{03F1}",
        "\u{2192}",
        "\u{21A3}",
        "\u{21C1}",
        "\u{21C0}",
        "\u{21C4}",
        "\u{21CC}",
        "\u{21C9}",
        "\u{219D}",
        "\u{22CC}",
        "\u{02DA}",
        "\u{2253}",
        "\u{21C4}",
        "\u{21CC}",
        "\u{200F}",
        "\u{23B1}",
        "\u{23B1}",
        "\u{2AEE}",
        "\u{27ED}",
        "\u{21FE}",
        "\u{27E7}",
        "\u{2986}",
        "\u{1D563}",
        "\u{2A2E}",
        "\u{2A35}",
        "\u{0029}",
        "\u{2994}",
        "\u{2A12}",
        "\u{21C9}",
        "\u{203A}",
        "\u{1D4C7}",
        "\u{21B1}",
        "\u{005D}",
        "\u{2019}",
        "\u{2019}",
        "\u{22CC}",
        "\u{22CA}",
        "\u{25B9}",
        "\u{22B5}",
        "\u{25B8}",
        "\u{29CE}",
        "\u{2968}",
        "\u{211E}",
        "\u{015B}",
        "\u{201A}",
        "\u{227B}",
        "\u{2AB4}",
        "\u{2AB8}",
        "\u{0161}",
        "\u{227D}",
        "\u{2AB0}",
        "\u{015F}",
        "\u{015D}",
        "\u{2AB6}",
        "\u{2ABA}",
        "\u{22E9}",
        "\u{2A13}",
        "\u{227F}",
        "\u{0441}",
        "\u{22C5}",
        "\u{22A1}",
        "\u{2A66}",
        "\u{21D8}",
        "\u{2925}",
        "\u{2198}",
        "\u{2198}",
        "\u{00A7}",
        "\u{003B}",
        "\u{2929}",
        "\u{2216}",
        "\u{2216}",
        "\u{2736}",
        "\u{1D530}",
        "\u{2322}",
        "\u{266F}",
        "\u{0449}",
        "\u{0448}",
        "\u{2223}",
        "\u{2225}",
        "\u{00AD}",
        "\u{03C3}",
        "\u{03C2}",
        "\u{03C2}",
        "\u{223C}",
        "\u{2A6A}",
        "\u{2243}",
        "\u{2243}",
        "\u{2A9E}",
        "\u{2AA0}",
        "\u{2A9D}",
        "\u{2A9F}",
        "\u{2246}",
        "\u{2A24}",
        "\u{2972}",
        "\u{2190}",
        "\u{2216}",
        "\u{2A33}",
        "\u{29E4}",
        "\u{2223}",
        "\u{2323}",
        "\u{2AAA}",
        "\u{2AAC}",
        "\u{2AAC}\u{FE00}",
        "\u{044C}",
        "\u{002F}",
        "\u{29C4}",
        "\u{233F}",
        "\u{1D564}",
        "\u{2660}",
        "\u{2660}",
        "\u{2225}",
        "\u{2293}",
        "\u{2293}\u{FE00}",
        "\u{2294}",
        "\u{2294}\u{FE00}",
        "\u{228F}",
        "\u{2291}",
        "\u{228F}",
        "\u{2291}",
        "\u{2290}",
        "\u{2292}",
        "\u{2290}",
        "\u{2292}",
        "\u{25A1}",
        "\u{25A1}",
        "\u{25AA}",
        "\u{25AA}",
        "\u{2192}",
        "\u{1D4C8}",
        "\u{2216}",
        "\u{2323}",
        "\u{22C6}",
        "\u{2606}",
        "\u{2605}",
        "\u{03F5}",
        "\u{03D5}",
        "\u{00AF}",
        "\u{2282}",
        "\u{2AC5}",
        "\u{2ABD}",
        "\u{2286}",
        "\u{2AC3}",
        "\u{2AC1}",
        "\u{2ACB}",
        "\u{228A}",
        "\u{2ABF}",
        "\u{2979}",
        "\u{2282}",
        "\u{2286}",
        "\u{2AC5}",
        "\u{228A}",
        "\u{2ACB}",
        "\u{2AC7}",
        "\u{2AD5}",
        "\u{2AD3}",
        "\u{227B}",
        "\u{2AB8}",
        "\u{227D}",
        "\u{2AB0}",
        "\u{2ABA}",
        "\u{2AB6}",
        "\u{22E9}",
        "\u{227F}",
        "\u{2211}",
        "\u{266A}",
        "\u{2283}",
        "\u{00B9}",
        "\u{00B2}",
        "\u{00B3}",
        "\u{2AC6}",
        "\u{2ABE}",
        "\u{2AD8}",
        "\u{2287}",
        "\u{2AC4}",
        "\u{27C9}",
        "\u{2AD7}",
        "\u{297B}",
        "\u{2AC2}",
        "\u{2ACC}",
        "\u{228B}",
        "\u{2AC0}",
        "\u{2283}",
        "\u{2287}",
        "\u{2AC6}",
        "\u{228B}",
        "\u{2ACC}",
        "\u{2AC8}",
        "\u{2AD4}",
        "\u{2AD6}",
        "\u{21D9}",
        "\u{2926}",
        "\u{2199}",
        "\u{2199}",
        "\u{292A}",
        "\u{00DF}",
        "\u{2316}",
        "\u{03C4}",
        "\u{23B4}",
        "\u{0165}",
        "\u{0163}",
        "\u{0442}",
        "\u{20DB}",
        "\u{2315}",
        "\u{1D531}",
        "\u{2234}",
        "\u{2234}",
        "\u{03B8}",
        "\u{03D1}",
        "\u{03D1}",
        "\u{2248}",
        "\u{223C}",
        "\u{2009}",
        "\u{2248}",
        "\u{223C}",
        "\u{00FE}",
        "\u{02DC}",
        "\u{00D7}",
        "\u{22A0}",
        "\u{2A31}",
        "\u{2A30}",
        "\u{222D}",
        "\u{2928}",
        "\u{22A4}",
        "\u{2336}",
        "\u{2AF1}",
        "\u{1D565}",
        "\u{2ADA}",
        "\u{2929}",
        "\u{2034}",
        "\u{2122}",
        "\u{25B5}",
        "\u{25BF}",
        "\u{25C3}",
        "\u{22B4}",
        "\u{225C}",
        "\u{25B9}",
        "\u{22B5}",
        "\u{25EC}",
        "\u{225C}",
        "\u{2A3A}",
        "\u{2A39}",
        "\u{29CD}",
        "\u{2A3B}",
        "\u{23E2}",
        "\u{1D4C9}",
        "\u{0446}",
        "\u{045B}",
        "\u{0167}",
        "\u{226C}",
        "\u{219E}",
        "\u{21A0}",
        "\u{21D1}",
        "\u{2963}",
        "\u{00FA}",
        "\u{2191}",
        "\u{045E}",
        "\u{016D}",
        "\u{00FB}",
        "\u{0443}",
        "\u{21C5}",
        "\u{0171}",
        "\u{296E}",
        "\u{297E}",
        "\u{1D532}",
        "\u{00F9}",
        "\u{21BF}",
        "\u{21BE}",
        "\u{2580}",
        "\u{231C}",
        "\u{231C}",
        "\u{230F}",
        "\u{25F8}",
        "\u{016B}",
        "\u{00A8}",
        "\u{0173}",
        "\u{1D566}",
        "\u{2191}",
        "\u{2195}",
        "\u{21BF}",
        "\u{21BE}",
        "\u{228E}",
        "\u{03C5}",
        "\u{03D2}",
        "\u{03C5}",
        "\u{21C8}",
        "\u{231D}",
        "\u{231D}",
        "\u{230E}",
        "\u{016F}",
        "\u{25F9}",
        "\u{1D4CA}",
        "\u{22F0}",
        "\u{0169}",
        "\u{25B5}",
        "\u{25B4}",
        "\u{21C8}",
        "\u{00FC}",
        "\u{29A7}",
        "\u{21D5}",
        "\u{2AE8}",
        "\u{2AE9}",
        "\u{22A8}",
        "\u{299C}",
        "\u{03F5}",
        "\u{03F0}",
        "\u{2205}",
        "\u{03D5}",
        "\u{03D6}",
        "\u{221D}",
        "\u{2195}",
        "\u{03F1}",
        "\u{03C2}",
        "\u{228A}\u{FE00}",
        "\u{2ACB}\u{FE00}",
        "\u{228B}\u{FE00}",
        "\u{2ACC}\u{FE00}",
        "\u{03D1}",
        "\u{22B2}",
        "\u{22B3}",
        "\u{0432}",
        "\u{22A2}",
        "\u{2228}",
        "\u{22BB}",
        "\u{225A}",
        "\u{22EE}",
        "\u{007C}",
        "\u{007C}",
        "\u{1D533}",
        "\u{22B2}",
        "\u{2282}\u{20D2}",
        "\u{2283}\u{20D2}",
        "\u{1D567}",
        "\u{221D}",
        "\u{22B3}",
        "\u{1D4CB}",
        "\u{2ACB}\u{FE00}",
        "\u{228A}\u{FE00}",
        "\u{2ACC}\u{FE00}",
        "\u{228B}\u{FE00}",
        "\u{299A}",
        "\u{0175}",
        "\u{2A5F}",
        "\u{2227}",
        "\u{2259}",
        "\u{2118}",
        "\u{1D534}",
        "\u{1D568}",
        "\u{2118}",
        "\u{2240}",
        "\u{2240}",
        "\u{1D4CC}",
        "\u{22C2}",
        "\u{25EF}",
        "\u{22C3}",
        "\u{25BD}",
        "\u{1D535}",
        "\u{27FA}",
        "\u{27F7}",
        "\u{03BE}",
        "\u{27F8}",
        "\u{27F5}",
        "\u{27FC}",
        "\u{22FB}",
        "\u{2A00}",
        "\u{1D569}",
        "\u{2A01}",
        "\u{2A02}",
        "\u{27F9}",
        "\u{27F6}",
        "\u{1D4CD}",
        "\u{2A06}",
        "\u{2A04}",
        "\u{25B3}",
        "\u{22C1}",
        "\u{22C0}",
        "\u{00FD}",
        "\u{044F}",
        "\u{0177}",
        "\u{044B}",
        "\u{00A5}",
        "\u{1D536}",
        "\u{0457}",
        "\u{1D56A}",
        "\u{1D4CE}",
        "\u{044E}",
        "\u{00FF}",
        "\u{017A}",
        "\u{017E}",
        "\u{0437}",
        "\u{017C}",
        "\u{2128}",
        "\u{03B6}",
        "\u{1D537}",
        "\u{0436}",
        "\u{21DD}",
        "\u{1D56B}",
        "\u{1D4CF}",
        "\u{200D}",
        "\u{200C}",
    ];

pub fn get_entity(name: &str) -> Option<&'static str> {
    ENTITIES.binary_search(&name).ok().map(|i| ENTITY_VALUES[i])
}

