// Autogenerated file - DO NOT EDIT
use phf;
use std::borrow::Cow;

/// A SQLSTATE error code
#[derive(PartialEq, Eq, Clone, Debug)]
pub struct SqlState(Cow<'static, str>);

impl SqlState {
    /// Creates a `SqlState` from its error code.
    pub fn from_code(s: &str) -> SqlState {
        match SQLSTATE_MAP.get(s) {
            Some(state) => state.clone(),
            None => SqlState(Cow::Owned(s.to_string())),
        }
    }

    /// Returns the error code corresponding to the `SqlState`.
    pub fn code(&self) -> &str {
        &self.0
    }
}

/// 00000
pub const SUCCESSFUL_COMPLETION: SqlState = SqlState(Cow::Borrowed("00000"));

/// 01000
pub const WARNING: SqlState = SqlState(Cow::Borrowed("01000"));

/// 0100C
pub const WARNING_DYNAMIC_RESULT_SETS_RETURNED: SqlState = SqlState(Cow::Borrowed("0100C"));

/// 01008
pub const WARNING_IMPLICIT_ZERO_BIT_PADDING: SqlState = SqlState(Cow::Borrowed("01008"));

/// 01003
pub const WARNING_NULL_VALUE_ELIMINATED_IN_SET_FUNCTION: SqlState = SqlState(Cow::Borrowed("01003"));

/// 01007
pub const WARNING_PRIVILEGE_NOT_GRANTED: SqlState = SqlState(Cow::Borrowed("01007"));

/// 01006
pub const WARNING_PRIVILEGE_NOT_REVOKED: SqlState = SqlState(Cow::Borrowed("01006"));

/// 01004
pub const WARNING_STRING_DATA_RIGHT_TRUNCATION: SqlState = SqlState(Cow::Borrowed("01004"));

/// 01P01
pub const WARNING_DEPRECATED_FEATURE: SqlState = SqlState(Cow::Borrowed("01P01"));

/// 02000
pub const NO_DATA: SqlState = SqlState(Cow::Borrowed("02000"));

/// 02001
pub const NO_ADDITIONAL_DYNAMIC_RESULT_SETS_RETURNED: SqlState = SqlState(Cow::Borrowed("02001"));

/// 03000
pub const SQL_STATEMENT_NOT_YET_COMPLETE: SqlState = SqlState(Cow::Borrowed("03000"));

/// 08000
pub const CONNECTION_EXCEPTION: SqlState = SqlState(Cow::Borrowed("08000"));

/// 08003
pub const CONNECTION_DOES_NOT_EXIST: SqlState = SqlState(Cow::Borrowed("08003"));

/// 08006
pub const CONNECTION_FAILURE: SqlState = SqlState(Cow::Borrowed("08006"));

/// 08001
pub const SQLCLIENT_UNABLE_TO_ESTABLISH_SQLCONNECTION: SqlState = SqlState(Cow::Borrowed("08001"));

/// 08004
pub const SQLSERVER_REJECTED_ESTABLISHMENT_OF_SQLCONNECTION: SqlState = SqlState(Cow::Borrowed("08004"));

/// 08007
pub const TRANSACTION_RESOLUTION_UNKNOWN: SqlState = SqlState(Cow::Borrowed("08007"));

/// 08P01
pub const PROTOCOL_VIOLATION: SqlState = SqlState(Cow::Borrowed("08P01"));

/// 09000
pub const TRIGGERED_ACTION_EXCEPTION: SqlState = SqlState(Cow::Borrowed("09000"));

/// 0A000
pub const FEATURE_NOT_SUPPORTED: SqlState = SqlState(Cow::Borrowed("0A000"));

/// 0B000
pub const INVALID_TRANSACTION_INITIATION: SqlState = SqlState(Cow::Borrowed("0B000"));

/// 0F000
pub const LOCATOR_EXCEPTION: SqlState = SqlState(Cow::Borrowed("0F000"));

/// 0F001
pub const L_E_INVALID_SPECIFICATION: SqlState = SqlState(Cow::Borrowed("0F001"));

/// 0L000
pub const INVALID_GRANTOR: SqlState = SqlState(Cow::Borrowed("0L000"));

/// 0LP01
pub const INVALID_GRANT_OPERATION: SqlState = SqlState(Cow::Borrowed("0LP01"));

/// 0P000
pub const INVALID_ROLE_SPECIFICATION: SqlState = SqlState(Cow::Borrowed("0P000"));

/// 0Z000
pub const DIAGNOSTICS_EXCEPTION: SqlState = SqlState(Cow::Borrowed("0Z000"));

/// 0Z002
pub const STACKED_DIAGNOSTICS_ACCESSED_WITHOUT_ACTIVE_HANDLER: SqlState = SqlState(Cow::Borrowed("0Z002"));

/// 20000
pub const CASE_NOT_FOUND: SqlState = SqlState(Cow::Borrowed("20000"));

/// 21000
pub const CARDINALITY_VIOLATION: SqlState = SqlState(Cow::Borrowed("21000"));

/// 22000
pub const DATA_EXCEPTION: SqlState = SqlState(Cow::Borrowed("22000"));

/// 2202E
pub const ARRAY_ELEMENT_ERROR: SqlState = SqlState(Cow::Borrowed("2202E"));

/// 2202E
pub const ARRAY_SUBSCRIPT_ERROR: SqlState = SqlState(Cow::Borrowed("2202E"));

/// 22021
pub const CHARACTER_NOT_IN_REPERTOIRE: SqlState = SqlState(Cow::Borrowed("22021"));

/// 22008
pub const DATETIME_FIELD_OVERFLOW: SqlState = SqlState(Cow::Borrowed("22008"));

/// 22008
pub const DATETIME_VALUE_OUT_OF_RANGE: SqlState = SqlState(Cow::Borrowed("22008"));

/// 22012
pub const DIVISION_BY_ZERO: SqlState = SqlState(Cow::Borrowed("22012"));

/// 22005
pub const ERROR_IN_ASSIGNMENT: SqlState = SqlState(Cow::Borrowed("22005"));

/// 2200B
pub const ESCAPE_CHARACTER_CONFLICT: SqlState = SqlState(Cow::Borrowed("2200B"));

/// 22022
pub const INDICATOR_OVERFLOW: SqlState = SqlState(Cow::Borrowed("22022"));

/// 22015
pub const INTERVAL_FIELD_OVERFLOW: SqlState = SqlState(Cow::Borrowed("22015"));

/// 2201E
pub const INVALID_ARGUMENT_FOR_LOG: SqlState = SqlState(Cow::Borrowed("2201E"));

/// 22014
pub const INVALID_ARGUMENT_FOR_NTILE: SqlState = SqlState(Cow::Borrowed("22014"));

/// 22016
pub const INVALID_ARGUMENT_FOR_NTH_VALUE: SqlState = SqlState(Cow::Borrowed("22016"));

/// 2201F
pub const INVALID_ARGUMENT_FOR_POWER_FUNCTION: SqlState = SqlState(Cow::Borrowed("2201F"));

/// 2201G
pub const INVALID_ARGUMENT_FOR_WIDTH_BUCKET_FUNCTION: SqlState = SqlState(Cow::Borrowed("2201G"));

/// 22018
pub const INVALID_CHARACTER_VALUE_FOR_CAST: SqlState = SqlState(Cow::Borrowed("22018"));

/// 22007
pub const INVALID_DATETIME_FORMAT: SqlState = SqlState(Cow::Borrowed("22007"));

/// 22019
pub const INVALID_ESCAPE_CHARACTER: SqlState = SqlState(Cow::Borrowed("22019"));

/// 2200D
pub const INVALID_ESCAPE_OCTET: SqlState = SqlState(Cow::Borrowed("2200D"));

/// 22025
pub const INVALID_ESCAPE_SEQUENCE: SqlState = SqlState(Cow::Borrowed("22025"));

/// 22P06
pub const NONSTANDARD_USE_OF_ESCAPE_CHARACTER: SqlState = SqlState(Cow::Borrowed("22P06"));

/// 22010
pub const INVALID_INDICATOR_PARAMETER_VALUE: SqlState = SqlState(Cow::Borrowed("22010"));

/// 22023
pub const INVALID_PARAMETER_VALUE: SqlState = SqlState(Cow::Borrowed("22023"));

/// 2201B
pub const INVALID_REGULAR_EXPRESSION: SqlState = SqlState(Cow::Borrowed("2201B"));

/// 2201W
pub const INVALID_ROW_COUNT_IN_LIMIT_CLAUSE: SqlState = SqlState(Cow::Borrowed("2201W"));

/// 2201X
pub const INVALID_ROW_COUNT_IN_RESULT_OFFSET_CLAUSE: SqlState = SqlState(Cow::Borrowed("2201X"));

/// 2202H
pub const INVALID_TABLESAMPLE_ARGUMENT: SqlState = SqlState(Cow::Borrowed("2202H"));

/// 2202G
pub const INVALID_TABLESAMPLE_REPEAT: SqlState = SqlState(Cow::Borrowed("2202G"));

/// 22009
pub const INVALID_TIME_ZONE_DISPLACEMENT_VALUE: SqlState = SqlState(Cow::Borrowed("22009"));

/// 2200C
pub const INVALID_USE_OF_ESCAPE_CHARACTER: SqlState = SqlState(Cow::Borrowed("2200C"));

/// 2200G
pub const MOST_SPECIFIC_TYPE_MISMATCH: SqlState = SqlState(Cow::Borrowed("2200G"));

/// 22004
pub const NULL_VALUE_NOT_ALLOWED: SqlState = SqlState(Cow::Borrowed("22004"));

/// 22002
pub const NULL_VALUE_NO_INDICATOR_PARAMETER: SqlState = SqlState(Cow::Borrowed("22002"));

/// 22003
pub const NUMERIC_VALUE_OUT_OF_RANGE: SqlState = SqlState(Cow::Borrowed("22003"));

/// 2200H
pub const SEQUENCE_GENERATOR_LIMIT_EXCEEDED: SqlState = SqlState(Cow::Borrowed("2200H"));

/// 22026
pub const STRING_DATA_LENGTH_MISMATCH: SqlState = SqlState(Cow::Borrowed("22026"));

/// 22001
pub const STRING_DATA_RIGHT_TRUNCATION: SqlState = SqlState(Cow::Borrowed("22001"));

/// 22011
pub const SUBSTRING_ERROR: SqlState = SqlState(Cow::Borrowed("22011"));

/// 22027
pub const TRIM_ERROR: SqlState = SqlState(Cow::Borrowed("22027"));

/// 22024
pub const UNTERMINATED_C_STRING: SqlState = SqlState(Cow::Borrowed("22024"));

/// 2200F
pub const ZERO_LENGTH_CHARACTER_STRING: SqlState = SqlState(Cow::Borrowed("2200F"));

/// 22P01
pub const FLOATING_POINT_EXCEPTION: SqlState = SqlState(Cow::Borrowed("22P01"));

/// 22P02
pub const INVALID_TEXT_REPRESENTATION: SqlState = SqlState(Cow::Borrowed("22P02"));

/// 22P03
pub const INVALID_BINARY_REPRESENTATION: SqlState = SqlState(Cow::Borrowed("22P03"));

/// 22P04
pub const BAD_COPY_FILE_FORMAT: SqlState = SqlState(Cow::Borrowed("22P04"));

/// 22P05
pub const UNTRANSLATABLE_CHARACTER: SqlState = SqlState(Cow::Borrowed("22P05"));

/// 2200L
pub const NOT_AN_XML_DOCUMENT: SqlState = SqlState(Cow::Borrowed("2200L"));

/// 2200M
pub const INVALID_XML_DOCUMENT: SqlState = SqlState(Cow::Borrowed("2200M"));

/// 2200N
pub const INVALID_XML_CONTENT: SqlState = SqlState(Cow::Borrowed("2200N"));

/// 2200S
pub const INVALID_XML_COMMENT: SqlState = SqlState(Cow::Borrowed("2200S"));

/// 2200T
pub const INVALID_XML_PROCESSING_INSTRUCTION: SqlState = SqlState(Cow::Borrowed("2200T"));

/// 23000
pub const INTEGRITY_CONSTRAINT_VIOLATION: SqlState = SqlState(Cow::Borrowed("23000"));

/// 23001
pub const RESTRICT_VIOLATION: SqlState = SqlState(Cow::Borrowed("23001"));

/// 23502
pub const NOT_NULL_VIOLATION: SqlState = SqlState(Cow::Borrowed("23502"));

/// 23503
pub const FOREIGN_KEY_VIOLATION: SqlState = SqlState(Cow::Borrowed("23503"));

/// 23505
pub const UNIQUE_VIOLATION: SqlState = SqlState(Cow::Borrowed("23505"));

/// 23514
pub const CHECK_VIOLATION: SqlState = SqlState(Cow::Borrowed("23514"));

/// 23P01
pub const EXCLUSION_VIOLATION: SqlState = SqlState(Cow::Borrowed("23P01"));

/// 24000
pub const INVALID_CURSOR_STATE: SqlState = SqlState(Cow::Borrowed("24000"));

/// 25000
pub const INVALID_TRANSACTION_STATE: SqlState = SqlState(Cow::Borrowed("25000"));

/// 25001
pub const ACTIVE_SQL_TRANSACTION: SqlState = SqlState(Cow::Borrowed("25001"));

/// 25002
pub const BRANCH_TRANSACTION_ALREADY_ACTIVE: SqlState = SqlState(Cow::Borrowed("25002"));

/// 25008
pub const HELD_CURSOR_REQUIRES_SAME_ISOLATION_LEVEL: SqlState = SqlState(Cow::Borrowed("25008"));

/// 25003
pub const INAPPROPRIATE_ACCESS_MODE_FOR_BRANCH_TRANSACTION: SqlState = SqlState(Cow::Borrowed("25003"));

/// 25004
pub const INAPPROPRIATE_ISOLATION_LEVEL_FOR_BRANCH_TRANSACTION: SqlState = SqlState(Cow::Borrowed("25004"));

/// 25005
pub const NO_ACTIVE_SQL_TRANSACTION_FOR_BRANCH_TRANSACTION: SqlState = SqlState(Cow::Borrowed("25005"));

/// 25006
pub const READ_ONLY_SQL_TRANSACTION: SqlState = SqlState(Cow::Borrowed("25006"));

/// 25007
pub const SCHEMA_AND_DATA_STATEMENT_MIXING_NOT_SUPPORTED: SqlState = SqlState(Cow::Borrowed("25007"));

/// 25P01
pub const NO_ACTIVE_SQL_TRANSACTION: SqlState = SqlState(Cow::Borrowed("25P01"));

/// 25P02
pub const IN_FAILED_SQL_TRANSACTION: SqlState = SqlState(Cow::Borrowed("25P02"));

/// 25P03
pub const IDLE_IN_TRANSACTION_SESSION_TIMEOUT: SqlState = SqlState(Cow::Borrowed("25P03"));

/// 26000
pub const INVALID_SQL_STATEMENT_NAME: SqlState = SqlState(Cow::Borrowed("26000"));

/// 26000
pub const UNDEFINED_PSTATEMENT: SqlState = SqlState(Cow::Borrowed("26000"));

/// 27000
pub const TRIGGERED_DATA_CHANGE_VIOLATION: SqlState = SqlState(Cow::Borrowed("27000"));

/// 28000
pub const INVALID_AUTHORIZATION_SPECIFICATION: SqlState = SqlState(Cow::Borrowed("28000"));

/// 28P01
pub const INVALID_PASSWORD: SqlState = SqlState(Cow::Borrowed("28P01"));

/// 2B000
pub const DEPENDENT_PRIVILEGE_DESCRIPTORS_STILL_EXIST: SqlState = SqlState(Cow::Borrowed("2B000"));

/// 2BP01
pub const DEPENDENT_OBJECTS_STILL_EXIST: SqlState = SqlState(Cow::Borrowed("2BP01"));

/// 2D000
pub const INVALID_TRANSACTION_TERMINATION: SqlState = SqlState(Cow::Borrowed("2D000"));

/// 2F000
pub const SQL_ROUTINE_EXCEPTION: SqlState = SqlState(Cow::Borrowed("2F000"));

/// 2F005
pub const S_R_E_FUNCTION_EXECUTED_NO_RETURN_STATEMENT: SqlState = SqlState(Cow::Borrowed("2F005"));

/// 2F002
pub const S_R_E_MODIFYING_SQL_DATA_NOT_PERMITTED: SqlState = SqlState(Cow::Borrowed("2F002"));

/// 2F003
pub const S_R_E_PROHIBITED_SQL_STATEMENT_ATTEMPTED: SqlState = SqlState(Cow::Borrowed("2F003"));

/// 2F004
pub const S_R_E_READING_SQL_DATA_NOT_PERMITTED: SqlState = SqlState(Cow::Borrowed("2F004"));

/// 34000
pub const INVALID_CURSOR_NAME: SqlState = SqlState(Cow::Borrowed("34000"));

/// 34000
pub const UNDEFINED_CURSOR: SqlState = SqlState(Cow::Borrowed("34000"));

/// 38000
pub const EXTERNAL_ROUTINE_EXCEPTION: SqlState = SqlState(Cow::Borrowed("38000"));

/// 38001
pub const E_R_E_CONTAINING_SQL_NOT_PERMITTED: SqlState = SqlState(Cow::Borrowed("38001"));

/// 38002
pub const E_R_E_MODIFYING_SQL_DATA_NOT_PERMITTED: SqlState = SqlState(Cow::Borrowed("38002"));

/// 38003
pub const E_R_E_PROHIBITED_SQL_STATEMENT_ATTEMPTED: SqlState = SqlState(Cow::Borrowed("38003"));

/// 38004
pub const E_R_E_READING_SQL_DATA_NOT_PERMITTED: SqlState = SqlState(Cow::Borrowed("38004"));

/// 39000
pub const EXTERNAL_ROUTINE_INVOCATION_EXCEPTION: SqlState = SqlState(Cow::Borrowed("39000"));

/// 39001
pub const E_R_I_E_INVALID_SQLSTATE_RETURNED: SqlState = SqlState(Cow::Borrowed("39001"));

/// 39004
pub const E_R_I_E_NULL_VALUE_NOT_ALLOWED: SqlState = SqlState(Cow::Borrowed("39004"));

/// 39P01
pub const E_R_I_E_TRIGGER_PROTOCOL_VIOLATED: SqlState = SqlState(Cow::Borrowed("39P01"));

/// 39P02
pub const E_R_I_E_SRF_PROTOCOL_VIOLATED: SqlState = SqlState(Cow::Borrowed("39P02"));

/// 39P03
pub const E_R_I_E_EVENT_TRIGGER_PROTOCOL_VIOLATED: SqlState = SqlState(Cow::Borrowed("39P03"));

/// 3B000
pub const SAVEPOINT_EXCEPTION: SqlState = SqlState(Cow::Borrowed("3B000"));

/// 3B001
pub const S_E_INVALID_SPECIFICATION: SqlState = SqlState(Cow::Borrowed("3B001"));

/// 3D000
pub const INVALID_CATALOG_NAME: SqlState = SqlState(Cow::Borrowed("3D000"));

/// 3D000
pub const UNDEFINED_DATABASE: SqlState = SqlState(Cow::Borrowed("3D000"));

/// 3F000
pub const INVALID_SCHEMA_NAME: SqlState = SqlState(Cow::Borrowed("3F000"));

/// 3F000
pub const UNDEFINED_SCHEMA: SqlState = SqlState(Cow::Borrowed("3F000"));

/// 40000
pub const TRANSACTION_ROLLBACK: SqlState = SqlState(Cow::Borrowed("40000"));

/// 40002
pub const T_R_INTEGRITY_CONSTRAINT_VIOLATION: SqlState = SqlState(Cow::Borrowed("40002"));

/// 40001
pub const T_R_SERIALIZATION_FAILURE: SqlState = SqlState(Cow::Borrowed("40001"));

/// 40003
pub const T_R_STATEMENT_COMPLETION_UNKNOWN: SqlState = SqlState(Cow::Borrowed("40003"));

/// 40P01
pub const T_R_DEADLOCK_DETECTED: SqlState = SqlState(Cow::Borrowed("40P01"));

/// 42000
pub const SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION: SqlState = SqlState(Cow::Borrowed("42000"));

/// 42601
pub const SYNTAX_ERROR: SqlState = SqlState(Cow::Borrowed("42601"));

/// 42501
pub const INSUFFICIENT_PRIVILEGE: SqlState = SqlState(Cow::Borrowed("42501"));

/// 42846
pub const CANNOT_COERCE: SqlState = SqlState(Cow::Borrowed("42846"));

/// 42803
pub const GROUPING_ERROR: SqlState = SqlState(Cow::Borrowed("42803"));

/// 42P20
pub const WINDOWING_ERROR: SqlState = SqlState(Cow::Borrowed("42P20"));

/// 42P19
pub const INVALID_RECURSION: SqlState = SqlState(Cow::Borrowed("42P19"));

/// 42830
pub const INVALID_FOREIGN_KEY: SqlState = SqlState(Cow::Borrowed("42830"));

/// 42602
pub const INVALID_NAME: SqlState = SqlState(Cow::Borrowed("42602"));

/// 42622
pub const NAME_TOO_LONG: SqlState = SqlState(Cow::Borrowed("42622"));

/// 42939
pub const RESERVED_NAME: SqlState = SqlState(Cow::Borrowed("42939"));

/// 42804
pub const DATATYPE_MISMATCH: SqlState = SqlState(Cow::Borrowed("42804"));

/// 42P18
pub const INDETERMINATE_DATATYPE: SqlState = SqlState(Cow::Borrowed("42P18"));

/// 42P21
pub const COLLATION_MISMATCH: SqlState = SqlState(Cow::Borrowed("42P21"));

/// 42P22
pub const INDETERMINATE_COLLATION: SqlState = SqlState(Cow::Borrowed("42P22"));

/// 42809
pub const WRONG_OBJECT_TYPE: SqlState = SqlState(Cow::Borrowed("42809"));

/// 428C9
pub const GENERATED_ALWAYS: SqlState = SqlState(Cow::Borrowed("428C9"));

/// 42703
pub const UNDEFINED_COLUMN: SqlState = SqlState(Cow::Borrowed("42703"));

/// 42883
pub const UNDEFINED_FUNCTION: SqlState = SqlState(Cow::Borrowed("42883"));

/// 42P01
pub const UNDEFINED_TABLE: SqlState = SqlState(Cow::Borrowed("42P01"));

/// 42P02
pub const UNDEFINED_PARAMETER: SqlState = SqlState(Cow::Borrowed("42P02"));

/// 42704
pub const UNDEFINED_OBJECT: SqlState = SqlState(Cow::Borrowed("42704"));

/// 42701
pub const DUPLICATE_COLUMN: SqlState = SqlState(Cow::Borrowed("42701"));

/// 42P03
pub const DUPLICATE_CURSOR: SqlState = SqlState(Cow::Borrowed("42P03"));

/// 42P04
pub const DUPLICATE_DATABASE: SqlState = SqlState(Cow::Borrowed("42P04"));

/// 42723
pub const DUPLICATE_FUNCTION: SqlState = SqlState(Cow::Borrowed("42723"));

/// 42P05
pub const DUPLICATE_PSTATEMENT: SqlState = SqlState(Cow::Borrowed("42P05"));

/// 42P06
pub const DUPLICATE_SCHEMA: SqlState = SqlState(Cow::Borrowed("42P06"));

/// 42P07
pub const DUPLICATE_TABLE: SqlState = SqlState(Cow::Borrowed("42P07"));

/// 42712
pub const DUPLICATE_ALIAS: SqlState = SqlState(Cow::Borrowed("42712"));

/// 42710
pub const DUPLICATE_OBJECT: SqlState = SqlState(Cow::Borrowed("42710"));

/// 42702
pub const AMBIGUOUS_COLUMN: SqlState = SqlState(Cow::Borrowed("42702"));

/// 42725
pub const AMBIGUOUS_FUNCTION: SqlState = SqlState(Cow::Borrowed("42725"));

/// 42P08
pub const AMBIGUOUS_PARAMETER: SqlState = SqlState(Cow::Borrowed("42P08"));

/// 42P09
pub const AMBIGUOUS_ALIAS: SqlState = SqlState(Cow::Borrowed("42P09"));

/// 42P10
pub const INVALID_COLUMN_REFERENCE: SqlState = SqlState(Cow::Borrowed("42P10"));

/// 42611
pub const INVALID_COLUMN_DEFINITION: SqlState = SqlState(Cow::Borrowed("42611"));

/// 42P11
pub const INVALID_CURSOR_DEFINITION: SqlState = SqlState(Cow::Borrowed("42P11"));

/// 42P12
pub const INVALID_DATABASE_DEFINITION: SqlState = SqlState(Cow::Borrowed("42P12"));

/// 42P13
pub const INVALID_FUNCTION_DEFINITION: SqlState = SqlState(Cow::Borrowed("42P13"));

/// 42P14
pub const INVALID_PSTATEMENT_DEFINITION: SqlState = SqlState(Cow::Borrowed("42P14"));

/// 42P15
pub const INVALID_SCHEMA_DEFINITION: SqlState = SqlState(Cow::Borrowed("42P15"));

/// 42P16
pub const INVALID_TABLE_DEFINITION: SqlState = SqlState(Cow::Borrowed("42P16"));

/// 42P17
pub const INVALID_OBJECT_DEFINITION: SqlState = SqlState(Cow::Borrowed("42P17"));

/// 44000
pub const WITH_CHECK_OPTION_VIOLATION: SqlState = SqlState(Cow::Borrowed("44000"));

/// 53000
pub const INSUFFICIENT_RESOURCES: SqlState = SqlState(Cow::Borrowed("53000"));

/// 53100
pub const DISK_FULL: SqlState = SqlState(Cow::Borrowed("53100"));

/// 53200
pub const OUT_OF_MEMORY: SqlState = SqlState(Cow::Borrowed("53200"));

/// 53300
pub const TOO_MANY_CONNECTIONS: SqlState = SqlState(Cow::Borrowed("53300"));

/// 53400
pub const CONFIGURATION_LIMIT_EXCEEDED: SqlState = SqlState(Cow::Borrowed("53400"));

/// 54000
pub const PROGRAM_LIMIT_EXCEEDED: SqlState = SqlState(Cow::Borrowed("54000"));

/// 54001
pub const STATEMENT_TOO_COMPLEX: SqlState = SqlState(Cow::Borrowed("54001"));

/// 54011
pub const TOO_MANY_COLUMNS: SqlState = SqlState(Cow::Borrowed("54011"));

/// 54023
pub const TOO_MANY_ARGUMENTS: SqlState = SqlState(Cow::Borrowed("54023"));

/// 55000
pub const OBJECT_NOT_IN_PREREQUISITE_STATE: SqlState = SqlState(Cow::Borrowed("55000"));

/// 55006
pub const OBJECT_IN_USE: SqlState = SqlState(Cow::Borrowed("55006"));

/// 55P02
pub const CANT_CHANGE_RUNTIME_PARAM: SqlState = SqlState(Cow::Borrowed("55P02"));

/// 55P03
pub const LOCK_NOT_AVAILABLE: SqlState = SqlState(Cow::Borrowed("55P03"));

/// 55P04
pub const UNSAFE_NEW_ENUM_VALUE_USAGE: SqlState = SqlState(Cow::Borrowed("55P04"));

/// 57000
pub const OPERATOR_INTERVENTION: SqlState = SqlState(Cow::Borrowed("57000"));

/// 57014
pub const QUERY_CANCELED: SqlState = SqlState(Cow::Borrowed("57014"));

/// 57P01
pub const ADMIN_SHUTDOWN: SqlState = SqlState(Cow::Borrowed("57P01"));

/// 57P02
pub const CRASH_SHUTDOWN: SqlState = SqlState(Cow::Borrowed("57P02"));

/// 57P03
pub const CANNOT_CONNECT_NOW: SqlState = SqlState(Cow::Borrowed("57P03"));

/// 57P04
pub const DATABASE_DROPPED: SqlState = SqlState(Cow::Borrowed("57P04"));

/// 58000
pub const SYSTEM_ERROR: SqlState = SqlState(Cow::Borrowed("58000"));

/// 58030
pub const IO_ERROR: SqlState = SqlState(Cow::Borrowed("58030"));

/// 58P01
pub const UNDEFINED_FILE: SqlState = SqlState(Cow::Borrowed("58P01"));

/// 58P02
pub const DUPLICATE_FILE: SqlState = SqlState(Cow::Borrowed("58P02"));

/// 72000
pub const SNAPSHOT_TOO_OLD: SqlState = SqlState(Cow::Borrowed("72000"));

/// F0000
pub const CONFIG_FILE_ERROR: SqlState = SqlState(Cow::Borrowed("F0000"));

/// F0001
pub const LOCK_FILE_EXISTS: SqlState = SqlState(Cow::Borrowed("F0001"));

/// HV000
pub const FDW_ERROR: SqlState = SqlState(Cow::Borrowed("HV000"));

/// HV005
pub const FDW_COLUMN_NAME_NOT_FOUND: SqlState = SqlState(Cow::Borrowed("HV005"));

/// HV002
pub const FDW_DYNAMIC_PARAMETER_VALUE_NEEDED: SqlState = SqlState(Cow::Borrowed("HV002"));

/// HV010
pub const FDW_FUNCTION_SEQUENCE_ERROR: SqlState = SqlState(Cow::Borrowed("HV010"));

/// HV021
pub const FDW_INCONSISTENT_DESCRIPTOR_INFORMATION: SqlState = SqlState(Cow::Borrowed("HV021"));

/// HV024
pub const FDW_INVALID_ATTRIBUTE_VALUE: SqlState = SqlState(Cow::Borrowed("HV024"));

/// HV007
pub const FDW_INVALID_COLUMN_NAME: SqlState = SqlState(Cow::Borrowed("HV007"));

/// HV008
pub const FDW_INVALID_COLUMN_NUMBER: SqlState = SqlState(Cow::Borrowed("HV008"));

/// HV004
pub const FDW_INVALID_DATA_TYPE: SqlState = SqlState(Cow::Borrowed("HV004"));

/// HV006
pub const FDW_INVALID_DATA_TYPE_DESCRIPTORS: SqlState = SqlState(Cow::Borrowed("HV006"));

/// HV091
pub const FDW_INVALID_DESCRIPTOR_FIELD_IDENTIFIER: SqlState = SqlState(Cow::Borrowed("HV091"));

/// HV00B
pub const FDW_INVALID_HANDLE: SqlState = SqlState(Cow::Borrowed("HV00B"));

/// HV00C
pub const FDW_INVALID_OPTION_INDEX: SqlState = SqlState(Cow::Borrowed("HV00C"));

/// HV00D
pub const FDW_INVALID_OPTION_NAME: SqlState = SqlState(Cow::Borrowed("HV00D"));

/// HV090
pub const FDW_INVALID_STRING_LENGTH_OR_BUFFER_LENGTH: SqlState = SqlState(Cow::Borrowed("HV090"));

/// HV00A
pub const FDW_INVALID_STRING_FORMAT: SqlState = SqlState(Cow::Borrowed("HV00A"));

/// HV009
pub const FDW_INVALID_USE_OF_NULL_POINTER: SqlState = SqlState(Cow::Borrowed("HV009"));

/// HV014
pub const FDW_TOO_MANY_HANDLES: SqlState = SqlState(Cow::Borrowed("HV014"));

/// HV001
pub const FDW_OUT_OF_MEMORY: SqlState = SqlState(Cow::Borrowed("HV001"));

/// HV00P
pub const FDW_NO_SCHEMAS: SqlState = SqlState(Cow::Borrowed("HV00P"));

/// HV00J
pub const FDW_OPTION_NAME_NOT_FOUND: SqlState = SqlState(Cow::Borrowed("HV00J"));

/// HV00K
pub const FDW_REPLY_HANDLE: SqlState = SqlState(Cow::Borrowed("HV00K"));

/// HV00Q
pub const FDW_SCHEMA_NOT_FOUND: SqlState = SqlState(Cow::Borrowed("HV00Q"));

/// HV00R
pub const FDW_TABLE_NOT_FOUND: SqlState = SqlState(Cow::Borrowed("HV00R"));

/// HV00L
pub const FDW_UNABLE_TO_CREATE_EXECUTION: SqlState = SqlState(Cow::Borrowed("HV00L"));

/// HV00M
pub const FDW_UNABLE_TO_CREATE_REPLY: SqlState = SqlState(Cow::Borrowed("HV00M"));

/// HV00N
pub const FDW_UNABLE_TO_ESTABLISH_CONNECTION: SqlState = SqlState(Cow::Borrowed("HV00N"));

/// P0000
pub const PLPGSQL_ERROR: SqlState = SqlState(Cow::Borrowed("P0000"));

/// P0001
pub const RAISE_EXCEPTION: SqlState = SqlState(Cow::Borrowed("P0001"));

/// P0002
pub const NO_DATA_FOUND: SqlState = SqlState(Cow::Borrowed("P0002"));

/// P0003
pub const TOO_MANY_ROWS: SqlState = SqlState(Cow::Borrowed("P0003"));

/// P0004
pub const ASSERT_FAILURE: SqlState = SqlState(Cow::Borrowed("P0004"));

/// XX000
pub const INTERNAL_ERROR: SqlState = SqlState(Cow::Borrowed("XX000"));

/// XX001
pub const DATA_CORRUPTED: SqlState = SqlState(Cow::Borrowed("XX001"));

/// XX002
pub const INDEX_CORRUPTED: SqlState = SqlState(Cow::Borrowed("XX002"));

#[cfg_attr(rustfmt, rustfmt_skip)]
static SQLSTATE_MAP: phf::Map<&'static str, SqlState> = ::phf::Map {
    key: 1897749892740154578,
    disps: ::phf::Slice::Static(&[
        (1, 99),
        (0, 0),
        (1, 5),
        (0, 3),
        (0, 110),
        (0, 54),
        (0, 3),
        (0, 13),
        (0, 0),
        (0, 24),
        (0, 214),
        (0, 52),
        (1, 34),
        (0, 33),
        (0, 44),
        (0, 130),
        (0, 16),
        (0, 187),
        (0, 3),
        (13, 168),
        (0, 4),
        (0, 19),
        (0, 13),
        (0, 87),
        (0, 0),
        (0, 108),
        (0, 123),
        (7, 181),
        (0, 109),
        (0, 32),
        (0, 0),
        (1, 69),
        (1, 81),
        (1, 219),
        (0, 157),
        (2, 41),
        (8, 141),
        (0, 5),
        (0, 0),
        (1, 6),
        (0, 3),
        (1, 146),
        (1, 227),
        (9, 94),
        (10, 158),
        (29, 65),
        (3, 2),
        (0, 33),
        (1, 94),
    ]),
    entries: ::phf::Slice::Static(&[
        ("23001", RESTRICT_VIOLATION),
        ("42830", INVALID_FOREIGN_KEY),
        ("P0000", PLPGSQL_ERROR),
        ("58000", SYSTEM_ERROR),
        ("57P01", ADMIN_SHUTDOWN),
        ("22P04", BAD_COPY_FILE_FORMAT),
        ("42P05", DUPLICATE_PSTATEMENT),
        ("28000", INVALID_AUTHORIZATION_SPECIFICATION),
        ("2202E", ARRAY_ELEMENT_ERROR),
        ("2F005", S_R_E_FUNCTION_EXECUTED_NO_RETURN_STATEMENT),
        ("53400", CONFIGURATION_LIMIT_EXCEEDED),
        ("20000", CASE_NOT_FOUND),
        ("25004", INAPPROPRIATE_ISOLATION_LEVEL_FOR_BRANCH_TRANSACTION),
        ("09000", TRIGGERED_ACTION_EXCEPTION),
        ("42P10", INVALID_COLUMN_REFERENCE),
        ("39P03", E_R_I_E_EVENT_TRIGGER_PROTOCOL_VIOLATED),
        ("08000", CONNECTION_EXCEPTION),
        ("08006", CONNECTION_FAILURE),
        ("2201W", INVALID_ROW_COUNT_IN_LIMIT_CLAUSE),
        ("03000", SQL_STATEMENT_NOT_YET_COMPLETE),
        ("22014", INVALID_ARGUMENT_FOR_NTILE),
        ("42611", INVALID_COLUMN_DEFINITION),
        ("42P11", INVALID_CURSOR_DEFINITION),
        ("2200N", INVALID_XML_CONTENT),
        ("57014", QUERY_CANCELED),
        ("01003", WARNING_NULL_VALUE_ELIMINATED_IN_SET_FUNCTION),
        ("01000", WARNING),
        ("55P04", UNSAFE_NEW_ENUM_VALUE_USAGE),
        ("25003", INAPPROPRIATE_ACCESS_MODE_FOR_BRANCH_TRANSACTION),
        ("2200L", NOT_AN_XML_DOCUMENT),
        ("42846", CANNOT_COERCE),
        ("55P03", LOCK_NOT_AVAILABLE),
        ("08007", TRANSACTION_RESOLUTION_UNKNOWN),
        ("XX000", INTERNAL_ERROR),
        ("22005", ERROR_IN_ASSIGNMENT),
        ("22P03", INVALID_BINARY_REPRESENTATION),
        ("2201X", INVALID_ROW_COUNT_IN_RESULT_OFFSET_CLAUSE),
        ("54011", TOO_MANY_COLUMNS),
        ("HV008", FDW_INVALID_COLUMN_NUMBER),
        ("HV009", FDW_INVALID_USE_OF_NULL_POINTER),
        ("0LP01", INVALID_GRANT_OPERATION),
        ("42704", UNDEFINED_OBJECT),
        ("25005", NO_ACTIVE_SQL_TRANSACTION_FOR_BRANCH_TRANSACTION),
        ("25P03", IDLE_IN_TRANSACTION_SESSION_TIMEOUT),
        ("44000", WITH_CHECK_OPTION_VIOLATION),
        ("22024", UNTERMINATED_C_STRING),
        ("0L000", INVALID_GRANTOR),
        ("40000", TRANSACTION_ROLLBACK),
        ("42P08", AMBIGUOUS_PARAMETER),
        ("38000", EXTERNAL_ROUTINE_EXCEPTION),
        ("42939", RESERVED_NAME),
        ("40001", T_R_SERIALIZATION_FAILURE),
        ("HV00K", FDW_REPLY_HANDLE),
        ("2F002", S_R_E_MODIFYING_SQL_DATA_NOT_PERMITTED),
        ("HV001", FDW_OUT_OF_MEMORY),
        ("42P19", INVALID_RECURSION),
        ("HV002", FDW_DYNAMIC_PARAMETER_VALUE_NEEDED),
        ("0A000", FEATURE_NOT_SUPPORTED),
        ("58P02", DUPLICATE_FILE),
        ("25006", READ_ONLY_SQL_TRANSACTION),
        ("22009", INVALID_TIME_ZONE_DISPLACEMENT_VALUE),
        ("0F001", L_E_INVALID_SPECIFICATION),
        ("P0002", NO_DATA_FOUND),
        ("2F000", SQL_ROUTINE_EXCEPTION),
        ("01006", WARNING_PRIVILEGE_NOT_REVOKED),
        ("22025", INVALID_ESCAPE_SEQUENCE),
        ("22027", TRIM_ERROR),
        ("54001", STATEMENT_TOO_COMPLEX),
        ("42602", INVALID_NAME),
        ("54023", TOO_MANY_ARGUMENTS),
        ("2200T", INVALID_XML_PROCESSING_INSTRUCTION),
        ("01007", WARNING_PRIVILEGE_NOT_GRANTED),
        ("22000", DATA_EXCEPTION),
        ("28P01", INVALID_PASSWORD),
        ("23514", CHECK_VIOLATION),
        ("39P02", E_R_I_E_SRF_PROTOCOL_VIOLATED),
        ("57P02", CRASH_SHUTDOWN),
        ("42P03", DUPLICATE_CURSOR),
        ("22021", CHARACTER_NOT_IN_REPERTOIRE),
        ("HV00P", FDW_NO_SCHEMAS),
        ("42701", DUPLICATE_COLUMN),
        ("42P15", INVALID_SCHEMA_DEFINITION),
        ("HV00B", FDW_INVALID_HANDLE),
        ("34000", INVALID_CURSOR_NAME),
        ("22P06", NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
        ("P0001", RAISE_EXCEPTION),
        ("08P01", PROTOCOL_VIOLATION),
        ("42723", DUPLICATE_FUNCTION),
        ("08001", SQLCLIENT_UNABLE_TO_ESTABLISH_SQLCONNECTION),
        ("HV006", FDW_INVALID_DATA_TYPE_DESCRIPTORS),
        ("23000", INTEGRITY_CONSTRAINT_VIOLATION),
        ("42712", DUPLICATE_ALIAS),
        ("2201G", INVALID_ARGUMENT_FOR_WIDTH_BUCKET_FUNCTION),
        ("2200F", ZERO_LENGTH_CHARACTER_STRING),
        ("XX002", INDEX_CORRUPTED),
        ("53300", TOO_MANY_CONNECTIONS),
        ("38002", E_R_E_MODIFYING_SQL_DATA_NOT_PERMITTED),
        ("22015", INTERVAL_FIELD_OVERFLOW),
        ("22P01", FLOATING_POINT_EXCEPTION),
        ("22012", DIVISION_BY_ZERO),
        ("XX001", DATA_CORRUPTED),
        ("0100C", WARNING_DYNAMIC_RESULT_SETS_RETURNED),
        ("42P01", UNDEFINED_TABLE),
        ("25002", BRANCH_TRANSACTION_ALREADY_ACTIVE),
        ("2D000", INVALID_TRANSACTION_TERMINATION),
        ("P0004", ASSERT_FAILURE),
        ("2200C", INVALID_USE_OF_ESCAPE_CHARACTER),
        ("HV00R", FDW_TABLE_NOT_FOUND),
        ("22016", INVALID_ARGUMENT_FOR_NTH_VALUE),
        ("01P01", WARNING_DEPRECATED_FEATURE),
        ("F0000", CONFIG_FILE_ERROR),
        ("0Z000", DIAGNOSTICS_EXCEPTION),
        ("42P02", UNDEFINED_PARAMETER),
        ("2200S", INVALID_XML_COMMENT),
        ("2200H", SEQUENCE_GENERATOR_LIMIT_EXCEEDED),
        ("HV00C", FDW_INVALID_OPTION_INDEX),
        ("38004", E_R_E_READING_SQL_DATA_NOT_PERMITTED),
        ("42703", UNDEFINED_COLUMN),
        ("23503", FOREIGN_KEY_VIOLATION),
        ("42000", SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION),
        ("22004", NULL_VALUE_NOT_ALLOWED),
        ("25008", HELD_CURSOR_REQUIRES_SAME_ISOLATION_LEVEL),
        ("22018", INVALID_CHARACTER_VALUE_FOR_CAST),
        ("22023", INVALID_PARAMETER_VALUE),
        ("22011", SUBSTRING_ERROR),
        ("40002", T_R_INTEGRITY_CONSTRAINT_VIOLATION),
        ("42803", GROUPING_ERROR),
        ("72000", SNAPSHOT_TOO_OLD),
        ("HV010", FDW_FUNCTION_SEQUENCE_ERROR),
        ("42809", WRONG_OBJECT_TYPE),
        ("42P16", INVALID_TABLE_DEFINITION),
        ("HV00D", FDW_INVALID_OPTION_NAME),
        ("39000", EXTERNAL_ROUTINE_INVOCATION_EXCEPTION),
        ("2202G", INVALID_TABLESAMPLE_REPEAT),
        ("42601", SYNTAX_ERROR),
        ("42622", NAME_TOO_LONG),
        ("HV00L", FDW_UNABLE_TO_CREATE_EXECUTION),
        ("25000", INVALID_TRANSACTION_STATE),
        ("3B000", SAVEPOINT_EXCEPTION),
        ("42P21", COLLATION_MISMATCH),
        ("23505", UNIQUE_VIOLATION),
        ("22001", STRING_DATA_RIGHT_TRUNCATION),
        ("02001", NO_ADDITIONAL_DYNAMIC_RESULT_SETS_RETURNED),
        ("21000", CARDINALITY_VIOLATION),
        ("58P01", UNDEFINED_FILE),
        ("HV091", FDW_INVALID_DESCRIPTOR_FIELD_IDENTIFIER),
        ("25P01", NO_ACTIVE_SQL_TRANSACTION),
        ("40P01", T_R_DEADLOCK_DETECTED),
        ("HV021", FDW_INCONSISTENT_DESCRIPTOR_INFORMATION),
        ("42P09", AMBIGUOUS_ALIAS),
        ("25007", SCHEMA_AND_DATA_STATEMENT_MIXING_NOT_SUPPORTED),
        ("23P01", EXCLUSION_VIOLATION),
        ("HV00J", FDW_OPTION_NAME_NOT_FOUND),
        ("58030", IO_ERROR),
        ("HV004", FDW_INVALID_DATA_TYPE),
        ("42710", DUPLICATE_OBJECT),
        ("HV090", FDW_INVALID_STRING_LENGTH_OR_BUFFER_LENGTH),
        ("42P18", INDETERMINATE_DATATYPE),
        ("HV00M", FDW_UNABLE_TO_CREATE_REPLY),
        ("42804", DATATYPE_MISMATCH),
        ("24000", INVALID_CURSOR_STATE),
        ("HV007", FDW_INVALID_COLUMN_NAME),
        ("2201E", INVALID_ARGUMENT_FOR_LOG),
        ("42P22", INDETERMINATE_COLLATION),
        ("22P05", UNTRANSLATABLE_CHARACTER),
        ("42P07", DUPLICATE_TABLE),
        ("2F004", S_R_E_READING_SQL_DATA_NOT_PERMITTED),
        ("23502", NOT_NULL_VIOLATION),
        ("57000", OPERATOR_INTERVENTION),
        ("HV000", FDW_ERROR),
        ("42883", UNDEFINED_FUNCTION),
        ("2201B", INVALID_REGULAR_EXPRESSION),
        ("2200D", INVALID_ESCAPE_OCTET),
        ("42P06", DUPLICATE_SCHEMA),
        ("38003", E_R_E_PROHIBITED_SQL_STATEMENT_ATTEMPTED),
        ("22026", STRING_DATA_LENGTH_MISMATCH),
        ("P0003", TOO_MANY_ROWS),
        ("3D000", INVALID_CATALOG_NAME),
        ("0B000", INVALID_TRANSACTION_INITIATION),
        ("55006", OBJECT_IN_USE),
        ("53200", OUT_OF_MEMORY),
        ("3F000", INVALID_SCHEMA_NAME),
        ("53100", DISK_FULL),
        ("2F003", S_R_E_PROHIBITED_SQL_STATEMENT_ATTEMPTED),
        ("55P02", CANT_CHANGE_RUNTIME_PARAM),
        ("01004", WARNING_STRING_DATA_RIGHT_TRUNCATION),
        ("3B001", S_E_INVALID_SPECIFICATION),
        ("2200G", MOST_SPECIFIC_TYPE_MISMATCH),
        ("428C9", GENERATED_ALWAYS),
        ("HV005", FDW_COLUMN_NAME_NOT_FOUND),
        ("2201F", INVALID_ARGUMENT_FOR_POWER_FUNCTION),
        ("22022", INDICATOR_OVERFLOW),
        ("HV00Q", FDW_SCHEMA_NOT_FOUND),
        ("0F000", LOCATOR_EXCEPTION),
        ("22002", NULL_VALUE_NO_INDICATOR_PARAMETER),
        ("02000", NO_DATA),
        ("2202H", INVALID_TABLESAMPLE_ARGUMENT),
        ("27000", TRIGGERED_DATA_CHANGE_VIOLATION),
        ("2BP01", DEPENDENT_OBJECTS_STILL_EXIST),
        ("55000", OBJECT_NOT_IN_PREREQUISITE_STATE),
        ("39001", E_R_I_E_INVALID_SQLSTATE_RETURNED),
        ("08004", SQLSERVER_REJECTED_ESTABLISHMENT_OF_SQLCONNECTION),
        ("42P13", INVALID_FUNCTION_DEFINITION),
        ("HV024", FDW_INVALID_ATTRIBUTE_VALUE),
        ("22019", INVALID_ESCAPE_CHARACTER),
        ("54000", PROGRAM_LIMIT_EXCEEDED),
        ("42501", INSUFFICIENT_PRIVILEGE),
        ("HV00A", FDW_INVALID_STRING_FORMAT),
        ("42702", AMBIGUOUS_COLUMN),
        ("53000", INSUFFICIENT_RESOURCES),
        ("25P02", IN_FAILED_SQL_TRANSACTION),
        ("22010", INVALID_INDICATOR_PARAMETER_VALUE),
        ("01008", WARNING_IMPLICIT_ZERO_BIT_PADDING),
        ("HV014", FDW_TOO_MANY_HANDLES),
        ("42P20", WINDOWING_ERROR),
        ("42725", AMBIGUOUS_FUNCTION),
        ("F0001", LOCK_FILE_EXISTS),
        ("08003", CONNECTION_DOES_NOT_EXIST),
        ("2200M", INVALID_XML_DOCUMENT),
        ("22003", NUMERIC_VALUE_OUT_OF_RANGE),
        ("39004", E_R_I_E_NULL_VALUE_NOT_ALLOWED),
        ("2200B", ESCAPE_CHARACTER_CONFLICT),
        ("0P000", INVALID_ROLE_SPECIFICATION),
        ("00000", SUCCESSFUL_COMPLETION),
        ("22P02", INVALID_TEXT_REPRESENTATION),
        ("25001", ACTIVE_SQL_TRANSACTION),
        ("HV00N", FDW_UNABLE_TO_ESTABLISH_CONNECTION),
        ("39P01", E_R_I_E_TRIGGER_PROTOCOL_VIOLATED),
        ("2B000", DEPENDENT_PRIVILEGE_DESCRIPTORS_STILL_EXIST),
        ("22008", DATETIME_FIELD_OVERFLOW),
        ("42P14", INVALID_PSTATEMENT_DEFINITION),
        ("57P04", DATABASE_DROPPED),
        ("26000", INVALID_SQL_STATEMENT_NAME),
        ("42P17", INVALID_OBJECT_DEFINITION),
        ("42P04", DUPLICATE_DATABASE),
        ("38001", E_R_E_CONTAINING_SQL_NOT_PERMITTED),
        ("0Z002", STACKED_DIAGNOSTICS_ACCESSED_WITHOUT_ACTIVE_HANDLER),
        ("22007", INVALID_DATETIME_FORMAT),
        ("40003", T_R_STATEMENT_COMPLETION_UNKNOWN),
        ("42P12", INVALID_DATABASE_DEFINITION),
        ("57P03", CANNOT_CONNECT_NOW),
    ]),
};
