use std::fmt;
use std::error;
use std::marker;

#[derive(Debug)]
pub enum BencodeError
{
    ParseError(&'static str)
}

impl fmt::Display for BencodeError
{
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            BencodeError::ParseError(err) => write!(f, "oxidation_bencode parse error: {}", err),
        }
    }
}

impl error::Error for BencodeError
{
    fn description(&self) -> &str {
        match *self {
            BencodeError::ParseError(err) => &err
        }
    }

    fn cause(&self) -> Option<&error::Error> {
        match *self {
            BencodeError::ParseError(_) => None
        }
    }

}

pub trait Bencodable<T> {
    fn to_bencode_string(&self) -> String;
    fn from_bencode_string(str: &'static str) -> Result<Self,BencodeError> 
        where Self: marker::Sized;
    fn extract_content(&self) -> T;
}