#[macro_use]
extern crate derive_is_enum_variant;
#[macro_use]
extern crate derive_new;

mod errors;
mod flag;
mod lex;
mod parse;
mod scope;
mod shapes;

pub use lex::lexer::{lex, parse_block, NewlineMode};
pub use lex::tokens::{LiteBlock, LiteCommand, LiteGroup, LitePipeline};
pub use parse::{classify_block, garbage, parse, parse_full_column_path, parse_math_expression};
pub use scope::ParserScope;
pub use shapes::shapes;
