use chrono::NaiveDateTime;
use serde::{Deserialize, Serialize};

#[derive(Serialize, Deserialize, Clone)]
pub enum NodeState {
    Syncing,
    Synced,
    Unreachable,
}

#[derive(Serialize, Deserialize)]
pub struct Status {
    //In Seconds
    pub sync_time_remaining: Option<u64>,
    pub current_block: u64,
    pub last_check: NaiveDateTime,
    pub state: NodeState,
    pub limits: Limits,
    pub node_monitor_version: String,
}

#[derive(Serialize, Deserialize, Clone)]
pub struct Limits {
    pub cpu_limit: u64,
    pub mem_limit: u64,
    pub storage_limit: u64,
}
