
use imp_prelude::*;

impl<A, D> ArrayBase<Vec<A>, D>
    where D: Dimension
{
    /// Return a vector of the elements in the array, in the way they are
    /// stored internally.
    ///
    /// If the array is in standard memory layout, the logical element order
    /// of the array (`.iter()` order) and of the returned vector will be the same.
    pub fn into_raw_vec(self) -> Vec<A> {
        self.data
    }
}
