use std::collections::HashMap;

// PropIdNameMap refers to mapping between property ID and
// Full list is available in [MS-OXPROPS].
#[derive(Debug)]
pub struct PropIdNameMap {
    map: HashMap<String, String>,
}

impl PropIdNameMap {
    pub fn init() -> Self {
        let map: HashMap<String, String> = vec![
            ("0x0001", "TemplateData"),
            ("0x0002", "AlternateRecipientAllowed"),
            ("0x0004", "ScriptData"),
            ("0x0005", "AutoForwarded"),
            ("0x000F", "DeferredDeliveryTime"),
            ("0x0010", "DeliverTime"),
            ("0x0015", "ExpiryTime"),
            ("0x0017", "Importance"),
            ("0x001A", "MessageClass"),
            ("0x0023", "OriginatorDeliveryReportRequested"),
            ("0x0025", "ParentKey"),
            ("0x0026", "Priority"),
            ("0x0029", "ReadReceiptRequested"),
            ("0x002A", "ReceiptTime"),
            ("0x002B", "RecipientReassignmentProhibited"),
            ("0x002E", "OriginalSensitivity"),
            ("0x0030", "ReplyTime"),
            ("0x0031", "ReportTag"),
            ("0x0032", "ReportTime"),
            ("0x0036", "Sensitivity"),
            ("0x0037", "Subject"),
            ("0x0039", "ClientSubmitTime"),
            ("0x003A", "ReportName"),
            ("0x003B", "SentRepresentingSearchKey"),
            ("0x003D", "SubjectPrefix"),
            ("0x003F", "ReceivedByEntryId"),
            ("0x0040", "ReceivedByName"),
            ("0x0041", "SentRepresentingEntryId"),
            ("0x0042", "SentRepresentingName"),
            ("0x0043", "ReceivedRepresentingEntryId"),
            ("0x0044", "ReceivedRepresentingName"),
            ("0x0045", "ReportEntryId"),
            ("0x0046", "ReadReceiptEntryId"),
            ("0x0047", "MessageSubmissionId"),
            ("0x0049", "OriginalSubject"),
            ("0x004B", "OriginalMessageClass"),
            ("0x004C", "OriginalAuthorEntryId"),
            ("0x004D", "OriginalAuthorName"),
            ("0x004E", "OriginalSubmitTime"),
            ("0x004F", "ReplyRecipientEntries"),
            ("0x0050", "ReplyRecipientNames"),
            ("0x0051", "ReceivedBySearchKey"),
            ("0x0052", "ReceivedRepresentingSearchKey"),
            ("0x0053", "ReadReceiptSearchKey"),
            ("0x0054", "ReportSearchKey"),
            ("0x0055", "OriginalDeliveryTime"),
            ("0x0057", "MessageToMe"),
            ("0x0058", "MessageCcMe"),
            ("0x0059", "MessageRecipientMe"),
            ("0x005A", "OriginalSenderName"),
            ("0x005B", "OriginalSenderEntryId"),
            ("0x005C", "OriginalSenderSearchKey"),
            ("0x005D", "OriginalSentRepresentingName"),
            ("0x005E", "OriginalSentRepresentingEntryId"),
            ("0x005F", "OriginalSentRepresentingSearchKey"),
            ("0x0060", "StartDate"),
            ("0x0061", "EndDate"),
            ("0x0062", "OwnerAppointmentId"),
            ("0x0063", "ResponseRequested"),
            ("0x0064", "SentRepresentingAddressType"),
            ("0x0065", "SentRepresentingEmailAddress"),
            ("0x0066", "OriginalSenderAddressType"),
            ("0x0067", "OriginalSenderEmailAddress"),
            ("0x0068", "OriginalSentRepresentingAddressType"),
            ("0x0069", "OriginalSentRepresentingEmailAddress"),
            ("0x0070", "ConversationTopic"),
            ("0x0071", "ConversationIndex"),
            ("0x0072", "OriginalDisplayBcc"),
            ("0x0073", "OriginalDisplayCc"),
            ("0x0074", "OriginalDisplayTo"),
            ("0x0075", "ReceivedByAddressType"),
            ("0x0076", "ReceivedByEmailAddress"),
            ("0x0077", "ReceivedRepresentingAddressType"),
            ("0x0078", "ReceivedRepresentingEmailAddress"),
            ("0x007D", "TransportMessageHeaders"),
            ("0x007F", "TnefCorrelationKey"),
            ("0x0080", "ReportDisposition"),
            ("0x0081", "ReportDispositionMode"),
            ("0x0807", "AddressBookRoomCapacity"),
            ("0x0809", "AddressBookRoomDescription"),
            ("0x0C04", "NonDeliveryReportReasonCode"),
            ("0x0C05", "NonDeliveryReportDiagCode"),
            ("0x0C06", "NonReceiptNotificationRequested"),
            ("0x0C08", "OriginatorNonDeliveryReportRequested"),
            ("0x0C15", "RecipientType"),
            ("0x0C17", "ReplyRequested"),
            ("0x0C19", "SenderEntryId"),
            ("0x0C1A", "SenderName"),
            ("0x0C1B", "SupplementaryInfo"),
            ("0x0C1D", "SenderSearchKey"),
            ("0x0C1E", "SenderAddressType"),
            ("0x0C1F", "SenderEmailAddress"),
            ("0x0C21", "RemoteMessageTransferAgent"),
            ("0x0E01", "DeleteAfterSubmit"),
            ("0x0E02", "DisplayBcc"),
            ("0x0E03", "DisplayCc"),
            ("0x0E04", "DisplayTo"),
            ("0x0E06", "MessageDeliveryTime"),
            ("0x0E07", "MessageFlags"),
            ("0x0E08", "MessageSizeExtended"),
            ("0x0E09", "ParentEntryId"),
            ("0x0E0F", "Responsibility"),
            ("0x0E12", "MessageRecipients"),
            ("0x0E13", "MessageAttachments"),
            ("0x0E17", "MessageStatus"),
            ("0x0E1B", "HasAttachments"),
            ("0x0E1D", "NormalizedSubject"),
            ("0x0E1F", "RtfInSync"),
            ("0x0E20", "AttachSize"),
            ("0x0E21", "AttachNumber"),
            ("0x0E28", "PrimarySendAccount"),
            ("0x0E29", "NextSendAcct"),
            ("0x0E2B", "ToDoItemFlags"),
            ("0x0E2C", "SwappedToDoStore"),
            ("0x0E2D", "SwappedToDoData"),
            ("0x0E69", "Read"),
            ("0x0E6A", "SecurityDescriptorAsXml"),
            ("0x0E79", "TrustSender"),
            ("0x0E84", "ExchangeNTSecurityDescriptor"),
            ("0x0E99", "ExtendedRuleMessageActions"),
            ("0x0E9A", "ExtendedRuleMessageCondition"),
            ("0x0E9B", "ExtendedRuleSizeLimit"),
            ("0x0FF4", "Access"),
            ("0x0FF5", "RowType"),
            ("0x0FF6", "InstanceKey"),
            ("0x0FF7", "AccessLevel"),
            ("0x0FF8", "MappingSignature"),
            ("0x0FF9", "RecordKey"),
            ("0x0FFB", "StoreEntryId"),
            ("0x0FFE", "ObjectType"),
            ("0x0FFF", "EntryId"),
            ("0x1000", "Body"),
            ("0x1001", "ReportText"),
            ("0x1009", "RtfCompressed"),
            ("0x1013", "Html"),
            ("0x1014", "BodyContentLocation"),
            ("0x1015", "BodyContentId"),
            ("0x1016", "NativeBody"),
            ("0x1035", "InternetMessageId"),
            ("0x1039", "InternetReferences"),
            ("0x1042", "InReplyToId"),
            ("0x1043", "ListHelp"),
            ("0x1044", "ListSubscribe"),
            ("0x1045", "ListUnsubscribe"),
            ("0x1046", "OriginalMessageId"),
            ("0x1080", "IconIndex"),
            ("0x1081", "LastVerbExecuted"),
            ("0x1082", "LastVerbExecutionTime"),
            ("0x1090", "FlagStatus"),
            ("0x1091", "FlagCompleteTime"),
            ("0x1095", "FollowupIcon"),
            ("0x1096", "BlockStatus"),
            ("0x10C3", "ICalendarStartTime"),
            ("0x10C4", "ICalendarEndTime"),
            ("0x10C5", "CdoRecurrenceid"),
            ("0x10CA", "ICalendarReminderNextTime"),
            ("0x10F4", "AttributeHidden"),
            ("0x10F6", "AttributeReadOnly"),
            ("0x3000", "Rowid"),
            ("0x3001", "DisplayName"),
            ("0x3002", "AddressType"),
            ("0x3003", "EmailAddress"),
            ("0x3004", "Comment"),
            ("0x3005", "Depth"),
            ("0x3007", "CreationTime"),
            ("0x3008", "LastModificationTime"),
            ("0x300B", "SearchKey"),
            ("0x3010", "TargetEntryId"),
            ("0x3013", "ConversationId"),
            ("0x3016", "ConversationIndexTracking"),
            ("0x3018", "ArchiveTag"),
            ("0x3019", "PolicyTag"),
            ("0x301A", "RetentionPeriod"),
            ("0x301B", "StartDateEtc"),
            ("0x301C", "RetentionDate"),
            ("0x301D", "RetentionFlags"),
            ("0x301E", "ArchivePeriod"),
            ("0x301F", "ArchiveDate"),
            ("0x340D", "StoreSupportMask"),
            ("0x340E", "StoreState"),
            ("0x3600", "ContainerFlags"),
            ("0x3601", "FolderType"),
            ("0x3602", "ContentCount"),
            ("0x3603", "ContentUnreadCount"),
            ("0x3609", "Selectable"),
            ("0x360A", "Subfolders"),
            ("0x360C", "Anr"),
            ("0x360E", "ContainerHierarchy"),
            ("0x360F", "ContainerContents"),
            ("0x3610", "FolderAssociatedContents"),
            ("0x3613", "ContainerClass"),
            ("0x36D0", "IpmAppointmentEntryId"),
            ("0x36D1", "IpmContactEntryId"),
            ("0x36D2", "IpmJournalEntryId"),
            ("0x36D3", "IpmNoteEntryId"),
            ("0x36D4", "IpmTaskEntryId"),
            ("0x36D5", "RemindersOnlineEntryId"),
            ("0x36D7", "IpmDraftsEntryId"),
            ("0x36D8", "AdditionalRenEntryIds"),
            ("0x36D9", "AdditionalRenEntryIdsEx"),
            ("0x36DA", "ExtendedFolderFlags"),
            ("0x36E2", "OrdinalMost"),
            ("0x36E4", "FreeBusyEntryIds"),
            ("0x36E5", "DefaultPostMessageClass"),
            ("0x3701", "AttachDataObject"),
            ("0x3702", "AttachEncoding"),
            ("0x3703", "AttachExtension"),
            ("0x3704", "AttachFilename"),
            ("0x3705", "AttachMethod"),
            ("0x3707", "AttachLongFilename"),
            ("0x3708", "AttachPathname"),
            ("0x3709", "AttachRendering"),
            ("0x370A", "AttachTag"),
            ("0x370B", "RenderingPosition"),
            ("0x370C", "AttachTransportName"),
            ("0x370D", "AttachLongPathname"),
            ("0x370E", "AttachMimeTag"),
            ("0x370F", "AttachAdditionalInformation"),
            ("0x3711", "AttachContentBase"),
            ("0x3712", "AttachContentId"),
            ("0x3713", "AttachContentLocation"),
            ("0x3714", "AttachFlags"),
            ("0x3719", "AttachPayloadProviderGuidString"),
            ("0x371A", "AttachPayloadClass"),
            ("0x371B", "TextAttachmentCharset"),
            ("0x3900", "DisplayType"),
            ("0x3902", "Templateid"),
            ("0x3905", "DisplayTypeEx"),
            ("0x39FE", "SmtpAddress"),
            ("0x39FF", "AddressBookDisplayNamePrintable"),
            ("0x3A00", "Account"),
            ("0x3A02", "CallbackTelephoneNumber"),
            ("0x3A05", "Generation"),
            ("0x3A06", "GivenName"),
            ("0x3A07", "GovernmentIdNumber"),
            ("0x3A08", "BusinessTelephoneNumber"),
            ("0x3A09", "HomeTelephoneNumber"),
            ("0x3A0A", "Initials"),
            ("0x3A0B", "Keyword"),
            ("0x3A0C", "Language"),
            ("0x3A0D", "Location"),
            ("0x3A0F", "MessageHandlingSystemCommonName"),
            ("0x3A10", "OrganizationalIdNumber"),
            ("0x3A11", "Surname"),
            ("0x3A12", "OriginalEntryId"),
            ("0x3A15", "PostalAddress"),
            ("0x3A16", "CompanyName"),
            ("0x3A17", "Title"),
            ("0x3A18", "DepartmentName"),
            ("0x3A19", "OfficeLocation"),
            ("0x3A1A", "PrimaryTelephoneNumber"),
            ("0x3A1B", "Business2TelephoneNumbers"),
            ("0x3A1C", "MobileTelephoneNumber"),
            ("0x3A1D", "RadioTelephoneNumber"),
            ("0x3A1E", "CarTelephoneNumber"),
            ("0x3A1F", "OtherTelephoneNumber"),
            ("0x3A20", "TransmittableDisplayName"),
            ("0x3A21", "PagerTelephoneNumber"),
            ("0x3A22", "UserCertificate"),
            ("0x3A23", "PrimaryFaxNumber"),
            ("0x3A24", "BusinessFaxNumber"),
            ("0x3A25", "HomeFaxNumber"),
            ("0x3A26", "Country"),
            ("0x3A27", "Locality"),
            ("0x3A28", "StateOrProvince"),
            ("0x3A29", "StreetAddress"),
            ("0x3A2A", "PostalCode"),
            ("0x3A2B", "PostOfficeBox"),
            ("0x3A2C", "TelexNumber"),
            ("0x3A2D", "IsdnNumber"),
            ("0x3A2E", "AssistantTelephoneNumber"),
            ("0x3A2F", "Home2TelephoneNumbers"),
            ("0x3A30", "Assistant"),
            ("0x3A40", "SendRichInfo"),
            ("0x3A41", "WeddingAnniversary"),
            ("0x3A42", "Birthday"),
            ("0x3A43", "Hobbies"),
            ("0x3A44", "MiddleName"),
            ("0x3A45", "DisplayNamePrefix"),
            ("0x3A46", "Profession"),
            ("0x3A47", "ReferredByName"),
            ("0x3A48", "SpouseName"),
            ("0x3A49", "ComputerNetworkName"),
            ("0x3A4A", "CustomerId"),
            ("0x3A4B", "TelecommunicationsDeviceForDeafTelephoneNumber"),
            ("0x3A4C", "FtpSite"),
            ("0x3A4D", "Gender"),
            ("0x3A4E", "ManagerName"),
            ("0x3A4F", "Nickname"),
            ("0x3A50", "PersonalHomePage"),
            ("0x3A51", "BusinessHomePage"),
            ("0x3A57", "CompanyMainTelephoneNumber"),
            ("0x3A58", "ChildrensNames"),
            ("0x3A59", "HomeAddressCity"),
            ("0x3A5A", "HomeAddressCountry"),
            ("0x3A5B", "HomeAddressPostalCode"),
            ("0x3A5C", "HomeAddressStateOrProvince"),
            ("0x3A5D", "HomeAddressStreet"),
            ("0x3A5E", "HomeAddressPostOfficeBox"),
            ("0x3A5F", "OtherAddressCity"),
            ("0x3A60", "OtherAddressCountry"),
            ("0x3A61", "OtherAddressPostalCode"),
            ("0x3A62", "OtherAddressStateOrProvince"),
            ("0x3A63", "OtherAddressStreet"),
            ("0x3A64", "OtherAddressPostOfficeBox"),
            ("0x3A70", "UserX509Certificate"),
            ("0x3A71", "SendInternetEncoding"),
            ("0x3F08", "InitialDetailsPane"),
            ("0x3FDE", "InternetCodepage"),
            ("0x3FDF", "AutoResponseSuppress"),
            ("0x3FE0", "AccessControlListData"),
            ("0x3FE3", "DelegatedByRule"),
            ("0x3FE7", "ResolveMethod"),
            ("0x3FEA", "HasDeferredActionMessages"),
            ("0x3FEB", "DeferredSendNumber"),
            ("0x3FEC", "DeferredSendUnits"),
            ("0x3FED", "ExpiryNumber"),
            ("0x3FEE", "ExpiryUnits"),
            ("0x3FEF", "DeferredSendTime"),
            ("0x3FF0", "ConflictEntryId"),
            ("0x3FF1", "MessageLocaleId"),
            ("0x3FF8", "CreatorName"),
            ("0x3FF9", "CreatorEntryId"),
            ("0x3FFA", "LastModifierName"),
            ("0x3FFB", "LastModifierEntryId"),
            ("0x3FFD", "MessageCodepage"),
            ("0x401A", "SentRepresentingFlags"),
            ("0x4029", "ReadReceiptAddressType"),
            ("0x402A", "ReadReceiptEmailAddress"),
            ("0x402B", "ReadReceiptName"),
            ("0x4076", "ContentFilterSpamConfidenceLevel"),
            ("0x4079", "SenderIdStatus"),
            ("0x4082", "HierRev"),
            ("0x4083", "PurportedSenderDomain"),
            ("0x5902", "InternetMailOverrideFormat"),
            ("0x5909", "MessageEditorFormat"),
            ("0x5D01", "SenderSmtpAddress"),
            ("0x5D02", "SentRepresentingSmtpAddress"),
            ("0x5D05", "ReadReceiptSmtpAddress"),
            ("0x5D07", "ReceivedBySmtpAddress"),
            ("0x5D08", "ReceivedRepresentingSmtpAddress"),
            ("0x5FDF", "RecipientOrder"),
            ("0x5FE1", "RecipientProposed"),
            ("0x5FE3", "RecipientProposedStartTime"),
            ("0x5FE4", "RecipientProposedEndTime"),
            ("0x5FF6", "RecipientDisplayName"),
            ("0x5FF7", "RecipientEntryId"),
            ("0x5FFB", "RecipientTrackStatusTime"),
            ("0x5FFD", "RecipientFlags"),
            ("0x5FFF", "RecipientTrackStatus"),
            ("0x6100", "JunkIncludeContacts"),
            ("0x6101", "JunkThreshold"),
            ("0x6102", "JunkPermanentlyDelete"),
            ("0x6103", "JunkAddRecipientsToSafeSendersList"),
            ("0x6107", "JunkPhishingEnableLinks"),
            ("0x64F0", "MimeSkeleton"),
            ("0x65C2", "ReplyTemplateId"),
            ("0x65E0", "SourceKey"),
            ("0x65E1", "ParentSourceKey"),
            ("0x65E2", "ChangeKey"),
            ("0x65E3", "PredecessorChangeList"),
            ("0x65E9", "RuleMessageState"),
            ("0x65EA", "RuleMessageUserFlags"),
            ("0x65EB", "RuleMessageProvider"),
            ("0x65EC", "RuleMessageName"),
            ("0x65ED", "RuleMessageLevel"),
            ("0x65EE", "RuleMessageProviderData"),
            ("0x65F3", "RuleMessageSequence"),
            ("0x6619", "UserEntryId"),
            ("0x661B", "MailboxOwnerEntryId"),
            ("0x661C", "MailboxOwnerName"),
            ("0x661D", "OutOfOfficeState"),
            ("0x6622", "SchedulePlusFreeBusyEntryId"),
            ("0x6638", "SerializedReplidGuidMap"),
            ("0x6639", "Rights"),
            ("0x663A", "HasRules"),
            ("0x663B", "AddressBookEntryId"),
            ("0x663E", "HierarchyChangeNumber"),
            ("0x6645", "ClientActions"),
            ("0x6646", "DamOriginalEntryId"),
            ("0x6647", "DamBackPatched"),
            ("0x6648", "RuleError"),
            ("0x6649", "RuleActionType"),
            ("0x664A", "HasNamedProperties"),
            ("0x6650", "RuleActionNumber"),
            ("0x6651", "RuleFolderEntryId"),
            ("0x666A", "ProhibitReceiveQuota"),
            ("0x666C", "InConflict"),
            ("0x666D", "MaximumSubmitMessageSize"),
            ("0x666E", "ProhibitSendQuota"),
            ("0x6671", "MemberId"),
            ("0x6672", "MemberName"),
            ("0x6673", "MemberRights"),
            ("0x6674", "RuleId"),
            ("0x6675", "RuleIds"),
            ("0x6676", "RuleSequence"),
            ("0x6677", "RuleState"),
            ("0x6678", "RuleUserFlags"),
            ("0x6679", "RuleCondition"),
            ("0x6680", "RuleActions"),
            ("0x6681", "RuleProvider"),
            ("0x6682", "RuleName"),
            ("0x6683", "RuleLevel"),
            ("0x6684", "RuleProviderData"),
            ("0x668F", "DeletedOn"),
            ("0x66A1", "LocaleId"),
            ("0x66A8", "FolderFlags"),
            ("0x66C3", "CodePageId"),
            ("0x6704", "AddressBookManageDistributionList"),
            ("0x6705", "SortLocaleId"),
            ("0x6709", "LocalCommitTime"),
            ("0x670A", "LocalCommitTimeMax"),
            ("0x670B", "DeletedCountTotal"),
            ("0x670E", "FlatUrlName"),
            ("0x6740", "SentMailSvrEID"),
            ("0x6741", "DeferredActionMessageOriginalEntryId"),
            ("0x6748", "FolderId"),
            ("0x6749", "ParentFolderId"),
            ("0x674A", "Mid"),
            ("0x674D", "InstID"),
            ("0x674E", "InstanceNum"),
            ("0x674F", "AddressBookMessageId"),
            ("0x67A4", "ChangeNumber"),
            ("0x67AA", "Associated"),
            ("0x6800", "OfflineAddressBookName"),
            ("0x6801", "VoiceMessageDuration"),
            ("0x6802", "SenderTelephoneNumber"),
            ("0x6803", "VoiceMessageSenderName"),
            ("0x6804", "OfflineAddressBookDistinguishedName"),
            ("0x6805", "VoiceMessageAttachmentOrder"),
            ("0x6806", "CallId"),
            ("0x6820", "ReportingMessageTransferAgent"),
            ("0x6834", "SearchFolderLastUsed"),
            ("0x683A", "SearchFolderExpiration"),
            ("0x6841", "SearchFolderTemplateId"),
            ("0x6842", "WlinkGroupHeaderID"),
            ("0x6843", "ScheduleInfoDontMailDelegates"),
            ("0x6844", "SearchFolderRecreateInfo"),
            ("0x6845", "SearchFolderDefinition"),
            ("0x6846", "SearchFolderComponentType"),
            ("0x6847", "WlinkSaveStamp"),
            ("0x6848", "SearchFolderEfpFlags"),
            ("0x6849", "WlinkType"),
            ("0x684A", "WlinkFlags"),
            ("0x684B", "WlinkOrdinal"),
            ("0x684C", "WlinkEntryId"),
            ("0x684D", "WlinkRecordKey"),
            ("0x684E", "WlinkStoreEntryId"),
            ("0x684F", "WlinkFolderType"),
            ("0x6850", "WlinkGroupClsid"),
            ("0x6851", "WlinkGroupName"),
            ("0x6852", "WlinkSection"),
            ("0x6853", "WlinkCalendarColor"),
            ("0x6854", "WlinkAddressBookEID"),
            ("0x6855", "ScheduleInfoMonthsAway"),
            ("0x6856", "ScheduleInfoFreeBusyAway"),
            ("0x6868", "FreeBusyRangeTimestamp"),
            ("0x6869", "FreeBusyCountMonths"),
            ("0x686A", "ScheduleInfoAppointmentTombstone"),
            ("0x686B", "DelegateFlags"),
            ("0x686C", "ScheduleInfoFreeBusy"),
            ("0x686D", "ScheduleInfoAutoAcceptAppointments"),
            ("0x686E", "ScheduleInfoDisallowRecurringAppts"),
            ("0x686F", "ScheduleInfoDisallowOverlappingAppts"),
            ("0x6890", "WlinkClientID"),
            ("0x6891", "WlinkAddressBookStoreEID"),
            ("0x6892", "WlinkROGroupType"),
            ("0x7001", "ViewDescriptorBinary"),
            ("0x7002", "ViewDescriptorStrings"),
            ("0x7006", "ViewDescriptorName"),
            ("0x7007", "ViewDescriptorVersion"),
            ("0x7C06", "RoamingDatatypes"),
            ("0x7C07", "RoamingDictionary"),
            ("0x7C08", "RoamingXmlStream"),
            ("0x7C24", "OscSyncEnabled"),
            ("0x7D01", "Processed"),
            ("0x7FF9", "ExceptionReplaceTime"),
            ("0x7FFA", "AttachmentLinkId"),
            ("0x7FFB", "ExceptionStartTime"),
            ("0x7FFC", "ExceptionEndTime"),
            ("0x7FFD", "AttachmentFlags"),
            ("0x7FFE", "AttachmentHidden"),
            ("0x7FFF", "AttachmentContactPhoto"),
            ("0x8004", "AddressBookFolderPathname"),
            ("0x8005", "AddressBookManagerDistinguishedName"),
            ("0x8006", "AddressBookHomeMessageDatabase"),
            ("0x8008", "AddressBookIsMemberOfDistributionList"),
            ("0x8009", "AddressBookMember"),
            ("0x800C", "AddressBookOwner"),
            ("0x800E", "AddressBookReports"),
            ("0x800F", "AddressBookProxyAddresses"),
            ("0x8011", "AddressBookTargetAddress"),
            ("0x8015", "AddressBookPublicDelegates"),
            ("0x8024", "AddressBookOwnerBackLink"),
            ("0x802D", "AddressBookExtensionAttribute1"),
            ("0x802E", "AddressBookExtensionAttribute2"),
            ("0x802F", "AddressBookExtensionAttribute3"),
            ("0x8030", "AddressBookExtensionAttribute4"),
            ("0x8031", "AddressBookExtensionAttribute5"),
            ("0x8032", "AddressBookExtensionAttribute6"),
            ("0x8033", "AddressBookExtensionAttribute7"),
            ("0x8034", "AddressBookExtensionAttribute8"),
            ("0x8035", "AddressBookExtensionAttribute9"),
            ("0x8036", "AddressBookExtensionAttribute10"),
            ("0x803C", "AddressBookObjectDistinguishedName"),
            ("0x806A", "AddressBookDeliveryContentLength"),
            ("0x8073", "AddressBookDistributionListMemberSubmitAccepted"),
            ("0x8170", "AddressBookNetworkAddress"),
            ("0x8C57", "AddressBookExtensionAttribute11"),
            ("0x8C58", "AddressBookExtensionAttribute12"),
            ("0x8C59", "AddressBookExtensionAttribute13"),
            ("0x8C60", "AddressBookExtensionAttribute14"),
            ("0x8C61", "AddressBookExtensionAttribute15"),
            ("0x8C6A", "AddressBookX509Certificate"),
            ("0x8C6D", "AddressBookObjectGuid"),
            ("0x8C8E", "AddressBookPhoneticGivenName"),
            ("0x8C8F", "AddressBookPhoneticSurname"),
            ("0x8C90", "AddressBookPhoneticDepartmentName"),
            ("0x8C91", "AddressBookPhoneticCompanyName"),
            ("0x8C92", "AddressBookPhoneticDisplayName"),
            ("0x8C93", "AddressBookDisplayTypeExtended"),
            ("0x8C94", "AddressBookHierarchicalShowInDepartments"),
            ("0x8C96", "AddressBookRoomContainers"),
            ("0x8C97", "AddressBookHierarchicalDepartmentMembers"),
            ("0x8C98", "AddressBookHierarchicalRootDepartment"),
            ("0x8C99", "AddressBookHierarchicalParentDepartment"),
            ("0x8C9A", "AddressBookHierarchicalChildDepartments"),
            ("0x8C9E", "ThumbnailPhoto"),
            ("0x8CA0", "AddressBookSeniorityIndex"),
            (
                "0x8CA8",
                "AddressBookOrganizationalUnitRootDistinguishedName",
            ),
            ("0x8CAC", "AddressBookSenderHintTranslations"),
            ("0x8CB5", "AddressBookModerationEnabled"),
            ("0x8CC2", "SpokenName"),
            ("0x8CD8", "AddressBookAuthorizedSenders"),
            ("0x8CD9", "AddressBookUnauthorizedSenders"),
            ("0x8CDA", "AddressBookDistributionListMemberSubmitRejected"),
            (
                "0x8CDB",
                "AddressBookDistributionListRejectMessagesFromDLMembers",
            ),
            ("0x8CDD", "AddressBookHierarchicalIsHierarchicalGroup"),
            ("0x8CE2", "AddressBookDistributionListMemberCount"),
            ("0x8CE3", "AddressBookDistributionListExternalMemberCount"),
            ("0xFFFB", "AddressBookIsMaster"),
            ("0xFFFC", "AddressBookParentEntryId"),
            ("0xFFFD", "AddressBookContainerId"),
        ]
        .into_iter()
        .map(|(k, v)| (k.to_string(), v.to_string()))
        .collect();

        Self { map }
    }

    pub fn get_canonical_name(&self, id: &str) -> Option<String> {
        self.map.get(id).map(|v| v.to_string())
    }
}
