extern crate mp4parse;

use std::env;
use std::fs::File;
use std::io::BufReader;

extern crate byteorder;

fn dump_file(filename: &String) {
    let file = File::open(filename).unwrap();
    let mut reader = BufReader::new(file);
    let mut context = mp4parse::MediaContext::new();
    // Turn on debug output.
    context.trace(true);
    // Read all boxes.
    loop {
        match mp4parse::read_box(&mut reader, &mut context) {
            Ok(_) => {},
            Err(mp4parse::Error::UnexpectedEOF) => { break },
            Err(e) => { panic!(e); },
        }
    }
    println!("-- result of parsing '{}' --\n{:?}", filename, context);
}

fn main() {
    for filename in env::args().skip(1) {
        println!("-- dump of '{}' --", filename);
        dump_file(&filename);
        println!("-- end of '{}' --", filename);
    }
}
