use std::error::Error;
use std::fmt;
use std::string::FromUtf8Error;

/// Error type returned by _try methods
#[derive(Debug, PartialEq)]
pub enum PatternError {
    Pattern(String),
    Utf8(FromUtf8Error),
}

impl fmt::Display for PatternError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self {
            PatternError::Pattern(s) => write!(f, "bad pattern: {}", s),
            PatternError::Utf8(e) => write!(f, "bad UTF-8 {}", e),
        }
    }
}

impl Error for PatternError {}
