#include <cstdio>
#include <libstaticvec.h>

// I'm aware there's a weird mix of C and C++ going on here...

int main() {
  CStaticVec v = staticvec_new();
  staticvec_push(&v, "A");
  staticvec_push(&v, "B");
  staticvec_push(&v, "C");
  staticvec_push(&v, "D");

  printf("%zu\n", staticvec_size_in_bytes(&v));

  while (staticvec_len(&v) > 0) {
    printf("%s\n", (const char *)staticvec_pop(&v).value);
  }

  for (size_t i = 0; i < staticvec_capacity(&v); ++i)
    staticvec_push(&v, (VoidPtr)i);

  printf("%zu\n", staticvec_len(&v));

  printf("%zu\n", staticvec_capacity(&v));

  staticvec_pop(&v);

  staticvec_pop(&v);

  printf("%zu\n", staticvec_remaining_capacity(&v));

  staticvec_clear(&v);

  printf("%zu\n", staticvec_len(&v));

  for (size_t i = 0; i < 3; ++i)
    staticvec_push(&v, (VoidPtr)i);

  staticvec_insert(&v, 2, (VoidPtr)17);

  for (size_t i = 0; i < staticvec_len(&v); ++i)
    printf("%zu\n", (size_t)staticvec_get(&v, i));

  staticvec_set(&v, 2, (VoidPtr)27);

  printf("%zu\n", (size_t)staticvec_get(&v, 2));

  printf("%d\n", (int)staticvec_contains(&v, (VoidPtr)27));

  printf("%d\n", (int)staticvec_contains(&v, (VoidPtr)98));

  printf("%zu\n", (size_t)staticvec_remove(&v, 2));

  printf("%zu\n", (size_t)staticvec_remove_item(&v, (VoidPtr)1).value);

  staticvec_clear(&v);

  const VoidPtr values[VECTOR_CAPACITY] = {
      "A", "B", "C", "D", "A", "B", "C", "D",
      "A", "B", "C", "D", "A", "B", "C", "D"};

  CStaticVec v2 = staticvec_new_from_const_array(values);

  for (size_t i = 0; i < staticvec_len(&v2); ++i) {
    printf("%s\n", (const char *)staticvec_get(&v2, i));
  }

  staticvec_clear(&v2);

  return 0;
}
