#include <cstdbool>
#include <cstdint>
#include <cstdlib>

// You'll want to change this to reflect the capacity
// you've built `libstaticvec` with, if not using the default
// `capacity_16` crate feature.
static constexpr size_t VECTOR_CAPACITY = 16;

using VoidPtr = const void *;

extern "C" {
// TODO: Figure out if there's any possible way to accept more than
// just opaque pointers.
struct CStaticVec {
private:
  VoidPtr data[VECTOR_CAPACITY];
  size_t length;
};

// TODO: Maybe make this an actual union or something? Might not be worth
// it though.
struct COption {
  bool is_some;
  VoidPtr value;
};

size_t staticvec_capacity(const CStaticVec *vec);

void staticvec_clear(CStaticVec *vec);

bool staticvec_contains(const CStaticVec *vec, VoidPtr item);

VoidPtr staticvec_get(const CStaticVec *vec, size_t index);

void staticvec_insert(CStaticVec *vec, size_t index, VoidPtr item);

size_t staticvec_len(const CStaticVec *vec);

CStaticVec staticvec_new(void);

COption staticvec_pop(CStaticVec *vec);

void staticvec_push(CStaticVec *vec, VoidPtr item);

size_t staticvec_remaining_capacity(const CStaticVec *vec);

VoidPtr staticvec_remove(CStaticVec *vec, size_t index);

COption staticvec_remove_item(CStaticVec *vec, VoidPtr item);

void staticvec_set(CStaticVec *vec, size_t index, VoidPtr item);

size_t staticvec_size_in_bytes(const CStaticVec *vec);
}