#![allow(incomplete_features)]
#![feature(const_generics)]

use staticvec::StaticVec;

#[cfg(feature = "capacity_32")]
pub const VECTOR_CAPACITY: usize = 32;

#[cfg(feature = "capacity_64")]
pub const VECTOR_CAPACITY: usize = 64;

#[cfg(feature = "capacity_128")]
pub const VECTOR_CAPACITY: usize = 128;

#[cfg(feature = "capacity_256")]
pub const VECTOR_CAPACITY: usize = 256;

#[cfg(feature = "capacity_512")]
pub const VECTOR_CAPACITY: usize = 512;

pub type VoidPtr = *const core::ffi::c_void;
pub type CStaticVec = StaticVec<VoidPtr, VECTOR_CAPACITY>;

#[repr(C)]
pub struct COption {
  is_some: bool,
  value: VoidPtr,
}

#[no_mangle]
pub extern "C" fn staticvec_capacity(vec: *const CStaticVec) -> usize {
  unsafe { (*vec).capacity() }
}

#[no_mangle]
pub extern "C" fn staticvec_clear(vec: *mut CStaticVec) {
  unsafe { (*vec).clear() };
}

#[no_mangle]
pub extern "C" fn staticvec_contains(vec: *const CStaticVec, item: VoidPtr) -> bool {
  unsafe { (*vec).contains(&item) }
}

#[no_mangle]
pub extern "C" fn staticvec_get(vec: *const CStaticVec, index: usize) -> VoidPtr {
  unsafe { (*vec)[index] }
}

#[no_mangle]
pub extern "C" fn staticvec_insert(vec: *mut CStaticVec, index: usize, item: VoidPtr) {
  unsafe { (*vec).insert(index, item) };
}

#[no_mangle]
pub extern "C" fn staticvec_len(vec: *const CStaticVec) -> usize {
  unsafe { (*vec).len() }
}

#[no_mangle]
pub extern "C" fn staticvec_new() -> CStaticVec {
  StaticVec::new()
}

#[no_mangle]
pub extern "C" fn staticvec_pop(vec: *mut CStaticVec) -> COption {
  let res = unsafe { (*vec).pop() };
  if res.is_some() {
    COption {
      is_some: true,
      value: res.unwrap(),
    }
  } else {
    COption {
      is_some: false,
      value: core::ptr::null(),
    }
  }
}

#[no_mangle]
pub extern "C" fn staticvec_push(vec: *mut CStaticVec, item: VoidPtr) {
  unsafe {
    (*vec).push(item);
  }
}

#[no_mangle]
pub extern "C" fn staticvec_remaining_capacity(vec: *const CStaticVec) -> usize {
  unsafe { (*vec).remaining_capacity() }
}

#[no_mangle]
pub extern "C" fn staticvec_remove(vec: *mut CStaticVec, index: usize) -> VoidPtr {
  unsafe { (*vec).remove(index) }
}

#[no_mangle]
pub extern "C" fn staticvec_remove_item(vec: *mut CStaticVec, item: VoidPtr) -> COption {
  let res = unsafe { (*vec).remove_item(&item) };
  if res.is_some() {
    COption {
      is_some: true,
      value: res.unwrap(),
    }
  } else {
    COption {
      is_some: false,
      value: core::ptr::null(),
    }
  }
}

#[no_mangle]
pub extern "C" fn staticvec_set(vec: *mut CStaticVec, index: usize, item: VoidPtr) {
  unsafe { (*vec)[index] = item }
}
