#include <libstaticvec.h>
#include <stdio.h>

int main() {
  CStaticVec v = staticvec_new();

  for (size_t i = 0; i < 32; ++i)
    staticvec_push(&v, (VoidPtr)i);

  while (staticvec_len(&v) > 0)
    printf("%lld\n", (size_t)staticvec_pop(&v).value);

  for (size_t i = 0; i < 32; ++i)
    staticvec_push(&v, (VoidPtr)i);

  printf("%lld\n", staticvec_len(&v));

  printf("%lld\n", staticvec_capacity(&v));

  staticvec_pop(&v);

  staticvec_pop(&v);

  printf("%lld\n", staticvec_remaining_capacity(&v));

  staticvec_clear(&v);

  printf("%lld\n", staticvec_len(&v));

  for (size_t i = 0; i < 3; ++i)
    staticvec_push(&v, (VoidPtr)i);

  staticvec_insert(&v, 2, (VoidPtr)17);

  for (size_t i = 0; i < staticvec_len(&v); ++i)
    printf("%lld\n", (size_t)staticvec_get(&v, i));

  staticvec_set(&v, 2, (VoidPtr)27);

  printf("%lld\n", (size_t)staticvec_get(&v, 2));

  printf("%d\n", (int)staticvec_contains(&v, (VoidPtr)27));

  printf("%d\n", (int)staticvec_contains(&v, (VoidPtr)98));

  printf("%lld\n", (size_t)staticvec_remove(&v, 2));

  printf("%lld\n", (size_t)staticvec_remove_item(&v, (VoidPtr)1).value);

  staticvec_clear(&v);
}