#![allow(warnings, unused)]

use libgitmail::{Id, Patch, Segment, Subject};

const TEST_MAIL: &'static str = include_str!("../email.txt");

/// Parse an e-mail that was generated by git-send-email in a real projectf
#[test]
fn parse_mail() {
  let headers = Patch::preprocess(TEST_MAIL);
  assert_eq!(
    Patch::new(TEST_MAIL).unwrap(),
    Patch {
      id: Id("<20191229132404.14579-1-hi@alyssa.is>".into()),
      headers,
      raw: TEST_MAIL,
      reply_to: None,
      subject: Subject {
        version: 1,
        segment: None,
        prefix: "PATCH".into(),
        message: "docs: Node.js 10 works fine (now?)".into()
      }
    }
  )
}
