//! Various functions to work with assembled patch sets

use crate::Patch;

/// A set of patches that can be applied to a repo
pub struct PatchSet<'maildir> {
  list: Vec<Patch<'maildir>>,
}

impl<'maildir> PatchSet<'maildir> {
  /// Consumes a PatchSet with a builder on each patch in the series
  pub fn exec<F>(self, cb: F)
  where
    F: Fn(Patch<'maildir>),
  {
    self.list.into_iter().for_each(|p| cb(p));
  }
}
