//! A library that can parse git-send-email generated email
//!
//! Please note that this is not a general mail parser.  It is
//! specifically built to understand mail generated by git-send-email.
//! For a more general mail parser, maybe look at mailparse or mail
//! instead.
//!
//! The important fields to get from a git email are the "In-Reply-To"
//! and "References" header.  The `structure` method returns the basic
//! structure of a pathset with a way to select specific parts of the
//! set to export.  Look at the `PatchSet` type for more information.

mod patch;
pub use patch::*;

pub mod set;
pub mod tree;

pub type Result<T> = std::result::Result<T, Error>;

/// A mail error type
#[derive(Debug)]
pub enum Error {
  /// Failed to parse the email for an unknown reason
  FailedParsing,
  /// The provided email is not a valid get-sent mail
  NotAGitMail,
  /// Generally a git email, but malformed
  InvalidGitFormat,
}
