pub mod serialization {
    pub use serialization::dll_serde::*;

    pub use serialization::func_serde::*;

    pub use serialization::func_mapper_serde::*;

    pub use serialization::parameter_serde::*;

    mod dll_serde {
        use serialization::FuncSerde;

        #[derive(Clone, Debug, Deserialize, Eq, PartialEq)]
        pub struct DllSerde {
            dll: String,
            functions: Vec<FuncSerde>,
        }

        impl DllSerde {
            pub fn destructure(self) -> (String, Vec<FuncSerde>) {
                (self.dll, self.functions)
            }
        }
    }

    mod func_serde {
        use serialization::ParameterSerde;

        #[derive(Clone, Debug, Deserialize, Eq, PartialEq)]
        pub struct FuncSerde {
            input: Option<ParameterSerde>,
            output: Option<ParameterSerde>,
            symbol: String,
            name: Option<String>,
        }

        impl FuncSerde {
            pub fn destructure(self) -> (Option<ParameterSerde>, Option<ParameterSerde>, String, Option<String>) {
                (
                    self.input,
                    self.output,
                    self.symbol,
                    self.name,
                )
            }
        }
    }

    mod func_mapper_serde {
        use std::collections::HashMap;

        #[derive(Clone, Debug, Serialize, Eq, PartialEq)]
        pub struct FuncMapperSerde<'a> {
            func_map: &'a Vec<Option<HashMap<String, usize>>>,
        }

        impl <'a> FuncMapperSerde<'a> {
            pub fn new(
                func_map: &'a Vec<Option<HashMap<String, usize>>>,
            ) -> Self {
                FuncMapperSerde {
                    func_map: func_map,
                }
            }
        }
    }

    mod parameter_serde {
        #[allow(non_camel_case_types)]
        #[derive(Clone, Debug, Deserialize, Eq, PartialEq)]
        pub enum ParameterSerde {
            none,
            any,
            string
        }
    }
}
