#![recursion_limit="200"]

// Begin serde

#![cfg_attr(feature = "serde_macros", feature(plugin, custom_derive))]

#![cfg_attr(feature = "serde_macros", plugin(serde_macros))]

extern crate serde;

extern crate serde_json;

#[cfg(feature = "serde_macros")]
include!("serde_types.in.rs");

#[cfg(feature = "serde_codegen")]
include!(concat!(env!("OUT_DIR"), "/serde_types.rs"));

// End serde

#[macro_use]
extern crate error_chain;

extern crate libflo_error;

extern crate libflo_module;

extern crate sharedlib;

#[macro_use]
mod register_funcs;

pub mod error;

mod file_funcs;

mod func;

mod func_mapper;

mod load;

mod payload;

mod string;

#[cfg(test)]
mod test;

pub use error::*;

pub use func::*;

pub use func_mapper::*;

pub use load::*;

pub use payload::*;
