use error::*;
use libflo_module::{ file_from_path, text_from_file };
use serde_json;
use serialization::DllSerde;
use std::path::Path;

pub fn dll_from_path<TPath>(path: TPath) -> Result<DllSerde>
    where TPath: AsRef<Path> {
    let file = file_from_path(path)?;
    let text = text_from_file(file)?;
    dll_from_text(text)
}

pub fn dll_from_text(text: String) -> Result<DllSerde> {
    serde_json::from_str::<DllSerde>(&text)
        .map_err(|err| Error::from(ErrorKind::SerdeJsonError(err)))
        .chain_err(|| ErrorKind::DllDeserializationFailure(text))
}
