macro_rules! define_func_header {
    ($func_ident: ident: $func_pointer_type: ty) => {
        #[derive(Clone)]
        pub struct $func_ident {
            func: FuncArc<$func_pointer_type>,
        }

        impl $func_ident {
            pub unsafe fn new(dll: &LibArc, symbol: &String) -> Result<Self> {
                let func: FuncArc<$func_pointer_type> =
                    try!(
                        dll
                            .find_func(symbol)
                            .chain_err(|| ErrorKind::SymbolCouldNotLoad(symbol.clone()))
                    );

                let result =
                    $func_ident {
                        func: func,
                    };
                Ok(result)
            }
        }
    }
}
