use error::*;
use libflo_module::{ file_from_path, text_from_file };
use serde_json;
use serialization::Dll;
use std::path::Path;

pub fn dll_from_path<TPath>(path: TPath) -> Result<Dll>
    where TPath: AsRef<Path> {
    let file = try!(file_from_path(path));
    let text = try!(text_from_file(file));
    dll_from_text(text)
}

pub fn dll_from_text(text: String) -> Result<Dll> {
    serde_json::from_str::<Dll>(&text)
        .map_err(|err| Error::from(ErrorKind::SerdeJsonError(err)))
        .chain_err(|| ErrorKind::DllDeserializationFailure(text))
}
