use func::Func;
use test::res::dll;

#[test]
fn load() {
    unsafe { dll::all_dll() }.unwrap();
}

#[test]
fn hello_world() {
    let (dll, module) = unsafe { dll::all_dll() }.unwrap();
    let func_mapper = dll.destructure();
    let (module_mapper, _) = module.destructure();

    let libflo_func_test_0_id = module_mapper.get_id("libflo_func_test_0").unwrap();
    let hello_world_id = func_mapper.get_id(libflo_func_test_0_id, "hello_world".to_string()).unwrap();

    let hello_world_func = func_mapper.get_func(hello_world_id).unwrap();

    match hello_world_func {
        &Func::NativeFuncNone(ref func) => unsafe { func.clone().call().unwrap() },
        _ => panic!(),
    }
}
