pub mod serialization {
    pub use serialization::dll::Dll;

    pub use serialization::func::Func;

    pub use serialization::func_mapper_serde::FuncMapperSerde;

    pub use serialization::func_type::FuncType;

    mod dll {
        use serialization::Func;

        #[derive(Clone, Debug, Deserialize, Eq, PartialEq)]
        pub struct Dll {
            dll: String,
            functions: Vec<Func>,
        }

        impl Dll {
            pub fn destructure(self) -> (String, Vec<Func>) {
                (self.dll, self.functions)
            }
        }
    }

    mod func {
        use serialization::FuncType;

        #[derive(Clone, Debug, Deserialize, Eq, PartialEq)]
        pub struct Func {
            func_type: FuncType,
            has_input: Option<bool>,
            has_output: Option<bool>,
            symbol: String,
            use_as: Option<String>,
        }

        impl Func {
            pub fn destructure(self) -> (FuncType, Option<bool>, Option<bool>, String, Option<String>) {
                (
                    self.func_type,
                    self.has_input,
                    self.has_output,
                    self.symbol,
                    self.use_as,
                )
            }
        }
    }

    mod func_mapper_serde {
        use std::collections::HashMap;

        #[derive(Clone, Debug, Serialize, Eq, PartialEq)]
        pub struct FuncMapperSerde<'a> {
            func_map: &'a Vec<Option<HashMap<String, usize>>>,
        }

        impl <'a> FuncMapperSerde<'a> {
            pub fn new(
                func_map: &'a Vec<Option<HashMap<String, usize>>>,
            ) -> Self {
                FuncMapperSerde {
                    func_map: func_map,
                }
            }
        }
    }

    mod func_type {
        #[allow(non_camel_case_types)]
        #[derive(Clone, Debug, Deserialize, Eq, PartialEq)]
        pub enum FuncType {
            native,
            string,
        }
    }
}
