#[macro_use]
mod define_func_header;
#[macro_use]
mod define_func;
#[macro_use]
mod register_funcs;

use error::*;
use libflo_error::Result as FuncResult;
use sharedlib::{ FuncArc, LibArc, Symbol };
use serialization::FuncType;
use std::any::Any;

define_func!(
    (&Any, Box<Any>) {
        NativeFuncNone,
        NativeFuncInput,
        NativeFuncOutput,
        NativeFuncInputOutput
    }
);

define_func!(
    (&str, String) {
        StringFuncNone,
        StringFuncInput,
        StringFuncOutput,
        StringFuncInputOutput
    }
);

register_funcs!(
    (FuncType, Func) {
        native {
            NativeFuncNone,
            NativeFuncInput,
            NativeFuncOutput,
            NativeFuncInputOutput
        },
        string {
            StringFuncNone,
            StringFuncInput,
            StringFuncOutput,
            StringFuncInputOutput
        }
    }
);
