macro_rules! define_func {
    (
        ($input: ty, $output: ty) {
            $func_none_ident: ident,
            $func_input_ident: ident,
            $func_output_ident: ident,
            $func_input_output_ident: ident
        }
    ) => {
        define_func_header!($func_none_ident: fn() -> FuncResult<()>);
        define_func_header!($func_input_ident: fn($input) -> FuncResult<()>);
        define_func_header!($func_output_ident: fn() -> FuncResult<$output>);
        define_func_header!($func_input_output_ident: fn($input) -> FuncResult<$output>);

        impl $func_none_ident {
            pub unsafe fn call(&self) -> Result<()> {
                let func = self.func.get();
                func().map_err(|err| Error::from(err))
            }
        }

        impl $func_input_ident {
            pub unsafe fn call(&self, input: $input) -> Result<()> {
                let func = self.func.get();
                func(input).map_err(|err| Error::from(err))
            }
        }

        impl $func_output_ident {
            pub unsafe fn call(&self) -> Result<$output> {
                let func = self.func.get();
                func().map_err(|err| Error::from(err))
            }
        }

        impl $func_input_output_ident {
            pub unsafe fn call(&self, input: $input) -> Result<$output> {
                let func = self.func.get();
                func(input).map_err(|err| Error::from(err))
            }
        }
    }
}
