#![recursion_limit="200"]

// Begin serde

#![cfg_attr(feature = "serde_macros", feature(plugin, custom_derive))]

#![cfg_attr(feature = "serde_macros", plugin(serde_macros))]

extern crate serde;

extern crate serde_json;

#[cfg(feature = "serde_macros")]
include!("serde_types.in.rs");

#[cfg(feature = "serde_codegen")]
include!(concat!(env!("OUT_DIR"), "/serde_types.rs"));

// End serde

#[macro_use]
extern crate lazy_static;

extern crate libflo;

extern crate libflo_dynamic_event;

extern crate libflo_error;

extern crate libflo_func;

extern crate libflo_module;

extern crate mut_static;

#[macro_use]
extern crate error_chain;


mod error;

mod func;

mod static_libflo;

mod string;

pub use error::*;

pub use func::*;
