use libflo_error::{ Result as FuncResult, WrapErr };
use serde_json;
use static_libflo::STATIC_LIBFLO;

#[no_mangle]
pub extern fn get_modules_with_submodule(submodule_id: &str) -> FuncResult<String> {
    let libflo = STATIC_LIBFLO.get().wrap_err_to_err()?;
    let module_list = libflo.get_module_mapper().get_raw_map();
    let path_resolver = libflo.get_path_resolver();

    let submodule_id: usize = submodule_id.parse().wrap_err_to_err()?;

    let mut result = Vec::new();
    for (_, module_id) in module_list {
        if path_resolver.has_submodule(*module_id, submodule_id).wrap_err_to_err()? {
            result.push(*module_id);
        }
    }

    let result = serde_json::to_string(&result).wrap_err_to_err()?;
    Ok(result)
}
