use libflo_error::{ Result as FuncResult, WrapErr };
use serialization::LibfloSerde;
use static_libflo::STATIC_LIBFLO;
use string;

#[no_mangle]
pub extern fn get() -> FuncResult<()> {
    let libflo = STATIC_LIBFLO.get().wrap_err_to_err()?;

    let dynamic_event_mapper = libflo.get_dynamic_event_mapper();
    let func_mapper = libflo.get_func_mapper();
    let module_mapper = libflo.get_module_mapper();

    let dynamic_event_mapper = dynamic_event_mapper.make_serde();
    let func_mapper = func_mapper.make_serde();
    let module_mapper = module_mapper.make_serde();

    let libflo_serde = LibfloSerde::new(dynamic_event_mapper, func_mapper, module_mapper);

    libflo.send_event_by_module_name(
        string::self_module_name(),
        string::get(),
        &libflo_serde
    ).wrap_err_to_err()
}
