use error::*;
use libflo::Libflo;
use libflo_error::{ Result as FuncResult, WrapErr, WrapError };
use static_libflo::STATIC_LIBFLO;
use std::any::Any;
use std::sync::Arc;

#[no_mangle]
pub extern fn construct(libflo: &Any) -> FuncResult<()> {
    let libflo: Option<&Arc<Libflo>> = libflo.downcast_ref();

    if let Some(libflo) = libflo {
        let libflo = libflo.clone();
        STATIC_LIBFLO.set(libflo).wrap_err_to_err()?;
    } else {
        let err: Error = ErrorKind::ConstructEventNotPassedLibflo.into();
        return err.wrap_error_to_err();
    }

    Ok(())
}
